searchData={"items":[{"type":"module","title":"gl","doc":"Erlang wrapper functions for OpenGL\n\nStandard OpenGL API\n\nThis documents the functions as a brief version of the complete\n[OpenGL reference pages.](https://www.khronos.org/registry/OpenGL-Refpages/)","ref":"gl.html"},{"type":"function","title":"gl.accum/2","doc":"The accumulation buffer is an extended-range color buffer. Images are not\nrendered into it. Rather, images rendered into one of the color buffers are\nadded to the contents of the accumulation buffer after rendering. Effects such\nas antialiasing (of points, lines, and polygons), motion blur, and depth of\nfield can be created by accumulating images generated with different\ntransformation matrices.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glAccum.xml)","ref":"gl.html#accum/2"},{"type":"function","title":"gl.activeShaderProgram/2","doc":"[`gl:activeShaderProgram/2`](`activeShaderProgram/2`) sets the linked program\nnamed by `Program` to be the active program for the program pipeline object\n`Pipeline`. The active program in the active program pipeline object is the\ntarget of calls to [`gl:uniform()`](`uniform1f/2`) when no program has been made\ncurrent through a call to [`gl:useProgram/1`](`useProgram/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glActiveShaderProgram.xhtml)","ref":"gl.html#activeShaderProgram/2"},{"type":"function","title":"gl.activeTexture/1","doc":"[`gl:activeTexture/1`](`activeTexture/1`) selects which texture unit subsequent\ntexture state calls will affect. The number of texture units an implementation\nsupports is implementation dependent, but must be at least 80.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glActiveTexture.xhtml)","ref":"gl.html#activeTexture/1"},{"type":"function","title":"gl.alphaFunc/2","doc":"The alpha test discards fragments depending on the outcome of a comparison\nbetween an incoming fragment's alpha value and a constant reference value.\n[`gl:alphaFunc/2`](`alphaFunc/2`) specifies the reference value and the\ncomparison function. The comparison is performed only if alpha testing is\nenabled. By default, it is not enabled. (See [`gl:enable/1`](`enable/1`) and\n[`gl:disable/1`](`enable/1`) of `?GL_ALPHA_TEST`.)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glAlphaFunc.xml)","ref":"gl.html#alphaFunc/2"},{"type":"function","title":"gl.areTexturesResident/1","doc":"GL establishes a \\`\\`working set'' of textures that are resident in texture\nmemory. These textures can be bound to a texture target much more efficiently\nthan textures that are not resident.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glAreTexturesResident.xml)","ref":"gl.html#areTexturesResident/1"},{"type":"function","title":"gl.arrayElement/1","doc":"[`gl:arrayElement/1`](`arrayElement/1`) commands are used within\n[`gl:'begin'/1`](`'begin'/1`)/[`gl:'end'/0`](`'begin'/1`) pairs to specify\nvertex and attribute data for point, line, and polygon primitives. If\n`?GL_VERTEX_ARRAY` is enabled when [`gl:arrayElement/1`](`arrayElement/1`) is\ncalled, a single vertex is drawn, using vertex and attribute data taken from\nlocation `I` of the enabled arrays. If `?GL_VERTEX_ARRAY` is not enabled, no\ndrawing occurs but the attributes corresponding to the enabled arrays are\nmodified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glArrayElement.xml)","ref":"gl.html#arrayElement/1"},{"type":"function","title":"gl.attachShader/2","doc":"In order to create a complete shader program, there must be a way to specify the\nlist of things that will be linked together. Program objects provide this\nmechanism. Shaders that are to be linked together in a program object must first\nbe attached to that program object. [`gl:attachShader/2`](`attachShader/2`)\nattaches the shader object specified by `Shader` to the program object specified\nby `Program`. This indicates that `Shader` will be included in link operations\nthat will be performed on `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glAttachShader.xhtml)","ref":"gl.html#attachShader/2"},{"type":"function","title":"gl.begin/1","doc":"","ref":"gl.html#begin/1"},{"type":"function","title":"gl.beginConditionalRender/2","doc":"","ref":"gl.html#beginConditionalRender/2"},{"type":"function","title":"gl.beginQuery/2","doc":"","ref":"gl.html#beginQuery/2"},{"type":"function","title":"gl.beginQueryIndexed/3","doc":"","ref":"gl.html#beginQueryIndexed/3"},{"type":"function","title":"gl.beginTransformFeedback/1","doc":"","ref":"gl.html#beginTransformFeedback/1"},{"type":"function","title":"gl.bindAttribLocation/3","doc":"[`gl:bindAttribLocation/3`](`bindAttribLocation/3`) is used to associate a\nuser-defined attribute variable in the program object specified by `Program`\nwith a generic vertex attribute index. The name of the user-defined attribute\nvariable is passed as a null terminated string in `Name`. The generic vertex\nattribute index to be bound to this variable is specified by `Index`. When\n`Program` is made part of current state, values provided via the generic vertex\nattribute `Index` will modify the value of the user-defined attribute variable\nspecified by `Name`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindAttribLocation.xhtml)","ref":"gl.html#bindAttribLocation/3"},{"type":"function","title":"gl.bindBuffer/2","doc":"[`gl:bindBuffer/2`](`bindBuffer/2`) binds a buffer object to the specified\nbuffer binding point. Calling [`gl:bindBuffer/2`](`bindBuffer/2`) with `Target`\nset to one of the accepted symbolic constants and `Buffer` set to the name of a\nbuffer object binds that buffer object name to the target. If no buffer object\nwith name `Buffer` exists, one is created with that name. When a buffer object\nis bound to a target, the previous binding for that target is automatically\nbroken.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffer.xhtml)","ref":"gl.html#bindBuffer/2"},{"type":"function","title":"gl.bindBufferBase/3","doc":"[`gl:bindBufferBase/3`](`bindBufferBase/3`) binds the buffer object `Buffer` to\nthe binding point at index `Index` of the array of targets specified by\n`Target`. Each `Target` represents an indexed array of buffer binding points, as\nwell as a single general binding point that can be used by other buffer\nmanipulation functions such as [`gl:bindBuffer/2`](`bindBuffer/2`) or\n`glMapBuffer`. In addition to binding `Buffer` to the indexed buffer binding\ntarget, [`gl:bindBufferBase/3`](`bindBufferBase/3`) also binds `Buffer` to the\ngeneric buffer binding point specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBufferBase.xhtml)","ref":"gl.html#bindBufferBase/3"},{"type":"function","title":"gl.bindBufferRange/5","doc":"[`gl:bindBufferRange/5`](`bindBufferRange/5`) binds a range the buffer object\n`Buffer` represented by `Offset` and `Size` to the binding point at index\n`Index` of the array of targets specified by `Target`. Each `Target` represents\nan indexed array of buffer binding points, as well as a single general binding\npoint that can be used by other buffer manipulation functions such as\n[`gl:bindBuffer/2`](`bindBuffer/2`) or `glMapBuffer`. In addition to binding a\nrange of `Buffer` to the indexed buffer binding target,\n[`gl:bindBufferRange/5`](`bindBufferRange/5`) also binds the range to the\ngeneric buffer binding point specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBufferRange.xhtml)","ref":"gl.html#bindBufferRange/5"},{"type":"function","title":"gl.bindBuffersBase/3","doc":"[`gl:bindBuffersBase/3`](`bindBuffersBase/3`) binds a set of `Count` buffer\nobjects whose names are given in the array `Buffers` to the `Count` consecutive\nbinding points starting from index `First` of the array of targets specified by\n`Target`. If `Buffers` is `?NULL` then\n[`gl:bindBuffersBase/3`](`bindBuffersBase/3`) unbinds any buffers that are\ncurrently bound to the referenced binding points. Assuming no errors are\ngenerated, it is equivalent to the following pseudo-code, which calls\n[`gl:bindBufferBase/3`](`bindBufferBase/3`), with the exception that the\nnon-indexed `Target` is not changed by\n[`gl:bindBuffersBase/3`](`bindBuffersBase/3`):\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffersBase.xhtml)","ref":"gl.html#bindBuffersBase/3"},{"type":"function","title":"gl.bindBuffersRange/5","doc":"[`gl:bindBuffersRange/5`](`bindBuffersRange/5`) binds a set of `Count` ranges\nfrom buffer objects whose names are given in the array `Buffers` to the `Count`\nconsecutive binding points starting from index `First` of the array of targets\nspecified by `Target`. `Offsets` specifies the address of an array containing\n`Count` starting offsets within the buffers, and `Sizes` specifies the address\nof an array of `Count` sizes of the ranges. If `Buffers` is `?NULL` then\n`Offsets` and `Sizes` are ignored and\n[`gl:bindBuffersRange/5`](`bindBuffersRange/5`) unbinds any buffers that are\ncurrently bound to the referenced binding points. Assuming no errors are\ngenerated, it is equivalent to the following pseudo-code, which calls\n[`gl:bindBufferRange/5`](`bindBufferRange/5`), with the exception that the\nnon-indexed `Target` is not changed by\n[`gl:bindBuffersRange/5`](`bindBuffersRange/5`):\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindBuffersRange.xhtml)","ref":"gl.html#bindBuffersRange/5"},{"type":"function","title":"gl.bindFragDataLocation/3","doc":"[`gl:bindFragDataLocation/3`](`bindFragDataLocation/3`) explicitly specifies the\nbinding of the user-defined varying out variable `Name` to fragment shader color\nnumber `ColorNumber` for program `Program`. If `Name` was bound previously, its\nassigned binding is replaced with `ColorNumber`. `Name` must be a\nnull-terminated string. `ColorNumber` must be less than `?GL_MAX_DRAW_BUFFERS`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFragDataLocation.xhtml)","ref":"gl.html#bindFragDataLocation/3"},{"type":"function","title":"gl.bindFragDataLocationIndexed/4","doc":"[`gl:bindFragDataLocationIndexed/4`](`bindFragDataLocationIndexed/4`) specifies\nthat the varying out variable `Name` in `Program` should be bound to fragment\ncolor `ColorNumber` when the program is next linked. `Index` may be zero or one\nto specify that the color be used as either the first or second color input to\nthe blend equation, respectively.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFragDataLocationIndexed.xhtml)","ref":"gl.html#bindFragDataLocationIndexed/4"},{"type":"function","title":"gl.bindFramebuffer/2","doc":"[`gl:bindFramebuffer/2`](`bindFramebuffer/2`) binds the framebuffer object with\nname `Framebuffer` to the framebuffer target specified by `Target`. `Target`\nmust be either `?GL_DRAW_FRAMEBUFFER`, `?GL_READ_FRAMEBUFFER` or\n`?GL_FRAMEBUFFER`. If a framebuffer object is bound to `?GL_DRAW_FRAMEBUFFER` or\n`?GL_READ_FRAMEBUFFER`, it becomes the target for rendering or readback\noperations, respectively, until it is deleted or another framebuffer is bound to\nthe corresponding bind point. Calling\n[`gl:bindFramebuffer/2`](`bindFramebuffer/2`) with `Target` set to\n`?GL_FRAMEBUFFER` binds `Framebuffer` to both the read and draw framebuffer\ntargets. `Framebuffer` is the name of a framebuffer object previously returned\nfrom a call to [`gl:genFramebuffers/1`](`genFramebuffers/1`), or zero to break\nthe existing binding of a framebuffer object to `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindFramebuffer.xhtml)","ref":"gl.html#bindFramebuffer/2"},{"type":"function","title":"gl.bindImageTexture/7","doc":"[`gl:bindImageTexture/7`](`bindImageTexture/7`) binds a single level of a\ntexture to an image unit for the purpose of reading and writing it from shaders.\n`Unit` specifies the zero-based index of the image unit to which to bind the\ntexture level. `Texture` specifies the name of an existing texture object to\nbind to the image unit. If `Texture` is zero, then any existing binding to the\nimage unit is broken. `Level` specifies the level of the texture to bind to the\nimage unit.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindImageTexture.xhtml)","ref":"gl.html#bindImageTexture/7"},{"type":"function","title":"gl.bindImageTextures/2","doc":"[`gl:bindImageTextures/2`](`bindImageTextures/2`) binds images from an array of\nexisting texture objects to a specified number of consecutive image units.\n`Count` specifies the number of texture objects whose names are stored in the\narray `Textures`. That number of texture names are read from the array and bound\nto the `Count` consecutive texture units starting from `First`. If the name zero\nappears in the `Textures` array, any existing binding to the image unit is\nreset. Any non-zero entry in `Textures` must be the name of an existing texture\nobject. When a non-zero entry in `Textures` is present, the image at level zero\nis bound, the binding is considered layered, with the first layer set to zero,\nand the image is bound for read-write access. The image unit format parameter is\ntaken from the internal format of the image at level zero of the texture object.\nFor cube map textures, the internal format of the positive X image of level zero\nis used. If `Textures` is `?NULL` then it is as if an appropriately sized array\ncontaining only zeros had been specified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindImageTextures.xhtml)","ref":"gl.html#bindImageTextures/2"},{"type":"function","title":"gl.bindProgramPipeline/1","doc":"[`gl:bindProgramPipeline/1`](`bindProgramPipeline/1`) binds a program pipeline\nobject to the current context. `Pipeline` must be a name previously returned\nfrom a call to [`gl:genProgramPipelines/1`](`genProgramPipelines/1`). If no\nprogram pipeline exists with name `Pipeline` then a new pipeline object is\ncreated with that name and initialized to the default state vector.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindProgramPipeline.xhtml)","ref":"gl.html#bindProgramPipeline/1"},{"type":"function","title":"gl.bindRenderbuffer/2","doc":"[`gl:bindRenderbuffer/2`](`bindRenderbuffer/2`) binds the renderbuffer object\nwith name `Renderbuffer` to the renderbuffer target specified by `Target`.\n`Target` must be `?GL_RENDERBUFFER`. `Renderbuffer` is the name of a\nrenderbuffer object previously returned from a call to\n[`gl:genRenderbuffers/1`](`genRenderbuffers/1`), or zero to break the existing\nbinding of a renderbuffer object to `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindRenderbuffer.xhtml)","ref":"gl.html#bindRenderbuffer/2"},{"type":"function","title":"gl.bindSampler/2","doc":"[`gl:bindSampler/2`](`bindSampler/2`) binds `Sampler` to the texture unit at\nindex `Unit`. `Sampler` must be zero or the name of a sampler object previously\nreturned from a call to [`gl:genSamplers/1`](`genSamplers/1`). `Unit` must be\nless than the value of `?GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindSampler.xhtml)","ref":"gl.html#bindSampler/2"},{"type":"function","title":"gl.bindSamplers/2","doc":"[`gl:bindSamplers/2`](`bindSamplers/2`) binds samplers from an array of existing\nsampler objects to a specified number of consecutive sampler units. `Count`\nspecifies the number of sampler objects whose names are stored in the array\n`Samplers`. That number of sampler names is read from the array and bound to the\n`Count` consecutive sampler units starting from `First`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindSamplers.xhtml)","ref":"gl.html#bindSamplers/2"},{"type":"function","title":"gl.bindTexture/2","doc":"[`gl:bindTexture/2`](`bindTexture/2`) lets you create or use a named texture.\nCalling [`gl:bindTexture/2`](`bindTexture/2`) with `Target` set to\n`?GL_TEXTURE_1D`, `?GL_TEXTURE_2D`, `?GL_TEXTURE_3D`, `?GL_TEXTURE_1D_ARRAY`,\n`?GL_TEXTURE_2D_ARRAY`, `?GL_TEXTURE_RECTANGLE`, `?GL_TEXTURE_CUBE_MAP`,\n`?GL_TEXTURE_CUBE_MAP_ARRAY`, `?GL_TEXTURE_BUFFER`, `?GL_TEXTURE_2D_MULTISAMPLE`\nor `?GL_TEXTURE_2D_MULTISAMPLE_ARRAY` and `Texture` set to the name of the new\ntexture binds the texture name to the target. When a texture is bound to a\ntarget, the previous binding for that target is automatically broken.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTexture.xhtml)","ref":"gl.html#bindTexture/2"},{"type":"function","title":"gl.bindTextures/2","doc":"[`gl:bindTextures/2`](`bindTextures/2`) binds an array of existing texture\nobjects to a specified number of consecutive texture units. `Count` specifies\nthe number of texture objects whose names are stored in the array `Textures`.\nThat number of texture names are read from the array and bound to the `Count`\nconsecutive texture units starting from `First`. The target, or type of texture\nis deduced from the texture object and each texture is bound to the\ncorresponding target of the texture unit. If the name zero appears in the\n`Textures` array, any existing binding to any target of the texture unit is\nreset and the default texture for that target is bound in its place. Any\nnon-zero entry in `Textures` must be the name of an existing texture object. If\n`Textures` is `?NULL` then it is as if an appropriately sized array containing\nonly zeros had been specified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTextures.xhtml)","ref":"gl.html#bindTextures/2"},{"type":"function","title":"gl.bindTextureUnit/2","doc":"[`gl:bindTextureUnit/2`](`bindTextureUnit/2`) binds an existing texture object\nto the texture unit numbered `Unit`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTextureUnit.xhtml)","ref":"gl.html#bindTextureUnit/2"},{"type":"function","title":"gl.bindTransformFeedback/2","doc":"[`gl:bindTransformFeedback/2`](`bindTransformFeedback/2`) binds the transform\nfeedback object with name `Id` to the current GL state. `Id` must be a name\npreviously returned from a call to\n[`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`). If `Id` has not\npreviously been bound, a new transform feedback object with name `Id` and\ninitialized with the default transform state vector is created.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindTransformFeedback.xhtml)","ref":"gl.html#bindTransformFeedback/2"},{"type":"function","title":"gl.bindVertexArray/1","doc":"[`gl:bindVertexArray/1`](`bindVertexArray/1`) binds the vertex array object with\nname `Array`. `Array` is the name of a vertex array object previously returned\nfrom a call to [`gl:genVertexArrays/1`](`genVertexArrays/1`), or zero to break\nthe existing vertex array object binding.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexArray.xhtml)","ref":"gl.html#bindVertexArray/1"},{"type":"function","title":"gl.bindVertexBuffer/4","doc":"","ref":"gl.html#bindVertexBuffer/4"},{"type":"function","title":"gl.bindVertexBuffers/4","doc":"","ref":"gl.html#bindVertexBuffers/4"},{"type":"function","title":"gl.bitmap/7","doc":"A bitmap is a binary image. When drawn, the bitmap is positioned relative to the\ncurrent raster position, and frame buffer pixels corresponding to 1's in the\nbitmap are written using the current raster color or index. Frame buffer pixels\ncorresponding to 0's in the bitmap are not modified.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glBitmap.xml)","ref":"gl.html#bitmap/7"},{"type":"function","title":"gl.blendColor/4","doc":"The `?GL_BLEND_COLOR` may be used to calculate the source and destination\nblending factors. The color components are clamped to the range \\[0 1] before\nbeing stored. See [`gl:blendFunc/2`](`blendFunc/2`) for a complete description\nof the blending operations. Initially the `?GL_BLEND_COLOR` is set to (0, 0, 0,\n0).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendColor.xhtml)","ref":"gl.html#blendColor/4"},{"type":"function","title":"gl.blendEquation/1","doc":"","ref":"gl.html#blendEquation/1"},{"type":"function","title":"gl.blendEquationi/2","doc":"The blend equations determine how a new pixel (the ''source'' color) is combined\nwith a pixel already in the framebuffer (the ''destination'' color). This\nfunction sets both the RGB blend equation and the alpha blend equation to a\nsingle equation. [`gl:blendEquationi/2`](`blendEquation/1`) specifies the blend\nequation for a single draw buffer whereas\n[`gl:blendEquation/1`](`blendEquation/1`) sets the blend equation for all draw\nbuffers.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendEquation.xhtml)","ref":"gl.html#blendEquationi/2"},{"type":"function","title":"gl.blendEquationSeparate/2","doc":"","ref":"gl.html#blendEquationSeparate/2"},{"type":"function","title":"gl.blendEquationSeparatei/3","doc":"The blend equations determines how a new pixel (the ''source'' color) is\ncombined with a pixel already in the framebuffer (the ''destination'' color).\nThese functions specify one blend equation for the RGB-color components and one\nblend equation for the alpha component.\n[`gl:blendEquationSeparatei/3`](`blendEquationSeparate/2`) specifies the blend\nequations for a single draw buffer whereas\n[`gl:blendEquationSeparate/2`](`blendEquationSeparate/2`) sets the blend\nequations for all draw buffers.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendEquationSeparate.xhtml)","ref":"gl.html#blendEquationSeparatei/3"},{"type":"function","title":"gl.blendFunc/2","doc":"","ref":"gl.html#blendFunc/2"},{"type":"function","title":"gl.blendFunci/3","doc":"Pixels can be drawn using a function that blends the incoming (source) RGBA\nvalues with the RGBA values that are already in the frame buffer (the\ndestination values). Blending is initially disabled. Use\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) with argument\n`?GL_BLEND` to enable and disable blending.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendFunc.xhtml)","ref":"gl.html#blendFunci/3"},{"type":"function","title":"gl.blendFuncSeparate/4","doc":"","ref":"gl.html#blendFuncSeparate/4"},{"type":"function","title":"gl.blendFuncSeparatei/5","doc":"Pixels can be drawn using a function that blends the incoming (source) RGBA\nvalues with the RGBA values that are already in the frame buffer (the\ndestination values). Blending is initially disabled. Use\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) with argument\n`?GL_BLEND` to enable and disable blending.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlendFuncSeparate.xhtml)","ref":"gl.html#blendFuncSeparatei/5"},{"type":"function","title":"gl.blitFramebuffer/10","doc":"[`gl:blitFramebuffer/10`](`blitFramebuffer/10`) and `glBlitNamedFramebuffer`\ntransfer a rectangle of pixel values from one region of a read framebuffer to\nanother region of a draw framebuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBlitFramebuffer.xhtml)","ref":"gl.html#blitFramebuffer/10"},{"type":"function","title":"gl.bufferData/4","doc":"[`gl:bufferData/4`](`bufferData/4`) and `glNamedBufferData` create a new data\nstore for a buffer object. In case of [`gl:bufferData/4`](`bufferData/4`), the\nbuffer object currently bound to `Target` is used. For `glNamedBufferData`, a\nbuffer object associated with ID specified by the caller in `Buffer` will be\nused instead.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferData.xhtml)","ref":"gl.html#bufferData/4"},{"type":"function","title":"gl.bufferStorage/4","doc":"[`gl:bufferStorage/4`](`bufferStorage/4`) and `glNamedBufferStorage` create a\nnew immutable data store. For [`gl:bufferStorage/4`](`bufferStorage/4`), the\nbuffer object currently bound to `Target` will be initialized. For\n`glNamedBufferStorage`, `Buffer` is the name of the buffer object that will be\nconfigured. The size of the data store is specified by `Size`. If an initial\ndata is available, its address may be supplied in `Data`. Otherwise, to create\nan uninitialized data store, `Data` should be `?NULL`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferStorage.xhtml)","ref":"gl.html#bufferStorage/4"},{"type":"function","title":"gl.bufferSubData/4","doc":"[`gl:bufferSubData/4`](`bufferSubData/4`) and `glNamedBufferSubData` redefine\nsome or all of the data store for the specified buffer object. Data starting at\nbyte offset `Offset` and extending for `Size` bytes is copied to the data store\nfrom the memory pointed to by `Data`. `Offset` and `Size` must define a range\nlying entirely within the buffer object's data store.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBufferSubData.xhtml)","ref":"gl.html#bufferSubData/4"},{"type":"function","title":"gl.callList/1","doc":"[`gl:callList/1`](`callList/1`) causes the named display list to be executed.\nThe commands saved in the display list are executed in order, just as if they\nwere called without using a display list. If `List` has not been defined as a\ndisplay list, [`gl:callList/1`](`callList/1`) is ignored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCallList.xml)","ref":"gl.html#callList/1"},{"type":"function","title":"gl.callLists/1","doc":"[`gl:callLists/1`](`callLists/1`) causes each display list in the list of names\npassed as `Lists` to be executed. As a result, the commands saved in each\ndisplay list are executed in order, just as if they were called without using a\ndisplay list. Names of display lists that have not been defined are ignored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCallLists.xml)","ref":"gl.html#callLists/1"},{"type":"function","title":"gl.checkFramebufferStatus/1","doc":"[`gl:checkFramebufferStatus/1`](`checkFramebufferStatus/1`) and\n`glCheckNamedFramebufferStatus` return the completeness status of a framebuffer\nobject when treated as a read or draw framebuffer, depending on the value of\n`Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCheckFramebufferStatus.xhtml)","ref":"gl.html#checkFramebufferStatus/1"},{"type":"function","title":"gl.clampColor/2","doc":"[`gl:clampColor/2`](`clampColor/2`) controls color clamping that is performed\nduring [`gl:readPixels/7`](`readPixels/7`). `Target` must be\n`?GL_CLAMP_READ_COLOR`. If `Clamp` is `?GL_TRUE`, read color clamping is\nenabled; if `Clamp` is `?GL_FALSE`, read color clamping is disabled. If `Clamp`\nis `?GL_FIXED_ONLY`, read color clamping is enabled only if the selected read\nbuffer has fixed point components and disabled otherwise.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClampColor.xhtml)","ref":"gl.html#clampColor/2"},{"type":"function","title":"gl.clear/1","doc":"[`gl:clear/1`](`clear/1`) sets the bitplane area of the window to values\npreviously selected by [`gl:clearColor/4`](`clearColor/4`),\n[`gl:clearDepth/1`](`clearDepth/1`), and\n[`gl:clearStencil/1`](`clearStencil/1`). Multiple color buffers can be cleared\nsimultaneously by selecting more than one buffer at a time using\n[`gl:drawBuffer/1`](`drawBuffer/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClear.xhtml)","ref":"gl.html#clear/1"},{"type":"function","title":"gl.clearAccum/4","doc":"[`gl:clearAccum/4`](`clearAccum/4`) specifies the red, green, blue, and alpha\nvalues used by [`gl:clear/1`](`clear/1`) to clear the accumulation buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClearAccum.xml)","ref":"gl.html#clearAccum/4"},{"type":"function","title":"gl.clearBufferData/5","doc":"","ref":"gl.html#clearBufferData/5"},{"type":"function","title":"gl.clearBufferfi/4","doc":"","ref":"gl.html#clearBufferfi/4"},{"type":"function","title":"gl.clearBufferfv/3","doc":"","ref":"gl.html#clearBufferfv/3"},{"type":"function","title":"gl.clearBufferiv/3","doc":"","ref":"gl.html#clearBufferiv/3"},{"type":"function","title":"gl.clearBufferSubData/7","doc":"","ref":"gl.html#clearBufferSubData/7"},{"type":"function","title":"gl.clearBufferuiv/3","doc":"These commands clear a specified buffer of a framebuffer to specified value(s).\nFor [`gl:clearBuffer*()`](`clearBufferiv/3`), the framebuffer is the currently\nbound draw framebuffer object. For `glClearNamedFramebuffer*`, `Framebuffer` is\nzero, indicating the default draw framebuffer, or the name of a framebuffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearBuffer.xhtml)","ref":"gl.html#clearBufferuiv/3"},{"type":"function","title":"gl.clearColor/4","doc":"[`gl:clearColor/4`](`clearColor/4`) specifies the red, green, blue, and alpha\nvalues used by [`gl:clear/1`](`clear/1`) to clear the color buffers. Values\nspecified by [`gl:clearColor/4`](`clearColor/4`) are clamped to the range \\[0\n1].\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearColor.xhtml)","ref":"gl.html#clearColor/4"},{"type":"function","title":"gl.clearDepth/1","doc":"","ref":"gl.html#clearDepth/1"},{"type":"function","title":"gl.clearDepthf/1","doc":"[`gl:clearDepth/1`](`clearDepth/1`) specifies the depth value used by\n[`gl:clear/1`](`clear/1`) to clear the depth buffer. Values specified by\n[`gl:clearDepth/1`](`clearDepth/1`) are clamped to the range \\[0 1].\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearDepth.xhtml)","ref":"gl.html#clearDepthf/1"},{"type":"function","title":"gl.clearIndex/1","doc":"[`gl:clearIndex/1`](`clearIndex/1`) specifies the index used by\n[`gl:clear/1`](`clear/1`) to clear the color index buffers. `C` is not clamped.\nRather, `C` is converted to a fixed-point value with unspecified precision to\nthe right of the binary point. The integer part of this value is then masked\nwith 2 m-1, where m is the number of bits in a color index stored in the frame\nbuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClearIndex.xml)","ref":"gl.html#clearIndex/1"},{"type":"function","title":"gl.clearStencil/1","doc":"[`gl:clearStencil/1`](`clearStencil/1`) specifies the index used by\n[`gl:clear/1`](`clear/1`) to clear the stencil buffer. `S` is masked with 2 m-1,\nwhere m is the number of bits in the stencil buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearStencil.xhtml)","ref":"gl.html#clearStencil/1"},{"type":"function","title":"gl.clearTexImage/5","doc":"[`gl:clearTexImage/5`](`clearTexImage/5`) fills all an image contained in a\ntexture with an application supplied value. `Texture` must be the name of an\nexisting texture. Further, `Texture` may not be the name of a buffer texture,\nnor may its internal format be compressed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearTexImage.xhtml)","ref":"gl.html#clearTexImage/5"},{"type":"function","title":"gl.clearTexSubImage/11","doc":"[`gl:clearTexSubImage/11`](`clearTexSubImage/11`) fills all or part of an image\ncontained in a texture with an application supplied value. `Texture` must be the\nname of an existing texture. Further, `Texture` may not be the name of a buffer\ntexture, nor may its internal format be compressed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClearTexSubImage.xhtml)","ref":"gl.html#clearTexSubImage/11"},{"type":"function","title":"gl.clientActiveTexture/1","doc":"[`gl:clientActiveTexture/1`](`clientActiveTexture/1`) selects the vertex array\nclient state parameters to be modified by\n[`gl:texCoordPointer/4`](`texCoordPointer/4`), and enabled or disabled with\n[`gl:enableClientState/1`](`enableClientState/1`) or\n[`gl:disableClientState/1`](`enableClientState/1`), respectively, when called\nwith a parameter of `?GL_TEXTURE_COORD_ARRAY`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClientActiveTexture.xml)","ref":"gl.html#clientActiveTexture/1"},{"type":"function","title":"gl.clientWaitSync/3","doc":"[`gl:clientWaitSync/3`](`clientWaitSync/3`) causes the client to block and wait\nfor the sync object specified by `Sync` to become signaled. If `Sync` is\nsignaled when [`gl:clientWaitSync/3`](`clientWaitSync/3`) is called,\n[`gl:clientWaitSync/3`](`clientWaitSync/3`) returns immediately, otherwise it\nwill block and wait for up to `Timeout` nanoseconds for `Sync` to become\nsignaled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClientWaitSync.xhtml)","ref":"gl.html#clientWaitSync/3"},{"type":"function","title":"gl.clipControl/2","doc":"[`gl:clipControl/2`](`clipControl/2`) controls the clipping volume behavior and\nthe clip coordinate to window coordinate transformation behavior.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glClipControl.xhtml)","ref":"gl.html#clipControl/2"},{"type":"function","title":"gl.clipPlane/2","doc":"Geometry is always clipped against the boundaries of a six-plane frustum in `x`,\n`y`, and `z`. [`gl:clipPlane/2`](`clipPlane/2`) allows the specification of\nadditional planes, not necessarily perpendicular to the `x`, `y`, or `z` axis,\nagainst which all geometry is clipped. To determine the maximum number of\nadditional clipping planes, call [`gl:getIntegerv/1`](`getBooleanv/1`) with\nargument `?GL_MAX_CLIP_PLANES`. All implementations support at least six such\nclipping planes. Because the resulting clipping region is the intersection of\nthe defined half-spaces, it is always convex.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glClipPlane.xml)","ref":"gl.html#clipPlane/2"},{"type":"function","title":"gl.color3b/3","doc":"","ref":"gl.html#color3b/3"},{"type":"function","title":"gl.color3bv/1","doc":"","ref":"gl.html#color3bv/1"},{"type":"function","title":"gl.color3d/3","doc":"","ref":"gl.html#color3d/3"},{"type":"function","title":"gl.color3dv/1","doc":"","ref":"gl.html#color3dv/1"},{"type":"function","title":"gl.color3f/3","doc":"","ref":"gl.html#color3f/3"},{"type":"function","title":"gl.color3fv/1","doc":"","ref":"gl.html#color3fv/1"},{"type":"function","title":"gl.color3i/3","doc":"","ref":"gl.html#color3i/3"},{"type":"function","title":"gl.color3iv/1","doc":"","ref":"gl.html#color3iv/1"},{"type":"function","title":"gl.color3s/3","doc":"","ref":"gl.html#color3s/3"},{"type":"function","title":"gl.color3sv/1","doc":"","ref":"gl.html#color3sv/1"},{"type":"function","title":"gl.color3ub/3","doc":"","ref":"gl.html#color3ub/3"},{"type":"function","title":"gl.color3ubv/1","doc":"","ref":"gl.html#color3ubv/1"},{"type":"function","title":"gl.color3ui/3","doc":"","ref":"gl.html#color3ui/3"},{"type":"function","title":"gl.color3uiv/1","doc":"","ref":"gl.html#color3uiv/1"},{"type":"function","title":"gl.color3us/3","doc":"","ref":"gl.html#color3us/3"},{"type":"function","title":"gl.color3usv/1","doc":"","ref":"gl.html#color3usv/1"},{"type":"function","title":"gl.color4b/4","doc":"","ref":"gl.html#color4b/4"},{"type":"function","title":"gl.color4bv/1","doc":"","ref":"gl.html#color4bv/1"},{"type":"function","title":"gl.color4d/4","doc":"","ref":"gl.html#color4d/4"},{"type":"function","title":"gl.color4dv/1","doc":"","ref":"gl.html#color4dv/1"},{"type":"function","title":"gl.color4f/4","doc":"","ref":"gl.html#color4f/4"},{"type":"function","title":"gl.color4fv/1","doc":"","ref":"gl.html#color4fv/1"},{"type":"function","title":"gl.color4i/4","doc":"","ref":"gl.html#color4i/4"},{"type":"function","title":"gl.color4iv/1","doc":"","ref":"gl.html#color4iv/1"},{"type":"function","title":"gl.color4s/4","doc":"","ref":"gl.html#color4s/4"},{"type":"function","title":"gl.color4sv/1","doc":"","ref":"gl.html#color4sv/1"},{"type":"function","title":"gl.color4ub/4","doc":"","ref":"gl.html#color4ub/4"},{"type":"function","title":"gl.color4ubv/1","doc":"","ref":"gl.html#color4ubv/1"},{"type":"function","title":"gl.color4ui/4","doc":"","ref":"gl.html#color4ui/4"},{"type":"function","title":"gl.color4uiv/1","doc":"","ref":"gl.html#color4uiv/1"},{"type":"function","title":"gl.color4us/4","doc":"","ref":"gl.html#color4us/4"},{"type":"function","title":"gl.color4usv/1","doc":"The GL stores both a current single-valued color index and a current four-valued\nRGBA color. [`gl:color()`](`color3b/3`) sets a new four-valued RGBA color.\n[`gl:color()`](`color3b/3`) has two major variants: [`gl:color3()`](`color3b/3`)\nand [`gl:color4()`](`color3b/3`). [`gl:color3()`](`color3b/3`) variants specify\nnew red, green, and blue values explicitly and set the current alpha value to\n1.0 (full intensity) implicitly. [`gl:color4()`](`color3b/3`) variants specify\nall four color components explicitly.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColor.xml)","ref":"gl.html#color4usv/1"},{"type":"function","title":"gl.colorMask/4","doc":"","ref":"gl.html#colorMask/4"},{"type":"function","title":"gl.colorMaski/5","doc":"[`gl:colorMask/4`](`colorMask/4`) and [`gl:colorMaski/5`](`colorMask/4`) specify\nwhether the individual color components in the frame buffer can or cannot be\nwritten. [`gl:colorMaski/5`](`colorMask/4`) sets the mask for a specific draw\nbuffer, whereas [`gl:colorMask/4`](`colorMask/4`) sets the mask for all draw\nbuffers. If `Red` is `?GL_FALSE`, for example, no change is made to the red\ncomponent of any pixel in any of the color buffers, regardless of the drawing\noperation attempted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glColorMask.xhtml)","ref":"gl.html#colorMaski/5"},{"type":"function","title":"gl.colorMaterial/2","doc":"[`gl:colorMaterial/2`](`colorMaterial/2`) specifies which material parameters\ntrack the current color. When `?GL_COLOR_MATERIAL` is enabled, the material\nparameter or parameters specified by `Mode`, of the material or materials\nspecified by `Face`, track the current color at all times.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorMaterial.xml)","ref":"gl.html#colorMaterial/2"},{"type":"function","title":"gl.colorPointer/4","doc":"[`gl:colorPointer/4`](`colorPointer/4`) specifies the location and data format\nof an array of color components to use when rendering. `Size` specifies the\nnumber of components per color, and must be 3 or 4. `Type` specifies the data\ntype of each color component, and `Stride` specifies the byte stride from one\ncolor to the next, allowing vertices and attributes to be packed into a single\narray or stored in separate arrays. (Single-array storage may be more efficient\non some implementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorPointer.xml)","ref":"gl.html#colorPointer/4"},{"type":"function","title":"gl.colorSubTable/6","doc":"[`gl:colorSubTable/6`](`colorSubTable/6`) is used to respecify a contiguous\nportion of a color table previously defined using\n[`gl:colorTable/6`](`colorTable/6`). The pixels referenced by `Data` replace the\nportion of the existing table from indices `Start` to start+count-1, inclusive.\nThis region may not include any entries outside the range of the color table as\nit was originally specified. It is not an error to specify a subtexture with\nwidth of 0, but such a specification has no effect.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorSubTable.xml)","ref":"gl.html#colorSubTable/6"},{"type":"function","title":"gl.colorTable/6","doc":"[`gl:colorTable/6`](`colorTable/6`) may be used in two ways: to test the actual\nsize and color resolution of a lookup table given a particular set of\nparameters, or to load the contents of a color lookup table. Use the targets\n`?GL_PROXY_*` for the first case and the other targets for the second case.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorTable.xml)","ref":"gl.html#colorTable/6"},{"type":"function","title":"gl.colorTableParameterfv/3","doc":"","ref":"gl.html#colorTableParameterfv/3"},{"type":"function","title":"gl.colorTableParameteriv/3","doc":"[`gl:colorTableParameter()`](`colorTableParameterfv/3`) is used to specify the\nscale factors and bias terms applied to color components when they are loaded\ninto a color table. `Target` indicates which color table the scale and bias\nterms apply to; it must be set to `?GL_COLOR_TABLE`,\n`?GL_POST_CONVOLUTION_COLOR_TABLE`, or `?GL_POST_COLOR_MATRIX_COLOR_TABLE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glColorTableParameter.xml)","ref":"gl.html#colorTableParameteriv/3"},{"type":"function","title":"gl.compileShader/1","doc":"[`gl:compileShader/1`](`compileShader/1`) compiles the source code strings that\nhave been stored in the shader object specified by `Shader`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompileShader.xhtml)","ref":"gl.html#compileShader/1"},{"type":"function","title":"gl.compressedTexImage1D/7","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexImage1D.xhtml)","ref":"gl.html#compressedTexImage1D/7"},{"type":"function","title":"gl.compressedTexImage2D/8","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexImage2D.xhtml)","ref":"gl.html#compressedTexImage2D/8"},{"type":"function","title":"gl.compressedTexImage3D/9","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexImage3D.xhtml)","ref":"gl.html#compressedTexImage3D/9"},{"type":"function","title":"gl.compressedTexSubImage1D/7","doc":"","ref":"gl.html#compressedTexSubImage1D/7"},{"type":"function","title":"gl.compressedTexSubImage2D/9","doc":"","ref":"gl.html#compressedTexSubImage2D/9"},{"type":"function","title":"gl.compressedTexSubImage3D/11","doc":"","ref":"gl.html#compressedTexSubImage3D/11"},{"type":"function","title":"gl.compressedTextureSubImage1D/7","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexSubImage1D.xhtml)","ref":"gl.html#compressedTextureSubImage1D/7"},{"type":"function","title":"gl.compressedTextureSubImage2D/9","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexSubImage2D.xhtml)","ref":"gl.html#compressedTextureSubImage2D/9"},{"type":"function","title":"gl.compressedTextureSubImage3D/11","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCompressedTexSubImage3D.xhtml)","ref":"gl.html#compressedTextureSubImage3D/11"},{"type":"function","title":"gl.convolutionFilter1D/6","doc":"[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`) builds a one-dimensional\nconvolution filter kernel from an array of pixels.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glConvolutionFilter1D.xml)","ref":"gl.html#convolutionFilter1D/6"},{"type":"function","title":"gl.convolutionFilter2D/7","doc":"[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`) builds a two-dimensional\nconvolution filter kernel from an array of pixels.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glConvolutionFilter2D.xml)","ref":"gl.html#convolutionFilter2D/7"},{"type":"function","title":"gl.convolutionParameterf/3","doc":"","ref":"gl.html#convolutionParameterf/3"},{"type":"function","title":"gl.convolutionParameterfv/3","doc":"","ref":"gl.html#convolutionParameterfv/3"},{"type":"function","title":"gl.convolutionParameteri/3","doc":"","ref":"gl.html#convolutionParameteri/3"},{"type":"function","title":"gl.convolutionParameteriv/3","doc":"[`gl:convolutionParameter()`](`convolutionParameterf/3`) sets the value of a\nconvolution parameter.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glConvolutionParameter.xml)","ref":"gl.html#convolutionParameteriv/3"},{"type":"function","title":"gl.copyBufferSubData/5","doc":"[`gl:copyBufferSubData/5`](`copyBufferSubData/5`) and `glCopyNamedBufferSubData`\ncopy part of the data store attached to a source buffer object to the data store\nattached to a destination buffer object. The number of basic machine units\nindicated by `Size` is copied from the source at offset `ReadOffset` to the\ndestination at `WriteOffset`. `ReadOffset`, `WriteOffset` and `Size` are in\nterms of basic machine units.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyBufferSubData.xhtml)","ref":"gl.html#copyBufferSubData/5"},{"type":"function","title":"gl.copyColorSubTable/5","doc":"[`gl:copyColorSubTable/5`](`copyColorSubTable/5`) is used to respecify a\ncontiguous portion of a color table previously defined using\n[`gl:colorTable/6`](`colorTable/6`). The pixels copied from the framebuffer\nreplace the portion of the existing table from indices `Start` to start+x-1,\ninclusive. This region may not include any entries outside the range of the\ncolor table, as was originally specified. It is not an error to specify a\nsubtexture with width of 0, but such a specification has no effect.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyColorSubTable.xml)","ref":"gl.html#copyColorSubTable/5"},{"type":"function","title":"gl.copyColorTable/5","doc":"[`gl:copyColorTable/5`](`copyColorTable/5`) loads a color table with pixels from\nthe current `?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:colorTable/6`](`colorTable/6`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyColorTable.xml)","ref":"gl.html#copyColorTable/5"},{"type":"function","title":"gl.copyConvolutionFilter1D/5","doc":"[`gl:copyConvolutionFilter1D/5`](`copyConvolutionFilter1D/5`) defines a\none-dimensional convolution filter kernel with pixels from the current\n`?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyConvolutionFilter1D.xml)","ref":"gl.html#copyConvolutionFilter1D/5"},{"type":"function","title":"gl.copyConvolutionFilter2D/6","doc":"[`gl:copyConvolutionFilter2D/6`](`copyConvolutionFilter2D/6`) defines a\ntwo-dimensional convolution filter kernel with pixels from the current\n`?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyConvolutionFilter2D.xml)","ref":"gl.html#copyConvolutionFilter2D/6"},{"type":"function","title":"gl.copyImageSubData/15","doc":"[`gl:copyImageSubData/15`](`copyImageSubData/15`) may be used to copy data from\none image (i.e. texture or renderbuffer) to another.\n[`gl:copyImageSubData/15`](`copyImageSubData/15`) does not perform\ngeneral-purpose conversions such as scaling, resizing, blending, color-space, or\nformat conversions. It should be considered to operate in a manner similar to a\nCPU memcpy. CopyImageSubData can copy between images with different internal\nformats, provided the formats are compatible.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyImageSubData.xhtml)","ref":"gl.html#copyImageSubData/15"},{"type":"function","title":"gl.copyPixels/5","doc":"[`gl:copyPixels/5`](`copyPixels/5`) copies a screen-aligned rectangle of pixels\nfrom the specified frame buffer location to a region relative to the current\nraster position. Its operation is well defined only if the entire pixel source\nregion is within the exposed portion of the window. Results of copies from\noutside the window, or from regions of the window that are not exposed, are\nhardware dependent and undefined.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glCopyPixels.xml)","ref":"gl.html#copyPixels/5"},{"type":"function","title":"gl.copyTexImage1D/7","doc":"[`gl:copyTexImage1D/7`](`copyTexImage1D/7`) defines a one-dimensional texture\nimage with pixels from the current `?GL_READ_BUFFER`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexImage1D.xhtml)","ref":"gl.html#copyTexImage1D/7"},{"type":"function","title":"gl.copyTexImage2D/8","doc":"[`gl:copyTexImage2D/8`](`copyTexImage2D/8`) defines a two-dimensional texture\nimage, or cube-map texture image with pixels from the current `?GL_READ_BUFFER`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexImage2D.xhtml)","ref":"gl.html#copyTexImage2D/8"},{"type":"function","title":"gl.copyTexSubImage1D/6","doc":"[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`) and `glCopyTextureSubImage1D`\nreplace a portion of a one-dimensional texture image with pixels from the\ncurrent `?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:texSubImage1D/7`](`texSubImage1D/7`)). For\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`), the texture object that is\nbound to `Target` will be used for the process. For `glCopyTextureSubImage1D`,\n`Texture` tells which texture object should be used for the purpose of the call.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexSubImage1D.xhtml)","ref":"gl.html#copyTexSubImage1D/6"},{"type":"function","title":"gl.copyTexSubImage2D/8","doc":"[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`) and `glCopyTextureSubImage2D`\nreplace a rectangular portion of a two-dimensional texture image, cube-map\ntexture image, rectangular image, or a linear portion of a number of slices of a\none-dimensional array texture with pixels from the current `?GL_READ_BUFFER`\n(rather than from main memory, as is the case for\n[`gl:texSubImage2D/9`](`texSubImage2D/9`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexSubImage2D.xhtml)","ref":"gl.html#copyTexSubImage2D/8"},{"type":"function","title":"gl.copyTexSubImage3D/9","doc":"[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`) and `glCopyTextureSubImage3D`\nfunctions replace a rectangular portion of a three-dimensional or\ntwo-dimensional array texture image with pixels from the current\n`?GL_READ_BUFFER` (rather than from main memory, as is the case for\n[`gl:texSubImage3D/11`](`texSubImage3D/11`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCopyTexSubImage3D.xhtml)","ref":"gl.html#copyTexSubImage3D/9"},{"type":"function","title":"gl.createBuffers/1","doc":"[`gl:createBuffers/1`](`createBuffers/1`) returns `N` previously unused buffer\nnames in `Buffers`, each representing a new buffer object initialized as if it\nhad been bound to an unspecified target.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateBuffers.xhtml)","ref":"gl.html#createBuffers/1"},{"type":"function","title":"gl.createFramebuffers/1","doc":"[`gl:createFramebuffers/1`](`createFramebuffers/1`) returns `N` previously\nunused framebuffer names in `Framebuffers`, each representing a new framebuffer\nobject initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateFramebuffers.xhtml)","ref":"gl.html#createFramebuffers/1"},{"type":"function","title":"gl.createProgram/0","doc":"[`gl:createProgram/0`](`createProgram/0`) creates an empty program object and\nreturns a non-zero value by which it can be referenced. A program object is an\nobject to which shader objects can be attached. This provides a mechanism to\nspecify the shader objects that will be linked to create a program. It also\nprovides a means for checking the compatibility of the shaders that will be used\nto create a program (for instance, checking the compatibility between a vertex\nshader and a fragment shader). When no longer needed as part of a program\nobject, shader objects can be detached.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateProgram.xhtml)","ref":"gl.html#createProgram/0"},{"type":"function","title":"gl.createProgramPipelines/1","doc":"[`gl:createProgramPipelines/1`](`createProgramPipelines/1`) returns `N`\npreviously unused program pipeline names in `Pipelines`, each representing a new\nprogram pipeline object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateProgramPipelines.xhtml)","ref":"gl.html#createProgramPipelines/1"},{"type":"function","title":"gl.createQueries/2","doc":"[`gl:createQueries/2`](`createQueries/2`) returns `N` previously unused query\nobject names in `Ids`, each representing a new query object with the specified\n`Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateQueries.xhtml)","ref":"gl.html#createQueries/2"},{"type":"function","title":"gl.createRenderbuffers/1","doc":"[`gl:createRenderbuffers/1`](`createRenderbuffers/1`) returns `N` previously\nunused renderbuffer object names in `Renderbuffers`, each representing a new\nrenderbuffer object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateRenderbuffers.xhtml)","ref":"gl.html#createRenderbuffers/1"},{"type":"function","title":"gl.createSamplers/1","doc":"[`gl:createSamplers/1`](`createSamplers/1`) returns `N` previously unused\nsampler names in `Samplers`, each representing a new sampler object initialized\nto the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateSamplers.xhtml)","ref":"gl.html#createSamplers/1"},{"type":"function","title":"gl.createShader/1","doc":"[`gl:createShader/1`](`createShader/1`) creates an empty shader object and\nreturns a non-zero value by which it can be referenced. A shader object is used\nto maintain the source code strings that define a shader. `ShaderType` indicates\nthe type of shader to be created. Five types of shader are supported. A shader\nof type `?GL_COMPUTE_SHADER` is a shader that is intended to run on the\nprogrammable compute processor. A shader of type `?GL_VERTEX_SHADER` is a shader\nthat is intended to run on the programmable vertex processor. A shader of type\n`?GL_TESS_CONTROL_SHADER` is a shader that is intended to run on the\nprogrammable tessellation processor in the control stage. A shader of type\n`?GL_TESS_EVALUATION_SHADER` is a shader that is intended to run on the\nprogrammable tessellation processor in the evaluation stage. A shader of type\n`?GL_GEOMETRY_SHADER` is a shader that is intended to run on the programmable\ngeometry processor. A shader of type `?GL_FRAGMENT_SHADER` is a shader that is\nintended to run on the programmable fragment processor.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateShader.xhtml)","ref":"gl.html#createShader/1"},{"type":"function","title":"gl.createShaderProgramv/2","doc":"[`gl:createShaderProgram()`](`createShaderProgramv/2`) creates a program object\ncontaining compiled and linked shaders for a single stage specified by `Type`.\n`Strings` refers to an array of `Count` strings from which to create the shader\nexecutables.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateShaderProgram.xhtml)","ref":"gl.html#createShaderProgramv/2"},{"type":"function","title":"gl.createTextures/2","doc":"[`gl:createTextures/2`](`createTextures/2`) returns `N` previously unused\ntexture names in `Textures`, each representing a new texture object of the\ndimensionality and type specified by `Target` and initialized to the default\nvalues for that texture type.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateTextures.xhtml)","ref":"gl.html#createTextures/2"},{"type":"function","title":"gl.createTransformFeedbacks/1","doc":"[`gl:createTransformFeedbacks/1`](`createTransformFeedbacks/1`) returns `N`\npreviously unused transform feedback object names in `Ids`, each representing a\nnew transform feedback object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateTransformFeedbacks.xhtml)","ref":"gl.html#createTransformFeedbacks/1"},{"type":"function","title":"gl.createVertexArrays/1","doc":"[`gl:createVertexArrays/1`](`createVertexArrays/1`) returns `N` previously\nunused vertex array object names in `Arrays`, each representing a new vertex\narray object initialized to the default state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCreateVertexArrays.xhtml)","ref":"gl.html#createVertexArrays/1"},{"type":"function","title":"gl.cullFace/1","doc":"[`gl:cullFace/1`](`cullFace/1`) specifies whether front- or back-facing facets\nare culled (as specified by `mode`) when facet culling is enabled. Facet culling\nis initially disabled. To enable and disable facet culling, call the\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) commands with the\nargument `?GL_CULL_FACE`. Facets include triangles, quadrilaterals, polygons,\nand rectangles.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glCullFace.xhtml)","ref":"gl.html#cullFace/1"},{"type":"function","title":"gl.debugMessageControl/5","doc":"[`gl:debugMessageControl/5`](`debugMessageControl/5`) controls the reporting of\ndebug messages generated by a debug context. The parameters `Source`, `Type` and\n`Severity` form a filter to select messages from the pool of potential messages\ngenerated by the GL.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDebugMessageControl.xhtml)","ref":"gl.html#debugMessageControl/5"},{"type":"function","title":"gl.debugMessageInsert/5","doc":"[`gl:debugMessageInsert/5`](`debugMessageInsert/5`) inserts a user-supplied\nmessage into the debug output queue. `Source` specifies the source that will be\nused to classify the message and must be `?GL_DEBUG_SOURCE_APPLICATION` or\n`?GL_DEBUG_SOURCE_THIRD_PARTY`. All other sources are reserved for use by the GL\nimplementation. `Type` indicates the type of the message to be inserted and may\nbe one of `?GL_DEBUG_TYPE_ERROR`, `?GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR`,\n`?GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR`, `?GL_DEBUG_TYPE_PORTABILITY`,\n`?GL_DEBUG_TYPE_PERFORMANCE`, `?GL_DEBUG_TYPE_MARKER`,\n`?GL_DEBUG_TYPE_PUSH_GROUP`, `?GL_DEBUG_TYPE_POP_GROUP`, or\n`?GL_DEBUG_TYPE_OTHER`. `Severity` indicates the severity of the message and may\nbe `?GL_DEBUG_SEVERITY_LOW`, `?GL_DEBUG_SEVERITY_MEDIUM`,\n`?GL_DEBUG_SEVERITY_HIGH` or `?GL_DEBUG_SEVERITY_NOTIFICATION`. `Id` is\navailable for application defined use and may be any value. This value will be\nrecorded and used to identify the message.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDebugMessageInsert.xhtml)","ref":"gl.html#debugMessageInsert/5"},{"type":"function","title":"gl.deleteBuffers/1","doc":"[`gl:deleteBuffers/1`](`deleteBuffers/1`) deletes `N` buffer objects named by\nthe elements of the array `Buffers`. After a buffer object is deleted, it has no\ncontents, and its name is free for reuse (for example by\n[`gl:genBuffers/1`](`genBuffers/1`)). If a buffer object that is currently bound\nis deleted, the binding reverts to 0 (the absence of any buffer object).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteBuffers.xhtml)","ref":"gl.html#deleteBuffers/1"},{"type":"function","title":"gl.deleteFramebuffers/1","doc":"[`gl:deleteFramebuffers/1`](`deleteFramebuffers/1`) deletes the `N` framebuffer\nobjects whose names are stored in the array addressed by `Framebuffers`. The\nname zero is reserved by the GL and is silently ignored, should it occur in\n`Framebuffers`, as are other unused names. Once a framebuffer object is deleted,\nits name is again unused and it has no attachments. If a framebuffer that is\ncurrently bound to one or more of the targets `?GL_DRAW_FRAMEBUFFER` or\n`?GL_READ_FRAMEBUFFER` is deleted, it is as though\n[`gl:bindFramebuffer/2`](`bindFramebuffer/2`) had been executed with the\ncorresponding `Target` and `Framebuffer` zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteFramebuffers.xhtml)","ref":"gl.html#deleteFramebuffers/1"},{"type":"function","title":"gl.deleteLists/2","doc":"[`gl:deleteLists/2`](`deleteLists/2`) causes a contiguous group of display lists\nto be deleted. `List` is the name of the first display list to be deleted, and\n`Range` is the number of display lists to delete. All display lists d with\nlist&lt;= d&lt;= list+range-1 are deleted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glDeleteLists.xml)","ref":"gl.html#deleteLists/2"},{"type":"function","title":"gl.deleteProgram/1","doc":"[`gl:deleteProgram/1`](`deleteProgram/1`) frees the memory and invalidates the\nname associated with the program object specified by `Program.` This command\neffectively undoes the effects of a call to\n[`gl:createProgram/0`](`createProgram/0`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteProgram.xhtml)","ref":"gl.html#deleteProgram/1"},{"type":"function","title":"gl.deleteProgramPipelines/1","doc":"[`gl:deleteProgramPipelines/1`](`deleteProgramPipelines/1`) deletes the `N`\nprogram pipeline objects whose names are stored in the array `Pipelines`. Unused\nnames in `Pipelines` are ignored, as is the name zero. After a program pipeline\nobject is deleted, its name is again unused and it has no contents. If program\npipeline object that is currently bound is deleted, the binding for that object\nreverts to zero and no program pipeline object becomes current.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteProgramPipelines.xhtml)","ref":"gl.html#deleteProgramPipelines/1"},{"type":"function","title":"gl.deleteQueries/1","doc":"[`gl:deleteQueries/1`](`deleteQueries/1`) deletes `N` query objects named by the\nelements of the array `Ids`. After a query object is deleted, it has no\ncontents, and its name is free for reuse (for example by\n[`gl:genQueries/1`](`genQueries/1`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteQueries.xhtml)","ref":"gl.html#deleteQueries/1"},{"type":"function","title":"gl.deleteRenderbuffers/1","doc":"[`gl:deleteRenderbuffers/1`](`deleteRenderbuffers/1`) deletes the `N`\nrenderbuffer objects whose names are stored in the array addressed by\n`Renderbuffers`. The name zero is reserved by the GL and is silently ignored,\nshould it occur in `Renderbuffers`, as are other unused names. Once a\nrenderbuffer object is deleted, its name is again unused and it has no contents.\nIf a renderbuffer that is currently bound to the target `?GL_RENDERBUFFER` is\ndeleted, it is as though [`gl:bindRenderbuffer/2`](`bindRenderbuffer/2`) had\nbeen executed with a `Target` of `?GL_RENDERBUFFER` and a `Name` of zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteRenderbuffers.xhtml)","ref":"gl.html#deleteRenderbuffers/1"},{"type":"function","title":"gl.deleteSamplers/1","doc":"[`gl:deleteSamplers/1`](`deleteSamplers/1`) deletes `N` sampler objects named by\nthe elements of the array `Samplers`. After a sampler object is deleted, its\nname is again unused. If a sampler object that is currently bound to a sampler\nunit is deleted, it is as though [`gl:bindSampler/2`](`bindSampler/2`) is called\nwith unit set to the unit the sampler is bound to and sampler zero. Unused names\nin samplers are silently ignored, as is the reserved name zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteSamplers.xhtml)","ref":"gl.html#deleteSamplers/1"},{"type":"function","title":"gl.deleteShader/1","doc":"[`gl:deleteShader/1`](`deleteShader/1`) frees the memory and invalidates the\nname associated with the shader object specified by `Shader`. This command\neffectively undoes the effects of a call to\n[`gl:createShader/1`](`createShader/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteShader.xhtml)","ref":"gl.html#deleteShader/1"},{"type":"function","title":"gl.deleteSync/1","doc":"[`gl:deleteSync/1`](`deleteSync/1`) deletes the sync object specified by `Sync`.\nIf the fence command corresponding to the specified sync object has completed,\nor if no [`gl:waitSync/3`](`waitSync/3`) or\n[`gl:clientWaitSync/3`](`clientWaitSync/3`) commands are blocking on `Sync`, the\nobject is deleted immediately. Otherwise, `Sync` is flagged for deletion and\nwill be deleted when it is no longer associated with any fence command and is no\nlonger blocking any [`gl:waitSync/3`](`waitSync/3`) or\n[`gl:clientWaitSync/3`](`clientWaitSync/3`) command. In either case, after\n[`gl:deleteSync/1`](`deleteSync/1`) returns, the name `Sync` is invalid and can\nno longer be used to refer to the sync object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteSync.xhtml)","ref":"gl.html#deleteSync/1"},{"type":"function","title":"gl.deleteTextures/1","doc":"[`gl:deleteTextures/1`](`deleteTextures/1`) deletes `N` textures named by the\nelements of the array `Textures`. After a texture is deleted, it has no contents\nor dimensionality, and its name is free for reuse (for example by\n[`gl:genTextures/1`](`genTextures/1`)). If a texture that is currently bound is\ndeleted, the binding reverts to 0 (the default texture).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteTextures.xhtml)","ref":"gl.html#deleteTextures/1"},{"type":"function","title":"gl.deleteTransformFeedbacks/1","doc":"[`gl:deleteTransformFeedbacks/1`](`deleteTransformFeedbacks/1`) deletes the `N`\ntransform feedback objects whose names are stored in the array `Ids`. Unused\nnames in `Ids` are ignored, as is the name zero. After a transform feedback\nobject is deleted, its name is again unused and it has no contents. If an active\ntransform feedback object is deleted, its name immediately becomes unused, but\nthe underlying object is not deleted until it is no longer active.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteTransformFeedbacks.xhtml)","ref":"gl.html#deleteTransformFeedbacks/1"},{"type":"function","title":"gl.deleteVertexArrays/1","doc":"[`gl:deleteVertexArrays/1`](`deleteVertexArrays/1`) deletes `N` vertex array\nobjects whose names are stored in the array addressed by `Arrays`. Once a vertex\narray object is deleted it has no contents and its name is again unused. If a\nvertex array object that is currently bound is deleted, the binding for that\nobject reverts to zero and the default vertex array becomes current. Unused\nnames in `Arrays` are silently ignored, as is the value zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDeleteVertexArrays.xhtml)","ref":"gl.html#deleteVertexArrays/1"},{"type":"function","title":"gl.depthFunc/1","doc":"[`gl:depthFunc/1`](`depthFunc/1`) specifies the function used to compare each\nincoming pixel depth value with the depth value present in the depth buffer. The\ncomparison is performed only if depth testing is enabled. (See\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) of\n`?GL_DEPTH_TEST`.)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthFunc.xhtml)","ref":"gl.html#depthFunc/1"},{"type":"function","title":"gl.depthMask/1","doc":"[`gl:depthMask/1`](`depthMask/1`) specifies whether the depth buffer is enabled\nfor writing. If `Flag` is `?GL_FALSE`, depth buffer writing is disabled.\nOtherwise, it is enabled. Initially, depth buffer writing is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthMask.xhtml)","ref":"gl.html#depthMask/1"},{"type":"function","title":"gl.depthRange/2","doc":"","ref":"gl.html#depthRange/2"},{"type":"function","title":"gl.depthRangeArrayv/2","doc":"After clipping and division by `w`, depth coordinates range from -1 to 1,\ncorresponding to the near and far clipping planes. Each viewport has an\nindependent depth range specified as a linear mapping of the normalized depth\ncoordinates in this range to window depth coordinates. Regardless of the actual\ndepth buffer implementation, window coordinate depth values are treated as\nthough they range from 0 through 1 (like color components).\n[`gl:depthRangeArray()`](`depthRangeArrayv/2`) specifies a linear mapping of the\nnormalized depth coordinates in this range to window depth coordinates for each\nviewport in the range [`First`, `First` \\+ `Count`). Thus, the values accepted\nby [`gl:depthRangeArray()`](`depthRangeArrayv/2`) are both clamped to this range\nbefore they are accepted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthRangeArray.xhtml)","ref":"gl.html#depthRangeArrayv/2"},{"type":"function","title":"gl.depthRangef/2","doc":"After clipping and division by `w`, depth coordinates range from -1 to 1,\ncorresponding to the near and far clipping planes.\n[`gl:depthRange/2`](`depthRange/2`) specifies a linear mapping of the normalized\ndepth coordinates in this range to window depth coordinates. Regardless of the\nactual depth buffer implementation, window coordinate depth values are treated\nas though they range from 0 through 1 (like color components). Thus, the values\naccepted by [`gl:depthRange/2`](`depthRange/2`) are both clamped to this range\nbefore they are accepted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthRange.xhtml)","ref":"gl.html#depthRangef/2"},{"type":"function","title":"gl.depthRangeIndexed/3","doc":"After clipping and division by `w`, depth coordinates range from -1 to 1,\ncorresponding to the near and far clipping planes. Each viewport has an\nindependent depth range specified as a linear mapping of the normalized depth\ncoordinates in this range to window depth coordinates. Regardless of the actual\ndepth buffer implementation, window coordinate depth values are treated as\nthough they range from 0 through 1 (like color components).\n[`gl:depthRangeIndexed/3`](`depthRangeIndexed/3`) specifies a linear mapping of\nthe normalized depth coordinates in this range to window depth coordinates for a\nspecified viewport. Thus, the values accepted by\n[`gl:depthRangeIndexed/3`](`depthRangeIndexed/3`) are both clamped to this range\nbefore they are accepted.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDepthRangeIndexed.xhtml)","ref":"gl.html#depthRangeIndexed/3"},{"type":"function","title":"gl.detachShader/2","doc":"[`gl:detachShader/2`](`detachShader/2`) detaches the shader object specified by\n`Shader` from the program object specified by `Program`. This command can be\nused to undo the effect of the command [`gl:attachShader/2`](`attachShader/2`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDetachShader.xhtml)","ref":"gl.html#detachShader/2"},{"type":"function","title":"gl.disable/1","doc":"","ref":"gl.html#disable/1"},{"type":"function","title":"gl.disableClientState/1","doc":"","ref":"gl.html#disableClientState/1"},{"type":"function","title":"gl.disablei/2","doc":"","ref":"gl.html#disablei/2"},{"type":"function","title":"gl.disableVertexArrayAttrib/2","doc":"","ref":"gl.html#disableVertexArrayAttrib/2"},{"type":"function","title":"gl.disableVertexAttribArray/1","doc":"","ref":"gl.html#disableVertexAttribArray/1"},{"type":"function","title":"gl.dispatchCompute/3","doc":"[`gl:dispatchCompute/3`](`dispatchCompute/3`) launches one or more compute work\ngroups. Each work group is processed by the active program object for the\ncompute shader stage. While the individual shader invocations within a work\ngroup are executed as a unit, work groups are executed completely independently\nand in unspecified order. `Num_groups_x`, `Num_groups_y` and `Num_groups_z`\nspecify the number of local work groups that will be dispatched in the X, Y and\nZ dimensions, respectively.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDispatchCompute.xhtml)","ref":"gl.html#dispatchCompute/3"},{"type":"function","title":"gl.dispatchComputeIndirect/1","doc":"[`gl:dispatchComputeIndirect/1`](`dispatchComputeIndirect/1`) launches one or\nmore compute work groups using parameters stored in the buffer object currently\nbound to the `?GL_DISPATCH_INDIRECT_BUFFER` target. Each work group is processed\nby the active program object for the compute shader stage. While the individual\nshader invocations within a work group are executed as a unit, work groups are\nexecuted completely independently and in unspecified order. `Indirect` contains\nthe offset into the data store of the buffer object bound to the\n`?GL_DISPATCH_INDIRECT_BUFFER` target at which the parameters are stored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDispatchComputeIndirect.xhtml)","ref":"gl.html#dispatchComputeIndirect/1"},{"type":"function","title":"gl.drawArrays/3","doc":"[`gl:drawArrays/3`](`drawArrays/3`) specifies multiple geometric primitives with\nvery few subroutine calls. Instead of calling a GL procedure to pass each\nindividual vertex, normal, texture coordinate, edge flag, or color, you can\nprespecify separate arrays of vertices, normals, and colors and use them to\nconstruct a sequence of primitives with a single call to\n[`gl:drawArrays/3`](`drawArrays/3`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArrays.xhtml)","ref":"gl.html#drawArrays/3"},{"type":"function","title":"gl.drawArraysIndirect/2","doc":"[`gl:drawArraysIndirect/2`](`drawArraysIndirect/2`) specifies multiple geometric\nprimitives with very few subroutine calls.\n[`gl:drawArraysIndirect/2`](`drawArraysIndirect/2`) behaves similarly to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`),\nexecept that the parameters to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`)\nare stored in memory at the address given by `Indirect`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysIndirect.xhtml)","ref":"gl.html#drawArraysIndirect/2"},{"type":"function","title":"gl.drawArraysInstanced/4","doc":"[`gl:drawArraysInstanced/4`](`drawArraysInstanced/4`) behaves identically to\n[`gl:drawArrays/3`](`drawArrays/3`) except that `Instancecount` instances of the\nrange of elements are executed and the value of the internal counter\n`InstanceID` advances for each iteration. `InstanceID` is an internal 32-bit\ninteger counter that may be read by a vertex shader as `?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysInstanced.xhtml)","ref":"gl.html#drawArraysInstanced/4"},{"type":"function","title":"gl.drawArraysInstancedBaseInstance/5","doc":"[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`)\nbehaves identically to [`gl:drawArrays/3`](`drawArrays/3`) except that\n`Instancecount` instances of the range of elements are executed and the value of\nthe internal counter `InstanceID` advances for each iteration. `InstanceID` is\nan internal 32-bit integer counter that may be read by a vertex shader as\n`?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawArraysInstancedBaseInstance.xhtml)","ref":"gl.html#drawArraysInstancedBaseInstance/5"},{"type":"function","title":"gl.drawBuffer/1","doc":"When colors are written to the frame buffer, they are written into the color\nbuffers specified by [`gl:drawBuffer/1`](`drawBuffer/1`). One of the following\nvalues can be used for default framebuffer:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawBuffer.xhtml)","ref":"gl.html#drawBuffer/1"},{"type":"function","title":"gl.drawBuffers/1","doc":"[`gl:drawBuffers/1`](`drawBuffers/1`) and `glNamedFramebufferDrawBuffers` define\nan array of buffers into which outputs from the fragment shader data will be\nwritten. If a fragment shader writes a value to one or more user defined output\nvariables, then the value of each variable will be written into the buffer\nspecified at a location within `Bufs` corresponding to the location assigned to\nthat user defined output. The draw buffer used for user defined outputs assigned\nto locations greater than or equal to `N` is implicitly set to `?GL_NONE` and\nany data written to such an output is discarded.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawBuffers.xhtml)","ref":"gl.html#drawBuffers/1"},{"type":"function","title":"gl.drawElements/4","doc":"[`gl:drawElements/4`](`drawElements/4`) specifies multiple geometric primitives\nwith very few subroutine calls. Instead of calling a GL function to pass each\nindividual vertex, normal, texture coordinate, edge flag, or color, you can\nprespecify separate arrays of vertices, normals, and so on, and use them to\nconstruct a sequence of primitives with a single call to\n[`gl:drawElements/4`](`drawElements/4`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElements.xhtml)","ref":"gl.html#drawElements/4"},{"type":"function","title":"gl.drawElementsBaseVertex/5","doc":"[`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`) behaves identically\nto [`gl:drawElements/4`](`drawElements/4`) except that the `i`th element\ntransferred by the corresponding draw call will be taken from element\n`Indices`\\[i] + `Basevertex` of each enabled array. If the resulting value is\nlarger than the maximum value representable by `Type`, it is as if the\ncalculation were upconverted to 32-bit unsigned integers (with wrapping on\noverflow conditions). The operation is undefined if the sum would be negative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsBaseVertex.xhtml)","ref":"gl.html#drawElementsBaseVertex/5"},{"type":"function","title":"gl.drawElementsIndirect/3","doc":"[`gl:drawElementsIndirect/3`](`drawElementsIndirect/3`) specifies multiple\nindexed geometric primitives with very few subroutine calls.\n[`gl:drawElementsIndirect/3`](`drawElementsIndirect/3`) behaves similarly to\n[`gl:drawElementsInstancedBaseVertexBaseInstance/7`](`drawElementsInstancedBaseVertexBaseInstance/7`),\nexecpt that the parameters to\n[`gl:drawElementsInstancedBaseVertexBaseInstance/7`](`drawElementsInstancedBaseVertexBaseInstance/7`)\nare stored in memory at the address given by `Indirect`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsIndirect.xhtml)","ref":"gl.html#drawElementsIndirect/3"},{"type":"function","title":"gl.drawElementsInstanced/5","doc":"[`gl:drawElementsInstanced/5`](`drawElementsInstanced/5`) behaves identically to\n[`gl:drawElements/4`](`drawElements/4`) except that `Instancecount` instances of\nthe set of elements are executed and the value of the internal counter\n`InstanceID` advances for each iteration. `InstanceID` is an internal 32-bit\ninteger counter that may be read by a vertex shader as `?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstanced.xhtml)","ref":"gl.html#drawElementsInstanced/5"},{"type":"function","title":"gl.drawElementsInstancedBaseInstance/6","doc":"[`gl:drawElementsInstancedBaseInstance/6`](`drawElementsInstancedBaseInstance/6`)\nbehaves identically to [`gl:drawElements/4`](`drawElements/4`) except that\n`Instancecount` instances of the set of elements are executed and the value of\nthe internal counter `InstanceID` advances for each iteration. `InstanceID` is\nan internal 32-bit integer counter that may be read by a vertex shader as\n`?gl_InstanceID`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstancedBaseInstance.xhtml)","ref":"gl.html#drawElementsInstancedBaseInstance/6"},{"type":"function","title":"gl.drawElementsInstancedBaseVertex/6","doc":"[`gl:drawElementsInstancedBaseVertex/6`](`drawElementsInstancedBaseVertex/6`)\nbehaves identically to [`gl:drawElementsInstanced/5`](`drawElementsInstanced/5`)\nexcept that the `i`th element transferred by the corresponding draw call will be\ntaken from element `Indices`\\[i] + `Basevertex` of each enabled array. If the\nresulting value is larger than the maximum value representable by `Type`, it is\nas if the calculation were upconverted to 32-bit unsigned integers (with\nwrapping on overflow conditions). The operation is undefined if the sum would be\nnegative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstancedBaseVertex.xhtml)","ref":"gl.html#drawElementsInstancedBaseVertex/6"},{"type":"function","title":"gl.drawElementsInstancedBaseVertexBaseInstance/7","doc":"[`gl:drawElementsInstancedBaseVertexBaseInstance/7`](`drawElementsInstancedBaseVertexBaseInstance/7`)\nbehaves identically to [`gl:drawElementsInstanced/5`](`drawElementsInstanced/5`)\nexcept that the `i`th element transferred by the corresponding draw call will be\ntaken from element `Indices`\\[i] + `Basevertex` of each enabled array. If the\nresulting value is larger than the maximum value representable by `Type`, it is\nas if the calculation were upconverted to 32-bit unsigned integers (with\nwrapping on overflow conditions). The operation is undefined if the sum would be\nnegative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawElementsInstancedBaseVertexBaseInstance.xhtml)","ref":"gl.html#drawElementsInstancedBaseVertexBaseInstance/7"},{"type":"function","title":"gl.drawPixels/5","doc":"[`gl:drawPixels/5`](`drawPixels/5`) reads pixel data from memory and writes it\ninto the frame buffer relative to the current raster position, provided that the\nraster position is valid. Use [`gl:rasterPos()`](`rasterPos2d/2`) or\n[`gl:windowPos()`](`windowPos2d/2`) to set the current raster position; use\n[`gl:get()`](`getBooleanv/1`) with argument `?GL_CURRENT_RASTER_POSITION_VALID`\nto determine if the specified raster position is valid, and\n[`gl:get()`](`getBooleanv/1`) with argument `?GL_CURRENT_RASTER_POSITION` to\nquery the raster position.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glDrawPixels.xml)","ref":"gl.html#drawPixels/5"},{"type":"function","title":"gl.drawRangeElements/6","doc":"[`gl:drawRangeElements/6`](`drawRangeElements/6`) is a restricted form of\n[`gl:drawElements/4`](`drawElements/4`). `Mode`, and `Count` match the\ncorresponding arguments to [`gl:drawElements/4`](`drawElements/4`), with the\nadditional constraint that all values in the arrays `Count` must lie between\n`Start` and `End`, inclusive.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawRangeElements.xhtml)","ref":"gl.html#drawRangeElements/6"},{"type":"function","title":"gl.drawRangeElementsBaseVertex/7","doc":"[`gl:drawRangeElementsBaseVertex/7`](`drawRangeElementsBaseVertex/7`) is a\nrestricted form of [`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`).\n`Mode`, `Count` and `Basevertex` match the corresponding arguments to\n[`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`), with the additional\nconstraint that all values in the array `Indices` must lie between `Start` and\n`End`, inclusive, prior to adding `Basevertex`. Index values lying outside the\nrange [`Start`, `End`] are treated in the same way as\n[`gl:drawElementsBaseVertex/5`](`drawElementsBaseVertex/5`). The `i`th element\ntransferred by the corresponding draw call will be taken from element\n`Indices`\\[i] + `Basevertex` of each enabled array. If the resulting value is\nlarger than the maximum value representable by `Type`, it is as if the\ncalculation were upconverted to 32-bit unsigned integers (with wrapping on\noverflow conditions). The operation is undefined if the sum would be negative.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawRangeElementsBaseVertex.xhtml)","ref":"gl.html#drawRangeElementsBaseVertex/7"},{"type":"function","title":"gl.drawTransformFeedback/2","doc":"[`gl:drawTransformFeedback/2`](`drawTransformFeedback/2`) draws primitives of a\ntype specified by `Mode` using a count retrieved from the transform feedback\nspecified by `Id`. Calling\n[`gl:drawTransformFeedback/2`](`drawTransformFeedback/2`) is equivalent to\ncalling [`gl:drawArrays/3`](`drawArrays/3`) with `Mode` as specified, `First`\nset to zero, and `Count` set to the number of vertices captured on vertex stream\nzero the last time transform feedback was active on the transform feedback\nobject named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedback.xhtml)","ref":"gl.html#drawTransformFeedback/2"},{"type":"function","title":"gl.drawTransformFeedbackInstanced/3","doc":"[`gl:drawTransformFeedbackInstanced/3`](`drawTransformFeedbackInstanced/3`)\ndraws multiple copies of a range of primitives of a type specified by `Mode`\nusing a count retrieved from the transform feedback stream specified by `Stream`\nof the transform feedback object specified by `Id`. Calling\n[`gl:drawTransformFeedbackInstanced/3`](`drawTransformFeedbackInstanced/3`) is\nequivalent to calling [`gl:drawArraysInstanced/4`](`drawArraysInstanced/4`) with\n`Mode` and `Instancecount` as specified, `First` set to zero, and `Count` set to\nthe number of vertices captured on vertex stream zero the last time transform\nfeedback was active on the transform feedback object named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedbackInstanced.xhtml)","ref":"gl.html#drawTransformFeedbackInstanced/3"},{"type":"function","title":"gl.drawTransformFeedbackStream/3","doc":"[`gl:drawTransformFeedbackStream/3`](`drawTransformFeedbackStream/3`) draws\nprimitives of a type specified by `Mode` using a count retrieved from the\ntransform feedback stream specified by `Stream` of the transform feedback object\nspecified by `Id`. Calling\n[`gl:drawTransformFeedbackStream/3`](`drawTransformFeedbackStream/3`) is\nequivalent to calling [`gl:drawArrays/3`](`drawArrays/3`) with `Mode` as\nspecified, `First` set to zero, and `Count` set to the number of vertices\ncaptured on vertex stream `Stream` the last time transform feedback was active\non the transform feedback object named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedbackStream.xhtml)","ref":"gl.html#drawTransformFeedbackStream/3"},{"type":"function","title":"gl.drawTransformFeedbackStreamInstanced/4","doc":"[`gl:drawTransformFeedbackStreamInstanced/4`](`drawTransformFeedbackStreamInstanced/4`)\ndraws multiple copies of a range of primitives of a type specified by `Mode`\nusing a count retrieved from the transform feedback stream specified by `Stream`\nof the transform feedback object specified by `Id`. Calling\n[`gl:drawTransformFeedbackStreamInstanced/4`](`drawTransformFeedbackStreamInstanced/4`)\nis equivalent to calling [`gl:drawArraysInstanced/4`](`drawArraysInstanced/4`)\nwith `Mode` and `Instancecount` as specified, `First` set to zero, and `Count`\nset to the number of vertices captured on vertex stream `Stream` the last time\ntransform feedback was active on the transform feedback object named by `Id`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glDrawTransformFeedbackStreamInstanced.xhtml)","ref":"gl.html#drawTransformFeedbackStreamInstanced/4"},{"type":"function","title":"gl.edgeFlag/1","doc":"","ref":"gl.html#edgeFlag/1"},{"type":"function","title":"gl.edgeFlagPointer/2","doc":"[`gl:edgeFlagPointer/2`](`edgeFlagPointer/2`) specifies the location and data\nformat of an array of boolean edge flags to use when rendering. `Stride`\nspecifies the byte stride from one edge flag to the next, allowing vertices and\nattributes to be packed into a single array or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEdgeFlagPointer.xml)","ref":"gl.html#edgeFlagPointer/2"},{"type":"function","title":"gl.edgeFlagv/1","doc":"Each vertex of a polygon, separate triangle, or separate quadrilateral specified\nbetween a [`gl:'begin'/1`](`'begin'/1`)/[`gl:'end'/0`](`'begin'/1`) pair is\nmarked as the start of either a boundary or nonboundary edge. If the current\nedge flag is true when the vertex is specified, the vertex is marked as the\nstart of a boundary edge. Otherwise, the vertex is marked as the start of a\nnonboundary edge. [`gl:edgeFlag/1`](`edgeFlag/1`) sets the edge flag bit to\n`?GL_TRUE` if `Flag` is `?GL_TRUE` and to `?GL_FALSE` otherwise.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEdgeFlag.xml)","ref":"gl.html#edgeFlagv/1"},{"type":"function","title":"gl.enable/1","doc":"","ref":"gl.html#enable/1"},{"type":"function","title":"gl.enableClientState/1","doc":"[`gl:enableClientState/1`](`enableClientState/1`) and\n[`gl:disableClientState/1`](`enableClientState/1`) enable or disable individual\nclient-side capabilities. By default, all client-side capabilities are disabled.\nBoth [`gl:enableClientState/1`](`enableClientState/1`) and\n[`gl:disableClientState/1`](`enableClientState/1`) take a single argument,\n`Cap`, which can assume one of the following values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEnableClientState.xml)","ref":"gl.html#enableClientState/1"},{"type":"function","title":"gl.enablei/2","doc":"[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`) enable and disable\nvarious capabilities. Use [`gl:isEnabled/1`](`isEnabled/1`) or\n[`gl:get()`](`getBooleanv/1`) to determine the current setting of any\ncapability. The initial value for each capability with the exception of\n`?GL_DITHER` and `?GL_MULTISAMPLE` is `?GL_FALSE`. The initial value for\n`?GL_DITHER` and `?GL_MULTISAMPLE` is `?GL_TRUE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnable.xhtml)","ref":"gl.html#enablei/2"},{"type":"function","title":"gl.enableVertexArrayAttrib/2","doc":"","ref":"gl.html#enableVertexArrayAttrib/2"},{"type":"function","title":"gl.enableVertexAttribArray/1","doc":"[`gl:enableVertexAttribArray/1`](`enableVertexAttribArray/1`) and\n[`gl:enableVertexArrayAttrib/2`](`disableVertexAttribArray/1`) enable the\ngeneric vertex attribute array specified by `Index`.\n[`gl:enableVertexAttribArray/1`](`enableVertexAttribArray/1`) uses currently\nbound vertex array object for the operation, whereas\n[`gl:enableVertexArrayAttrib/2`](`disableVertexAttribArray/1`) updates state of\nthe vertex array object with ID `Vaobj`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glEnableVertexAttribArray.xhtml)","ref":"gl.html#enableVertexAttribArray/1"},{"type":"function","title":"gl.end/0","doc":"[`gl:'begin'/1`](`'begin'/1`) and [`gl:'end'/0`](`'begin'/1`) delimit the\nvertices that define a primitive or a group of like primitives.\n[`gl:'begin'/1`](`'begin'/1`) accepts a single argument that specifies in which\nof ten ways the vertices are interpreted. Taking n as an integer count starting\nat one, and N as the total number of vertices specified, the interpretations are\nas follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glBegin.xml)","ref":"gl.html#end/0"},{"type":"function","title":"gl.endConditionalRender/0","doc":"Conditional rendering is started using\n[`gl:beginConditionalRender/2`](`beginConditionalRender/2`) and ended using\n[`gl:endConditionalRender/0`](`beginConditionalRender/2`). During conditional\nrendering, all vertex array commands, as well as [`gl:clear/1`](`clear/1`) and\n[`gl:clearBuffer()`](`clearBufferiv/3`) have no effect if the\n(`?GL_SAMPLES_PASSED`) result of the query object `Id` is zero, or if the\n(`?GL_ANY_SAMPLES_PASSED`) result is `?GL_FALSE`. The results of commands\nsetting the current vertex state, such as\n[`gl:vertexAttrib()`](`vertexAttrib1d/2`) are undefined. If the\n(`?GL_SAMPLES_PASSED`) result is non-zero or if the (`?GL_ANY_SAMPLES_PASSED`)\nresult is `?GL_TRUE`, such commands are not discarded. The `Id` parameter to\n[`gl:beginConditionalRender/2`](`beginConditionalRender/2`) must be the name of\na query object previously returned from a call to\n[`gl:genQueries/1`](`genQueries/1`). `Mode` specifies how the results of the\nquery object are to be interpreted. If `Mode` is `?GL_QUERY_WAIT`, the GL waits\nfor the results of the query to be available and then uses the results to\ndetermine if subsequent rendering commands are discarded. If `Mode` is\n`?GL_QUERY_NO_WAIT`, the GL may choose to unconditionally execute the subsequent\nrendering commands without waiting for the query to complete.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginConditionalRender.xhtml)","ref":"gl.html#endConditionalRender/0"},{"type":"function","title":"gl.endList/0","doc":"","ref":"gl.html#endList/0"},{"type":"function","title":"gl.endQuery/1","doc":"[`gl:beginQuery/2`](`beginQuery/2`) and [`gl:endQuery/1`](`beginQuery/2`)\ndelimit the boundaries of a query object. `Query` must be a name previously\nreturned from a call to [`gl:genQueries/1`](`genQueries/1`). If a query object\nwith name `Id` does not yet exist it is created with the type determined by\n`Target`. `Target` must be one of `?GL_SAMPLES_PASSED`,\n`?GL_ANY_SAMPLES_PASSED`, `?GL_PRIMITIVES_GENERATED`,\n`?GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN`, or `?GL_TIME_ELAPSED`. The behavior\nof the query object depends on its type and is as follows.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginQuery.xhtml)","ref":"gl.html#endQuery/1"},{"type":"function","title":"gl.endQueryIndexed/2","doc":"[`gl:beginQueryIndexed/3`](`beginQueryIndexed/3`) and\n[`gl:endQueryIndexed/2`](`beginQueryIndexed/3`) delimit the boundaries of a\nquery object. `Query` must be a name previously returned from a call to\n[`gl:genQueries/1`](`genQueries/1`). If a query object with name `Id` does not\nyet exist it is created with the type determined by `Target`. `Target` must be\none of `?GL_SAMPLES_PASSED`, `?GL_ANY_SAMPLES_PASSED`,\n`?GL_PRIMITIVES_GENERATED`, `?GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN`, or\n`?GL_TIME_ELAPSED`. The behavior of the query object depends on its type and is\nas follows.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginQueryIndexed.xhtml)","ref":"gl.html#endQueryIndexed/2"},{"type":"function","title":"gl.endTransformFeedback/0","doc":"Transform feedback mode captures the values of varying variables written by the\nvertex shader (or, if active, the geometry shader). Transform feedback is said\nto be active after a call to\n[`gl:beginTransformFeedback/1`](`beginTransformFeedback/1`) until a subsequent\ncall to [`gl:endTransformFeedback/0`](`beginTransformFeedback/1`). Transform\nfeedback commands must be paired.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBeginTransformFeedback.xhtml)","ref":"gl.html#endTransformFeedback/0"},{"type":"function","title":"gl.evalCoord1d/1","doc":"","ref":"gl.html#evalCoord1d/1"},{"type":"function","title":"gl.evalCoord1dv/1","doc":"","ref":"gl.html#evalCoord1dv/1"},{"type":"function","title":"gl.evalCoord1f/1","doc":"","ref":"gl.html#evalCoord1f/1"},{"type":"function","title":"gl.evalCoord1fv/1","doc":"","ref":"gl.html#evalCoord1fv/1"},{"type":"function","title":"gl.evalCoord2d/2","doc":"","ref":"gl.html#evalCoord2d/2"},{"type":"function","title":"gl.evalCoord2dv/1","doc":"","ref":"gl.html#evalCoord2dv/1"},{"type":"function","title":"gl.evalCoord2f/2","doc":"","ref":"gl.html#evalCoord2f/2"},{"type":"function","title":"gl.evalCoord2fv/1","doc":"[`gl:evalCoord1()`](`evalCoord1d/1`) evaluates enabled one-dimensional maps at\nargument `U`. [`gl:evalCoord2()`](`evalCoord1d/1`) does the same for\ntwo-dimensional maps using two domain values, `U` and `V`. To define a map, call\n`glMap1` and `glMap2`; to enable and disable it, call\n[`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEvalCoord.xml)","ref":"gl.html#evalCoord2fv/1"},{"type":"function","title":"gl.evalMesh1/3","doc":"","ref":"gl.html#evalMesh1/3"},{"type":"function","title":"gl.evalMesh2/5","doc":"[`gl:mapGrid()`](`mapGrid1d/3`) and [`gl:evalMesh()`](`evalMesh1/3`) are used in\ntandem to efficiently generate and evaluate a series of evenly-spaced map domain\nvalues. [`gl:evalMesh()`](`evalMesh1/3`) steps through the integer domain of a\none- or two-dimensional grid, whose range is the domain of the evaluation maps\nspecified by `glMap1` and `glMap2`. `Mode` determines whether the resulting\nvertices are connected as points, lines, or filled polygons.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEvalMesh.xml)","ref":"gl.html#evalMesh2/5"},{"type":"function","title":"gl.evalPoint1/1","doc":"","ref":"gl.html#evalPoint1/1"},{"type":"function","title":"gl.evalPoint2/2","doc":"[`gl:mapGrid()`](`mapGrid1d/3`) and [`gl:evalMesh()`](`evalMesh1/3`) are used in\ntandem to efficiently generate and evaluate a series of evenly spaced map domain\nvalues. [`gl:evalPoint()`](`evalPoint1/1`) can be used to evaluate a single grid\npoint in the same gridspace that is traversed by\n[`gl:evalMesh()`](`evalMesh1/3`). Calling [`gl:evalPoint1/1`](`evalPoint1/1`) is\nequivalent to calling glEvalCoord1( i.ð u+u 1 ); where ð u=(u 2-u 1)/n\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glEvalPoint.xml)","ref":"gl.html#evalPoint2/2"},{"type":"function","title":"gl.feedbackBuffer/3","doc":"The [`gl:feedbackBuffer/3`](`feedbackBuffer/3`) function controls feedback.\nFeedback, like selection, is a GL mode. The mode is selected by calling\n[`gl:renderMode/1`](`renderMode/1`) with `?GL_FEEDBACK`. When the GL is in\nfeedback mode, no pixels are produced by rasterization. Instead, information\nabout primitives that would have been rasterized is fed back to the application\nusing the GL.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFeedbackBuffer.xml)","ref":"gl.html#feedbackBuffer/3"},{"type":"function","title":"gl.fenceSync/2","doc":"[`gl:fenceSync/2`](`fenceSync/2`) creates a new fence sync object, inserts a\nfence command into the GL command stream and associates it with that sync\nobject, and returns a non-zero name corresponding to the sync object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFenceSync.xhtml)","ref":"gl.html#fenceSync/2"},{"type":"function","title":"gl.finish/0","doc":"[`gl:finish/0`](`finish/0`) does not return until the effects of all previously\ncalled GL commands are complete. Such effects include all changes to GL state,\nall changes to connection state, and all changes to the frame buffer contents.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFinish.xhtml)","ref":"gl.html#finish/0"},{"type":"function","title":"gl.flush/0","doc":"Different GL implementations buffer commands in several different locations,\nincluding network buffers and the graphics accelerator itself.\n[`gl:flush/0`](`flush/0`) empties all of these buffers, causing all issued\ncommands to be executed as quickly as they are accepted by the actual rendering\nengine. Though this execution may not be completed in any particular time\nperiod, it does complete in finite time.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFlush.xhtml)","ref":"gl.html#flush/0"},{"type":"function","title":"gl.flushMappedBufferRange/3","doc":"","ref":"gl.html#flushMappedBufferRange/3"},{"type":"function","title":"gl.flushMappedNamedBufferRange/3","doc":"[`gl:flushMappedBufferRange/3`](`flushMappedBufferRange/3`) indicates that\nmodifications have been made to a range of a mapped buffer object. The buffer\nobject must previously have been mapped with the `?GL_MAP_FLUSH_EXPLICIT_BIT`\nflag.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFlushMappedBufferRange.xhtml)","ref":"gl.html#flushMappedNamedBufferRange/3"},{"type":"function","title":"gl.fogCoordd/1","doc":"","ref":"gl.html#fogCoordd/1"},{"type":"function","title":"gl.fogCoorddv/1","doc":"","ref":"gl.html#fogCoorddv/1"},{"type":"function","title":"gl.fogCoordf/1","doc":"","ref":"gl.html#fogCoordf/1"},{"type":"function","title":"gl.fogCoordfv/1","doc":"[`gl:fogCoord()`](`fogCoordf/1`) specifies the fog coordinate that is associated\nwith each vertex and the current raster position. The value specified is\ninterpolated and used in computing the fog color (see [`gl:fog()`](`fogf/2`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFogCoord.xml)","ref":"gl.html#fogCoordfv/1"},{"type":"function","title":"gl.fogCoordPointer/3","doc":"[`gl:fogCoordPointer/3`](`fogCoordPointer/3`) specifies the location and data\nformat of an array of fog coordinates to use when rendering. `Type` specifies\nthe data type of each fog coordinate, and `Stride` specifies the byte stride\nfrom one fog coordinate to the next, allowing vertices and attributes to be\npacked into a single array or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFogCoordPointer.xml)","ref":"gl.html#fogCoordPointer/3"},{"type":"function","title":"gl.fogf/2","doc":"","ref":"gl.html#fogf/2"},{"type":"function","title":"gl.fogfv/2","doc":"","ref":"gl.html#fogfv/2"},{"type":"function","title":"gl.fogi/2","doc":"","ref":"gl.html#fogi/2"},{"type":"function","title":"gl.fogiv/2","doc":"Fog is initially disabled. While enabled, fog affects rasterized geometry,\nbitmaps, and pixel blocks, but not buffer clear operations. To enable and\ndisable fog, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_FOG`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFog.xml)","ref":"gl.html#fogiv/2"},{"type":"function","title":"gl.framebufferParameteri/3","doc":"[`gl:framebufferParameteri/3`](`framebufferParameteri/3`) and\n`glNamedFramebufferParameteri` modify the value of the parameter named `Pname`\nin the specified framebuffer object. There are no modifiable parameters of the\ndefault draw and read framebuffer, so they are not valid targets of these\ncommands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferParameteri.xhtml)","ref":"gl.html#framebufferParameteri/3"},{"type":"function","title":"gl.framebufferRenderbuffer/4","doc":"[`gl:framebufferRenderbuffer/4`](`framebufferRenderbuffer/4`) and\n`glNamedFramebufferRenderbuffer` attaches a renderbuffer as one of the logical\nbuffers of the specified framebuffer object. Renderbuffers cannot be attached to\nthe default draw and read framebuffer, so they are not valid targets of these\ncommands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferRenderbuffer.xhtml)","ref":"gl.html#framebufferRenderbuffer/4"},{"type":"function","title":"gl.framebufferTexture1D/5","doc":"","ref":"gl.html#framebufferTexture1D/5"},{"type":"function","title":"gl.framebufferTexture2D/5","doc":"","ref":"gl.html#framebufferTexture2D/5"},{"type":"function","title":"gl.framebufferTexture3D/6","doc":"","ref":"gl.html#framebufferTexture3D/6"},{"type":"function","title":"gl.framebufferTexture/4","doc":"","ref":"gl.html#framebufferTexture/4"},{"type":"function","title":"gl.framebufferTextureFaceARB/5","doc":"","ref":"gl.html#framebufferTextureFaceARB/5"},{"type":"function","title":"gl.framebufferTextureLayer/5","doc":"These commands attach a selected mipmap level or image of a texture object as\none of the logical buffers of the specified framebuffer object. Textures cannot\nbe attached to the default draw and read framebuffer, so they are not valid\ntargets of these commands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFramebufferTexture.xhtml)","ref":"gl.html#framebufferTextureLayer/5"},{"type":"function","title":"gl.frontFace/1","doc":"In a scene composed entirely of opaque closed surfaces, back-facing polygons are\nnever visible. Eliminating these invisible polygons has the obvious benefit of\nspeeding up the rendering of the image. To enable and disable elimination of\nback-facing polygons, call [`gl:enable/1`](`enable/1`) and\n[`gl:disable/1`](`enable/1`) with argument `?GL_CULL_FACE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glFrontFace.xhtml)","ref":"gl.html#frontFace/1"},{"type":"function","title":"gl.frustum/6","doc":"[`gl:frustum/6`](`frustum/6`) describes a perspective matrix that produces a\nperspective projection. The current matrix (see\n[`gl:matrixMode/1`](`matrixMode/1`)) is multiplied by this matrix and the result\nreplaces the current matrix, as if [`gl:multMatrix()`](`multMatrixd/1`) were\ncalled with the following matrix as its argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glFrustum.xml)","ref":"gl.html#frustum/6"},{"type":"function","title":"gl.genBuffers/1","doc":"[`gl:genBuffers/1`](`genBuffers/1`) returns `N` buffer object names in\n`Buffers`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genBuffers/1`](`genBuffers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenBuffers.xhtml)","ref":"gl.html#genBuffers/1"},{"type":"function","title":"gl.generateMipmap/1","doc":"","ref":"gl.html#generateMipmap/1"},{"type":"function","title":"gl.generateTextureMipmap/1","doc":"[`gl:generateMipmap/1`](`generateMipmap/1`) and\n[`gl:generateTextureMipmap/1`](`generateMipmap/1`) generates mipmaps for the\nspecified texture object. For [`gl:generateMipmap/1`](`generateMipmap/1`), the\ntexture object that is bound to `Target`. For\n[`gl:generateTextureMipmap/1`](`generateMipmap/1`), `Texture` is the name of the\ntexture object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenerateMipmap.xhtml)","ref":"gl.html#generateTextureMipmap/1"},{"type":"function","title":"gl.genFramebuffers/1","doc":"[`gl:genFramebuffers/1`](`genFramebuffers/1`) returns `N` framebuffer object\nnames in `Ids`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genFramebuffers/1`](`genFramebuffers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenFramebuffers.xhtml)","ref":"gl.html#genFramebuffers/1"},{"type":"function","title":"gl.genLists/1","doc":"[`gl:genLists/1`](`genLists/1`) has one argument, `Range`. It returns an integer\n`n` such that `Range` contiguous empty display lists, named n, n+1, ...,\nn+range-1, are created. If `Range` is 0, if there is no group of `Range`\ncontiguous names available, or if any error is generated, no display lists are\ngenerated, and 0 is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGenLists.xml)","ref":"gl.html#genLists/1"},{"type":"function","title":"gl.genProgramPipelines/1","doc":"[`gl:genProgramPipelines/1`](`genProgramPipelines/1`) returns `N` previously\nunused program pipeline object names in `Pipelines`. These names are marked as\nused, for the purposes of [`gl:genProgramPipelines/1`](`genProgramPipelines/1`)\nonly, but they acquire program pipeline state only when they are first bound.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenProgramPipelines.xhtml)","ref":"gl.html#genProgramPipelines/1"},{"type":"function","title":"gl.genQueries/1","doc":"[`gl:genQueries/1`](`genQueries/1`) returns `N` query object names in `Ids`.\nThere is no guarantee that the names form a contiguous set of integers; however,\nit is guaranteed that none of the returned names was in use immediately before\nthe call to [`gl:genQueries/1`](`genQueries/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenQueries.xhtml)","ref":"gl.html#genQueries/1"},{"type":"function","title":"gl.genRenderbuffers/1","doc":"[`gl:genRenderbuffers/1`](`genRenderbuffers/1`) returns `N` renderbuffer object\nnames in `Renderbuffers`. There is no guarantee that the names form a contiguous\nset of integers; however, it is guaranteed that none of the returned names was\nin use immediately before the call to\n[`gl:genRenderbuffers/1`](`genRenderbuffers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenRenderbuffers.xhtml)","ref":"gl.html#genRenderbuffers/1"},{"type":"function","title":"gl.genSamplers/1","doc":"[`gl:genSamplers/1`](`genSamplers/1`) returns `N` sampler object names in\n`Samplers`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genSamplers/1`](`genSamplers/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenSamplers.xhtml)","ref":"gl.html#genSamplers/1"},{"type":"function","title":"gl.genTextures/1","doc":"[`gl:genTextures/1`](`genTextures/1`) returns `N` texture names in `Textures`.\nThere is no guarantee that the names form a contiguous set of integers; however,\nit is guaranteed that none of the returned names was in use immediately before\nthe call to [`gl:genTextures/1`](`genTextures/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenTextures.xhtml)","ref":"gl.html#genTextures/1"},{"type":"function","title":"gl.genTransformFeedbacks/1","doc":"[`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`) returns `N` previously\nunused transform feedback object names in `Ids`. These names are marked as used,\nfor the purposes of [`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`)\nonly, but they acquire transform feedback state only when they are first bound.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenTransformFeedbacks.xhtml)","ref":"gl.html#genTransformFeedbacks/1"},{"type":"function","title":"gl.genVertexArrays/1","doc":"[`gl:genVertexArrays/1`](`genVertexArrays/1`) returns `N` vertex array object\nnames in `Arrays`. There is no guarantee that the names form a contiguous set of\nintegers; however, it is guaranteed that none of the returned names was in use\nimmediately before the call to [`gl:genVertexArrays/1`](`genVertexArrays/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGenVertexArrays.xhtml)","ref":"gl.html#genVertexArrays/1"},{"type":"function","title":"gl.getActiveAttrib/3","doc":"[`gl:getActiveAttrib/3`](`getActiveAttrib/3`) returns information about an\nactive attribute variable in the program object specified by `Program`. The\nnumber of active attributes can be obtained by calling\n[`gl:getProgram()`](`getProgramiv/2`) with the value `?GL_ACTIVE_ATTRIBUTES`. A\nvalue of 0 for `Index` selects the first active attribute variable. Permissible\nvalues for `Index` range from zero to the number of active attribute variables\nminus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveAttrib.xhtml)","ref":"gl.html#getActiveAttrib/3"},{"type":"function","title":"gl.getActiveSubroutineName/4","doc":"[`gl:getActiveSubroutineName/4`](`getActiveSubroutineName/4`) queries the name\nof an active shader subroutine uniform from the program object given in\n`Program`. `Index` specifies the index of the shader subroutine uniform within\nthe shader stage given by `Stage`, and must between zero and the value of\n`?GL_ACTIVE_SUBROUTINES` minus one for the shader stage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveSubroutineName.xhtml)","ref":"gl.html#getActiveSubroutineName/4"},{"type":"function","title":"gl.getActiveSubroutineUniformName/4","doc":"[`gl:getActiveSubroutineUniformName/4`](`getActiveSubroutineUniformName/4`)\nretrieves the name of an active shader subroutine uniform. `Program` contains\nthe name of the program containing the uniform. `Shadertype` specifies the stage\nfor which the uniform location, given by `Index`, is valid. `Index` must be\nbetween zero and the value of `?GL_ACTIVE_SUBROUTINE_UNIFORMS` minus one for the\nshader stage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveSubroutineUniformName.xhtml)","ref":"gl.html#getActiveSubroutineUniformName/4"},{"type":"function","title":"gl.getActiveUniform/3","doc":"[`gl:getActiveUniform/3`](`getActiveUniform/3`) returns information about an\nactive uniform variable in the program object specified by `Program`. The number\nof active uniform variables can be obtained by calling\n[`gl:getProgram()`](`getProgramiv/2`) with the value `?GL_ACTIVE_UNIFORMS`. A\nvalue of 0 for `Index` selects the first active uniform variable. Permissible\nvalues for `Index` range from zero to the number of active uniform variables\nminus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniform.xhtml)","ref":"gl.html#getActiveUniform/3"},{"type":"function","title":"gl.getActiveUniformBlockiv/4","doc":"[`gl:getActiveUniformBlockiv/4`](`getActiveUniformBlockiv/4`) retrieves\ninformation about an active uniform block within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformBlock.xhtml)","ref":"gl.html#getActiveUniformBlockiv/4"},{"type":"function","title":"gl.getActiveUniformBlockName/3","doc":"[`gl:getActiveUniformBlockName/3`](`getActiveUniformBlockName/3`) retrieves the\nname of the active uniform block at `UniformBlockIndex` within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformBlockName.xhtml)","ref":"gl.html#getActiveUniformBlockName/3"},{"type":"function","title":"gl.getActiveUniformName/3","doc":"[`gl:getActiveUniformName/3`](`getActiveUniformName/3`) returns the name of the\nactive uniform at `UniformIndex` within `Program`. If `UniformName` is not NULL,\nup to `BufSize` characters (including a nul-terminator) will be written into the\narray whose address is specified by `UniformName`. If `Length` is not NULL, the\nnumber of characters that were (or would have been) written into `UniformName`\n(not including the nul-terminator) will be placed in the variable whose address\nis specified in `Length`. If `Length` is NULL, no length is returned. The length\nof the longest uniform name in `Program` is given by the value of\n`?GL_ACTIVE_UNIFORM_MAX_LENGTH`, which can be queried with\n[`gl:getProgram()`](`getProgramiv/2`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformName.xhtml)","ref":"gl.html#getActiveUniformName/3"},{"type":"function","title":"gl.getActiveUniformsiv/3","doc":"[`gl:getActiveUniformsiv/3`](`getActiveUniformsiv/3`) queries the value of the\nparameter named `Pname` for each of the uniforms within `Program` whose indices\nare specified in the array of `UniformCount` unsigned integers `UniformIndices`.\nUpon success, the value of the parameter for each uniform is written into the\ncorresponding entry in the array whose address is given in `Params`. If an error\nis generated, nothing is written into `Params`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetActiveUniformsiv.xhtml)","ref":"gl.html#getActiveUniformsiv/3"},{"type":"function","title":"gl.getAttachedShaders/2","doc":"[`gl:getAttachedShaders/2`](`getAttachedShaders/2`) returns the names of the\nshader objects attached to `Program`. The names of shader objects that are\nattached to `Program` will be returned in `Shaders.` The actual number of shader\nnames written into `Shaders` is returned in `Count.` If no shader objects are\nattached to `Program`, `Count` is set to 0. The maximum number of shader names\nthat may be returned in `Shaders` is specified by `MaxCount`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetAttachedShaders.xhtml)","ref":"gl.html#getAttachedShaders/2"},{"type":"function","title":"gl.getAttribLocation/2","doc":"[`gl:getAttribLocation/2`](`getAttribLocation/2`) queries the previously linked\nprogram object specified by `Program` for the attribute variable specified by\n`Name` and returns the index of the generic vertex attribute that is bound to\nthat attribute variable. If `Name` is a matrix attribute variable, the index of\nthe first column of the matrix is returned. If the named attribute variable is\nnot an active attribute in the specified program object or if `Name` starts with\nthe reserved prefix \"gl\\_\", a value of -1 is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetAttribLocation.xhtml)","ref":"gl.html#getAttribLocation/2"},{"type":"function","title":"gl.getBooleani_v/2","doc":"","ref":"gl.html#getBooleani_v/2"},{"type":"function","title":"gl.getBooleanv/1","doc":"","ref":"gl.html#getBooleanv/1"},{"type":"function","title":"gl.getBufferParameteri64v/2","doc":"","ref":"gl.html#getBufferParameteri64v/2"},{"type":"function","title":"gl.getBufferParameteriv/2","doc":"[`gl:getBufferParameteriv/2`](`getBufferParameteriv/2`) returns in `Data` a\nselected parameter of the buffer object specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetBufferParameteriv.xml)","ref":"gl.html#getBufferParameteriv/2"},{"type":"function","title":"gl.getBufferParameterivARB/2","doc":"These functions return in `Data` a selected parameter of the specified buffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetBufferParameter.xhtml)","ref":"gl.html#getBufferParameterivARB/2"},{"type":"function","title":"gl.getBufferSubData/4","doc":"[`gl:getBufferSubData/4`](`getBufferSubData/4`) and `glGetNamedBufferSubData`\nreturn some or all of the data contents of the data store of the specified\nbuffer object. Data starting at byte offset `Offset` and extending for `Size`\nbytes is copied from the buffer object's data store to the memory pointed to by\n`Data`. An error is thrown if the buffer object is currently mapped, or if\n`Offset` and `Size` together define a range beyond the bounds of the buffer\nobject's data store.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetBufferSubData.xhtml)","ref":"gl.html#getBufferSubData/4"},{"type":"function","title":"gl.getClipPlane/1","doc":"[`gl:getClipPlane/1`](`getClipPlane/1`) returns in `Equation` the four\ncoefficients of the plane equation for `Plane`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetClipPlane.xml)","ref":"gl.html#getClipPlane/1"},{"type":"function","title":"gl.getColorTable/4","doc":"[`gl:getColorTable/4`](`getColorTable/4`) returns in `Table` the contents of the\ncolor table specified by `Target`. No pixel transfer operations are performed,\nbut pixel storage modes that are applicable to\n[`gl:readPixels/7`](`readPixels/7`) are performed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetColorTable.xml)","ref":"gl.html#getColorTable/4"},{"type":"function","title":"gl.getColorTableParameterfv/2","doc":"","ref":"gl.html#getColorTableParameterfv/2"},{"type":"function","title":"gl.getColorTableParameteriv/2","doc":"Returns parameters specific to color table `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetColorTableParameter.xml)","ref":"gl.html#getColorTableParameteriv/2"},{"type":"function","title":"gl.getCompressedTexImage/3","doc":"[`gl:getCompressedTexImage/3`](`getCompressedTexImage/3`) and\n`glGetnCompressedTexImage` return the compressed texture image associated with\n`Target` and `Lod` into `Pixels`. `glGetCompressedTextureImage` serves the same\npurpose, but instead of taking a texture target, it takes the ID of the texture\nobject. `Pixels` should be an array of `BufSize` bytes for\n`glGetnCompresedTexImage` and `glGetCompressedTextureImage` functions, and of\n`?GL_TEXTURE_COMPRESSED_IMAGE_SIZE` bytes in case of\n[`gl:getCompressedTexImage/3`](`getCompressedTexImage/3`). If the actual data\ntakes less space than `BufSize`, the remaining bytes will not be touched.\n`Target` specifies the texture target, to which the texture the data the\nfunction should extract the data from is bound to. `Lod` specifies the\nlevel-of-detail number of the desired image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetCompressedTexImage.xhtml)","ref":"gl.html#getCompressedTexImage/3"},{"type":"function","title":"gl.getConvolutionFilter/4","doc":"[`gl:getConvolutionFilter/4`](`getConvolutionFilter/4`) returns the current 1D\nor 2D convolution filter kernel as an image. The one- or two-dimensional image\nis placed in `Image` according to the specifications in `Format` and `Type`. No\npixel transfer operations are performed on this image, but the relevant pixel\nstorage modes are applied.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetConvolutionFilter.xml)","ref":"gl.html#getConvolutionFilter/4"},{"type":"function","title":"gl.getConvolutionParameterfv/2","doc":"","ref":"gl.html#getConvolutionParameterfv/2"},{"type":"function","title":"gl.getConvolutionParameteriv/2","doc":"[`gl:getConvolutionParameter()`](`getConvolutionParameterfv/2`) retrieves\nconvolution parameters. `Target` determines which convolution filter is queried.\n`Pname` determines which parameter is returned:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetConvolutionParameter.xml)","ref":"gl.html#getConvolutionParameteriv/2"},{"type":"function","title":"gl.getDebugMessageLog/2","doc":"[`gl:getDebugMessageLog/2`](`getDebugMessageLog/2`) retrieves messages from the\ndebug message log. A maximum of `Count` messages are retrieved from the log. If\n`Sources` is not NULL then the source of each message is written into up to\n`Count` elements of the array. If `Types` is not NULL then the type of each\nmessage is written into up to `Count` elements of the array. If `Id` is not NULL\nthen the identifier of each message is written into up to `Count` elements of\nthe array. If `Severities` is not NULL then the severity of each message is\nwritten into up to `Count` elements of the array. If `Lengths` is not NULL then\nthe length of each message is written into up to `Count` elements of the array.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetDebugMessageLog.xhtml)","ref":"gl.html#getDebugMessageLog/2"},{"type":"function","title":"gl.getDoublei_v/2","doc":"","ref":"gl.html#getDoublei_v/2"},{"type":"function","title":"gl.getDoublev/1","doc":"","ref":"gl.html#getDoublev/1"},{"type":"function","title":"gl.getError/0","doc":"[`gl:getError/0`](`getError/0`) returns the value of the error flag. Each\ndetectable error is assigned a numeric code and symbolic name. When an error\noccurs, the error flag is set to the appropriate error code value. No other\nerrors are recorded until [`gl:getError/0`](`getError/0`) is called, the error\ncode is returned, and the flag is reset to `?GL_NO_ERROR`. If a call to\n[`gl:getError/0`](`getError/0`) returns `?GL_NO_ERROR`, there has been no\ndetectable error since the last call to [`gl:getError/0`](`getError/0`), or\nsince the GL was initialized.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetError.xhtml)","ref":"gl.html#getError/0"},{"type":"function","title":"gl.getFloati_v/2","doc":"","ref":"gl.html#getFloati_v/2"},{"type":"function","title":"gl.getFloatv/1","doc":"","ref":"gl.html#getFloatv/1"},{"type":"function","title":"gl.getFragDataIndex/2","doc":"[`gl:getFragDataIndex/2`](`getFragDataIndex/2`) returns the index of the\nfragment color to which the variable `Name` was bound when the program object\n`Program` was last linked. If `Name` is not a varying out variable of `Program`,\nor if an error occurs, -1 will be returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFragDataIndex.xhtml)","ref":"gl.html#getFragDataIndex/2"},{"type":"function","title":"gl.getFragDataLocation/2","doc":"[`gl:getFragDataLocation/2`](`getFragDataLocation/2`) retrieves the assigned\ncolor number binding for the user-defined varying out variable `Name` for\nprogram `Program`. `Program` must have previously been linked. `Name` must be a\nnull-terminated string. If `Name` is not the name of an active user-defined\nvarying out fragment shader variable within `Program`, -1 will be returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFragDataLocation.xhtml)","ref":"gl.html#getFragDataLocation/2"},{"type":"function","title":"gl.getFramebufferAttachmentParameteriv/3","doc":"[`gl:getFramebufferAttachmentParameteriv/3`](`getFramebufferAttachmentParameteriv/3`)\nand `glGetNamedFramebufferAttachmentParameteriv` return parameters of\nattachments of a specified framebuffer object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFramebufferAttachmentParameter.xhtml)","ref":"gl.html#getFramebufferAttachmentParameteriv/3"},{"type":"function","title":"gl.getFramebufferParameteriv/2","doc":"[`gl:getFramebufferParameteriv/2`](`getFramebufferParameteriv/2`) and\n`glGetNamedFramebufferParameteriv` query parameters of a specified framebuffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetFramebufferParameter.xhtml)","ref":"gl.html#getFramebufferParameteriv/2"},{"type":"function","title":"gl.getGraphicsResetStatus/0","doc":"Certain events can result in a reset of the GL context. Such a reset causes all\ncontext state to be lost and requires the application to recreate all objects in\nthe affected context.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetGraphicsResetStatus.xhtml)","ref":"gl.html#getGraphicsResetStatus/0"},{"type":"function","title":"gl.getHistogram/5","doc":"[`gl:getHistogram/5`](`getHistogram/5`) returns the current histogram table as a\none-dimensional image with the same width as the histogram. No pixel transfer\noperations are performed on this image, but pixel storage modes that are\napplicable to 1D images are honored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetHistogram.xml)","ref":"gl.html#getHistogram/5"},{"type":"function","title":"gl.getHistogramParameterfv/2","doc":"","ref":"gl.html#getHistogramParameterfv/2"},{"type":"function","title":"gl.getHistogramParameteriv/2","doc":"[`gl:getHistogramParameter()`](`getHistogramParameterfv/2`) is used to query\nparameter values for the current histogram or for a proxy. The histogram state\ninformation may be queried by calling\n[`gl:getHistogramParameter()`](`getHistogramParameterfv/2`) with a `Target` of\n`?GL_HISTOGRAM` (to obtain information for the current histogram table) or\n`?GL_PROXY_HISTOGRAM` (to obtain information from the most recent proxy request)\nand one of the following values for the `Pname` argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetHistogramParameter.xml)","ref":"gl.html#getHistogramParameteriv/2"},{"type":"function","title":"gl.getInteger64i_v/2","doc":"","ref":"gl.html#getInteger64i_v/2"},{"type":"function","title":"gl.getInteger64v/1","doc":"","ref":"gl.html#getInteger64v/1"},{"type":"function","title":"gl.getIntegeri_v/2","doc":"","ref":"gl.html#getIntegeri_v/2"},{"type":"function","title":"gl.getIntegerv/1","doc":"These commands return values for simple state variables in GL. `Pname` is a\nsymbolic constant indicating the state variable to be returned, and `Data` is a\npointer to an array of the indicated type in which to place the returned data.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGet.xhtml)","ref":"gl.html#getIntegerv/1"},{"type":"function","title":"gl.getInternalformati64v/4","doc":"","ref":"gl.html#getInternalformati64v/4"},{"type":"function","title":"gl.getInternalformativ/4","doc":"No documentation available.","ref":"gl.html#getInternalformativ/4"},{"type":"function","title":"gl.getLightfv/2","doc":"","ref":"gl.html#getLightfv/2"},{"type":"function","title":"gl.getLightiv/2","doc":"[`gl:getLight()`](`getLightfv/2`) returns in `Params` the value or values of a\nlight source parameter. `Light` names the light and is a symbolic name of the\nform `?GL_LIGHT` i where i ranges from 0 to the value of `?GL_MAX_LIGHTS` \\- 1.\n`?GL_MAX_LIGHTS` is an implementation dependent constant that is greater than or\nequal to eight. `Pname` specifies one of ten light source parameters, again by\nsymbolic name.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetLight.xml)","ref":"gl.html#getLightiv/2"},{"type":"function","title":"gl.getMapdv/3","doc":"","ref":"gl.html#getMapdv/3"},{"type":"function","title":"gl.getMapfv/3","doc":"","ref":"gl.html#getMapfv/3"},{"type":"function","title":"gl.getMapiv/3","doc":"`glMap1` and `glMap2` define evaluators. [`gl:getMap()`](`getMapdv/3`) returns\nevaluator parameters. `Target` chooses a map, `Query` selects a specific\nparameter, and `V` points to storage where the values will be returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMap.xml)","ref":"gl.html#getMapiv/3"},{"type":"function","title":"gl.getMaterialfv/2","doc":"","ref":"gl.html#getMaterialfv/2"},{"type":"function","title":"gl.getMaterialiv/2","doc":"[`gl:getMaterial()`](`getMaterialfv/2`) returns in `Params` the value or values\nof parameter `Pname` of material `Face`. Six parameters are defined:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMaterial.xml)","ref":"gl.html#getMaterialiv/2"},{"type":"function","title":"gl.getMinmax/5","doc":"[`gl:getMinmax/5`](`getMinmax/5`) returns the accumulated minimum and maximum\npixel values (computed on a per-component basis) in a one-dimensional image of\nwidth 2. The first set of return values are the minima, and the second set of\nreturn values are the maxima. The format of the return values is determined by\n`Format`, and their type is determined by `Types`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMinmax.xml)","ref":"gl.html#getMinmax/5"},{"type":"function","title":"gl.getMinmaxParameterfv/2","doc":"","ref":"gl.html#getMinmaxParameterfv/2"},{"type":"function","title":"gl.getMinmaxParameteriv/2","doc":"[`gl:getMinmaxParameter()`](`getMinmaxParameterfv/2`) retrieves parameters for\nthe current minmax table by setting `Pname` to one of the following values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetMinmaxParameter.xml)","ref":"gl.html#getMinmaxParameteriv/2"},{"type":"function","title":"gl.getMultisamplefv/2","doc":"[`gl:getMultisamplefv/2`](`getMultisamplefv/2`) queries the location of a given\nsample. `Pname` specifies the sample parameter to retrieve and must be\n`?GL_SAMPLE_POSITION`. `Index` corresponds to the sample for which the location\nshould be returned. The sample location is returned as two floating-point values\nin `Val[0]` and `Val[1]`, each between 0 and 1, corresponding to the `X` and `Y`\nlocations respectively in the GL pixel space of that sample. (0.5, 0.5) this\ncorresponds to the pixel center. `Index` must be between zero and the value of\n`?GL_SAMPLES` minus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetMultisample.xhtml)","ref":"gl.html#getMultisamplefv/2"},{"type":"function","title":"gl.getPixelMapfv/2","doc":"","ref":"gl.html#getPixelMapfv/2"},{"type":"function","title":"gl.getPixelMapuiv/2","doc":"","ref":"gl.html#getPixelMapuiv/2"},{"type":"function","title":"gl.getPixelMapusv/2","doc":"See the [`gl:pixelMap()`](`pixelMapfv/3`) reference page for a description of\nthe acceptable values for the `Map` parameter.\n[`gl:getPixelMap()`](`getPixelMapfv/2`) returns in `Data` the contents of the\npixel map specified in `Map`. Pixel maps are used during the execution of\n[`gl:readPixels/7`](`readPixels/7`), [`gl:drawPixels/5`](`drawPixels/5`),\n[`gl:copyPixels/5`](`copyPixels/5`), [`gl:texImage1D/8`](`texImage1D/8`),\n[`gl:texImage2D/9`](`texImage2D/9`), [`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`),\n[`gl:texSubImage3D/11`](`texSubImage3D/11`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`), and\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`). to map color indices, stencil\nindices, color components, and depth components to other values.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetPixelMap.xml)","ref":"gl.html#getPixelMapusv/2"},{"type":"function","title":"gl.getPolygonStipple/0","doc":"[`gl:getPolygonStipple/0`](`getPolygonStipple/0`) returns to `Pattern` a 32×32\npolygon stipple pattern. The pattern is packed into memory as if\n[`gl:readPixels/7`](`readPixels/7`) with both `height` and `width` of 32, `type`\nof `?GL_BITMAP`, and `format` of `?GL_COLOR_INDEX` were called, and the stipple\npattern were stored in an internal 32×32 color index buffer. Unlike\n[`gl:readPixels/7`](`readPixels/7`), however, pixel transfer operations (shift,\noffset, pixel map) are not applied to the returned stipple image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetPolygonStipple.xml)","ref":"gl.html#getPolygonStipple/0"},{"type":"function","title":"gl.getProgramBinary/2","doc":"[`gl:getProgramBinary/2`](`getProgramBinary/2`) returns a binary representation\nof the compiled and linked executable for `Program` into the array of bytes\nwhose address is specified in `Binary`. The maximum number of bytes that may be\nwritten into `Binary` is specified by `BufSize`. If the program binary is\ngreater in size than `BufSize` bytes, then an error is generated, otherwise the\nactual number of bytes written into `Binary` is returned in the variable whose\naddress is given by `Length`. If `Length` is `?NULL`, then no length is\nreturned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramBinary.xhtml)","ref":"gl.html#getProgramBinary/2"},{"type":"function","title":"gl.getProgramInfoLog/2","doc":"[`gl:getProgramInfoLog/2`](`getProgramInfoLog/2`) returns the information log\nfor the specified program object. The information log for a program object is\nmodified when the program object is linked or validated. The string that is\nreturned will be null terminated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramInfoLog.xhtml)","ref":"gl.html#getProgramInfoLog/2"},{"type":"function","title":"gl.getProgramInterfaceiv/3","doc":"[`gl:getProgramInterfaceiv/3`](`getProgramInterfaceiv/3`) queries the property\nof the interface identifed by `ProgramInterface` in `Program`, the property name\nof which is given by `Pname`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramInterface.xhtml)","ref":"gl.html#getProgramInterfaceiv/3"},{"type":"function","title":"gl.getProgramiv/2","doc":"[`gl:getProgram()`](`getProgramiv/2`) returns in `Params` the value of a\nparameter for a specific program object. The following parameters are defined:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgram.xhtml)","ref":"gl.html#getProgramiv/2"},{"type":"function","title":"gl.getProgramPipelineInfoLog/2","doc":"[`gl:getProgramPipelineInfoLog/2`](`getProgramPipelineInfoLog/2`) retrieves the\ninfo log for the program pipeline object `Pipeline`. The info log, including its\nnull terminator, is written into the array of characters whose address is given\nby `InfoLog`. The maximum number of characters that may be written into\n`InfoLog` is given by `BufSize`, and the actual number of characters written\ninto `InfoLog` is returned in the integer whose address is given by `Length`. If\n`Length` is `?NULL`, no length is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramPipelineInfoLog.xhtml)","ref":"gl.html#getProgramPipelineInfoLog/2"},{"type":"function","title":"gl.getProgramPipelineiv/2","doc":"[`gl:getProgramPipelineiv/2`](`getProgramPipelineiv/2`) retrieves the value of a\nproperty of the program pipeline object `Pipeline`. `Pname` specifies the name\nof the parameter whose value to retrieve. The value of the parameter is written\nto the variable whose address is given by `Params`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramPipeline.xhtml)","ref":"gl.html#getProgramPipelineiv/2"},{"type":"function","title":"gl.getProgramResourceIndex/3","doc":"[`gl:getProgramResourceIndex/3`](`getProgramResourceIndex/3`) returns the\nunsigned integer index assigned to a resource named `Name` in the interface type\n`ProgramInterface` of program object `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceIndex.xhtml)","ref":"gl.html#getProgramResourceIndex/3"},{"type":"function","title":"gl.getProgramResourceLocation/3","doc":"[`gl:getProgramResourceLocation/3`](`getProgramResourceLocation/3`) returns the\nlocation assigned to the variable named `Name` in interface `ProgramInterface`\nof program object `Program`. `Program` must be the name of a program that has\nbeen linked successfully. `ProgramInterface` must be one of `?GL_UNIFORM`,\n`?GL_PROGRAM_INPUT`, `?GL_PROGRAM_OUTPUT`, `?GL_VERTEX_SUBROUTINE_UNIFORM`,\n`?GL_TESS_CONTROL_SUBROUTINE_UNIFORM`, `?GL_TESS_EVALUATION_SUBROUTINE_UNIFORM`,\n`?GL_GEOMETRY_SUBROUTINE_UNIFORM`, `?GL_FRAGMENT_SUBROUTINE_UNIFORM`,\n`?GL_COMPUTE_SUBROUTINE_UNIFORM`, or `?GL_TRANSFORM_FEEDBACK_BUFFER`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceLocation.xhtml)","ref":"gl.html#getProgramResourceLocation/3"},{"type":"function","title":"gl.getProgramResourceLocationIndex/3","doc":"[`gl:getProgramResourceLocationIndex/3`](`getProgramResourceLocationIndex/3`)\nreturns the fragment color index assigned to the variable named `Name` in\ninterface `ProgramInterface` of program object `Program`. `Program` must be the\nname of a program that has been linked successfully. `ProgramInterface` must be\n`?GL_PROGRAM_OUTPUT`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceLocationIndex.xhtml)","ref":"gl.html#getProgramResourceLocationIndex/3"},{"type":"function","title":"gl.getProgramResourceName/4","doc":"[`gl:getProgramResourceName/4`](`getProgramResourceName/4`) retrieves the name\nstring assigned to the single active resource with an index of `Index` in the\ninterface `ProgramInterface` of program object `Program`. `Index` must be less\nthan the number of entries in the active resource list for `ProgramInterface`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramResourceName.xhtml)","ref":"gl.html#getProgramResourceName/4"},{"type":"function","title":"gl.getProgramStageiv/3","doc":"[`gl:getProgramStage()`](`getProgramStageiv/3`) queries a parameter of a shader\nstage attached to a program object. `Program` contains the name of the program\nto which the shader is attached. `Shadertype` specifies the stage from which to\nquery the parameter. `Pname` specifies which parameter should be queried. The\nvalue or values of the parameter to be queried is returned in the variable whose\naddress is given in `Values`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetProgramStage.xhtml)","ref":"gl.html#getProgramStageiv/3"},{"type":"function","title":"gl.getQueryBufferObjecti64v/4","doc":"","ref":"gl.html#getQueryBufferObjecti64v/4"},{"type":"function","title":"gl.getQueryBufferObjectiv/4","doc":"","ref":"gl.html#getQueryBufferObjectiv/4"},{"type":"function","title":"gl.getQueryBufferObjectui64v/4","doc":"","ref":"gl.html#getQueryBufferObjectui64v/4"},{"type":"function","title":"gl.getQueryBufferObjectuiv/4","doc":"","ref":"gl.html#getQueryBufferObjectuiv/4"},{"type":"function","title":"gl.getQueryIndexediv/3","doc":"[`gl:getQueryIndexediv/3`](`getQueryIndexediv/3`) returns in `Params` a selected\nparameter of the indexed query object target specified by `Target` and `Index`.\n`Index` specifies the index of the query object target and must be between zero\nand a target-specific maxiumum.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetQueryIndexed.xhtml)","ref":"gl.html#getQueryIndexediv/3"},{"type":"function","title":"gl.getQueryiv/2","doc":"[`gl:getQueryiv/2`](`getQueryiv/2`) returns in `Params` a selected parameter of\nthe query object target specified by `Target`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetQueryiv.xhtml)","ref":"gl.html#getQueryiv/2"},{"type":"function","title":"gl.getQueryObjecti64v/2","doc":"","ref":"gl.html#getQueryObjecti64v/2"},{"type":"function","title":"gl.getQueryObjectiv/2","doc":"","ref":"gl.html#getQueryObjectiv/2"},{"type":"function","title":"gl.getQueryObjectui64v/2","doc":"","ref":"gl.html#getQueryObjectui64v/2"},{"type":"function","title":"gl.getQueryObjectuiv/2","doc":"These commands return a selected parameter of the query object specified by\n`Id`. [`gl:getQueryObject()`](`getQueryObjectiv/2`) returns in `Params` a\nselected parameter of the query object specified by `Id`.\n[`gl:getQueryBufferObject()`](`getQueryObjectiv/2`) returns in `Buffer` a\nselected parameter of the query object specified by `Id`, by writing it to\n`Buffer`'s data store at the byte offset specified by `Offset`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetQueryObject.xhtml)","ref":"gl.html#getQueryObjectuiv/2"},{"type":"function","title":"gl.getRenderbufferParameteriv/2","doc":"[`gl:getRenderbufferParameteriv/2`](`getRenderbufferParameteriv/2`) and\n`glGetNamedRenderbufferParameteriv` query parameters of a specified renderbuffer\nobject.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetRenderbufferParameter.xhtml)","ref":"gl.html#getRenderbufferParameteriv/2"},{"type":"function","title":"gl.getSamplerParameterfv/2","doc":"","ref":"gl.html#getSamplerParameterfv/2"},{"type":"function","title":"gl.getSamplerParameterIiv/2","doc":"","ref":"gl.html#getSamplerParameterIiv/2"},{"type":"function","title":"gl.getSamplerParameterIuiv/2","doc":"","ref":"gl.html#getSamplerParameterIuiv/2"},{"type":"function","title":"gl.getSamplerParameteriv/2","doc":"[`gl:getSamplerParameter()`](`getSamplerParameteriv/2`) returns in `Params` the\nvalue or values of the sampler parameter specified as `Pname`. `Sampler` defines\nthe target sampler, and must be the name of an existing sampler object, returned\nfrom a previous call to [`gl:genSamplers/1`](`genSamplers/1`). `Pname` accepts\nthe same symbols as [`gl:samplerParameter()`](`samplerParameteri/3`), with the\nsame interpretations:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSamplerParameter.xhtml)","ref":"gl.html#getSamplerParameteriv/2"},{"type":"function","title":"gl.getShaderInfoLog/2","doc":"[`gl:getShaderInfoLog/2`](`getShaderInfoLog/2`) returns the information log for\nthe specified shader object. The information log for a shader object is modified\nwhen the shader is compiled. The string that is returned will be null\nterminated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderInfoLog.xhtml)","ref":"gl.html#getShaderInfoLog/2"},{"type":"function","title":"gl.getShaderiv/2","doc":"[`gl:getShader()`](`getShaderiv/2`) returns in `Params` the value of a parameter\nfor a specific shader object. The following parameters are defined:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShader.xhtml)","ref":"gl.html#getShaderiv/2"},{"type":"function","title":"gl.getShaderPrecisionFormat/2","doc":"[`gl:getShaderPrecisionFormat/2`](`getShaderPrecisionFormat/2`) retrieves the\nnumeric range and precision for the implementation's representation of\nquantities in different numeric formats in specified shader type. `ShaderType`\nspecifies the type of shader for which the numeric precision and range is to be\nretrieved and must be one of `?GL_VERTEX_SHADER` or `?GL_FRAGMENT_SHADER`.\n`PrecisionType` specifies the numeric format to query and must be one of\n`?GL_LOW_FLOAT`, `?GL_MEDIUM_FLOAT``?GL_HIGH_FLOAT`, `?GL_LOW_INT`,\n`?GL_MEDIUM_INT`, or `?GL_HIGH_INT`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderPrecisionFormat.xhtml)","ref":"gl.html#getShaderPrecisionFormat/2"},{"type":"function","title":"gl.getShaderSource/2","doc":"[`gl:getShaderSource/2`](`getShaderSource/2`) returns the concatenation of the\nsource code strings from the shader object specified by `Shader`. The source\ncode strings for a shader object are the result of a previous call to\n[`gl:shaderSource/2`](`shaderSource/2`). The string returned by the function\nwill be null terminated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetShaderSource.xhtml)","ref":"gl.html#getShaderSource/2"},{"type":"function","title":"gl.getString/1","doc":"","ref":"gl.html#getString/1"},{"type":"function","title":"gl.getStringi/2","doc":"[`gl:getString/1`](`getString/1`) returns a pointer to a static string\ndescribing some aspect of the current GL connection. `Name` can be one of the\nfollowing:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetString.xhtml)","ref":"gl.html#getStringi/2"},{"type":"function","title":"gl.getSubroutineIndex/3","doc":"[`gl:getSubroutineIndex/3`](`getSubroutineIndex/3`) returns the index of a\nsubroutine uniform within a shader stage attached to a program object. `Program`\ncontains the name of the program to which the shader is attached. `Shadertype`\nspecifies the stage from which to query shader subroutine index. `Name` contains\nthe null-terminated name of the subroutine uniform whose name to query.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSubroutineIndex.xhtml)","ref":"gl.html#getSubroutineIndex/3"},{"type":"function","title":"gl.getSubroutineUniformLocation/3","doc":"[`gl:getSubroutineUniformLocation/3`](`getSubroutineUniformLocation/3`) returns\nthe location of the subroutine uniform variable `Name` in the shader stage of\ntype `Shadertype` attached to `Program`, with behavior otherwise identical to\n[`gl:getUniformLocation/2`](`getUniformLocation/2`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSubroutineUniformLocation.xhtml)","ref":"gl.html#getSubroutineUniformLocation/3"},{"type":"function","title":"gl.getSynciv/3","doc":"[`gl:getSynciv/3`](`getSynciv/3`) retrieves properties of a sync object. `Sync`\nspecifies the name of the sync object whose properties to retrieve.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetSync.xhtml)","ref":"gl.html#getSynciv/3"},{"type":"function","title":"gl.getTexEnvfv/2","doc":"","ref":"gl.html#getTexEnvfv/2"},{"type":"function","title":"gl.getTexEnviv/2","doc":"[`gl:getTexEnv()`](`getTexEnvfv/2`) returns in `Params` selected values of a\ntexture environment that was specified with [`gl:texEnv()`](`texEnvf/3`).\n`Target` specifies a texture environment.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetTexEnv.xml)","ref":"gl.html#getTexEnviv/2"},{"type":"function","title":"gl.getTexGendv/2","doc":"","ref":"gl.html#getTexGendv/2"},{"type":"function","title":"gl.getTexGenfv/2","doc":"","ref":"gl.html#getTexGenfv/2"},{"type":"function","title":"gl.getTexGeniv/2","doc":"[`gl:getTexGen()`](`getTexGendv/2`) returns in `Params` selected parameters of a\ntexture coordinate generation function that was specified using\n[`gl:texGen()`](`texGend/3`). `Coord` names one of the (`s`, `t`, `r`, `q`)\ntexture coordinates, using the symbolic constant `?GL_S`, `?GL_T`, `?GL_R`, or\n`?GL_Q`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glGetTexGen.xml)","ref":"gl.html#getTexGeniv/2"},{"type":"function","title":"gl.getTexImage/5","doc":"[`gl:getTexImage/5`](`getTexImage/5`), `glGetnTexImage` and `glGetTextureImage`\nfunctions return a texture image into `Pixels`. For\n[`gl:getTexImage/5`](`getTexImage/5`) and `glGetnTexImage`, `Target` specifies\nwhether the desired texture image is one specified by\n[`gl:texImage1D/8`](`texImage1D/8`) (`?GL_TEXTURE_1D`),\n[`gl:texImage2D/9`](`texImage2D/9`) (`?GL_TEXTURE_1D_ARRAY`,\n`?GL_TEXTURE_RECTANGLE`, `?GL_TEXTURE_2D` or any of `?GL_TEXTURE_CUBE_MAP_*`),\nor [`gl:texImage3D/10`](`texImage3D/10`) (`?GL_TEXTURE_2D_ARRAY`,\n`?GL_TEXTURE_3D`, `?GL_TEXTURE_CUBE_MAP_ARRAY`). For `glGetTextureImage`,\n`Texture` specifies the texture object name. In addition to types of textures\naccepted by [`gl:getTexImage/5`](`getTexImage/5`) and `glGetnTexImage`, the\nfunction also accepts cube map texture objects (with effective target\n`?GL_TEXTURE_CUBE_MAP`). `Level` specifies the level-of-detail number of the\ndesired image. `Format` and `Type` specify the format and type of the desired\nimage array. See the reference page for [`gl:texImage1D/8`](`texImage1D/8`) for\na description of the acceptable values for the `Format` and `Type` parameters,\nrespectively. For glGetnTexImage and glGetTextureImage functions, bufSize tells\nthe size of the buffer to receive the retrieved pixel data. `glGetnTexImage` and\n`glGetTextureImage` do not write more than `BufSize` bytes into `Pixels`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTexImage.xhtml)","ref":"gl.html#getTexImage/5"},{"type":"function","title":"gl.getTexLevelParameterfv/3","doc":"","ref":"gl.html#getTexLevelParameterfv/3"},{"type":"function","title":"gl.getTexLevelParameteriv/3","doc":"[`gl:getTexLevelParameterfv/3`](`getTexLevelParameterfv/3`),\n[`gl:getTexLevelParameteriv/3`](`getTexLevelParameterfv/3`),\n`glGetTextureLevelParameterfv` and `glGetTextureLevelParameteriv` return in\n`Params` texture parameter values for a specific level-of-detail value,\nspecified as `Level`. For the first two functions, `Target` defines the target\ntexture, either `?GL_TEXTURE_1D`, `?GL_TEXTURE_2D`, `?GL_TEXTURE_3D`,\n`?GL_PROXY_TEXTURE_1D`, `?GL_PROXY_TEXTURE_2D`, `?GL_PROXY_TEXTURE_3D`,\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_X`, `?GL_TEXTURE_CUBE_MAP_NEGATIVE_X`,\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_Y`, `?GL_TEXTURE_CUBE_MAP_NEGATIVE_Y`,\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_Z`, `?GL_TEXTURE_CUBE_MAP_NEGATIVE_Z`, or\n`?GL_PROXY_TEXTURE_CUBE_MAP`. The remaining two take a `Texture` argument which\nspecifies the name of the texture object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTexLevelParameter.xhtml)","ref":"gl.html#getTexLevelParameteriv/3"},{"type":"function","title":"gl.getTexParameterfv/2","doc":"","ref":"gl.html#getTexParameterfv/2"},{"type":"function","title":"gl.getTexParameterIiv/2","doc":"","ref":"gl.html#getTexParameterIiv/2"},{"type":"function","title":"gl.getTexParameterIuiv/2","doc":"","ref":"gl.html#getTexParameterIuiv/2"},{"type":"function","title":"gl.getTexParameteriv/2","doc":"[`gl:getTexParameter()`](`getTexParameterfv/2`) and `glGetTextureParameter`\nreturn in `Params` the value or values of the texture parameter specified as\n`Pname`. `Target` defines the target texture. `?GL_TEXTURE_1D`,\n`?GL_TEXTURE_2D`, `?GL_TEXTURE_3D`, `?GL_TEXTURE_1D_ARRAY`,\n`?GL_TEXTURE_2D_ARRAY`, `?GL_TEXTURE_RECTANGLE`, `?GL_TEXTURE_CUBE_MAP`,\n`?GL_TEXTURE_CUBE_MAP_ARRAY`, `?GL_TEXTURE_2D_MULTISAMPLE`, or\n`?GL_TEXTURE_2D_MULTISAMPLE_ARRAY` specify one-, two-, or three-dimensional,\none-dimensional array, two-dimensional array, rectangle, cube-mapped or\ncube-mapped array, two-dimensional multisample, or two-dimensional multisample\narray texturing, respectively. `Pname` accepts the same symbols as\n[`gl:texParameter()`](`texParameterf/3`), with the same interpretations:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTexParameter.xhtml)","ref":"gl.html#getTexParameteriv/2"},{"type":"function","title":"gl.getTransformFeedbackVarying/3","doc":"Information about the set of varying variables in a linked program that will be\ncaptured during transform feedback may be retrieved by calling\n[`gl:getTransformFeedbackVarying/3`](`getTransformFeedbackVarying/3`).\n[`gl:getTransformFeedbackVarying/3`](`getTransformFeedbackVarying/3`) provides\ninformation about the varying variable selected by `Index`. An `Index` of 0\nselects the first varying variable specified in the `Varyings` array passed to\n[`gl:transformFeedbackVaryings/3`](`transformFeedbackVaryings/3`), and an\n`Index` of the value of `?GL_TRANSFORM_FEEDBACK_VARYINGS` minus one selects the\nlast such variable.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetTransformFeedbackVarying.xhtml)","ref":"gl.html#getTransformFeedbackVarying/3"},{"type":"function","title":"gl.getUniformBlockIndex/2","doc":"[`gl:getUniformBlockIndex/2`](`getUniformBlockIndex/2`) retrieves the index of a\nuniform block within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformBlockIndex.xhtml)","ref":"gl.html#getUniformBlockIndex/2"},{"type":"function","title":"gl.getUniformdv/2","doc":"","ref":"gl.html#getUniformdv/2"},{"type":"function","title":"gl.getUniformfv/2","doc":"","ref":"gl.html#getUniformfv/2"},{"type":"function","title":"gl.getUniformIndices/2","doc":"[`gl:getUniformIndices/2`](`getUniformIndices/2`) retrieves the indices of a\nnumber of uniforms within `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformIndices.xhtml)","ref":"gl.html#getUniformIndices/2"},{"type":"function","title":"gl.getUniformiv/2","doc":"","ref":"gl.html#getUniformiv/2"},{"type":"function","title":"gl.getUniformLocation/2","doc":"`glGetUniformLocation `returns an integer that represents the location of a\nspecific uniform variable within a program object. `Name` must be a null\nterminated string that contains no white space. `Name` must be an active uniform\nvariable name in `Program` that is not a structure, an array of structures, or a\nsubcomponent of a vector or a matrix. This function returns -1 if `Name` does\nnot correspond to an active uniform variable in `Program`, if `Name` starts with\nthe reserved prefix \"gl\\_\", or if `Name` is associated with an atomic counter or\na named uniform block.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformLocation.xhtml)","ref":"gl.html#getUniformLocation/2"},{"type":"function","title":"gl.getUniformSubroutineuiv/2","doc":"[`gl:getUniformSubroutine()`](`getUniformSubroutineuiv/2`) retrieves the value\nof the subroutine uniform at location `Location` for shader stage `Shadertype`\nof the current program. `Location` must be less than the value of\n`?GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS` for the shader currently in use at\nshader stage `Shadertype`. The value of the subroutine uniform is returned in\n`Values`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniformSubroutine.xhtml)","ref":"gl.html#getUniformSubroutineuiv/2"},{"type":"function","title":"gl.getUniformuiv/2","doc":"[`gl:getUniform()`](`getUniformfv/2`) and `glGetnUniform` return in `Params` the\nvalue(s) of the specified uniform variable. The type of the uniform variable\nspecified by `Location` determines the number of values returned. If the uniform\nvariable is defined in the shader as a boolean, int, or float, a single value\nwill be returned. If it is defined as a vec2, ivec2, or bvec2, two values will\nbe returned. If it is defined as a vec3, ivec3, or bvec3, three values will be\nreturned, and so on. To query values stored in uniform variables declared as\narrays, call [`gl:getUniform()`](`getUniformfv/2`) for each element of the\narray. To query values stored in uniform variables declared as structures, call\n[`gl:getUniform()`](`getUniformfv/2`) for each field in the structure. The\nvalues for uniform variables declared as a matrix will be returned in column\nmajor order.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetUniform.xhtml)","ref":"gl.html#getUniformuiv/2"},{"type":"function","title":"gl.getVertexAttribdv/2","doc":"","ref":"gl.html#getVertexAttribdv/2"},{"type":"function","title":"gl.getVertexAttribfv/2","doc":"","ref":"gl.html#getVertexAttribfv/2"},{"type":"function","title":"gl.getVertexAttribIiv/2","doc":"","ref":"gl.html#getVertexAttribIiv/2"},{"type":"function","title":"gl.getVertexAttribIuiv/2","doc":"","ref":"gl.html#getVertexAttribIuiv/2"},{"type":"function","title":"gl.getVertexAttribiv/2","doc":"[`gl:getVertexAttrib()`](`getVertexAttribdv/2`) returns in `Params` the value of\na generic vertex attribute parameter. The generic vertex attribute to be queried\nis specified by `Index`, and the parameter to be queried is specified by\n`Pname`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glGetVertexAttrib.xhtml)","ref":"gl.html#getVertexAttribiv/2"},{"type":"function","title":"gl.getVertexAttribLdv/2","doc":"","ref":"gl.html#getVertexAttribLdv/2"},{"type":"function","title":"gl.hint/2","doc":"Certain aspects of GL behavior, when there is room for interpretation, can be\ncontrolled with hints. A hint is specified with two arguments. `Target` is a\nsymbolic constant indicating the behavior to be controlled, and `Mode` is\nanother symbolic constant indicating the desired behavior. The initial value for\neach `Target` is `?GL_DONT_CARE`. `Mode` can be one of the following:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glHint.xhtml)","ref":"gl.html#hint/2"},{"type":"function","title":"gl.histogram/4","doc":"When `?GL_HISTOGRAM` is enabled, RGBA color components are converted to\nhistogram table indices by clamping to the range \\[0,1], multiplying by the\nwidth of the histogram table, and rounding to the nearest integer. The table\nentries selected by the RGBA indices are then incremented. (If the internal\nformat of the histogram table includes luminance, then the index derived from\nthe R color component determines the luminance table entry to be incremented.)\nIf a histogram table entry is incremented beyond its maximum value, then its\nvalue becomes undefined. (This is not an error.)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glHistogram.xml)","ref":"gl.html#histogram/4"},{"type":"function","title":"gl.indexd/1","doc":"","ref":"gl.html#indexd/1"},{"type":"function","title":"gl.indexdv/1","doc":"","ref":"gl.html#indexdv/1"},{"type":"function","title":"gl.indexf/1","doc":"","ref":"gl.html#indexf/1"},{"type":"function","title":"gl.indexfv/1","doc":"","ref":"gl.html#indexfv/1"},{"type":"function","title":"gl.indexi/1","doc":"","ref":"gl.html#indexi/1"},{"type":"function","title":"gl.indexiv/1","doc":"","ref":"gl.html#indexiv/1"},{"type":"function","title":"gl.indexMask/1","doc":"[`gl:indexMask/1`](`indexMask/1`) controls the writing of individual bits in the\ncolor index buffers. The least significant n bits of `Mask`, where n is the\nnumber of bits in a color index buffer, specify a mask. Where a 1 (one) appears\nin the mask, it's possible to write to the corresponding bit in the color index\nbuffer (or buffers). Where a 0 (zero) appears, the corresponding bit is\nwrite-protected.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIndexMask.xml)","ref":"gl.html#indexMask/1"},{"type":"function","title":"gl.indexPointer/3","doc":"[`gl:indexPointer/3`](`indexPointer/3`) specifies the location and data format\nof an array of color indexes to use when rendering. `Type` specifies the data\ntype of each color index and `Stride` specifies the byte stride from one color\nindex to the next, allowing vertices and attributes to be packed into a single\narray or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIndexPointer.xml)","ref":"gl.html#indexPointer/3"},{"type":"function","title":"gl.indexs/1","doc":"","ref":"gl.html#indexs/1"},{"type":"function","title":"gl.indexsv/1","doc":"","ref":"gl.html#indexsv/1"},{"type":"function","title":"gl.indexub/1","doc":"","ref":"gl.html#indexub/1"},{"type":"function","title":"gl.indexubv/1","doc":"[`gl:index()`](`indexd/1`) updates the current (single-valued) color index. It\ntakes one argument, the new value for the current color index.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIndex.xml)","ref":"gl.html#indexubv/1"},{"type":"function","title":"gl.initNames/0","doc":"The name stack is used during selection mode to allow sets of rendering commands\nto be uniquely identified. It consists of an ordered set of unsigned integers.\n[`gl:initNames/0`](`initNames/0`) causes the name stack to be initialized to its\ndefault empty state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glInitNames.xml)","ref":"gl.html#initNames/0"},{"type":"function","title":"gl.interleavedArrays/3","doc":"[`gl:interleavedArrays/3`](`interleavedArrays/3`) lets you specify and enable\nindividual color, normal, texture and vertex arrays whose elements are part of a\nlarger aggregate array element. For some implementations, this is more efficient\nthan specifying the arrays separately.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glInterleavedArrays.xml)","ref":"gl.html#interleavedArrays/3"},{"type":"function","title":"gl.invalidateBufferData/1","doc":"[`gl:invalidateBufferData/1`](`invalidateBufferData/1`) invalidates all of the\ncontent of the data store of a buffer object. After invalidation, the content of\nthe buffer's data store becomes undefined.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateBufferData.xhtml)","ref":"gl.html#invalidateBufferData/1"},{"type":"function","title":"gl.invalidateBufferSubData/3","doc":"[`gl:invalidateBufferSubData/3`](`invalidateBufferSubData/3`) invalidates all or\npart of the content of the data store of a buffer object. After invalidation,\nthe content of the specified range of the buffer's data store becomes undefined.\nThe start of the range is given by `Offset` and its size is given by `Length`,\nboth measured in basic machine units.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateBufferSubData.xhtml)","ref":"gl.html#invalidateBufferSubData/3"},{"type":"function","title":"gl.invalidateFramebuffer/2","doc":"[`gl:invalidateFramebuffer/2`](`invalidateFramebuffer/2`) and\n`glInvalidateNamedFramebufferData` invalidate the entire contents of a specified\nset of attachments of a framebuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateFramebuffer.xhtml)","ref":"gl.html#invalidateFramebuffer/2"},{"type":"function","title":"gl.invalidateSubFramebuffer/6","doc":"[`gl:invalidateSubFramebuffer/6`](`invalidateSubFramebuffer/6`) and\n`glInvalidateNamedFramebufferSubData` invalidate the contents of a specified\nregion of a specified set of attachments of a framebuffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateSubFramebuffer.xhtml)","ref":"gl.html#invalidateSubFramebuffer/6"},{"type":"function","title":"gl.invalidateTexImage/2","doc":"[`gl:invalidateTexSubImage/8`](`invalidateTexSubImage/8`) invalidates all of a\ntexture image. `Texture` and `Level` indicated which texture image is being\ninvalidated. After this command, data in the texture image has undefined values.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateTexImage.xhtml)","ref":"gl.html#invalidateTexImage/2"},{"type":"function","title":"gl.invalidateTexSubImage/8","doc":"[`gl:invalidateTexSubImage/8`](`invalidateTexSubImage/8`) invalidates all or\npart of a texture image. `Texture` and `Level` indicated which texture image is\nbeing invalidated. After this command, data in that subregion have undefined\nvalues. `Xoffset`, `Yoffset`, `Zoffset`, `Width`, `Height`, and `Depth` are\ninterpreted as they are in [`gl:texSubImage3D/11`](`texSubImage3D/11`). For\ntexture targets that don't have certain dimensions, this command treats those\ndimensions as having a size of 1. For example, to invalidate a portion of a two-\ndimensional texture, the application would use `Zoffset` equal to zero and\n`Depth` equal to one. Cube map textures are treated as an array of six slices in\nthe z-dimension, where a value of `Zoffset` is interpreted as specifying face\n`?GL_TEXTURE_CUBE_MAP_POSITIVE_X` \\+ `Zoffset`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glInvalidateTexSubImage.xhtml)","ref":"gl.html#invalidateTexSubImage/8"},{"type":"function","title":"gl.isBuffer/1","doc":"[`gl:isBuffer/1`](`isBuffer/1`) returns `?GL_TRUE` if `Buffer` is currently the\nname of a buffer object. If `Buffer` is zero, or is a non-zero value that is not\ncurrently the name of a buffer object, or if an error occurs,\n[`gl:isBuffer/1`](`isBuffer/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsBuffer.xhtml)","ref":"gl.html#isBuffer/1"},{"type":"function","title":"gl.isEnabled/1","doc":"","ref":"gl.html#isEnabled/1"},{"type":"function","title":"gl.isEnabledi/2","doc":"[`gl:isEnabled/1`](`isEnabled/1`) returns `?GL_TRUE` if `Cap` is an enabled\ncapability and returns `?GL_FALSE` otherwise. Boolean states that are indexed\nmay be tested with [`gl:isEnabledi/2`](`isEnabled/1`). For\n[`gl:isEnabledi/2`](`isEnabled/1`), `Index` specifies the index of the\ncapability to test. `Index` must be between zero and the count of indexed\ncapabilities for `Cap`. Initially all capabilities except `?GL_DITHER` are\ndisabled; `?GL_DITHER` is initially enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsEnabled.xhtml)","ref":"gl.html#isEnabledi/2"},{"type":"function","title":"gl.isFramebuffer/1","doc":"[`gl:isFramebuffer/1`](`isFramebuffer/1`) returns `?GL_TRUE` if `Framebuffer` is\ncurrently the name of a framebuffer object. If `Framebuffer` is zero, or if\n`?framebuffer` is not the name of a framebuffer object, or if an error occurs,\n[`gl:isFramebuffer/1`](`isFramebuffer/1`) returns `?GL_FALSE`. If `Framebuffer`\nis a name returned by [`gl:genFramebuffers/1`](`genFramebuffers/1`), by that has\nnot yet been bound through a call to\n[`gl:bindFramebuffer/2`](`bindFramebuffer/2`), then the name is not a\nframebuffer object and [`gl:isFramebuffer/1`](`isFramebuffer/1`) returns\n`?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsFramebuffer.xhtml)","ref":"gl.html#isFramebuffer/1"},{"type":"function","title":"gl.isList/1","doc":"[`gl:isList/1`](`isList/1`) returns `?GL_TRUE` if `List` is the name of a\ndisplay list and returns `?GL_FALSE` if it is not, or if an error occurs.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glIsList.xml)","ref":"gl.html#isList/1"},{"type":"function","title":"gl.isProgram/1","doc":"[`gl:isProgram/1`](`isProgram/1`) returns `?GL_TRUE` if `Program` is the name of\na program object previously created with\n[`gl:createProgram/0`](`createProgram/0`) and not yet deleted with\n[`gl:deleteProgram/1`](`deleteProgram/1`). If `Program` is zero or a non-zero\nvalue that is not the name of a program object, or if an error occurs,\n[`gl:isProgram/1`](`isProgram/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsProgram.xhtml)","ref":"gl.html#isProgram/1"},{"type":"function","title":"gl.isProgramPipeline/1","doc":"[`gl:isProgramPipeline/1`](`isProgramPipeline/1`) returns `?GL_TRUE` if\n`Pipeline` is currently the name of a program pipeline object. If `Pipeline` is\nzero, or if `?pipeline` is not the name of a program pipeline object, or if an\nerror occurs, [`gl:isProgramPipeline/1`](`isProgramPipeline/1`) returns\n`?GL_FALSE`. If `Pipeline` is a name returned by\n[`gl:genProgramPipelines/1`](`genProgramPipelines/1`), but that has not yet been\nbound through a call to [`gl:bindProgramPipeline/1`](`bindProgramPipeline/1`),\nthen the name is not a program pipeline object and\n[`gl:isProgramPipeline/1`](`isProgramPipeline/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsProgramPipeline.xhtml)","ref":"gl.html#isProgramPipeline/1"},{"type":"function","title":"gl.isQuery/1","doc":"[`gl:isQuery/1`](`isQuery/1`) returns `?GL_TRUE` if `Id` is currently the name\nof a query object. If `Id` is zero, or is a non-zero value that is not currently\nthe name of a query object, or if an error occurs, [`gl:isQuery/1`](`isQuery/1`)\nreturns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsQuery.xhtml)","ref":"gl.html#isQuery/1"},{"type":"function","title":"gl.isRenderbuffer/1","doc":"[`gl:isRenderbuffer/1`](`isRenderbuffer/1`) returns `?GL_TRUE` if `Renderbuffer`\nis currently the name of a renderbuffer object. If `Renderbuffer` is zero, or if\n`Renderbuffer` is not the name of a renderbuffer object, or if an error occurs,\n[`gl:isRenderbuffer/1`](`isRenderbuffer/1`) returns `?GL_FALSE`. If\n`Renderbuffer` is a name returned by\n[`gl:genRenderbuffers/1`](`genRenderbuffers/1`), by that has not yet been bound\nthrough a call to [`gl:bindRenderbuffer/2`](`bindRenderbuffer/2`) or\n[`gl:framebufferRenderbuffer/4`](`framebufferRenderbuffer/4`), then the name is\nnot a renderbuffer object and [`gl:isRenderbuffer/1`](`isRenderbuffer/1`)\nreturns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsRenderbuffer.xhtml)","ref":"gl.html#isRenderbuffer/1"},{"type":"function","title":"gl.isSampler/1","doc":"[`gl:isSampler/1`](`isSampler/1`) returns `?GL_TRUE` if `Id` is currently the\nname of a sampler object. If `Id` is zero, or is a non-zero value that is not\ncurrently the name of a sampler object, or if an error occurs,\n[`gl:isSampler/1`](`isSampler/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsSampler.xhtml)","ref":"gl.html#isSampler/1"},{"type":"function","title":"gl.isShader/1","doc":"[`gl:isShader/1`](`isShader/1`) returns `?GL_TRUE` if `Shader` is the name of a\nshader object previously created with [`gl:createShader/1`](`createShader/1`)\nand not yet deleted with [`gl:deleteShader/1`](`deleteShader/1`). If `Shader` is\nzero or a non-zero value that is not the name of a shader object, or if an error\noccurs, `glIsShader `returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsShader.xhtml)","ref":"gl.html#isShader/1"},{"type":"function","title":"gl.isSync/1","doc":"[`gl:isSync/1`](`isSync/1`) returns `?GL_TRUE` if `Sync` is currently the name\nof a sync object. If `Sync` is not the name of a sync object, or if an error\noccurs, [`gl:isSync/1`](`isSync/1`) returns `?GL_FALSE`. Note that zero is not\nthe name of a sync object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsSync.xhtml)","ref":"gl.html#isSync/1"},{"type":"function","title":"gl.isTexture/1","doc":"[`gl:isTexture/1`](`isTexture/1`) returns `?GL_TRUE` if `Texture` is currently\nthe name of a texture. If `Texture` is zero, or is a non-zero value that is not\ncurrently the name of a texture, or if an error occurs,\n[`gl:isTexture/1`](`isTexture/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsTexture.xhtml)","ref":"gl.html#isTexture/1"},{"type":"function","title":"gl.isTransformFeedback/1","doc":"[`gl:isTransformFeedback/1`](`isTransformFeedback/1`) returns `?GL_TRUE` if `Id`\nis currently the name of a transform feedback object. If `Id` is zero, or if\n`?id` is not the name of a transform feedback object, or if an error occurs,\n[`gl:isTransformFeedback/1`](`isTransformFeedback/1`) returns `?GL_FALSE`. If\n`Id` is a name returned by\n[`gl:genTransformFeedbacks/1`](`genTransformFeedbacks/1`), but that has not yet\nbeen bound through a call to\n[`gl:bindTransformFeedback/2`](`bindTransformFeedback/2`), then the name is not\na transform feedback object and\n[`gl:isTransformFeedback/1`](`isTransformFeedback/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsTransformFeedback.xhtml)","ref":"gl.html#isTransformFeedback/1"},{"type":"function","title":"gl.isVertexArray/1","doc":"[`gl:isVertexArray/1`](`isVertexArray/1`) returns `?GL_TRUE` if `Array` is\ncurrently the name of a vertex array object. If `Array` is zero, or if `Array`\nis not the name of a vertex array object, or if an error occurs,\n[`gl:isVertexArray/1`](`isVertexArray/1`) returns `?GL_FALSE`. If `Array` is a\nname returned by [`gl:genVertexArrays/1`](`genVertexArrays/1`), by that has not\nyet been bound through a call to [`gl:bindVertexArray/1`](`bindVertexArray/1`),\nthen the name is not a vertex array object and\n[`gl:isVertexArray/1`](`isVertexArray/1`) returns `?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glIsVertexArray.xhtml)","ref":"gl.html#isVertexArray/1"},{"type":"function","title":"gl.lightf/3","doc":"","ref":"gl.html#lightf/3"},{"type":"function","title":"gl.lightfv/3","doc":"","ref":"gl.html#lightfv/3"},{"type":"function","title":"gl.lighti/3","doc":"","ref":"gl.html#lighti/3"},{"type":"function","title":"gl.lightiv/3","doc":"[`gl:light()`](`lightf/3`) sets the values of individual light source\nparameters. `Light` names the light and is a symbolic name of the form\n`?GL_LIGHT` i, where i ranges from 0 to the value of `?GL_MAX_LIGHTS` \\- 1.\n`Pname` specifies one of ten light source parameters, again by symbolic name.\n`Params` is either a single value or a pointer to an array that contains the new\nvalues.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLight.xml)","ref":"gl.html#lightiv/3"},{"type":"function","title":"gl.lightModelf/2","doc":"","ref":"gl.html#lightModelf/2"},{"type":"function","title":"gl.lightModelfv/2","doc":"","ref":"gl.html#lightModelfv/2"},{"type":"function","title":"gl.lightModeli/2","doc":"","ref":"gl.html#lightModeli/2"},{"type":"function","title":"gl.lightModeliv/2","doc":"[`gl:lightModel()`](`lightModelf/2`) sets the lighting model parameter. `Pname`\nnames a parameter and `Params` gives the new value. There are three lighting\nmodel parameters:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLightModel.xml)","ref":"gl.html#lightModeliv/2"},{"type":"function","title":"gl.lineStipple/2","doc":"Line stippling masks out certain fragments produced by rasterization; those\nfragments will not be drawn. The masking is achieved by using three parameters:\nthe 16-bit line stipple pattern `Pattern`, the repeat count `Factor`, and an\ninteger stipple counter s.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLineStipple.xml)","ref":"gl.html#lineStipple/2"},{"type":"function","title":"gl.lineWidth/1","doc":"[`gl:lineWidth/1`](`lineWidth/1`) specifies the rasterized width of both aliased\nand antialiased lines. Using a line width other than 1 has different effects,\ndepending on whether line antialiasing is enabled. To enable and disable line\nantialiasing, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_LINE_SMOOTH`. Line antialiasing is initially disabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLineWidth.xhtml)","ref":"gl.html#lineWidth/1"},{"type":"function","title":"gl.linkProgram/1","doc":"[`gl:linkProgram/1`](`linkProgram/1`) links the program object specified by\n`Program`. If any shader objects of type `?GL_VERTEX_SHADER` are attached to\n`Program`, they will be used to create an executable that will run on the\nprogrammable vertex processor. If any shader objects of type\n`?GL_GEOMETRY_SHADER` are attached to `Program`, they will be used to create an\nexecutable that will run on the programmable geometry processor. If any shader\nobjects of type `?GL_FRAGMENT_SHADER` are attached to `Program`, they will be\nused to create an executable that will run on the programmable fragment\nprocessor.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLinkProgram.xhtml)","ref":"gl.html#linkProgram/1"},{"type":"function","title":"gl.listBase/1","doc":"[`gl:callLists/1`](`callLists/1`) specifies an array of offsets. Display-list\nnames are generated by adding `Base` to each offset. Names that reference valid\ndisplay lists are executed; the others are ignored.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glListBase.xml)","ref":"gl.html#listBase/1"},{"type":"function","title":"gl.loadIdentity/0","doc":"[`gl:loadIdentity/0`](`loadIdentity/0`) replaces the current matrix with the\nidentity matrix. It is semantically equivalent to calling\n[`gl:loadMatrix()`](`loadMatrixd/1`) with the identity matrix\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadIdentity.xml)","ref":"gl.html#loadIdentity/0"},{"type":"function","title":"gl.loadMatrixd/1","doc":"","ref":"gl.html#loadMatrixd/1"},{"type":"function","title":"gl.loadMatrixf/1","doc":"[`gl:loadMatrix()`](`loadMatrixd/1`) replaces the current matrix with the one\nwhose elements are specified by `M`. The current matrix is the projection\nmatrix, modelview matrix, or texture matrix, depending on the current matrix\nmode (see [`gl:matrixMode/1`](`matrixMode/1`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadMatrix.xml)","ref":"gl.html#loadMatrixf/1"},{"type":"function","title":"gl.loadName/1","doc":"The name stack is used during selection mode to allow sets of rendering commands\nto be uniquely identified. It consists of an ordered set of unsigned integers\nand is initially empty.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadName.xml)","ref":"gl.html#loadName/1"},{"type":"function","title":"gl.loadTransposeMatrixd/1","doc":"","ref":"gl.html#loadTransposeMatrixd/1"},{"type":"function","title":"gl.loadTransposeMatrixf/1","doc":"[`gl:loadTransposeMatrix()`](`loadTransposeMatrixf/1`) replaces the current\nmatrix with the one whose elements are specified by `M`. The current matrix is\nthe projection matrix, modelview matrix, or texture matrix, depending on the\ncurrent matrix mode (see [`gl:matrixMode/1`](`matrixMode/1`)).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glLoadTransposeMatrix.xml)","ref":"gl.html#loadTransposeMatrixf/1"},{"type":"function","title":"gl.logicOp/1","doc":"[`gl:logicOp/1`](`logicOp/1`) specifies a logical operation that, when enabled,\nis applied between the incoming RGBA color and the RGBA color at the\ncorresponding location in the frame buffer. To enable or disable the logical\noperation, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nusing the symbolic constant `?GL_COLOR_LOGIC_OP`. The initial value is disabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glLogicOp.xhtml)","ref":"gl.html#logicOp/1"},{"type":"function","title":"gl.map1d/6","doc":"","ref":"gl.html#map1d/6"},{"type":"function","title":"gl.map1f/6","doc":"Evaluators provide a way to use polynomial or rational polynomial mapping to\nproduce vertices, normals, texture coordinates, and colors. The values produced\nby an evaluator are sent to further stages of GL processing just as if they had\nbeen presented using [`gl:vertex()`](`vertex2d/2`),\n[`gl:normal()`](`normal3b/3`), [`gl:texCoord()`](`texCoord1d/1`), and\n[`gl:color()`](`color3b/3`) commands, except that the generated values do not\nupdate the current normal, texture coordinates, or color.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMap1.xml)","ref":"gl.html#map1f/6"},{"type":"function","title":"gl.map2d/10","doc":"","ref":"gl.html#map2d/10"},{"type":"function","title":"gl.map2f/10","doc":"Evaluators provide a way to use polynomial or rational polynomial mapping to\nproduce vertices, normals, texture coordinates, and colors. The values produced\nby an evaluator are sent on to further stages of GL processing just as if they\nhad been presented using [`gl:vertex()`](`vertex2d/2`),\n[`gl:normal()`](`normal3b/3`), [`gl:texCoord()`](`texCoord1d/1`), and\n[`gl:color()`](`color3b/3`) commands, except that the generated values do not\nupdate the current normal, texture coordinates, or color.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMap2.xml)","ref":"gl.html#map2f/10"},{"type":"function","title":"gl.mapGrid1d/3","doc":"","ref":"gl.html#mapGrid1d/3"},{"type":"function","title":"gl.mapGrid1f/3","doc":"","ref":"gl.html#mapGrid1f/3"},{"type":"function","title":"gl.mapGrid2d/6","doc":"","ref":"gl.html#mapGrid2d/6"},{"type":"function","title":"gl.mapGrid2f/6","doc":"[`gl:mapGrid()`](`mapGrid1d/3`) and [`gl:evalMesh()`](`evalMesh1/3`) are used\ntogether to efficiently generate and evaluate a series of evenly-spaced map\ndomain values. [`gl:evalMesh()`](`evalMesh1/3`) steps through the integer domain\nof a one- or two-dimensional grid, whose range is the domain of the evaluation\nmaps specified by `glMap1` and `glMap2`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMapGrid.xml)","ref":"gl.html#mapGrid2f/6"},{"type":"function","title":"gl.materialf/3","doc":"","ref":"gl.html#materialf/3"},{"type":"function","title":"gl.materialfv/3","doc":"","ref":"gl.html#materialfv/3"},{"type":"function","title":"gl.materiali/3","doc":"","ref":"gl.html#materiali/3"},{"type":"function","title":"gl.materialiv/3","doc":"[`gl:material()`](`materialf/3`) assigns values to material parameters. There\nare two matched sets of material parameters. One, the `front-facing` set, is\nused to shade points, lines, bitmaps, and all polygons (when two-sided lighting\nis disabled), or just front-facing polygons (when two-sided lighting is\nenabled). The other set, `back-facing`, is used to shade back-facing polygons\nonly when two-sided lighting is enabled. Refer to the\n[`gl:lightModel()`](`lightModelf/2`) reference page for details concerning one-\nand two-sided lighting calculations.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMaterial.xml)","ref":"gl.html#materialiv/3"},{"type":"function","title":"gl.matrixMode/1","doc":"[`gl:matrixMode/1`](`matrixMode/1`) sets the current matrix mode. `Mode` can\nassume one of four values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMatrixMode.xml)","ref":"gl.html#matrixMode/1"},{"type":"function","title":"gl.memoryBarrier/1","doc":"","ref":"gl.html#memoryBarrier/1"},{"type":"function","title":"gl.memoryBarrierByRegion/1","doc":"[`gl:memoryBarrier/1`](`memoryBarrier/1`) defines a barrier ordering the memory\ntransactions issued prior to the command relative to those issued after the\nbarrier. For the purposes of this ordering, memory transactions performed by\nshaders are considered to be issued by the rendering command that triggered the\nexecution of the shader. `Barriers` is a bitfield indicating the set of\noperations that are synchronized with shader stores; the bits used in `Barriers`\nare as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMemoryBarrier.xhtml)","ref":"gl.html#memoryBarrierByRegion/1"},{"type":"function","title":"gl.minmax/3","doc":"When `?GL_MINMAX` is enabled, the RGBA components of incoming pixels are\ncompared to the minimum and maximum values for each component, which are stored\nin the two-element minmax table. (The first element stores the minima, and the\nsecond element stores the maxima.) If a pixel component is greater than the\ncorresponding component in the maximum element, then the maximum element is\nupdated with the pixel component value. If a pixel component is less than the\ncorresponding component in the minimum element, then the minimum element is\nupdated with the pixel component value. (In both cases, if the internal format\nof the minmax table includes luminance, then the R color component of incoming\npixels is used for comparison.) The contents of the minmax table may be\nretrieved at a later time by calling [`gl:getMinmax/5`](`getMinmax/5`). The\nminmax operation is enabled or disabled by calling [`gl:enable/1`](`enable/1`)\nor [`gl:disable/1`](`enable/1`), respectively, with an argument of `?GL_MINMAX`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMinmax.xml)","ref":"gl.html#minmax/3"},{"type":"function","title":"gl.minSampleShading/1","doc":"[`gl:minSampleShading/1`](`minSampleShading/1`) specifies the rate at which\nsamples are shaded within a covered pixel. Sample-rate shading is enabled by\ncalling [`gl:enable/1`](`enable/1`) with the parameter `?GL_SAMPLE_SHADING`. If\n`?GL_MULTISAMPLE` or `?GL_SAMPLE_SHADING` is disabled, sample shading has no\neffect. Otherwise, an implementation must provide at least as many unique color\nvalues for each covered fragment as specified by `Value` times `Samples` where\n`Samples` is the value of `?GL_SAMPLES` for the current framebuffer. At least 1\nsample for each covered fragment is generated.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMinSampleShading.xhtml)","ref":"gl.html#minSampleShading/1"},{"type":"function","title":"gl.multiDrawArrays/3","doc":"[`gl:multiDrawArrays/3`](`multiDrawArrays/3`) specifies multiple sets of\ngeometric primitives with very few subroutine calls. Instead of calling a GL\nprocedure to pass each individual vertex, normal, texture coordinate, edge flag,\nor color, you can prespecify separate arrays of vertices, normals, and colors\nand use them to construct a sequence of primitives with a single call to\n[`gl:multiDrawArrays/3`](`multiDrawArrays/3`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMultiDrawArrays.xhtml)","ref":"gl.html#multiDrawArrays/3"},{"type":"function","title":"gl.multiDrawArraysIndirect/4","doc":"[`gl:multiDrawArraysIndirect/4`](`multiDrawArraysIndirect/4`) specifies multiple\ngeometric primitives with very few subroutine calls.\n[`gl:multiDrawArraysIndirect/4`](`multiDrawArraysIndirect/4`) behaves similarly\nto a multitude of calls to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`),\nexecept that the parameters to each call to\n[`gl:drawArraysInstancedBaseInstance/5`](`drawArraysInstancedBaseInstance/5`)\nare stored in an array in memory at the address given by `Indirect`, separated\nby the stride, in basic machine units, specified by `Stride`. If `Stride` is\nzero, then the array is assumed to be tightly packed in memory.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glMultiDrawArraysIndirect.xhtml)","ref":"gl.html#multiDrawArraysIndirect/4"},{"type":"function","title":"gl.multiDrawArraysIndirectCount/5","doc":"No documentation available.","ref":"gl.html#multiDrawArraysIndirectCount/5"},{"type":"function","title":"gl.multiTexCoord1d/2","doc":"","ref":"gl.html#multiTexCoord1d/2"},{"type":"function","title":"gl.multiTexCoord1dv/2","doc":"","ref":"gl.html#multiTexCoord1dv/2"},{"type":"function","title":"gl.multiTexCoord1f/2","doc":"","ref":"gl.html#multiTexCoord1f/2"},{"type":"function","title":"gl.multiTexCoord1fv/2","doc":"","ref":"gl.html#multiTexCoord1fv/2"},{"type":"function","title":"gl.multiTexCoord1i/2","doc":"","ref":"gl.html#multiTexCoord1i/2"},{"type":"function","title":"gl.multiTexCoord1iv/2","doc":"","ref":"gl.html#multiTexCoord1iv/2"},{"type":"function","title":"gl.multiTexCoord1s/2","doc":"","ref":"gl.html#multiTexCoord1s/2"},{"type":"function","title":"gl.multiTexCoord1sv/2","doc":"","ref":"gl.html#multiTexCoord1sv/2"},{"type":"function","title":"gl.multiTexCoord2d/3","doc":"","ref":"gl.html#multiTexCoord2d/3"},{"type":"function","title":"gl.multiTexCoord2dv/2","doc":"","ref":"gl.html#multiTexCoord2dv/2"},{"type":"function","title":"gl.multiTexCoord2f/3","doc":"","ref":"gl.html#multiTexCoord2f/3"},{"type":"function","title":"gl.multiTexCoord2fv/2","doc":"","ref":"gl.html#multiTexCoord2fv/2"},{"type":"function","title":"gl.multiTexCoord2i/3","doc":"","ref":"gl.html#multiTexCoord2i/3"},{"type":"function","title":"gl.multiTexCoord2iv/2","doc":"","ref":"gl.html#multiTexCoord2iv/2"},{"type":"function","title":"gl.multiTexCoord2s/3","doc":"","ref":"gl.html#multiTexCoord2s/3"},{"type":"function","title":"gl.multiTexCoord2sv/2","doc":"","ref":"gl.html#multiTexCoord2sv/2"},{"type":"function","title":"gl.multiTexCoord3d/4","doc":"","ref":"gl.html#multiTexCoord3d/4"},{"type":"function","title":"gl.multiTexCoord3dv/2","doc":"","ref":"gl.html#multiTexCoord3dv/2"},{"type":"function","title":"gl.multiTexCoord3f/4","doc":"","ref":"gl.html#multiTexCoord3f/4"},{"type":"function","title":"gl.multiTexCoord3fv/2","doc":"","ref":"gl.html#multiTexCoord3fv/2"},{"type":"function","title":"gl.multiTexCoord3i/4","doc":"","ref":"gl.html#multiTexCoord3i/4"},{"type":"function","title":"gl.multiTexCoord3iv/2","doc":"","ref":"gl.html#multiTexCoord3iv/2"},{"type":"function","title":"gl.multiTexCoord3s/4","doc":"","ref":"gl.html#multiTexCoord3s/4"},{"type":"function","title":"gl.multiTexCoord3sv/2","doc":"","ref":"gl.html#multiTexCoord3sv/2"},{"type":"function","title":"gl.multiTexCoord4d/5","doc":"","ref":"gl.html#multiTexCoord4d/5"},{"type":"function","title":"gl.multiTexCoord4dv/2","doc":"","ref":"gl.html#multiTexCoord4dv/2"},{"type":"function","title":"gl.multiTexCoord4f/5","doc":"","ref":"gl.html#multiTexCoord4f/5"},{"type":"function","title":"gl.multiTexCoord4fv/2","doc":"","ref":"gl.html#multiTexCoord4fv/2"},{"type":"function","title":"gl.multiTexCoord4i/5","doc":"","ref":"gl.html#multiTexCoord4i/5"},{"type":"function","title":"gl.multiTexCoord4iv/2","doc":"","ref":"gl.html#multiTexCoord4iv/2"},{"type":"function","title":"gl.multiTexCoord4s/5","doc":"","ref":"gl.html#multiTexCoord4s/5"},{"type":"function","title":"gl.multiTexCoord4sv/2","doc":"[`gl:multiTexCoord()`](`multiTexCoord1d/2`) specifies texture coordinates in\none, two, three, or four dimensions.\n[`gl:multiTexCoord1()`](`multiTexCoord1d/2`) sets the current texture\ncoordinates to (s 0 0 1); a call to [`gl:multiTexCoord2()`](`multiTexCoord1d/2`)\nsets them to (s t 0 1). Similarly, [`gl:multiTexCoord3()`](`multiTexCoord1d/2`)\nspecifies the texture coordinates as (s t r 1), and\n[`gl:multiTexCoord4()`](`multiTexCoord1d/2`) defines all four components\nexplicitly as (s t r q).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMultiTexCoord.xml)","ref":"gl.html#multiTexCoord4sv/2"},{"type":"function","title":"gl.multMatrixd/1","doc":"","ref":"gl.html#multMatrixd/1"},{"type":"function","title":"gl.multMatrixf/1","doc":"[`gl:multMatrix()`](`multMatrixd/1`) multiplies the current matrix with the one\nspecified using `M`, and replaces the current matrix with the product.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMultMatrix.xml)","ref":"gl.html#multMatrixf/1"},{"type":"function","title":"gl.multTransposeMatrixd/1","doc":"","ref":"gl.html#multTransposeMatrixd/1"},{"type":"function","title":"gl.multTransposeMatrixf/1","doc":"[`gl:multTransposeMatrix()`](`multTransposeMatrixf/1`) multiplies the current\nmatrix with the one specified using `M`, and replaces the current matrix with\nthe product.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glMultTransposeMatrix.xml)","ref":"gl.html#multTransposeMatrixf/1"},{"type":"function","title":"gl.newList/2","doc":"Display lists are groups of GL commands that have been stored for subsequent\nexecution. Display lists are created with [`gl:newList/2`](`newList/2`). All\nsubsequent commands are placed in the display list, in the order issued, until\n[`gl:endList/0`](`newList/2`) is called.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glNewList.xml)","ref":"gl.html#newList/2"},{"type":"function","title":"gl.normal3b/3","doc":"","ref":"gl.html#normal3b/3"},{"type":"function","title":"gl.normal3bv/1","doc":"","ref":"gl.html#normal3bv/1"},{"type":"function","title":"gl.normal3d/3","doc":"","ref":"gl.html#normal3d/3"},{"type":"function","title":"gl.normal3dv/1","doc":"","ref":"gl.html#normal3dv/1"},{"type":"function","title":"gl.normal3f/3","doc":"","ref":"gl.html#normal3f/3"},{"type":"function","title":"gl.normal3fv/1","doc":"","ref":"gl.html#normal3fv/1"},{"type":"function","title":"gl.normal3i/3","doc":"","ref":"gl.html#normal3i/3"},{"type":"function","title":"gl.normal3iv/1","doc":"","ref":"gl.html#normal3iv/1"},{"type":"function","title":"gl.normal3s/3","doc":"","ref":"gl.html#normal3s/3"},{"type":"function","title":"gl.normal3sv/1","doc":"The current normal is set to the given coordinates whenever\n[`gl:normal()`](`normal3b/3`) is issued. Byte, short, or integer arguments are\nconverted to floating-point format with a linear mapping that maps the most\npositive representable integer value to 1.0 and the most negative representable\ninteger value to -1.0.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glNormal.xml)","ref":"gl.html#normal3sv/1"},{"type":"function","title":"gl.normalPointer/3","doc":"[`gl:normalPointer/3`](`normalPointer/3`) specifies the location and data format\nof an array of normals to use when rendering. `Type` specifies the data type of\neach normal coordinate, and `Stride` specifies the byte stride from one normal\nto the next, allowing vertices and attributes to be packed into a single array\nor stored in separate arrays. (Single-array storage may be more efficient on\nsome implementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glNormalPointer.xml)","ref":"gl.html#normalPointer/3"},{"type":"function","title":"gl.objectPtrLabel/3","doc":"[`gl:objectPtrLabel/3`](`objectPtrLabel/3`) labels the sync object identified by\n`Ptr`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glObjectPtrLabel.xhtml)","ref":"gl.html#objectPtrLabel/3"},{"type":"function","title":"gl.ortho/6","doc":"[`gl:ortho/6`](`ortho/6`) describes a transformation that produces a parallel\nprojection. The current matrix (see [`gl:matrixMode/1`](`matrixMode/1`)) is\nmultiplied by this matrix and the result replaces the current matrix, as if\n[`gl:multMatrix()`](`multMatrixd/1`) were called with the following matrix as\nits argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glOrtho.xml)","ref":"gl.html#ortho/6"},{"type":"function","title":"gl.passThrough/1","doc":"[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPassThrough.xml)","ref":"gl.html#passThrough/1"},{"type":"function","title":"gl.patchParameterfv/2","doc":"","ref":"gl.html#patchParameterfv/2"},{"type":"function","title":"gl.patchParameteri/2","doc":"[`gl:patchParameter()`](`patchParameteri/2`) specifies the parameters that will\nbe used for patch primitives. `Pname` specifies the parameter to modify and must\nbe either `?GL_PATCH_VERTICES`, `?GL_PATCH_DEFAULT_OUTER_LEVEL` or\n`?GL_PATCH_DEFAULT_INNER_LEVEL`. For\n[`gl:patchParameteri/2`](`patchParameteri/2`), `Value` specifies the new value\nfor the parameter specified by `Pname`. For\n[`gl:patchParameterfv/2`](`patchParameteri/2`), `Values` specifies the address\nof an array containing the new values for the parameter specified by `Pname`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPatchParameter.xhtml)","ref":"gl.html#patchParameteri/2"},{"type":"function","title":"gl.pauseTransformFeedback/0","doc":"[`gl:pauseTransformFeedback/0`](`pauseTransformFeedback/0`) pauses transform\nfeedback operations on the currently active transform feedback object. When\ntransform feedback operations are paused, transform feedback is still considered\nactive and changing most transform feedback state related to the object results\nin an error. However, a new transform feedback object may be bound while\ntransform feedback is paused.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPauseTransformFeedback.xhtml)","ref":"gl.html#pauseTransformFeedback/0"},{"type":"function","title":"gl.pixelMapfv/3","doc":"","ref":"gl.html#pixelMapfv/3"},{"type":"function","title":"gl.pixelMapuiv/3","doc":"","ref":"gl.html#pixelMapuiv/3"},{"type":"function","title":"gl.pixelMapusv/3","doc":"[`gl:pixelMap()`](`pixelMapfv/3`) sets up translation tables, or `maps`, used by\n[`gl:copyPixels/5`](`copyPixels/5`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`),\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`),\n[`gl:drawPixels/5`](`drawPixels/5`), [`gl:readPixels/7`](`readPixels/7`),\n[`gl:texImage1D/8`](`texImage1D/8`), [`gl:texImage2D/9`](`texImage2D/9`),\n[`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`), and\n[`gl:texSubImage3D/11`](`texSubImage3D/11`). Additionally, if the ARB_imaging\nsubset is supported, the routines [`gl:colorTable/6`](`colorTable/6`),\n[`gl:colorSubTable/6`](`colorSubTable/6`),\n[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`),\n[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`),\n[`gl:histogram/4`](`histogram/4`), [`gl:minmax/3`](`minmax/3`), and\n[`gl:separableFilter2D/8`](`separableFilter2D/8`). Use of these maps is\ndescribed completely in the [`gl:pixelTransfer()`](`pixelTransferf/2`) reference\npage, and partly in the reference pages for the pixel and texture image\ncommands. Only the specification of the maps is described in this reference\npage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPixelMap.xml)","ref":"gl.html#pixelMapusv/3"},{"type":"function","title":"gl.pixelStoref/2","doc":"","ref":"gl.html#pixelStoref/2"},{"type":"function","title":"gl.pixelStorei/2","doc":"[`gl:pixelStore()`](`pixelStoref/2`) sets pixel storage modes that affect the\noperation of subsequent [`gl:readPixels/7`](`readPixels/7`) as well as the\nunpacking of texture patterns (see [`gl:texImage1D/8`](`texImage1D/8`),\n[`gl:texImage2D/9`](`texImage2D/9`), [`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`),\n[`gl:texSubImage3D/11`](`texSubImage3D/11`)),\n[`gl:compressedTexImage1D/7`](`compressedTexImage1D/7`),\n[`gl:compressedTexImage2D/8`](`compressedTexImage2D/8`),\n[`gl:compressedTexImage3D/9`](`compressedTexImage3D/9`),\n[`gl:compressedTexSubImage1D/7`](`compressedTexSubImage1D/7`),\n[`gl:compressedTexSubImage2D/9`](`compressedTexSubImage2D/9`) or\n[`gl:compressedTexSubImage1D/7`](`compressedTexSubImage1D/7`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPixelStore.xhtml)","ref":"gl.html#pixelStorei/2"},{"type":"function","title":"gl.pixelTransferf/2","doc":"","ref":"gl.html#pixelTransferf/2"},{"type":"function","title":"gl.pixelTransferi/2","doc":"[`gl:pixelTransfer()`](`pixelTransferf/2`) sets pixel transfer modes that affect\nthe operation of subsequent [`gl:copyPixels/5`](`copyPixels/5`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`),\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`),\n[`gl:drawPixels/5`](`drawPixels/5`), [`gl:readPixels/7`](`readPixels/7`),\n[`gl:texImage1D/8`](`texImage1D/8`), [`gl:texImage2D/9`](`texImage2D/9`),\n[`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`), and\n[`gl:texSubImage3D/11`](`texSubImage3D/11`) commands. Additionally, if the\nARB_imaging subset is supported, the routines\n[`gl:colorTable/6`](`colorTable/6`), [`gl:colorSubTable/6`](`colorSubTable/6`),\n[`gl:convolutionFilter1D/6`](`convolutionFilter1D/6`),\n[`gl:convolutionFilter2D/7`](`convolutionFilter2D/7`),\n[`gl:histogram/4`](`histogram/4`), [`gl:minmax/3`](`minmax/3`), and\n[`gl:separableFilter2D/8`](`separableFilter2D/8`) are also affected. The\nalgorithms that are specified by pixel transfer modes operate on pixels after\nthey are read from the frame buffer\n([`gl:copyPixels/5`](`copyPixels/5`)[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`),\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`), and\n[`gl:readPixels/7`](`readPixels/7`)), or unpacked from client memory\n([`gl:drawPixels/5`](`drawPixels/5`), [`gl:texImage1D/8`](`texImage1D/8`),\n[`gl:texImage2D/9`](`texImage2D/9`), [`gl:texImage3D/10`](`texImage3D/10`),\n[`gl:texSubImage1D/7`](`texSubImage1D/7`),\n[`gl:texSubImage2D/9`](`texSubImage2D/9`), and\n[`gl:texSubImage3D/11`](`texSubImage3D/11`)). Pixel transfer operations happen\nin the same order, and in the same manner, regardless of the command that\nresulted in the pixel operation. Pixel storage modes (see\n[`gl:pixelStore()`](`pixelStoref/2`)) control the unpacking of pixels being read\nfrom client memory and the packing of pixels being written back into client\nmemory.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPixelTransfer.xml)","ref":"gl.html#pixelTransferi/2"},{"type":"function","title":"gl.pixelZoom/2","doc":"[`gl:pixelZoom/2`](`pixelZoom/2`) specifies values for the x and y zoom factors.\nDuring the execution of [`gl:drawPixels/5`](`drawPixels/5`) or\n[`gl:copyPixels/5`](`copyPixels/5`), if ( xr, yr) is the current raster\nposition, and a given element is in the mth row and nth column of the pixel\nrectangle, then pixels whose centers are in the rectangle with corners at\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPixelZoom.xml)","ref":"gl.html#pixelZoom/2"},{"type":"function","title":"gl.pointParameterf/2","doc":"","ref":"gl.html#pointParameterf/2"},{"type":"function","title":"gl.pointParameterfv/2","doc":"","ref":"gl.html#pointParameterfv/2"},{"type":"function","title":"gl.pointParameteri/2","doc":"","ref":"gl.html#pointParameteri/2"},{"type":"function","title":"gl.pointParameteriv/2","doc":"The following values are accepted for `Pname`:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPointParameter.xhtml)","ref":"gl.html#pointParameteriv/2"},{"type":"function","title":"gl.pointSize/1","doc":"[`gl:pointSize/1`](`pointSize/1`) specifies the rasterized diameter of points.\nIf point size mode is disabled (see [`gl:enable/1`](`enable/1`) with parameter\n`?GL_PROGRAM_POINT_SIZE`), this value will be used to rasterize points.\nOtherwise, the value written to the shading language built-in variable\ngl_PointSize will be used.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPointSize.xhtml)","ref":"gl.html#pointSize/1"},{"type":"function","title":"gl.polygonMode/2","doc":"[`gl:polygonMode/2`](`polygonMode/2`) controls the interpretation of polygons\nfor rasterization. `Face` describes which polygons `Mode` applies to: both front\nand back-facing polygons (`?GL_FRONT_AND_BACK`). The polygon mode affects only\nthe final rasterization of polygons. In particular, a polygon's vertices are lit\nand the polygon is clipped and possibly culled before these modes are applied.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPolygonMode.xhtml)","ref":"gl.html#polygonMode/2"},{"type":"function","title":"gl.polygonOffset/2","doc":"When `?GL_POLYGON_OFFSET_FILL`, `?GL_POLYGON_OFFSET_LINE`, or\n`?GL_POLYGON_OFFSET_POINT` is enabled, each fragment's `depth` value will be\noffset after it is interpolated from the `depth` values of the appropriate\nvertices. The value of the offset is factor×DZ+r×units, where DZ is a\nmeasurement of the change in depth relative to the screen area of the polygon,\nand r is the smallest value that is guaranteed to produce a resolvable offset\nfor a given implementation. The offset is added before the depth test is\nperformed and before the value is written into the depth buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPolygonOffset.xhtml)","ref":"gl.html#polygonOffset/2"},{"type":"function","title":"gl.polygonOffsetClamp/3","doc":"No documentation available.","ref":"gl.html#polygonOffsetClamp/3"},{"type":"function","title":"gl.polygonStipple/1","doc":"Polygon stippling, like line stippling (see\n[`gl:lineStipple/2`](`lineStipple/2`)), masks out certain fragments produced by\nrasterization, creating a pattern. Stippling is independent of polygon\nantialiasing.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPolygonStipple.xml)","ref":"gl.html#polygonStipple/1"},{"type":"function","title":"gl.popAttrib/0","doc":"","ref":"gl.html#popAttrib/0"},{"type":"function","title":"gl.popClientAttrib/0","doc":"","ref":"gl.html#popClientAttrib/0"},{"type":"function","title":"gl.popDebugGroup/0","doc":"","ref":"gl.html#popDebugGroup/0"},{"type":"function","title":"gl.popMatrix/0","doc":"","ref":"gl.html#popMatrix/0"},{"type":"function","title":"gl.popName/0","doc":"","ref":"gl.html#popName/0"},{"type":"function","title":"gl.primitiveRestartIndex/1","doc":"[`gl:primitiveRestartIndex/1`](`primitiveRestartIndex/1`) specifies a vertex\narray element that is treated specially when primitive restarting is enabled.\nThis is known as the primitive restart index.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPrimitiveRestartIndex.xhtml)","ref":"gl.html#primitiveRestartIndex/1"},{"type":"function","title":"gl.prioritizeTextures/2","doc":"[`gl:prioritizeTextures/2`](`prioritizeTextures/2`) assigns the `N` texture\npriorities given in `Priorities` to the `N` textures named in `Textures`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPrioritizeTextures.xml)","ref":"gl.html#prioritizeTextures/2"},{"type":"function","title":"gl.programBinary/3","doc":"[`gl:programBinary/3`](`programBinary/3`) loads a program object with a program\nbinary previously returned from [`gl:getProgramBinary/2`](`getProgramBinary/2`).\n`BinaryFormat` and `Binary` must be those returned by a previous call to\n[`gl:getProgramBinary/2`](`getProgramBinary/2`), and `Length` must be the length\nreturned by [`gl:getProgramBinary/2`](`getProgramBinary/2`), or by\n[`gl:getProgram()`](`getProgramiv/2`) when called with `Pname` set to\n`?GL_PROGRAM_BINARY_LENGTH`. If these conditions are not met, loading the\nprogram binary will fail and `Program`'s `?GL_LINK_STATUS` will be set to\n`?GL_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProgramBinary.xhtml)","ref":"gl.html#programBinary/3"},{"type":"function","title":"gl.programParameteri/3","doc":"[`gl:programParameter()`](`programParameteri/3`) specifies a new value for the\nparameter nameed by `Pname` for the program object `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProgramParameter.xhtml)","ref":"gl.html#programParameteri/3"},{"type":"function","title":"gl.programUniform1d/3","doc":"","ref":"gl.html#programUniform1d/3"},{"type":"function","title":"gl.programUniform1dv/3","doc":"","ref":"gl.html#programUniform1dv/3"},{"type":"function","title":"gl.programUniform1f/3","doc":"","ref":"gl.html#programUniform1f/3"},{"type":"function","title":"gl.programUniform1fv/3","doc":"","ref":"gl.html#programUniform1fv/3"},{"type":"function","title":"gl.programUniform1i/3","doc":"","ref":"gl.html#programUniform1i/3"},{"type":"function","title":"gl.programUniform1iv/3","doc":"","ref":"gl.html#programUniform1iv/3"},{"type":"function","title":"gl.programUniform1ui/3","doc":"","ref":"gl.html#programUniform1ui/3"},{"type":"function","title":"gl.programUniform1uiv/3","doc":"","ref":"gl.html#programUniform1uiv/3"},{"type":"function","title":"gl.programUniform2d/4","doc":"","ref":"gl.html#programUniform2d/4"},{"type":"function","title":"gl.programUniform2dv/3","doc":"","ref":"gl.html#programUniform2dv/3"},{"type":"function","title":"gl.programUniform2f/4","doc":"","ref":"gl.html#programUniform2f/4"},{"type":"function","title":"gl.programUniform2fv/3","doc":"","ref":"gl.html#programUniform2fv/3"},{"type":"function","title":"gl.programUniform2i/4","doc":"","ref":"gl.html#programUniform2i/4"},{"type":"function","title":"gl.programUniform2iv/3","doc":"","ref":"gl.html#programUniform2iv/3"},{"type":"function","title":"gl.programUniform2ui/4","doc":"","ref":"gl.html#programUniform2ui/4"},{"type":"function","title":"gl.programUniform2uiv/3","doc":"","ref":"gl.html#programUniform2uiv/3"},{"type":"function","title":"gl.programUniform3d/5","doc":"","ref":"gl.html#programUniform3d/5"},{"type":"function","title":"gl.programUniform3dv/3","doc":"","ref":"gl.html#programUniform3dv/3"},{"type":"function","title":"gl.programUniform3f/5","doc":"","ref":"gl.html#programUniform3f/5"},{"type":"function","title":"gl.programUniform3fv/3","doc":"","ref":"gl.html#programUniform3fv/3"},{"type":"function","title":"gl.programUniform3i/5","doc":"","ref":"gl.html#programUniform3i/5"},{"type":"function","title":"gl.programUniform3iv/3","doc":"","ref":"gl.html#programUniform3iv/3"},{"type":"function","title":"gl.programUniform3ui/5","doc":"","ref":"gl.html#programUniform3ui/5"},{"type":"function","title":"gl.programUniform3uiv/3","doc":"","ref":"gl.html#programUniform3uiv/3"},{"type":"function","title":"gl.programUniform4d/6","doc":"","ref":"gl.html#programUniform4d/6"},{"type":"function","title":"gl.programUniform4dv/3","doc":"","ref":"gl.html#programUniform4dv/3"},{"type":"function","title":"gl.programUniform4f/6","doc":"","ref":"gl.html#programUniform4f/6"},{"type":"function","title":"gl.programUniform4fv/3","doc":"","ref":"gl.html#programUniform4fv/3"},{"type":"function","title":"gl.programUniform4i/6","doc":"","ref":"gl.html#programUniform4i/6"},{"type":"function","title":"gl.programUniform4iv/3","doc":"","ref":"gl.html#programUniform4iv/3"},{"type":"function","title":"gl.programUniform4ui/6","doc":"","ref":"gl.html#programUniform4ui/6"},{"type":"function","title":"gl.programUniform4uiv/3","doc":"","ref":"gl.html#programUniform4uiv/3"},{"type":"function","title":"gl.programUniformMatrix2dv/4","doc":"","ref":"gl.html#programUniformMatrix2dv/4"},{"type":"function","title":"gl.programUniformMatrix2fv/4","doc":"","ref":"gl.html#programUniformMatrix2fv/4"},{"type":"function","title":"gl.programUniformMatrix2x3dv/4","doc":"","ref":"gl.html#programUniformMatrix2x3dv/4"},{"type":"function","title":"gl.programUniformMatrix2x3fv/4","doc":"","ref":"gl.html#programUniformMatrix2x3fv/4"},{"type":"function","title":"gl.programUniformMatrix2x4dv/4","doc":"","ref":"gl.html#programUniformMatrix2x4dv/4"},{"type":"function","title":"gl.programUniformMatrix2x4fv/4","doc":"","ref":"gl.html#programUniformMatrix2x4fv/4"},{"type":"function","title":"gl.programUniformMatrix3dv/4","doc":"","ref":"gl.html#programUniformMatrix3dv/4"},{"type":"function","title":"gl.programUniformMatrix3fv/4","doc":"","ref":"gl.html#programUniformMatrix3fv/4"},{"type":"function","title":"gl.programUniformMatrix3x2dv/4","doc":"","ref":"gl.html#programUniformMatrix3x2dv/4"},{"type":"function","title":"gl.programUniformMatrix3x2fv/4","doc":"","ref":"gl.html#programUniformMatrix3x2fv/4"},{"type":"function","title":"gl.programUniformMatrix3x4dv/4","doc":"","ref":"gl.html#programUniformMatrix3x4dv/4"},{"type":"function","title":"gl.programUniformMatrix3x4fv/4","doc":"","ref":"gl.html#programUniformMatrix3x4fv/4"},{"type":"function","title":"gl.programUniformMatrix4dv/4","doc":"","ref":"gl.html#programUniformMatrix4dv/4"},{"type":"function","title":"gl.programUniformMatrix4fv/4","doc":"","ref":"gl.html#programUniformMatrix4fv/4"},{"type":"function","title":"gl.programUniformMatrix4x2dv/4","doc":"","ref":"gl.html#programUniformMatrix4x2dv/4"},{"type":"function","title":"gl.programUniformMatrix4x2fv/4","doc":"","ref":"gl.html#programUniformMatrix4x2fv/4"},{"type":"function","title":"gl.programUniformMatrix4x3dv/4","doc":"","ref":"gl.html#programUniformMatrix4x3dv/4"},{"type":"function","title":"gl.programUniformMatrix4x3fv/4","doc":"[`gl:programUniform()`](`programUniform1i/3`) modifies the value of a uniform\nvariable or a uniform variable array. The location of the uniform variable to be\nmodified is specified by `Location`, which should be a value returned by\n[`gl:getUniformLocation/2`](`getUniformLocation/2`).\n[`gl:programUniform()`](`programUniform1i/3`) operates on the program object\nspecified by `Program`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProgramUniform.xhtml)","ref":"gl.html#programUniformMatrix4x3fv/4"},{"type":"function","title":"gl.provokingVertex/1","doc":"`Flatshading` a vertex shader varying output means to assign all vetices of the\nprimitive the same value for that output. The vertex from which these values is\nderived is known as the `provoking vertex` and\n[`gl:provokingVertex/1`](`provokingVertex/1`) specifies which vertex is to be\nused as the source of data for flat shaded varyings.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glProvokingVertex.xhtml)","ref":"gl.html#provokingVertex/1"},{"type":"function","title":"gl.pushAttrib/1","doc":"[`gl:pushAttrib/1`](`pushAttrib/1`) takes one argument, a mask that indicates\nwhich groups of state variables to save on the attribute stack. Symbolic\nconstants are used to set bits in the mask. `Mask` is typically constructed by\nspecifying the bitwise-or of several of these constants together. The special\nmask `?GL_ALL_ATTRIB_BITS` can be used to save all stackable states.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushAttrib.xml)","ref":"gl.html#pushAttrib/1"},{"type":"function","title":"gl.pushClientAttrib/1","doc":"[`gl:pushClientAttrib/1`](`pushClientAttrib/1`) takes one argument, a mask that\nindicates which groups of client-state variables to save on the client attribute\nstack. Symbolic constants are used to set bits in the mask. `Mask` is typically\nconstructed by specifying the bitwise-or of several of these constants together.\nThe special mask `?GL_CLIENT_ALL_ATTRIB_BITS` can be used to save all stackable\nclient state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushClientAttrib.xml)","ref":"gl.html#pushClientAttrib/1"},{"type":"function","title":"gl.pushDebugGroup/4","doc":"[`gl:pushDebugGroup/4`](`pushDebugGroup/4`) pushes a debug group described by\nthe string `Message` into the command stream. The value of `Id` specifies the ID\nof messages generated. The parameter `Length` contains the number of characters\nin `Message`. If `Length` is negative, it is implied that `Message` contains a\nnull terminated string. The message has the specified `Source` and `Id`, the\n`Type``?GL_DEBUG_TYPE_PUSH_GROUP`, and\n`Severity``?GL_DEBUG_SEVERITY_NOTIFICATION`. The GL will put a new debug group\non top of the debug group stack which inherits the control of the volume of\ndebug output of the debug group previously residing on the top of the debug\ngroup stack. Because debug groups are strictly hierarchical, any additional\ncontrol of the debug output volume will only apply within the active debug group\nand the debug groups pushed on top of the active debug group.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glPushDebugGroup.xhtml)","ref":"gl.html#pushDebugGroup/4"},{"type":"function","title":"gl.pushMatrix/0","doc":"There is a stack of matrices for each of the matrix modes. In `?GL_MODELVIEW`\nmode, the stack depth is at least 32. In the other modes, `?GL_COLOR`,\n`?GL_PROJECTION`, and `?GL_TEXTURE`, the depth is at least 2. The current matrix\nin any mode is the matrix on the top of the stack for that mode.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushMatrix.xml)","ref":"gl.html#pushMatrix/0"},{"type":"function","title":"gl.pushName/1","doc":"The name stack is used during selection mode to allow sets of rendering commands\nto be uniquely identified. It consists of an ordered set of unsigned integers\nand is initially empty.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glPushName.xml)","ref":"gl.html#pushName/1"},{"type":"function","title":"gl.queryCounter/2","doc":"[`gl:queryCounter/2`](`queryCounter/2`) causes the GL to record the current time\ninto the query object named `Id`. `Target` must be `?GL_TIMESTAMP`. The time is\nrecorded after all previous commands on the GL client and server state and the\nframebuffer have been fully realized. When the time is recorded, the query\nresult for that object is marked available.\n[`gl:queryCounter/2`](`queryCounter/2`) timer queries can be used within a\n[`gl:beginQuery/2`](`beginQuery/2`) / [`gl:endQuery/1`](`beginQuery/2`) block\nwhere the target is `?GL_TIME_ELAPSED` and it does not affect the result of that\nquery object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glQueryCounter.xhtml)","ref":"gl.html#queryCounter/2"},{"type":"function","title":"gl.rasterPos2d/2","doc":"","ref":"gl.html#rasterPos2d/2"},{"type":"function","title":"gl.rasterPos2dv/1","doc":"","ref":"gl.html#rasterPos2dv/1"},{"type":"function","title":"gl.rasterPos2f/2","doc":"","ref":"gl.html#rasterPos2f/2"},{"type":"function","title":"gl.rasterPos2fv/1","doc":"","ref":"gl.html#rasterPos2fv/1"},{"type":"function","title":"gl.rasterPos2i/2","doc":"","ref":"gl.html#rasterPos2i/2"},{"type":"function","title":"gl.rasterPos2iv/1","doc":"","ref":"gl.html#rasterPos2iv/1"},{"type":"function","title":"gl.rasterPos2s/2","doc":"","ref":"gl.html#rasterPos2s/2"},{"type":"function","title":"gl.rasterPos2sv/1","doc":"","ref":"gl.html#rasterPos2sv/1"},{"type":"function","title":"gl.rasterPos3d/3","doc":"","ref":"gl.html#rasterPos3d/3"},{"type":"function","title":"gl.rasterPos3dv/1","doc":"","ref":"gl.html#rasterPos3dv/1"},{"type":"function","title":"gl.rasterPos3f/3","doc":"","ref":"gl.html#rasterPos3f/3"},{"type":"function","title":"gl.rasterPos3fv/1","doc":"","ref":"gl.html#rasterPos3fv/1"},{"type":"function","title":"gl.rasterPos3i/3","doc":"","ref":"gl.html#rasterPos3i/3"},{"type":"function","title":"gl.rasterPos3iv/1","doc":"","ref":"gl.html#rasterPos3iv/1"},{"type":"function","title":"gl.rasterPos3s/3","doc":"","ref":"gl.html#rasterPos3s/3"},{"type":"function","title":"gl.rasterPos3sv/1","doc":"","ref":"gl.html#rasterPos3sv/1"},{"type":"function","title":"gl.rasterPos4d/4","doc":"","ref":"gl.html#rasterPos4d/4"},{"type":"function","title":"gl.rasterPos4dv/1","doc":"","ref":"gl.html#rasterPos4dv/1"},{"type":"function","title":"gl.rasterPos4f/4","doc":"","ref":"gl.html#rasterPos4f/4"},{"type":"function","title":"gl.rasterPos4fv/1","doc":"","ref":"gl.html#rasterPos4fv/1"},{"type":"function","title":"gl.rasterPos4i/4","doc":"","ref":"gl.html#rasterPos4i/4"},{"type":"function","title":"gl.rasterPos4iv/1","doc":"","ref":"gl.html#rasterPos4iv/1"},{"type":"function","title":"gl.rasterPos4s/4","doc":"","ref":"gl.html#rasterPos4s/4"},{"type":"function","title":"gl.rasterPos4sv/1","doc":"The GL maintains a 3D position in window coordinates. This position, called the\nraster position, is used to position pixel and bitmap write operations. It is\nmaintained with subpixel accuracy. See [`gl:bitmap/7`](`bitmap/7`),\n[`gl:drawPixels/5`](`drawPixels/5`), and [`gl:copyPixels/5`](`copyPixels/5`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRasterPos.xml)","ref":"gl.html#rasterPos4sv/1"},{"type":"function","title":"gl.readBuffer/1","doc":"[`gl:readBuffer/1`](`readBuffer/1`) specifies a color buffer as the source for\nsubsequent [`gl:readPixels/7`](`readPixels/7`),\n[`gl:copyTexImage1D/7`](`copyTexImage1D/7`),\n[`gl:copyTexImage2D/8`](`copyTexImage2D/8`),\n[`gl:copyTexSubImage1D/6`](`copyTexSubImage1D/6`),\n[`gl:copyTexSubImage2D/8`](`copyTexSubImage2D/8`), and\n[`gl:copyTexSubImage3D/9`](`copyTexSubImage3D/9`) commands. `Mode` accepts one\nof twelve or more predefined values. In a fully configured system, `?GL_FRONT`,\n`?GL_LEFT`, and `?GL_FRONT_LEFT` all name the front left buffer,\n`?GL_FRONT_RIGHT` and `?GL_RIGHT` name the front right buffer, and\n`?GL_BACK_LEFT` and `?GL_BACK` name the back left buffer. Further more, the\nconstants `?GL_COLOR_ATTACHMENT``i` may be used to indicate the `i`th color\nattachment where `i` ranges from zero to the value of\n`?GL_MAX_COLOR_ATTACHMENTS` minus one.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReadBuffer.xhtml)","ref":"gl.html#readBuffer/1"},{"type":"function","title":"gl.readPixels/7","doc":"[`gl:readPixels/7`](`readPixels/7`) and `glReadnPixels` return pixel data from\nthe frame buffer, starting with the pixel whose lower left corner is at location\n(`X`, `Y`), into client memory starting at location `Data`. Several parameters\ncontrol the processing of the pixel data before it is placed into client memory.\nThese parameters are set with [`gl:pixelStore()`](`pixelStoref/2`). This\nreference page describes the effects on [`gl:readPixels/7`](`readPixels/7`) and\n`glReadnPixels` of most, but not all of the parameters specified by these three\ncommands.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReadPixels.xhtml)","ref":"gl.html#readPixels/7"},{"type":"function","title":"gl.rectd/4","doc":"","ref":"gl.html#rectd/4"},{"type":"function","title":"gl.rectdv/2","doc":"","ref":"gl.html#rectdv/2"},{"type":"function","title":"gl.rectf/4","doc":"","ref":"gl.html#rectf/4"},{"type":"function","title":"gl.rectfv/2","doc":"","ref":"gl.html#rectfv/2"},{"type":"function","title":"gl.recti/4","doc":"","ref":"gl.html#recti/4"},{"type":"function","title":"gl.rectiv/2","doc":"","ref":"gl.html#rectiv/2"},{"type":"function","title":"gl.rects/4","doc":"","ref":"gl.html#rects/4"},{"type":"function","title":"gl.rectsv/2","doc":"[`gl:rect()`](`rectd/4`) supports efficient specification of rectangles as two\ncorner points. Each rectangle command takes four arguments, organized either as\ntwo consecutive pairs of (x y) coordinates or as two pointers to arrays, each\ncontaining an (x y) pair. The resulting rectangle is defined in the z=0 plane.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRect.xml)","ref":"gl.html#rectsv/2"},{"type":"function","title":"gl.releaseShaderCompiler/0","doc":"[`gl:releaseShaderCompiler/0`](`releaseShaderCompiler/0`) provides a hint to the\nimplementation that it may free internal resources associated with its shader\ncompiler. [`gl:compileShader/1`](`compileShader/1`) may subsequently be called\nand the implementation may at that time reallocate resources previously freed by\nthe call to [`gl:releaseShaderCompiler/0`](`releaseShaderCompiler/0`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glReleaseShaderCompiler.xhtml)","ref":"gl.html#releaseShaderCompiler/0"},{"type":"function","title":"gl.renderbufferStorage/4","doc":"[`gl:renderbufferStorage/4`](`renderbufferStorage/4`) is equivalent to calling\n[`gl:renderbufferStorageMultisample/5`](`renderbufferStorageMultisample/5`) with\nthe `Samples` set to zero, and `glNamedRenderbufferStorage` is equivalent to\ncalling `glNamedRenderbufferStorageMultisample` with the samples set to zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glRenderbufferStorage.xhtml)","ref":"gl.html#renderbufferStorage/4"},{"type":"function","title":"gl.renderbufferStorageMultisample/5","doc":"[`gl:renderbufferStorageMultisample/5`](`renderbufferStorageMultisample/5`) and\n`glNamedRenderbufferStorageMultisample` establish the data storage, format,\ndimensions and number of samples of a renderbuffer object's image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glRenderbufferStorageMultisample.xhtml)","ref":"gl.html#renderbufferStorageMultisample/5"},{"type":"function","title":"gl.renderMode/1","doc":"[`gl:renderMode/1`](`renderMode/1`) sets the rasterization mode. It takes one\nargument, `Mode`, which can assume one of three predefined values:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRenderMode.xml)","ref":"gl.html#renderMode/1"},{"type":"function","title":"gl.resetHistogram/1","doc":"[`gl:resetHistogram/1`](`resetHistogram/1`) resets all the elements of the\ncurrent histogram table to zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glResetHistogram.xml)","ref":"gl.html#resetHistogram/1"},{"type":"function","title":"gl.resetMinmax/1","doc":"[`gl:resetMinmax/1`](`resetMinmax/1`) resets the elements of the current minmax\ntable to their initial values: the \\`\\`maximum'' element receives the minimum\npossible component values, and the \\`\\`minimum'' element receives the maximum\npossible component values.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glResetMinmax.xml)","ref":"gl.html#resetMinmax/1"},{"type":"function","title":"gl.resumeTransformFeedback/0","doc":"[`gl:resumeTransformFeedback/0`](`resumeTransformFeedback/0`) resumes transform\nfeedback operations on the currently active transform feedback object. When\ntransform feedback operations are paused, transform feedback is still considered\nactive and changing most transform feedback state related to the object results\nin an error. However, a new transform feedback object may be bound while\ntransform feedback is paused.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glResumeTransformFeedback.xhtml)","ref":"gl.html#resumeTransformFeedback/0"},{"type":"function","title":"gl.rotated/4","doc":"","ref":"gl.html#rotated/4"},{"type":"function","title":"gl.rotatef/4","doc":"[`gl:rotate()`](`rotated/4`) produces a rotation of `Angle` degrees around the\nvector (x y z). The current matrix (see [`gl:matrixMode/1`](`matrixMode/1`)) is\nmultiplied by a rotation matrix with the product replacing the current matrix,\nas if [`gl:multMatrix()`](`multMatrixd/1`) were called with the following matrix\nas its argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glRotate.xml)","ref":"gl.html#rotatef/4"},{"type":"function","title":"gl.sampleCoverage/2","doc":"Multisampling samples a pixel multiple times at various implementation-dependent\nsubpixel locations to generate antialiasing effects. Multisampling transparently\nantialiases points, lines, polygons, and images if it is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glSampleCoverage.xhtml)","ref":"gl.html#sampleCoverage/2"},{"type":"function","title":"gl.sampleMaski/2","doc":"[`gl:sampleMaski/2`](`sampleMaski/2`) sets one 32-bit sub-word of the multi-word\nsample mask, `?GL_SAMPLE_MASK_VALUE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glSampleMaski.xhtml)","ref":"gl.html#sampleMaski/2"},{"type":"function","title":"gl.samplerParameterf/3","doc":"","ref":"gl.html#samplerParameterf/3"},{"type":"function","title":"gl.samplerParameterfv/3","doc":"","ref":"gl.html#samplerParameterfv/3"},{"type":"function","title":"gl.samplerParameterIiv/3","doc":"","ref":"gl.html#samplerParameterIiv/3"},{"type":"function","title":"gl.samplerParameterIuiv/3","doc":"","ref":"gl.html#samplerParameterIuiv/3"},{"type":"function","title":"gl.samplerParameteri/3","doc":"","ref":"gl.html#samplerParameteri/3"},{"type":"function","title":"gl.samplerParameteriv/3","doc":"[`gl:samplerParameter()`](`samplerParameteri/3`) assigns the value or values in\n`Params` to the sampler parameter specified as `Pname`. `Sampler` specifies the\nsampler object to be modified, and must be the name of a sampler object\npreviously returned from a call to [`gl:genSamplers/1`](`genSamplers/1`). The\nfollowing symbols are accepted in `Pname`:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glSamplerParameter.xhtml)","ref":"gl.html#samplerParameteriv/3"},{"type":"function","title":"gl.scaled/3","doc":"","ref":"gl.html#scaled/3"},{"type":"function","title":"gl.scalef/3","doc":"[`gl:scale()`](`scaled/3`) produces a nonuniform scaling along the `x`, `y`, and\n`z` axes. The three parameters indicate the desired scale factor along each of\nthe three axes.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glScale.xml)","ref":"gl.html#scalef/3"},{"type":"function","title":"gl.scissor/4","doc":"[`gl:scissor/4`](`scissor/4`) defines a rectangle, called the scissor box, in\nwindow coordinates. The first two arguments, `X` and `Y`, specify the lower left\ncorner of the box. `Width` and `Height` specify the width and height of the box.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glScissor.xhtml)","ref":"gl.html#scissor/4"},{"type":"function","title":"gl.scissorArrayv/2","doc":"[`gl:scissorArrayv/2`](`scissorArrayv/2`) defines rectangles, called scissor\nboxes, in window coordinates for each viewport. `First` specifies the index of\nthe first scissor box to modify and `Count` specifies the number of scissor\nboxes to modify. `First` must be less than the value of `?GL_MAX_VIEWPORTS`, and\n`First` \\+ `Count` must be less than or equal to the value of\n`?GL_MAX_VIEWPORTS`. `V` specifies the address of an array containing integers\nspecifying the lower left corner of the scissor boxes, and the width and height\nof the scissor boxes, in that order.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glScissorArray.xhtml)","ref":"gl.html#scissorArrayv/2"},{"type":"function","title":"gl.scissorIndexed/5","doc":"","ref":"gl.html#scissorIndexed/5"},{"type":"function","title":"gl.scissorIndexedv/2","doc":"[`gl:scissorIndexed/5`](`scissorIndexed/5`) defines the scissor box for a\nspecified viewport. `Index` specifies the index of scissor box to modify.\n`Index` must be less than the value of `?GL_MAX_VIEWPORTS`. For\n[`gl:scissorIndexed/5`](`scissorIndexed/5`), `Left`, `Bottom`, `Width` and\n`Height` specify the left, bottom, width and height of the scissor box, in\npixels, respectively. For [`gl:scissorIndexedv/2`](`scissorIndexed/5`), `V`\nspecifies the address of an array containing integers specifying the lower left\ncorner of the scissor box, and the width and height of the scissor box, in that\norder.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glScissorIndexed.xhtml)","ref":"gl.html#scissorIndexedv/2"},{"type":"function","title":"gl.secondaryColor3b/3","doc":"","ref":"gl.html#secondaryColor3b/3"},{"type":"function","title":"gl.secondaryColor3bv/1","doc":"","ref":"gl.html#secondaryColor3bv/1"},{"type":"function","title":"gl.secondaryColor3d/3","doc":"","ref":"gl.html#secondaryColor3d/3"},{"type":"function","title":"gl.secondaryColor3dv/1","doc":"","ref":"gl.html#secondaryColor3dv/1"},{"type":"function","title":"gl.secondaryColor3f/3","doc":"","ref":"gl.html#secondaryColor3f/3"},{"type":"function","title":"gl.secondaryColor3fv/1","doc":"","ref":"gl.html#secondaryColor3fv/1"},{"type":"function","title":"gl.secondaryColor3i/3","doc":"","ref":"gl.html#secondaryColor3i/3"},{"type":"function","title":"gl.secondaryColor3iv/1","doc":"","ref":"gl.html#secondaryColor3iv/1"},{"type":"function","title":"gl.secondaryColor3s/3","doc":"","ref":"gl.html#secondaryColor3s/3"},{"type":"function","title":"gl.secondaryColor3sv/1","doc":"","ref":"gl.html#secondaryColor3sv/1"},{"type":"function","title":"gl.secondaryColor3ub/3","doc":"","ref":"gl.html#secondaryColor3ub/3"},{"type":"function","title":"gl.secondaryColor3ubv/1","doc":"","ref":"gl.html#secondaryColor3ubv/1"},{"type":"function","title":"gl.secondaryColor3ui/3","doc":"","ref":"gl.html#secondaryColor3ui/3"},{"type":"function","title":"gl.secondaryColor3uiv/1","doc":"","ref":"gl.html#secondaryColor3uiv/1"},{"type":"function","title":"gl.secondaryColor3us/3","doc":"","ref":"gl.html#secondaryColor3us/3"},{"type":"function","title":"gl.secondaryColor3usv/1","doc":"The GL stores both a primary four-valued RGBA color and a secondary four-valued\nRGBA color (where alpha is always set to 0.0) that is associated with every\nvertex.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSecondaryColor.xml)","ref":"gl.html#secondaryColor3usv/1"},{"type":"function","title":"gl.secondaryColorPointer/4","doc":"[`gl:secondaryColorPointer/4`](`secondaryColorPointer/4`) specifies the location\nand data format of an array of color components to use when rendering. `Size`\nspecifies the number of components per color, and must be 3. `Type` specifies\nthe data type of each color component, and `Stride` specifies the byte stride\nfrom one color to the next, allowing vertices and attributes to be packed into a\nsingle array or stored in separate arrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSecondaryColorPointer.xml)","ref":"gl.html#secondaryColorPointer/4"},{"type":"function","title":"gl.selectBuffer/2","doc":"[`gl:selectBuffer/2`](`selectBuffer/2`) has two arguments: `Buffer` is a pointer\nto an array of unsigned integers, and `Size` indicates the size of the array.\n`Buffer` returns values from the name stack (see\n[`gl:initNames/0`](`initNames/0`), [`gl:loadName/1`](`loadName/1`),\n[`gl:pushName/1`](`pushName/1`)) when the rendering mode is `?GL_SELECT` (see\n[`gl:renderMode/1`](`renderMode/1`)). [`gl:selectBuffer/2`](`selectBuffer/2`)\nmust be issued before selection mode is enabled, and it must not be issued while\nthe rendering mode is `?GL_SELECT`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSelectBuffer.xml)","ref":"gl.html#selectBuffer/2"},{"type":"function","title":"gl.separableFilter2D/8","doc":"[`gl:separableFilter2D/8`](`separableFilter2D/8`) builds a two-dimensional\nseparable convolution filter kernel from two arrays of pixels.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glSeparableFilter2D.xml)","ref":"gl.html#separableFilter2D/8"},{"type":"function","title":"gl.shadeModel/1","doc":"GL primitives can have either flat or smooth shading. Smooth shading, the\ndefault, causes the computed colors of vertices to be interpolated as the\nprimitive is rasterized, typically assigning different colors to each resulting\npixel fragment. Flat shading selects the computed color of just one vertex and\nassigns it to all the pixel fragments generated by rasterizing a single\nprimitive. In either case, the computed color of a vertex is the result of\nlighting if lighting is enabled, or it is the current color at the time the\nvertex was specified if lighting is disabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glShadeModel.xml)","ref":"gl.html#shadeModel/1"},{"type":"function","title":"gl.shaderBinary/3","doc":"[`gl:shaderBinary/3`](`shaderBinary/3`) loads pre-compiled shader binary code\ninto the `Count` shader objects whose handles are given in `Shaders`. `Binary`\npoints to `Length` bytes of binary shader code stored in client memory.\n`BinaryFormat` specifies the format of the pre-compiled code.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderBinary.xhtml)","ref":"gl.html#shaderBinary/3"},{"type":"function","title":"gl.shaderSource/2","doc":"[`gl:shaderSource/2`](`shaderSource/2`) sets the source code in `Shader` to the\nsource code in the array of strings specified by `String`. Any source code\npreviously stored in the shader object is completely replaced. The number of\nstrings in the array is specified by `Count`. If `Length` is `?NULL`, each\nstring is assumed to be null terminated. If `Length` is a value other than\n`?NULL`, it points to an array containing a string length for each of the\ncorresponding elements of `String`. Each element in the `Length` array may\ncontain the length of the corresponding string (the null character is not\ncounted as part of the string length) or a value less than 0 to indicate that\nthe string is null terminated. The source code strings are not scanned or parsed\nat this time; they are simply copied into the specified shader object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderSource.xhtml)","ref":"gl.html#shaderSource/2"},{"type":"function","title":"gl.shaderStorageBlockBinding/3","doc":"[`gl:shaderStorageBlockBinding/3`](`shaderStorageBlockBinding/3`), changes the\nactive shader storage block with an assigned index of `StorageBlockIndex` in\nprogram object `Program`. `StorageBlockIndex` must be an active shader storage\nblock index in `Program`. `StorageBlockBinding` must be less than the value of\n`?GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS`. If successful,\n[`gl:shaderStorageBlockBinding/3`](`shaderStorageBlockBinding/3`) specifies that\n`Program` will use the data store of the buffer object bound to the binding\npoint `StorageBlockBinding` to read and write the values of the buffer variables\nin the shader storage block identified by `StorageBlockIndex`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glShaderStorageBlockBinding.xhtml)","ref":"gl.html#shaderStorageBlockBinding/3"},{"type":"function","title":"gl.stencilFunc/3","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. Stencil planes are first drawn into using GL drawing primitives, then\ngeometry and images are rendered using the stencil planes to mask out portions\nof the screen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilFunc.xhtml)","ref":"gl.html#stencilFunc/3"},{"type":"function","title":"gl.stencilFuncSeparate/4","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. You draw into the stencil planes using GL drawing primitives, then render\ngeometry and images, using the stencil planes to mask out portions of the\nscreen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilFuncSeparate.xhtml)","ref":"gl.html#stencilFuncSeparate/4"},{"type":"function","title":"gl.stencilMask/1","doc":"[`gl:stencilMask/1`](`stencilMask/1`) controls the writing of individual bits in\nthe stencil planes. The least significant n bits of `Mask`, where n is the\nnumber of bits in the stencil buffer, specify a mask. Where a 1 appears in the\nmask, it's possible to write to the corresponding bit in the stencil buffer.\nWhere a 0 appears, the corresponding bit is write-protected. Initially, all bits\nare enabled for writing.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilMask.xhtml)","ref":"gl.html#stencilMask/1"},{"type":"function","title":"gl.stencilMaskSeparate/2","doc":"[`gl:stencilMaskSeparate/2`](`stencilMaskSeparate/2`) controls the writing of\nindividual bits in the stencil planes. The least significant n bits of `Mask`,\nwhere n is the number of bits in the stencil buffer, specify a mask. Where a 1\nappears in the mask, it's possible to write to the corresponding bit in the\nstencil buffer. Where a 0 appears, the corresponding bit is write-protected.\nInitially, all bits are enabled for writing.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilMaskSeparate.xhtml)","ref":"gl.html#stencilMaskSeparate/2"},{"type":"function","title":"gl.stencilOp/3","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. You draw into the stencil planes using GL drawing primitives, then render\ngeometry and images, using the stencil planes to mask out portions of the\nscreen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilOp.xhtml)","ref":"gl.html#stencilOp/3"},{"type":"function","title":"gl.stencilOpSeparate/4","doc":"Stenciling, like depth-buffering, enables and disables drawing on a per-pixel\nbasis. You draw into the stencil planes using GL drawing primitives, then render\ngeometry and images, using the stencil planes to mask out portions of the\nscreen. Stenciling is typically used in multipass rendering algorithms to\nachieve special effects, such as decals, outlining, and constructive solid\ngeometry rendering.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glStencilOpSeparate.xhtml)","ref":"gl.html#stencilOpSeparate/4"},{"type":"function","title":"gl.texBuffer/3","doc":"","ref":"gl.html#texBuffer/3"},{"type":"function","title":"gl.texBufferRange/5","doc":"","ref":"gl.html#texBufferRange/5"},{"type":"function","title":"gl.texCoord1d/1","doc":"","ref":"gl.html#texCoord1d/1"},{"type":"function","title":"gl.texCoord1dv/1","doc":"","ref":"gl.html#texCoord1dv/1"},{"type":"function","title":"gl.texCoord1f/1","doc":"","ref":"gl.html#texCoord1f/1"},{"type":"function","title":"gl.texCoord1fv/1","doc":"","ref":"gl.html#texCoord1fv/1"},{"type":"function","title":"gl.texCoord1i/1","doc":"","ref":"gl.html#texCoord1i/1"},{"type":"function","title":"gl.texCoord1iv/1","doc":"","ref":"gl.html#texCoord1iv/1"},{"type":"function","title":"gl.texCoord1s/1","doc":"","ref":"gl.html#texCoord1s/1"},{"type":"function","title":"gl.texCoord1sv/1","doc":"","ref":"gl.html#texCoord1sv/1"},{"type":"function","title":"gl.texCoord2d/2","doc":"","ref":"gl.html#texCoord2d/2"},{"type":"function","title":"gl.texCoord2dv/1","doc":"","ref":"gl.html#texCoord2dv/1"},{"type":"function","title":"gl.texCoord2f/2","doc":"","ref":"gl.html#texCoord2f/2"},{"type":"function","title":"gl.texCoord2fv/1","doc":"","ref":"gl.html#texCoord2fv/1"},{"type":"function","title":"gl.texCoord2i/2","doc":"","ref":"gl.html#texCoord2i/2"},{"type":"function","title":"gl.texCoord2iv/1","doc":"","ref":"gl.html#texCoord2iv/1"},{"type":"function","title":"gl.texCoord2s/2","doc":"","ref":"gl.html#texCoord2s/2"},{"type":"function","title":"gl.texCoord2sv/1","doc":"","ref":"gl.html#texCoord2sv/1"},{"type":"function","title":"gl.texCoord3d/3","doc":"","ref":"gl.html#texCoord3d/3"},{"type":"function","title":"gl.texCoord3dv/1","doc":"","ref":"gl.html#texCoord3dv/1"},{"type":"function","title":"gl.texCoord3f/3","doc":"","ref":"gl.html#texCoord3f/3"},{"type":"function","title":"gl.texCoord3fv/1","doc":"","ref":"gl.html#texCoord3fv/1"},{"type":"function","title":"gl.texCoord3i/3","doc":"","ref":"gl.html#texCoord3i/3"},{"type":"function","title":"gl.texCoord3iv/1","doc":"","ref":"gl.html#texCoord3iv/1"},{"type":"function","title":"gl.texCoord3s/3","doc":"","ref":"gl.html#texCoord3s/3"},{"type":"function","title":"gl.texCoord3sv/1","doc":"","ref":"gl.html#texCoord3sv/1"},{"type":"function","title":"gl.texCoord4d/4","doc":"","ref":"gl.html#texCoord4d/4"},{"type":"function","title":"gl.texCoord4dv/1","doc":"","ref":"gl.html#texCoord4dv/1"},{"type":"function","title":"gl.texCoord4f/4","doc":"","ref":"gl.html#texCoord4f/4"},{"type":"function","title":"gl.texCoord4fv/1","doc":"","ref":"gl.html#texCoord4fv/1"},{"type":"function","title":"gl.texCoord4i/4","doc":"","ref":"gl.html#texCoord4i/4"},{"type":"function","title":"gl.texCoord4iv/1","doc":"","ref":"gl.html#texCoord4iv/1"},{"type":"function","title":"gl.texCoord4s/4","doc":"","ref":"gl.html#texCoord4s/4"},{"type":"function","title":"gl.texCoord4sv/1","doc":"[`gl:texCoord()`](`texCoord1d/1`) specifies texture coordinates in one, two,\nthree, or four dimensions. [`gl:texCoord1()`](`texCoord1d/1`) sets the current\ntexture coordinates to (s 0 0 1); a call to [`gl:texCoord2()`](`texCoord1d/1`)\nsets them to (s t 0 1). Similarly, [`gl:texCoord3()`](`texCoord1d/1`) specifies\nthe texture coordinates as (s t r 1), and [`gl:texCoord4()`](`texCoord1d/1`)\ndefines all four components explicitly as (s t r q).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexCoord.xml)","ref":"gl.html#texCoord4sv/1"},{"type":"function","title":"gl.texCoordPointer/4","doc":"[`gl:texCoordPointer/4`](`texCoordPointer/4`) specifies the location and data\nformat of an array of texture coordinates to use when rendering. `Size`\nspecifies the number of coordinates per texture coordinate set, and must be 1,\n2, 3, or 4. `Type` specifies the data type of each texture coordinate, and\n`Stride` specifies the byte stride from one texture coordinate set to the next,\nallowing vertices and attributes to be packed into a single array or stored in\nseparate arrays. (Single-array storage may be more efficient on some\nimplementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexCoordPointer.xml)","ref":"gl.html#texCoordPointer/4"},{"type":"function","title":"gl.texEnvf/3","doc":"","ref":"gl.html#texEnvf/3"},{"type":"function","title":"gl.texEnvfv/3","doc":"","ref":"gl.html#texEnvfv/3"},{"type":"function","title":"gl.texEnvi/3","doc":"","ref":"gl.html#texEnvi/3"},{"type":"function","title":"gl.texEnviv/3","doc":"A texture environment specifies how texture values are interpreted when a\nfragment is textured. When `Target` is `?GL_TEXTURE_FILTER_CONTROL`, `Pname`\nmust be `?GL_TEXTURE_LOD_BIAS`. When `Target` is `?GL_TEXTURE_ENV`, `Pname` can\nbe `?GL_TEXTURE_ENV_MODE`, `?GL_TEXTURE_ENV_COLOR`, `?GL_COMBINE_RGB`,\n`?GL_COMBINE_ALPHA`, `?GL_RGB_SCALE`, `?GL_ALPHA_SCALE`, `?GL_SRC0_RGB`,\n`?GL_SRC1_RGB`, `?GL_SRC2_RGB`, `?GL_SRC0_ALPHA`, `?GL_SRC1_ALPHA`, or\n`?GL_SRC2_ALPHA`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexEnv.xml)","ref":"gl.html#texEnviv/3"},{"type":"function","title":"gl.texGend/3","doc":"","ref":"gl.html#texGend/3"},{"type":"function","title":"gl.texGendv/3","doc":"","ref":"gl.html#texGendv/3"},{"type":"function","title":"gl.texGenf/3","doc":"","ref":"gl.html#texGenf/3"},{"type":"function","title":"gl.texGenfv/3","doc":"","ref":"gl.html#texGenfv/3"},{"type":"function","title":"gl.texGeni/3","doc":"","ref":"gl.html#texGeni/3"},{"type":"function","title":"gl.texGeniv/3","doc":"[`gl:texGen()`](`texGend/3`) selects a texture-coordinate generation function or\nsupplies coefficients for one of the functions. `Coord` names one of the (`s`,\n`t`, `r`, `q`) texture coordinates; it must be one of the symbols `?GL_S`,\n`?GL_T`, `?GL_R`, or `?GL_Q`. `Pname` must be one of three symbolic constants:\n`?GL_TEXTURE_GEN_MODE`, `?GL_OBJECT_PLANE`, or `?GL_EYE_PLANE`. If `Pname` is\n`?GL_TEXTURE_GEN_MODE`, then `Params` chooses a mode, one of\n`?GL_OBJECT_LINEAR`, `?GL_EYE_LINEAR`, `?GL_SPHERE_MAP`, `?GL_NORMAL_MAP`, or\n`?GL_REFLECTION_MAP`. If `Pname` is either `?GL_OBJECT_PLANE` or\n`?GL_EYE_PLANE`, `Params` contains coefficients for the corresponding texture\ngeneration function.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTexGen.xml)","ref":"gl.html#texGeniv/3"},{"type":"function","title":"gl.texImage1D/8","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled. To enable and disable one-dimensional\ntexturing, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_TEXTURE_1D`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage1D.xhtml)","ref":"gl.html#texImage1D/8"},{"type":"function","title":"gl.texImage2D/9","doc":"Texturing allows elements of an image array to be read by shaders.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage2D.xhtml)","ref":"gl.html#texImage2D/9"},{"type":"function","title":"gl.texImage2DMultisample/6","doc":"[`gl:texImage2DMultisample/6`](`texImage2DMultisample/6`) establishes the data\nstorage, format, dimensions and number of samples of a multisample texture's\nimage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage2DMultisample.xhtml)","ref":"gl.html#texImage2DMultisample/6"},{"type":"function","title":"gl.texImage3D/10","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled. To enable and disable\nthree-dimensional texturing, call [`gl:enable/1`](`enable/1`) and\n[`gl:disable/1`](`enable/1`) with argument `?GL_TEXTURE_3D`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage3D.xhtml)","ref":"gl.html#texImage3D/10"},{"type":"function","title":"gl.texImage3DMultisample/7","doc":"[`gl:texImage3DMultisample/7`](`texImage3DMultisample/7`) establishes the data\nstorage, format, dimensions and number of samples of a multisample texture's\nimage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexImage3DMultisample.xhtml)","ref":"gl.html#texImage3DMultisample/7"},{"type":"function","title":"gl.texParameterf/3","doc":"","ref":"gl.html#texParameterf/3"},{"type":"function","title":"gl.texParameterfv/3","doc":"","ref":"gl.html#texParameterfv/3"},{"type":"function","title":"gl.texParameterIiv/3","doc":"","ref":"gl.html#texParameterIiv/3"},{"type":"function","title":"gl.texParameterIuiv/3","doc":"","ref":"gl.html#texParameterIuiv/3"},{"type":"function","title":"gl.texParameteri/3","doc":"","ref":"gl.html#texParameteri/3"},{"type":"function","title":"gl.texParameteriv/3","doc":"[`gl:texParameter()`](`texParameterf/3`) and\n[`gl:textureParameter()`](`texParameterf/3`) assign the value or values in\n`Params` to the texture parameter specified as `Pname`. For\n[`gl:texParameter()`](`texParameterf/3`), `Target` defines the target texture,\neither `?GL_TEXTURE_1D`, `?GL_TEXTURE_1D_ARRAY`, `?GL_TEXTURE_2D`,\n`?GL_TEXTURE_2D_ARRAY`, `?GL_TEXTURE_2D_MULTISAMPLE`,\n`?GL_TEXTURE_2D_MULTISAMPLE_ARRAY`, `?GL_TEXTURE_3D`, `?GL_TEXTURE_CUBE_MAP`,\n`?GL_TEXTURE_CUBE_MAP_ARRAY`, or `?GL_TEXTURE_RECTANGLE`. The following symbols\nare accepted in `Pname`:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexParameter.xhtml)","ref":"gl.html#texParameteriv/3"},{"type":"function","title":"gl.texStorage1D/4","doc":"[`gl:texStorage1D/4`](`texStorage1D/4`) and\n[`gl:textureStorage1D()`](`texStorage1D/4`) specify the storage requirements for\nall levels of a one-dimensional texture simultaneously. Once a texture is\nspecified with this command, the format and dimensions of all levels become\nimmutable unless it is a proxy texture. The contents of the image may still be\nmodified, however, its storage requirements may not change. Such a texture is\nreferred to as an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage1D.xhtml)","ref":"gl.html#texStorage1D/4"},{"type":"function","title":"gl.texStorage2D/5","doc":"[`gl:texStorage2D/5`](`texStorage2D/5`) and\n[`gl:textureStorage2D()`](`texStorage2D/5`) specify the storage requirements for\nall levels of a two-dimensional texture or one-dimensional texture array\nsimultaneously. Once a texture is specified with this command, the format and\ndimensions of all levels become immutable unless it is a proxy texture. The\ncontents of the image may still be modified, however, its storage requirements\nmay not change. Such a texture is referred to as an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage2D.xhtml)","ref":"gl.html#texStorage2D/5"},{"type":"function","title":"gl.texStorage2DMultisample/6","doc":"[`gl:texStorage2DMultisample/6`](`texStorage2DMultisample/6`) and\n[`gl:textureStorage2DMultisample()`](`texStorage2DMultisample/6`) specify the\nstorage requirements for a two-dimensional multisample texture. Once a texture\nis specified with this command, its format and dimensions become immutable\nunless it is a proxy texture. The contents of the image may still be modified,\nhowever, its storage requirements may not change. Such a texture is referred to\nas an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage2DMultisample.xhtml)","ref":"gl.html#texStorage2DMultisample/6"},{"type":"function","title":"gl.texStorage3D/6","doc":"[`gl:texStorage3D/6`](`texStorage3D/6`) and\n[`gl:textureStorage3D()`](`texStorage3D/6`) specify the storage requirements for\nall levels of a three-dimensional, two-dimensional array or cube-map array\ntexture simultaneously. Once a texture is specified with this command, the\nformat and dimensions of all levels become immutable unless it is a proxy\ntexture. The contents of the image may still be modified, however, its storage\nrequirements may not change. Such a texture is referred to as an\n`immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage3D.xhtml)","ref":"gl.html#texStorage3D/6"},{"type":"function","title":"gl.texStorage3DMultisample/7","doc":"[`gl:texStorage3DMultisample/7`](`texStorage3DMultisample/7`) and\n[`gl:textureStorage3DMultisample()`](`texStorage3DMultisample/7`) specify the\nstorage requirements for a two-dimensional multisample array texture. Once a\ntexture is specified with this command, its format and dimensions become\nimmutable unless it is a proxy texture. The contents of the image may still be\nmodified, however, its storage requirements may not change. Such a texture is\nreferred to as an `immutable-format` texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexStorage3DMultisample.xhtml)","ref":"gl.html#texStorage3DMultisample/7"},{"type":"function","title":"gl.texSubImage1D/7","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled. To enable or disable one-dimensional\ntexturing, call [`gl:enable/1`](`enable/1`) and [`gl:disable/1`](`enable/1`)\nwith argument `?GL_TEXTURE_1D`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexSubImage1D.xhtml)","ref":"gl.html#texSubImage1D/7"},{"type":"function","title":"gl.texSubImage2D/9","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexSubImage2D.xhtml)","ref":"gl.html#texSubImage2D/9"},{"type":"function","title":"gl.texSubImage3D/11","doc":"Texturing maps a portion of a specified texture image onto each graphical\nprimitive for which texturing is enabled.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexSubImage3D.xhtml)","ref":"gl.html#texSubImage3D/11"},{"type":"function","title":"gl.textureBarrier/0","doc":"The values of rendered fragments are undefined when a shader stage fetches\ntexels and the same texels are written via fragment shader outputs, even if the\nreads and writes are not in the same drawing command. To safely read the result\nof a written texel via a texel fetch in a subsequent drawing command, call\n[`gl:textureBarrier/0`](`textureBarrier/0`) between the two drawing commands to\nguarantee that writes have completed and caches have been invalidated before\nsubsequent drawing commands are executed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTextureBarrier.xhtml)","ref":"gl.html#textureBarrier/0"},{"type":"function","title":"gl.textureBuffer/3","doc":"[`gl:texBuffer/3`](`texBuffer/3`) and [`gl:textureBuffer/3`](`texBuffer/3`)\nattaches the data store of a specified buffer object to a specified texture\nobject, and specify the storage format for the texture image found in the buffer\nobject. The texture object must be a buffer texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexBuffer.xhtml)","ref":"gl.html#textureBuffer/3"},{"type":"function","title":"gl.textureBufferRange/5","doc":"[`gl:texBufferRange/5`](`texBufferRange/5`) and\n[`gl:textureBufferRange/5`](`texBufferRange/5`) attach a range of the data store\nof a specified buffer object to a specified texture object, and specify the\nstorage format for the texture image found in the buffer object. The texture\nobject must be a buffer texture.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTexBufferRange.xhtml)","ref":"gl.html#textureBufferRange/5"},{"type":"function","title":"gl.textureView/8","doc":"[`gl:textureView/8`](`textureView/8`) initializes a texture object as an alias,\nor view of another texture object, sharing some or all of the parent texture's\ndata store with the initialized texture. `Texture` specifies a name previously\nreserved by a successful call to [`gl:genTextures/1`](`genTextures/1`) but that\nhas not yet been bound or given a target. `Target` specifies the target for the\nnewly initialized texture and must be compatible with the target of the parent\ntexture, given in `Origtexture` as specified in the following table:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTextureView.xhtml)","ref":"gl.html#textureView/8"},{"type":"function","title":"gl.transformFeedbackBufferBase/3","doc":"[`gl:transformFeedbackBufferBase/3`](`transformFeedbackBufferBase/3`) binds the\nbuffer object `Buffer` to the binding point at index `Index` of the transform\nfeedback object `Xfb`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTransformFeedbackBufferBase.xhtml)","ref":"gl.html#transformFeedbackBufferBase/3"},{"type":"function","title":"gl.transformFeedbackBufferRange/5","doc":"[`gl:transformFeedbackBufferRange/5`](`transformFeedbackBufferRange/5`) binds a\nrange of the buffer object `Buffer` represented by `Offset` and `Size` to the\nbinding point at index `Index` of the transform feedback object `Xfb`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTransformFeedbackBufferRange.xhtml)","ref":"gl.html#transformFeedbackBufferRange/5"},{"type":"function","title":"gl.transformFeedbackVaryings/3","doc":"The names of the vertex or geometry shader outputs to be recorded in transform\nfeedback mode are specified using\n[`gl:transformFeedbackVaryings/3`](`transformFeedbackVaryings/3`). When a\ngeometry shader is active, transform feedback records the values of selected\ngeometry shader output variables from the emitted vertices. Otherwise, the\nvalues of the selected vertex shader outputs are recorded.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glTransformFeedbackVaryings.xhtml)","ref":"gl.html#transformFeedbackVaryings/3"},{"type":"function","title":"gl.translated/3","doc":"","ref":"gl.html#translated/3"},{"type":"function","title":"gl.translatef/3","doc":"[`gl:translate()`](`translated/3`) produces a translation by (x y z). The\ncurrent matrix (see [`gl:matrixMode/1`](`matrixMode/1`)) is multiplied by this\ntranslation matrix, with the product replacing the current matrix, as if\n[`gl:multMatrix()`](`multMatrixd/1`) were called with the following matrix for\nits argument:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glTranslate.xml)","ref":"gl.html#translatef/3"},{"type":"function","title":"gl.uniform1d/2","doc":"","ref":"gl.html#uniform1d/2"},{"type":"function","title":"gl.uniform1dv/2","doc":"","ref":"gl.html#uniform1dv/2"},{"type":"function","title":"gl.uniform1f/2","doc":"","ref":"gl.html#uniform1f/2"},{"type":"function","title":"gl.uniform1fv/2","doc":"","ref":"gl.html#uniform1fv/2"},{"type":"function","title":"gl.uniform1i/2","doc":"","ref":"gl.html#uniform1i/2"},{"type":"function","title":"gl.uniform1iv/2","doc":"","ref":"gl.html#uniform1iv/2"},{"type":"function","title":"gl.uniform1ui/2","doc":"","ref":"gl.html#uniform1ui/2"},{"type":"function","title":"gl.uniform1uiv/2","doc":"","ref":"gl.html#uniform1uiv/2"},{"type":"function","title":"gl.uniform2d/3","doc":"","ref":"gl.html#uniform2d/3"},{"type":"function","title":"gl.uniform2dv/2","doc":"","ref":"gl.html#uniform2dv/2"},{"type":"function","title":"gl.uniform2f/3","doc":"","ref":"gl.html#uniform2f/3"},{"type":"function","title":"gl.uniform2fv/2","doc":"","ref":"gl.html#uniform2fv/2"},{"type":"function","title":"gl.uniform2i/3","doc":"","ref":"gl.html#uniform2i/3"},{"type":"function","title":"gl.uniform2iv/2","doc":"","ref":"gl.html#uniform2iv/2"},{"type":"function","title":"gl.uniform2ui/3","doc":"","ref":"gl.html#uniform2ui/3"},{"type":"function","title":"gl.uniform2uiv/2","doc":"","ref":"gl.html#uniform2uiv/2"},{"type":"function","title":"gl.uniform3d/4","doc":"","ref":"gl.html#uniform3d/4"},{"type":"function","title":"gl.uniform3dv/2","doc":"","ref":"gl.html#uniform3dv/2"},{"type":"function","title":"gl.uniform3f/4","doc":"","ref":"gl.html#uniform3f/4"},{"type":"function","title":"gl.uniform3fv/2","doc":"","ref":"gl.html#uniform3fv/2"},{"type":"function","title":"gl.uniform3i/4","doc":"","ref":"gl.html#uniform3i/4"},{"type":"function","title":"gl.uniform3iv/2","doc":"","ref":"gl.html#uniform3iv/2"},{"type":"function","title":"gl.uniform3ui/4","doc":"","ref":"gl.html#uniform3ui/4"},{"type":"function","title":"gl.uniform3uiv/2","doc":"","ref":"gl.html#uniform3uiv/2"},{"type":"function","title":"gl.uniform4d/5","doc":"","ref":"gl.html#uniform4d/5"},{"type":"function","title":"gl.uniform4dv/2","doc":"","ref":"gl.html#uniform4dv/2"},{"type":"function","title":"gl.uniform4f/5","doc":"","ref":"gl.html#uniform4f/5"},{"type":"function","title":"gl.uniform4fv/2","doc":"","ref":"gl.html#uniform4fv/2"},{"type":"function","title":"gl.uniform4i/5","doc":"","ref":"gl.html#uniform4i/5"},{"type":"function","title":"gl.uniform4iv/2","doc":"","ref":"gl.html#uniform4iv/2"},{"type":"function","title":"gl.uniform4ui/5","doc":"","ref":"gl.html#uniform4ui/5"},{"type":"function","title":"gl.uniform4uiv/2","doc":"","ref":"gl.html#uniform4uiv/2"},{"type":"function","title":"gl.uniformBlockBinding/3","doc":"Binding points for active uniform blocks are assigned using\n[`gl:uniformBlockBinding/3`](`uniformBlockBinding/3`). Each of a program's\nactive uniform blocks has a corresponding uniform buffer binding point.\n`Program` is the name of a program object for which the command\n[`gl:linkProgram/1`](`linkProgram/1`) has been issued in the past.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniformBlockBinding.xhtml)","ref":"gl.html#uniformBlockBinding/3"},{"type":"function","title":"gl.uniformMatrix2dv/3","doc":"","ref":"gl.html#uniformMatrix2dv/3"},{"type":"function","title":"gl.uniformMatrix2fv/3","doc":"","ref":"gl.html#uniformMatrix2fv/3"},{"type":"function","title":"gl.uniformMatrix2x3dv/3","doc":"","ref":"gl.html#uniformMatrix2x3dv/3"},{"type":"function","title":"gl.uniformMatrix2x3fv/3","doc":"","ref":"gl.html#uniformMatrix2x3fv/3"},{"type":"function","title":"gl.uniformMatrix2x4dv/3","doc":"","ref":"gl.html#uniformMatrix2x4dv/3"},{"type":"function","title":"gl.uniformMatrix2x4fv/3","doc":"","ref":"gl.html#uniformMatrix2x4fv/3"},{"type":"function","title":"gl.uniformMatrix3dv/3","doc":"","ref":"gl.html#uniformMatrix3dv/3"},{"type":"function","title":"gl.uniformMatrix3fv/3","doc":"","ref":"gl.html#uniformMatrix3fv/3"},{"type":"function","title":"gl.uniformMatrix3x2dv/3","doc":"","ref":"gl.html#uniformMatrix3x2dv/3"},{"type":"function","title":"gl.uniformMatrix3x2fv/3","doc":"","ref":"gl.html#uniformMatrix3x2fv/3"},{"type":"function","title":"gl.uniformMatrix3x4dv/3","doc":"","ref":"gl.html#uniformMatrix3x4dv/3"},{"type":"function","title":"gl.uniformMatrix3x4fv/3","doc":"","ref":"gl.html#uniformMatrix3x4fv/3"},{"type":"function","title":"gl.uniformMatrix4dv/3","doc":"","ref":"gl.html#uniformMatrix4dv/3"},{"type":"function","title":"gl.uniformMatrix4fv/3","doc":"","ref":"gl.html#uniformMatrix4fv/3"},{"type":"function","title":"gl.uniformMatrix4x2dv/3","doc":"","ref":"gl.html#uniformMatrix4x2dv/3"},{"type":"function","title":"gl.uniformMatrix4x2fv/3","doc":"","ref":"gl.html#uniformMatrix4x2fv/3"},{"type":"function","title":"gl.uniformMatrix4x3dv/3","doc":"","ref":"gl.html#uniformMatrix4x3dv/3"},{"type":"function","title":"gl.uniformMatrix4x3fv/3","doc":"[`gl:uniform()`](`uniform1f/2`) modifies the value of a uniform variable or a\nuniform variable array. The location of the uniform variable to be modified is\nspecified by `Location`, which should be a value returned by\n[`gl:getUniformLocation/2`](`getUniformLocation/2`).\n[`gl:uniform()`](`uniform1f/2`) operates on the program object that was made\npart of current state by calling [`gl:useProgram/1`](`useProgram/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniform.xhtml)","ref":"gl.html#uniformMatrix4x3fv/3"},{"type":"function","title":"gl.uniformSubroutinesuiv/2","doc":"[`gl:uniformSubroutines()`](`uniformSubroutinesuiv/2`) loads all active\nsubroutine uniforms for shader stage `Shadertype` of the current program with\nsubroutine indices from `Indices`, storing `Indices[i]` into the uniform at\nlocation `I`. `Count` must be equal to the value of\n`?GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS` for the program currently in use at\nshader stage `Shadertype`. Furthermore, all values in `Indices` must be less\nthan the value of `?GL_ACTIVE_SUBROUTINES` for the shader stage.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUniformSubroutines.xhtml)","ref":"gl.html#uniformSubroutinesuiv/2"},{"type":"function","title":"gl.useProgram/1","doc":"[`gl:useProgram/1`](`useProgram/1`) installs the program object specified by\n`Program` as part of current rendering state. One or more executables are\ncreated in a program object by successfully attaching shader objects to it with\n[`gl:attachShader/2`](`attachShader/2`), successfully compiling the shader\nobjects with [`gl:compileShader/1`](`compileShader/1`), and successfully linking\nthe program object with [`gl:linkProgram/1`](`linkProgram/1`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUseProgram.xhtml)","ref":"gl.html#useProgram/1"},{"type":"function","title":"gl.useProgramStages/3","doc":"[`gl:useProgramStages/3`](`useProgramStages/3`) binds executables from a program\nobject associated with a specified set of shader stages to the program pipeline\nobject given by `Pipeline`. `Pipeline` specifies the program pipeline object to\nwhich to bind the executables. `Stages` contains a logical combination of bits\nindicating the shader stages to use within `Program` with the program pipeline\nobject `Pipeline`. `Stages` must be a logical combination of\n`?GL_VERTEX_SHADER_BIT`, `?GL_TESS_CONTROL_SHADER_BIT`,\n`?GL_TESS_EVALUATION_SHADER_BIT`, `?GL_GEOMETRY_SHADER_BIT`,\n`?GL_FRAGMENT_SHADER_BIT` and `?GL_COMPUTE_SHADER_BIT`. Additionally, the\nspecial value `?GL_ALL_SHADER_BITS` may be specified to indicate that all\nexecutables contained in `Program` should be installed in `Pipeline`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glUseProgramStages.xhtml)","ref":"gl.html#useProgramStages/3"},{"type":"function","title":"gl.validateProgram/1","doc":"[`gl:validateProgram/1`](`validateProgram/1`) checks to see whether the\nexecutables contained in `Program` can execute given the current OpenGL state.\nThe information generated by the validation process will be stored in\n`Program`'s information log. The validation information may consist of an empty\nstring, or it may be a string containing information about how the current\nprogram object interacts with the rest of current OpenGL state. This provides a\nway for OpenGL implementers to convey more information about why the current\nprogram is inefficient, suboptimal, failing to execute, and so on.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glValidateProgram.xhtml)","ref":"gl.html#validateProgram/1"},{"type":"function","title":"gl.validateProgramPipeline/1","doc":"[`gl:validateProgramPipeline/1`](`validateProgramPipeline/1`) instructs the\nimplementation to validate the shader executables contained in `Pipeline`\nagainst the current GL state. The implementation may use this as an opportunity\nto perform any internal shader modifications that may be required to ensure\ncorrect operation of the installed shaders given the current GL state.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glValidateProgramPipeline.xhtml)","ref":"gl.html#validateProgramPipeline/1"},{"type":"function","title":"gl.vertex2d/2","doc":"","ref":"gl.html#vertex2d/2"},{"type":"function","title":"gl.vertex2dv/1","doc":"","ref":"gl.html#vertex2dv/1"},{"type":"function","title":"gl.vertex2f/2","doc":"","ref":"gl.html#vertex2f/2"},{"type":"function","title":"gl.vertex2fv/1","doc":"","ref":"gl.html#vertex2fv/1"},{"type":"function","title":"gl.vertex2i/2","doc":"","ref":"gl.html#vertex2i/2"},{"type":"function","title":"gl.vertex2iv/1","doc":"","ref":"gl.html#vertex2iv/1"},{"type":"function","title":"gl.vertex2s/2","doc":"","ref":"gl.html#vertex2s/2"},{"type":"function","title":"gl.vertex2sv/1","doc":"","ref":"gl.html#vertex2sv/1"},{"type":"function","title":"gl.vertex3d/3","doc":"","ref":"gl.html#vertex3d/3"},{"type":"function","title":"gl.vertex3dv/1","doc":"","ref":"gl.html#vertex3dv/1"},{"type":"function","title":"gl.vertex3f/3","doc":"","ref":"gl.html#vertex3f/3"},{"type":"function","title":"gl.vertex3fv/1","doc":"","ref":"gl.html#vertex3fv/1"},{"type":"function","title":"gl.vertex3i/3","doc":"","ref":"gl.html#vertex3i/3"},{"type":"function","title":"gl.vertex3iv/1","doc":"","ref":"gl.html#vertex3iv/1"},{"type":"function","title":"gl.vertex3s/3","doc":"","ref":"gl.html#vertex3s/3"},{"type":"function","title":"gl.vertex3sv/1","doc":"","ref":"gl.html#vertex3sv/1"},{"type":"function","title":"gl.vertex4d/4","doc":"","ref":"gl.html#vertex4d/4"},{"type":"function","title":"gl.vertex4dv/1","doc":"","ref":"gl.html#vertex4dv/1"},{"type":"function","title":"gl.vertex4f/4","doc":"","ref":"gl.html#vertex4f/4"},{"type":"function","title":"gl.vertex4fv/1","doc":"","ref":"gl.html#vertex4fv/1"},{"type":"function","title":"gl.vertex4i/4","doc":"","ref":"gl.html#vertex4i/4"},{"type":"function","title":"gl.vertex4iv/1","doc":"","ref":"gl.html#vertex4iv/1"},{"type":"function","title":"gl.vertex4s/4","doc":"","ref":"gl.html#vertex4s/4"},{"type":"function","title":"gl.vertex4sv/1","doc":"[`gl:vertex()`](`vertex2d/2`) commands are used within\n[`gl:'begin'/1`](`'begin'/1`)/[`gl:'end'/0`](`'begin'/1`) pairs to specify\npoint, line, and polygon vertices. The current color, normal, texture\ncoordinates, and fog coordinate are associated with the vertex when\n[`gl:vertex()`](`vertex2d/2`) is called.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glVertex.xml)","ref":"gl.html#vertex4sv/1"},{"type":"function","title":"gl.vertexArrayAttribBinding/3","doc":"","ref":"gl.html#vertexArrayAttribBinding/3"},{"type":"function","title":"gl.vertexArrayAttribFormat/6","doc":"","ref":"gl.html#vertexArrayAttribFormat/6"},{"type":"function","title":"gl.vertexArrayAttribIFormat/5","doc":"","ref":"gl.html#vertexArrayAttribIFormat/5"},{"type":"function","title":"gl.vertexArrayAttribLFormat/5","doc":"","ref":"gl.html#vertexArrayAttribLFormat/5"},{"type":"function","title":"gl.vertexArrayBindingDivisor/3","doc":"","ref":"gl.html#vertexArrayBindingDivisor/3"},{"type":"function","title":"gl.vertexArrayElementBuffer/2","doc":"[`gl:vertexArrayElementBuffer/2`](`vertexArrayElementBuffer/2`) binds a buffer\nobject with id `Buffer` to the element array buffer bind point of a vertex array\nobject with id `Vaobj`. If `Buffer` is zero, any existing element array buffer\nbinding to `Vaobj` is removed.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexArrayElementBuffer.xhtml)","ref":"gl.html#vertexArrayElementBuffer/2"},{"type":"function","title":"gl.vertexArrayVertexBuffer/5","doc":"[`gl:bindVertexBuffer/4`](`bindVertexBuffer/4`) and\n[`gl:vertexArrayVertexBuffer/5`](`bindVertexBuffer/4`) bind the buffer named\n`Buffer` to the vertex buffer binding point whose index is given by\n`Bindingindex`. [`gl:bindVertexBuffer/4`](`bindVertexBuffer/4`) modifies the\nbinding of the currently bound vertex array object, whereas\n[`gl:vertexArrayVertexBuffer/5`](`bindVertexBuffer/4`) allows the caller to\nspecify ID of the vertex array object with an argument named `Vaobj`, for which\nthe binding should be modified. `Offset` and `Stride` specify the offset of the\nfirst element within the buffer and the distance between elements within the\nbuffer, respectively, and are both measured in basic machine units.\n`Bindingindex` must be less than the value of `?GL_MAX_VERTEX_ATTRIB_BINDINGS`.\n`Offset` and `Stride` must be greater than or equal to zero. If `Buffer` is\nzero, then any buffer currently bound to the specified binding point is unbound.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexBuffer.xhtml)","ref":"gl.html#vertexArrayVertexBuffer/5"},{"type":"function","title":"gl.vertexArrayVertexBuffers/5","doc":"[`gl:bindVertexBuffers/4`](`bindVertexBuffers/4`) and\n[`gl:vertexArrayVertexBuffers/5`](`bindVertexBuffers/4`) bind storage from an\narray of existing buffer objects to a specified number of consecutive vertex\nbuffer binding points units in a vertex array object. For\n[`gl:bindVertexBuffers/4`](`bindVertexBuffers/4`), the vertex array object is\nthe currently bound vertex array object. For\n[`gl:vertexArrayVertexBuffers/5`](`bindVertexBuffers/4`), `Vaobj` is the name of\nthe vertex array object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glBindVertexBuffers.xhtml)","ref":"gl.html#vertexArrayVertexBuffers/5"},{"type":"function","title":"gl.vertexAttrib1d/2","doc":"","ref":"gl.html#vertexAttrib1d/2"},{"type":"function","title":"gl.vertexAttrib1dv/2","doc":"","ref":"gl.html#vertexAttrib1dv/2"},{"type":"function","title":"gl.vertexAttrib1f/2","doc":"","ref":"gl.html#vertexAttrib1f/2"},{"type":"function","title":"gl.vertexAttrib1fv/2","doc":"","ref":"gl.html#vertexAttrib1fv/2"},{"type":"function","title":"gl.vertexAttrib1s/2","doc":"","ref":"gl.html#vertexAttrib1s/2"},{"type":"function","title":"gl.vertexAttrib1sv/2","doc":"","ref":"gl.html#vertexAttrib1sv/2"},{"type":"function","title":"gl.vertexAttrib2d/3","doc":"","ref":"gl.html#vertexAttrib2d/3"},{"type":"function","title":"gl.vertexAttrib2dv/2","doc":"","ref":"gl.html#vertexAttrib2dv/2"},{"type":"function","title":"gl.vertexAttrib2f/3","doc":"","ref":"gl.html#vertexAttrib2f/3"},{"type":"function","title":"gl.vertexAttrib2fv/2","doc":"","ref":"gl.html#vertexAttrib2fv/2"},{"type":"function","title":"gl.vertexAttrib2s/3","doc":"","ref":"gl.html#vertexAttrib2s/3"},{"type":"function","title":"gl.vertexAttrib2sv/2","doc":"","ref":"gl.html#vertexAttrib2sv/2"},{"type":"function","title":"gl.vertexAttrib3d/4","doc":"","ref":"gl.html#vertexAttrib3d/4"},{"type":"function","title":"gl.vertexAttrib3dv/2","doc":"","ref":"gl.html#vertexAttrib3dv/2"},{"type":"function","title":"gl.vertexAttrib3f/4","doc":"","ref":"gl.html#vertexAttrib3f/4"},{"type":"function","title":"gl.vertexAttrib3fv/2","doc":"","ref":"gl.html#vertexAttrib3fv/2"},{"type":"function","title":"gl.vertexAttrib3s/4","doc":"","ref":"gl.html#vertexAttrib3s/4"},{"type":"function","title":"gl.vertexAttrib3sv/2","doc":"","ref":"gl.html#vertexAttrib3sv/2"},{"type":"function","title":"gl.vertexAttrib4bv/2","doc":"","ref":"gl.html#vertexAttrib4bv/2"},{"type":"function","title":"gl.vertexAttrib4d/5","doc":"","ref":"gl.html#vertexAttrib4d/5"},{"type":"function","title":"gl.vertexAttrib4dv/2","doc":"","ref":"gl.html#vertexAttrib4dv/2"},{"type":"function","title":"gl.vertexAttrib4f/5","doc":"","ref":"gl.html#vertexAttrib4f/5"},{"type":"function","title":"gl.vertexAttrib4fv/2","doc":"","ref":"gl.html#vertexAttrib4fv/2"},{"type":"function","title":"gl.vertexAttrib4iv/2","doc":"","ref":"gl.html#vertexAttrib4iv/2"},{"type":"function","title":"gl.vertexAttrib4Nbv/2","doc":"","ref":"gl.html#vertexAttrib4Nbv/2"},{"type":"function","title":"gl.vertexAttrib4Niv/2","doc":"","ref":"gl.html#vertexAttrib4Niv/2"},{"type":"function","title":"gl.vertexAttrib4Nsv/2","doc":"","ref":"gl.html#vertexAttrib4Nsv/2"},{"type":"function","title":"gl.vertexAttrib4Nub/5","doc":"","ref":"gl.html#vertexAttrib4Nub/5"},{"type":"function","title":"gl.vertexAttrib4Nubv/2","doc":"","ref":"gl.html#vertexAttrib4Nubv/2"},{"type":"function","title":"gl.vertexAttrib4Nuiv/2","doc":"","ref":"gl.html#vertexAttrib4Nuiv/2"},{"type":"function","title":"gl.vertexAttrib4Nusv/2","doc":"","ref":"gl.html#vertexAttrib4Nusv/2"},{"type":"function","title":"gl.vertexAttrib4s/5","doc":"","ref":"gl.html#vertexAttrib4s/5"},{"type":"function","title":"gl.vertexAttrib4sv/2","doc":"","ref":"gl.html#vertexAttrib4sv/2"},{"type":"function","title":"gl.vertexAttrib4ubv/2","doc":"","ref":"gl.html#vertexAttrib4ubv/2"},{"type":"function","title":"gl.vertexAttrib4uiv/2","doc":"","ref":"gl.html#vertexAttrib4uiv/2"},{"type":"function","title":"gl.vertexAttrib4usv/2","doc":"","ref":"gl.html#vertexAttrib4usv/2"},{"type":"function","title":"gl.vertexAttribBinding/2","doc":"[`gl:vertexAttribBinding/2`](`vertexAttribBinding/2`) and\n[`gl:vertexArrayAttribBinding/3`](`vertexAttribBinding/2`) establishes an\nassociation between the generic vertex attribute of a vertex array object whose\nindex is given by `Attribindex`, and a vertex buffer binding whose index is\ngiven by `Bindingindex`. For\n[`gl:vertexAttribBinding/2`](`vertexAttribBinding/2`), the vertex array object\naffected is that currently bound. For\n[`gl:vertexArrayAttribBinding/3`](`vertexAttribBinding/2`), `Vaobj` is the name\nof the vertex array object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribBinding.xhtml)","ref":"gl.html#vertexAttribBinding/2"},{"type":"function","title":"gl.vertexAttribDivisor/2","doc":"[`gl:vertexAttribDivisor/2`](`vertexAttribDivisor/2`) modifies the rate at which\ngeneric vertex attributes advance when rendering multiple instances of\nprimitives in a single draw call. If `Divisor` is zero, the attribute at slot\n`Index` advances once per vertex. If `Divisor` is non-zero, the attribute\nadvances once per `Divisor` instances of the set(s) of vertices being rendered.\nAn attribute is referred to as instanced if its\n`?GL_VERTEX_ATTRIB_ARRAY_DIVISOR` value is non-zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribDivisor.xhtml)","ref":"gl.html#vertexAttribDivisor/2"},{"type":"function","title":"gl.vertexAttribFormat/5","doc":"","ref":"gl.html#vertexAttribFormat/5"},{"type":"function","title":"gl.vertexAttribI1i/2","doc":"","ref":"gl.html#vertexAttribI1i/2"},{"type":"function","title":"gl.vertexAttribI1iv/2","doc":"","ref":"gl.html#vertexAttribI1iv/2"},{"type":"function","title":"gl.vertexAttribI1ui/2","doc":"","ref":"gl.html#vertexAttribI1ui/2"},{"type":"function","title":"gl.vertexAttribI1uiv/2","doc":"","ref":"gl.html#vertexAttribI1uiv/2"},{"type":"function","title":"gl.vertexAttribI2i/3","doc":"","ref":"gl.html#vertexAttribI2i/3"},{"type":"function","title":"gl.vertexAttribI2iv/2","doc":"","ref":"gl.html#vertexAttribI2iv/2"},{"type":"function","title":"gl.vertexAttribI2ui/3","doc":"","ref":"gl.html#vertexAttribI2ui/3"},{"type":"function","title":"gl.vertexAttribI2uiv/2","doc":"","ref":"gl.html#vertexAttribI2uiv/2"},{"type":"function","title":"gl.vertexAttribI3i/4","doc":"","ref":"gl.html#vertexAttribI3i/4"},{"type":"function","title":"gl.vertexAttribI3iv/2","doc":"","ref":"gl.html#vertexAttribI3iv/2"},{"type":"function","title":"gl.vertexAttribI3ui/4","doc":"","ref":"gl.html#vertexAttribI3ui/4"},{"type":"function","title":"gl.vertexAttribI3uiv/2","doc":"","ref":"gl.html#vertexAttribI3uiv/2"},{"type":"function","title":"gl.vertexAttribI4bv/2","doc":"","ref":"gl.html#vertexAttribI4bv/2"},{"type":"function","title":"gl.vertexAttribI4i/5","doc":"","ref":"gl.html#vertexAttribI4i/5"},{"type":"function","title":"gl.vertexAttribI4iv/2","doc":"","ref":"gl.html#vertexAttribI4iv/2"},{"type":"function","title":"gl.vertexAttribI4sv/2","doc":"","ref":"gl.html#vertexAttribI4sv/2"},{"type":"function","title":"gl.vertexAttribI4ubv/2","doc":"","ref":"gl.html#vertexAttribI4ubv/2"},{"type":"function","title":"gl.vertexAttribI4ui/5","doc":"","ref":"gl.html#vertexAttribI4ui/5"},{"type":"function","title":"gl.vertexAttribI4uiv/2","doc":"","ref":"gl.html#vertexAttribI4uiv/2"},{"type":"function","title":"gl.vertexAttribI4usv/2","doc":"","ref":"gl.html#vertexAttribI4usv/2"},{"type":"function","title":"gl.vertexAttribIFormat/4","doc":"","ref":"gl.html#vertexAttribIFormat/4"},{"type":"function","title":"gl.vertexAttribIPointer/5","doc":"","ref":"gl.html#vertexAttribIPointer/5"},{"type":"function","title":"gl.vertexAttribL1d/2","doc":"","ref":"gl.html#vertexAttribL1d/2"},{"type":"function","title":"gl.vertexAttribL1dv/2","doc":"","ref":"gl.html#vertexAttribL1dv/2"},{"type":"function","title":"gl.vertexAttribL2d/3","doc":"","ref":"gl.html#vertexAttribL2d/3"},{"type":"function","title":"gl.vertexAttribL2dv/2","doc":"","ref":"gl.html#vertexAttribL2dv/2"},{"type":"function","title":"gl.vertexAttribL3d/4","doc":"","ref":"gl.html#vertexAttribL3d/4"},{"type":"function","title":"gl.vertexAttribL3dv/2","doc":"","ref":"gl.html#vertexAttribL3dv/2"},{"type":"function","title":"gl.vertexAttribL4d/5","doc":"","ref":"gl.html#vertexAttribL4d/5"},{"type":"function","title":"gl.vertexAttribL4dv/2","doc":"The [`gl:vertexAttrib()`](`vertexAttrib1d/2`) family of entry points allows an\napplication to pass generic vertex attributes in numbered locations.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttrib.xhtml)","ref":"gl.html#vertexAttribL4dv/2"},{"type":"function","title":"gl.vertexAttribLFormat/4","doc":"","ref":"gl.html#vertexAttribLFormat/4"},{"type":"function","title":"gl.vertexAttribLPointer/5","doc":"[`gl:vertexAttribFormat/5`](`vertexAttribFormat/5`),\n[`gl:vertexAttribIFormat/4`](`vertexAttribIPointer/5`) and\n[`gl:vertexAttribLFormat/4`](`vertexAttribIPointer/5`), as well as\n[`gl:vertexArrayAttribFormat/6`](`vertexAttribIPointer/5`),\n[`gl:vertexArrayAttribIFormat/5`](`vertexAttribIPointer/5`) and\n[`gl:vertexArrayAttribLFormat/5`](`vertexAttribIPointer/5`) specify the\norganization of data in vertex arrays. The first three calls operate on the\nbound vertex array object, whereas the last three ones modify the state of a\nvertex array object with ID `Vaobj`. `Attribindex` specifies the index of the\ngeneric vertex attribute array whose data layout is being described, and must be\nless than the value of `?GL_MAX_VERTEX_ATTRIBS`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribFormat.xhtml)","ref":"gl.html#vertexAttribLPointer/5"},{"type":"function","title":"gl.vertexAttribPointer/6","doc":"[`gl:vertexAttribPointer/6`](`vertexAttribPointer/6`),\n[`gl:vertexAttribIPointer/5`](`vertexAttribIPointer/5`) and\n[`gl:vertexAttribLPointer/5`](`vertexAttribIPointer/5`) specify the location and\ndata format of the array of generic vertex attributes at index `Index` to use\nwhen rendering. `Size` specifies the number of components per attribute and must\nbe 1, 2, 3, 4, or `?GL_BGRA`. `Type` specifies the data type of each component,\nand `Stride` specifies the byte stride from one attribute to the next, allowing\nvertices and attributes to be packed into a single array or stored in separate\narrays.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexAttribPointer.xhtml)","ref":"gl.html#vertexAttribPointer/6"},{"type":"function","title":"gl.vertexBindingDivisor/2","doc":"[`gl:vertexBindingDivisor/2`](`vertexBindingDivisor/2`) and\n[`gl:vertexArrayBindingDivisor/3`](`vertexBindingDivisor/2`) modify the rate at\nwhich generic vertex attributes advance when rendering multiple instances of\nprimitives in a single draw command. If `Divisor` is zero, the attributes using\nthe buffer bound to `Bindingindex` advance once per vertex. If `Divisor` is\nnon-zero, the attributes advance once per `Divisor` instances of the set(s) of\nvertices being rendered. An attribute is referred to as `instanced` if the\ncorresponding `Divisor` value is non-zero.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glVertexBindingDivisor.xhtml)","ref":"gl.html#vertexBindingDivisor/2"},{"type":"function","title":"gl.vertexPointer/4","doc":"[`gl:vertexPointer/4`](`vertexPointer/4`) specifies the location and data format\nof an array of vertex coordinates to use when rendering. `Size` specifies the\nnumber of coordinates per vertex, and must be 2, 3, or 4. `Type` specifies the\ndata type of each coordinate, and `Stride` specifies the byte stride from one\nvertex to the next, allowing vertices and attributes to be packed into a single\narray or stored in separate arrays. (Single-array storage may be more efficient\non some implementations; see [`gl:interleavedArrays/3`](`interleavedArrays/3`).)\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glVertexPointer.xml)","ref":"gl.html#vertexPointer/4"},{"type":"function","title":"gl.viewport/4","doc":"[`gl:viewport/4`](`viewport/4`) specifies the affine transformation of x and y\nfrom normalized device coordinates to window coordinates. Let (x nd y nd) be\nnormalized device coordinates. Then the window coordinates (x w y w) are\ncomputed as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewport.xhtml)","ref":"gl.html#viewport/4"},{"type":"function","title":"gl.viewportArrayv/2","doc":"[`gl:viewportArrayv/2`](`viewportArrayv/2`) specifies the parameters for\nmultiple viewports simulataneously. `First` specifies the index of the first\nviewport to modify and `Count` specifies the number of viewports to modify.\n`First` must be less than the value of `?GL_MAX_VIEWPORTS`, and `First` \\+\n`Count` must be less than or equal to the value of `?GL_MAX_VIEWPORTS`.\nViewports whose indices lie outside the range [`First`, `First` \\+ `Count`) are\nnot modified. `V` contains the address of an array of floating point values\nspecifying the left ( x), bottom ( y), width ( w), and height ( h) of each\nviewport, in that order. x and y give the location of the viewport's lower left\ncorner, and w and h give the width and height of the viewport, respectively. The\nviewport specifies the affine transformation of x and y from normalized device\ncoordinates to window coordinates. Let (x nd y nd) be normalized device\ncoordinates. Then the window coordinates (x w y w) are computed as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewportArray.xhtml)","ref":"gl.html#viewportArrayv/2"},{"type":"function","title":"gl.viewportIndexedf/5","doc":"","ref":"gl.html#viewportIndexedf/5"},{"type":"function","title":"gl.viewportIndexedfv/2","doc":"[`gl:viewportIndexedf/5`](`viewportIndexedf/5`) and\n[`gl:viewportIndexedfv/2`](`viewportIndexedf/5`) specify the parameters for a\nsingle viewport. `Index` specifies the index of the viewport to modify. `Index`\nmust be less than the value of `?GL_MAX_VIEWPORTS`. For\n[`gl:viewportIndexedf/5`](`viewportIndexedf/5`), `X`, `Y`, `W`, and `H` specify\nthe left, bottom, width and height of the viewport in pixels, respectively. For\n[`gl:viewportIndexedfv/2`](`viewportIndexedf/5`), `V` contains the address of an\narray of floating point values specifying the left ( x), bottom ( y), width (\nw), and height ( h) of each viewport, in that order. x and y give the location\nof the viewport's lower left corner, and w and h give the width and height of\nthe viewport, respectively. The viewport specifies the affine transformation of\nx and y from normalized device coordinates to window coordinates. Let (x nd y\nnd) be normalized device coordinates. Then the window coordinates (x w y w) are\ncomputed as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glViewportIndexed.xhtml)","ref":"gl.html#viewportIndexedfv/2"},{"type":"function","title":"gl.waitSync/3","doc":"[`gl:waitSync/3`](`waitSync/3`) causes the GL server to block and wait until\n`Sync` becomes signaled. `Sync` is the name of an existing sync object upon\nwhich to wait. `Flags` and `Timeout` are currently not used and must be set to\nzero and the special value `?GL_TIMEOUT_IGNORED`, respectively\n\n`Flags` and `Timeout` are placeholders for anticipated future extensions of sync\nobject capabilities. They must have these reserved values in order that existing\ncode calling [`gl:waitSync/3`](`waitSync/3`) operate properly in the presence of\nsuch extensions.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl4/html/glWaitSync.xhtml)","ref":"gl.html#waitSync/3"},{"type":"function","title":"gl.windowPos2d/2","doc":"","ref":"gl.html#windowPos2d/2"},{"type":"function","title":"gl.windowPos2dv/1","doc":"","ref":"gl.html#windowPos2dv/1"},{"type":"function","title":"gl.windowPos2f/2","doc":"","ref":"gl.html#windowPos2f/2"},{"type":"function","title":"gl.windowPos2fv/1","doc":"","ref":"gl.html#windowPos2fv/1"},{"type":"function","title":"gl.windowPos2i/2","doc":"","ref":"gl.html#windowPos2i/2"},{"type":"function","title":"gl.windowPos2iv/1","doc":"","ref":"gl.html#windowPos2iv/1"},{"type":"function","title":"gl.windowPos2s/2","doc":"","ref":"gl.html#windowPos2s/2"},{"type":"function","title":"gl.windowPos2sv/1","doc":"","ref":"gl.html#windowPos2sv/1"},{"type":"function","title":"gl.windowPos3d/3","doc":"","ref":"gl.html#windowPos3d/3"},{"type":"function","title":"gl.windowPos3dv/1","doc":"","ref":"gl.html#windowPos3dv/1"},{"type":"function","title":"gl.windowPos3f/3","doc":"","ref":"gl.html#windowPos3f/3"},{"type":"function","title":"gl.windowPos3fv/1","doc":"","ref":"gl.html#windowPos3fv/1"},{"type":"function","title":"gl.windowPos3i/3","doc":"","ref":"gl.html#windowPos3i/3"},{"type":"function","title":"gl.windowPos3iv/1","doc":"","ref":"gl.html#windowPos3iv/1"},{"type":"function","title":"gl.windowPos3s/3","doc":"","ref":"gl.html#windowPos3s/3"},{"type":"function","title":"gl.windowPos3sv/1","doc":"The GL maintains a 3D position in window coordinates. This position, called the\nraster position, is used to position pixel and bitmap write operations. It is\nmaintained with subpixel accuracy. See [`gl:bitmap/7`](`bitmap/7`),\n[`gl:drawPixels/5`](`drawPixels/5`), and [`gl:copyPixels/5`](`copyPixels/5`).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/glWindowPos.xml)","ref":"gl.html#windowPos3sv/1"},{"type":"type","title":"gl.clamp/0","doc":"","ref":"gl.html#t:clamp/0"},{"type":"type","title":"gl.enum/0","doc":"","ref":"gl.html#t:enum/0"},{"type":"type","title":"gl.f/0","doc":"","ref":"gl.html#t:f/0"},{"type":"type","title":"gl.i/0","doc":"","ref":"gl.html#t:i/0"},{"type":"type","title":"gl.m12/0","doc":"","ref":"gl.html#t:m12/0"},{"type":"type","title":"gl.m16/0","doc":"","ref":"gl.html#t:m16/0"},{"type":"type","title":"gl.matrix/0","doc":"","ref":"gl.html#t:matrix/0"},{"type":"type","title":"gl.mem/0","doc":"","ref":"gl.html#t:mem/0"},{"type":"type","title":"gl.offset/0","doc":"","ref":"gl.html#t:offset/0"},{"type":"module","title":"glu","doc":"Erlang wrapper functions for OpenGL\n\nStandard OpenGL API\n\nThis documents the functions as a brief version of the complete\n[OpenGL reference pages.](https://www.khronos.org/registry/OpenGL-Refpages/)","ref":"glu.html"},{"type":"function","title":"glu.build1DMipmapLevels/9","doc":"[`glu:build1DMipmapLevels/9`](`build1DMipmapLevels/9`) builds a subset of\nprefiltered one-dimensional texture maps of decreasing resolutions called a\nmipmap. This is used for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild1DMipmapLevels.xml)","ref":"glu.html#build1DMipmapLevels/9"},{"type":"function","title":"glu.build1DMipmaps/6","doc":"[`glu:build1DMipmaps/6`](`build1DMipmaps/6`) builds a series of prefiltered\none-dimensional texture maps of decreasing resolutions called a mipmap. This is\nused for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild1DMipmaps.xml)","ref":"glu.html#build1DMipmaps/6"},{"type":"function","title":"glu.build2DMipmapLevels/10","doc":"[`glu:build2DMipmapLevels/10`](`build2DMipmapLevels/10`) builds a subset of\nprefiltered two-dimensional texture maps of decreasing resolutions called a\nmipmap. This is used for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild2DMipmapLevels.xml)","ref":"glu.html#build2DMipmapLevels/10"},{"type":"function","title":"glu.build2DMipmaps/7","doc":"[`glu:build2DMipmaps/7`](`build2DMipmaps/7`) builds a series of prefiltered\ntwo-dimensional texture maps of decreasing resolutions called a mipmap. This is\nused for the antialiasing of texture-mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild2DMipmaps.xml)","ref":"glu.html#build2DMipmaps/7"},{"type":"function","title":"glu.build3DMipmapLevels/11","doc":"[`glu:build3DMipmapLevels/11`](`build3DMipmapLevels/11`) builds a subset of\nprefiltered three-dimensional texture maps of decreasing resolutions called a\nmipmap. This is used for the antialiasing of texture mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild3DMipmapLevels.xml)","ref":"glu.html#build3DMipmapLevels/11"},{"type":"function","title":"glu.build3DMipmaps/8","doc":"[`glu:build3DMipmaps/8`](`build3DMipmaps/8`) builds a series of prefiltered\nthree-dimensional texture maps of decreasing resolutions called a mipmap. This\nis used for the antialiasing of texture-mapped primitives.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluBuild3DMipmaps.xml)","ref":"glu.html#build3DMipmaps/8"},{"type":"function","title":"glu.checkExtension/2","doc":"[`glu:checkExtension/2`](`checkExtension/2`) returns `?GLU_TRUE` if `ExtName` is\nsupported otherwise `?GLU_FALSE` is returned.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluCheckExtension.xml)","ref":"glu.html#checkExtension/2"},{"type":"function","title":"glu.cylinder/6","doc":"[`glu:cylinder/6`](`cylinder/6`) draws a cylinder oriented along the `z` axis.\nThe base of the cylinder is placed at `z` = 0 and the top at z=height. Like a\nsphere, a cylinder is subdivided around the `z` axis into slices and along the\n`z` axis into stacks.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluCylinder.xml)","ref":"glu.html#cylinder/6"},{"type":"function","title":"glu.deleteQuadric/1","doc":"[`glu:deleteQuadric/1`](`deleteQuadric/1`) destroys the quadrics object (created\nwith [`glu:newQuadric/0`](`newQuadric/0`)) and frees any memory it uses. Once\n[`glu:deleteQuadric/1`](`deleteQuadric/1`) has been called, `Quad` cannot be\nused again.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluDeleteQuadric.xml)","ref":"glu.html#deleteQuadric/1"},{"type":"function","title":"glu.disk/5","doc":"[`glu:disk/5`](`disk/5`) renders a disk on the `z` = 0 plane. The disk has a\nradius of `Outer` and contains a concentric circular hole with a radius of\n`Inner`. If `Inner` is 0, then no hole is generated. The disk is subdivided\naround the `z` axis into slices (like pizza slices) and also about the `z` axis\ninto rings (as specified by `Slices` and `Loops`, respectively).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluDisk.xml)","ref":"glu.html#disk/5"},{"type":"function","title":"glu.errorString/1","doc":"[`glu:errorString/1`](`errorString/1`) produces an error string from a GL or GLU\nerror code. The string is in ISO Latin 1 format. For example,\n[`glu:errorString/1`](`errorString/1`)(`?GLU_OUT_OF_MEMORY`) returns the string\n`out of memory`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluErrorString.xml)","ref":"glu.html#errorString/1"},{"type":"function","title":"glu.getString/1","doc":"[`glu:getString/1`](`getString/1`) returns a pointer to a static string\ndescribing the GLU version or the GLU extensions that are supported.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluGetString.xml)","ref":"glu.html#getString/1"},{"type":"function","title":"glu.lookAt/9","doc":"[`glu:lookAt/9`](`lookAt/9`) creates a viewing matrix derived from an eye point,\na reference point indicating the center of the scene, and an `UP` vector.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluLookAt.xml)","ref":"glu.html#lookAt/9"},{"type":"function","title":"glu.newQuadric/0","doc":"[`glu:newQuadric/0`](`newQuadric/0`) creates and returns a pointer to a new\nquadrics object. This object must be referred to when calling quadrics rendering\nand control functions. A return value of 0 means that there is not enough memory\nto allocate the object.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluNewQuadric.xml)","ref":"glu.html#newQuadric/0"},{"type":"function","title":"glu.ortho2D/4","doc":"[`glu:ortho2D/4`](`ortho2D/4`) sets up a two-dimensional orthographic viewing\nregion. This is equivalent to calling `gl:ortho/6` with near=-1 and far=1.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluOrtho2D.xml)","ref":"glu.html#ortho2D/4"},{"type":"function","title":"glu.partialDisk/7","doc":"[`glu:partialDisk/7`](`partialDisk/7`) renders a partial disk on the z=0 plane.\nA partial disk is similar to a full disk, except that only the subset of the\ndisk from `Start` through `Start` \\+ `Sweep` is included (where 0 degrees is\nalong the +f2yf axis, 90 degrees along the +`x` axis, 180 degrees along the -`y`\naxis, and 270 degrees along the -`x` axis).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluPartialDisk.xml)","ref":"glu.html#partialDisk/7"},{"type":"function","title":"glu.perspective/4","doc":"[`glu:perspective/4`](`perspective/4`) specifies a viewing frustum into the\nworld coordinate system. In general, the aspect ratio in\n[`glu:perspective/4`](`perspective/4`) should match the aspect ratio of the\nassociated viewport. For example, aspect=2.0 means the viewer's angle of view is\ntwice as wide in `x` as it is in `y`. If the viewport is twice as wide as it is\ntall, it displays the image without distortion.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluPerspective.xml)","ref":"glu.html#perspective/4"},{"type":"function","title":"glu.pickMatrix/5","doc":"[`glu:pickMatrix/5`](`pickMatrix/5`) creates a projection matrix that can be\nused to restrict drawing to a small region of the viewport. This is typically\nuseful to determine what objects are being drawn near the cursor. Use\n[`glu:pickMatrix/5`](`pickMatrix/5`) to restrict drawing to a small region\naround the cursor. Then, enter selection mode (with `gl:renderMode/1`) and\nrerender the scene. All primitives that would have been drawn near the cursor\nare identified and stored in the selection buffer.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluPickMatrix.xml)","ref":"glu.html#pickMatrix/5"},{"type":"function","title":"glu.project/6","doc":"[`glu:project/6`](`project/6`) transforms the specified object coordinates into\nwindow coordinates using `Model`, `Proj`, and `View`. The result is stored in\n`WinX`, `WinY`, and `WinZ`. A return value of `?GLU_TRUE` indicates success, a\nreturn value of `?GLU_FALSE` indicates failure.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluProject.xml)","ref":"glu.html#project/6"},{"type":"function","title":"glu.quadricDrawStyle/2","doc":"[`glu:quadricDrawStyle/2`](`quadricDrawStyle/2`) specifies the draw style for\nquadrics rendered with `Quad`. The legal values are as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricDrawStyle.xml)","ref":"glu.html#quadricDrawStyle/2"},{"type":"function","title":"glu.quadricNormals/2","doc":"[`glu:quadricNormals/2`](`quadricNormals/2`) specifies what kind of normals are\ndesired for quadrics rendered with `Quad`. The legal values are as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricNormals.xml)","ref":"glu.html#quadricNormals/2"},{"type":"function","title":"glu.quadricOrientation/2","doc":"[`glu:quadricOrientation/2`](`quadricOrientation/2`) specifies what kind of\norientation is desired for quadrics rendered with `Quad`. The `Orientation`\nvalues are as follows:\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricOrientation.xml)","ref":"glu.html#quadricOrientation/2"},{"type":"function","title":"glu.quadricTexture/2","doc":"[`glu:quadricTexture/2`](`quadricTexture/2`) specifies if texture coordinates\nshould be generated for quadrics rendered with `Quad`. If the value of `Texture`\nis `?GLU_TRUE`, then texture coordinates are generated, and if `Texture` is\n`?GLU_FALSE`, they are not. The initial value is `?GLU_FALSE`.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluQuadricTexture.xml)","ref":"glu.html#quadricTexture/2"},{"type":"function","title":"glu.scaleImage/9","doc":"[`glu:scaleImage/9`](`scaleImage/9`) scales a pixel image using the appropriate\npixel store modes to unpack data from the source image and pack data into the\ndestination image.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluScaleImage.xml)","ref":"glu.html#scaleImage/9"},{"type":"function","title":"glu.sphere/4","doc":"[`glu:sphere/4`](`sphere/4`) draws a sphere of the given radius centered around\nthe origin. The sphere is subdivided around the `z` axis into slices and along\nthe `z` axis into stacks (similar to lines of longitude and latitude).\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluSphere.xml)","ref":"glu.html#sphere/4"},{"type":"function","title":"glu.tesselate/2","doc":"Triangulates a polygon, the polygon is specified by a `Normal` and `Vs` a list\nof vertex positions.\n\nThe function returns a list of indices of the vertices and a binary (64bit\nnative float) containing an array of vertex positions, it starts with the\nvertices in `Vs` and may contain newly created vertices in the end.","ref":"glu.html#tesselate/2"},{"type":"function","title":"glu.unProject4/9","doc":"[`glu:unProject/6`](`unProject/6`) maps the specified window coordinates into\nobject coordinates using `Model`, `Proj`, and `View`. The result is stored in\n`ObjX`, `ObjY`, and `ObjZ`. A return value of `?GLU_TRUE` indicates success; a\nreturn value of `?GLU_FALSE` indicates failure.\n\n[External documentation.](https://www.khronos.org/registry/OpenGL-Refpages/gl2.1/xhtml/gluUnProject.xml)","ref":"glu.html#unProject4/9"},{"type":"function","title":"glu.unProject/6","doc":"","ref":"glu.html#unProject/6"},{"type":"type","title":"glu.enum/0","doc":"","ref":"glu.html#t:enum/0"},{"type":"type","title":"glu.f/0","doc":"","ref":"glu.html#t:f/0"},{"type":"type","title":"glu.i/0","doc":"","ref":"glu.html#t:i/0"},{"type":"type","title":"glu.m12/0","doc":"","ref":"glu.html#t:m12/0"},{"type":"type","title":"glu.m16/0","doc":"","ref":"glu.html#t:m16/0"},{"type":"type","title":"glu.matrix/0","doc":"","ref":"glu.html#t:matrix/0"},{"type":"type","title":"glu.mem/0","doc":"","ref":"glu.html#t:mem/0"},{"type":"type","title":"glu.vertex/0","doc":"","ref":"glu.html#t:vertex/0"},{"type":"module","title":"wx","doc":"A port of wxWidgets.\n\nA port of [wxWidgets](http://www.wxwidgets.org/).\n\nThis is the base api of [wxWidgets](http://www.wxwidgets.org/). This module\ncontains functions for starting and stopping the wx-server, as well as other\nutility functions.\n\nwxWidgets is object oriented, and not functional. Thus, in Wx a module\nrepresents a class, and the object created by this class has an own type,\nwxCLASS(). This module represents the base class, and all other wxMODULE's are\nsub-classes of this class.\n\nObjects of a class are created with wxCLASS:new(...) and destroyed with\nwxCLASS:destroy(). Member functions are called with wxCLASS:member(Object, ...)\ninstead of as in C++ Object.member(...).\n\nSub class modules inherit (non static) functions from their parents. The\ninherited functions are not documented in the sub-classes.\n\nThis erlang port of wxWidgets tries to be a one-to-one mapping with the original\nwxWidgets library. Some things are different though, as the optional arguments\nuse property lists and can be in any order. The main difference is the event\nhandling which is different from the original library. See `m:wxEvtHandler`.\n\nThe following classes are implemented directly as erlang types:  \nwxPoint=\\{x,y\\},wxSize=\\{w,h\\},wxRect=\\{x,y,w,h\\},wxColour=\\{r,g,b \\[,a]\\},\nwxString=[unicode:chardata()](`t:unicode:chardata/0`),\nwxGBPosition=\\{r,c\\},wxGBSpan=\\{rs,cs\\},wxGridCellCoords=\\{r,c\\}.\n\nwxWidgets uses a process specific environment, which is created by\n[wx:new/0](`new/0`). To be able to use the environment from other processes,\ncall `get_env/0` to retrieve the environment and `set_env/1` to assign the\nenvironment in the other process.\n\nGlobal (classless) functions are located in the wx_misc module.","ref":"wx.html"},{"type":"module","title":"DATA TYPES - wx","doc":"- **[](){: #type-wx_colour } wx_colour() = \\{R::byte(), G::byte(), B::byte()\\} |\n  [wx_colour4()](`m:wx#type-wx_colour4`)**\n\n- **[](){: #type-wx_colour4 } wx_colour4() = \\{R::byte(), G::byte(), B::byte(),\n  A::byte()\\}**\n\n- **[](){: #type-wx_datetime } wx_datetime() = \\{\\{Year::integer(),\n  Month::integer(), Day::integer()\\}, \\{Hour::integer(), Minute::integer(),\n  Second::integer()\\}\\}**\n\n  In Local Timezone\n\n- **[](){: #type-wx_enum } wx_enum() = integer()**\n\n  Constant defined in wx.hrl\n\n- **[](){: #type-wx_env } wx_env() = #wx_env\\{\\}**\n\n  Opaque process environment\n\n- **[](){: #type-wx_memory } wx_memory() = binary() | #wx_mem\\{\\}**\n\n  Opaque memory reference\n\n- **[](){: #type-wx_object } wx_object() = #wx_ref\\{\\}**\n\n  Opaque object reference\n\n- **[](){: #type-wx_wxHtmlLinkInfo } wx_wxHtmlLinkInfo() =\n  #wxHtmlLinkInfo\\{href=[unicode:chardata()](`t:unicode:chardata/0`),\n  target=[unicode:chardata()](`t:unicode:chardata/0`)\\}**\n\n- **[](){: #type-wx_wxMouseState } wx_wxMouseState() =\n  #wxMouseState\\{x=integer(), y=integer(), leftDown=boolean(),\n  middleDown=boolean(), rightDown=boolean(), controlDown=boolean(),\n  shiftDown=boolean(), altDown=boolean(), metaDown=boolean(),\n  cmdDown=boolean()\\}**\n\n  See #wxMouseState\\{\\} defined in wx.hrl","ref":"wx.html#module-data-types"},{"type":"function","title":"wx.batch/1","doc":"batch(Fun::function()) -> term()\n\nBatches all `wx` commands used in the fun. Improves performance of the command\nprocessing by grabbing the wxWidgets thread so that no event processing will be\ndone before the complete batch of commands is invoked.\n\n_See also:_ `foldl/3`, `foldr/3`, `foreach/2`, `map/2`.","ref":"wx.html#batch/1"},{"type":"function","title":"wx.create_memory/1","doc":"create_memory(Size::integer()) -> wx_memory()\n\nCreates a memory area (of Size in bytes) which can be used by an external\nlibrary (i.e. opengl). It is up to the client to keep a reference to this object\nso it does not get garbage collected by erlang while still in use by the\nexternal library.\n\nThis is far from erlang's intentional usage and can crash the erlang emulator.\nUse it carefully.","ref":"wx.html#create_memory/1"},{"type":"function","title":"wx.debug/1","doc":"debug(Debug::Level | [Level]) -> ok\n\nSets debug level. If debug level is 'verbose' or 'trace' each call is printed on\nconsole. If Level is 'driver' each allocated object and deletion is printed on\nthe console.","ref":"wx.html#debug/1"},{"type":"function","title":"wx.demo/0","doc":"demo() -> ok | {error, atom()}\n\nStarts a Wx demo if examples directory exists and is compiled","ref":"wx.html#demo/0"},{"type":"function","title":"wx.destroy/0","doc":"destroy() -> ok\n\nStops a wx server.","ref":"wx.html#destroy/0"},{"type":"function","title":"wx.equal/2","doc":"equal(Wx_ref::wx_object(), X2::wx_object()) -> boolean()\n\nReturns true if both arguments references the same object, false otherwise","ref":"wx.html#equal/2"},{"type":"function","title":"wx.foldl/3","doc":"foldl(Fun::function(), Acc::term(), List::list()) -> term()\n\nBehaves like `lists:foldl/3` but batches wx commands. See `batch/1`.","ref":"wx.html#foldl/3"},{"type":"function","title":"wx.foldr/3","doc":"foldr(Fun::function(), Acc::term(), List::list()) -> term()\n\nBehaves like `lists:foldr/3` but batches wx commands. See `batch/1`.","ref":"wx.html#foldr/3"},{"type":"function","title":"wx.foreach/2","doc":"foreach(Fun::function(), List::list()) -> ok\n\nBehaves like `lists:foreach/2` but batches wx commands. See `batch/1`.","ref":"wx.html#foreach/2"},{"type":"function","title":"wx.get_env/0","doc":"get_env() -> wx_env()\n\nGets this process's current wx environment. Can be sent to other processes to\nallow them use this process wx environment.\n\n_See also:_ `set_env/1`.","ref":"wx.html#get_env/0"},{"type":"function","title":"wx.get_memory_bin/1","doc":"get_memory_bin(Wx_mem::wx_memory()) -> binary()\n\nReturns the memory area as a binary.","ref":"wx.html#get_memory_bin/1"},{"type":"function","title":"wx.getObjectType/1","doc":"getObjectType(Wx_ref::wx_object()) -> atom()\n\nReturns the object type","ref":"wx.html#getObjectType/1"},{"type":"function","title":"wx.is_null/1","doc":"is_null(Wx_ref::wx_object()) -> boolean()\n\nReturns true if object is null, false otherwise","ref":"wx.html#is_null/1"},{"type":"function","title":"wx.map/2","doc":"map(Fun::function(), List::list()) -> list()\n\nBehaves like `lists:map/2` but batches wx commands. See `batch/1`.","ref":"wx.html#map/2"},{"type":"function","title":"wx.new/0","doc":"new() -> wx_object()\n\nStarts a wx server.","ref":"wx.html#new/0"},{"type":"function","title":"wx.new/1","doc":"new(Options::[Option]) -> wx_object()\n\nStarts a wx server. Option may be \\{debug, Level\\}, see debug/1. Or\n\\{silent_start, Bool\\}, which causes error messages at startup to be suppressed.\nThe latter can be used as a silent test of whether wx is properly installed or\nnot.","ref":"wx.html#new/1"},{"type":"function","title":"wx.null/0","doc":"null() -> wx_object()\n\nReturns the null object","ref":"wx.html#null/0"},{"type":"function","title":"wx.parent_class/1","doc":"parent_class(X1) -> term()","ref":"wx.html#parent_class/1"},{"type":"function","title":"wx.release_memory/1","doc":"release_memory(Wx_mem::wx_memory()) -> ok","ref":"wx.html#release_memory/1"},{"type":"function","title":"wx.retain_memory/1","doc":"retain_memory(Wx_mem::wx_memory()) -> ok\n\nSaves the memory from deletion until release_memory/1 is called. If\nrelease_memory/1 is not called the memory will not be garbage collected.","ref":"wx.html#retain_memory/1"},{"type":"function","title":"wx.set_env/1","doc":"set_env(Wx_env::wx_env()) -> ok\n\nSets the process wx environment, allows this process to use another process wx\nenvironment.","ref":"wx.html#set_env/1"},{"type":"function","title":"wx.subscribe_events/0","doc":"subscribe_events() -> ok\n\nAdds the calling process to the list of of processes that are listening to wx\napplication events.\n\nAt the moment these are all MacOSX specific events corresponding to\n`MacNewFile()` and friends from wxWidgets\n[wxApp](https://docs.wxwidgets.org/trunk/classwx_app.html):\n\n- `{new_file, \"\"}`\n- `{open_file, Filename}`\n- `{print_file, Filename}`\n- `{open_url, Url}`\n- `{reopen_app, \"\"}`\n\nThe call always returns ok but will have sent any already received events to the\ncalling process.","ref":"wx.html#subscribe_events/0"},{"type":"function","title":"wx.typeCast/2","doc":"typeCast(Old::wx_object(), NewType::atom()) -> wx_object()\n\nCasts the object to class NewType. It is needed when using functions like\nwxWindow:findWindow/2, which returns a generic wxObject type.","ref":"wx.html#typeCast/2"},{"type":"type","title":"wx.wx_colour4/0","doc":"","ref":"wx.html#t:wx_colour4/0"},{"type":"type","title":"wx.wx_colour/0","doc":"","ref":"wx.html#t:wx_colour/0"},{"type":"type","title":"wx.wx_datetime/0","doc":"","ref":"wx.html#t:wx_datetime/0"},{"type":"type","title":"wx.wx_enum/0","doc":"","ref":"wx.html#t:wx_enum/0"},{"type":"type","title":"wx.wx_env/0","doc":"","ref":"wx.html#t:wx_env/0"},{"type":"type","title":"wx.wx_memory/0","doc":"","ref":"wx.html#t:wx_memory/0"},{"type":"type","title":"wx.wx_object/0","doc":"","ref":"wx.html#t:wx_object/0"},{"type":"type","title":"wx.wx_wxHtmlLinkInfo/0","doc":"","ref":"wx.html#t:wx_wxHtmlLinkInfo/0"},{"type":"type","title":"wx.wx_wxMouseState/0","doc":"","ref":"wx.html#t:wx_wxMouseState/0"},{"type":"module","title":"wxAcceleratorEntry","doc":"Functions for wxAcceleratorEntry class\n\nAn object used by an application wishing to create an accelerator table (see\n`m:wxAcceleratorTable`).\n\nSee: `m:wxAcceleratorTable`, `wxWindow:setAcceleratorTable/2`\n\nwxWidgets docs:\n[wxAcceleratorEntry](https://docs.wxwidgets.org/3.1/classwx_accelerator_entry.html)","ref":"wxAcceleratorEntry.html"},{"type":"function","title":"wxAcceleratorEntry.destroy/1","doc":"Destroys the object.","ref":"wxAcceleratorEntry.html#destroy/1"},{"type":"function","title":"wxAcceleratorEntry.getCommand/1","doc":"Returns the command identifier for the accelerator table entry.","ref":"wxAcceleratorEntry.html#getCommand/1"},{"type":"function","title":"wxAcceleratorEntry.getFlags/1","doc":"Returns the flags for the accelerator table entry.","ref":"wxAcceleratorEntry.html#getFlags/1"},{"type":"function","title":"wxAcceleratorEntry.getKeyCode/1","doc":"Returns the keycode for the accelerator table entry.","ref":"wxAcceleratorEntry.html#getKeyCode/1"},{"type":"function","title":"wxAcceleratorEntry.new/0","doc":"","ref":"wxAcceleratorEntry.html#new/0"},{"type":"function","title":"wxAcceleratorEntry.new/1","doc":"Copy ctor.","ref":"wxAcceleratorEntry.html#new/1"},{"type":"function","title":"wxAcceleratorEntry.set/4","doc":"","ref":"wxAcceleratorEntry.html#set/4"},{"type":"function","title":"wxAcceleratorEntry.set/5","doc":"Sets the accelerator entry parameters.","ref":"wxAcceleratorEntry.html#set/5"},{"type":"type","title":"wxAcceleratorEntry.wxAcceleratorEntry/0","doc":"","ref":"wxAcceleratorEntry.html#t:wxAcceleratorEntry/0"},{"type":"module","title":"wxAcceleratorTable","doc":"Functions for wxAcceleratorTable class\n\nAn accelerator table allows the application to specify a table of keyboard\nshortcuts for menu or button commands.\n\nThe object ?wxNullAcceleratorTable is defined to be a table with no data, and is\nthe initial accelerator table for a window.\n\nExample:\n\nRemark: An accelerator takes precedence over normal processing and can be a\nconvenient way to program some event handling. For example, you can use an\naccelerator table to enable a dialog with a multi-line text control to accept\nCTRL-Enter as meaning 'OK'.\n\nPredefined objects (include wx.hrl): ?wxNullAcceleratorTable\n\nSee: `m:wxAcceleratorEntry`, `wxWindow:setAcceleratorTable/2`\n\nwxWidgets docs:\n[wxAcceleratorTable](https://docs.wxwidgets.org/3.1/classwx_accelerator_table.html)","ref":"wxAcceleratorTable.html"},{"type":"function","title":"wxAcceleratorTable.destroy/1","doc":"Destroys the `m:wxAcceleratorTable` object.\n\nSee overview_refcount_destruct for more info.","ref":"wxAcceleratorTable.html#destroy/1"},{"type":"function","title":"wxAcceleratorTable.isOk/1","doc":"Returns true if the accelerator table is valid.","ref":"wxAcceleratorTable.html#isOk/1"},{"type":"function","title":"wxAcceleratorTable.new/0","doc":"Default ctor.","ref":"wxAcceleratorTable.html#new/0"},{"type":"function","title":"wxAcceleratorTable.new/2","doc":"Initializes the accelerator table from an array of `m:wxAcceleratorEntry`.","ref":"wxAcceleratorTable.html#new/2"},{"type":"function","title":"wxAcceleratorTable.ok/1","doc":"See: `isOk/1`.","ref":"wxAcceleratorTable.html#ok/1"},{"type":"type","title":"wxAcceleratorTable.wxAcceleratorTable/0","doc":"","ref":"wxAcceleratorTable.html#t:wxAcceleratorTable/0"},{"type":"module","title":"wxActivateEvent","doc":"Functions for wxActivateEvent class\n\nAn activate event is sent when a window or application is being activated or\ndeactivated.\n\nNote: Until wxWidgets 3.1.0 activation events could be sent by wxMSW when the\nwindow was minimized. This reflected the native MSW behaviour but was often\nsurprising and unexpected, so starting from 3.1.0 such events are not sent any\nmore when the window is in the minimized state.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxApp::IsActive` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxActivateEvent](https://docs.wxwidgets.org/3.1/classwx_activate_event.html)","ref":"wxActivateEvent.html"},{"type":"module","title":"Events - wxActivateEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxActivateEventType`](`t:wxActivateEventType/0`) to subscribe to events of\nthis type.","ref":"wxActivateEvent.html#module-events"},{"type":"function","title":"wxActivateEvent.getActive/1","doc":"Returns true if the application or window is being activated, false otherwise.","ref":"wxActivateEvent.html#getActive/1"},{"type":"type","title":"wxActivateEvent.wxActivate/0","doc":"","ref":"wxActivateEvent.html#t:wxActivate/0"},{"type":"type","title":"wxActivateEvent.wxActivateEvent/0","doc":"","ref":"wxActivateEvent.html#t:wxActivateEvent/0"},{"type":"type","title":"wxActivateEvent.wxActivateEventType/0","doc":"","ref":"wxActivateEvent.html#t:wxActivateEventType/0"},{"type":"module","title":"wxArtProvider","doc":"Functions for wxArtProvider class\n\n`m:wxArtProvider` class is used to customize the look of wxWidgets application.\n\nWhen wxWidgets needs to display an icon or a bitmap (e.g. in the standard file\ndialog), it does not use a hard-coded resource but asks `m:wxArtProvider` for it\ninstead. This way users can plug in their own `m:wxArtProvider` class and easily\nreplace standard art with their own version.\n\nAll that is needed is to derive a class from `m:wxArtProvider`, override either\nits `wxArtProvider::CreateBitmap()` (not implemented in wx) and/or its\n`wxArtProvider::CreateIconBundle()` (not implemented in wx) methods and register\nthe provider with `wxArtProvider::Push()` (not implemented in wx):\n\nIf you need bitmap images (of the same artwork) that should be displayed at\ndifferent sizes you should probably consider overriding\n`wxArtProvider::CreateIconBundle` (not implemented in wx) and supplying icon\nbundles that contain different bitmap sizes.\n\nThere's another way of taking advantage of this class: you can use it in your\ncode and use platform native icons as provided by `getBitmap/2` or `getIcon/2`.\n\nIdentifying art resources\n\nEvery bitmap and icon bundle are known to `m:wxArtProvider` under an unique ID\nthat is used when requesting a resource from it. The ID is represented by the\n?wxArtID type and can have one of these predefined values (you can see bitmaps\nrepresented by these constants in the page_samples_artprov):\n\nAdditionally, any string recognized by custom art providers registered using\n`wxArtProvider::Push` (not implemented in wx) may be used.\n\nNote: When running under GTK+ 2, GTK+ stock item IDs (e.g. `\"gtk-cdrom\"`) may be\nused as well: For a list of the GTK+ stock items please refer to the\n[GTK+ documentation page](http://library.gnome.org/devel/gtk/stable/gtk-Stock-Items.html).\nIt is also possible to load icons from the current icon theme by specifying\ntheir name (without extension and directory components). Icon themes recognized\nby GTK+ follow the freedesktop.org\n[Icon Themes specification](http://freedesktop.org/Standards/icon-theme-spec).\nNote that themes are not guaranteed to contain all icons, so `m:wxArtProvider`\nmay return ?wxNullBitmap or ?wxNullIcon. The default theme is typically\ninstalled in `/usr/share/icons/hicolor`.\n\nClients\n\nThe `client` is the entity that calls `m:wxArtProvider`'s `getBitmap/2` or\n`getIcon/2` function. It is represented by wxClientID type and can have one of\nthese values:\n\nClient ID serve as a hint to `m:wxArtProvider` that is supposed to help it to\nchoose the best looking bitmap. For example it is often desirable to use\nslightly different icons in menus and toolbars even though they represent the\nsame action (e.g. wxART_FILE_OPEN). Remember that this is really only a hint for\n`m:wxArtProvider` \\- it is common that `getBitmap/2` returns identical bitmap\nfor different client values\\!\n\nSee:\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_artprov\nfor an example of), `m:wxArtProvider`, usage; stock ID list\n\nwxWidgets docs:\n[wxArtProvider](https://docs.wxwidgets.org/3.1/classwx_art_provider.html)","ref":"wxArtProvider.html"},{"type":"function","title":"wxArtProvider.getBitmap/1","doc":"","ref":"wxArtProvider.html#getBitmap/1"},{"type":"function","title":"wxArtProvider.getBitmap/2","doc":"Query registered providers for bitmap with given ID.\n\nReturn: The bitmap if one of registered providers recognizes the ID or\nwxNullBitmap otherwise.","ref":"wxArtProvider.html#getBitmap/2"},{"type":"function","title":"wxArtProvider.getIcon/1","doc":"","ref":"wxArtProvider.html#getIcon/1"},{"type":"function","title":"wxArtProvider.getIcon/2","doc":"Same as `getBitmap/2`, but return a `m:wxIcon` object (or ?wxNullIcon on\nfailure).","ref":"wxArtProvider.html#getIcon/2"},{"type":"type","title":"wxArtProvider.wxArtProvider/0","doc":"","ref":"wxArtProvider.html#t:wxArtProvider/0"},{"type":"module","title":"wxAuiDockArt","doc":"Functions for wxAuiDockArt class\n\n`m:wxAuiDockArt` is part of the wxAUI class framework. See also overview_aui.\n\n`m:wxAuiDockArt` is the art provider: provides all drawing functionality to the\nwxAui dock manager. This allows the dock manager to have a pluggable\nlook-and-feel.\n\nBy default, a `m:wxAuiManager` uses an instance of this class called\n`wxAuiDefaultDockArt` (not implemented in wx) which provides bitmap art and a\ncolour scheme that is adapted to the major platforms' look. You can either\nderive from that class to alter its behaviour or write a completely new dock art\nclass. Call `wxAuiManager:setArtProvider/2` to force wxAUI to use your new dock\nart provider.\n\nSee: `m:wxAuiManager`, `m:wxAuiPaneInfo`\n\nwxWidgets docs:\n[wxAuiDockArt](https://docs.wxwidgets.org/3.1/classwx_aui_dock_art.html)","ref":"wxAuiDockArt.html"},{"type":"function","title":"wxAuiDockArt.getColour/2","doc":"Get the colour of a certain setting.\n\n`id` can be one of the colour values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#getColour/2"},{"type":"function","title":"wxAuiDockArt.getFont/2","doc":"Get a font setting.","ref":"wxAuiDockArt.html#getFont/2"},{"type":"function","title":"wxAuiDockArt.getMetric/2","doc":"Get the value of a certain setting.\n\n`id` can be one of the size values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#getMetric/2"},{"type":"function","title":"wxAuiDockArt.setColour/3","doc":"Set a certain setting with the value `colour`.\n\n`id` can be one of the colour values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#setColour/3"},{"type":"function","title":"wxAuiDockArt.setFont/3","doc":"Set a font setting.","ref":"wxAuiDockArt.html#setFont/3"},{"type":"function","title":"wxAuiDockArt.setMetric/3","doc":"Set a certain setting with the value `new_val`.\n\n`id` can be one of the size values of `wxAuiPaneDockArtSetting`.","ref":"wxAuiDockArt.html#setMetric/3"},{"type":"type","title":"wxAuiDockArt.wxAuiDockArt/0","doc":"","ref":"wxAuiDockArt.html#t:wxAuiDockArt/0"},{"type":"module","title":"wxAuiManager","doc":"Functions for wxAuiManager class\n\n`m:wxAuiManager` is the central class of the wxAUI class framework.\n\n`m:wxAuiManager` manages the panes associated with it for a particular\n`m:wxFrame`, using a pane's `m:wxAuiPaneInfo` information to determine each\npane's docking and floating behaviour.\n\n`m:wxAuiManager` uses wxWidgets' sizer mechanism to plan the layout of each\nframe. It uses a replaceable dock art class to do all drawing, so all drawing is\nlocalized in one area, and may be customized depending on an application's\nspecific needs.\n\n`m:wxAuiManager` works as follows: the programmer adds panes to the class, or\nmakes changes to existing pane properties (dock position, floating state, show\nstate, etc.). To apply these changes, `m:wxAuiManager`'s `update/1` function is\ncalled. This batch processing can be used to avoid flicker, by modifying more\nthan one pane at a time, and then \"committing\" all of the changes at once by\ncalling `update/1`.\n\nPanes can be added quite easily:\n\nLater on, the positions can be modified easily. The following will float an\nexisting pane in a tool window:\n\nLayers, Rows and Directions, Positions\n\nInside wxAUI, the docking layout is figured out by checking several pane\nparameters. Four of these are important for determining where a pane will end\nup:\n\nStyles\n\nThis class supports the following styles:\n\nSee:\n[Overview aui](https://docs.wxwidgets.org/3.1/overview_aui.html#overview_aui),\n`m:wxAuiNotebook`, `m:wxAuiDockArt`, `m:wxAuiPaneInfo`\n\nThis class is derived (and can use functions) from: `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxAuiManager](https://docs.wxwidgets.org/3.1/classwx_aui_manager.html)","ref":"wxAuiManager.html"},{"type":"module","title":"Events - wxAuiManager","doc":"Event types emitted from this class: [`aui_pane_button`](`m:wxAuiManagerEvent`),\n[`aui_pane_close`](`m:wxAuiManagerEvent`),\n[`aui_pane_maximize`](`m:wxAuiManagerEvent`),\n[`aui_pane_restore`](`m:wxAuiManagerEvent`),\n[`aui_pane_activated`](`m:wxAuiManagerEvent`),\n[`aui_render`](`m:wxAuiManagerEvent`)","ref":"wxAuiManager.html#module-events"},{"type":"function","title":"wxAuiManager.addPane/2","doc":"","ref":"wxAuiManager.html#addPane/2"},{"type":"function","title":"wxAuiManager.addPane/3","doc":"`addPane/4` tells the frame manager to start managing a child window.\n\nThere are several versions of this function. The first version allows the full\nspectrum of pane parameter possibilities. The second version is used for simpler\nuser interfaces which do not require as much configuration. The last version\nallows a drop position to be specified, which will determine where the pane will\nbe added.","ref":"wxAuiManager.html#addPane/3"},{"type":"function","title":"wxAuiManager.addPane/4","doc":"","ref":"wxAuiManager.html#addPane/4"},{"type":"function","title":"wxAuiManager.destroy/1","doc":"Dtor.","ref":"wxAuiManager.html#destroy/1"},{"type":"function","title":"wxAuiManager.detachPane/2","doc":"Tells the `m:wxAuiManager` to stop managing the pane specified by window.\n\nThe window, if in a floated frame, is reparented to the frame managed by\n`m:wxAuiManager`.","ref":"wxAuiManager.html#detachPane/2"},{"type":"function","title":"wxAuiManager.getAllPanes/1","doc":"Returns an array of all panes managed by the frame manager.","ref":"wxAuiManager.html#getAllPanes/1"},{"type":"function","title":"wxAuiManager.getArtProvider/1","doc":"Returns the current art provider being used.\n\nSee: `m:wxAuiDockArt`","ref":"wxAuiManager.html#getArtProvider/1"},{"type":"function","title":"wxAuiManager.getDockSizeConstraint/1","doc":"Returns the current dock constraint values.\n\nSee `setDockSizeConstraint/3` for more information.","ref":"wxAuiManager.html#getDockSizeConstraint/1"},{"type":"function","title":"wxAuiManager.getFlags/1","doc":"Returns the current ?wxAuiManagerOption's flags.","ref":"wxAuiManager.html#getFlags/1"},{"type":"function","title":"wxAuiManager.getManagedWindow/1","doc":"Returns the frame currently being managed by `m:wxAuiManager`.","ref":"wxAuiManager.html#getManagedWindow/1"},{"type":"function","title":"wxAuiManager.getManager/1","doc":"Calling this method will return the `m:wxAuiManager` for a given window.\n\nThe `window` parameter should specify any child window or sub-child window of\nthe frame or window managed by `m:wxAuiManager`.\n\nThe `window` parameter need not be managed by the manager itself, nor does it\neven need to be a child or sub-child of a managed window. It must however be\ninside the window hierarchy underneath the managed window.","ref":"wxAuiManager.html#getManager/1"},{"type":"function","title":"wxAuiManager.getPane/2","doc":"`getPane/2` is used to lookup a `m:wxAuiPaneInfo` object either by window\npointer or by pane name, which acts as a unique id for a window pane.\n\nThe returned `m:wxAuiPaneInfo` object may then be modified to change a pane's\nlook, state or position. After one or more modifications to `m:wxAuiPaneInfo`,\n`update/1` should be called to commit the changes to the user interface. If the\nlookup failed (meaning the pane could not be found in the manager), a call to\nthe returned `m:wxAuiPaneInfo`'s IsOk() method will return false.","ref":"wxAuiManager.html#getPane/2"},{"type":"function","title":"wxAuiManager.hideHint/1","doc":"`hideHint/1` hides any docking hint that may be visible.","ref":"wxAuiManager.html#hideHint/1"},{"type":"function","title":"wxAuiManager.insertPane/3","doc":"","ref":"wxAuiManager.html#insertPane/3"},{"type":"function","title":"wxAuiManager.insertPane/4","doc":"This method is used to insert either a previously unmanaged pane window into the\nframe manager, or to insert a currently managed pane somewhere else.\n\n`insertPane/4` will push all panes, rows, or docks aside and insert the window\ninto the position specified by `insert_location`.\n\nBecause `insert_location` can specify either a pane, dock row, or dock layer,\nthe `insert_level` parameter is used to disambiguate this. The parameter\n`insert_level` can take a value of wxAUI_INSERT_PANE, wxAUI_INSERT_ROW or\nwxAUI_INSERT_DOCK.","ref":"wxAuiManager.html#insertPane/4"},{"type":"function","title":"wxAuiManager.loadPaneInfo/3","doc":"`loadPaneInfo/3` is similar to LoadPerspective, with the exception that it only\nloads information about a single pane.\n\nThis method writes the serialized data into the passed pane. Pointers to UI\nelements are not modified.\n\nNote: This operation also changes the name in the pane information\\!\n\nSee: `loadPerspective/3`\n\nSee: `savePaneInfo/2`\n\nSee: `savePerspective/1`","ref":"wxAuiManager.html#loadPaneInfo/3"},{"type":"function","title":"wxAuiManager.loadPerspective/2","doc":"","ref":"wxAuiManager.html#loadPerspective/2"},{"type":"function","title":"wxAuiManager.loadPerspective/3","doc":"Loads a saved perspective.\n\nA perspective is the layout state of an AUI managed window.\n\nAll currently existing panes that have an object in \"perspective\" with the same\nname (\"equivalent\") will receive the layout parameters of the object in\n\"perspective\". Existing panes that do not have an equivalent in \"perspective\"\nremain unchanged, objects in \"perspective\" having no equivalent in the manager\nare ignored.\n\nSee: `loadPaneInfo/3`\n\nSee: `loadPerspective/3`\n\nSee: `savePerspective/1`","ref":"wxAuiManager.html#loadPerspective/3"},{"type":"function","title":"wxAuiManager.new/0","doc":"","ref":"wxAuiManager.html#new/0"},{"type":"function","title":"wxAuiManager.new/1","doc":"Constructor.","ref":"wxAuiManager.html#new/1"},{"type":"function","title":"wxAuiManager.savePaneInfo/2","doc":"`savePaneInfo/2` is similar to SavePerspective, with the exception that it only\nsaves information about a single pane.\n\nReturn: The serialized layout parameters of the pane are returned within the\nstring. Information about the pointers to UI elements stored in the pane are not\nserialized.\n\nSee: `loadPaneInfo/3`\n\nSee: `loadPerspective/3`\n\nSee: `savePerspective/1`","ref":"wxAuiManager.html#savePaneInfo/2"},{"type":"function","title":"wxAuiManager.savePerspective/1","doc":"Saves the entire user interface layout into an encoded `wxString` (not\nimplemented in wx), which can then be stored by the application (probably using\nwxConfig).\n\nSee: `loadPerspective/3`\n\nSee: `loadPaneInfo/3`\n\nSee: `savePaneInfo/2`","ref":"wxAuiManager.html#savePerspective/1"},{"type":"function","title":"wxAuiManager.setArtProvider/2","doc":"Instructs `m:wxAuiManager` to use art provider specified by parameter\n`art_provider` for all drawing calls.\n\nThis allows pluggable look-and-feel features. The previous art provider object,\nif any, will be deleted by `m:wxAuiManager`.\n\nSee: `m:wxAuiDockArt`","ref":"wxAuiManager.html#setArtProvider/2"},{"type":"function","title":"wxAuiManager.setDockSizeConstraint/3","doc":"When a user creates a new dock by dragging a window into a docked position,\noften times the large size of the window will create a dock that is unwieldy\nlarge.\n\n`m:wxAuiManager` by default limits the size of any new dock to 1/3 of the window\nsize. For horizontal docks, this would be 1/3 of the window height. For vertical\ndocks, 1/3 of the width.\n\nCalling this function will adjust this constraint value. The numbers must be\nbetween 0.0 and 1.0. For instance, calling SetDockSizeContraint with 0.5, 0.5\nwill cause new docks to be limited to half of the size of the entire managed\nwindow.","ref":"wxAuiManager.html#setDockSizeConstraint/3"},{"type":"function","title":"wxAuiManager.setFlags/2","doc":"This method is used to specify ?wxAuiManagerOption's flags.\n\n`flags` specifies options which allow the frame management behaviour to be\nmodified.","ref":"wxAuiManager.html#setFlags/2"},{"type":"function","title":"wxAuiManager.setManagedWindow/2","doc":"Called to specify the frame or window which is to be managed by\n`m:wxAuiManager`.\n\nFrame management is not restricted to just frames. Child windows or custom\ncontrols are also allowed.","ref":"wxAuiManager.html#setManagedWindow/2"},{"type":"function","title":"wxAuiManager.showHint/2","doc":"This function is used by controls to explicitly show a hint window at the\nspecified rectangle.\n\nIt is rarely called, and is mostly used by controls implementing custom pane\ndrag/drop behaviour. The specified rectangle should be in screen coordinates.","ref":"wxAuiManager.html#showHint/2"},{"type":"function","title":"wxAuiManager.unInit/1","doc":"Dissociate the managed window from the manager.\n\nThis function may be called before the managed frame or window is destroyed,\nbut, since wxWidgets 3.1.4, it's unnecessary to call it explicitly, as it will\nbe called automatically when this window is destroyed, as well as when the\nmanager itself is.","ref":"wxAuiManager.html#unInit/1"},{"type":"function","title":"wxAuiManager.update/1","doc":"This method is called after any number of changes are made to any of the managed\npanes.\n\n`update/1` must be invoked after `addPane/4` or `insertPane/4` are called in\norder to \"realize\" or \"commit\" the changes. In addition, any number of changes\nmay be made to `m:wxAuiPaneInfo` structures (retrieved with `getPane/2`), but to\nrealize the changes, `update/1` must be called. This construction allows pane\nflicker to be avoided by updating the whole layout at one time.","ref":"wxAuiManager.html#update/1"},{"type":"type","title":"wxAuiManager.wxAuiManager/0","doc":"","ref":"wxAuiManager.html#t:wxAuiManager/0"},{"type":"module","title":"wxAuiManagerEvent","doc":"Functions for wxAuiManagerEvent class\n\nEvent used to indicate various actions taken with `m:wxAuiManager`.\n\nSee `m:wxAuiManager` for available event types.\n\nSee: `m:wxAuiManager`, `m:wxAuiPaneInfo`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxAuiManagerEvent](https://docs.wxwidgets.org/3.1/classwx_aui_manager_event.html)","ref":"wxAuiManagerEvent.html"},{"type":"module","title":"Events - wxAuiManagerEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxAuiManagerEventType`](`t:wxAuiManagerEventType/0`) to subscribe to events of\nthis type.","ref":"wxAuiManagerEvent.html#module-events"},{"type":"function","title":"wxAuiManagerEvent.canVeto/1","doc":"Return: true if this event can be vetoed.\n\nSee: `veto/2`","ref":"wxAuiManagerEvent.html#canVeto/1"},{"type":"function","title":"wxAuiManagerEvent.getButton/1","doc":"Return: The ID of the button that was clicked.","ref":"wxAuiManagerEvent.html#getButton/1"},{"type":"function","title":"wxAuiManagerEvent.getDC/1","doc":"","ref":"wxAuiManagerEvent.html#getDC/1"},{"type":"function","title":"wxAuiManagerEvent.getManager/1","doc":"Return: The `m:wxAuiManager` this event is associated with.","ref":"wxAuiManagerEvent.html#getManager/1"},{"type":"function","title":"wxAuiManagerEvent.getPane/1","doc":"Return: The pane this event is associated with.","ref":"wxAuiManagerEvent.html#getPane/1"},{"type":"function","title":"wxAuiManagerEvent.getVeto/1","doc":"Return: true if this event was vetoed.\n\nSee: `veto/2`","ref":"wxAuiManagerEvent.html#getVeto/1"},{"type":"function","title":"wxAuiManagerEvent.setButton/2","doc":"Sets the ID of the button clicked that triggered this event.","ref":"wxAuiManagerEvent.html#setButton/2"},{"type":"function","title":"wxAuiManagerEvent.setCanVeto/2","doc":"Sets whether or not this event can be vetoed.","ref":"wxAuiManagerEvent.html#setCanVeto/2"},{"type":"function","title":"wxAuiManagerEvent.setDC/2","doc":"","ref":"wxAuiManagerEvent.html#setDC/2"},{"type":"function","title":"wxAuiManagerEvent.setManager/2","doc":"Sets the `m:wxAuiManager` this event is associated with.","ref":"wxAuiManagerEvent.html#setManager/2"},{"type":"function","title":"wxAuiManagerEvent.setPane/2","doc":"Sets the pane this event is associated with.","ref":"wxAuiManagerEvent.html#setPane/2"},{"type":"function","title":"wxAuiManagerEvent.veto/1","doc":"","ref":"wxAuiManagerEvent.html#veto/1"},{"type":"function","title":"wxAuiManagerEvent.veto/2","doc":"Cancels the action indicated by this event if `canVeto/1` is true.","ref":"wxAuiManagerEvent.html#veto/2"},{"type":"type","title":"wxAuiManagerEvent.wxAuiManager/0","doc":"","ref":"wxAuiManagerEvent.html#t:wxAuiManager/0"},{"type":"type","title":"wxAuiManagerEvent.wxAuiManagerEvent/0","doc":"","ref":"wxAuiManagerEvent.html#t:wxAuiManagerEvent/0"},{"type":"type","title":"wxAuiManagerEvent.wxAuiManagerEventType/0","doc":"","ref":"wxAuiManagerEvent.html#t:wxAuiManagerEventType/0"},{"type":"module","title":"wxAuiNotebook","doc":"Functions for wxAuiNotebook class\n\n`m:wxAuiNotebook` is part of the wxAUI class framework, which represents a\nnotebook control, managing multiple windows with associated tabs.\n\nSee also overview_aui.\n\n`m:wxAuiNotebook` is a notebook control which implements many features common in\napplications with dockable panes. Specifically, `m:wxAuiNotebook` implements\nfunctionality which allows the user to rearrange tab order via drag-and-drop,\nsplit the tab window into many different splitter configurations, and toggle\nthrough different themes to customize the control's look and feel.\n\nThe default theme that is used is `wxAuiDefaultTabArt` (not implemented in wx),\nwhich provides a modern, glossy look and feel. The theme can be changed by\ncalling `setArtProvider/2`.\n\nStyles\n\nThis class supports the following styles:\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxAuiNotebook](https://docs.wxwidgets.org/3.1/classwx_aui_notebook.html)","ref":"wxAuiNotebook.html"},{"type":"module","title":"Events - wxAuiNotebook","doc":"Event types emitted from this class:\n[`command_auinotebook_page_close`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_page_closed`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_page_changed`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_page_changing`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_button`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_begin_drag`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_end_drag`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_drag_motion`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_allow_dnd`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_drag_done`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_tab_middle_down`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_tab_middle_up`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_tab_right_down`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_tab_right_up`](`m:wxAuiNotebookEvent`),\n[`command_auinotebook_bg_dclick`](`m:wxAuiNotebookEvent`)","ref":"wxAuiNotebook.html#module-events"},{"type":"function","title":"wxAuiNotebook.addPage/3","doc":"","ref":"wxAuiNotebook.html#addPage/3"},{"type":"function","title":"wxAuiNotebook.addPage/4","doc":"Adds a page.\n\nIf the `select` parameter is true, calling this will generate a page change\nevent.","ref":"wxAuiNotebook.html#addPage/4"},{"type":"function","title":"wxAuiNotebook.addPage/5","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been\nadded to this control previously.\n\nThe call to this function may generate the page changing events.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/6`\n\nSince: 2.9.3","ref":"wxAuiNotebook.html#addPage/5"},{"type":"function","title":"wxAuiNotebook.create/2","doc":"","ref":"wxAuiNotebook.html#create/2"},{"type":"function","title":"wxAuiNotebook.create/3","doc":"Creates the notebook window.","ref":"wxAuiNotebook.html#create/3"},{"type":"function","title":"wxAuiNotebook.create/4","doc":"Constructs the book control with the given parameters.","ref":"wxAuiNotebook.html#create/4"},{"type":"function","title":"wxAuiNotebook.deletePage/2","doc":"Deletes a page at the given index.\n\nCalling this method will generate a page change event.","ref":"wxAuiNotebook.html#deletePage/2"},{"type":"function","title":"wxAuiNotebook.destroy/1","doc":"Destroys the object.","ref":"wxAuiNotebook.html#destroy/1"},{"type":"function","title":"wxAuiNotebook.getArtProvider/1","doc":"Returns the associated art provider.","ref":"wxAuiNotebook.html#getArtProvider/1"},{"type":"function","title":"wxAuiNotebook.getPage/2","doc":"Returns the page specified by the given index.","ref":"wxAuiNotebook.html#getPage/2"},{"type":"function","title":"wxAuiNotebook.getPageBitmap/2","doc":"Returns the tab bitmap for the page.","ref":"wxAuiNotebook.html#getPageBitmap/2"},{"type":"function","title":"wxAuiNotebook.getPageCount/1","doc":"Returns the number of pages in the notebook.","ref":"wxAuiNotebook.html#getPageCount/1"},{"type":"function","title":"wxAuiNotebook.getPageIndex/2","doc":"Returns the page index for the specified window.\n\nIf the window is not found in the notebook, wxNOT_FOUND is returned.","ref":"wxAuiNotebook.html#getPageIndex/2"},{"type":"function","title":"wxAuiNotebook.getPageText/2","doc":"Returns the tab label for the page.","ref":"wxAuiNotebook.html#getPageText/2"},{"type":"function","title":"wxAuiNotebook.getSelection/1","doc":"Returns the currently selected page.","ref":"wxAuiNotebook.html#getSelection/1"},{"type":"function","title":"wxAuiNotebook.insertPage/4","doc":"","ref":"wxAuiNotebook.html#insertPage/4"},{"type":"function","title":"wxAuiNotebook.insertPage/5","doc":"`insertPage/6` is similar to AddPage, but allows the ability to specify the\ninsert location.\n\nIf the `select` parameter is true, calling this will generate a page change\nevent.","ref":"wxAuiNotebook.html#insertPage/5"},{"type":"function","title":"wxAuiNotebook.insertPage/6","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/5`\n\nSince: 2.9.3","ref":"wxAuiNotebook.html#insertPage/6"},{"type":"function","title":"wxAuiNotebook.new/0","doc":"Default ctor.","ref":"wxAuiNotebook.html#new/0"},{"type":"function","title":"wxAuiNotebook.new/1","doc":"","ref":"wxAuiNotebook.html#new/1"},{"type":"function","title":"wxAuiNotebook.new/2","doc":"Constructor.\n\nCreates a wxAuiNotebok control.","ref":"wxAuiNotebook.html#new/2"},{"type":"function","title":"wxAuiNotebook.removePage/2","doc":"Removes a page, without deleting the window pointer.","ref":"wxAuiNotebook.html#removePage/2"},{"type":"function","title":"wxAuiNotebook.setArtProvider/2","doc":"Sets the art provider to be used by the notebook.","ref":"wxAuiNotebook.html#setArtProvider/2"},{"type":"function","title":"wxAuiNotebook.setFont/2","doc":"Sets the font for drawing the tab labels, using a bold version of the font for\nselected tab labels.","ref":"wxAuiNotebook.html#setFont/2"},{"type":"function","title":"wxAuiNotebook.setPageBitmap/3","doc":"Sets the bitmap for the page.\n\nTo remove a bitmap from the tab caption, pass wxNullBitmap.","ref":"wxAuiNotebook.html#setPageBitmap/3"},{"type":"function","title":"wxAuiNotebook.setPageText/3","doc":"Sets the tab label for the page.","ref":"wxAuiNotebook.html#setPageText/3"},{"type":"function","title":"wxAuiNotebook.setSelection/2","doc":"Sets the page selection.\n\nCalling this method will generate a page change event.","ref":"wxAuiNotebook.html#setSelection/2"},{"type":"function","title":"wxAuiNotebook.setTabCtrlHeight/2","doc":"Sets the tab height.\n\nBy default, the tab control height is calculated by measuring the text height\nand bitmap sizes on the tab captions. Calling this method will override that\ncalculation and set the tab control to the specified height parameter. A call to\nthis method will override any call to `setUniformBitmapSize/2`.\n\nSpecifying -1 as the height will return the control to its default auto-sizing\nbehaviour.","ref":"wxAuiNotebook.html#setTabCtrlHeight/2"},{"type":"function","title":"wxAuiNotebook.setUniformBitmapSize/2","doc":"Ensure that all tabs have the same height, even if some of them don't have\nbitmaps.\n\nPassing ?wxDefaultSize as `size` undoes the effect of a previous call to this\nfunction and instructs the control to use dynamic tab height.","ref":"wxAuiNotebook.html#setUniformBitmapSize/2"},{"type":"type","title":"wxAuiNotebook.wxAuiNotebook/0","doc":"","ref":"wxAuiNotebook.html#t:wxAuiNotebook/0"},{"type":"module","title":"wxAuiNotebookEvent","doc":"Functions for wxAuiNotebookEvent class\n\nThis class is used by the events generated by `m:wxAuiNotebook`.\n\nSee: `m:wxAuiNotebook`, `m:wxBookCtrlEvent`\n\nThis class is derived (and can use functions) from: `m:wxBookCtrlEvent`\n`m:wxNotifyEvent` `m:wxCommandEvent` `m:wxEvent`\n\nwxWidgets docs:\n[wxAuiNotebookEvent](https://docs.wxwidgets.org/3.1/classwx_aui_notebook_event.html)","ref":"wxAuiNotebookEvent.html"},{"type":"module","title":"Events - wxAuiNotebookEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxAuiNotebookEventType`](`t:wxAuiNotebookEventType/0`) to subscribe to events\nof this type.","ref":"wxAuiNotebookEvent.html#module-events"},{"type":"function","title":"wxAuiNotebookEvent.getDragSource/1","doc":"","ref":"wxAuiNotebookEvent.html#getDragSource/1"},{"type":"function","title":"wxAuiNotebookEvent.getOldSelection/1","doc":"Returns the page that was selected before the change, `wxNOT_FOUND` if none was\nselected.","ref":"wxAuiNotebookEvent.html#getOldSelection/1"},{"type":"function","title":"wxAuiNotebookEvent.getSelection/1","doc":"Returns the currently selected page, or `wxNOT_FOUND` if none was selected.\n\nNote: under Windows, `getSelection/1` will return the same value as\n`getOldSelection/1` when called from the `EVT_BOOKCTRL_PAGE_CHANGING` handler\nand not the page which is going to be selected.","ref":"wxAuiNotebookEvent.html#getSelection/1"},{"type":"function","title":"wxAuiNotebookEvent.setDragSource/2","doc":"","ref":"wxAuiNotebookEvent.html#setDragSource/2"},{"type":"function","title":"wxAuiNotebookEvent.setOldSelection/2","doc":"Sets the id of the page selected before the change.","ref":"wxAuiNotebookEvent.html#setOldSelection/2"},{"type":"function","title":"wxAuiNotebookEvent.setSelection/2","doc":"Sets the selection member variable.","ref":"wxAuiNotebookEvent.html#setSelection/2"},{"type":"type","title":"wxAuiNotebookEvent.wxAuiNotebook/0","doc":"","ref":"wxAuiNotebookEvent.html#t:wxAuiNotebook/0"},{"type":"type","title":"wxAuiNotebookEvent.wxAuiNotebookEvent/0","doc":"","ref":"wxAuiNotebookEvent.html#t:wxAuiNotebookEvent/0"},{"type":"type","title":"wxAuiNotebookEvent.wxAuiNotebookEventType/0","doc":"","ref":"wxAuiNotebookEvent.html#t:wxAuiNotebookEventType/0"},{"type":"module","title":"wxAuiPaneInfo","doc":"Functions for wxAuiPaneInfo class\n\n`m:wxAuiPaneInfo` is part of the wxAUI class framework. See also overview_aui.\n\n`m:wxAuiPaneInfo` specifies all the parameters for a pane. These parameters\nspecify where the pane is on the screen, whether it is docked or floating, or\nhidden. In addition, these parameters specify the pane's docked position,\nfloating position, preferred size, minimum size, caption text among many other\nparameters.\n\nSee: `m:wxAuiManager`, `m:wxAuiDockArt`\n\nwxWidgets docs:\n[wxAuiPaneInfo](https://docs.wxwidgets.org/3.1/classwx_aui_pane_info.html)","ref":"wxAuiPaneInfo.html"},{"type":"function","title":"wxAuiPaneInfo.bestSize/2","doc":"`bestSize/3` sets the ideal size for the pane.\n\nThe docking manager will attempt to use this size as much as possible when\ndocking or floating the pane.","ref":"wxAuiPaneInfo.html#bestSize/2"},{"type":"function","title":"wxAuiPaneInfo.bestSize/3","doc":"","ref":"wxAuiPaneInfo.html#bestSize/3"},{"type":"function","title":"wxAuiPaneInfo.bottom/1","doc":"`bottom/1` sets the pane dock position to the bottom side of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_BOTTOM).","ref":"wxAuiPaneInfo.html#bottom/1"},{"type":"function","title":"wxAuiPaneInfo.bottomDockable/1","doc":"","ref":"wxAuiPaneInfo.html#bottomDockable/1"},{"type":"function","title":"wxAuiPaneInfo.bottomDockable/2","doc":"`bottomDockable/2` indicates whether a pane can be docked at the bottom of the\nframe.","ref":"wxAuiPaneInfo.html#bottomDockable/2"},{"type":"function","title":"wxAuiPaneInfo.caption/2","doc":"`caption/2` sets the caption of the pane.","ref":"wxAuiPaneInfo.html#caption/2"},{"type":"function","title":"wxAuiPaneInfo.captionVisible/1","doc":"","ref":"wxAuiPaneInfo.html#captionVisible/1"},{"type":"function","title":"wxAuiPaneInfo.captionVisible/2","doc":"CaptionVisible indicates that a pane caption should be visible.\n\nIf false, no pane caption is drawn.","ref":"wxAuiPaneInfo.html#captionVisible/2"},{"type":"function","title":"wxAuiPaneInfo.centre/1","doc":"`Center()` (not implemented in wx) sets the pane dock position to the left side\nof the frame.\n\nThe centre pane is the space in the middle after all border panes (left, top,\nright, bottom) are subtracted from the layout. This is the same thing as calling\nDirection(wxAUI_DOCK_CENTRE).","ref":"wxAuiPaneInfo.html#centre/1"},{"type":"function","title":"wxAuiPaneInfo.centrePane/1","doc":"`centrePane/1` specifies that the pane should adopt the default center pane\nsettings.\n\nCentre panes usually do not have caption bars. This function provides an easy\nway of preparing a pane to be displayed in the center dock position.","ref":"wxAuiPaneInfo.html#centrePane/1"},{"type":"function","title":"wxAuiPaneInfo.closeButton/1","doc":"","ref":"wxAuiPaneInfo.html#closeButton/1"},{"type":"function","title":"wxAuiPaneInfo.closeButton/2","doc":"`closeButton/2` indicates that a close button should be drawn for the pane.","ref":"wxAuiPaneInfo.html#closeButton/2"},{"type":"function","title":"wxAuiPaneInfo.defaultPane/1","doc":"`defaultPane/1` specifies that the pane should adopt the default pane settings.","ref":"wxAuiPaneInfo.html#defaultPane/1"},{"type":"function","title":"wxAuiPaneInfo.destroy/1","doc":"Destroys the object.","ref":"wxAuiPaneInfo.html#destroy/1"},{"type":"function","title":"wxAuiPaneInfo.destroyOnClose/1","doc":"","ref":"wxAuiPaneInfo.html#destroyOnClose/1"},{"type":"function","title":"wxAuiPaneInfo.destroyOnClose/2","doc":"`destroyOnClose/2` indicates whether a pane should be destroyed when it is\nclosed.\n\nNormally a pane is simply hidden when the close button is clicked. Setting\nDestroyOnClose to true will cause the window to be destroyed when the user\nclicks the pane's close button.","ref":"wxAuiPaneInfo.html#destroyOnClose/2"},{"type":"function","title":"wxAuiPaneInfo.direction/2","doc":"`direction/2` determines the direction of the docked pane.\n\nIt is functionally the same as calling `left/1`, `right/1`, `top/1` or\n`bottom/1`, except that docking direction may be specified programmatically via\nthe parameter.","ref":"wxAuiPaneInfo.html#direction/2"},{"type":"function","title":"wxAuiPaneInfo.dock/1","doc":"`dock/1` indicates that a pane should be docked.\n\nIt is the opposite of `float/1`.","ref":"wxAuiPaneInfo.html#dock/1"},{"type":"function","title":"wxAuiPaneInfo.dockable/1","doc":"","ref":"wxAuiPaneInfo.html#dockable/1"},{"type":"function","title":"wxAuiPaneInfo.dockable/2","doc":"`dockable/2` specifies whether a frame can be docked or not.\n\nIt is the same as specifying\nTopDockable(b).BottomDockable(b).LeftDockable(b).RightDockable(b).","ref":"wxAuiPaneInfo.html#dockable/2"},{"type":"function","title":"wxAuiPaneInfo.fixed/1","doc":"`fixed/1` forces a pane to be fixed size so that it cannot be resized.\n\nAfter calling `fixed/1`, `isFixed/1` will return true.","ref":"wxAuiPaneInfo.html#fixed/1"},{"type":"function","title":"wxAuiPaneInfo.float/1","doc":"`float/1` indicates that a pane should be floated.\n\nIt is the opposite of `dock/1`.","ref":"wxAuiPaneInfo.html#float/1"},{"type":"function","title":"wxAuiPaneInfo.floatable/1","doc":"","ref":"wxAuiPaneInfo.html#floatable/1"},{"type":"function","title":"wxAuiPaneInfo.floatable/2","doc":"`floatable/2` sets whether the user will be able to undock a pane and turn it\ninto a floating window.","ref":"wxAuiPaneInfo.html#floatable/2"},{"type":"function","title":"wxAuiPaneInfo.floatingPosition/2","doc":"`floatingPosition/3` sets the position of the floating pane.","ref":"wxAuiPaneInfo.html#floatingPosition/2"},{"type":"function","title":"wxAuiPaneInfo.floatingPosition/3","doc":"","ref":"wxAuiPaneInfo.html#floatingPosition/3"},{"type":"function","title":"wxAuiPaneInfo.floatingSize/2","doc":"`floatingSize/3` sets the size of the floating pane.","ref":"wxAuiPaneInfo.html#floatingSize/2"},{"type":"function","title":"wxAuiPaneInfo.floatingSize/3","doc":"","ref":"wxAuiPaneInfo.html#floatingSize/3"},{"type":"function","title":"wxAuiPaneInfo.getDirection/1","doc":"","ref":"wxAuiPaneInfo.html#getDirection/1"},{"type":"function","title":"wxAuiPaneInfo.getFloatingPosition/1","doc":"","ref":"wxAuiPaneInfo.html#getFloatingPosition/1"},{"type":"function","title":"wxAuiPaneInfo.getFloatingSize/1","doc":"","ref":"wxAuiPaneInfo.html#getFloatingSize/1"},{"type":"function","title":"wxAuiPaneInfo.getFrame/1","doc":"","ref":"wxAuiPaneInfo.html#getFrame/1"},{"type":"function","title":"wxAuiPaneInfo.getLayer/1","doc":"","ref":"wxAuiPaneInfo.html#getLayer/1"},{"type":"function","title":"wxAuiPaneInfo.getPosition/1","doc":"","ref":"wxAuiPaneInfo.html#getPosition/1"},{"type":"function","title":"wxAuiPaneInfo.getRow/1","doc":"","ref":"wxAuiPaneInfo.html#getRow/1"},{"type":"function","title":"wxAuiPaneInfo.getWindow/1","doc":"","ref":"wxAuiPaneInfo.html#getWindow/1"},{"type":"function","title":"wxAuiPaneInfo.gripper/1","doc":"","ref":"wxAuiPaneInfo.html#gripper/1"},{"type":"function","title":"wxAuiPaneInfo.gripper/2","doc":"`gripper/2` indicates that a gripper should be drawn for the pane.","ref":"wxAuiPaneInfo.html#gripper/2"},{"type":"function","title":"wxAuiPaneInfo.gripperTop/1","doc":"","ref":"wxAuiPaneInfo.html#gripperTop/1"},{"type":"function","title":"wxAuiPaneInfo.gripperTop/2","doc":"`gripperTop/2` indicates that a gripper should be drawn at the top of the pane.","ref":"wxAuiPaneInfo.html#gripperTop/2"},{"type":"function","title":"wxAuiPaneInfo.hasBorder/1","doc":"`hasBorder/1` returns true if the pane displays a border.","ref":"wxAuiPaneInfo.html#hasBorder/1"},{"type":"function","title":"wxAuiPaneInfo.hasCaption/1","doc":"`hasCaption/1` returns true if the pane displays a caption.","ref":"wxAuiPaneInfo.html#hasCaption/1"},{"type":"function","title":"wxAuiPaneInfo.hasCloseButton/1","doc":"`hasCloseButton/1` returns true if the pane displays a button to close the pane.","ref":"wxAuiPaneInfo.html#hasCloseButton/1"},{"type":"function","title":"wxAuiPaneInfo.hasFlag/2","doc":"`hasFlag/2` returns true if the property specified by flag is active for the\npane.","ref":"wxAuiPaneInfo.html#hasFlag/2"},{"type":"function","title":"wxAuiPaneInfo.hasGripper/1","doc":"`hasGripper/1` returns true if the pane displays a gripper.","ref":"wxAuiPaneInfo.html#hasGripper/1"},{"type":"function","title":"wxAuiPaneInfo.hasGripperTop/1","doc":"`hasGripper/1` returns true if the pane displays a gripper at the top.","ref":"wxAuiPaneInfo.html#hasGripperTop/1"},{"type":"function","title":"wxAuiPaneInfo.hasMaximizeButton/1","doc":"`hasMaximizeButton/1` returns true if the pane displays a button to maximize the\npane.","ref":"wxAuiPaneInfo.html#hasMaximizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.hasMinimizeButton/1","doc":"`hasMinimizeButton/1` returns true if the pane displays a button to minimize the\npane.","ref":"wxAuiPaneInfo.html#hasMinimizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.hasPinButton/1","doc":"`hasPinButton/1` returns true if the pane displays a button to float the pane.","ref":"wxAuiPaneInfo.html#hasPinButton/1"},{"type":"function","title":"wxAuiPaneInfo.hide/1","doc":"`hide/1` indicates that a pane should be hidden.","ref":"wxAuiPaneInfo.html#hide/1"},{"type":"function","title":"wxAuiPaneInfo.isBottomDockable/1","doc":"`isBottomDockable/1` returns true if the pane can be docked at the bottom of the\nmanaged frame.\n\nSee: `IsDockable()` (not implemented in wx)","ref":"wxAuiPaneInfo.html#isBottomDockable/1"},{"type":"function","title":"wxAuiPaneInfo.isDocked/1","doc":"`isDocked/1` returns true if the pane is currently docked.","ref":"wxAuiPaneInfo.html#isDocked/1"},{"type":"function","title":"wxAuiPaneInfo.isFixed/1","doc":"`isFixed/1` returns true if the pane cannot be resized.","ref":"wxAuiPaneInfo.html#isFixed/1"},{"type":"function","title":"wxAuiPaneInfo.isFloatable/1","doc":"`isFloatable/1` returns true if the pane can be undocked and displayed as a\nfloating window.","ref":"wxAuiPaneInfo.html#isFloatable/1"},{"type":"function","title":"wxAuiPaneInfo.isFloating/1","doc":"`isFloating/1` returns true if the pane is floating.","ref":"wxAuiPaneInfo.html#isFloating/1"},{"type":"function","title":"wxAuiPaneInfo.isLeftDockable/1","doc":"`isLeftDockable/1` returns true if the pane can be docked on the left of the\nmanaged frame.\n\nSee: `IsDockable()` (not implemented in wx)","ref":"wxAuiPaneInfo.html#isLeftDockable/1"},{"type":"function","title":"wxAuiPaneInfo.isMovable/1","doc":"IsMoveable() returns true if the docked frame can be undocked or moved to\nanother dock position.","ref":"wxAuiPaneInfo.html#isMovable/1"},{"type":"function","title":"wxAuiPaneInfo.isOk/1","doc":"`isOk/1` returns true if the `m:wxAuiPaneInfo` structure is valid.\n\nA pane structure is valid if it has an associated window.","ref":"wxAuiPaneInfo.html#isOk/1"},{"type":"function","title":"wxAuiPaneInfo.isResizable/1","doc":"`isResizable/1` returns true if the pane can be resized.","ref":"wxAuiPaneInfo.html#isResizable/1"},{"type":"function","title":"wxAuiPaneInfo.isRightDockable/1","doc":"`isRightDockable/1` returns true if the pane can be docked on the right of the\nmanaged frame.\n\nSee: `IsDockable()` (not implemented in wx)","ref":"wxAuiPaneInfo.html#isRightDockable/1"},{"type":"function","title":"wxAuiPaneInfo.isShown/1","doc":"`isShown/1` returns true if the pane is currently shown.","ref":"wxAuiPaneInfo.html#isShown/1"},{"type":"function","title":"wxAuiPaneInfo.isToolbar/1","doc":"`isToolbar/1` returns true if the pane contains a toolbar.","ref":"wxAuiPaneInfo.html#isToolbar/1"},{"type":"function","title":"wxAuiPaneInfo.isTopDockable/1","doc":"`isTopDockable/1` returns true if the pane can be docked at the top of the\nmanaged frame.\n\nSee: `IsDockable()` (not implemented in wx)","ref":"wxAuiPaneInfo.html#isTopDockable/1"},{"type":"function","title":"wxAuiPaneInfo.layer/2","doc":"`layer/2` determines the layer of the docked pane.\n\nThe dock layer is similar to an onion, the inner-most layer being layer 0. Each\nshell moving in the outward direction has a higher layer number. This allows for\nmore complex docking layout formation.","ref":"wxAuiPaneInfo.html#layer/2"},{"type":"function","title":"wxAuiPaneInfo.left/1","doc":"`left/1` sets the pane dock position to the left side of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_LEFT).","ref":"wxAuiPaneInfo.html#left/1"},{"type":"function","title":"wxAuiPaneInfo.leftDockable/1","doc":"","ref":"wxAuiPaneInfo.html#leftDockable/1"},{"type":"function","title":"wxAuiPaneInfo.leftDockable/2","doc":"`leftDockable/2` indicates whether a pane can be docked on the left of the\nframe.","ref":"wxAuiPaneInfo.html#leftDockable/2"},{"type":"function","title":"wxAuiPaneInfo.maximizeButton/1","doc":"","ref":"wxAuiPaneInfo.html#maximizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.maximizeButton/2","doc":"`maximizeButton/2` indicates that a maximize button should be drawn for the\npane.","ref":"wxAuiPaneInfo.html#maximizeButton/2"},{"type":"function","title":"wxAuiPaneInfo.maxSize/2","doc":"`maxSize/3` sets the maximum size of the pane.","ref":"wxAuiPaneInfo.html#maxSize/2"},{"type":"function","title":"wxAuiPaneInfo.maxSize/3","doc":"","ref":"wxAuiPaneInfo.html#maxSize/3"},{"type":"function","title":"wxAuiPaneInfo.minimizeButton/1","doc":"","ref":"wxAuiPaneInfo.html#minimizeButton/1"},{"type":"function","title":"wxAuiPaneInfo.minimizeButton/2","doc":"`minimizeButton/2` indicates that a minimize button should be drawn for the\npane.","ref":"wxAuiPaneInfo.html#minimizeButton/2"},{"type":"function","title":"wxAuiPaneInfo.minSize/2","doc":"`minSize/3` sets the minimum size of the pane.\n\nPlease note that this is only partially supported as of this writing.","ref":"wxAuiPaneInfo.html#minSize/2"},{"type":"function","title":"wxAuiPaneInfo.minSize/3","doc":"","ref":"wxAuiPaneInfo.html#minSize/3"},{"type":"function","title":"wxAuiPaneInfo.movable/1","doc":"","ref":"wxAuiPaneInfo.html#movable/1"},{"type":"function","title":"wxAuiPaneInfo.movable/2","doc":"Movable indicates whether a frame can be moved.","ref":"wxAuiPaneInfo.html#movable/2"},{"type":"function","title":"wxAuiPaneInfo.name/2","doc":"`name/2` sets the name of the pane so it can be referenced in lookup functions.\n\nIf a name is not specified by the user, a random name is assigned to the pane\nwhen it is added to the manager.","ref":"wxAuiPaneInfo.html#name/2"},{"type":"function","title":"wxAuiPaneInfo.new/0","doc":"","ref":"wxAuiPaneInfo.html#new/0"},{"type":"function","title":"wxAuiPaneInfo.new/1","doc":"Copy constructor.","ref":"wxAuiPaneInfo.html#new/1"},{"type":"function","title":"wxAuiPaneInfo.paneBorder/1","doc":"","ref":"wxAuiPaneInfo.html#paneBorder/1"},{"type":"function","title":"wxAuiPaneInfo.paneBorder/2","doc":"PaneBorder indicates that a border should be drawn for the pane.","ref":"wxAuiPaneInfo.html#paneBorder/2"},{"type":"function","title":"wxAuiPaneInfo.pinButton/1","doc":"","ref":"wxAuiPaneInfo.html#pinButton/1"},{"type":"function","title":"wxAuiPaneInfo.pinButton/2","doc":"`pinButton/2` indicates that a pin button should be drawn for the pane.","ref":"wxAuiPaneInfo.html#pinButton/2"},{"type":"function","title":"wxAuiPaneInfo.position/2","doc":"`position/2` determines the position of the docked pane.","ref":"wxAuiPaneInfo.html#position/2"},{"type":"function","title":"wxAuiPaneInfo.resizable/1","doc":"","ref":"wxAuiPaneInfo.html#resizable/1"},{"type":"function","title":"wxAuiPaneInfo.resizable/2","doc":"`resizable/2` allows a pane to be resized if the parameter is true, and forces\nit to be a fixed size if the parameter is false.\n\nThis is simply an antonym for `fixed/1`.","ref":"wxAuiPaneInfo.html#resizable/2"},{"type":"function","title":"wxAuiPaneInfo.right/1","doc":"`right/1` sets the pane dock position to the right side of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_RIGHT).","ref":"wxAuiPaneInfo.html#right/1"},{"type":"function","title":"wxAuiPaneInfo.rightDockable/1","doc":"","ref":"wxAuiPaneInfo.html#rightDockable/1"},{"type":"function","title":"wxAuiPaneInfo.rightDockable/2","doc":"`rightDockable/2` indicates whether a pane can be docked on the right of the\nframe.","ref":"wxAuiPaneInfo.html#rightDockable/2"},{"type":"function","title":"wxAuiPaneInfo.row/2","doc":"`row/2` determines the row of the docked pane.","ref":"wxAuiPaneInfo.html#row/2"},{"type":"function","title":"wxAuiPaneInfo.safeSet/2","doc":"Write the safe parts of a PaneInfo object \"source\" into \"this\".\n\n\"Safe parts\" are all non-UI elements (e.g. all layout determining parameters\nlike the size, position etc.). \"Unsafe parts\" (pointers to button, frame and\nwindow) are not modified by this write operation.\n\nRemark: This method is used when loading perspectives.","ref":"wxAuiPaneInfo.html#safeSet/2"},{"type":"function","title":"wxAuiPaneInfo.setFlag/3","doc":"`setFlag/3` turns the property given by flag on or off with the option_state\nparameter.","ref":"wxAuiPaneInfo.html#setFlag/3"},{"type":"function","title":"wxAuiPaneInfo.show/1","doc":"","ref":"wxAuiPaneInfo.html#show/1"},{"type":"function","title":"wxAuiPaneInfo.show/2","doc":"`show/2` indicates that a pane should be shown.","ref":"wxAuiPaneInfo.html#show/2"},{"type":"function","title":"wxAuiPaneInfo.toolbarPane/1","doc":"`toolbarPane/1` specifies that the pane should adopt the default toolbar pane\nsettings.","ref":"wxAuiPaneInfo.html#toolbarPane/1"},{"type":"function","title":"wxAuiPaneInfo.top/1","doc":"`top/1` sets the pane dock position to the top of the frame.\n\nThis is the same thing as calling Direction(wxAUI_DOCK_TOP).","ref":"wxAuiPaneInfo.html#top/1"},{"type":"function","title":"wxAuiPaneInfo.topDockable/1","doc":"","ref":"wxAuiPaneInfo.html#topDockable/1"},{"type":"function","title":"wxAuiPaneInfo.topDockable/2","doc":"`topDockable/2` indicates whether a pane can be docked at the top of the frame.","ref":"wxAuiPaneInfo.html#topDockable/2"},{"type":"function","title":"wxAuiPaneInfo.window/2","doc":"`window/2` assigns the window pointer that the `m:wxAuiPaneInfo` should use.\n\nThis normally does not need to be specified, as the window pointer is\nautomatically assigned to the `m:wxAuiPaneInfo` structure as soon as it is added\nto the manager.","ref":"wxAuiPaneInfo.html#window/2"},{"type":"type","title":"wxAuiPaneInfo.wxAuiPaneInfo/0","doc":"","ref":"wxAuiPaneInfo.html#t:wxAuiPaneInfo/0"},{"type":"module","title":"wxAuiSimpleTabArt","doc":"Functions for wxAuiSimpleTabArt class\n\nAnother standard tab art provider for `m:wxAuiNotebook`.\n\n`m:wxAuiSimpleTabArt` is derived from `m:wxAuiTabArt` demonstrating how to write\na completely new tab art class. It can also be used as alternative to\n`wxAuiDefaultTabArt` (not implemented in wx).\n\nThis class is derived (and can use functions) from: `m:wxAuiTabArt`\n\nwxWidgets docs:\n[wxAuiSimpleTabArt](https://docs.wxwidgets.org/3.1/classwx_aui_simple_tab_art.html)","ref":"wxAuiSimpleTabArt.html"},{"type":"function","title":"wxAuiSimpleTabArt.destroy/1","doc":"Destroys the object.","ref":"wxAuiSimpleTabArt.html#destroy/1"},{"type":"function","title":"wxAuiSimpleTabArt.new/0","doc":"","ref":"wxAuiSimpleTabArt.html#new/0"},{"type":"type","title":"wxAuiSimpleTabArt.wxAuiSimpleTabArt/0","doc":"","ref":"wxAuiSimpleTabArt.html#t:wxAuiSimpleTabArt/0"},{"type":"module","title":"wxAuiTabArt","doc":"Functions for wxAuiTabArt class\n\nTab art provider defines all the drawing functions used by `m:wxAuiNotebook`.\n\nThis allows the `m:wxAuiNotebook` to have a pluggable look-and-feel.\n\nBy default, a `m:wxAuiNotebook` uses an instance of this class called\n`wxAuiDefaultTabArt` (not implemented in wx) which provides bitmap art and a\ncolour scheme that is adapted to the major platforms' look. You can either\nderive from that class to alter its behaviour or write a completely new tab art\nclass.\n\nAnother example of creating a new `m:wxAuiNotebook` tab bar is\n`m:wxAuiSimpleTabArt`.\n\nCall `wxAuiNotebook:setArtProvider/2` to make use of this new tab art.\n\nwxWidgets docs:\n[wxAuiTabArt](https://docs.wxwidgets.org/3.1/classwx_aui_tab_art.html)","ref":"wxAuiTabArt.html"},{"type":"function","title":"wxAuiTabArt.setActiveColour/2","doc":"Sets the colour of the selected tab.\n\nSince: 2.9.2","ref":"wxAuiTabArt.html#setActiveColour/2"},{"type":"function","title":"wxAuiTabArt.setColour/2","doc":"Sets the colour of the inactive tabs.\n\nSince: 2.9.2","ref":"wxAuiTabArt.html#setColour/2"},{"type":"function","title":"wxAuiTabArt.setFlags/2","doc":"Sets flags.","ref":"wxAuiTabArt.html#setFlags/2"},{"type":"function","title":"wxAuiTabArt.setMeasuringFont/2","doc":"Sets the font used for calculating measurements.","ref":"wxAuiTabArt.html#setMeasuringFont/2"},{"type":"function","title":"wxAuiTabArt.setNormalFont/2","doc":"Sets the normal font for drawing labels.","ref":"wxAuiTabArt.html#setNormalFont/2"},{"type":"function","title":"wxAuiTabArt.setSelectedFont/2","doc":"Sets the font for drawing text for selected UI elements.","ref":"wxAuiTabArt.html#setSelectedFont/2"},{"type":"type","title":"wxAuiTabArt.wxAuiTabArt/0","doc":"","ref":"wxAuiTabArt.html#t:wxAuiTabArt/0"},{"type":"module","title":"wxBitmap","doc":"Functions for wxBitmap class\n\nThis class encapsulates the concept of a platform-dependent bitmap, either\nmonochrome or colour or colour with alpha channel support.\n\nIf you need direct access the bitmap data instead going through drawing to it\nusing `m:wxMemoryDC` you need to use the `wxPixelData` (not implemented in wx)\nclass (either wxNativePixelData for RGB bitmaps or wxAlphaPixelData for bitmaps\nwith an additionally alpha channel).\n\nNote that many `m:wxBitmap` functions take a `type` parameter, which is a value\nof the ?wxBitmapType enumeration. The validity of those values depends however\non the platform where your program is running and from the wxWidgets\nconfiguration. If all possible wxWidgets settings are used:\n\nIn addition, `m:wxBitmap` can load and save all formats that `m:wxImage` can;\nsee `m:wxImage` for more info. Of course, you must have loaded the `m:wxImage`\nhandlers (see ?wxInitAllImageHandlers() and `wxImage::AddHandler` (not\nimplemented in wx)). Note that all available wxBitmapHandlers for a given\nwxWidgets port are automatically loaded at startup so you won't need to use\n`wxBitmap::AddHandler` (not implemented in wx).\n\nMore on the difference between `m:wxImage` and `m:wxBitmap`: `m:wxImage` is just\na buffer of RGB bytes with an optional buffer for the alpha bytes. It is all\ngeneric, platform independent and image file format independent code. It\nincludes generic code for scaling, resizing, clipping, and other manipulations\nof the image data. OTOH, `m:wxBitmap` is intended to be a wrapper of whatever is\nthe native image format that is quickest/easiest to draw to a DC or to be the\ntarget of the drawing operations performed on a `m:wxMemoryDC`. By splitting the\nresponsibilities between wxImage/wxBitmap like this then it's easier to use\ngeneric code shared by all platforms and image types for generic operations and\nplatform specific code where performance or compatibility is needed.\n\nPredefined objects (include wx.hrl): ?wxNullBitmap\n\nSee:\n[Overview bitmap](https://docs.wxwidgets.org/3.1/overview_bitmap.html#overview_bitmap),\n[Overview bitmap](https://docs.wxwidgets.org/3.1/overview_bitmap.html#overview_bitmap_supportedformats),\n`wxDC:blit/6`, `m:wxIcon`, `m:wxCursor`, `m:wxMemoryDC`, `m:wxImage`,\n`wxPixelData` (not implemented in wx)\n\nwxWidgets docs: [wxBitmap](https://docs.wxwidgets.org/3.1/classwx_bitmap.html)","ref":"wxBitmap.html"},{"type":"function","title":"wxBitmap.convertToImage/1","doc":"Creates an image from a platform-dependent bitmap.\n\nThis preserves mask information so that bitmaps and images can be converted back\nand forth without loss in that respect.","ref":"wxBitmap.html#convertToImage/1"},{"type":"function","title":"wxBitmap.copyFromIcon/2","doc":"Creates the bitmap from an icon.","ref":"wxBitmap.html#copyFromIcon/2"},{"type":"function","title":"wxBitmap.create/2","doc":"","ref":"wxBitmap.html#create/2"},{"type":"function","title":"wxBitmap.create/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxBitmap.html#create/3"},{"type":"function","title":"wxBitmap.create/4","doc":"Create a bitmap compatible with the given DC, inheriting its magnification\nfactor.\n\nReturn: true if the creation was successful.\n\nSince: 3.1.0","ref":"wxBitmap.html#create/4"},{"type":"function","title":"wxBitmap.destroy/1","doc":"Creates bitmap corresponding to the given cursor.\n\nThis can be useful to display a cursor as it cannot be drawn directly on a\nwindow.\n\nThis constructor only exists in wxMSW and wxGTK (where it is implemented for\nGTK+ 2.8 or later) only.\n\nSince: 3.1.0 Destructor. See overview_refcount_destruct for more info.\n\nIf the application omits to delete the bitmap explicitly, the bitmap will be\ndestroyed automatically by wxWidgets when the application exits.\n\nWarning: Do not delete a bitmap that is selected into a memory device context.","ref":"wxBitmap.html#destroy/1"},{"type":"function","title":"wxBitmap.getDepth/1","doc":"Gets the colour depth of the bitmap.\n\nA value of 1 indicates a monochrome bitmap.","ref":"wxBitmap.html#getDepth/1"},{"type":"function","title":"wxBitmap.getHeight/1","doc":"Gets the height of the bitmap in pixels.\n\nSee: `getWidth/1`, `GetSize()` (not implemented in wx)","ref":"wxBitmap.html#getHeight/1"},{"type":"function","title":"wxBitmap.getMask/1","doc":"Gets the associated mask (if any) which may have been loaded from a file or set\nfor the bitmap.\n\nSee: `setMask/2`, `m:wxMask`","ref":"wxBitmap.html#getMask/1"},{"type":"function","title":"wxBitmap.getPalette/1","doc":"Gets the associated palette (if any) which may have been loaded from a file or\nset for the bitmap.\n\nSee: `m:wxPalette`","ref":"wxBitmap.html#getPalette/1"},{"type":"function","title":"wxBitmap.getSubBitmap/2","doc":"Returns a sub bitmap of the current one as long as the rect belongs entirely to\nthe bitmap.\n\nThis function preserves bit depth and mask information.","ref":"wxBitmap.html#getSubBitmap/2"},{"type":"function","title":"wxBitmap.getWidth/1","doc":"Gets the width of the bitmap in pixels.\n\nSee: `getHeight/1`, `GetSize()` (not implemented in wx)","ref":"wxBitmap.html#getWidth/1"},{"type":"function","title":"wxBitmap.isOk/1","doc":"Returns true if bitmap data is present.","ref":"wxBitmap.html#isOk/1"},{"type":"function","title":"wxBitmap.loadFile/2","doc":"","ref":"wxBitmap.html#loadFile/2"},{"type":"function","title":"wxBitmap.loadFile/3","doc":"Loads a bitmap from a file or resource.\n\nReturn: true if the operation succeeded, false otherwise.\n\nRemark: A palette may be associated with the bitmap if one exists (especially\nfor colour Windows bitmaps), and if the code supports it. You can check if one\nhas been created by using the `getPalette/1` member.\n\nSee: `saveFile/4`","ref":"wxBitmap.html#loadFile/3"},{"type":"function","title":"wxBitmap.new/0","doc":"Default constructor.\n\nConstructs a bitmap object with no data; an assignment or another member\nfunction such as `create/4` or `loadFile/3` must be called subsequently.","ref":"wxBitmap.html#new/0"},{"type":"function","title":"wxBitmap.new/1","doc":"","ref":"wxBitmap.html#new/1"},{"type":"function","title":"wxBitmap.new/2","doc":"Creates this bitmap object from the given image.\n\nThis has to be done to actually display an image as you cannot draw an image\ndirectly on a window.\n\nThe resulting bitmap will use the provided colour depth (or that of the current\nsystem if depth is ?wxBITMAP_SCREEN_DEPTH) which entails that a colour reduction\nmay take place.\n\nOn Windows, if there is a palette present (set with SetPalette), it will be used\nwhen creating the `m:wxBitmap` (most useful in 8-bit display mode). On other\nplatforms, the palette is currently ignored.","ref":"wxBitmap.html#new/2"},{"type":"function","title":"wxBitmap.new/3","doc":"Creates a new bitmap.\n\nA depth of ?wxBITMAP_SCREEN_DEPTH indicates the depth of the current screen or\nvisual.\n\nSome platforms only support 1 for monochrome and ?wxBITMAP_SCREEN_DEPTH for the\ncurrent colour setting.\n\nA depth of 32 including an alpha channel is supported under MSW, Mac and GTK+.","ref":"wxBitmap.html#new/3"},{"type":"function","title":"wxBitmap.new/4","doc":"Creates a bitmap from the given array `bits`.\n\nYou should only use this function for monochrome bitmaps (depth 1) in portable\nprograms: in this case the bits parameter should contain an XBM image.\n\nFor other bit depths, the behaviour is platform dependent: under Windows, the\ndata is passed without any changes to the underlying CreateBitmap() API. Under\nother platforms, only monochrome bitmaps may be created using this constructor\nand `m:wxImage` should be used for creating colour bitmaps from static data.","ref":"wxBitmap.html#new/4"},{"type":"function","title":"wxBitmap.ok/1","doc":"See: `isOk/1`.","ref":"wxBitmap.html#ok/1"},{"type":"function","title":"wxBitmap.saveFile/3","doc":"","ref":"wxBitmap.html#saveFile/3"},{"type":"function","title":"wxBitmap.saveFile/4","doc":"Saves a bitmap in the named file.\n\nReturn: true if the operation succeeded, false otherwise.\n\nRemark: Depending on how wxWidgets has been configured, not all formats may be\navailable.\n\nSee: `loadFile/3`","ref":"wxBitmap.html#saveFile/4"},{"type":"function","title":"wxBitmap.setDepth/2","doc":"Deprecated: This function is deprecated since version 3.1.2, dimensions and\ndepth can only be set at construction time.\n\nSets the depth member (does not affect the bitmap data).","ref":"wxBitmap.html#setDepth/2"},{"type":"function","title":"wxBitmap.setHeight/2","doc":"Deprecated: This function is deprecated since version 3.1.2, dimensions and\ndepth can only be set at construction time.\n\nSets the height member (does not affect the bitmap data).","ref":"wxBitmap.html#setHeight/2"},{"type":"function","title":"wxBitmap.setMask/2","doc":"Sets the mask for this bitmap.\n\nRemark: The bitmap object owns the mask once this has been called.\n\nNote: A mask can be set also for bitmap with an alpha channel but doing so under\nwxMSW is not recommended because performance of drawing such bitmap is not very\ngood.\n\nSee: `getMask/1`, `m:wxMask`","ref":"wxBitmap.html#setMask/2"},{"type":"function","title":"wxBitmap.setPalette/2","doc":"Sets the associated palette.\n\n(Not implemented under GTK+).\n\nSee: `m:wxPalette`","ref":"wxBitmap.html#setPalette/2"},{"type":"function","title":"wxBitmap.setWidth/2","doc":"Deprecated: This function is deprecated since version 3.1.2, dimensions and\ndepth can only be set at construction time.\n\nSets the width member (does not affect the bitmap data).","ref":"wxBitmap.html#setWidth/2"},{"type":"type","title":"wxBitmap.wxBitmap/0","doc":"","ref":"wxBitmap.html#t:wxBitmap/0"},{"type":"module","title":"wxBitmapButton","doc":"Functions for wxBitmapButton class\n\nA bitmap button is a control that contains a bitmap.\n\nNotice that since wxWidgets 2.9.1 bitmap display is supported by the base\n`m:wxButton` class itself and the only tiny advantage of using this class is\nthat it allows specifying the bitmap in its constructor, unlike `m:wxButton`.\nPlease see the base class documentation for more information about images\nsupport in `m:wxButton`.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxButton`\n\nThis class is derived (and can use functions) from: `m:wxButton` `m:wxControl`\n`m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxBitmapButton](https://docs.wxwidgets.org/3.1/classwx_bitmap_button.html)","ref":"wxBitmapButton.html"},{"type":"module","title":"Events - wxBitmapButton","doc":"Event types emitted from this class:\n[`command_button_clicked`](`m:wxCommandEvent`)","ref":"wxBitmapButton.html#module-events"},{"type":"function","title":"wxBitmapButton.create/4","doc":"","ref":"wxBitmapButton.html#create/4"},{"type":"function","title":"wxBitmapButton.create/5","doc":"Button creation function for two-step creation.\n\nFor more details, see `new/4`.","ref":"wxBitmapButton.html#create/5"},{"type":"function","title":"wxBitmapButton.destroy/1","doc":"Destroys the object.","ref":"wxBitmapButton.html#destroy/1"},{"type":"function","title":"wxBitmapButton.new/0","doc":"Default ctor.","ref":"wxBitmapButton.html#new/0"},{"type":"function","title":"wxBitmapButton.new/3","doc":"","ref":"wxBitmapButton.html#new/3"},{"type":"function","title":"wxBitmapButton.new/4","doc":"Constructor, creating and showing a button.\n\nRemark: The bitmap parameter is normally the only bitmap you need to provide,\nand wxWidgets will draw the button correctly in its different states. If you\nwant more control, call any of the functions `SetBitmapPressed()` (not\nimplemented in wx), `wxButton:setBitmapFocus/2`, `wxButton:setBitmapDisabled/2`.\n\nSee: `create/5`, `wxValidator` (not implemented in wx)","ref":"wxBitmapButton.html#new/4"},{"type":"function","title":"wxBitmapButton.newCloseButton/2","doc":"Helper function creating a standard-looking \"Close\" button.\n\nTo get the best results, platform-specific code may need to be used to create a\nsmall, title bar-like \"Close\" button. This function is provided to avoid the\nneed to test for the current platform and creates the button with as native look\nas possible.\n\nReturn: The new button.\n\nSince: 2.9.5","ref":"wxBitmapButton.html#newCloseButton/2"},{"type":"type","title":"wxBitmapButton.wxBitmapButton/0","doc":"","ref":"wxBitmapButton.html#t:wxBitmapButton/0"},{"type":"module","title":"wxBitmapDataObject","doc":"Functions for wxBitmapDataObject class\n\n`m:wxBitmapDataObject` is a specialization of `m:wxDataObject` for bitmap data.\nIt can be used without change to paste data into the `m:wxClipboard` or a\n`wxDropSource` (not implemented in wx). A user may wish to derive a new class\nfrom this class for providing a bitmap on-demand in order to minimize memory\nconsumption when offering data in several formats, such as a bitmap and GIF.\n\nThis class may be used as is, but `getBitmap/1` may be overridden to increase\nefficiency.\n\nSee:\n[Overview dnd](https://docs.wxwidgets.org/3.1/overview_dnd.html#overview_dnd),\n`m:wxDataObject`, `wxDataObjectSimple` (not implemented in wx),\n`m:wxFileDataObject`, `m:wxTextDataObject`, `m:wxDataObject`\n\nThis class is derived (and can use functions) from: `m:wxDataObject`\n\nwxWidgets docs:\n[wxBitmapDataObject](https://docs.wxwidgets.org/3.1/classwx_bitmap_data_object.html)","ref":"wxBitmapDataObject.html"},{"type":"function","title":"wxBitmapDataObject.destroy/1","doc":"Destroys the object.","ref":"wxBitmapDataObject.html#destroy/1"},{"type":"function","title":"wxBitmapDataObject.getBitmap/1","doc":"Returns the bitmap associated with the data object.\n\nYou may wish to override this method when offering data on-demand, but this is\nnot required by wxWidgets' internals. Use this method to get data in bitmap form\nfrom the `m:wxClipboard`.","ref":"wxBitmapDataObject.html#getBitmap/1"},{"type":"function","title":"wxBitmapDataObject.new/0","doc":"","ref":"wxBitmapDataObject.html#new/0"},{"type":"function","title":"wxBitmapDataObject.new/1","doc":"Constructor, optionally passing a bitmap (otherwise use `setBitmap/2` later).","ref":"wxBitmapDataObject.html#new/1"},{"type":"function","title":"wxBitmapDataObject.setBitmap/2","doc":"Sets the bitmap associated with the data object.\n\nThis method is called when the data object receives data. Usually there will be\nno reason to override this function.","ref":"wxBitmapDataObject.html#setBitmap/2"},{"type":"type","title":"wxBitmapDataObject.wxBitmapDataObject/0","doc":"","ref":"wxBitmapDataObject.html#t:wxBitmapDataObject/0"},{"type":"module","title":"wxBookCtrlBase","doc":"Functions for wxBookCtrlBase class\n\nA book control is a convenient way of displaying multiple pages of information,\ndisplayed one page at a time. wxWidgets has five variants of this control:\n\nThis abstract class is the parent of all these book controls, and provides their\nbasic interface. This is a pure virtual class so you cannot allocate it\ndirectly.\n\nSee:\n[Overview bookctrl](https://docs.wxwidgets.org/3.1/overview_bookctrl.html#overview_bookctrl)\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxBookCtrlBase](https://docs.wxwidgets.org/3.1/classwx_book_ctrl_base.html)","ref":"wxBookCtrlBase.html"},{"type":"function","title":"wxBookCtrlBase.addPage/3","doc":"","ref":"wxBookCtrlBase.html#addPage/3"},{"type":"function","title":"wxBookCtrlBase.addPage/4","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been\nadded to this control previously.\n\nThe call to this function will generate the page changing and page changed\nevents if `select` is true, but not when inserting the very first page (as there\nis no previous page selection to switch from in this case and so it wouldn't\nmake sense to e.g. veto such event).\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/5`","ref":"wxBookCtrlBase.html#addPage/4"},{"type":"function","title":"wxBookCtrlBase.advanceSelection/1","doc":"","ref":"wxBookCtrlBase.html#advanceSelection/1"},{"type":"function","title":"wxBookCtrlBase.advanceSelection/2","doc":"Cycles through the tabs.\n\nThe call to this function generates the page changing events.","ref":"wxBookCtrlBase.html#advanceSelection/2"},{"type":"function","title":"wxBookCtrlBase.changeSelection/2","doc":"Changes the selection to the given page, returning the previous selection.\n\nThis function behaves as `setSelection/2` but does `not` generate the page\nchanging events.\n\nSee overview_events_prog for more information.","ref":"wxBookCtrlBase.html#changeSelection/2"},{"type":"function","title":"wxBookCtrlBase.deleteAllPages/1","doc":"Deletes all pages.","ref":"wxBookCtrlBase.html#deleteAllPages/1"},{"type":"function","title":"wxBookCtrlBase.deletePage/2","doc":"Deletes the specified page, and the associated window.\n\nThe call to this function generates the page changing events when deleting the\ncurrently selected page or a page preceding it in the index order, but it does\n`not` send any events when deleting the last page: while in this case the\nselection also changes, it becomes invalid and for compatibility reasons the\ncontrol never generates events with the invalid selection index.","ref":"wxBookCtrlBase.html#deletePage/2"},{"type":"function","title":"wxBookCtrlBase.getCurrentPage/1","doc":"Returns the currently selected page or NULL.","ref":"wxBookCtrlBase.html#getCurrentPage/1"},{"type":"function","title":"wxBookCtrlBase.getPage/2","doc":"Returns the window at the given page position.","ref":"wxBookCtrlBase.html#getPage/2"},{"type":"function","title":"wxBookCtrlBase.getPageCount/1","doc":"Returns the number of pages in the control.","ref":"wxBookCtrlBase.html#getPageCount/1"},{"type":"function","title":"wxBookCtrlBase.getPageText/2","doc":"Returns the string for the given page.","ref":"wxBookCtrlBase.html#getPageText/2"},{"type":"function","title":"wxBookCtrlBase.getSelection/1","doc":"Returns the currently selected page, or `wxNOT_FOUND` if none was selected.\n\nNote that this method may return either the previously or newly selected page\nwhen called from the `EVT_BOOKCTRL_PAGE_CHANGED` handler depending on the\nplatform and so `wxBookCtrlEvent:getSelection/1` should be used instead in this\ncase.","ref":"wxBookCtrlBase.html#getSelection/1"},{"type":"function","title":"wxBookCtrlBase.hitTest/2","doc":"Returns the index of the tab at the specified position or `wxNOT_FOUND` if none.\n\nIf `flags` parameter is non-NULL, the position of the point inside the tab is\nreturned as well.\n\nReturn: Returns the zero-based tab index or `wxNOT_FOUND` if there is no tab at\nthe specified position.","ref":"wxBookCtrlBase.html#hitTest/2"},{"type":"function","title":"wxBookCtrlBase.insertPage/4","doc":"","ref":"wxBookCtrlBase.html#insertPage/4"},{"type":"function","title":"wxBookCtrlBase.insertPage/5","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/4`","ref":"wxBookCtrlBase.html#insertPage/5"},{"type":"function","title":"wxBookCtrlBase.removePage/2","doc":"Deletes the specified page, without deleting the associated window.\n\nSee `deletePage/2` for a note about the events generated by this function.","ref":"wxBookCtrlBase.html#removePage/2"},{"type":"function","title":"wxBookCtrlBase.setPageText/3","doc":"Sets the text for the given page.","ref":"wxBookCtrlBase.html#setPageText/3"},{"type":"function","title":"wxBookCtrlBase.setSelection/2","doc":"Sets the selection to the given page, returning the previous selection.\n\nNotice that the call to this function generates the page changing events, use\nthe `changeSelection/2` function if you don't want these events to be generated.\n\nSee: `getSelection/1`","ref":"wxBookCtrlBase.html#setSelection/2"},{"type":"type","title":"wxBookCtrlBase.wxBookCtrlBase/0","doc":"","ref":"wxBookCtrlBase.html#t:wxBookCtrlBase/0"},{"type":"module","title":"wxBookCtrlEvent","doc":"Functions for wxBookCtrlEvent class\n\nThis class represents the events generated by book controls (`m:wxNotebook`,\n`m:wxListbook`, `m:wxChoicebook`, `m:wxTreebook`, `m:wxAuiNotebook`).\n\nThe PAGE_CHANGING events are sent before the current page is changed. It allows\nthe program to examine the current page (which can be retrieved with\n`getOldSelection/1`) and to veto the page change by calling\n`wxNotifyEvent:veto/1` if, for example, the current values in the controls of\nthe old page are invalid.\n\nThe PAGE_CHANGED events are sent after the page has been changed and the program\ncannot veto it any more, it just informs it about the page change.\n\nTo summarize, if the program is interested in validating the page values before\nallowing the user to change it, it should process the PAGE_CHANGING event,\notherwise PAGE_CHANGED is probably enough. In any case, it is probably\nunnecessary to process both events at once.\n\nSee: `m:wxNotebook`, `m:wxListbook`, `m:wxChoicebook`, `m:wxTreebook`,\n`m:wxToolbook`, `m:wxAuiNotebook`\n\nThis class is derived (and can use functions) from: `m:wxNotifyEvent`\n`m:wxCommandEvent` `m:wxEvent`\n\nwxWidgets docs:\n[wxBookCtrlEvent](https://docs.wxwidgets.org/3.1/classwx_book_ctrl_event.html)","ref":"wxBookCtrlEvent.html"},{"type":"function","title":"wxBookCtrlEvent.getOldSelection/1","doc":"Returns the page that was selected before the change, `wxNOT_FOUND` if none was\nselected.","ref":"wxBookCtrlEvent.html#getOldSelection/1"},{"type":"function","title":"wxBookCtrlEvent.getSelection/1","doc":"Returns the currently selected page, or `wxNOT_FOUND` if none was selected.\n\nNote: under Windows, `getSelection/1` will return the same value as\n`getOldSelection/1` when called from the `EVT_BOOKCTRL_PAGE_CHANGING` handler\nand not the page which is going to be selected.","ref":"wxBookCtrlEvent.html#getSelection/1"},{"type":"function","title":"wxBookCtrlEvent.setOldSelection/2","doc":"Sets the id of the page selected before the change.","ref":"wxBookCtrlEvent.html#setOldSelection/2"},{"type":"function","title":"wxBookCtrlEvent.setSelection/2","doc":"Sets the selection member variable.","ref":"wxBookCtrlEvent.html#setSelection/2"},{"type":"type","title":"wxBookCtrlEvent.wxBookCtrl/0","doc":"","ref":"wxBookCtrlEvent.html#t:wxBookCtrl/0"},{"type":"type","title":"wxBookCtrlEvent.wxBookCtrlEvent/0","doc":"","ref":"wxBookCtrlEvent.html#t:wxBookCtrlEvent/0"},{"type":"type","title":"wxBookCtrlEvent.wxBookCtrlEventType/0","doc":"","ref":"wxBookCtrlEvent.html#t:wxBookCtrlEventType/0"},{"type":"module","title":"wxBoxSizer","doc":"Functions for wxBoxSizer class\n\nThe basic idea behind a box sizer is that windows will most often be laid out in\nrather simple basic geometry, typically in a row or a column or several\nhierarchies of either.\n\nFor more information, please see overview_sizer_box.\n\nSee: `m:wxSizer`,\n[Overview sizer](https://docs.wxwidgets.org/3.1/overview_sizer.html#overview_sizer)\n\nThis class is derived (and can use functions) from: `m:wxSizer`\n\nwxWidgets docs:\n[wxBoxSizer](https://docs.wxwidgets.org/3.1/classwx_box_sizer.html)","ref":"wxBoxSizer.html"},{"type":"function","title":"wxBoxSizer.destroy/1","doc":"Destroys the object.","ref":"wxBoxSizer.html#destroy/1"},{"type":"function","title":"wxBoxSizer.getOrientation/1","doc":"Returns the orientation of the box sizer, either wxVERTICAL or wxHORIZONTAL.","ref":"wxBoxSizer.html#getOrientation/1"},{"type":"function","title":"wxBoxSizer.new/1","doc":"Constructor for a `m:wxBoxSizer`.\n\n`orient` may be either of wxVERTICAL or wxHORIZONTAL for creating either a\ncolumn sizer or a row sizer.","ref":"wxBoxSizer.html#new/1"},{"type":"type","title":"wxBoxSizer.wxBoxSizer/0","doc":"","ref":"wxBoxSizer.html#t:wxBoxSizer/0"},{"type":"module","title":"wxBrush","doc":"Functions for wxBrush class\n\nA brush is a drawing tool for filling in areas. It is used for painting the\nbackground of rectangles, ellipses, etc. It has a colour and a style.\n\nOn a monochrome display, wxWidgets shows all brushes as white unless the colour\nis really black.\n\nDo not initialize objects on the stack before the program commences, since other\nrequired structures may not have been set up yet. Instead, define global\npointers to objects and create them in `wxApp::OnInit` (not implemented in wx)\nor when required.\n\nAn application may wish to create brushes with different characteristics\ndynamically, and there is the consequent danger that a large number of duplicate\nbrushes will be created. Therefore an application may wish to get a pointer to a\nbrush by using the global list of brushes ?wxTheBrushList, and calling the\nmember function `wxBrushList::FindOrCreateBrush()` (not implemented in wx).\n\nThis class uses reference counting and copy-on-write internally so that\nassignments between two instances of this class are very cheap. You can\ntherefore use actual objects instead of pointers without efficiency problems. If\nan instance of this class is changed it will create its own data internally so\nthat other instances, which previously shared the data using the reference\ncounting, are not affected.\n\nPredefined objects (include wx.hrl):\n\nSee: `wxBrushList` (not implemented in wx), `m:wxDC`, `wxDC:setBrush/2`\n\nwxWidgets docs: [wxBrush](https://docs.wxwidgets.org/3.1/classwx_brush.html)","ref":"wxBrush.html"},{"type":"function","title":"wxBrush.destroy/1","doc":"Destructor.\n\nSee overview_refcount_destruct for more info.\n\nRemark: Although all remaining brushes are deleted when the application exits,\nthe application should try to clean up all brushes itself. This is because\nwxWidgets cannot know if a pointer to the brush object is stored in an\napplication data structure, and there is a risk of double deletion.","ref":"wxBrush.html#destroy/1"},{"type":"function","title":"wxBrush.getColour/1","doc":"Returns a reference to the brush colour.\n\nSee: `setColour/4`","ref":"wxBrush.html#getColour/1"},{"type":"function","title":"wxBrush.getStipple/1","doc":"Gets a pointer to the stipple bitmap.\n\nIf the brush does not have a `wxBRUSHSTYLE_STIPPLE` style, this bitmap may be\nnon-NULL but uninitialised (i.e. `m:wxBitmap`:`isOk/1` returns false).\n\nSee: `setStipple/2`","ref":"wxBrush.html#getStipple/1"},{"type":"function","title":"wxBrush.getStyle/1","doc":"Returns the brush style, one of the ?wxBrushStyle values.\n\nSee: `setStyle/2`, `setColour/4`, `setStipple/2`","ref":"wxBrush.html#getStyle/1"},{"type":"function","title":"wxBrush.isHatch/1","doc":"Returns true if the style of the brush is any of hatched fills.\n\nSee: `getStyle/1`","ref":"wxBrush.html#isHatch/1"},{"type":"function","title":"wxBrush.isOk/1","doc":"Returns true if the brush is initialised.\n\nNotice that an uninitialized brush object can't be queried for any brush\nproperties and all calls to the accessor methods on it will result in an assert\nfailure.","ref":"wxBrush.html#isOk/1"},{"type":"function","title":"wxBrush.new/0","doc":"Default constructor.\n\nThe brush will be uninitialised, and `m:wxBrush`:`isOk/1` will return false.","ref":"wxBrush.html#new/0"},{"type":"function","title":"wxBrush.new/1","doc":"Copy constructor, uses reference counting.","ref":"wxBrush.html#new/1"},{"type":"function","title":"wxBrush.new/2","doc":"Constructs a brush from a colour object and `style`.","ref":"wxBrush.html#new/2"},{"type":"function","title":"wxBrush.setColour/2","doc":"Sets the brush colour using red, green and blue values.\n\nSee: `getColour/1`","ref":"wxBrush.html#setColour/2"},{"type":"function","title":"wxBrush.setColour/4","doc":"","ref":"wxBrush.html#setColour/4"},{"type":"function","title":"wxBrush.setStipple/2","doc":"Sets the stipple bitmap.\n\nRemark: The style will be set to `wxBRUSHSTYLE_STIPPLE`, unless the bitmap has a\nmask associated to it, in which case the style will be set to\n`wxBRUSHSTYLE_STIPPLE_MASK_OPAQUE`.\n\nSee: `m:wxBitmap`","ref":"wxBrush.html#setStipple/2"},{"type":"function","title":"wxBrush.setStyle/2","doc":"Sets the brush style.\n\nSee: `getStyle/1`","ref":"wxBrush.html#setStyle/2"},{"type":"type","title":"wxBrush.wxBrush/0","doc":"","ref":"wxBrush.html#t:wxBrush/0"},{"type":"module","title":"wxBufferedDC","doc":"Functions for wxBufferedDC class\n\nThis class provides a simple way to avoid flicker: when drawing on it,\neverything is in fact first drawn on an in-memory buffer (a `m:wxBitmap`) and\nthen copied to the screen, using the associated `m:wxDC`, only once, when this\nobject is destroyed. `m:wxBufferedDC` itself is typically associated with\n`m:wxClientDC`, if you want to use it in your `EVT_PAINT` handler, you should\nlook at `m:wxBufferedPaintDC` instead.\n\nWhen used like this, a valid `DC` must be specified in the constructor while the\n`buffer` bitmap doesn't have to be explicitly provided, by default this class\nwill allocate the bitmap of required size itself. However using a dedicated\nbitmap can speed up the redrawing process by eliminating the repeated creation\nand destruction of a possibly big bitmap. Otherwise, `m:wxBufferedDC` can be\nused in the same way as any other device context.\n\nAnother possible use for `m:wxBufferedDC` is to use it to maintain a backing\nstore for the window contents. In this case, the associated `DC` may be NULL but\na valid backing store bitmap should be specified.\n\nFinally, please note that GTK+ 2.0 as well as macOS provide double buffering\nthemselves natively. You can either use `wxWindow:isDoubleBuffered/1` to\ndetermine whether you need to use buffering or not, or use\n`wxAutoBufferedPaintDC` (not implemented in wx) to avoid needless double\nbuffering on the systems which already do it automatically.\n\nSee: `m:wxDC`, `m:wxMemoryDC`, `m:wxBufferedPaintDC`, `wxAutoBufferedPaintDC`\n(not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxMemoryDC` `m:wxDC`\n\nwxWidgets docs:\n[wxBufferedDC](https://docs.wxwidgets.org/3.1/classwx_buffered_d_c.html)","ref":"wxBufferedDC.html"},{"type":"function","title":"wxBufferedDC.destroy/1","doc":"Copies everything drawn on the DC so far to the underlying DC associated with\nthis object, if any.","ref":"wxBufferedDC.html#destroy/1"},{"type":"function","title":"wxBufferedDC.init/2","doc":"","ref":"wxBufferedDC.html#init/2"},{"type":"function","title":"wxBufferedDC.init/3","doc":"","ref":"wxBufferedDC.html#init/3"},{"type":"function","title":"wxBufferedDC.init/4","doc":"Initializes the object created using the default constructor.\n\nPlease see the constructors for parameter details.","ref":"wxBufferedDC.html#init/4"},{"type":"function","title":"wxBufferedDC.new/0","doc":"Default constructor.\n\nYou must call one of the `init/4` methods later in order to use the device\ncontext.","ref":"wxBufferedDC.html#new/0"},{"type":"function","title":"wxBufferedDC.new/1","doc":"","ref":"wxBufferedDC.html#new/1"},{"type":"function","title":"wxBufferedDC.new/2","doc":"Creates a buffer for the provided dc.\n\n`init/4` must not be called when using this constructor.","ref":"wxBufferedDC.html#new/2"},{"type":"function","title":"wxBufferedDC.new/3","doc":"Creates a buffer for the provided `dc`.\n\n`init/4` must not be called when using this constructor.","ref":"wxBufferedDC.html#new/3"},{"type":"type","title":"wxBufferedDC.wxBufferedDC/0","doc":"","ref":"wxBufferedDC.html#t:wxBufferedDC/0"},{"type":"module","title":"wxBufferedPaintDC","doc":"Functions for wxBufferedPaintDC class\n\nThis is a subclass of `m:wxBufferedDC` which can be used inside of an\n`EVT_PAINT()` event handler to achieve double-buffered drawing. Just use this\nclass instead of `m:wxPaintDC` and make sure `wxWindow:setBackgroundStyle/2` is\ncalled with wxBG_STYLE_PAINT somewhere in the class initialization code, and\nthat's all you have to do to (mostly) avoid flicker. The only thing to watch out\nfor is that if you are using this class together with `wxScrolled` (not\nimplemented in wx), you probably do `not` want to call\n`wxScrolledWindow:prepareDC/2` on it as it already does this internally for the\nreal underlying `m:wxPaintDC`.\n\nSee: `m:wxDC`, `m:wxBufferedDC`, `wxAutoBufferedPaintDC` (not implemented in\nwx), `m:wxPaintDC`\n\nThis class is derived (and can use functions) from: `m:wxBufferedDC`\n`m:wxMemoryDC` `m:wxDC`\n\nwxWidgets docs:\n[wxBufferedPaintDC](https://docs.wxwidgets.org/3.1/classwx_buffered_paint_d_c.html)","ref":"wxBufferedPaintDC.html"},{"type":"function","title":"wxBufferedPaintDC.destroy/1","doc":"Copies everything drawn on the DC so far to the window associated with this\nobject, using a `m:wxPaintDC`.","ref":"wxBufferedPaintDC.html#destroy/1"},{"type":"function","title":"wxBufferedPaintDC.new/1","doc":"","ref":"wxBufferedPaintDC.html#new/1"},{"type":"function","title":"wxBufferedPaintDC.new/2","doc":"","ref":"wxBufferedPaintDC.html#new/2"},{"type":"function","title":"wxBufferedPaintDC.new/3","doc":"As with `m:wxBufferedDC`, you may either provide the bitmap to be used for\nbuffering or let this object create one internally (in the latter case, the size\nof the client part of the window is used).\n\nPass wxBUFFER_CLIENT_AREA for the `style` parameter to indicate that just the\nclient area of the window is buffered, or wxBUFFER_VIRTUAL_AREA to indicate that\nthe buffer bitmap covers the virtual area.","ref":"wxBufferedPaintDC.html#new/3"},{"type":"type","title":"wxBufferedPaintDC.wxBufferedPaintDC/0","doc":"","ref":"wxBufferedPaintDC.html#t:wxBufferedPaintDC/0"},{"type":"module","title":"wxButton","doc":"Functions for wxButton class\n\nA button is a control that contains a text string, and is one of the most common\nelements of a GUI.\n\nIt may be placed on a `m:wxDialog` or on a `m:wxPanel` panel, or indeed on\nalmost any other window.\n\nBy default, i.e. if none of the alignment styles are specified, the label is\ncentered both horizontally and vertically. If the button has both a label and a\nbitmap, the alignment styles above specify the location of the rectangle\ncombining both the label and the bitmap and the bitmap position set with\n`wxButton::SetBitmapPosition()` (not implemented in wx) defines the relative\nposition of the bitmap with respect to the label (however currently non-default\nalignment combinations are not implemented on all platforms).\n\nSince version 2.9.1 `m:wxButton` supports showing both text and an image\n(currently only when using wxMSW, wxGTK or wxOSX/Cocoa ports), see `SetBitmap()`\n(not implemented in wx) and `setBitmapLabel/2`, `setBitmapDisabled/2` &c\nmethods. In the previous wxWidgets versions this functionality was only\navailable in (the now trivial) `m:wxBitmapButton` class which was only capable\nof showing an image without text.\n\nA button may have either a single image for all states or different images for\nthe following states (different images are not currently supported under macOS\nwhere the normal image is used for all states):\n\nAll of the bitmaps must be of the same size and the normal bitmap must be set\nfirst (to a valid bitmap), before setting any other ones. Also, if the size of\nthe bitmaps is changed later, you need to change the size of the normal bitmap\nbefore setting any other bitmaps with the new size (and you do need to reset all\nof them as their original values can be lost when the normal bitmap size\nchanges).\n\nThe position of the image inside the button be configured using\n`SetBitmapPosition()` (not implemented in wx). By default the image is on the\nleft of the text.\n\nPlease also notice that GTK+ uses a global setting called `gtk-button-images` to\ndetermine if the images should be shown in the buttons at all. If it is off\n(which is the case in e.g. Gnome 2.28 by default), no images will be shown,\nconsistently with the native behaviour.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxBitmapButton`\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs: [wxButton](https://docs.wxwidgets.org/3.1/classwx_button.html)","ref":"wxButton.html"},{"type":"module","title":"Events - wxButton","doc":"Event types emitted from this class:\n[`command_button_clicked`](`m:wxCommandEvent`)","ref":"wxButton.html#module-events"},{"type":"function","title":"wxButton.create/3","doc":"","ref":"wxButton.html#create/3"},{"type":"function","title":"wxButton.create/4","doc":"Button creation function for two-step creation.\n\nFor more details, see `new/3`.","ref":"wxButton.html#create/4"},{"type":"function","title":"wxButton.destroy/1","doc":"Destroys the object.","ref":"wxButton.html#destroy/1"},{"type":"function","title":"wxButton.getBitmapDisabled/1","doc":"Returns the bitmap for the disabled state, which may be invalid.\n\nSee: `setBitmapDisabled/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#getBitmapDisabled/1"},{"type":"function","title":"wxButton.getBitmapFocus/1","doc":"Returns the bitmap for the focused state, which may be invalid.\n\nSee: `setBitmapFocus/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#getBitmapFocus/1"},{"type":"function","title":"wxButton.getBitmapLabel/1","doc":"Returns the bitmap for the normal state.\n\nThis is exactly the same as `GetBitmap()` (not implemented in wx) but uses a\nname backwards-compatible with `m:wxBitmapButton`.\n\nSee: `SetBitmap()` (not implemented in wx), `setBitmapLabel/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#getBitmapLabel/1"},{"type":"function","title":"wxButton.getDefaultSize/0","doc":"Returns the default size for the buttons.\n\nIt is advised to make all the dialog buttons of the same size and this function\nallows retrieving the (platform, and current font dependent) size which should\nbe the best suited for this.\n\nThe optional `win` argument is new since wxWidgets 3.1.3 and allows to get a\nper-monitor DPI specific size.","ref":"wxButton.html#getDefaultSize/0"},{"type":"function","title":"wxButton.getDefaultSize/1","doc":"","ref":"wxButton.html#getDefaultSize/1"},{"type":"function","title":"wxButton.new/0","doc":"Default ctor.","ref":"wxButton.html#new/0"},{"type":"function","title":"wxButton.new/2","doc":"","ref":"wxButton.html#new/2"},{"type":"function","title":"wxButton.new/3","doc":"Constructor, creating and showing a button.\n\nThe preferred way to create standard buttons is to use default value of `label`.\nIf no label is supplied and `id` is one of standard IDs from this list, a\nstandard label will be used. In other words, if you use a predefined `wxID_XXX`\nconstant, just omit the label completely rather than specifying it. In\nparticular, help buttons (the ones with `id` of `wxID_HELP`) under macOS can't\ndisplay any label at all and while `m:wxButton` will detect if the standard\n\"Help\" label is used and ignore it, using any other label will prevent the\nbutton from correctly appearing as a help button and so should be avoided.\n\nIn addition to that, the button will be decorated with stock icons under GTK+ 2.\n\nSee: `create/4`, `wxValidator` (not implemented in wx)","ref":"wxButton.html#new/3"},{"type":"function","title":"wxButton.setBitmapDisabled/2","doc":"Sets the bitmap for the disabled button appearance.\n\nIf `bitmap` is invalid, the disabled bitmap is set to the automatically\ngenerated greyed out version of the normal bitmap, i.e. the same bitmap as is\nused by default if this method is not called at all. Use `SetBitmap()` (not\nimplemented in wx) with an invalid bitmap to remove the bitmap completely (for\nall states).\n\nSee: `getBitmapDisabled/1`, `setBitmapLabel/2`, `SetBitmapPressed()` (not\nimplemented in wx), `setBitmapFocus/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#setBitmapDisabled/2"},{"type":"function","title":"wxButton.setBitmapFocus/2","doc":"Sets the bitmap for the button appearance when it has the keyboard focus.\n\nIf `bitmap` is invalid, the normal bitmap will be used in the focused state.\n\nSee: `getBitmapFocus/1`, `setBitmapLabel/2`, `SetBitmapPressed()` (not\nimplemented in wx), `setBitmapDisabled/2`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#setBitmapFocus/2"},{"type":"function","title":"wxButton.setBitmapLabel/2","doc":"Sets the bitmap label for the button.\n\nRemark: This is the bitmap used for the unselected state, and for all other\nstates if no other bitmaps are provided.\n\nSee: `SetBitmap()` (not implemented in wx), `getBitmapLabel/1`\n\nSince: 2.9.1 (available in `m:wxBitmapButton` only in previous versions)","ref":"wxButton.html#setBitmapLabel/2"},{"type":"function","title":"wxButton.setDefault/1","doc":"This sets the button to be the default item in its top-level window (e.g.\n\nthe panel or the dialog box containing it).\n\nAs normal, pressing return causes the default button to be depressed when the\nreturn key is pressed.\n\nSee also `wxWindow:setFocus/1` which sets the keyboard focus for windows and\ntext panel items, and `wxTopLevelWindow::SetDefaultItem()` (not implemented in\nwx).\n\nRemark: Under Windows, only dialog box buttons respond to this function.\n\nReturn: the old default item (possibly NULL)","ref":"wxButton.html#setDefault/1"},{"type":"function","title":"wxButton.setLabel/2","doc":"Sets the string label for the button.","ref":"wxButton.html#setLabel/2"},{"type":"type","title":"wxButton.wxButton/0","doc":"","ref":"wxButton.html#t:wxButton/0"},{"type":"module","title":"wxCalendarCtrl","doc":"Functions for wxCalendarCtrl class\n\nThe calendar control allows the user to pick a date. The user can move the\ncurrent selection using the keyboard and select the date (generating\n`EVT_CALENDAR` event) by pressing ` ` or double clicking it.\n\nGeneric calendar has advanced possibilities for the customization of its\ndisplay, described below. If you want to use these possibilities on every\nplatform, use wxGenericCalendarCtrl instead of `m:wxCalendarCtrl`.\n\nAll global settings (such as colours and fonts used) can, of course, be changed.\nBut also, the display style for each day in the month can be set independently\nusing `m:wxCalendarDateAttr` class.\n\nAn item without custom attributes is drawn with the default colours and font and\nwithout border, but setting custom attributes with `setAttr/3` allows modifying\nits appearance. Just create a custom attribute object and set it for the day you\nwant to be displayed specially (note that the control will take ownership of the\npointer, i.e. it will delete it itself). A day may be marked as being a holiday,\neven if it is not recognized as one by [`wx_datetime()`](`t:wx:wx_datetime/0`)\nusing the `wxCalendarDateAttr:setHoliday/2` method.\n\nAs the attributes are specified for each day, they may change when the month is\nchanged, so you will often want to update them in `EVT_CALENDAR_PAGE_CHANGED`\nevent handler.\n\nIf neither the `wxCAL_SUNDAY_FIRST` or `wxCAL_MONDAY_FIRST` style is given, the\nfirst day of the week is determined from operating system's settings, if\npossible. The native wxGTK calendar chooses the first weekday based on locale,\nand these styles have no effect on it.\n\nStyles\n\nThis class supports the following styles:\n\nNote: Changing the selected date will trigger an EVT_CALENDAR_DAY, MONTH or YEAR\nevent as well as an EVT_CALENDAR_SEL_CHANGED event.\n\nSee:\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_calendar),\n`m:wxCalendarDateAttr`, `m:wxCalendarEvent`, `m:wxDatePickerCtrl`\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxCalendarCtrl](https://docs.wxwidgets.org/3.1/classwx_calendar_ctrl.html)","ref":"wxCalendarCtrl.html"},{"type":"module","title":"Events - wxCalendarCtrl","doc":"Event types emitted from this class:\n[`calendar_sel_changed`](`m:wxCalendarEvent`),\n[`calendar_weekday_clicked`](`m:wxCalendarEvent`)","ref":"wxCalendarCtrl.html#module-events"},{"type":"function","title":"wxCalendarCtrl.create/3","doc":"","ref":"wxCalendarCtrl.html#create/3"},{"type":"function","title":"wxCalendarCtrl.create/4","doc":"Creates the control.\n\nSee `wxWindow:new/3` for the meaning of the parameters and the control overview\nfor the possible styles.","ref":"wxCalendarCtrl.html#create/4"},{"type":"function","title":"wxCalendarCtrl.destroy/1","doc":"Destroys the control.","ref":"wxCalendarCtrl.html#destroy/1"},{"type":"function","title":"wxCalendarCtrl.enableHolidayDisplay/1","doc":"","ref":"wxCalendarCtrl.html#enableHolidayDisplay/1"},{"type":"function","title":"wxCalendarCtrl.enableHolidayDisplay/2","doc":"This function should be used instead of changing `wxCAL_SHOW_HOLIDAYS` style bit\ndirectly.\n\nIt enables or disables the special highlighting of the holidays.","ref":"wxCalendarCtrl.html#enableHolidayDisplay/2"},{"type":"function","title":"wxCalendarCtrl.enableMonthChange/1","doc":"","ref":"wxCalendarCtrl.html#enableMonthChange/1"},{"type":"function","title":"wxCalendarCtrl.enableMonthChange/2","doc":"This function should be used instead of changing `wxCAL_NO_MONTH_CHANGE` style\nbit.\n\nIt allows or disallows the user to change the month interactively. Note that if\nthe month cannot be changed, the year cannot be changed neither.\n\nReturn: true if the value of this option really changed or false if it was\nalready set to the requested value.","ref":"wxCalendarCtrl.html#enableMonthChange/2"},{"type":"function","title":"wxCalendarCtrl.enableYearChange/1","doc":"","ref":"wxCalendarCtrl.html#enableYearChange/1"},{"type":"function","title":"wxCalendarCtrl.enableYearChange/2","doc":"Deprecated:\n\nThis function should be used instead of changing `wxCAL_NO_YEAR_CHANGE` style\nbit directly. It allows or disallows the user to change the year interactively.\nOnly in generic `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#enableYearChange/2"},{"type":"function","title":"wxCalendarCtrl.getAttr/2","doc":"Returns the attribute for the given date (should be in the range 1...31).\n\nThe returned pointer may be NULL. Only in generic `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#getAttr/2"},{"type":"function","title":"wxCalendarCtrl.getDate/1","doc":"Gets the currently selected date.","ref":"wxCalendarCtrl.html#getDate/1"},{"type":"function","title":"wxCalendarCtrl.getHeaderColourBg/1","doc":"Gets the background colour of the header part of the calendar window.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and\nalways returns `wxNullColour` in the native versions.\n\nSee: `setHeaderColours/3`","ref":"wxCalendarCtrl.html#getHeaderColourBg/1"},{"type":"function","title":"wxCalendarCtrl.getHeaderColourFg/1","doc":"Gets the foreground colour of the header part of the calendar window.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and\nalways returns `wxNullColour` in the native versions.\n\nSee: `setHeaderColours/3`","ref":"wxCalendarCtrl.html#getHeaderColourFg/1"},{"type":"function","title":"wxCalendarCtrl.getHighlightColourBg/1","doc":"Gets the background highlight colour.\n\nOnly in generic `m:wxCalendarCtrl`.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and\nalways returns `wxNullColour` in the native versions.\n\nSee: `setHighlightColours/3`","ref":"wxCalendarCtrl.html#getHighlightColourBg/1"},{"type":"function","title":"wxCalendarCtrl.getHighlightColourFg/1","doc":"Gets the foreground highlight colour.\n\nOnly in generic `m:wxCalendarCtrl`.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and\nalways returns `wxNullColour` in the native versions.\n\nSee: `setHighlightColours/3`","ref":"wxCalendarCtrl.html#getHighlightColourFg/1"},{"type":"function","title":"wxCalendarCtrl.getHolidayColourBg/1","doc":"Return the background colour currently used for holiday highlighting.\n\nOnly useful with generic `m:wxCalendarCtrl` as native versions currently don't\nsupport holidays display at all and always return `wxNullColour`.\n\nSee: `setHolidayColours/3`","ref":"wxCalendarCtrl.html#getHolidayColourBg/1"},{"type":"function","title":"wxCalendarCtrl.getHolidayColourFg/1","doc":"Return the foreground colour currently used for holiday highlighting.\n\nOnly useful with generic `m:wxCalendarCtrl` as native versions currently don't\nsupport holidays display at all and always return `wxNullColour`.\n\nSee: `setHolidayColours/3`","ref":"wxCalendarCtrl.html#getHolidayColourFg/1"},{"type":"function","title":"wxCalendarCtrl.hitTest/2","doc":"Returns one of wxCalendarHitTestResult constants and fills either `date` or `wd`\npointer with the corresponding value depending on the hit test code.\n\nNot implemented in wxGTK currently.","ref":"wxCalendarCtrl.html#hitTest/2"},{"type":"function","title":"wxCalendarCtrl.new/0","doc":"Default constructor.","ref":"wxCalendarCtrl.html#new/0"},{"type":"function","title":"wxCalendarCtrl.new/2","doc":"","ref":"wxCalendarCtrl.html#new/2"},{"type":"function","title":"wxCalendarCtrl.new/3","doc":"Does the same as `create/4` method.","ref":"wxCalendarCtrl.html#new/3"},{"type":"function","title":"wxCalendarCtrl.resetAttr/2","doc":"Clears any attributes associated with the given day (in the range 1...31).\n\nOnly in generic `m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#resetAttr/2"},{"type":"function","title":"wxCalendarCtrl.setAttr/3","doc":"Associates the attribute with the specified date (in the range 1...31).\n\nIf the pointer is NULL, the items attribute is cleared. Only in generic\n`m:wxCalendarCtrl`.","ref":"wxCalendarCtrl.html#setAttr/3"},{"type":"function","title":"wxCalendarCtrl.setDate/2","doc":"Sets the current date.\n\nThe `date` parameter must be valid and in the currently valid range as set by\n`SetDateRange()` (not implemented in wx), otherwise the current date is not\nchanged and the function returns false and, additionally, triggers an assertion\nfailure if the date is invalid.","ref":"wxCalendarCtrl.html#setDate/2"},{"type":"function","title":"wxCalendarCtrl.setHeaderColours/3","doc":"Set the colours used for painting the weekdays at the top of the control.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and does\nnothing in the native versions.","ref":"wxCalendarCtrl.html#setHeaderColours/3"},{"type":"function","title":"wxCalendarCtrl.setHighlightColours/3","doc":"Set the colours to be used for highlighting the currently selected date.\n\nThis method is currently only implemented in generic `m:wxCalendarCtrl` and does\nnothing in the native versions.","ref":"wxCalendarCtrl.html#setHighlightColours/3"},{"type":"function","title":"wxCalendarCtrl.setHoliday/2","doc":"Marks the specified day as being a holiday in the current month.\n\nThis method is only implemented in the generic version of the control and does\nnothing in the native ones.","ref":"wxCalendarCtrl.html#setHoliday/2"},{"type":"function","title":"wxCalendarCtrl.setHolidayColours/3","doc":"Sets the colours to be used for the holidays highlighting.\n\nThis method is only implemented in the generic version of the control and does\nnothing in the native ones. It should also only be called if the window style\nincludes `wxCAL_SHOW_HOLIDAYS` flag or `enableHolidayDisplay/2` had been called.","ref":"wxCalendarCtrl.html#setHolidayColours/3"},{"type":"type","title":"wxCalendarCtrl.wxCalendarCtrl/0","doc":"","ref":"wxCalendarCtrl.html#t:wxCalendarCtrl/0"},{"type":"module","title":"wxCalendarDateAttr","doc":"Functions for wxCalendarDateAttr class\n\n`m:wxCalendarDateAttr` is a custom attributes for a calendar date. The objects\nof this class are used with `m:wxCalendarCtrl`.\n\nSee: `m:wxCalendarCtrl`\n\nwxWidgets docs:\n[wxCalendarDateAttr](https://docs.wxwidgets.org/3.1/classwx_calendar_date_attr.html)","ref":"wxCalendarDateAttr.html"},{"type":"function","title":"wxCalendarDateAttr.destroy/1","doc":"Destroys the object.","ref":"wxCalendarDateAttr.html#destroy/1"},{"type":"function","title":"wxCalendarDateAttr.getBackgroundColour/1","doc":"Returns the background colour set for the calendar date.","ref":"wxCalendarDateAttr.html#getBackgroundColour/1"},{"type":"function","title":"wxCalendarDateAttr.getBorder/1","doc":"Returns the border set for the calendar date.","ref":"wxCalendarDateAttr.html#getBorder/1"},{"type":"function","title":"wxCalendarDateAttr.getBorderColour/1","doc":"Returns the border colour set for the calendar date.","ref":"wxCalendarDateAttr.html#getBorderColour/1"},{"type":"function","title":"wxCalendarDateAttr.getFont/1","doc":"Returns the font set for the calendar date.","ref":"wxCalendarDateAttr.html#getFont/1"},{"type":"function","title":"wxCalendarDateAttr.getTextColour/1","doc":"Returns the text colour set for the calendar date.","ref":"wxCalendarDateAttr.html#getTextColour/1"},{"type":"function","title":"wxCalendarDateAttr.hasBackgroundColour/1","doc":"Returns true if a non-default text background colour is set.","ref":"wxCalendarDateAttr.html#hasBackgroundColour/1"},{"type":"function","title":"wxCalendarDateAttr.hasBorder/1","doc":"Returns true if a non-default (i.e. any) border is set.","ref":"wxCalendarDateAttr.html#hasBorder/1"},{"type":"function","title":"wxCalendarDateAttr.hasBorderColour/1","doc":"Returns true if a non-default border colour is set.","ref":"wxCalendarDateAttr.html#hasBorderColour/1"},{"type":"function","title":"wxCalendarDateAttr.hasFont/1","doc":"Returns true if a non-default font is set.","ref":"wxCalendarDateAttr.html#hasFont/1"},{"type":"function","title":"wxCalendarDateAttr.hasTextColour/1","doc":"Returns true if a non-default text foreground colour is set.","ref":"wxCalendarDateAttr.html#hasTextColour/1"},{"type":"function","title":"wxCalendarDateAttr.isHoliday/1","doc":"Returns true if this calendar day is displayed as a holiday.","ref":"wxCalendarDateAttr.html#isHoliday/1"},{"type":"function","title":"wxCalendarDateAttr.new/0","doc":"","ref":"wxCalendarDateAttr.html#new/0"},{"type":"function","title":"wxCalendarDateAttr.new/1","doc":"Constructor for specifying all `m:wxCalendarDateAttr` properties.","ref":"wxCalendarDateAttr.html#new/1"},{"type":"function","title":"wxCalendarDateAttr.new/2","doc":"Constructor using default properties except the given border.","ref":"wxCalendarDateAttr.html#new/2"},{"type":"function","title":"wxCalendarDateAttr.setBackgroundColour/2","doc":"Sets the text background colour to use.","ref":"wxCalendarDateAttr.html#setBackgroundColour/2"},{"type":"function","title":"wxCalendarDateAttr.setBorder/2","doc":"Sets the border to use.","ref":"wxCalendarDateAttr.html#setBorder/2"},{"type":"function","title":"wxCalendarDateAttr.setBorderColour/2","doc":"Sets the border colour to use.","ref":"wxCalendarDateAttr.html#setBorderColour/2"},{"type":"function","title":"wxCalendarDateAttr.setFont/2","doc":"Sets the font to use.","ref":"wxCalendarDateAttr.html#setFont/2"},{"type":"function","title":"wxCalendarDateAttr.setHoliday/2","doc":"If `holiday` is true, this calendar day will be displayed as a holiday.","ref":"wxCalendarDateAttr.html#setHoliday/2"},{"type":"function","title":"wxCalendarDateAttr.setTextColour/2","doc":"Sets the text (foreground) colour to use.","ref":"wxCalendarDateAttr.html#setTextColour/2"},{"type":"type","title":"wxCalendarDateAttr.wxCalendarDateAttr/0","doc":"","ref":"wxCalendarDateAttr.html#t:wxCalendarDateAttr/0"},{"type":"module","title":"wxCalendarEvent","doc":"Functions for wxCalendarEvent class\n\nThe `m:wxCalendarEvent` class is used together with `m:wxCalendarCtrl`.\n\nSee: `m:wxCalendarCtrl`\n\nThis class is derived (and can use functions) from: `m:wxDateEvent`\n`m:wxCommandEvent` `m:wxEvent`\n\nwxWidgets docs:\n[wxCalendarEvent](https://docs.wxwidgets.org/3.1/classwx_calendar_event.html)","ref":"wxCalendarEvent.html"},{"type":"function","title":"wxCalendarEvent.getDate/1","doc":"Returns the date.","ref":"wxCalendarEvent.html#getDate/1"},{"type":"function","title":"wxCalendarEvent.getWeekDay/1","doc":"Returns the week day on which the user clicked in `EVT_CALENDAR_WEEKDAY_CLICKED`\nhandler.\n\nIt doesn't make sense to call this function in other handlers.","ref":"wxCalendarEvent.html#getWeekDay/1"},{"type":"type","title":"wxCalendarEvent.wxCalendar/0","doc":"","ref":"wxCalendarEvent.html#t:wxCalendar/0"},{"type":"type","title":"wxCalendarEvent.wxCalendarEvent/0","doc":"","ref":"wxCalendarEvent.html#t:wxCalendarEvent/0"},{"type":"type","title":"wxCalendarEvent.wxCalendarEventType/0","doc":"","ref":"wxCalendarEvent.html#t:wxCalendarEventType/0"},{"type":"module","title":"wxCaret","doc":"Functions for wxCaret class\n\nA caret is a blinking cursor showing the position where the typed text will\nappear. Text controls usually have their own caret but `m:wxCaret` provides a\nway to use a caret in other windows.\n\nCurrently, the caret appears as a rectangle of the given size. In the future, it\nwill be possible to specify a bitmap to be used for the caret shape.\n\nA caret is always associated with a window and the current caret can be\nretrieved using `wxWindow:getCaret/1`. The same caret can't be reused in two\ndifferent windows.\n\nwxWidgets docs: [wxCaret](https://docs.wxwidgets.org/3.1/classwx_caret.html)","ref":"wxCaret.html"},{"type":"function","title":"wxCaret.create/3","doc":"","ref":"wxCaret.html#create/3"},{"type":"function","title":"wxCaret.create/4","doc":"Creates a caret with the given size (in pixels) and associates it with the\n`window` (same as the equivalent constructors).","ref":"wxCaret.html#create/4"},{"type":"function","title":"wxCaret.destroy/1","doc":"Destroys the object.","ref":"wxCaret.html#destroy/1"},{"type":"function","title":"wxCaret.getBlinkTime/0","doc":"Returns the blink time which is measured in milliseconds and is the time elapsed\nbetween 2 inversions of the caret (blink time of the caret is the same for all\ncarets, so this functions is static).","ref":"wxCaret.html#getBlinkTime/0"},{"type":"function","title":"wxCaret.getPosition/1","doc":"","ref":"wxCaret.html#getPosition/1"},{"type":"function","title":"wxCaret.getSize/1","doc":"","ref":"wxCaret.html#getSize/1"},{"type":"function","title":"wxCaret.getWindow/1","doc":"Get the window the caret is associated with.","ref":"wxCaret.html#getWindow/1"},{"type":"function","title":"wxCaret.hide/1","doc":"Hides the caret, same as Show(false).","ref":"wxCaret.html#hide/1"},{"type":"function","title":"wxCaret.isOk/1","doc":"Returns true if the caret was created successfully.","ref":"wxCaret.html#isOk/1"},{"type":"function","title":"wxCaret.isVisible/1","doc":"Returns true if the caret is visible and false if it is permanently hidden (if\nit is blinking and not shown currently but will be after the next blink, this\nmethod still returns true).","ref":"wxCaret.html#isVisible/1"},{"type":"function","title":"wxCaret.move/2","doc":"","ref":"wxCaret.html#move/2"},{"type":"function","title":"wxCaret.move/3","doc":"Move the caret to given position (in logical coordinates).","ref":"wxCaret.html#move/3"},{"type":"function","title":"wxCaret.new/2","doc":"","ref":"wxCaret.html#new/2"},{"type":"function","title":"wxCaret.new/3","doc":"Creates a caret with the given size (in pixels) and associates it with the\n`window`.","ref":"wxCaret.html#new/3"},{"type":"function","title":"wxCaret.setBlinkTime/1","doc":"Sets the blink time for all the carets.\n\nWarning: Under Windows, this function will change the blink time for all carets\npermanently (until the next time it is called), even for carets in other\napplications.\n\nSee: `getBlinkTime/0`","ref":"wxCaret.html#setBlinkTime/1"},{"type":"function","title":"wxCaret.setSize/2","doc":"","ref":"wxCaret.html#setSize/2"},{"type":"function","title":"wxCaret.setSize/3","doc":"Changes the size of the caret.","ref":"wxCaret.html#setSize/3"},{"type":"function","title":"wxCaret.show/1","doc":"","ref":"wxCaret.html#show/1"},{"type":"function","title":"wxCaret.show/2","doc":"Shows or hides the caret.\n\nNotice that if the caret was hidden N times, it must be shown N times as well to\nreappear on the screen.","ref":"wxCaret.html#show/2"},{"type":"type","title":"wxCaret.wxCaret/0","doc":"","ref":"wxCaret.html#t:wxCaret/0"},{"type":"module","title":"wxCheckBox","doc":"Functions for wxCheckBox class\n\nA checkbox is a labelled box which by default is either on (checkmark is\nvisible) or off (no checkmark). Optionally (when the wxCHK_3STATE style flag is\nset) it can have a third state, called the mixed or undetermined state. Often\nthis is used as a \"Does Not Apply\" state.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxRadioButton`, `m:wxCommandEvent`\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxCheckBox](https://docs.wxwidgets.org/3.1/classwx_check_box.html)","ref":"wxCheckBox.html"},{"type":"module","title":"Events - wxCheckBox","doc":"Event types emitted from this class:\n[`command_checkbox_clicked`](`m:wxCommandEvent`)","ref":"wxCheckBox.html#module-events"},{"type":"function","title":"wxCheckBox.create/4","doc":"","ref":"wxCheckBox.html#create/4"},{"type":"function","title":"wxCheckBox.create/5","doc":"Creates the checkbox for two-step construction.\n\nSee `new/4` for details.","ref":"wxCheckBox.html#create/5"},{"type":"function","title":"wxCheckBox.destroy/1","doc":"Destructor, destroying the checkbox.","ref":"wxCheckBox.html#destroy/1"},{"type":"function","title":"wxCheckBox.get3StateValue/1","doc":"Gets the state of a 3-state checkbox.\n\nAsserts when the function is used with a 2-state checkbox.","ref":"wxCheckBox.html#get3StateValue/1"},{"type":"function","title":"wxCheckBox.getValue/1","doc":"Gets the state of a 2-state checkbox.\n\nReturn: Returns true if it is checked, false otherwise.","ref":"wxCheckBox.html#getValue/1"},{"type":"function","title":"wxCheckBox.is3rdStateAllowedForUser/1","doc":"Returns whether or not the user can set the checkbox to the third state.\n\nReturn: true if the user can set the third state of this checkbox, false if it\ncan only be set programmatically or if it's a 2-state checkbox.","ref":"wxCheckBox.html#is3rdStateAllowedForUser/1"},{"type":"function","title":"wxCheckBox.is3State/1","doc":"Returns whether or not the checkbox is a 3-state checkbox.\n\nReturn: true if this checkbox is a 3-state checkbox, false if it's a 2-state\ncheckbox.","ref":"wxCheckBox.html#is3State/1"},{"type":"function","title":"wxCheckBox.isChecked/1","doc":"This is just a maybe more readable synonym for `getValue/1`: just as the latter,\nit returns true if the checkbox is checked and false otherwise.","ref":"wxCheckBox.html#isChecked/1"},{"type":"function","title":"wxCheckBox.new/0","doc":"Default constructor.\n\nSee: `create/5`, `wxValidator` (not implemented in wx)","ref":"wxCheckBox.html#new/0"},{"type":"function","title":"wxCheckBox.new/3","doc":"","ref":"wxCheckBox.html#new/3"},{"type":"function","title":"wxCheckBox.new/4","doc":"Constructor, creating and showing a checkbox.\n\nSee: `create/5`, `wxValidator` (not implemented in wx)","ref":"wxCheckBox.html#new/4"},{"type":"function","title":"wxCheckBox.set3StateValue/2","doc":"Sets the checkbox to the given state.\n\nThis does not cause a `wxEVT_CHECKBOX` event to get emitted.\n\nAsserts when the checkbox is a 2-state checkbox and setting the state to\nwxCHK_UNDETERMINED.","ref":"wxCheckBox.html#set3StateValue/2"},{"type":"function","title":"wxCheckBox.setValue/2","doc":"Sets the checkbox to the given state.\n\nThis does not cause a `wxEVT_CHECKBOX` event to get emitted.","ref":"wxCheckBox.html#setValue/2"},{"type":"type","title":"wxCheckBox.wxCheckBox/0","doc":"","ref":"wxCheckBox.html#t:wxCheckBox/0"},{"type":"module","title":"wxCheckListBox","doc":"Functions for wxCheckListBox class\n\nA `m:wxCheckListBox` is like a `m:wxListBox`, but allows items to be checked or\nunchecked.\n\nWhen using this class under Windows wxWidgets must be compiled with\nwxUSE_OWNER_DRAWN set to 1.\n\nSee: `m:wxListBox`, `m:wxChoice`, `m:wxComboBox`, `m:wxListCtrl`,\n`m:wxCommandEvent`\n\nThis class is derived (and can use functions) from: `m:wxListBox`\n`m:wxControlWithItems` `m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxCheckListBox](https://docs.wxwidgets.org/3.1/classwx_check_list_box.html)","ref":"wxCheckListBox.html"},{"type":"module","title":"Events - wxCheckListBox","doc":"Event types emitted from this class:\n[`command_checklistbox_toggled`](`m:wxCommandEvent`)","ref":"wxCheckListBox.html#module-events"},{"type":"function","title":"wxCheckListBox.check/2","doc":"","ref":"wxCheckListBox.html#check/2"},{"type":"function","title":"wxCheckListBox.check/3","doc":"Checks the given item.\n\nNote that calling this method does not result in a `wxEVT_CHECKLISTBOX` event\nbeing emitted.","ref":"wxCheckListBox.html#check/3"},{"type":"function","title":"wxCheckListBox.destroy/1","doc":"Destructor, destroying the list box.","ref":"wxCheckListBox.html#destroy/1"},{"type":"function","title":"wxCheckListBox.isChecked/2","doc":"Returns true if the given item is checked, false otherwise.","ref":"wxCheckListBox.html#isChecked/2"},{"type":"function","title":"wxCheckListBox.new/0","doc":"Default constructor.","ref":"wxCheckListBox.html#new/0"},{"type":"function","title":"wxCheckListBox.new/2","doc":"","ref":"wxCheckListBox.html#new/2"},{"type":"function","title":"wxCheckListBox.new/3","doc":"Constructor, creating and showing a list box.","ref":"wxCheckListBox.html#new/3"},{"type":"type","title":"wxCheckListBox.wxCheckListBox/0","doc":"","ref":"wxCheckListBox.html#t:wxCheckListBox/0"},{"type":"module","title":"wxChildFocusEvent","doc":"Functions for wxChildFocusEvent class\n\nA child focus event is sent to a (parent-)window when one of its child windows\ngains focus, so that the window could restore the focus back to its\ncorresponding child if it loses it now and regains later.\n\nNotice that child window is the direct child of the window receiving event. Use\n`wxWindow:findFocus/0` to retrieve the window which is actually getting focus.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxChildFocusEvent](https://docs.wxwidgets.org/3.1/classwx_child_focus_event.html)","ref":"wxChildFocusEvent.html"},{"type":"module","title":"Events - wxChildFocusEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxChildFocusEventType`](`t:wxChildFocusEventType/0`) to subscribe to events of\nthis type.","ref":"wxChildFocusEvent.html#module-events"},{"type":"function","title":"wxChildFocusEvent.getWindow/1","doc":"Returns the direct child which receives the focus, or a (grand-)parent of the\ncontrol receiving the focus.\n\nTo get the actually focused control use `wxWindow:findFocus/0`.","ref":"wxChildFocusEvent.html#getWindow/1"},{"type":"type","title":"wxChildFocusEvent.wxChildFocus/0","doc":"","ref":"wxChildFocusEvent.html#t:wxChildFocus/0"},{"type":"type","title":"wxChildFocusEvent.wxChildFocusEvent/0","doc":"","ref":"wxChildFocusEvent.html#t:wxChildFocusEvent/0"},{"type":"type","title":"wxChildFocusEvent.wxChildFocusEventType/0","doc":"","ref":"wxChildFocusEvent.html#t:wxChildFocusEventType/0"},{"type":"module","title":"wxChoice","doc":"Functions for wxChoice class\n\nA choice item is used to select one of a list of strings. Unlike a\n`m:wxListBox`, only the selection is visible until the user pulls down the menu\nof choices.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxListBox`, `m:wxComboBox`, `m:wxCommandEvent`\n\nThis class is derived (and can use functions) from: `m:wxControlWithItems`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs: [wxChoice](https://docs.wxwidgets.org/3.1/classwx_choice.html)","ref":"wxChoice.html"},{"type":"module","title":"Events - wxChoice","doc":"Event types emitted from this class:\n[`command_choice_selected`](`m:wxCommandEvent`)","ref":"wxChoice.html#module-events"},{"type":"function","title":"wxChoice.create/6","doc":"","ref":"wxChoice.html#create/6"},{"type":"function","title":"wxChoice.create/7","doc":"","ref":"wxChoice.html#create/7"},{"type":"function","title":"wxChoice.delete/2","doc":"Deletes an item from the control.\n\nThe client data associated with the item will be also deleted if it is owned by\nthe control. Note that it is an error (signalled by an assert failure in debug\nbuilds) to remove an item with the index negative or greater or equal than the\nnumber of items in the control.\n\nIf there is a currently selected item below the item being deleted, i.e. if\n`wxControlWithItems:getSelection/1` returns a valid index greater than or equal\nto `n`, the selection is invalidated when this function is called. However if\nthe selected item appears before the item being deleted, the selection is\npreserved unchanged.\n\nSee: `wxControlWithItems:clear/1`","ref":"wxChoice.html#delete/2"},{"type":"function","title":"wxChoice.destroy/1","doc":"Destructor, destroying the choice item.","ref":"wxChoice.html#destroy/1"},{"type":"function","title":"wxChoice.getColumns/1","doc":"Gets the number of columns in this choice item.\n\nRemark: This is implemented for GTK and Motif only and always returns 1 for the\nother platforms.","ref":"wxChoice.html#getColumns/1"},{"type":"function","title":"wxChoice.new/0","doc":"Default constructor.\n\nSee: `create/7`, `wxValidator` (not implemented in wx)","ref":"wxChoice.html#new/0"},{"type":"function","title":"wxChoice.new/2","doc":"","ref":"wxChoice.html#new/2"},{"type":"function","title":"wxChoice.new/3","doc":"Constructor, creating and showing a choice.\n\nSee: `create/7`, `wxValidator` (not implemented in wx)","ref":"wxChoice.html#new/3"},{"type":"function","title":"wxChoice.setColumns/1","doc":"","ref":"wxChoice.html#setColumns/1"},{"type":"function","title":"wxChoice.setColumns/2","doc":"Sets the number of columns in this choice item.\n\nRemark: This is implemented for GTK and Motif only and doesn’t do anything under\nother platforms.","ref":"wxChoice.html#setColumns/2"},{"type":"type","title":"wxChoice.wxChoice/0","doc":"","ref":"wxChoice.html#t:wxChoice/0"},{"type":"module","title":"wxChoicebook","doc":"Functions for wxChoicebook class\n\n`m:wxChoicebook` is a class similar to `m:wxNotebook`, but uses a `m:wxChoice`\ncontrol to show the labels instead of the tabs.\n\nFor usage documentation of this class, please refer to the base abstract class\nwxBookCtrl. You can also use the page_samples_notebook to see `m:wxChoicebook`\nin action.\n\n`m:wxChoicebook` allows the use of wxBookCtrlBase::GetControlSizer(), allowing a\nprogram to add other controls next to the choice control. This is particularly\nuseful when screen space is restricted, as it often is when `m:wxChoicebook` is\nbeing employed.\n\nStyles\n\nThis class supports the following styles:\n\nSee:\n[Overview bookctrl](https://docs.wxwidgets.org/3.1/overview_bookctrl.html#overview_bookctrl),\n`m:wxNotebook`,\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_notebook)\n\nThis class is derived (and can use functions) from: `m:wxBookCtrlBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxChoicebook](https://docs.wxwidgets.org/3.1/classwx_choicebook.html)","ref":"wxChoicebook.html"},{"type":"module","title":"Events - wxChoicebook","doc":"Event types emitted from this class:\n[`choicebook_page_changed`](`m:wxBookCtrlEvent`),\n[`choicebook_page_changing`](`m:wxBookCtrlEvent`)","ref":"wxChoicebook.html#module-events"},{"type":"function","title":"wxChoicebook.addPage/3","doc":"","ref":"wxChoicebook.html#addPage/3"},{"type":"function","title":"wxChoicebook.addPage/4","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been\nadded to this control previously.\n\nThe call to this function will generate the page changing and page changed\nevents if `select` is true, but not when inserting the very first page (as there\nis no previous page selection to switch from in this case and so it wouldn't\nmake sense to e.g. veto such event).\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/5`","ref":"wxChoicebook.html#addPage/4"},{"type":"function","title":"wxChoicebook.advanceSelection/1","doc":"","ref":"wxChoicebook.html#advanceSelection/1"},{"type":"function","title":"wxChoicebook.advanceSelection/2","doc":"Cycles through the tabs.\n\nThe call to this function generates the page changing events.","ref":"wxChoicebook.html#advanceSelection/2"},{"type":"function","title":"wxChoicebook.assignImageList/2","doc":"Sets the image list for the page control and takes ownership of the list.\n\nSee: `m:wxImageList`, `setImageList/2`","ref":"wxChoicebook.html#assignImageList/2"},{"type":"function","title":"wxChoicebook.changeSelection/2","doc":"Changes the selection to the given page, returning the previous selection.\n\nThis function behaves as `setSelection/2` but does `not` generate the page\nchanging events.\n\nSee overview_events_prog for more information.","ref":"wxChoicebook.html#changeSelection/2"},{"type":"function","title":"wxChoicebook.create/3","doc":"","ref":"wxChoicebook.html#create/3"},{"type":"function","title":"wxChoicebook.create/4","doc":"Create the choicebook control that has already been constructed with the default\nconstructor.","ref":"wxChoicebook.html#create/4"},{"type":"function","title":"wxChoicebook.deleteAllPages/1","doc":"Deletes all pages.","ref":"wxChoicebook.html#deleteAllPages/1"},{"type":"function","title":"wxChoicebook.destroy/1","doc":"Destroys the object.","ref":"wxChoicebook.html#destroy/1"},{"type":"function","title":"wxChoicebook.getCurrentPage/1","doc":"Returns the currently selected page or NULL.","ref":"wxChoicebook.html#getCurrentPage/1"},{"type":"function","title":"wxChoicebook.getImageList/1","doc":"Returns the associated image list, may be NULL.\n\nSee: `m:wxImageList`, `setImageList/2`","ref":"wxChoicebook.html#getImageList/1"},{"type":"function","title":"wxChoicebook.getPage/2","doc":"Returns the window at the given page position.","ref":"wxChoicebook.html#getPage/2"},{"type":"function","title":"wxChoicebook.getPageCount/1","doc":"Returns the number of pages in the control.","ref":"wxChoicebook.html#getPageCount/1"},{"type":"function","title":"wxChoicebook.getPageImage/2","doc":"Returns the image index for the given page.","ref":"wxChoicebook.html#getPageImage/2"},{"type":"function","title":"wxChoicebook.getPageText/2","doc":"Returns the string for the given page.","ref":"wxChoicebook.html#getPageText/2"},{"type":"function","title":"wxChoicebook.getSelection/1","doc":"Returns the currently selected page, or `wxNOT_FOUND` if none was selected.\n\nNote that this method may return either the previously or newly selected page\nwhen called from the `EVT_BOOKCTRL_PAGE_CHANGED` handler depending on the\nplatform and so `wxBookCtrlEvent:getSelection/1` should be used instead in this\ncase.","ref":"wxChoicebook.html#getSelection/1"},{"type":"function","title":"wxChoicebook.hitTest/2","doc":"Returns the index of the tab at the specified position or `wxNOT_FOUND` if none.\n\nIf `flags` parameter is non-NULL, the position of the point inside the tab is\nreturned as well.\n\nReturn: Returns the zero-based tab index or `wxNOT_FOUND` if there is no tab at\nthe specified position.","ref":"wxChoicebook.html#hitTest/2"},{"type":"function","title":"wxChoicebook.insertPage/4","doc":"","ref":"wxChoicebook.html#insertPage/4"},{"type":"function","title":"wxChoicebook.insertPage/5","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/4`","ref":"wxChoicebook.html#insertPage/5"},{"type":"function","title":"wxChoicebook.new/0","doc":"Constructs a choicebook control.","ref":"wxChoicebook.html#new/0"},{"type":"function","title":"wxChoicebook.new/2","doc":"","ref":"wxChoicebook.html#new/2"},{"type":"function","title":"wxChoicebook.new/3","doc":"","ref":"wxChoicebook.html#new/3"},{"type":"function","title":"wxChoicebook.setImageList/2","doc":"Sets the image list to use.\n\nIt does not take ownership of the image list, you must delete it yourself.\n\nSee: `m:wxImageList`, `assignImageList/2`","ref":"wxChoicebook.html#setImageList/2"},{"type":"function","title":"wxChoicebook.setPageImage/3","doc":"Sets the image index for the given page.\n\n`image` is an index into the image list which was set with `setImageList/2`.","ref":"wxChoicebook.html#setPageImage/3"},{"type":"function","title":"wxChoicebook.setPageSize/2","doc":"Sets the width and height of the pages.\n\nNote: This method is currently not implemented for wxGTK.","ref":"wxChoicebook.html#setPageSize/2"},{"type":"function","title":"wxChoicebook.setPageText/3","doc":"Sets the text for the given page.","ref":"wxChoicebook.html#setPageText/3"},{"type":"function","title":"wxChoicebook.setSelection/2","doc":"Sets the selection to the given page, returning the previous selection.\n\nNotice that the call to this function generates the page changing events, use\nthe `changeSelection/2` function if you don't want these events to be generated.\n\nSee: `getSelection/1`","ref":"wxChoicebook.html#setSelection/2"},{"type":"type","title":"wxChoicebook.wxChoicebook/0","doc":"","ref":"wxChoicebook.html#t:wxChoicebook/0"},{"type":"module","title":"wxClientDC","doc":"Functions for wxClientDC class\n\n`m:wxClientDC` is primarily useful for obtaining information about the window\nfrom outside EVT_PAINT() handler.\n\nTypical use of this class is to obtain the extent of some text string in order\nto allocate enough size for a window, e.g.\n\nNote: While `m:wxClientDC` may also be used for drawing on the client area of a\nwindow from outside an EVT_PAINT() handler in some ports, this does `not` work\non all platforms (neither wxOSX nor wxGTK with GTK 3 Wayland backend support\nthis, so drawing using `m:wxClientDC` simply doesn't have any effect there) and\nthe only portable way of drawing is via `m:wxPaintDC`. To redraw a small part of\nthe window, use `wxWindow:refreshRect/3` to invalidate just this part and check\n`wxWindow:getUpdateRegion/1` in the paint event handler to redraw this part\nonly.\n\n`m:wxClientDC` objects should normally be constructed as temporary stack\nobjects, i.e. don't store a `m:wxClientDC` object.\n\nA `m:wxClientDC` object is initialized to use the same font and colours as the\nwindow it is associated with.\n\nSee: `m:wxDC`, `m:wxMemoryDC`, `m:wxPaintDC`, `m:wxWindowDC`, `m:wxScreenDC`\n\nThis class is derived (and can use functions) from: `m:wxWindowDC` `m:wxDC`\n\nwxWidgets docs:\n[wxClientDC](https://docs.wxwidgets.org/3.1/classwx_client_d_c.html)","ref":"wxClientDC.html"},{"type":"function","title":"wxClientDC.destroy/1","doc":"Destroys the object.","ref":"wxClientDC.html#destroy/1"},{"type":"function","title":"wxClientDC.new/1","doc":"Constructor.\n\nPass a pointer to the window on which you wish to paint.","ref":"wxClientDC.html#new/1"},{"type":"type","title":"wxClientDC.wxClientDC/0","doc":"","ref":"wxClientDC.html#t:wxClientDC/0"},{"type":"module","title":"wxClipboard","doc":"Functions for wxClipboard class\n\nA class for manipulating the clipboard.\n\nTo use the clipboard, you call member functions of the global ?wxTheClipboard\nobject.\n\nSee the overview_dataobject for further information.\n\nCall `open/1` to get ownership of the clipboard. If this operation returns true,\nyou now own the clipboard. Call `setData/2` to put data on the clipboard, or\n`getData/2` to retrieve data from the clipboard. Call `close/1` to close the\nclipboard and relinquish ownership. You should keep the clipboard open only\nmomentarily.\n\nFor example:\n\nNote: On GTK, the clipboard behavior can vary depending on the configuration of\nthe end-user's machine. In order for the clipboard data to persist after the\nwindow closes, a clipboard manager must be installed. Some clipboard managers\nwill automatically flush the clipboard after each new piece of data is added,\nwhile others will not. The @Flush() function will force the clipboard manager to\nflush the data.\n\nSee:\n[Overview dnd](https://docs.wxwidgets.org/3.1/overview_dnd.html#overview_dnd),\n[Overview dataobject](https://docs.wxwidgets.org/3.1/overview_dataobject.html#overview_dataobject),\n`m:wxDataObject`\n\nwxWidgets docs:\n[wxClipboard](https://docs.wxwidgets.org/3.1/classwx_clipboard.html)","ref":"wxClipboard.html"},{"type":"function","title":"wxClipboard.addData/2","doc":"Call this function to add the data object to the clipboard.\n\nThis is an obsolete synonym for `setData/2`.","ref":"wxClipboard.html#addData/2"},{"type":"function","title":"wxClipboard.clear/1","doc":"Clears the global clipboard object and the system's clipboard if possible.","ref":"wxClipboard.html#clear/1"},{"type":"function","title":"wxClipboard.close/1","doc":"Call this function to close the clipboard, having opened it with `open/1`.","ref":"wxClipboard.html#close/1"},{"type":"function","title":"wxClipboard.destroy/1","doc":"Destructor.","ref":"wxClipboard.html#destroy/1"},{"type":"function","title":"wxClipboard.flush/1","doc":"Flushes the clipboard: this means that the data which is currently on clipboard\nwill stay available even after the application exits (possibly eating memory),\notherwise the clipboard will be emptied on exit.\n\nCurrently this method is implemented in MSW and GTK and always returns false\notherwise.\n\nNote: On GTK, only the non-primary selection can be flushed. Calling this\nfunction when the clipboard is using the primary selection will return false and\nnot make any data available after the program exits.\n\nReturn: false if the operation is unsuccessful for any reason.","ref":"wxClipboard.html#flush/1"},{"type":"function","title":"wxClipboard.get/0","doc":"Returns the global instance (wxTheClipboard) of the clipboard object.","ref":"wxClipboard.html#get/0"},{"type":"function","title":"wxClipboard.getData/2","doc":"Call this function to fill `data` with data on the clipboard, if available in\nthe required format.\n\nReturns true on success.","ref":"wxClipboard.html#getData/2"},{"type":"function","title":"wxClipboard.isOpened/1","doc":"Returns true if the clipboard has been opened.","ref":"wxClipboard.html#isOpened/1"},{"type":"function","title":"wxClipboard.isSupported/2","doc":"Returns true if there is data which matches the data format of the given data\nobject currently `available` on the clipboard.","ref":"wxClipboard.html#isSupported/2"},{"type":"function","title":"wxClipboard.new/0","doc":"Default constructor.","ref":"wxClipboard.html#new/0"},{"type":"function","title":"wxClipboard.open/1","doc":"Call this function to open the clipboard before calling `setData/2` and\n`getData/2`.\n\nCall `close/1` when you have finished with the clipboard. You should keep the\nclipboard open for only a very short time.\n\nReturn: true on success. This should be tested (as in the sample shown above).","ref":"wxClipboard.html#open/1"},{"type":"function","title":"wxClipboard.setData/2","doc":"Call this function to set the data object to the clipboard.\n\nThe new data object replaces any previously set one, so if the application wants\nto provide clipboard data in several different formats, it must use a composite\ndata object supporting all of the formats instead of calling this function\nseveral times with different data objects as this would only leave data from the\nlast one in the clipboard.\n\nAfter this function has been called, the clipboard owns the data, so do not\ndelete the data explicitly.","ref":"wxClipboard.html#setData/2"},{"type":"function","title":"wxClipboard.usePrimarySelection/1","doc":"","ref":"wxClipboard.html#usePrimarySelection/1"},{"type":"function","title":"wxClipboard.usePrimarySelection/2","doc":"On platforms supporting it (all X11-based ports), `m:wxClipboard` uses the\nCLIPBOARD X11 selection by default.\n\nWhen this function is called with true, all subsequent clipboard operations will\nuse PRIMARY selection until this function is called again with false.\n\nOn the other platforms, there is no PRIMARY selection and so all clipboard\noperations will fail. This allows implementing the standard X11 handling of the\nclipboard which consists in copying data to the CLIPBOARD selection only when\nthe user explicitly requests it (i.e. by selecting the \"Copy\" menu command) but\nputting the currently selected text into the PRIMARY selection automatically,\nwithout overwriting the normal clipboard contents with the currently selected\ntext on the other platforms.","ref":"wxClipboard.html#usePrimarySelection/2"},{"type":"type","title":"wxClipboard.wxClipboard/0","doc":"","ref":"wxClipboard.html#t:wxClipboard/0"},{"type":"module","title":"wxClipboardTextEvent","doc":"Functions for wxClipboardTextEvent class\n\nThis class represents the events generated by a control (typically a\n`m:wxTextCtrl` but other windows can generate these events as well) when its\ncontent gets copied or cut to, or pasted from the clipboard.\n\nThere are three types of corresponding events `wxEVT_TEXT_COPY`,\n`wxEVT_TEXT_CUT` and `wxEVT_TEXT_PASTE`.\n\nIf any of these events is processed (without being skipped) by an event handler,\nthe corresponding operation doesn't take place which allows preventing the text\nfrom being copied from or pasted to a control. It is also possible to examine\nthe clipboard contents in the PASTE event handler and transform it in some way\nbefore inserting in a control - for example, changing its case or removing\ninvalid characters.\n\nFinally notice that a CUT event is always preceded by the COPY event which makes\nit possible to only process the latter if it doesn't matter if the text was\ncopied or cut.\n\nNote: These events are currently only generated by `m:wxTextCtrl` in wxGTK and\nwxOSX but are also generated by `m:wxComboBox` without wxCB_READONLY style in\nwxMSW.\n\nSee: `m:wxClipboard`\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxClipboardTextEvent](https://docs.wxwidgets.org/3.1/classwx_clipboard_text_event.html)","ref":"wxClipboardTextEvent.html"},{"type":"module","title":"Events - wxClipboardTextEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxClipboardTextEventType`](`t:wxClipboardTextEventType/0`) to subscribe to\nevents of this type.","ref":"wxClipboardTextEvent.html#module-events"},{"type":"type","title":"wxClipboardTextEvent.wxClipboardText/0","doc":"","ref":"wxClipboardTextEvent.html#t:wxClipboardText/0"},{"type":"type","title":"wxClipboardTextEvent.wxClipboardTextEvent/0","doc":"","ref":"wxClipboardTextEvent.html#t:wxClipboardTextEvent/0"},{"type":"type","title":"wxClipboardTextEvent.wxClipboardTextEventType/0","doc":"","ref":"wxClipboardTextEvent.html#t:wxClipboardTextEventType/0"},{"type":"module","title":"wxCloseEvent","doc":"Functions for wxCloseEvent class\n\nThis event class contains information about window and session close events.\n\nThe handler function for EVT_CLOSE is called when the user has tried to close a\na frame or dialog box using the window manager (X) or system menu (Windows). It\ncan also be invoked by the application itself programmatically, for example by\ncalling the `wxWindow:close/2` function.\n\nYou should check whether the application is forcing the deletion of the window\nusing `canVeto/1`. If this is false, you `must` destroy the window using\n`wxWindow:'Destroy'/1`.\n\nIf the return value is true, it is up to you whether you respond by destroying\nthe window.\n\nIf you don't destroy the window, you should call `veto/2` to let the calling\ncode know that you did not destroy the window. This allows the\n`wxWindow:close/2` function to return true or false depending on whether the\nclose instruction was honoured or not.\n\nExample of a `m:wxCloseEvent` handler:\n\nThe EVT_END_SESSION event is slightly different as it is sent by the system when\nthe user session is ending (e.g. because of log out or shutdown) and so all\nwindows are being forcefully closed. At least under MSW, after the handler for\nthis event is executed the program is simply killed by the system. Because of\nthis, the default handler for this event provided by wxWidgets calls all the\nusual cleanup code (including `wxApp::OnExit()` (not implemented in wx)) so that\nit could still be executed and exit()s the process itself, without waiting for\nbeing killed. If this behaviour is for some reason undesirable, make sure that\nyou define a handler for this event in your wxApp-derived class and do not call\n`event.Skip()` in it (but be aware that the system will still kill your\napplication).\n\nSee: `wxWindow:close/2`,\n[Overview windowdeletion](https://docs.wxwidgets.org/3.1/overview_windowdeletion.html#overview_windowdeletion)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxCloseEvent](https://docs.wxwidgets.org/3.1/classwx_close_event.html)","ref":"wxCloseEvent.html"},{"type":"module","title":"Events - wxCloseEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxCloseEventType`](`t:wxCloseEventType/0`)\nto subscribe to events of this type.","ref":"wxCloseEvent.html#module-events"},{"type":"function","title":"wxCloseEvent.canVeto/1","doc":"Returns true if you can veto a system shutdown or a window close event.\n\nVetoing a window close event is not possible if the calling code wishes to force\nthe application to exit, and so this function must be called to check this.","ref":"wxCloseEvent.html#canVeto/1"},{"type":"function","title":"wxCloseEvent.getLoggingOff/1","doc":"Returns true if the user is just logging off or false if the system is shutting\ndown.\n\nThis method can only be called for end session and query end session events, it\ndoesn't make sense for close window event.","ref":"wxCloseEvent.html#getLoggingOff/1"},{"type":"function","title":"wxCloseEvent.setCanVeto/2","doc":"Sets the 'can veto' flag.","ref":"wxCloseEvent.html#setCanVeto/2"},{"type":"function","title":"wxCloseEvent.setLoggingOff/2","doc":"Sets the 'logging off' flag.","ref":"wxCloseEvent.html#setLoggingOff/2"},{"type":"function","title":"wxCloseEvent.veto/1","doc":"","ref":"wxCloseEvent.html#veto/1"},{"type":"function","title":"wxCloseEvent.veto/2","doc":"Call this from your event handler to veto a system shutdown or to signal to the\ncalling application that a window close did not happen.\n\nYou can only veto a shutdown if `canVeto/1` returns true.","ref":"wxCloseEvent.html#veto/2"},{"type":"type","title":"wxCloseEvent.wxClose/0","doc":"","ref":"wxCloseEvent.html#t:wxClose/0"},{"type":"type","title":"wxCloseEvent.wxCloseEvent/0","doc":"","ref":"wxCloseEvent.html#t:wxCloseEvent/0"},{"type":"type","title":"wxCloseEvent.wxCloseEventType/0","doc":"","ref":"wxCloseEvent.html#t:wxCloseEventType/0"},{"type":"module","title":"wxColourData","doc":"Functions for wxColourData class\n\nThis class holds a variety of information related to colour dialogs.\n\nSee: [`wx_color()`](`t:wx:wx_colour/0`), `m:wxColourDialog`,\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_colour)\n\nwxWidgets docs:\n[wxColourData](https://docs.wxwidgets.org/3.1/classwx_colour_data.html)","ref":"wxColourData.html"},{"type":"function","title":"wxColourData.destroy/1","doc":"Destructor.","ref":"wxColourData.html#destroy/1"},{"type":"function","title":"wxColourData.getChooseFull/1","doc":"Under Windows, determines whether the Windows colour dialog will display the\nfull dialog with custom colour selection controls.\n\nHas no meaning under other platforms.\n\nThe default value is true.","ref":"wxColourData.html#getChooseFull/1"},{"type":"function","title":"wxColourData.getColour/1","doc":"Gets the current colour associated with the colour dialog.\n\nThe default colour is black.","ref":"wxColourData.html#getColour/1"},{"type":"function","title":"wxColourData.getCustomColour/2","doc":"Returns custom colours associated with the colour dialog.","ref":"wxColourData.html#getCustomColour/2"},{"type":"function","title":"wxColourData.new/0","doc":"Constructor.\n\nInitializes the custom colours to `wxNullColour`, the `data` colour setting to\nblack, and the `choose` full setting to true.","ref":"wxColourData.html#new/0"},{"type":"function","title":"wxColourData.setChooseFull/2","doc":"Under Windows, tells the Windows colour dialog to display the full dialog with\ncustom colour selection controls.\n\nUnder other platforms, has no effect.\n\nThe default value is true.","ref":"wxColourData.html#setChooseFull/2"},{"type":"function","title":"wxColourData.setColour/2","doc":"Sets the default colour for the colour dialog.\n\nThe default colour is black.","ref":"wxColourData.html#setColour/2"},{"type":"function","title":"wxColourData.setCustomColour/3","doc":"Sets custom colours for the colour dialog.","ref":"wxColourData.html#setCustomColour/3"},{"type":"type","title":"wxColourData.wxColourData/0","doc":"","ref":"wxColourData.html#t:wxColourData/0"},{"type":"module","title":"wxColourDialog","doc":"Functions for wxColourDialog class\n\nThis class represents the colour chooser dialog.\n\nStarting from wxWidgets 3.1.3 and currently in the MSW port only, this dialog\ngenerates wxEVT_COLOUR_CHANGED events while it is being shown, i.e. from inside\nits `wxDialog:showModal/1` method, that notify the program about the change of\nthe currently selected colour and allow it to e.g. preview the effect of\nselecting this colour. Note that if you react to this event, you should also\ncorrectly revert to the previously selected colour if the dialog is cancelled by\nthe user.\n\nExample of using this class with dynamic feedback for the selected colour:\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_colour),\n[`wx_color()`](`t:wx:wx_colour/0`), `m:wxColourData`, `wxColourDialogEvent` (not\nimplemented in wx), ?wxGetColourFromUser()\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxColourDialog](https://docs.wxwidgets.org/3.1/classwx_colour_dialog.html)","ref":"wxColourDialog.html"},{"type":"function","title":"wxColourDialog.create/2","doc":"","ref":"wxColourDialog.html#create/2"},{"type":"function","title":"wxColourDialog.create/3","doc":"Same as `new/2`.","ref":"wxColourDialog.html#create/3"},{"type":"function","title":"wxColourDialog.destroy/1","doc":"Destructor.","ref":"wxColourDialog.html#destroy/1"},{"type":"function","title":"wxColourDialog.getColourData/1","doc":"Returns the colour data associated with the colour dialog.","ref":"wxColourDialog.html#getColourData/1"},{"type":"function","title":"wxColourDialog.new/0","doc":"","ref":"wxColourDialog.html#new/0"},{"type":"function","title":"wxColourDialog.new/1","doc":"","ref":"wxColourDialog.html#new/1"},{"type":"function","title":"wxColourDialog.new/2","doc":"Constructor.\n\nPass a parent window, and optionally a pointer to a block of colour data, which\nwill be copied to the colour dialog's colour data.\n\nCustom colours from colour data object will be used in the dialog's colour\npalette. Invalid entries in custom colours list will be ignored on some\nplatforms(GTK) or replaced with white colour on platforms where custom colours\npalette has fixed size (MSW).\n\nSee: `m:wxColourData`","ref":"wxColourDialog.html#new/2"},{"type":"type","title":"wxColourDialog.wxColourDialog/0","doc":"","ref":"wxColourDialog.html#t:wxColourDialog/0"},{"type":"module","title":"wxColourPickerCtrl","doc":"Functions for wxColourPickerCtrl class\n\nThis control allows the user to select a colour. The generic implementation is a\nbutton which brings up a `m:wxColourDialog` when clicked. Native implementation\nmay differ but this is usually a (small) widget which give access to the\ncolour-chooser dialog. It is only available if `wxUSE_COLOURPICKERCTRL` is set\nto 1 (the default).\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxColourDialog`, `m:wxColourPickerEvent`\n\nThis class is derived (and can use functions) from: `m:wxPickerBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxColourPickerCtrl](https://docs.wxwidgets.org/3.1/classwx_colour_picker_ctrl.html)","ref":"wxColourPickerCtrl.html"},{"type":"module","title":"Events - wxColourPickerCtrl","doc":"Event types emitted from this class:\n[`command_colourpicker_changed`](`m:wxColourPickerEvent`)","ref":"wxColourPickerCtrl.html#module-events"},{"type":"function","title":"wxColourPickerCtrl.create/3","doc":"","ref":"wxColourPickerCtrl.html#create/3"},{"type":"function","title":"wxColourPickerCtrl.create/4","doc":"Creates a colour picker with the given arguments.\n\nReturn: true if the control was successfully created or false if creation\nfailed.","ref":"wxColourPickerCtrl.html#create/4"},{"type":"function","title":"wxColourPickerCtrl.destroy/1","doc":"Destroys the object.","ref":"wxColourPickerCtrl.html#destroy/1"},{"type":"function","title":"wxColourPickerCtrl.getColour/1","doc":"Returns the currently selected colour.","ref":"wxColourPickerCtrl.html#getColour/1"},{"type":"function","title":"wxColourPickerCtrl.new/0","doc":"","ref":"wxColourPickerCtrl.html#new/0"},{"type":"function","title":"wxColourPickerCtrl.new/2","doc":"","ref":"wxColourPickerCtrl.html#new/2"},{"type":"function","title":"wxColourPickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxColourPickerCtrl.html#new/3"},{"type":"function","title":"wxColourPickerCtrl.setColour/2","doc":"Sets the currently selected colour.\n\nSee `wxColour::Set()` (not implemented in wx).","ref":"wxColourPickerCtrl.html#setColour/2"},{"type":"type","title":"wxColourPickerCtrl.wxColourPickerCtrl/0","doc":"","ref":"wxColourPickerCtrl.html#t:wxColourPickerCtrl/0"},{"type":"module","title":"wxColourPickerEvent","doc":"Functions for wxColourPickerEvent class\n\nThis event class is used for the events generated by `m:wxColourPickerCtrl`.\n\nSee: `m:wxColourPickerCtrl`\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxColourPickerEvent](https://docs.wxwidgets.org/3.1/classwx_colour_picker_event.html)","ref":"wxColourPickerEvent.html"},{"type":"module","title":"Events - wxColourPickerEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxColourPickerEventType`](`t:wxColourPickerEventType/0`) to subscribe to\nevents of this type.","ref":"wxColourPickerEvent.html#module-events"},{"type":"function","title":"wxColourPickerEvent.getColour/1","doc":"Retrieve the colour the user has just selected.","ref":"wxColourPickerEvent.html#getColour/1"},{"type":"type","title":"wxColourPickerEvent.wxColourPicker/0","doc":"","ref":"wxColourPickerEvent.html#t:wxColourPicker/0"},{"type":"type","title":"wxColourPickerEvent.wxColourPickerEvent/0","doc":"","ref":"wxColourPickerEvent.html#t:wxColourPickerEvent/0"},{"type":"type","title":"wxColourPickerEvent.wxColourPickerEventType/0","doc":"","ref":"wxColourPickerEvent.html#t:wxColourPickerEventType/0"},{"type":"module","title":"wxComboBox","doc":"Functions for wxComboBox class\n\nA combobox is like a combination of an edit control and a listbox.\n\nIt can be displayed as static list with editable or read-only text field; or a\ndrop-down list with text field; or a drop-down list without a text field\ndepending on the platform and presence of wxCB_READONLY style.\n\nA combobox permits a single selection only. Combobox items are numbered from\nzero.\n\nIf you need a customized combobox, have a look at `wxComboCtrl` (not implemented\nin wx), `wxOwnerDrawnComboBox` (not implemented in wx), `wxComboPopup` (not\nimplemented in wx) and the ready-to-use `wxBitmapComboBox` (not implemented in\nwx).\n\nPlease refer to `wxTextEntry` (not implemented in wx) documentation for the\ndescription of methods operating with the text entry part of the combobox and to\n`wxItemContainer` (not implemented in wx) for the methods operating with the\nlist of strings. Notice that at least under MSW `m:wxComboBox` doesn't behave\ncorrectly if it contains strings differing in case only so portable programs\nshould avoid adding such strings to this control.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxListBox`, `m:wxTextCtrl`, `m:wxChoice`, `m:wxCommandEvent`\n\nThis class is derived (and can use functions) from: `m:wxControlWithItems`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxComboBox](https://docs.wxwidgets.org/3.1/classwx_combo_box.html)","ref":"wxComboBox.html"},{"type":"module","title":"Events - wxComboBox","doc":"Event types emitted from this class:\n[`command_combobox_selected`](`m:wxCommandEvent`),\n[`command_text_updated`](`m:wxCommandEvent`),\n[`command_text_enter`](`m:wxCommandEvent`),\n[`combobox_dropdown`](`m:wxCommandEvent`),\n[`combobox_closeup`](`m:wxCommandEvent`)","ref":"wxComboBox.html#module-events"},{"type":"function","title":"wxComboBox.canCopy/1","doc":"Returns true if the selection can be copied to the clipboard.","ref":"wxComboBox.html#canCopy/1"},{"type":"function","title":"wxComboBox.canCut/1","doc":"Returns true if the selection can be cut to the clipboard.","ref":"wxComboBox.html#canCut/1"},{"type":"function","title":"wxComboBox.canPaste/1","doc":"Returns true if the contents of the clipboard can be pasted into the text\ncontrol.\n\nOn some platforms (Motif, GTK) this is an approximation and returns true if the\ncontrol is editable, false otherwise.","ref":"wxComboBox.html#canPaste/1"},{"type":"function","title":"wxComboBox.canRedo/1","doc":"Returns true if there is a redo facility available and the last operation can be\nredone.","ref":"wxComboBox.html#canRedo/1"},{"type":"function","title":"wxComboBox.canUndo/1","doc":"Returns true if there is an undo facility available and the last operation can\nbe undone.","ref":"wxComboBox.html#canUndo/1"},{"type":"function","title":"wxComboBox.copy/1","doc":"Copies the selected text to the clipboard.","ref":"wxComboBox.html#copy/1"},{"type":"function","title":"wxComboBox.create/7","doc":"","ref":"wxComboBox.html#create/7"},{"type":"function","title":"wxComboBox.create/8","doc":"","ref":"wxComboBox.html#create/8"},{"type":"function","title":"wxComboBox.cut/1","doc":"Copies the selected text to the clipboard and removes it from the control.","ref":"wxComboBox.html#cut/1"},{"type":"function","title":"wxComboBox.destroy/1","doc":"Destructor, destroying the combobox.","ref":"wxComboBox.html#destroy/1"},{"type":"function","title":"wxComboBox.getInsertionPoint/1","doc":"Same as `wxTextCtrl:getInsertionPoint/1`.\n\nNote: Under wxMSW, this function always returns 0 if the combobox doesn't have\nthe focus.","ref":"wxComboBox.html#getInsertionPoint/1"},{"type":"function","title":"wxComboBox.getLastPosition/1","doc":"Returns the zero based index of the last position in the text control, which is\nequal to the number of characters in the control.","ref":"wxComboBox.html#getLastPosition/1"},{"type":"function","title":"wxComboBox.getValue/1","doc":"Gets the contents of the control.\n\nNotice that for a multiline text control, the lines will be separated by\n(Unix-style) `\\n` characters, even under Windows where they are separated by a\n`\\r\\n` sequence in the native control.","ref":"wxComboBox.html#getValue/1"},{"type":"function","title":"wxComboBox.new/0","doc":"Default constructor.","ref":"wxComboBox.html#new/0"},{"type":"function","title":"wxComboBox.new/2","doc":"","ref":"wxComboBox.html#new/2"},{"type":"function","title":"wxComboBox.new/3","doc":"Constructor, creating and showing a combobox.\n\nSee: `create/8`, `wxValidator` (not implemented in wx)","ref":"wxComboBox.html#new/3"},{"type":"function","title":"wxComboBox.paste/1","doc":"Pastes text from the clipboard to the text item.","ref":"wxComboBox.html#paste/1"},{"type":"function","title":"wxComboBox.redo/1","doc":"If there is a redo facility and the last operation can be redone, redoes the\nlast operation.\n\nDoes nothing if there is no redo facility.","ref":"wxComboBox.html#redo/1"},{"type":"function","title":"wxComboBox.remove/3","doc":"Removes the text starting at the first given position up to (but not including)\nthe character at the last position.\n\nThis function puts the current insertion point position at `to` as a side\neffect.","ref":"wxComboBox.html#remove/3"},{"type":"function","title":"wxComboBox.replace/4","doc":"Replaces the text starting at the first position up to (but not including) the\ncharacter at the last position with the given text.\n\nThis function puts the current insertion point position at `to` as a side\neffect.","ref":"wxComboBox.html#replace/4"},{"type":"function","title":"wxComboBox.setInsertionPoint/2","doc":"Sets the insertion point at the given position.","ref":"wxComboBox.html#setInsertionPoint/2"},{"type":"function","title":"wxComboBox.setInsertionPointEnd/1","doc":"Sets the insertion point at the end of the text control.\n\nThis is equivalent to calling `setInsertionPoint/2` with `getLastPosition/1`\nargument.","ref":"wxComboBox.html#setInsertionPointEnd/1"},{"type":"function","title":"wxComboBox.setSelection/2","doc":"Sets the selection to the given item `n` or removes the selection entirely if\n`n` == `wxNOT_FOUND`.\n\nNote that this does not cause any command events to be emitted nor does it\ndeselect any other items in the controls which support multiple selections.\n\nSee: `wxControlWithItems:setString/3`, `wxControlWithItems:setStringSelection/2`","ref":"wxComboBox.html#setSelection/2"},{"type":"function","title":"wxComboBox.setSelection/3","doc":"Same as `wxTextCtrl:setSelection/3`.","ref":"wxComboBox.html#setSelection/3"},{"type":"function","title":"wxComboBox.setValue/2","doc":"Sets the text for the combobox text field.\n\nFor normal, editable comboboxes with a text entry field calling this method will\ngenerate a `wxEVT_TEXT` event, consistently with `wxTextCtrl:setValue/2`\nbehaviour, use `wxTextCtrl:changeValue/2` if this is undesirable.\n\nFor controls with `wxCB_READONLY` style the method behaves somewhat differently:\nthe string must be in the combobox choices list (the check for this is\ncase-insensitive) and `wxEVT_TEXT` is `not` generated in this case.","ref":"wxComboBox.html#setValue/2"},{"type":"function","title":"wxComboBox.undo/1","doc":"If there is an undo facility and the last operation can be undone, undoes the\nlast operation.\n\nDoes nothing if there is no undo facility.","ref":"wxComboBox.html#undo/1"},{"type":"type","title":"wxComboBox.wxComboBox/0","doc":"","ref":"wxComboBox.html#t:wxComboBox/0"},{"type":"module","title":"wxCommandEvent","doc":"Functions for wxCommandEvent class\n\nThis event class contains information about command events, which originate from\na variety of simple controls.\n\nNote that wxCommandEvents and wxCommandEvent-derived event classes by default\nand unlike other wxEvent-derived classes propagate upward from the source window\n(the window which emits the event) up to the first parent which processes the\nevent. Be sure to read overview_events_propagation.\n\nMore complex controls, such as `m:wxTreeCtrl`, have separate command event\nclasses.\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxCommandEvent](https://docs.wxwidgets.org/3.1/classwx_command_event.html)","ref":"wxCommandEvent.html"},{"type":"module","title":"Events - wxCommandEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxCommandEventType`](`t:wxCommandEventType/0`) to subscribe to events of this\ntype.","ref":"wxCommandEvent.html#module-events"},{"type":"function","title":"wxCommandEvent.getClientData/1","doc":"Returns client object pointer for a listbox or choice selection event (not valid\nfor a deselection).","ref":"wxCommandEvent.html#getClientData/1"},{"type":"function","title":"wxCommandEvent.getExtraLong/1","doc":"Returns extra information dependent on the event objects type.\n\nIf the event comes from a listbox selection, it is a boolean determining whether\nthe event was a selection (true) or a deselection (false). A listbox deselection\nonly occurs for multiple-selection boxes, and in this case the index and string\nvalues are indeterminate and the listbox must be examined by the application.","ref":"wxCommandEvent.html#getExtraLong/1"},{"type":"function","title":"wxCommandEvent.getInt/1","doc":"Returns the integer identifier corresponding to a listbox, choice or radiobox\nselection (only if the event was a selection, not a deselection), or a boolean\nvalue representing the value of a checkbox.\n\nFor a menu item, this method returns -1 if the item is not checkable or a\nboolean value (true or false) for checkable items indicating the new state of\nthe item.","ref":"wxCommandEvent.html#getInt/1"},{"type":"function","title":"wxCommandEvent.getSelection/1","doc":"Returns item index for a listbox or choice selection event (not valid for a\ndeselection).","ref":"wxCommandEvent.html#getSelection/1"},{"type":"function","title":"wxCommandEvent.getString/1","doc":"Returns item string for a listbox or choice selection event.\n\nIf one or several items have been deselected, returns the index of the first\ndeselected item. If some items have been selected and others deselected at the\nsame time, it will return the index of the first selected item.","ref":"wxCommandEvent.html#getString/1"},{"type":"function","title":"wxCommandEvent.isChecked/1","doc":"This method can be used with checkbox and menu events: for the checkboxes, the\nmethod returns true for a selection event and false for a deselection one.\n\nFor the menu events, this method indicates if the menu item just has become\nchecked or unchecked (and thus only makes sense for checkable menu items).\n\nNotice that this method cannot be used with `m:wxCheckListBox` currently.","ref":"wxCommandEvent.html#isChecked/1"},{"type":"function","title":"wxCommandEvent.isSelection/1","doc":"For a listbox or similar event, returns true if it is a selection, false if it\nis a deselection.\n\nIf some items have been selected and others deselected at the same time, it will\nreturn true.","ref":"wxCommandEvent.html#isSelection/1"},{"type":"function","title":"wxCommandEvent.setInt/2","doc":"Sets the `m_commandInt` member.","ref":"wxCommandEvent.html#setInt/2"},{"type":"function","title":"wxCommandEvent.setString/2","doc":"Sets the `m_commandString` member.","ref":"wxCommandEvent.html#setString/2"},{"type":"type","title":"wxCommandEvent.wxCommand/0","doc":"","ref":"wxCommandEvent.html#t:wxCommand/0"},{"type":"type","title":"wxCommandEvent.wxCommandEvent/0","doc":"","ref":"wxCommandEvent.html#t:wxCommandEvent/0"},{"type":"type","title":"wxCommandEvent.wxCommandEventType/0","doc":"","ref":"wxCommandEvent.html#t:wxCommandEventType/0"},{"type":"module","title":"wxContextMenuEvent","doc":"Functions for wxContextMenuEvent class\n\nThis class is used for context menu events, sent to give the application a\nchance to show a context (popup) menu for a `m:wxWindow`.\n\nNote that if `getPosition/1` returns wxDefaultPosition, this means that the\nevent originated from a keyboard context button event, and you should compute a\nsuitable position yourself, for example by calling `wx_misc:getMousePosition/0`.\n\nNotice that the exact sequence of mouse events is different across the\nplatforms. For example, under MSW the context menu event is generated after\n`EVT_RIGHT_UP` event and only if it was not handled but under GTK the context\nmenu event is generated after `EVT_RIGHT_DOWN` event. This is correct in the\nsense that it ensures that the context menu is shown according to the current\nplatform UI conventions and also means that you must not handle (or call\n`wxEvent:skip/2` in your handler if you do have one) neither right mouse down\nnor right mouse up event if you plan on handling `EVT_CONTEXT_MENU` event.\n\nSee: `m:wxCommandEvent`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxContextMenuEvent](https://docs.wxwidgets.org/3.1/classwx_context_menu_event.html)","ref":"wxContextMenuEvent.html"},{"type":"module","title":"Events - wxContextMenuEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxContextMenuEventType`](`t:wxContextMenuEventType/0`) to subscribe to events\nof this type.","ref":"wxContextMenuEvent.html#module-events"},{"type":"function","title":"wxContextMenuEvent.getPosition/1","doc":"Returns the position in screen coordinates at which the menu should be shown.\n\nUse `wxWindow:screenToClient/2` to convert to client coordinates.\n\nYou can also omit a position from `wxWindow:popupMenu/4` in order to use the\ncurrent mouse pointer position.\n\nIf the event originated from a keyboard event, the value returned from this\nfunction will be wxDefaultPosition.","ref":"wxContextMenuEvent.html#getPosition/1"},{"type":"function","title":"wxContextMenuEvent.setPosition/2","doc":"Sets the position at which the menu should be shown.","ref":"wxContextMenuEvent.html#setPosition/2"},{"type":"type","title":"wxContextMenuEvent.wxContextMenu/0","doc":"","ref":"wxContextMenuEvent.html#t:wxContextMenu/0"},{"type":"type","title":"wxContextMenuEvent.wxContextMenuEvent/0","doc":"","ref":"wxContextMenuEvent.html#t:wxContextMenuEvent/0"},{"type":"type","title":"wxContextMenuEvent.wxContextMenuEventType/0","doc":"","ref":"wxContextMenuEvent.html#t:wxContextMenuEventType/0"},{"type":"module","title":"wxControl","doc":"Functions for wxControl class\n\nThis is the base class for a control or \"widget\".\n\nA control is generally a small window which processes user input and/or displays\none or more item of data.\n\nSee: `wxValidator` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs: [wxControl](https://docs.wxwidgets.org/3.1/classwx_control.html)","ref":"wxControl.html"},{"type":"module","title":"Events - wxControl","doc":"Event types emitted from this class:\n[`command_text_copy`](`m:wxClipboardTextEvent`),\n[`command_text_cut`](`m:wxClipboardTextEvent`),\n[`command_text_paste`](`m:wxClipboardTextEvent`)","ref":"wxControl.html#module-events"},{"type":"function","title":"wxControl.getLabel/1","doc":"Returns the control's label, as it was passed to `setLabel/2`.\n\nNote that the returned string may contains mnemonics (\"&\" characters) if they\nwere passed to the `setLabel/2` function; use `GetLabelText()` (not implemented\nin wx) if they are undesired.\n\nAlso note that the returned string is always the string which was passed to\n`setLabel/2` but may be different from the string passed to `SetLabelText()`\n(not implemented in wx) (since this last one escapes mnemonic characters).","ref":"wxControl.html#getLabel/1"},{"type":"function","title":"wxControl.setLabel/2","doc":"Sets the control's label.\n\nAll \"&\" characters in the `label` are special and indicate that the following\ncharacter is a `mnemonic` for this control and can be used to activate it from\nthe keyboard (typically by using `Alt` key in combination with it). To insert a\nliteral ampersand character, you need to double it, i.e. use \"&&\". If this\nbehaviour is undesirable, use `SetLabelText()` (not implemented in wx) instead.","ref":"wxControl.html#setLabel/2"},{"type":"type","title":"wxControl.wxControl/0","doc":"","ref":"wxControl.html#t:wxControl/0"},{"type":"module","title":"wxControlWithItems","doc":"Functions for wxControlWithItems class\n\nThis is convenience class that derives from both `m:wxControl` and\n`wxItemContainer` (not implemented in wx). It is used as basis for some\nwxWidgets controls (`m:wxChoice` and `m:wxListBox`).\n\nSee: `wxItemContainer` (not implemented in wx), `wxItemContainerImmutable` (not\nimplemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxControlWithItems](https://docs.wxwidgets.org/3.1/classwx_control_with_items.html)","ref":"wxControlWithItems.html"},{"type":"function","title":"wxControlWithItems.append/2","doc":"Appends item into the control.\n\nReturn: The return value is the index of the newly inserted item. Note that this\nmay be different from the last one if the control is sorted (e.g. has\n`wxLB_SORT` or `wxCB_SORT` style).","ref":"wxControlWithItems.html#append/2"},{"type":"function","title":"wxControlWithItems.append/3","doc":"Appends item into the control.\n\nReturn: The return value is the index of the newly inserted item. Note that this\nmay be different from the last one if the control is sorted (e.g. has\n`wxLB_SORT` or `wxCB_SORT` style).","ref":"wxControlWithItems.html#append/3"},{"type":"function","title":"wxControlWithItems.appendStrings/2","doc":"Appends several items at once into the control.\n\nNotice that calling this method is usually much faster than appending them one\nby one if you need to add a lot of items.","ref":"wxControlWithItems.html#appendStrings/2"},{"type":"function","title":"wxControlWithItems.appendStrings/3","doc":"Appends several items at once into the control.\n\nNotice that calling this method is usually much faster than appending them one\nby one if you need to add a lot of items.","ref":"wxControlWithItems.html#appendStrings/3"},{"type":"function","title":"wxControlWithItems.clear/1","doc":"Removes all items from the control.\n\n`clear/1` also deletes the client data of the existing items if it is owned by\nthe control.","ref":"wxControlWithItems.html#clear/1"},{"type":"function","title":"wxControlWithItems.delete/2","doc":"Deletes an item from the control.\n\nThe client data associated with the item will be also deleted if it is owned by\nthe control. Note that it is an error (signalled by an assert failure in debug\nbuilds) to remove an item with the index negative or greater or equal than the\nnumber of items in the control.\n\nIf there is a currently selected item below the item being deleted, i.e. if\n`getSelection/1` returns a valid index greater than or equal to `n`, the\nselection is invalidated when this function is called. However if the selected\nitem appears before the item being deleted, the selection is preserved\nunchanged.\n\nSee: `clear/1`","ref":"wxControlWithItems.html#delete/2"},{"type":"function","title":"wxControlWithItems.findString/2","doc":"","ref":"wxControlWithItems.html#findString/2"},{"type":"function","title":"wxControlWithItems.findString/3","doc":"Finds an item whose label matches the given string.\n\nReturn: The zero-based position of the item, or wxNOT_FOUND if the string was\nnot found.","ref":"wxControlWithItems.html#findString/3"},{"type":"function","title":"wxControlWithItems.getClientData/2","doc":"Returns a pointer to the client data associated with the given item (if any).\n\nIt is an error to call this function for a control which doesn't have typed\nclient data at all although it is OK to call it even if the given item doesn't\nhave any client data associated with it (but other items do).\n\nNotice that the returned pointer is still owned by the control and will be\ndeleted by it, use `DetachClientObject()` (not implemented in wx) if you want to\nremove the pointer from the control.\n\nReturn: A pointer to the client data, or NULL if not present.","ref":"wxControlWithItems.html#getClientData/2"},{"type":"function","title":"wxControlWithItems.getCount/1","doc":"Returns the number of items in the control.\n\nSee: `isEmpty/1`","ref":"wxControlWithItems.html#getCount/1"},{"type":"function","title":"wxControlWithItems.getSelection/1","doc":"Returns the index of the selected item or `wxNOT_FOUND` if no item is selected.\n\nReturn: The position of the current selection.\n\nRemark: This method can be used with single selection list boxes only, you\nshould use `wxListBox:getSelections/1` for the list boxes with wxLB_MULTIPLE\nstyle.\n\nSee: `setSelection/2`, `getStringSelection/1`","ref":"wxControlWithItems.html#getSelection/1"},{"type":"function","title":"wxControlWithItems.getString/2","doc":"Returns the label of the item with the given index.\n\nReturn: The label of the item or an empty string if the position was invalid.","ref":"wxControlWithItems.html#getString/2"},{"type":"function","title":"wxControlWithItems.getStringSelection/1","doc":"Returns the label of the selected item or an empty string if no item is\nselected.\n\nSee: `getSelection/1`","ref":"wxControlWithItems.html#getStringSelection/1"},{"type":"function","title":"wxControlWithItems.insert/3","doc":"Inserts item into the control.\n\nReturn: The return value is the index of the newly inserted item. If the\ninsertion failed for some reason, -1 is returned.","ref":"wxControlWithItems.html#insert/3"},{"type":"function","title":"wxControlWithItems.insert/4","doc":"Inserts item into the control.\n\nReturn: The return value is the index of the newly inserted item. If the\ninsertion failed for some reason, -1 is returned.","ref":"wxControlWithItems.html#insert/4"},{"type":"function","title":"wxControlWithItems.insertStrings/3","doc":"Inserts several items at once into the control.\n\nNotice that calling this method is usually much faster than inserting them one\nby one if you need to insert a lot of items.\n\nReturn: The return value is the index of the last inserted item. If the\ninsertion failed for some reason, -1 is returned.","ref":"wxControlWithItems.html#insertStrings/3"},{"type":"function","title":"wxControlWithItems.insertStrings/4","doc":"Inserts several items at once into the control.\n\nNotice that calling this method is usually much faster than inserting them one\nby one if you need to insert a lot of items.\n\nReturn: The return value is the index of the last inserted item. If the\ninsertion failed for some reason, -1 is returned.","ref":"wxControlWithItems.html#insertStrings/4"},{"type":"function","title":"wxControlWithItems.isEmpty/1","doc":"Returns true if the control is empty or false if it has some items.\n\nSee: `getCount/1`","ref":"wxControlWithItems.html#isEmpty/1"},{"type":"function","title":"wxControlWithItems.select/2","doc":"This is the same as `setSelection/2` and exists only because it is slightly more\nnatural for controls which support multiple selection.","ref":"wxControlWithItems.html#select/2"},{"type":"function","title":"wxControlWithItems.setClientData/3","doc":"Associates the given typed client data pointer with the given item: the `data`\nobject will be deleted when the item is deleted (either explicitly by using\n`delete/2` or implicitly when the control itself is destroyed).\n\nNote that it is an error to call this function if any untyped client data\npointers had been associated with the control items before.","ref":"wxControlWithItems.html#setClientData/3"},{"type":"function","title":"wxControlWithItems.setSelection/2","doc":"Sets the selection to the given item `n` or removes the selection entirely if\n`n` == `wxNOT_FOUND`.\n\nNote that this does not cause any command events to be emitted nor does it\ndeselect any other items in the controls which support multiple selections.\n\nSee: `setString/3`, `setStringSelection/2`","ref":"wxControlWithItems.html#setSelection/2"},{"type":"function","title":"wxControlWithItems.setString/3","doc":"Sets the label for the given item.","ref":"wxControlWithItems.html#setString/3"},{"type":"function","title":"wxControlWithItems.setStringSelection/2","doc":"Selects the item with the specified string in the control.\n\nThis method doesn't cause any command events to be emitted.\n\nNotice that this method is case-insensitive, i.e. the string is compared with\nall the elements of the control case-insensitively and the first matching entry\nis selected, even if it doesn't have exactly the same case as this string and\nthere is an exact match afterwards.\n\nReturn: true if the specified string has been selected, false if it wasn't found\nin the control.","ref":"wxControlWithItems.html#setStringSelection/2"},{"type":"type","title":"wxControlWithItems.wxControlWithItems/0","doc":"","ref":"wxControlWithItems.html#t:wxControlWithItems/0"},{"type":"module","title":"wxCursor","doc":"Functions for wxCursor class\n\nA cursor is a small bitmap usually used for denoting where the mouse pointer is,\nwith a picture that might indicate the interpretation of a mouse click. As with\nicons, cursors in X and MS Windows are created in a different manner. Therefore,\nseparate cursors will be created for the different environments.\nPlatform-specific methods for creating a `m:wxCursor` object are catered for,\nand this is an occasion where conditional compilation will probably be required\n(see `m:wxIcon` for an example).\n\nA single cursor object may be used in many windows (any subwindow type). The\nwxWidgets convention is to set the cursor for a window, as in X, rather than to\nset it globally as in MS Windows, although a global `wx_misc:setCursor/1`\nfunction is also available for MS Windows use.\n\nCreating a Custom Cursor\n\nThe following is an example of creating a cursor from 32x32 bitmap data\n(down_bits) and a mask (down_mask) where 1 is black and 0 is white for the bits,\nand 1 is opaque and 0 is transparent for the mask. It works on Windows and GTK+.\n\nPredefined objects (include wx.hrl):\n\nSee: `m:wxBitmap`, `m:wxIcon`, `wxWindow:setCursor/2`, `wx_misc:setCursor/1`,\n?wxStockCursor\n\nThis class is derived (and can use functions) from: `m:wxBitmap`\n\nwxWidgets docs: [wxCursor](https://docs.wxwidgets.org/3.1/classwx_cursor.html)","ref":"wxCursor.html"},{"type":"function","title":"wxCursor.destroy/1","doc":"Destroys the cursor.\n\nSee reference-counted object destruction for more info.\n\nA cursor can be reused for more than one window, and does not get destroyed when\nthe window is destroyed. wxWidgets destroys all cursors on application exit,\nalthough it is best to clean them up explicitly.","ref":"wxCursor.html#destroy/1"},{"type":"function","title":"wxCursor.isOk/1","doc":"Returns true if cursor data is present.","ref":"wxCursor.html#isOk/1"},{"type":"function","title":"wxCursor.new/0","doc":"Default constructor.","ref":"wxCursor.html#new/0"},{"type":"function","title":"wxCursor.new/1","doc":"Constructs a cursor using a cursor identifier.","ref":"wxCursor.html#new/1"},{"type":"function","title":"wxCursor.new/2","doc":"Constructs a cursor by passing a string resource name or filename.\n\nThe arguments `hotSpotX` and `hotSpotY` are only used when there's no hotspot\ninfo in the resource/image-file to load (e.g. when using `wxBITMAP_TYPE_ICO`\nunder wxMSW or `wxBITMAP_TYPE_XPM` under wxGTK).","ref":"wxCursor.html#new/2"},{"type":"function","title":"wxCursor.ok/1","doc":"See: `isOk/1`.","ref":"wxCursor.html#ok/1"},{"type":"type","title":"wxCursor.wxCursor/0","doc":"","ref":"wxCursor.html#t:wxCursor/0"},{"type":"module","title":"wxDC","doc":"Functions for wxDC class\n\nA `m:wxDC` is a `\"device context\"` onto which graphics and text can be drawn. It\nis intended to represent different output devices and offers a common abstract\nAPI for drawing on any of them.\n\nwxWidgets offers an alternative drawing API based on the modern drawing backends\nGDI+, CoreGraphics, Cairo and Direct2D. See `m:wxGraphicsContext`,\n`m:wxGraphicsRenderer` and related classes. There is also a `m:wxGCDC` linking\nthe APIs by offering the `m:wxDC` API on top of a `m:wxGraphicsContext`.\n\n`m:wxDC` is an abstract base class and cannot be created directly. Use\n`m:wxPaintDC`, `m:wxClientDC`, `m:wxWindowDC`, `m:wxScreenDC`, `m:wxMemoryDC` or\n`wxPrinterDC` (not implemented in wx). Notice that device contexts which are\nassociated with windows (i.e. `m:wxClientDC`, `m:wxWindowDC` and `m:wxPaintDC`)\nuse the window font and colours by default (starting with wxWidgets 2.9.0) but\nthe other device context classes use system-default values so you always must\nset the appropriate fonts and colours before using them.\n\nIn addition to the versions of the methods documented below, there are also\nversions which accept single \\{X,Y\\} parameter instead of the two wxCoord ones\nor \\{X,Y\\} and \\{Width,Height\\} instead of the four wxCoord parameters.\n\nBeginning with wxWidgets 2.9.0 the entire `m:wxDC` code has been reorganized.\nAll platform dependent code (actually all drawing code) has been moved into\nbackend classes which derive from a common wxDCImpl class. The user-visible\nclasses such as `m:wxClientDC` and `m:wxPaintDC` merely forward all calls to the\nbackend implementation.\n\nDevice and logical units\n\nIn the `m:wxDC` context there is a distinction between `logical` units and\n`device` units.\n\n`Device` units are the units native to the particular device; e.g. for a screen,\na device unit is a `pixel`. For a printer, the device unit is defined by the\nresolution of the printer (usually given in `DPI:` dot-per-inch).\n\nAll `m:wxDC` functions use instead `logical` units, unless where explicitly\nstated. Logical units are arbitrary units mapped to device units using the\ncurrent mapping mode (see `setMapMode/2`).\n\nThis mechanism allows reusing the same code which prints on e.g. a window on the\nscreen to print on e.g. a paper.\n\nSupport for Transparency / Alpha Channel\n\nIn general `m:wxDC` methods don't support alpha transparency and the alpha\ncomponent of [`wx_color()`](`t:wx:wx_colour/0`) is simply ignored and you need\nto use `m:wxGraphicsContext` for full transparency support. There are, however,\na few exceptions: first, under macOS and GTK+ 3 colours with alpha channel are\nsupported in all the normal wxDC-derived classes as they use\n`m:wxGraphicsContext` internally. Second, under all platforms `wxSVGFileDC` (not\nimplemented in wx) also fully supports alpha channel. In both of these cases the\ninstances of `m:wxPen` or `m:wxBrush` that are built from\n[`wx_color()`](`t:wx:wx_colour/0`) use the colour's alpha values when stroking\nor filling.\n\nSupport for Transformation Matrix\n\nOn some platforms (currently under MSW, GTK+ 3, macOS) `m:wxDC` has support for\napplying an arbitrary affine transformation matrix to its coordinate system\n(since 3.1.1 this feature is also supported by `m:wxGCDC` in all ports). Call\n`CanUseTransformMatrix()` (not implemented in wx) to check if this support is\navailable and then call `SetTransformMatrix()` (not implemented in wx) if it is.\nIf the transformation matrix is not supported, `SetTransformMatrix()` (not\nimplemented in wx) always simply returns `false` and doesn't do anything.\n\nThis feature is only available when `wxUSE_DC_TRANSFORM_MATRIX` build option is\nenabled.\n\nSee: [Overview dc](https://docs.wxwidgets.org/3.1/overview_dc.html#overview_dc),\n`m:wxGraphicsContext`, `wxDCFontChanger` (not implemented in wx),\n`wxDCTextColourChanger` (not implemented in wx), `wxDCPenChanger` (not\nimplemented in wx), `wxDCBrushChanger` (not implemented in wx), `wxDCClipper`\n(not implemented in wx)\n\nwxWidgets docs: [wxDC](https://docs.wxwidgets.org/3.1/classwx_d_c.html)","ref":"wxDC.html"},{"type":"function","title":"wxDC.blit/5","doc":"","ref":"wxDC.html#blit/5"},{"type":"function","title":"wxDC.blit/6","doc":"Copy from a source DC to this DC.\n\nWith this method you can specify the destination coordinates and the size of\narea to copy which will be the same for both the source and target DCs. If you\nneed to apply scaling while copying, use `StretchBlit()` (not implemented in\nwx).\n\nNotice that source DC coordinates `xsrc` and `ysrc` are interpreted using the\ncurrent source DC coordinate system, i.e. the scale, origin position and axis\ndirections are taken into account when transforming them to physical (pixel)\ncoordinates.\n\nRemark: There is partial support for `blit/6` in `m:wxPostScriptDC`, under X.\n\nSee: `StretchBlit()` (not implemented in wx), `m:wxMemoryDC`, `m:wxBitmap`,\n`m:wxMask`","ref":"wxDC.html#blit/6"},{"type":"function","title":"wxDC.calcBoundingBox/3","doc":"Adds the specified point to the bounding box which can be retrieved with\n`minX/1`, `maxX/1` and `minY/1`, `maxY/1` functions.\n\nSee: `resetBoundingBox/1`","ref":"wxDC.html#calcBoundingBox/3"},{"type":"function","title":"wxDC.clear/1","doc":"Clears the device context using the current background brush.\n\nNote that `setBackground/2` method must be used to set the brush used by\n`clear/1`, the brush used for filling the shapes set by `setBrush/2` is ignored\nby it.\n\nIf no background brush was set, solid white brush is used to clear the device\ncontext.","ref":"wxDC.html#clear/1"},{"type":"function","title":"wxDC.crossHair/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#crossHair/2"},{"type":"function","title":"wxDC.destroyClippingRegion/1","doc":"Destroys the current clipping region so that none of the DC is clipped.\n\nSee: `setClippingRegion/3`","ref":"wxDC.html#destroyClippingRegion/1"},{"type":"function","title":"wxDC.deviceToLogicalX/2","doc":"Convert `device` X coordinate to logical coordinate, using the current mapping\nmode, user scale factor, device origin and axis orientation.","ref":"wxDC.html#deviceToLogicalX/2"},{"type":"function","title":"wxDC.deviceToLogicalXRel/2","doc":"Convert `device` X coordinate to relative logical coordinate, using the current\nmapping mode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a width, for example.","ref":"wxDC.html#deviceToLogicalXRel/2"},{"type":"function","title":"wxDC.deviceToLogicalY/2","doc":"Converts `device` Y coordinate to logical coordinate, using the current mapping\nmode, user scale factor, device origin and axis orientation.","ref":"wxDC.html#deviceToLogicalY/2"},{"type":"function","title":"wxDC.deviceToLogicalYRel/2","doc":"Convert `device` Y coordinate to relative logical coordinate, using the current\nmapping mode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a height, for example.","ref":"wxDC.html#deviceToLogicalYRel/2"},{"type":"function","title":"wxDC.drawArc/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawArc/4"},{"type":"function","title":"wxDC.drawBitmap/3","doc":"","ref":"wxDC.html#drawBitmap/3"},{"type":"function","title":"wxDC.drawBitmap/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawBitmap/4"},{"type":"function","title":"wxDC.drawCheckMark/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawCheckMark/2"},{"type":"function","title":"wxDC.drawCircle/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawCircle/3"},{"type":"function","title":"wxDC.drawEllipse/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawEllipse/2"},{"type":"function","title":"wxDC.drawEllipse/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawEllipse/3"},{"type":"function","title":"wxDC.drawEllipticArc/5","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawEllipticArc/5"},{"type":"function","title":"wxDC.drawIcon/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawIcon/3"},{"type":"function","title":"wxDC.drawLabel/3","doc":"","ref":"wxDC.html#drawLabel/3"},{"type":"function","title":"wxDC.drawLabel/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawLabel/4"},{"type":"function","title":"wxDC.drawLine/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawLine/3"},{"type":"function","title":"wxDC.drawLines/2","doc":"","ref":"wxDC.html#drawLines/2"},{"type":"function","title":"wxDC.drawLines/3","doc":"Draws lines using an array of points of size `n` adding the optional offset\ncoordinate.\n\nThe current pen is used for drawing the lines.","ref":"wxDC.html#drawLines/3"},{"type":"function","title":"wxDC.drawPoint/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawPoint/2"},{"type":"function","title":"wxDC.drawPolygon/2","doc":"","ref":"wxDC.html#drawPolygon/2"},{"type":"function","title":"wxDC.drawPolygon/3","doc":"Draws a filled polygon using an array of points of size `n`, adding the optional\noffset coordinate.\n\nThe first and last points are automatically closed.\n\nThe last argument specifies the fill rule: `wxODDEVEN_RULE` (the default) or\n`wxWINDING_RULE`.\n\nThe current pen is used for drawing the outline, and the current brush for\nfilling the shape. Using a transparent brush suppresses filling.","ref":"wxDC.html#drawPolygon/3"},{"type":"function","title":"wxDC.drawRectangle/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawRectangle/2"},{"type":"function","title":"wxDC.drawRectangle/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawRectangle/3"},{"type":"function","title":"wxDC.drawRotatedText/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawRotatedText/4"},{"type":"function","title":"wxDC.drawRoundedRectangle/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawRoundedRectangle/3"},{"type":"function","title":"wxDC.drawRoundedRectangle/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawRoundedRectangle/4"},{"type":"function","title":"wxDC.drawText/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#drawText/3"},{"type":"function","title":"wxDC.endDoc/1","doc":"Ends a document (only relevant when outputting to a printer).","ref":"wxDC.html#endDoc/1"},{"type":"function","title":"wxDC.endPage/1","doc":"Ends a document page (only relevant when outputting to a printer).","ref":"wxDC.html#endPage/1"},{"type":"function","title":"wxDC.floodFill/3","doc":"","ref":"wxDC.html#floodFill/3"},{"type":"function","title":"wxDC.floodFill/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#floodFill/4"},{"type":"function","title":"wxDC.getBackground/1","doc":"Gets the brush used for painting the background.\n\nSee: `setBackground/2`","ref":"wxDC.html#getBackground/1"},{"type":"function","title":"wxDC.getBackgroundMode/1","doc":"Returns the current background mode: `wxPENSTYLE_SOLID` or\n`wxPENSTYLE_TRANSPARENT`.\n\nSee: `setBackgroundMode/2`","ref":"wxDC.html#getBackgroundMode/1"},{"type":"function","title":"wxDC.getBrush/1","doc":"Gets the current brush.\n\nSee: `setBrush/2`","ref":"wxDC.html#getBrush/1"},{"type":"function","title":"wxDC.getCharHeight/1","doc":"Gets the character height of the currently set font.","ref":"wxDC.html#getCharHeight/1"},{"type":"function","title":"wxDC.getCharWidth/1","doc":"Gets the average character width of the currently set font.","ref":"wxDC.html#getCharWidth/1"},{"type":"function","title":"wxDC.getClippingBox/1","doc":"`Gets the rectangle surrounding the current clipping region. If no clipping region is set this function returns the extent of the device context. @remarks Clipping region is given in logical coordinates. @param x If non- NULL , filled in with the logical horizontal coordinate of the top left corner of the clipping region if the function returns true or 0 otherwise. @param y If non- NULL , filled in with the logical vertical coordinate of the top left corner of the clipping region if the function returns true or 0 otherwise. @param width If non- NULL , filled in with the width of the clipping region if the function returns true or the device context width otherwise. @param height If non- NULL , filled in with the height of the clipping region if the function returns true or the device context height otherwise.`\n\nReturn: true if there is a clipping region or false if there is no active\nclipping region (note that this return value is available only since wxWidgets\n3.1.2, this function didn't return anything in the previous versions).","ref":"wxDC.html#getClippingBox/1"},{"type":"function","title":"wxDC.getFont/1","doc":"Gets the current font.\n\nNotice that even although each device context object has some default font after\ncreation, this method would return a ?wxNullFont initially and only after\ncalling `setFont/2` a valid font is returned.","ref":"wxDC.html#getFont/1"},{"type":"function","title":"wxDC.getLayoutDirection/1","doc":"Gets the current layout direction of the device context.\n\nOn platforms where RTL layout is supported, the return value will either be\n`wxLayout_LeftToRight` or `wxLayout_RightToLeft`. If RTL layout is not\nsupported, the return value will be `wxLayout_Default`.\n\nSee: `setLayoutDirection/2`","ref":"wxDC.html#getLayoutDirection/1"},{"type":"function","title":"wxDC.getLogicalFunction/1","doc":"Gets the current logical function.\n\nSee: `setLogicalFunction/2`","ref":"wxDC.html#getLogicalFunction/1"},{"type":"function","title":"wxDC.getMapMode/1","doc":"Gets the current mapping mode for the device context.\n\nSee: `setMapMode/2`","ref":"wxDC.html#getMapMode/1"},{"type":"function","title":"wxDC.getMultiLineTextExtent/2","doc":"Gets the dimensions of the string using the currently selected font.\n\n`string` is the text string to measure.\n\nReturn: The text extent as a \\{Width,Height\\} object.\n\nNote: This function works with both single-line and multi-line strings.\n\nSee: `m:wxFont`, `setFont/2`, `getPartialTextExtents/2`, `getTextExtent/3`","ref":"wxDC.html#getMultiLineTextExtent/2"},{"type":"function","title":"wxDC.getMultiLineTextExtent/3","doc":"Gets the dimensions of the string using the currently selected font.\n\n`string` is the text string to measure, `heightLine`, if non NULL, is where to\nstore the height of a single line.\n\nThe text extent is set in the given `w` and `h` pointers.\n\nIf the optional parameter `font` is specified and valid, then it is used for the\ntext extent calculation, otherwise the currently selected font is used.\n\nIf `string` is empty, its horizontal extent is 0 but, for convenience when using\nthis function for allocating enough space for a possibly multi-line string, its\nvertical extent is the same as the height of an empty line of text. Please note\nthat this behaviour differs from that of `getTextExtent/3`.\n\nNote: This function works with both single-line and multi-line strings.\n\nSee: `m:wxFont`, `setFont/2`, `getPartialTextExtents/2`, `getTextExtent/3`","ref":"wxDC.html#getMultiLineTextExtent/3"},{"type":"function","title":"wxDC.getPartialTextExtents/2","doc":"Fills the `widths` array with the widths from the beginning of `text` to the\ncorresponding character of `text`.\n\nThe generic version simply builds a running total of the widths of each\ncharacter using `getTextExtent/3`, however if the various platforms have a\nnative API function that is faster or more accurate than the generic\nimplementation then it should be used instead.\n\nSee: `getMultiLineTextExtent/3`, `getTextExtent/3`","ref":"wxDC.html#getPartialTextExtents/2"},{"type":"function","title":"wxDC.getPen/1","doc":"Gets the current pen.\n\nSee: `setPen/2`","ref":"wxDC.html#getPen/1"},{"type":"function","title":"wxDC.getPixel/2","doc":"Gets in `colour` the colour at the specified location.\n\nThis method isn't available for `m:wxPostScriptDC` or `wxMetafileDC` (not\nimplemented in wx) nor for any DC in wxOSX port and simply returns false there.\n\nNote: Setting a pixel can be done using `drawPoint/2`.\n\nNote: This method shouldn't be used with `m:wxPaintDC` as accessing the DC while\ndrawing can result in unexpected results, notably in wxGTK.","ref":"wxDC.html#getPixel/2"},{"type":"function","title":"wxDC.getPPI/1","doc":"Returns the resolution of the device in pixels per inch.","ref":"wxDC.html#getPPI/1"},{"type":"function","title":"wxDC.getSize/1","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#getSize/1"},{"type":"function","title":"wxDC.getSizeMM/1","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#getSizeMM/1"},{"type":"function","title":"wxDC.getTextBackground/1","doc":"Gets the current text background colour.\n\nSee: `setTextBackground/2`","ref":"wxDC.html#getTextBackground/1"},{"type":"function","title":"wxDC.getTextExtent/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#getTextExtent/2"},{"type":"function","title":"wxDC.getTextExtent/3","doc":"Gets the dimensions of the string using the currently selected font.\n\n`string` is the text string to measure, `descent` is the dimension from the\nbaseline of the font to the bottom of the descender, and `externalLeading` is\nany extra vertical space added to the font by the font designer (usually is\nzero).\n\nThe text extent is returned in `w` and `h` pointers or as a \\{Width,Height\\}\nobject depending on which version of this function is used.\n\nIf the optional parameter `font` is specified and valid, then it is used for the\ntext extent calculation. Otherwise the currently selected font is.\n\nIf `string` is empty, its extent is 0 in both directions, as expected.\n\nNote: This function only works with single-line strings.\n\nSee: `m:wxFont`, `setFont/2`, `getPartialTextExtents/2`,\n`getMultiLineTextExtent/3`","ref":"wxDC.html#getTextExtent/3"},{"type":"function","title":"wxDC.getTextForeground/1","doc":"Gets the current text foreground colour.\n\nSee: `setTextForeground/2`","ref":"wxDC.html#getTextForeground/1"},{"type":"function","title":"wxDC.getUserScale/1","doc":"Gets the current user scale factor.\n\nSee: `setUserScale/3`","ref":"wxDC.html#getUserScale/1"},{"type":"function","title":"wxDC.gradientFillConcentric/4","doc":"Fill the area specified by rect with a radial gradient, starting from\n`initialColour` at the centre of the circle and fading to `destColour` on the\ncircle outside.\n\nThe circle is placed at the centre of `rect`.\n\nNote: Currently this function is very slow, don't use it for real-time drawing.","ref":"wxDC.html#gradientFillConcentric/4"},{"type":"function","title":"wxDC.gradientFillConcentric/5","doc":"Fill the area specified by rect with a radial gradient, starting from\n`initialColour` at the centre of the circle and fading to `destColour` on the\ncircle outside.\n\n`circleCenter` are the relative coordinates of centre of the circle in the\nspecified `rect`.\n\nNote: Currently this function is very slow, don't use it for real-time drawing.","ref":"wxDC.html#gradientFillConcentric/5"},{"type":"function","title":"wxDC.gradientFillLinear/4","doc":"","ref":"wxDC.html#gradientFillLinear/4"},{"type":"function","title":"wxDC.gradientFillLinear/5","doc":"Fill the area specified by `rect` with a linear gradient, starting from\n`initialColour` and eventually fading to `destColour`.\n\nThe `nDirection` specifies the direction of the colour change, default is to use\n`initialColour` on the left part of the rectangle and `destColour` on the right\none.","ref":"wxDC.html#gradientFillLinear/5"},{"type":"function","title":"wxDC.isOk/1","doc":"Returns true if the DC is ok to use.","ref":"wxDC.html#isOk/1"},{"type":"function","title":"wxDC.logicalToDeviceX/2","doc":"Converts logical X coordinate to device coordinate, using the current mapping\nmode, user scale factor, device origin and axis orientation.","ref":"wxDC.html#logicalToDeviceX/2"},{"type":"function","title":"wxDC.logicalToDeviceXRel/2","doc":"Converts logical X coordinate to relative device coordinate, using the current\nmapping mode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a width, for example.","ref":"wxDC.html#logicalToDeviceXRel/2"},{"type":"function","title":"wxDC.logicalToDeviceY/2","doc":"Converts logical Y coordinate to device coordinate, using the current mapping\nmode, user scale factor, device origin and axis orientation.","ref":"wxDC.html#logicalToDeviceY/2"},{"type":"function","title":"wxDC.logicalToDeviceYRel/2","doc":"Converts logical Y coordinate to relative device coordinate, using the current\nmapping mode and user scale factor but ignoring the axis orientation.\n\nUse this for converting a height, for example.","ref":"wxDC.html#logicalToDeviceYRel/2"},{"type":"function","title":"wxDC.maxX/1","doc":"Gets the maximum horizontal extent used in drawing commands so far.","ref":"wxDC.html#maxX/1"},{"type":"function","title":"wxDC.maxY/1","doc":"Gets the maximum vertical extent used in drawing commands so far.","ref":"wxDC.html#maxY/1"},{"type":"function","title":"wxDC.minX/1","doc":"Gets the minimum horizontal extent used in drawing commands so far.","ref":"wxDC.html#minX/1"},{"type":"function","title":"wxDC.minY/1","doc":"Gets the minimum vertical extent used in drawing commands so far.","ref":"wxDC.html#minY/1"},{"type":"function","title":"wxDC.resetBoundingBox/1","doc":"Resets the bounding box: after a call to this function, the bounding box doesn't\ncontain anything.\n\nSee: `calcBoundingBox/3`","ref":"wxDC.html#resetBoundingBox/1"},{"type":"function","title":"wxDC.setAxisOrientation/3","doc":"Sets the x and y axis orientation (i.e. the direction from lowest to highest\nvalues on the axis).\n\nThe default orientation is x axis from left to right and y axis from top down.","ref":"wxDC.html#setAxisOrientation/3"},{"type":"function","title":"wxDC.setBackground/2","doc":"Sets the current background brush for the DC.","ref":"wxDC.html#setBackground/2"},{"type":"function","title":"wxDC.setBackgroundMode/2","doc":"`mode` may be one of `wxPENSTYLE_SOLID` and `wxPENSTYLE_TRANSPARENT`.\n\nThis setting determines whether text will be drawn with a background colour or\nnot.","ref":"wxDC.html#setBackgroundMode/2"},{"type":"function","title":"wxDC.setBrush/2","doc":"Sets the current brush for the DC.\n\nIf the argument is ?wxNullBrush (or another invalid brush; see\n`wxBrush:isOk/1`), the current brush is selected out of the device context\n(leaving `m:wxDC` without any valid brush), allowing the current brush to be\ndestroyed safely.\n\nSee: `m:wxBrush`, `m:wxMemoryDC`, (for the interpretation of colours when\ndrawing into a monochrome bitmap)","ref":"wxDC.html#setBrush/2"},{"type":"function","title":"wxDC.setClippingRegion/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#setClippingRegion/2"},{"type":"function","title":"wxDC.setClippingRegion/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxDC.html#setClippingRegion/3"},{"type":"function","title":"wxDC.setDeviceOrigin/3","doc":"Sets the device origin (i.e. the origin in pixels after scaling has been\napplied).\n\nThis function may be useful in Windows printing operations for placing a graphic\non a page.","ref":"wxDC.html#setDeviceOrigin/3"},{"type":"function","title":"wxDC.setFont/2","doc":"Sets the current font for the DC.\n\nIf the argument is ?wxNullFont (or another invalid font; see `wxFont:isOk/1`),\nthe current font is selected out of the device context (leaving `m:wxDC` without\nany valid font), allowing the current font to be destroyed safely.\n\nSee: `m:wxFont`","ref":"wxDC.html#setFont/2"},{"type":"function","title":"wxDC.setLayoutDirection/2","doc":"Sets the current layout direction for the device context.\n\nSee: `getLayoutDirection/1`","ref":"wxDC.html#setLayoutDirection/2"},{"type":"function","title":"wxDC.setLogicalFunction/2","doc":"Sets the current logical function for the device context.\n\nNote: This function is not fully supported in all ports, due to the limitations\nof the underlying drawing model. Notably, `wxINVERT` which was commonly used for\ndrawing rubber bands or other moving outlines in the past, is not, and will not,\nbe supported by wxGTK3 and wxMac. The suggested alternative is to draw\ntemporarily objects normally and refresh the (affected part of the) window to\nremove them later.\n\nIt determines how a `source` pixel (from a pen or brush colour, or source device\ncontext if using `blit/6`) combines with a `destination` pixel in the current\ndevice context. Text drawing is not affected by this function.\n\nSee ?wxRasterOperationMode enumeration values for more info.\n\nThe default is `wxCOPY`, which simply draws with the current colour. The others\ncombine the current colour and the background using a logical operation.","ref":"wxDC.html#setLogicalFunction/2"},{"type":"function","title":"wxDC.setMapMode/2","doc":"The mapping mode of the device context defines the unit of measurement used to\nconvert `logical` units to `device` units.\n\nNote that in X, text drawing isn't handled consistently with the mapping mode; a\nfont is always specified in point size. However, setting the user scale (see\n`setUserScale/3`) scales the text appropriately. In Windows, scalable TrueType\nfonts are always used; in X, results depend on availability of fonts, but\nusually a reasonable match is found.\n\nThe coordinate origin is always at the top left of the screen/printer.\n\nDrawing to a Windows printer device context uses the current mapping mode, but\nmapping mode is currently ignored for PostScript output.","ref":"wxDC.html#setMapMode/2"},{"type":"function","title":"wxDC.setPalette/2","doc":"If this is a window DC or memory DC, assigns the given palette to the window or\nbitmap associated with the DC.\n\nIf the argument is ?wxNullPalette, the current palette is selected out of the\ndevice context, and the original palette restored.\n\nSee: `m:wxPalette`","ref":"wxDC.html#setPalette/2"},{"type":"function","title":"wxDC.setPen/2","doc":"Sets the current pen for the DC.\n\nIf the argument is ?wxNullPen (or another invalid pen; see `wxPen:isOk/1`), the\ncurrent pen is selected out of the device context (leaving `m:wxDC` without any\nvalid pen), allowing the current pen to be destroyed safely.\n\nSee: `m:wxMemoryDC`, for the interpretation of colours when drawing into a\nmonochrome bitmap","ref":"wxDC.html#setPen/2"},{"type":"function","title":"wxDC.setTextBackground/2","doc":"Sets the current text background colour for the DC.","ref":"wxDC.html#setTextBackground/2"},{"type":"function","title":"wxDC.setTextForeground/2","doc":"Sets the current text foreground colour for the DC.\n\nSee: `m:wxMemoryDC`, for the interpretation of colours when drawing into a\nmonochrome bitmap","ref":"wxDC.html#setTextForeground/2"},{"type":"function","title":"wxDC.setUserScale/3","doc":"Sets the user scaling factor, useful for applications which require 'zooming'.","ref":"wxDC.html#setUserScale/3"},{"type":"function","title":"wxDC.startDoc/2","doc":"Starts a document (only relevant when outputting to a printer).\n\n`message` is a message to show while printing.","ref":"wxDC.html#startDoc/2"},{"type":"function","title":"wxDC.startPage/1","doc":"Starts a document page (only relevant when outputting to a printer).","ref":"wxDC.html#startPage/1"},{"type":"type","title":"wxDC.wxDC/0","doc":"","ref":"wxDC.html#t:wxDC/0"},{"type":"module","title":"wxDCOverlay","doc":"Functions for wxDCOverlay class\n\nConnects an overlay with a drawing DC.\n\nSee: `m:wxOverlay`, `m:wxDC`\n\nwxWidgets docs:\n[wxDCOverlay](https://docs.wxwidgets.org/3.1/classwx_d_c_overlay.html)","ref":"wxDCOverlay.html"},{"type":"function","title":"wxDCOverlay.clear/1","doc":"Clears the layer, restoring the state at the last init.","ref":"wxDCOverlay.html#clear/1"},{"type":"function","title":"wxDCOverlay.destroy/1","doc":"Removes the connection between the overlay and the dc.","ref":"wxDCOverlay.html#destroy/1"},{"type":"function","title":"wxDCOverlay.new/2","doc":"Convenience wrapper that behaves the same using the entire area of the dc.","ref":"wxDCOverlay.html#new/2"},{"type":"function","title":"wxDCOverlay.new/6","doc":"Connects this overlay to the corresponding drawing dc, if the overlay is not\ninitialized yet this call will do so.","ref":"wxDCOverlay.html#new/6"},{"type":"type","title":"wxDCOverlay.wxDCOverlay/0","doc":"","ref":"wxDCOverlay.html#t:wxDCOverlay/0"},{"type":"module","title":"wxDataObject","doc":"Functions for wxDataObject class\n\nA `m:wxDataObject` represents data that can be copied to or from the clipboard,\nor dragged and dropped. The important thing about `m:wxDataObject` is that this\nis a 'smart' piece of data unlike 'dumb' data containers such as memory buffers\nor files. Being 'smart' here means that the data object itself should know what\ndata formats it supports and how to render itself in each of its supported\nformats.\n\nA supported format, incidentally, is exactly the format in which the data can be\nrequested from a data object or from which the data object may be set. In the\ngeneral case, an object may support different formats on 'input' and 'output',\ni.e. it may be able to render itself in a given format but not be created from\ndata on this format or vice versa. `m:wxDataObject` defines the\n`wxDataObject::Direction` (not implemented in wx) enumeration type which\ndistinguishes between them.\n\nSee `wxDataFormat` (not implemented in wx) documentation for more about formats.\n\nNot surprisingly, being 'smart' comes at a price of added complexity. This is\nreasonable for the situations when you really need to support multiple formats,\nbut may be annoying if you only want to do something simple like cut and paste\ntext.\n\nTo provide a solution for both cases, wxWidgets has two predefined classes which\nderive from `m:wxDataObject`: `wxDataObjectSimple` (not implemented in wx) and\n`wxDataObjectComposite` (not implemented in wx). `wxDataObjectSimple` (not\nimplemented in wx) is the simplest `m:wxDataObject` possible and only holds data\nin a single format (such as HTML or text) and `wxDataObjectComposite` (not\nimplemented in wx) is the simplest way to implement a `m:wxDataObject` that does\nsupport multiple formats because it achieves this by simply holding several\n`wxDataObjectSimple` (not implemented in wx) objects.\n\nSo, you have several solutions when you need a `m:wxDataObject` class (and you\nneed one as soon as you want to transfer data via the clipboard or drag and\ndrop):\n\nPlease note that the easiest way to use drag and drop and the clipboard with\nmultiple formats is by using `wxDataObjectComposite` (not implemented in wx),\nbut it is not the most efficient one as each `wxDataObjectSimple` (not\nimplemented in wx) would contain the whole data in its respective formats. Now\nimagine that you want to paste 200 pages of text in your proprietary format, as\nwell as Word, RTF, HTML, Unicode and plain text to the clipboard and even\ntoday's computers are in trouble. For this case, you will have to derive from\n`m:wxDataObject` directly and make it enumerate its formats and provide the data\nin the requested format on demand.\n\nNote that neither the GTK+ data transfer mechanisms for clipboard and drag and\ndrop, nor OLE data transfer, `copies` any data until another application\nactually requests the data. This is in contrast to the 'feel' offered to the\nuser of a program who would normally think that the data resides in the\nclipboard after having pressed 'Copy' - in reality it is only declared to be\n`available`.\n\nYou may also derive your own data object classes from `wxCustomDataObject` (not\nimplemented in wx) for user-defined types. The format of user-defined data is\ngiven as a mime-type string literal, such as \"application/word\" or \"image/png\".\nThese strings are used as they are under Unix (so far only GTK+) to identify a\nformat and are translated into their Windows equivalent under Win32 (using the\nOLE IDataObject for data exchange to and from the clipboard and for drag and\ndrop). Note that the format string translation under Windows is not yet\nfinished.\n\nEach class derived directly from `m:wxDataObject` must override and implement\nall of its functions which are pure virtual in the base class. The data objects\nwhich only render their data or only set it (i.e. work in only one direction),\nshould return 0 from `GetFormatCount()` (not implemented in wx).\n\nSee:\n[Overview dnd](https://docs.wxwidgets.org/3.1/overview_dnd.html#overview_dnd),\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_dnd),\n`m:wxFileDataObject`, `m:wxTextDataObject`, `m:wxBitmapDataObject`,\n`wxCustomDataObject` (not implemented in wx), `wxDropTarget` (not implemented in\nwx), `wxDropSource` (not implemented in wx), `wxTextDropTarget` (not implemented\nin wx), `wxFileDropTarget` (not implemented in wx)\n\nwxWidgets docs:\n[wxDataObject](https://docs.wxwidgets.org/3.1/classwx_data_object.html)","ref":"wxDataObject.html"},{"type":"type","title":"wxDataObject.wxDataObject/0","doc":"","ref":"wxDataObject.html#t:wxDataObject/0"},{"type":"module","title":"wxDateEvent","doc":"Functions for wxDateEvent class\n\nThis event class holds information about a date change and is used together with\n`m:wxDatePickerCtrl`. It also serves as a base class for `m:wxCalendarEvent`.\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxDateEvent](https://docs.wxwidgets.org/3.1/classwx_date_event.html)","ref":"wxDateEvent.html"},{"type":"function","title":"wxDateEvent.getDate/1","doc":"Returns the date.","ref":"wxDateEvent.html#getDate/1"},{"type":"type","title":"wxDateEvent.wxDate/0","doc":"","ref":"wxDateEvent.html#t:wxDate/0"},{"type":"type","title":"wxDateEvent.wxDateEvent/0","doc":"","ref":"wxDateEvent.html#t:wxDateEvent/0"},{"type":"type","title":"wxDateEvent.wxDateEventType/0","doc":"","ref":"wxDateEvent.html#t:wxDateEventType/0"},{"type":"module","title":"wxDatePickerCtrl","doc":"Functions for wxDatePickerCtrl class\n\nThis control allows the user to select a date. Unlike `m:wxCalendarCtrl`, which\nis a relatively big control, `m:wxDatePickerCtrl` is implemented as a small\nwindow showing the currently selected date. The control can be edited using the\nkeyboard, and can also display a popup window for more user-friendly date\nselection, depending on the styles used and the platform.\n\nIt is only available if `wxUSE_DATEPICKCTRL` is set to 1.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `wxTimePickerCtrl` (not implemented in wx), `m:wxCalendarCtrl`,\n`m:wxDateEvent`\n\nThis class is derived (and can use functions) from: `m:wxPickerBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxDatePickerCtrl](https://docs.wxwidgets.org/3.1/classwx_date_picker_ctrl.html)","ref":"wxDatePickerCtrl.html"},{"type":"module","title":"Events - wxDatePickerCtrl","doc":"Event types emitted from this class: [`date_changed`](`m:wxDateEvent`)","ref":"wxDatePickerCtrl.html#module-events"},{"type":"function","title":"wxDatePickerCtrl.destroy/1","doc":"Destroys the object.","ref":"wxDatePickerCtrl.html#destroy/1"},{"type":"function","title":"wxDatePickerCtrl.getRange/3","doc":"If the control had been previously limited to a range of dates using\n`setRange/3`, returns the lower and upper bounds of this range.\n\nIf no range is set (or only one of the bounds is set), `dt1` and/or `dt2` are\nset to be invalid.\n\nNotice that when using a native MSW implementation of this control the lower\nrange is always set, even if `setRange/3` hadn't been called explicitly, as the\nnative control only supports dates later than year 1601.\n\nReturn: false if no range limits are currently set, true if at least one bound\nis set.","ref":"wxDatePickerCtrl.html#getRange/3"},{"type":"function","title":"wxDatePickerCtrl.getValue/1","doc":"Returns the currently entered date.\n\nFor a control with `wxDP_ALLOWNONE` style the returned value may be invalid if\nno date is entered, otherwise it is always valid.","ref":"wxDatePickerCtrl.html#getValue/1"},{"type":"function","title":"wxDatePickerCtrl.new/0","doc":"Default constructor.","ref":"wxDatePickerCtrl.html#new/0"},{"type":"function","title":"wxDatePickerCtrl.new/2","doc":"","ref":"wxDatePickerCtrl.html#new/2"},{"type":"function","title":"wxDatePickerCtrl.new/3","doc":"Initializes the object and calls `Create()` (not implemented in wx) with all the\nparameters.","ref":"wxDatePickerCtrl.html#new/3"},{"type":"function","title":"wxDatePickerCtrl.setRange/3","doc":"Sets the valid range for the date selection.\n\nIf `dt1` is valid, it becomes the earliest date (inclusive) accepted by the\ncontrol. If `dt2` is valid, it becomes the latest possible date.\n\nNotice that if the current value is not inside the new range, it will be\nadjusted to lie inside it, i.e. calling this method can change the control\nvalue, however no events are generated by it.\n\nRemark: If the current value of the control is outside of the newly set range\nbounds, the behaviour is undefined.","ref":"wxDatePickerCtrl.html#setRange/3"},{"type":"function","title":"wxDatePickerCtrl.setValue/2","doc":"Changes the current value of the control.\n\nThe date should be valid unless the control was created with `wxDP_ALLOWNONE`\nstyle and included in the currently selected range, if any.\n\nCalling this method does not result in a date change event.","ref":"wxDatePickerCtrl.html#setValue/2"},{"type":"type","title":"wxDatePickerCtrl.wxDatePickerCtrl/0","doc":"","ref":"wxDatePickerCtrl.html#t:wxDatePickerCtrl/0"},{"type":"module","title":"wxDialog","doc":"Functions for wxDialog class\n\nA dialog box is a window with a title bar and sometimes a system menu, which can\nbe moved around the screen. It can contain controls and other windows and is\noften used to allow the user to make some choice or to answer a question.\n\nDialogs can be made scrollable, automatically, for computers with low resolution\nscreens: please see overview_dialog_autoscrolling for further details.\n\nDialogs usually contain either a single button allowing to close the dialog or\ntwo buttons, one accepting the changes and the other one discarding them (such\nbutton, if present, is automatically activated if the user presses the \"Esc\"\nkey). By default, buttons with the standard wxID_OK and wxID_CANCEL identifiers\nbehave as expected. Starting with wxWidgets 2.7 it is also possible to use a\nbutton with a different identifier instead, see `setAffirmativeId/2` and\n`SetEscapeId()` (not implemented in wx).\n\nAlso notice that the `createButtonSizer/2` should be used to create the buttons\nappropriate for the current platform and positioned correctly (including their\norder which is platform-dependent).\n\nModal and Modeless\n\nThere are two kinds of dialog, modal and modeless. A modal dialog blocks program\nflow and user input on other windows until it is dismissed, whereas a modeless\ndialog behaves more like a frame in that program flow continues, and input in\nother windows is still possible. To show a modal dialog you should use the\n`showModal/1` method while to show a dialog modelessly you simply use `show/2`,\njust as with frames.\n\nNote that the modal dialog is one of the very few examples of wxWindow-derived\nobjects which may be created on the stack and not on the heap. In other words,\nwhile most windows would be created like this:\n\nYou can achieve the same result with dialogs by using simpler code:\n\nAn application can define a `m:wxCloseEvent` handler for the dialog to respond\nto system close events.\n\nStyles\n\nThis class supports the following styles:\n\nSee:\n[Overview dialog](https://docs.wxwidgets.org/3.1/overview_dialog.html#overview_dialog),\n`m:wxFrame`,\n[Overview validator](https://docs.wxwidgets.org/3.1/overview_validator.html#overview_validator)\n\nThis class is derived (and can use functions) from: `m:wxTopLevelWindow`\n`m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs: [wxDialog](https://docs.wxwidgets.org/3.1/classwx_dialog.html)","ref":"wxDialog.html"},{"type":"module","title":"Events - wxDialog","doc":"Event types emitted from this class: [`close_window`](`m:wxCloseEvent`),\n[`init_dialog`](`m:wxInitDialogEvent`)","ref":"wxDialog.html#module-events"},{"type":"function","title":"wxDialog.create/4","doc":"","ref":"wxDialog.html#create/4"},{"type":"function","title":"wxDialog.create/5","doc":"Used for two-step dialog box construction.\n\nSee: `new/4`","ref":"wxDialog.html#create/5"},{"type":"function","title":"wxDialog.createButtonSizer/2","doc":"Creates a sizer with standard buttons.\n\n`flags` is a bit list of the following flags: wxOK, wxCANCEL, wxYES, wxNO,\nwxAPPLY, wxCLOSE, wxHELP, wxNO_DEFAULT.\n\nThe sizer lays out the buttons in a manner appropriate to the platform.\n\nThis function uses `createStdDialogButtonSizer/2` internally for most platforms\nbut doesn't create the sizer at all for the platforms with hardware buttons\n(such as smartphones) for which it sets up the hardware buttons appropriately\nand returns NULL, so don't forget to test that the return value is valid before\nusing it.","ref":"wxDialog.html#createButtonSizer/2"},{"type":"function","title":"wxDialog.createStdDialogButtonSizer/2","doc":"Creates a `m:wxStdDialogButtonSizer` with standard buttons.\n\n`flags` is a bit list of the following flags: wxOK, wxCANCEL, wxYES, wxNO,\nwxAPPLY, wxCLOSE, wxHELP, wxNO_DEFAULT.\n\nThe sizer lays out the buttons in a manner appropriate to the platform.","ref":"wxDialog.html#createStdDialogButtonSizer/2"},{"type":"function","title":"wxDialog.destroy/1","doc":"Destructor.\n\nDeletes any child windows before deleting the physical window.\n\nSee overview_windowdeletion for more info.","ref":"wxDialog.html#destroy/1"},{"type":"function","title":"wxDialog.endModal/2","doc":"Ends a modal dialog, passing a value to be returned from the `showModal/1`\ninvocation.\n\nSee: `showModal/1`, `getReturnCode/1`, `setReturnCode/2`","ref":"wxDialog.html#endModal/2"},{"type":"function","title":"wxDialog.getAffirmativeId/1","doc":"Gets the identifier of the button which works like standard OK button in this\ndialog.\n\nSee: `setAffirmativeId/2`","ref":"wxDialog.html#getAffirmativeId/1"},{"type":"function","title":"wxDialog.getReturnCode/1","doc":"Gets the return code for this window.\n\nRemark: A return code is normally associated with a modal dialog, where\n`showModal/1` returns a code to the application.\n\nSee: `setReturnCode/2`, `showModal/1`, `endModal/2`","ref":"wxDialog.html#getReturnCode/1"},{"type":"function","title":"wxDialog.isModal/1","doc":"Returns true if the dialog box is modal, false otherwise.","ref":"wxDialog.html#isModal/1"},{"type":"function","title":"wxDialog.new/0","doc":"Default constructor.","ref":"wxDialog.html#new/0"},{"type":"function","title":"wxDialog.new/3","doc":"","ref":"wxDialog.html#new/3"},{"type":"function","title":"wxDialog.new/4","doc":"Constructor.\n\nSee: `create/5`","ref":"wxDialog.html#new/4"},{"type":"function","title":"wxDialog.setAffirmativeId/2","doc":"Sets the identifier to be used as OK button.\n\nWhen the button with this identifier is pressed, the dialog calls\n`wxWindow:validate/1` and `wxWindow:transferDataFromWindow/1` and, if they both\nreturn true, closes the dialog with the affirmative id return code.\n\nAlso, when the user presses a hardware OK button on the devices having one or\nthe special OK button in the PocketPC title bar, an event with this id is\ngenerated.\n\nBy default, the affirmative id is wxID_OK.\n\nSee: `getAffirmativeId/1`, `SetEscapeId()` (not implemented in wx)","ref":"wxDialog.html#setAffirmativeId/2"},{"type":"function","title":"wxDialog.setReturnCode/2","doc":"Sets the return code for this window.\n\nA return code is normally associated with a modal dialog, where `showModal/1`\nreturns a code to the application. The function `endModal/2` calls\n`setReturnCode/2`.\n\nSee: `getReturnCode/1`, `showModal/1`, `endModal/2`","ref":"wxDialog.html#setReturnCode/2"},{"type":"function","title":"wxDialog.show/1","doc":"","ref":"wxDialog.html#show/1"},{"type":"function","title":"wxDialog.show/2","doc":"Hides or shows the dialog.\n\nThe preferred way of dismissing a modal dialog is to use `endModal/2`.","ref":"wxDialog.html#show/2"},{"type":"function","title":"wxDialog.showModal/1","doc":"Shows an application-modal dialog.\n\nProgram flow does not return until the dialog has been dismissed with\n`endModal/2`.\n\nNotice that it is possible to call `showModal/1` for a dialog which had been\npreviously shown with `show/2`, this allows making an existing modeless dialog\nmodal. However `showModal/1` can't be called twice without intervening\n`endModal/2` calls.\n\nNote that this function creates a temporary event loop which takes precedence\nover the application's main event loop (see `wxEventLoopBase` (not implemented\nin wx)) and which is destroyed when the dialog is dismissed. This also results\nin a call to `wxApp::ProcessPendingEvents()` (not implemented in wx).\n\nReturn: The value set with `setReturnCode/2`.\n\nSee: `ShowWindowModal()` (not implemented in wx), `ShowWindowModalThenDo()` (not\nimplemented in wx), `endModal/2`, `getReturnCode/1`, `setReturnCode/2`","ref":"wxDialog.html#showModal/1"},{"type":"type","title":"wxDialog.wxDialog/0","doc":"","ref":"wxDialog.html#t:wxDialog/0"},{"type":"module","title":"wxDirDialog","doc":"Functions for wxDirDialog class\n\nThis class represents the directory chooser dialog.\n\nStyles\n\nThis class supports the following styles:\n\nNote: This flag cannot be used with the `wxDD_MULTIPLE` style.\n\nRemark: MacOS 10.11+ does not display a title bar on the dialog. Use\n`setMessage/2` to change the string displayed to the user at the top of the\ndialog after creation. The `wxTopLevelWindow:setTitle/2` method is provided for\ncompatibility with pre-10.11 MacOS versions that do still support displaying the\ntitle bar.\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_dir),\n`m:wxFileDialog`\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxDirDialog](https://docs.wxwidgets.org/3.1/classwx_dir_dialog.html)","ref":"wxDirDialog.html"},{"type":"function","title":"wxDirDialog.destroy/1","doc":"Destructor.","ref":"wxDirDialog.html#destroy/1"},{"type":"function","title":"wxDirDialog.getMessage/1","doc":"Returns the message that will be displayed on the dialog.","ref":"wxDirDialog.html#getMessage/1"},{"type":"function","title":"wxDirDialog.getPath/1","doc":"Returns the default or user-selected path.\n\nNote: This function can't be used with dialogs which have the `wxDD_MULTIPLE`\nstyle, use `GetPaths()` (not implemented in wx) instead.","ref":"wxDirDialog.html#getPath/1"},{"type":"function","title":"wxDirDialog.new/1","doc":"","ref":"wxDirDialog.html#new/1"},{"type":"function","title":"wxDirDialog.new/2","doc":"Constructor.\n\nUse `wxDialog:showModal/1` to show the dialog.","ref":"wxDirDialog.html#new/2"},{"type":"function","title":"wxDirDialog.setMessage/2","doc":"Sets the message that will be displayed on the dialog.","ref":"wxDirDialog.html#setMessage/2"},{"type":"function","title":"wxDirDialog.setPath/2","doc":"Sets the default path.","ref":"wxDirDialog.html#setPath/2"},{"type":"type","title":"wxDirDialog.wxDirDialog/0","doc":"","ref":"wxDirDialog.html#t:wxDirDialog/0"},{"type":"module","title":"wxDirPickerCtrl","doc":"Functions for wxDirPickerCtrl class\n\nThis control allows the user to select a directory. The generic implementation\nis a button which brings up a `m:wxDirDialog` when clicked. Native\nimplementation may differ but this is usually a (small) widget which give access\nto the dir-chooser dialog. It is only available if `wxUSE_DIRPICKERCTRL` is set\nto 1 (the default).\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxDirDialog`, `m:wxFileDirPickerEvent`\n\nThis class is derived (and can use functions) from: `m:wxPickerBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxDirPickerCtrl](https://docs.wxwidgets.org/3.1/classwx_dir_picker_ctrl.html)","ref":"wxDirPickerCtrl.html"},{"type":"module","title":"Events - wxDirPickerCtrl","doc":"Event types emitted from this class:\n[`command_dirpicker_changed`](`m:wxFileDirPickerEvent`)","ref":"wxDirPickerCtrl.html#module-events"},{"type":"function","title":"wxDirPickerCtrl.create/3","doc":"","ref":"wxDirPickerCtrl.html#create/3"},{"type":"function","title":"wxDirPickerCtrl.create/4","doc":"Creates the widgets with the given parameters.\n\nReturn: true if the control was successfully created or false if creation\nfailed.","ref":"wxDirPickerCtrl.html#create/4"},{"type":"function","title":"wxDirPickerCtrl.destroy/1","doc":"Destroys the object.","ref":"wxDirPickerCtrl.html#destroy/1"},{"type":"function","title":"wxDirPickerCtrl.getPath/1","doc":"Returns the absolute path of the currently selected directory.","ref":"wxDirPickerCtrl.html#getPath/1"},{"type":"function","title":"wxDirPickerCtrl.new/0","doc":"","ref":"wxDirPickerCtrl.html#new/0"},{"type":"function","title":"wxDirPickerCtrl.new/2","doc":"","ref":"wxDirPickerCtrl.html#new/2"},{"type":"function","title":"wxDirPickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxDirPickerCtrl.html#new/3"},{"type":"function","title":"wxDirPickerCtrl.setPath/2","doc":"Sets the absolute path of the currently selected directory.\n\nIf the control uses `wxDIRP_DIR_MUST_EXIST` and does not use\n`wxDIRP_USE_TEXTCTRL` style, the `dirname` must be a name of an existing\ndirectory and will be simply ignored by the native wxGTK implementation if this\nis not the case.","ref":"wxDirPickerCtrl.html#setPath/2"},{"type":"type","title":"wxDirPickerCtrl.wxDirPickerCtrl/0","doc":"","ref":"wxDirPickerCtrl.html#t:wxDirPickerCtrl/0"},{"type":"module","title":"wxDisplay","doc":"Functions for wxDisplay class\n\nDetermines the sizes and locations of displays connected to the system.\n\nwxWidgets docs: [wxDisplay](https://docs.wxwidgets.org/3.1/classwx_display.html)","ref":"wxDisplay.html"},{"type":"function","title":"wxDisplay.destroy/1","doc":"Destructor.","ref":"wxDisplay.html#destroy/1"},{"type":"function","title":"wxDisplay.getClientArea/1","doc":"Returns the client area of the display.\n\nThe client area is the part of the display available for the normal (non full\nscreen) windows, usually it is the same as `getGeometry/1` but it could be less\nif there is a taskbar (or equivalent) on this display.","ref":"wxDisplay.html#getClientArea/1"},{"type":"function","title":"wxDisplay.getCount/0","doc":"Returns the number of connected displays.","ref":"wxDisplay.html#getCount/0"},{"type":"function","title":"wxDisplay.getFromPoint/1","doc":"Returns the index of the display on which the given point lies, or `wxNOT_FOUND`\nif the point is not on any connected display.","ref":"wxDisplay.html#getFromPoint/1"},{"type":"function","title":"wxDisplay.getFromWindow/1","doc":"Returns the index of the display on which the given window lies.\n\nIf the window is on more than one display it gets the display that overlaps the\nwindow the most.\n\nReturns `wxNOT_FOUND` if the window is not on any connected display.","ref":"wxDisplay.html#getFromWindow/1"},{"type":"function","title":"wxDisplay.getGeometry/1","doc":"Returns the bounding rectangle of the display whose index was passed to the\nconstructor.\n\nSee: `getClientArea/1`, `wx_misc:displaySize/0`","ref":"wxDisplay.html#getGeometry/1"},{"type":"function","title":"wxDisplay.getName/1","doc":"Returns the display's name.\n\nThe returned value is currently an empty string under all platforms except MSW.","ref":"wxDisplay.html#getName/1"},{"type":"function","title":"wxDisplay.getPPI/1","doc":"Returns display resolution in pixels per inch.\n\nHorizontal and vertical resolution are returned in `x` and `y` components of the\n\\{Width,Height\\} object respectively.\n\nIf the resolution information is not available, returns.\n\nSince: 3.1.2","ref":"wxDisplay.html#getPPI/1"},{"type":"function","title":"wxDisplay.isOk/1","doc":"Returns true if the object was initialized successfully.","ref":"wxDisplay.html#isOk/1"},{"type":"function","title":"wxDisplay.isPrimary/1","doc":"Returns true if the display is the primary display.\n\nThe primary display is the one whose index is 0.","ref":"wxDisplay.html#isPrimary/1"},{"type":"function","title":"wxDisplay.new/0","doc":"Default constructor creating `m:wxDisplay` object representing the primary\ndisplay.","ref":"wxDisplay.html#new/0"},{"type":"function","title":"wxDisplay.new/1","doc":"Constructor creating the display object associated with the given window.\n\nThis is the most convenient way of finding the display on which the given window\nis shown while falling back to the default display if it is not shown at all or\npositioned outside of any display.\n\nSee: `getFromWindow/1`\n\nSince: 3.1.2","ref":"wxDisplay.html#new/1"},{"type":"type","title":"wxDisplay.wxDisplay/0","doc":"","ref":"wxDisplay.html#t:wxDisplay/0"},{"type":"module","title":"wxDisplayChangedEvent","doc":"Functions for wxDisplayChangedEvent class\n\nA display changed event is sent to top-level windows when the display resolution\nhas changed.\n\nThis event is currently emitted under Windows only.\n\nOnly for:wxmsw\n\nSee: `m:wxDisplay`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxDisplayChangedEvent](https://docs.wxwidgets.org/3.1/classwx_display_changed_event.html)","ref":"wxDisplayChangedEvent.html"},{"type":"module","title":"Events - wxDisplayChangedEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxDisplayChangedEventType`](`t:wxDisplayChangedEventType/0`) to subscribe to\nevents of this type.","ref":"wxDisplayChangedEvent.html#module-events"},{"type":"type","title":"wxDisplayChangedEvent.wxDisplayChanged/0","doc":"","ref":"wxDisplayChangedEvent.html#t:wxDisplayChanged/0"},{"type":"type","title":"wxDisplayChangedEvent.wxDisplayChangedEvent/0","doc":"","ref":"wxDisplayChangedEvent.html#t:wxDisplayChangedEvent/0"},{"type":"type","title":"wxDisplayChangedEvent.wxDisplayChangedEventType/0","doc":"","ref":"wxDisplayChangedEvent.html#t:wxDisplayChangedEventType/0"},{"type":"module","title":"wxDropFilesEvent","doc":"Functions for wxDropFilesEvent class\n\nThis class is used for drop files events, that is, when files have been dropped\nonto the window.\n\nThe window must have previously been enabled for dropping by calling\n`wxWindow:dragAcceptFiles/2`.\n\nImportant note: this is a separate implementation to the more general drag and\ndrop implementation documented in the overview_dnd. It uses the older, Windows\nmessage-based approach of dropping files.\n\nRemark: Windows only until version 2.8.9, available on all platforms since\n2.8.10.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxWindow:dragAcceptFiles/2`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxDropFilesEvent](https://docs.wxwidgets.org/3.1/classwx_drop_files_event.html)","ref":"wxDropFilesEvent.html"},{"type":"module","title":"Events - wxDropFilesEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxDropFilesEventType`](`t:wxDropFilesEventType/0`) to subscribe to events of\nthis type.","ref":"wxDropFilesEvent.html#module-events"},{"type":"function","title":"wxDropFilesEvent.getFiles/1","doc":"Returns an array of filenames.","ref":"wxDropFilesEvent.html#getFiles/1"},{"type":"function","title":"wxDropFilesEvent.getNumberOfFiles/1","doc":"Returns the number of files dropped.","ref":"wxDropFilesEvent.html#getNumberOfFiles/1"},{"type":"function","title":"wxDropFilesEvent.getPosition/1","doc":"Returns the position at which the files were dropped.\n\nReturns an array of filenames.","ref":"wxDropFilesEvent.html#getPosition/1"},{"type":"type","title":"wxDropFilesEvent.wxDropFiles/0","doc":"","ref":"wxDropFilesEvent.html#t:wxDropFiles/0"},{"type":"type","title":"wxDropFilesEvent.wxDropFilesEvent/0","doc":"","ref":"wxDropFilesEvent.html#t:wxDropFilesEvent/0"},{"type":"type","title":"wxDropFilesEvent.wxDropFilesEventType/0","doc":"","ref":"wxDropFilesEvent.html#t:wxDropFilesEventType/0"},{"type":"module","title":"wxEraseEvent","doc":"Functions for wxEraseEvent class\n\nAn erase event is sent when a window's background needs to be repainted.\n\nOn some platforms, such as GTK+, this event is simulated (simply generated just\nbefore the paint event) and may cause flicker. It is therefore recommended that\nyou set the text background colour explicitly in order to prevent flicker. The\ndefault background colour under GTK+ is grey.\n\nTo intercept this event, use the EVT_ERASE_BACKGROUND macro in an event table\ndefinition.\n\nYou must use the device context returned by `getDC/1` to draw on, don't create a\n`m:wxPaintDC` in the event handler.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxEraseEvent](https://docs.wxwidgets.org/3.1/classwx_erase_event.html)","ref":"wxEraseEvent.html"},{"type":"module","title":"Events - wxEraseEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxEraseEventType`](`t:wxEraseEventType/0`)\nto subscribe to events of this type.","ref":"wxEraseEvent.html#module-events"},{"type":"function","title":"wxEraseEvent.getDC/1","doc":"Returns the device context associated with the erase event to draw on.\n\nThe returned pointer is never NULL.","ref":"wxEraseEvent.html#getDC/1"},{"type":"type","title":"wxEraseEvent.wxErase/0","doc":"","ref":"wxEraseEvent.html#t:wxErase/0"},{"type":"type","title":"wxEraseEvent.wxEraseEvent/0","doc":"","ref":"wxEraseEvent.html#t:wxEraseEvent/0"},{"type":"type","title":"wxEraseEvent.wxEraseEventType/0","doc":"","ref":"wxEraseEvent.html#t:wxEraseEventType/0"},{"type":"module","title":"wxEvent","doc":"Functions for wxEvent class\n\nAn event is a structure holding information about an event passed to a callback\nor member function.\n\n`m:wxEvent` used to be a multipurpose event object, and is an abstract base\nclass for other event classes (see below).\n\nFor more information about events, see the overview_events overview.\n\nSee: `m:wxCommandEvent`, `m:wxMouseEvent`\n\nwxWidgets docs: [wxEvent](https://docs.wxwidgets.org/3.1/classwx_event.html)","ref":"wxEvent.html"},{"type":"function","title":"wxEvent.getId/1","doc":"Returns the identifier associated with this event, such as a button command id.","ref":"wxEvent.html#getId/1"},{"type":"function","title":"wxEvent.getSkipped/1","doc":"Returns true if the event handler should be skipped, false otherwise.","ref":"wxEvent.html#getSkipped/1"},{"type":"function","title":"wxEvent.getTimestamp/1","doc":"Gets the timestamp for the event.\n\nThe timestamp is the time in milliseconds since some fixed moment (not\nnecessarily the standard Unix Epoch, so only differences between the timestamps\nand not their absolute values usually make sense).\n\nWarning: wxWidgets returns a non-NULL timestamp only for mouse and key events\n(see `m:wxMouseEvent` and `m:wxKeyEvent`).","ref":"wxEvent.html#getTimestamp/1"},{"type":"function","title":"wxEvent.isCommandEvent/1","doc":"Returns true if the event is or is derived from `m:wxCommandEvent` else it\nreturns false.\n\nNote: exists only for optimization purposes.","ref":"wxEvent.html#isCommandEvent/1"},{"type":"function","title":"wxEvent.resumePropagation/2","doc":"Sets the propagation level to the given value (for example returned from an\nearlier call to `stopPropagation/1`).","ref":"wxEvent.html#resumePropagation/2"},{"type":"function","title":"wxEvent.shouldPropagate/1","doc":"Test if this event should be propagated or not, i.e. if the propagation level is\ncurrently greater than 0.","ref":"wxEvent.html#shouldPropagate/1"},{"type":"function","title":"wxEvent.skip/1","doc":"","ref":"wxEvent.html#skip/1"},{"type":"function","title":"wxEvent.skip/2","doc":"This method can be used inside an event handler to control whether further event\nhandlers bound to this event will be called after the current one returns.\n\nWithout `skip/2` (or equivalently if Skip(false) is used), the event will not be\nprocessed any more. If Skip(true) is called, the event processing system\ncontinues searching for a further handler function for this event, even though\nit has been processed already in the current handler.\n\nIn general, it is recommended to skip all non-command events to allow the\ndefault handling to take place. The command events are, however, normally not\nskipped as usually a single command such as a button click or menu item\nselection must only be processed by one handler.","ref":"wxEvent.html#skip/2"},{"type":"function","title":"wxEvent.stopPropagation/1","doc":"Stop the event from propagating to its parent window.\n\nReturns the old propagation level value which may be later passed to\n`resumePropagation/2` to allow propagating the event again.","ref":"wxEvent.html#stopPropagation/1"},{"type":"type","title":"wxEvent.wxEvent/0","doc":"","ref":"wxEvent.html#t:wxEvent/0"},{"type":"module","title":"wxEvtHandler","doc":"Functions for wxEvtHandler class\n\nA class that can handle events from the windowing system. `m:wxWindow` is (and\ntherefore all window classes are) derived from this class.\n\nTo get events from wxwidgets objects you subscribe to them by calling\n`connect/3`.\n\nIf the `callback` option is not supplied events are sent as messages.\n\nThese messages will be `#wx{}` where `EventRecord` is a record that depends on\nthe `wxEventType`. The records are defined in: `wx/include/wx.hrl`.\n\nIf a callback was supplied to connect, the callback will be invoked (in another\nprocess) to handle the event. The callback should be of arity 2.\n\n`fun Callback (EventRecord::wx(), EventObject::wxObject()).`\n\nNote: The callback will be in executed in new process each time.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events_processing)\n\nwxWidgets docs:\n[wxEvtHandler](https://docs.wxwidgets.org/3.1/classwx_evt_handler.html)","ref":"wxEvtHandler.html"},{"type":"function","title":"wxEvtHandler.connect/2","doc":"","ref":"wxEvtHandler.html#connect/2"},{"type":"function","title":"wxEvtHandler.connect/3","doc":"This function subscribes to events.\n\nSubscribes to events of type `EventType`, in the range `id`, `lastId`.\n\nThe events will be received as messages if no callback is supplied.\n\nOptions\n\nid:`{id, integer()} `The identifier (or first of the identifier range) to be\nassociated with this event handler. Default is ?wxID_ANY\n\nlastid:`{lastId,integer()} `The second part of the identifier range. If used\n'id' must be set as the starting identifier range. Default is ?wxID_ANY\n\nskip:`{skip,boolean()} `If skip is true further event_handlers will be called.\nThis is not used if the 'callback' option is used. Default is `false`.\n\ncallback:`{callback,function()} `Use a\ncallback`fun(EventRecord::wx(),EventObject::wxObject()) `to process the event.\nDefault not specified i.e. a message will be delivered to the process calling\nthis function.\n\nuserData:`{userData,term()} `An erlang term that will be sent with the event.\nDefault: [].","ref":"wxEvtHandler.html#connect/3"},{"type":"function","title":"wxEvtHandler.disconnect/1","doc":"","ref":"wxEvtHandler.html#disconnect/1"},{"type":"function","title":"wxEvtHandler.disconnect/2","doc":"","ref":"wxEvtHandler.html#disconnect/2"},{"type":"function","title":"wxEvtHandler.disconnect/3","doc":"This function unsubscribes the process or callback fun from the event handler.\n\nEventType may be the atom 'null' to match any eventtype. Notice that the options\nskip and userdata is not used to match the eventhandler.","ref":"wxEvtHandler.html#disconnect/3"},{"type":"type","title":"wxEvtHandler.event/0","doc":"","ref":"wxEvtHandler.html#t:event/0"},{"type":"type","title":"wxEvtHandler.wx/0","doc":"","ref":"wxEvtHandler.html#t:wx/0"},{"type":"type","title":"wxEvtHandler.wxEventType/0","doc":"","ref":"wxEvtHandler.html#t:wxEventType/0"},{"type":"type","title":"wxEvtHandler.wxEvtHandler/0","doc":"","ref":"wxEvtHandler.html#t:wxEvtHandler/0"},{"type":"module","title":"wxFileDataObject","doc":"Functions for wxFileDataObject class\n\n`m:wxFileDataObject` is a specialization of `m:wxDataObject` for file names. The\nprogram works with it just as if it were a list of absolute file names, but\ninternally it uses the same format as Explorer and other compatible programs\nunder Windows or GNOME/KDE file manager under Unix which makes it possible to\nreceive files from them using this class.\n\nSee: `m:wxDataObject`, `wxDataObjectSimple` (not implemented in wx),\n`m:wxTextDataObject`, `m:wxBitmapDataObject`, `m:wxDataObject`\n\nThis class is derived (and can use functions) from: `m:wxDataObject`\n\nwxWidgets docs:\n[wxFileDataObject](https://docs.wxwidgets.org/3.1/classwx_file_data_object.html)","ref":"wxFileDataObject.html"},{"type":"function","title":"wxFileDataObject.addFile/2","doc":"Adds a file to the file list represented by this data object (Windows only).","ref":"wxFileDataObject.html#addFile/2"},{"type":"function","title":"wxFileDataObject.destroy/1","doc":"Destroys the object.","ref":"wxFileDataObject.html#destroy/1"},{"type":"function","title":"wxFileDataObject.getFilenames/1","doc":"Returns the array of file names.","ref":"wxFileDataObject.html#getFilenames/1"},{"type":"function","title":"wxFileDataObject.new/0","doc":"Constructor.","ref":"wxFileDataObject.html#new/0"},{"type":"type","title":"wxFileDataObject.wxFileDataObject/0","doc":"","ref":"wxFileDataObject.html#t:wxFileDataObject/0"},{"type":"module","title":"wxFileDialog","doc":"Functions for wxFileDialog class\n\nThis class represents the file chooser dialog.\n\nThe path and filename are distinct elements of a full file pathname. If path is\n?wxEmptyString, the current directory will be used. If filename is\n?wxEmptyString, no default filename will be supplied. The wildcard determines\nwhat files are displayed in the file selector, and file extension supplies a\ntype extension for the required filename.\n\nThe typical usage for the open file dialog is:\n\nThe typical usage for the save file dialog is instead somewhat simpler:\n\nRemark: All implementations of the `m:wxFileDialog` provide a wildcard filter.\nTyping a filename containing wildcards (_, ?) in the filename text item, and\nclicking on Ok, will result in only those files matching the pattern being\ndisplayed. The wildcard may be a specification for multiple types of file with a\ndescription for each, such as: It must be noted that wildcard support in the\nnative Motif file dialog is quite limited: only one file type is supported, and\nit is displayed without the descriptive test; \"BMP files (_.bmp)|_.bmp\" is\ndisplayed as \"_.bmp\", and both \"BMP files (_.bmp)|_.bmp|GIF files (_.gif)|_.gif\"\nand \"Image files|_.bmp;_.gif\" are errors. On Mac macOS in the open file dialog\nthe filter choice box is not shown by default. Instead all given wildcards are\nappplied at the same time: So in the above example all bmp, gif and png files\nare displayed. To enforce the display of the filter choice set the corresponding\n`m:wxSystemOptions` before calling the file open dialog: But in contrast to\nWindows and Unix, where the file type choice filters only the selected files, on\nMac macOS even in this case the dialog shows all files matching all file types.\nThe files which does not match the currently selected file type are greyed out\nand are not selectable.\n\nStyles\n\nThis class supports the following styles:\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_file),\n?wxFileSelector()\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxFileDialog](https://docs.wxwidgets.org/3.1/classwx_file_dialog.html)","ref":"wxFileDialog.html"},{"type":"function","title":"wxFileDialog.destroy/1","doc":"Destructor.","ref":"wxFileDialog.html#destroy/1"},{"type":"function","title":"wxFileDialog.getDirectory/1","doc":"Returns the default directory.","ref":"wxFileDialog.html#getDirectory/1"},{"type":"function","title":"wxFileDialog.getFilename/1","doc":"Returns the default filename.\n\nNote: This function can't be used with dialogs which have the `wxFD_MULTIPLE`\nstyle, use `getFilenames/1` instead.","ref":"wxFileDialog.html#getFilename/1"},{"type":"function","title":"wxFileDialog.getFilenames/1","doc":"Fills the array `filenames` with the names of the files chosen.\n\nThis function should only be used with the dialogs which have `wxFD_MULTIPLE`\nstyle, use `getFilename/1` for the others.\n\nNote that under Windows, if the user selects shortcuts, the filenames include\npaths, since the application cannot determine the full path of each referenced\nfile by appending the directory containing the shortcuts to the filename.","ref":"wxFileDialog.html#getFilenames/1"},{"type":"function","title":"wxFileDialog.getFilterIndex/1","doc":"Returns the index into the list of filters supplied, optionally, in the wildcard\nparameter.\n\nBefore the dialog is shown, this is the index which will be used when the dialog\nis first displayed.\n\nAfter the dialog is shown, this is the index selected by the user.","ref":"wxFileDialog.html#getFilterIndex/1"},{"type":"function","title":"wxFileDialog.getMessage/1","doc":"Returns the message that will be displayed on the dialog.","ref":"wxFileDialog.html#getMessage/1"},{"type":"function","title":"wxFileDialog.getPath/1","doc":"Returns the full path (directory and filename) of the selected file.\n\nNote: This function can't be used with dialogs which have the `wxFD_MULTIPLE`\nstyle, use `getPaths/1` instead.","ref":"wxFileDialog.html#getPath/1"},{"type":"function","title":"wxFileDialog.getPaths/1","doc":"Fills the array `paths` with the full paths of the files chosen.\n\nThis function should only be used with the dialogs which have `wxFD_MULTIPLE`\nstyle, use `getPath/1` for the others.","ref":"wxFileDialog.html#getPaths/1"},{"type":"function","title":"wxFileDialog.getWildcard/1","doc":"Returns the file dialog wildcard.","ref":"wxFileDialog.html#getWildcard/1"},{"type":"function","title":"wxFileDialog.new/1","doc":"","ref":"wxFileDialog.html#new/1"},{"type":"function","title":"wxFileDialog.new/2","doc":"Constructor.\n\nUse `wxDialog:showModal/1` to show the dialog.","ref":"wxFileDialog.html#new/2"},{"type":"function","title":"wxFileDialog.setDirectory/2","doc":"Sets the default directory.","ref":"wxFileDialog.html#setDirectory/2"},{"type":"function","title":"wxFileDialog.setFilename/2","doc":"Sets the default filename.\n\nIn wxGTK this will have little effect unless a default directory has previously\nbeen set.","ref":"wxFileDialog.html#setFilename/2"},{"type":"function","title":"wxFileDialog.setFilterIndex/2","doc":"Sets the default filter index, starting from zero.","ref":"wxFileDialog.html#setFilterIndex/2"},{"type":"function","title":"wxFileDialog.setMessage/2","doc":"Sets the message that will be displayed on the dialog.","ref":"wxFileDialog.html#setMessage/2"},{"type":"function","title":"wxFileDialog.setPath/2","doc":"Sets the path (the combined directory and filename that will be returned when\nthe dialog is dismissed).","ref":"wxFileDialog.html#setPath/2"},{"type":"function","title":"wxFileDialog.setWildcard/2","doc":"Sets the wildcard, which can contain multiple file types, for example: \"BMP\nfiles (_.bmp)|_.bmp|GIF files (_.gif)|_.gif\".\n\nNote that the native Motif dialog has some limitations with respect to\nwildcards; see the Remarks section above.","ref":"wxFileDialog.html#setWildcard/2"},{"type":"type","title":"wxFileDialog.wxFileDialog/0","doc":"","ref":"wxFileDialog.html#t:wxFileDialog/0"},{"type":"module","title":"wxFileDirPickerEvent","doc":"Functions for wxFileDirPickerEvent class\n\nThis event class is used for the events generated by `m:wxFilePickerCtrl` and by\n`m:wxDirPickerCtrl`.\n\nSee: `m:wxFilePickerCtrl`, `m:wxDirPickerCtrl`\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxFileDirPickerEvent](https://docs.wxwidgets.org/3.1/classwx_file_dir_picker_event.html)","ref":"wxFileDirPickerEvent.html"},{"type":"module","title":"Events - wxFileDirPickerEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxFileDirPickerEventType`](`t:wxFileDirPickerEventType/0`) to subscribe to\nevents of this type.","ref":"wxFileDirPickerEvent.html#module-events"},{"type":"function","title":"wxFileDirPickerEvent.getPath/1","doc":"Retrieve the absolute path of the file/directory the user has just selected.","ref":"wxFileDirPickerEvent.html#getPath/1"},{"type":"type","title":"wxFileDirPickerEvent.wxFileDirPicker/0","doc":"","ref":"wxFileDirPickerEvent.html#t:wxFileDirPicker/0"},{"type":"type","title":"wxFileDirPickerEvent.wxFileDirPickerEvent/0","doc":"","ref":"wxFileDirPickerEvent.html#t:wxFileDirPickerEvent/0"},{"type":"type","title":"wxFileDirPickerEvent.wxFileDirPickerEventType/0","doc":"","ref":"wxFileDirPickerEvent.html#t:wxFileDirPickerEventType/0"},{"type":"module","title":"wxFilePickerCtrl","doc":"Functions for wxFilePickerCtrl class\n\nThis control allows the user to select a file. The generic implementation is a\nbutton which brings up a `m:wxFileDialog` when clicked. Native implementation\nmay differ but this is usually a (small) widget which give access to the\nfile-chooser dialog. It is only available if `wxUSE_FILEPICKERCTRL` is set to 1\n(the default).\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxFileDialog`, `m:wxFileDirPickerEvent`\n\nThis class is derived (and can use functions) from: `m:wxPickerBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxFilePickerCtrl](https://docs.wxwidgets.org/3.1/classwx_file_picker_ctrl.html)","ref":"wxFilePickerCtrl.html"},{"type":"module","title":"Events - wxFilePickerCtrl","doc":"Event types emitted from this class:\n[`command_filepicker_changed`](`m:wxFileDirPickerEvent`)","ref":"wxFilePickerCtrl.html#module-events"},{"type":"function","title":"wxFilePickerCtrl.create/3","doc":"","ref":"wxFilePickerCtrl.html#create/3"},{"type":"function","title":"wxFilePickerCtrl.create/4","doc":"Creates this widget with the given parameters.\n\nReturn: true if the control was successfully created or false if creation\nfailed.","ref":"wxFilePickerCtrl.html#create/4"},{"type":"function","title":"wxFilePickerCtrl.destroy/1","doc":"Destroys the object.","ref":"wxFilePickerCtrl.html#destroy/1"},{"type":"function","title":"wxFilePickerCtrl.getPath/1","doc":"Returns the absolute path of the currently selected file.","ref":"wxFilePickerCtrl.html#getPath/1"},{"type":"function","title":"wxFilePickerCtrl.new/0","doc":"","ref":"wxFilePickerCtrl.html#new/0"},{"type":"function","title":"wxFilePickerCtrl.new/2","doc":"","ref":"wxFilePickerCtrl.html#new/2"},{"type":"function","title":"wxFilePickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxFilePickerCtrl.html#new/3"},{"type":"function","title":"wxFilePickerCtrl.setPath/2","doc":"Sets the absolute path of the currently selected file.\n\nIf the control uses `wxFLP_FILE_MUST_EXIST` and does not use\n`wxFLP_USE_TEXTCTRL` style, the `filename` must be a name of an existing file\nand will be simply ignored by the native wxGTK implementation if this is not the\ncase (the generic implementation used under the other platforms accepts even\ninvalid file names currently, but this is subject to change in the future, don't\nrely on being able to use non-existent paths with it).","ref":"wxFilePickerCtrl.html#setPath/2"},{"type":"type","title":"wxFilePickerCtrl.wxFilePickerCtrl/0","doc":"","ref":"wxFilePickerCtrl.html#t:wxFilePickerCtrl/0"},{"type":"module","title":"wxFindReplaceData","doc":"Functions for wxFindReplaceData class\n\n`m:wxFindReplaceData` holds the data for `m:wxFindReplaceDialog`.\n\nIt is used to initialize the dialog with the default values and will keep the\nlast values from the dialog when it is closed. It is also updated each time a\n`wxFindDialogEvent` (not implemented in wx) is generated so instead of using the\n`wxFindDialogEvent` (not implemented in wx) methods you can also directly query\nthis object.\n\nNote that all `SetXXX()` methods may only be called before showing the dialog\nand calling them has no effect later.\n\nwxWidgets docs:\n[wxFindReplaceData](https://docs.wxwidgets.org/3.1/classwx_find_replace_data.html)","ref":"wxFindReplaceData.html"},{"type":"function","title":"wxFindReplaceData.destroy/1","doc":"Destroys the object.","ref":"wxFindReplaceData.html#destroy/1"},{"type":"function","title":"wxFindReplaceData.getFindString/1","doc":"Get the string to find.","ref":"wxFindReplaceData.html#getFindString/1"},{"type":"function","title":"wxFindReplaceData.getFlags/1","doc":"Get the combination of `wxFindReplaceFlags` values.","ref":"wxFindReplaceData.html#getFlags/1"},{"type":"function","title":"wxFindReplaceData.getReplaceString/1","doc":"Get the replacement string.","ref":"wxFindReplaceData.html#getReplaceString/1"},{"type":"function","title":"wxFindReplaceData.new/0","doc":"","ref":"wxFindReplaceData.html#new/0"},{"type":"function","title":"wxFindReplaceData.new/1","doc":"Constructor initializes the flags to default value (0).","ref":"wxFindReplaceData.html#new/1"},{"type":"function","title":"wxFindReplaceData.setFindString/2","doc":"Set the string to find (used as initial value by the dialog).","ref":"wxFindReplaceData.html#setFindString/2"},{"type":"function","title":"wxFindReplaceData.setFlags/2","doc":"Set the flags to use to initialize the controls of the dialog.","ref":"wxFindReplaceData.html#setFlags/2"},{"type":"function","title":"wxFindReplaceData.setReplaceString/2","doc":"Set the replacement string (used as initial value by the dialog).","ref":"wxFindReplaceData.html#setReplaceString/2"},{"type":"type","title":"wxFindReplaceData.wxFindReplaceData/0","doc":"","ref":"wxFindReplaceData.html#t:wxFindReplaceData/0"},{"type":"module","title":"wxFindReplaceDialog","doc":"Functions for wxFindReplaceDialog class\n\n`m:wxFindReplaceDialog` is a standard modeless dialog which is used to allow the\nuser to search for some text (and possibly replace it with something else).\n\nThe actual searching is supposed to be done in the owner window which is the\nparent of this dialog. Note that it means that unlike for the other standard\ndialogs this one `must` have a parent window. Also note that there is no way to\nuse this dialog in a modal way; it is always, by design and implementation,\nmodeless.\n\nPlease see the page_samples_dialogs sample for an example of using it.\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxFindReplaceDialog](https://docs.wxwidgets.org/3.1/classwx_find_replace_dialog.html)","ref":"wxFindReplaceDialog.html"},{"type":"function","title":"wxFindReplaceDialog.create/4","doc":"","ref":"wxFindReplaceDialog.html#create/4"},{"type":"function","title":"wxFindReplaceDialog.create/5","doc":"Creates the dialog; use `wxWindow:show/2` to show it on screen.\n\nThe `parent` and `data` parameters must be non-NULL.","ref":"wxFindReplaceDialog.html#create/5"},{"type":"function","title":"wxFindReplaceDialog.destroy/1","doc":"Destructor.","ref":"wxFindReplaceDialog.html#destroy/1"},{"type":"function","title":"wxFindReplaceDialog.getData/1","doc":"Get the `m:wxFindReplaceData` object used by this dialog.","ref":"wxFindReplaceDialog.html#getData/1"},{"type":"function","title":"wxFindReplaceDialog.new/0","doc":"","ref":"wxFindReplaceDialog.html#new/0"},{"type":"function","title":"wxFindReplaceDialog.new/3","doc":"","ref":"wxFindReplaceDialog.html#new/3"},{"type":"function","title":"wxFindReplaceDialog.new/4","doc":"After using default constructor `create/5` must be called.\n\nThe `parent` and `data` parameters must be non-NULL.","ref":"wxFindReplaceDialog.html#new/4"},{"type":"type","title":"wxFindReplaceDialog.wxFindReplaceDialog/0","doc":"","ref":"wxFindReplaceDialog.html#t:wxFindReplaceDialog/0"},{"type":"module","title":"wxFlexGridSizer","doc":"Functions for wxFlexGridSizer class\n\nA flex grid sizer is a sizer which lays out its children in a two-dimensional\ntable with all table fields in one row having the same height and all fields in\none column having the same width, but all rows or all columns are not\nnecessarily the same height or width as in the `m:wxGridSizer`.\n\nSince wxWidgets 2.5.0, `m:wxFlexGridSizer` can also size items equally in one\ndirection but unequally (\"flexibly\") in the other. If the sizer is only flexible\nin one direction (this can be changed using `setFlexibleDirection/2`), it needs\nto be decided how the sizer should grow in the other (\"non-flexible\") direction\nin order to fill the available space. The `setNonFlexibleGrowMode/2` method\nserves this purpose.\n\nSee: `m:wxSizer`,\n[Overview sizer](https://docs.wxwidgets.org/3.1/overview_sizer.html#overview_sizer)\n\nThis class is derived (and can use functions) from: `m:wxGridSizer` `m:wxSizer`\n\nwxWidgets docs:\n[wxFlexGridSizer](https://docs.wxwidgets.org/3.1/classwx_flex_grid_sizer.html)","ref":"wxFlexGridSizer.html"},{"type":"function","title":"wxFlexGridSizer.addGrowableCol/2","doc":"","ref":"wxFlexGridSizer.html#addGrowableCol/2"},{"type":"function","title":"wxFlexGridSizer.addGrowableCol/3","doc":"Specifies that column `idx` (starting from zero) should be grown if there is\nextra space available to the sizer.\n\nThe `proportion` parameter has the same meaning as the stretch factor for the\nsizers (see `m:wxBoxSizer`) except that if all proportions are 0, then all\ncolumns are resized equally (instead of not being resized at all).\n\nNotice that the column must not be already growable, if you need to change the\nproportion you must call `removeGrowableCol/2` first and then make it growable\n(with a different proportion) again. You can use `IsColGrowable()` (not\nimplemented in wx) to check whether a column is already growable.","ref":"wxFlexGridSizer.html#addGrowableCol/3"},{"type":"function","title":"wxFlexGridSizer.addGrowableRow/2","doc":"","ref":"wxFlexGridSizer.html#addGrowableRow/2"},{"type":"function","title":"wxFlexGridSizer.addGrowableRow/3","doc":"Specifies that row idx (starting from zero) should be grown if there is extra\nspace available to the sizer.\n\nThis is identical to `addGrowableCol/3` except that it works with rows and not\ncolumns.","ref":"wxFlexGridSizer.html#addGrowableRow/3"},{"type":"function","title":"wxFlexGridSizer.destroy/1","doc":"Destroys the object.","ref":"wxFlexGridSizer.html#destroy/1"},{"type":"function","title":"wxFlexGridSizer.getFlexibleDirection/1","doc":"Returns a ?wxOrientation value that specifies whether the sizer flexibly resizes\nits columns, rows, or both (default).\n\nReturn: One of the following values:\n\nSee: `setFlexibleDirection/2`","ref":"wxFlexGridSizer.html#getFlexibleDirection/1"},{"type":"function","title":"wxFlexGridSizer.getNonFlexibleGrowMode/1","doc":"Returns the value that specifies how the sizer grows in the \"non-flexible\"\ndirection if there is one.\n\nThe behaviour of the elements in the flexible direction (i.e. both rows and\ncolumns by default, or rows only if `getFlexibleDirection/1` is `wxVERTICAL` or\ncolumns only if it is `wxHORIZONTAL`) is always governed by their proportion as\nspecified in the call to `addGrowableRow/3` or `addGrowableCol/3`. What happens\nin the other direction depends on the value of returned by this function as\ndescribed below.\n\nReturn: One of the following values:\n\nSee: `setFlexibleDirection/2`, `setNonFlexibleGrowMode/2`","ref":"wxFlexGridSizer.html#getNonFlexibleGrowMode/1"},{"type":"function","title":"wxFlexGridSizer.new/1","doc":"","ref":"wxFlexGridSizer.html#new/1"},{"type":"function","title":"wxFlexGridSizer.new/2","doc":"","ref":"wxFlexGridSizer.html#new/2"},{"type":"function","title":"wxFlexGridSizer.new/3","doc":"","ref":"wxFlexGridSizer.html#new/3"},{"type":"function","title":"wxFlexGridSizer.new/4","doc":"","ref":"wxFlexGridSizer.html#new/4"},{"type":"function","title":"wxFlexGridSizer.removeGrowableCol/2","doc":"Specifies that the `idx` column index is no longer growable.","ref":"wxFlexGridSizer.html#removeGrowableCol/2"},{"type":"function","title":"wxFlexGridSizer.removeGrowableRow/2","doc":"Specifies that the `idx` row index is no longer growable.","ref":"wxFlexGridSizer.html#removeGrowableRow/2"},{"type":"function","title":"wxFlexGridSizer.setFlexibleDirection/2","doc":"Specifies whether the sizer should flexibly resize its columns, rows, or both.\n\nArgument `direction` can be `wxVERTICAL`, `wxHORIZONTAL` or `wxBOTH` (which is\nthe default value). Any other value is ignored.\n\nSee `getFlexibleDirection/1` for the explanation of these values. Note that this\nmethod does not trigger relayout.","ref":"wxFlexGridSizer.html#setFlexibleDirection/2"},{"type":"function","title":"wxFlexGridSizer.setNonFlexibleGrowMode/2","doc":"Specifies how the sizer should grow in the non-flexible direction if there is\none (so `setFlexibleDirection/2` must have been called previously).\n\nArgument `mode` can be one of those documented in `getNonFlexibleGrowMode/1`,\nplease see there for their explanation. Note that this method does not trigger\nrelayout.","ref":"wxFlexGridSizer.html#setNonFlexibleGrowMode/2"},{"type":"type","title":"wxFlexGridSizer.wxFlexGridSizer/0","doc":"","ref":"wxFlexGridSizer.html#t:wxFlexGridSizer/0"},{"type":"module","title":"wxFocusEvent","doc":"Functions for wxFocusEvent class\n\nA focus event is sent when a window's focus changes. The window losing focus\nreceives a \"kill focus\" event while the window gaining it gets a \"set focus\"\none.\n\nNotice that the set focus event happens both when the user gives focus to the\nwindow (whether using the mouse or keyboard) and when it is done from the\nprogram itself using `wxWindow:setFocus/1`.\n\nThe focus event handlers should almost invariably call `wxEvent:skip/2` on their\nevent argument to allow the default handling to take place. Failure to do this\nmay result in incorrect behaviour of the native controls. Also note that\nwxEVT_KILL_FOCUS handler must not call `wxWindow:setFocus/1` as this, again, is\nnot supported by all native controls. If you need to do this, consider using the\n`Delayed Action Mechanism` (not implemented in wx) described in `m:wxIdleEvent`\ndocumentation.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxFocusEvent](https://docs.wxwidgets.org/3.1/classwx_focus_event.html)","ref":"wxFocusEvent.html"},{"type":"module","title":"Events - wxFocusEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxFocusEventType`](`t:wxFocusEventType/0`)\nto subscribe to events of this type.","ref":"wxFocusEvent.html#module-events"},{"type":"function","title":"wxFocusEvent.getWindow/1","doc":"Returns the window associated with this event, that is the window which had the\nfocus before for the `wxEVT_SET_FOCUS` event and the window which is going to\nreceive focus for the `wxEVT_KILL_FOCUS` one.\n\nWarning: the window pointer may be NULL\\!","ref":"wxFocusEvent.html#getWindow/1"},{"type":"type","title":"wxFocusEvent.wxFocus/0","doc":"","ref":"wxFocusEvent.html#t:wxFocus/0"},{"type":"type","title":"wxFocusEvent.wxFocusEvent/0","doc":"","ref":"wxFocusEvent.html#t:wxFocusEvent/0"},{"type":"type","title":"wxFocusEvent.wxFocusEventType/0","doc":"","ref":"wxFocusEvent.html#t:wxFocusEventType/0"},{"type":"module","title":"wxFont","doc":"Functions for wxFont class\n\nA font is an object which determines the appearance of text.\n\nFonts are used for drawing text to a device context, and setting the appearance\nof a window's text, see `wxDC:setFont/2` and `wxWindow:setFont/2`.\n\nThe easiest way to create a custom font is to use `wxFontInfo` (not implemented\nin wx) object to specify the font attributes and then use `new/5` constructor.\nAlternatively, you could start with one of the pre-defined fonts or use\n`wxWindow:getFont/1` and modify the font, e.g. by increasing its size using\n`MakeLarger()` (not implemented in wx) or changing its weight using `MakeBold()`\n(not implemented in wx).\n\nThis class uses reference counting and copy-on-write internally so that\nassignments between two instances of this class are very cheap. You can\ntherefore use actual objects instead of pointers without efficiency problems. If\nan instance of this class is changed it will create its own data internally so\nthat other instances, which previously shared the data using the reference\ncounting, are not affected.\n\nYou can retrieve the current system font settings with `m:wxSystemSettings`.\n\nPredefined objects (include wx.hrl): ?wxNullFont, ?wxNORMAL_FONT, ?wxSMALL_FONT,\n?wxITALIC_FONT, ?wxSWISS_FONT\n\nSee:\n[Overview font](https://docs.wxwidgets.org/3.1/overview_font.html#overview_font),\n`wxDC:setFont/2`, `wxDC:drawText/3`, `wxDC:getTextExtent/3`, `m:wxFontDialog`,\n`m:wxSystemSettings`\n\nwxWidgets docs: [wxFont](https://docs.wxwidgets.org/3.1/classwx_font.html)","ref":"wxFont.html"},{"type":"function","title":"wxFont.destroy/1","doc":"Destructor.\n\nSee reference-counted object destruction for more info.\n\nRemark: Although all remaining fonts are deleted when the application exits, the\napplication should try to clean up all fonts itself. This is because wxWidgets\ncannot know if a pointer to the font object is stored in an application data\nstructure, and there is a risk of double deletion.","ref":"wxFont.html#destroy/1"},{"type":"function","title":"wxFont.getDefaultEncoding/0","doc":"Returns the current application's default encoding.\n\nSee:\n[Overview fontencoding](https://docs.wxwidgets.org/3.1/overview_fontencoding.html#overview_fontencoding),\n`setDefaultEncoding/1`","ref":"wxFont.html#getDefaultEncoding/0"},{"type":"function","title":"wxFont.getFaceName/1","doc":"Returns the face name associated with the font, or the empty string if there is\nno face information.\n\nSee: `setFaceName/2`","ref":"wxFont.html#getFaceName/1"},{"type":"function","title":"wxFont.getFamily/1","doc":"Gets the font family if possible.\n\nAs described in ?wxFontFamily docs the returned value acts as a rough, basic\nclassification of the main font properties (look, spacing).\n\nIf the current font face name is not recognized by `m:wxFont` or by the\nunderlying system, `wxFONTFAMILY_DEFAULT` is returned.\n\nNote that currently this function is not very precise and so not particularly\nuseful. Font families mostly make sense only for font creation, see\n`setFamily/2`.\n\nSee: `setFamily/2`","ref":"wxFont.html#getFamily/1"},{"type":"function","title":"wxFont.getNativeFontInfoDesc/1","doc":"Returns the platform-dependent string completely describing this font.\n\nReturned string is always non-empty unless the font is invalid (in which case an\nassert is triggered).\n\nNote that the returned string is not meant to be shown or edited by the user: a\ntypical use of this function is for serializing in string-form a `m:wxFont`\nobject.\n\nSee: `SetNativeFontInfo()` (not implemented in wx),\n`getNativeFontInfoUserDesc/1`","ref":"wxFont.html#getNativeFontInfoDesc/1"},{"type":"function","title":"wxFont.getNativeFontInfoUserDesc/1","doc":"Returns a user-friendly string for this font object.\n\nReturned string is always non-empty unless the font is invalid (in which case an\nassert is triggered).\n\nThe string does not encode all `m:wxFont` infos under all platforms; e.g. under\nwxMSW the font family is not present in the returned string.\n\nSome examples of the formats of returned strings (which are platform-dependent)\nare in `SetNativeFontInfoUserDesc()` (not implemented in wx).\n\nSee: `SetNativeFontInfoUserDesc()` (not implemented in wx),\n`getNativeFontInfoDesc/1`","ref":"wxFont.html#getNativeFontInfoUserDesc/1"},{"type":"function","title":"wxFont.getPointSize/1","doc":"Gets the point size as an integer number.\n\nThis function is kept for compatibility reasons. New code should use\n`GetFractionalPointSize()` (not implemented in wx) and support fractional point\nsizes.\n\nSee: `setPointSize/2`\n\nSee: `GetFractionalPointSize()` (not implemented in wx)","ref":"wxFont.html#getPointSize/1"},{"type":"function","title":"wxFont.getStyle/1","doc":"Gets the font style.\n\nSee ?wxFontStyle for a list of valid styles.\n\nSee: `setStyle/2`","ref":"wxFont.html#getStyle/1"},{"type":"function","title":"wxFont.getUnderlined/1","doc":"Returns true if the font is underlined, false otherwise.\n\nSee: `setUnderlined/2`","ref":"wxFont.html#getUnderlined/1"},{"type":"function","title":"wxFont.getWeight/1","doc":"Gets the font weight.\n\nSee ?wxFontWeight for a list of valid weight identifiers.\n\nSee: `setWeight/2`","ref":"wxFont.html#getWeight/1"},{"type":"function","title":"wxFont.isFixedWidth/1","doc":"Returns true if the font is a fixed width (or monospaced) font, false if it is a\nproportional one or font is invalid.\n\nNote that this function under some platforms is different from just testing for\nthe font family being equal to `wxFONTFAMILY_TELETYPE` because native\nplatform-specific functions are used for the check (resulting in a more accurate\nreturn value).","ref":"wxFont.html#isFixedWidth/1"},{"type":"function","title":"wxFont.isOk/1","doc":"Returns true if this object is a valid font, false otherwise.","ref":"wxFont.html#isOk/1"},{"type":"function","title":"wxFont.new/0","doc":"Default ctor.","ref":"wxFont.html#new/0"},{"type":"function","title":"wxFont.new/1","doc":"Copy constructor, uses reference counting.","ref":"wxFont.html#new/1"},{"type":"function","title":"wxFont.new/4","doc":"","ref":"wxFont.html#new/4"},{"type":"function","title":"wxFont.new/5","doc":"Creates a font object with the specified attributes and size in pixels.\n\nNotice that the use of this constructor is often more verbose and less readable\nthan the use of constructor from `wxFontInfo` (not implemented in wx), consider\nusing that constructor instead.\n\nRemark: If the desired font does not exist, the closest match will be chosen.\nUnder Windows, only scalable TrueType fonts are used.","ref":"wxFont.html#new/5"},{"type":"function","title":"wxFont.ok/1","doc":"See: `isOk/1`.","ref":"wxFont.html#ok/1"},{"type":"function","title":"wxFont.setDefaultEncoding/1","doc":"Sets the default font encoding.\n\nSee:\n[Overview fontencoding](https://docs.wxwidgets.org/3.1/overview_fontencoding.html#overview_fontencoding),\n`getDefaultEncoding/0`","ref":"wxFont.html#setDefaultEncoding/1"},{"type":"function","title":"wxFont.setFaceName/2","doc":"Sets the facename for the font.\n\nRemark: To avoid portability problems, don't rely on a specific face, but\nspecify the font family instead (see ?wxFontFamily and `setFamily/2`).\n\nReturn: true if the given face name exists; if the face name doesn't exist in\nthe user's system then the font is invalidated (so that `isOk/1` will return\nfalse) and false is returned.\n\nSee: `getFaceName/1`, `setFamily/2`","ref":"wxFont.html#setFaceName/2"},{"type":"function","title":"wxFont.setFamily/2","doc":"Sets the font family.\n\nAs described in ?wxFontFamily docs the given `family` value acts as a rough,\nbasic indication of the main font properties (look, spacing).\n\nNote that changing the font family results in changing the font face name.\n\nSee: `getFamily/1`, `setFaceName/2`","ref":"wxFont.html#setFamily/2"},{"type":"function","title":"wxFont.setPointSize/2","doc":"Sets the font size in points to an integer value.\n\nThis is a legacy version of the function only supporting integer point sizes. It\ncan still be used, but to avoid unnecessarily restricting the font size in\npoints to integer values, consider using the new (added in wxWidgets 3.1.2)\n`SetFractionalPointSize()` (not implemented in wx) function instead.","ref":"wxFont.html#setPointSize/2"},{"type":"function","title":"wxFont.setStyle/2","doc":"Sets the font style.\n\nSee: `getStyle/1`","ref":"wxFont.html#setStyle/2"},{"type":"function","title":"wxFont.setUnderlined/2","doc":"Sets underlining.\n\nSee: `getUnderlined/1`","ref":"wxFont.html#setUnderlined/2"},{"type":"function","title":"wxFont.setWeight/2","doc":"Sets the font weight.\n\nSee: `getWeight/1`","ref":"wxFont.html#setWeight/2"},{"type":"type","title":"wxFont.wxFont/0","doc":"","ref":"wxFont.html#t:wxFont/0"},{"type":"module","title":"wxFontData","doc":"Functions for wxFontData class\n\nThis class holds a variety of information related to font dialogs.\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_font),\n`m:wxFont`, `m:wxFontDialog`\n\nwxWidgets docs:\n[wxFontData](https://docs.wxwidgets.org/3.1/classwx_font_data.html)","ref":"wxFontData.html"},{"type":"function","title":"wxFontData.destroy/1","doc":"Destroys the object.","ref":"wxFontData.html#destroy/1"},{"type":"function","title":"wxFontData.enableEffects/2","doc":"Enables or disables \"effects\" under Windows or generic only.\n\nThis refers to the controls for manipulating colour, strikeout and underline\nproperties.\n\nThe default value is true.","ref":"wxFontData.html#enableEffects/2"},{"type":"function","title":"wxFontData.getAllowSymbols/1","doc":"Under Windows, returns a flag determining whether symbol fonts can be selected.\n\nHas no effect on other platforms.\n\nThe default value is true.","ref":"wxFontData.html#getAllowSymbols/1"},{"type":"function","title":"wxFontData.getChosenFont/1","doc":"Gets the font chosen by the user if the user pressed OK\n(`wxFontDialog::ShowModal()` (not implemented in wx) returned wxID_OK).","ref":"wxFontData.html#getChosenFont/1"},{"type":"function","title":"wxFontData.getColour/1","doc":"Gets the colour associated with the font dialog.\n\nThe default value is black.","ref":"wxFontData.html#getColour/1"},{"type":"function","title":"wxFontData.getEnableEffects/1","doc":"Determines whether \"effects\" are enabled under Windows.\n\nThis refers to the controls for manipulating colour, strikeout and underline\nproperties.\n\nThe default value is true.","ref":"wxFontData.html#getEnableEffects/1"},{"type":"function","title":"wxFontData.getInitialFont/1","doc":"Gets the font that will be initially used by the font dialog.\n\nThis should have previously been set by the application.","ref":"wxFontData.html#getInitialFont/1"},{"type":"function","title":"wxFontData.getShowHelp/1","doc":"Returns true if the Help button will be shown (Windows only).\n\nThe default value is false.","ref":"wxFontData.html#getShowHelp/1"},{"type":"function","title":"wxFontData.new/0","doc":"Constructor.\n\nInitializes `fontColour` to black, `showHelp` to false, `allowSymbols` to true,\n`enableEffects` to true, `minSize` to 0 and `maxSize` to 0.","ref":"wxFontData.html#new/0"},{"type":"function","title":"wxFontData.new/1","doc":"Copy Constructor.","ref":"wxFontData.html#new/1"},{"type":"function","title":"wxFontData.setAllowSymbols/2","doc":"Under Windows, determines whether symbol fonts can be selected.\n\nHas no effect on other platforms.\n\nThe default value is true.","ref":"wxFontData.html#setAllowSymbols/2"},{"type":"function","title":"wxFontData.setChosenFont/2","doc":"Sets the font that will be returned to the user (for internal use only).","ref":"wxFontData.html#setChosenFont/2"},{"type":"function","title":"wxFontData.setColour/2","doc":"Sets the colour that will be used for the font foreground colour.\n\nThe default colour is black.","ref":"wxFontData.html#setColour/2"},{"type":"function","title":"wxFontData.setInitialFont/2","doc":"Sets the font that will be initially used by the font dialog.","ref":"wxFontData.html#setInitialFont/2"},{"type":"function","title":"wxFontData.setRange/3","doc":"Sets the valid range for the font point size (Windows only).\n\nThe default is 0, 0 (unrestricted range).","ref":"wxFontData.html#setRange/3"},{"type":"function","title":"wxFontData.setShowHelp/2","doc":"Determines whether the Help button will be displayed in the font dialog (Windows\nonly).\n\nThe default value is false.","ref":"wxFontData.html#setShowHelp/2"},{"type":"type","title":"wxFontData.wxFontData/0","doc":"","ref":"wxFontData.html#t:wxFontData/0"},{"type":"module","title":"wxFontDialog","doc":"Functions for wxFontDialog class\n\nThis class represents the font chooser dialog.\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_font),\n`m:wxFontData`, ?wxGetFontFromUser()\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxFontDialog](https://docs.wxwidgets.org/3.1/classwx_font_dialog.html)","ref":"wxFontDialog.html"},{"type":"function","title":"wxFontDialog.create/3","doc":"Creates the dialog if the `m:wxFontDialog` object had been initialized using the\ndefault constructor.\n\nReturn: true on success and false if an error occurred.","ref":"wxFontDialog.html#create/3"},{"type":"function","title":"wxFontDialog.destroy/1","doc":"Destroys the object.","ref":"wxFontDialog.html#destroy/1"},{"type":"function","title":"wxFontDialog.getFontData/1","doc":"Returns the `m:wxFontData` associated with the font dialog.","ref":"wxFontDialog.html#getFontData/1"},{"type":"function","title":"wxFontDialog.new/0","doc":"Default ctor.\n\n`create/3` must be called before the dialog can be shown.","ref":"wxFontDialog.html#new/0"},{"type":"function","title":"wxFontDialog.new/2","doc":"Constructor.\n\nPass a parent window, and the `m:wxFontData` object to be used to initialize the\ndialog controls.","ref":"wxFontDialog.html#new/2"},{"type":"type","title":"wxFontDialog.wxFontDialog/0","doc":"","ref":"wxFontDialog.html#t:wxFontDialog/0"},{"type":"module","title":"wxFontPickerCtrl","doc":"Functions for wxFontPickerCtrl class\n\nThis control allows the user to select a font. The generic implementation is a\nbutton which brings up a `m:wxFontDialog` when clicked. Native implementation\nmay differ but this is usually a (small) widget which give access to the\nfont-chooser dialog. It is only available if `wxUSE_FONTPICKERCTRL` is set to 1\n(the default).\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxFontDialog`, `m:wxFontPickerEvent`\n\nThis class is derived (and can use functions) from: `m:wxPickerBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxFontPickerCtrl](https://docs.wxwidgets.org/3.1/classwx_font_picker_ctrl.html)","ref":"wxFontPickerCtrl.html"},{"type":"module","title":"Events - wxFontPickerCtrl","doc":"Event types emitted from this class:\n[`command_fontpicker_changed`](`m:wxFontPickerEvent`)","ref":"wxFontPickerCtrl.html#module-events"},{"type":"function","title":"wxFontPickerCtrl.create/3","doc":"","ref":"wxFontPickerCtrl.html#create/3"},{"type":"function","title":"wxFontPickerCtrl.create/4","doc":"Creates this widget with given parameters.\n\nReturn: true if the control was successfully created or false if creation\nfailed.","ref":"wxFontPickerCtrl.html#create/4"},{"type":"function","title":"wxFontPickerCtrl.destroy/1","doc":"Destroys the object.","ref":"wxFontPickerCtrl.html#destroy/1"},{"type":"function","title":"wxFontPickerCtrl.getMaxPointSize/1","doc":"Returns the maximum point size value allowed for the user-chosen font.","ref":"wxFontPickerCtrl.html#getMaxPointSize/1"},{"type":"function","title":"wxFontPickerCtrl.getSelectedFont/1","doc":"Returns the currently selected font.\n\nNote that this function is completely different from `wxWindow:getFont/1`.","ref":"wxFontPickerCtrl.html#getSelectedFont/1"},{"type":"function","title":"wxFontPickerCtrl.new/0","doc":"","ref":"wxFontPickerCtrl.html#new/0"},{"type":"function","title":"wxFontPickerCtrl.new/2","doc":"","ref":"wxFontPickerCtrl.html#new/2"},{"type":"function","title":"wxFontPickerCtrl.new/3","doc":"Initializes the object and calls `create/4` with all the parameters.","ref":"wxFontPickerCtrl.html#new/3"},{"type":"function","title":"wxFontPickerCtrl.setMaxPointSize/2","doc":"Sets the maximum point size value allowed for the user-chosen font.\n\nThe default value is 100. Note that big fonts can require a lot of memory and\nCPU time both for creation and for rendering; thus, specially because the user\nhas the option to specify the fontsize through a text control (see\nwxFNTP_USE_TEXTCTRL), it's a good idea to put a limit to the maximum font size\nwhen huge fonts do not make much sense.","ref":"wxFontPickerCtrl.html#setMaxPointSize/2"},{"type":"function","title":"wxFontPickerCtrl.setSelectedFont/2","doc":"Sets the currently selected font.\n\nNote that this function is completely different from `wxWindow:setFont/2`.","ref":"wxFontPickerCtrl.html#setSelectedFont/2"},{"type":"type","title":"wxFontPickerCtrl.wxFontPickerCtrl/0","doc":"","ref":"wxFontPickerCtrl.html#t:wxFontPickerCtrl/0"},{"type":"module","title":"wxFontPickerEvent","doc":"Functions for wxFontPickerEvent class\n\nThis event class is used for the events generated by `m:wxFontPickerCtrl`.\n\nSee: `m:wxFontPickerCtrl`\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxFontPickerEvent](https://docs.wxwidgets.org/3.1/classwx_font_picker_event.html)","ref":"wxFontPickerEvent.html"},{"type":"module","title":"Events - wxFontPickerEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxFontPickerEventType`](`t:wxFontPickerEventType/0`) to subscribe to events of\nthis type.","ref":"wxFontPickerEvent.html#module-events"},{"type":"function","title":"wxFontPickerEvent.getFont/1","doc":"Retrieve the font the user has just selected.","ref":"wxFontPickerEvent.html#getFont/1"},{"type":"type","title":"wxFontPickerEvent.wxFontPicker/0","doc":"","ref":"wxFontPickerEvent.html#t:wxFontPicker/0"},{"type":"type","title":"wxFontPickerEvent.wxFontPickerEvent/0","doc":"","ref":"wxFontPickerEvent.html#t:wxFontPickerEvent/0"},{"type":"type","title":"wxFontPickerEvent.wxFontPickerEventType/0","doc":"","ref":"wxFontPickerEvent.html#t:wxFontPickerEventType/0"},{"type":"module","title":"wxFrame","doc":"Functions for wxFrame class\n\nA frame is a window whose size and position can (usually) be changed by the\nuser.\n\nIt usually has thick borders and a title bar, and can optionally contain a menu\nbar, toolbar and status bar. A frame can contain any window that is not a frame\nor dialog.\n\nA frame that has a status bar and toolbar, created via the `createStatusBar/2`\nand `createToolBar/2` functions, manages these windows and adjusts the value\nreturned by `wxWindow:getClientSize/1` to reflect the remaining size available\nto application windows.\n\nRemark: An application should normally define an `m:wxCloseEvent` handler for\nthe frame to respond to system close events, for example so that related data\nand subwindows can be cleaned up.\n\nDefault event processing\n\n`m:wxFrame` processes the following events:\n\nStyles\n\nThis class supports the following styles:\n\nSee also the overview_windowstyles.\n\nExtra Styles\n\nThis class supports the following extra styles:\n\nSee: `m:wxMDIParentFrame`, `m:wxMDIChildFrame`, `m:wxMiniFrame`, `m:wxDialog`\n\nThis class is derived (and can use functions) from: `m:wxTopLevelWindow`\n`m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs: [wxFrame](https://docs.wxwidgets.org/3.1/classwx_frame.html)","ref":"wxFrame.html"},{"type":"module","title":"Events - wxFrame","doc":"Event types emitted from this class: [`close_window`](`m:wxCloseEvent`),\n[`iconize`](`m:wxIconizeEvent`), [`menu_open`](`m:wxMenuEvent`),\n[`menu_close`](`m:wxMenuEvent`), [`menu_highlight`](`m:wxMenuEvent`)","ref":"wxFrame.html#module-events"},{"type":"function","title":"wxFrame.create/4","doc":"","ref":"wxFrame.html#create/4"},{"type":"function","title":"wxFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxFrame.html#create/5"},{"type":"function","title":"wxFrame.createStatusBar/1","doc":"","ref":"wxFrame.html#createStatusBar/1"},{"type":"function","title":"wxFrame.createStatusBar/2","doc":"Creates a status bar at the bottom of the frame.\n\nReturn: A pointer to the status bar if it was created successfully, NULL\notherwise.\n\nRemark: The width of the status bar is the whole width of the frame (adjusted\nautomatically when resizing), and the height and text size are chosen by the\nhost windowing system.\n\nSee: `setStatusText/3`, `OnCreateStatusBar()` (not implemented in wx),\n`getStatusBar/1`","ref":"wxFrame.html#createStatusBar/2"},{"type":"function","title":"wxFrame.createToolBar/1","doc":"","ref":"wxFrame.html#createToolBar/1"},{"type":"function","title":"wxFrame.createToolBar/2","doc":"Creates a toolbar at the top or left of the frame.\n\nReturn: A pointer to the toolbar if it was created successfully, NULL otherwise.\n\nRemark: By default, the toolbar is an instance of `m:wxToolBar`. To use a\ndifferent class, override `OnCreateToolBar()` (not implemented in wx). When a\ntoolbar has been created with this function, or made known to the frame with\n`setToolBar/2`, the frame will manage the toolbar position and adjust the return\nvalue from `wxWindow:getClientSize/1` to reflect the available space for\napplication windows. Under Pocket PC, you should always use this function for\ncreating the toolbar to be managed by the frame, so that wxWidgets can use a\ncombined menubar and toolbar. Where you manage your own toolbars, create a\n`m:wxToolBar` as usual.\n\nSee: `createStatusBar/2`, `OnCreateToolBar()` (not implemented in wx),\n`setToolBar/2`, `getToolBar/1`","ref":"wxFrame.html#createToolBar/2"},{"type":"function","title":"wxFrame.destroy/1","doc":"Destructor.\n\nDestroys all child windows and menu bar if present.\n\nSee overview_windowdeletion for more info.","ref":"wxFrame.html#destroy/1"},{"type":"function","title":"wxFrame.getClientAreaOrigin/1","doc":"Returns the origin of the frame client area (in client coordinates).\n\nIt may be different from (0, 0) if the frame has a toolbar.","ref":"wxFrame.html#getClientAreaOrigin/1"},{"type":"function","title":"wxFrame.getMenuBar/1","doc":"Returns a pointer to the menubar currently associated with the frame (if any).\n\nSee: `setMenuBar/2`, `m:wxMenuBar`, `m:wxMenu`","ref":"wxFrame.html#getMenuBar/1"},{"type":"function","title":"wxFrame.getStatusBar/1","doc":"Returns a pointer to the status bar currently associated with the frame (if\nany).\n\nSee: `createStatusBar/2`, `m:wxStatusBar`","ref":"wxFrame.html#getStatusBar/1"},{"type":"function","title":"wxFrame.getStatusBarPane/1","doc":"Returns the status bar pane used to display menu and toolbar help.\n\nSee: `setStatusBarPane/2`","ref":"wxFrame.html#getStatusBarPane/1"},{"type":"function","title":"wxFrame.getToolBar/1","doc":"Returns a pointer to the toolbar currently associated with the frame (if any).\n\nSee: `createToolBar/2`, `m:wxToolBar`, `setToolBar/2`","ref":"wxFrame.html#getToolBar/1"},{"type":"function","title":"wxFrame.new/0","doc":"Default constructor.","ref":"wxFrame.html#new/0"},{"type":"function","title":"wxFrame.new/3","doc":"","ref":"wxFrame.html#new/3"},{"type":"function","title":"wxFrame.new/4","doc":"Constructor, creating the window.\n\nRemark: For Motif, MWM (the Motif Window Manager) should be running for any\nwindow styles to work (otherwise all styles take effect).\n\nSee: `create/5`","ref":"wxFrame.html#new/4"},{"type":"function","title":"wxFrame.processCommand/2","doc":"Simulate a menu command.","ref":"wxFrame.html#processCommand/2"},{"type":"function","title":"wxFrame.sendSizeEvent/1","doc":"","ref":"wxFrame.html#sendSizeEvent/1"},{"type":"function","title":"wxFrame.sendSizeEvent/2","doc":"This function sends a dummy `m:wxSizeEvent` to the window allowing it to\nre-layout its children positions.\n\nIt is sometimes useful to call this function after adding or deleting a children\nafter the frame creation or if a child size changes. Note that if the frame is\nusing either sizers or constraints for the children layout, it is enough to call\n`wxWindow:layout/1` directly and this function should not be used in this case.\n\nIf `flags` includes `wxSEND_EVENT_POST` value, this function posts the event,\ni.e. schedules it for later processing, instead of dispatching it directly. You\ncan also use `PostSizeEvent()` (not implemented in wx) as a more readable\nequivalent of calling this function with this flag.","ref":"wxFrame.html#sendSizeEvent/2"},{"type":"function","title":"wxFrame.setMenuBar/2","doc":"Tells the frame to show the given menu bar.\n\nRemark: If the frame is destroyed, the menu bar and its menus will be destroyed\nalso, so do not delete the menu bar explicitly (except by resetting the frame's\nmenu bar to another frame or NULL). Under Windows, a size event is generated, so\nbe sure to initialize data members properly before calling `setMenuBar/2`. Note\nthat on some platforms, it is not possible to call this function twice for the\nsame frame object.\n\nSee: `getMenuBar/1`, `m:wxMenuBar`, `m:wxMenu`","ref":"wxFrame.html#setMenuBar/2"},{"type":"function","title":"wxFrame.setStatusBar/2","doc":"Associates a status bar with the frame.\n\nIf `statusBar` is NULL, then the status bar, if present, is detached from the\nframe, but `not` deleted.\n\nSee: `createStatusBar/2`, `m:wxStatusBar`, `getStatusBar/1`","ref":"wxFrame.html#setStatusBar/2"},{"type":"function","title":"wxFrame.setStatusBarPane/2","doc":"Set the status bar pane used to display menu and toolbar help.\n\nUsing -1 disables help display.","ref":"wxFrame.html#setStatusBarPane/2"},{"type":"function","title":"wxFrame.setStatusText/2","doc":"","ref":"wxFrame.html#setStatusText/2"},{"type":"function","title":"wxFrame.setStatusText/3","doc":"Sets the status bar text and updates the status bar display.\n\nThis is a simple wrapper for `wxStatusBar:setStatusText/3` which doesn't do\nanything if the frame has no status bar, i.e. `getStatusBar/1` returns NULL.\n\nRemark: Use an empty string to clear the status bar.\n\nSee: `createStatusBar/2`, `m:wxStatusBar`","ref":"wxFrame.html#setStatusText/3"},{"type":"function","title":"wxFrame.setStatusWidths/2","doc":"Sets the widths of the fields in the status bar.\n\nRemark: The widths of the variable fields are calculated from the total width of\nall fields, minus the sum of widths of the non-variable fields, divided by the\nnumber of variable fields.","ref":"wxFrame.html#setStatusWidths/2"},{"type":"function","title":"wxFrame.setToolBar/2","doc":"Associates a toolbar with the frame.","ref":"wxFrame.html#setToolBar/2"},{"type":"type","title":"wxFrame.wxFrame/0","doc":"","ref":"wxFrame.html#t:wxFrame/0"},{"type":"module","title":"wxGBSizerItem","doc":"Functions for wxGBSizerItem class\n\nThe `m:wxGBSizerItem` class is used by the `m:wxGridBagSizer` for tracking the\nitems in the sizer. It adds grid position and spanning information to the normal\n`m:wxSizerItem` by adding `wxGBPosition` (not implemented in wx) and `wxGBSpan`\n(not implemented in wx) attributes. Most of the time you will not need to use a\n`m:wxGBSizerItem` directly in your code, but there are a couple of cases where\nit is handy.\n\nThis class is derived (and can use functions) from: `m:wxSizerItem`\n\nwxWidgets docs:\n[wxGBSizerItem](https://docs.wxwidgets.org/3.1/classwx_g_b_sizer_item.html)","ref":"wxGBSizerItem.html"},{"type":"type","title":"wxGBSizerItem.wxGBSizerItem/0","doc":"","ref":"wxGBSizerItem.html#t:wxGBSizerItem/0"},{"type":"module","title":"wxGCDC","doc":"Functions for wxGCDC class\n\n`m:wxGCDC` is a device context that draws on a `m:wxGraphicsContext`.\n\n`m:wxGCDC` does its best to implement `m:wxDC` API, but the following features\nare not (fully) implemented because `m:wxGraphicsContext` doesn't support them:\n\nSee: `m:wxDC`, `m:wxGraphicsContext`\n\nThis class is derived (and can use functions) from: `m:wxDC`\n\nwxWidgets docs: [wxGCDC](https://docs.wxwidgets.org/3.1/classwx_g_c_d_c.html)","ref":"wxGCDC.html"},{"type":"function","title":"wxGCDC.destroy/1","doc":"","ref":"wxGCDC.html#destroy/1"},{"type":"function","title":"wxGCDC.getGraphicsContext/1","doc":"Retrieves associated `m:wxGraphicsContext`.","ref":"wxGCDC.html#getGraphicsContext/1"},{"type":"function","title":"wxGCDC.new/0","doc":"","ref":"wxGCDC.html#new/0"},{"type":"function","title":"wxGCDC.new/1","doc":"Constructs a `m:wxGCDC` from a `m:wxWindowDC`.","ref":"wxGCDC.html#new/1"},{"type":"function","title":"wxGCDC.setGraphicsContext/2","doc":"Set the graphics context to be used for this `m:wxGCDC`.\n\nNote that this object takes ownership of `context` and will delete it when it is\ndestroyed or when `setGraphicsContext/2` is called again.\n\nAlso, unlike the constructor taking `m:wxGraphicsContext`, this method will\nreapply the current font, pen and brush, so that this object continues to use\nthem, if they had been changed before (which is never the case when constructing\n`m:wxGCDC` directly from `m:wxGraphicsContext`).","ref":"wxGCDC.html#setGraphicsContext/2"},{"type":"type","title":"wxGCDC.wxGCDC/0","doc":"","ref":"wxGCDC.html#t:wxGCDC/0"},{"type":"module","title":"wxGLCanvas","doc":"Functions for wxGLCanvas class\n\n`m:wxGLCanvas` is a class for displaying OpenGL graphics. It is always used in\nconjunction with `m:wxGLContext` as the context can only be made current (i.e.\nactive for the OpenGL commands) when it is associated to a `m:wxGLCanvas`.\n\nMore precisely, you first need to create a `m:wxGLCanvas` window and then create\nan instance of a `m:wxGLContext` that is initialized with this `m:wxGLCanvas`\nand then later use either `setCurrent/2` with the instance of the\n`m:wxGLContext` or `wxGLContext:setCurrent/2` with the instance of the\n`m:wxGLCanvas` (which might be not the same as was used for the creation of the\ncontext) to bind the OpenGL state that is represented by the rendering context\nto the canvas, and then finally call `swapBuffers/1` to swap the buffers of the\nOpenGL canvas and thus show your current output.\n\nPlease note that `m:wxGLContext` always uses physical pixels, even on the\nplatforms where `m:wxWindow` uses logical pixels, affected by the coordinate\nscaling, on high DPI displays. Thus, if you want to set the OpenGL view port to\nthe size of entire window, you must multiply the result returned by\n`wxWindow:getClientSize/1` by `wxWindow:getContentScaleFactor/1` before passing\nit to `glViewport()`. Same considerations apply to other OpenGL functions and\nother coordinates, notably those retrieved from `m:wxMouseEvent` in the event\nhandlers.\n\nNotice that versions of wxWidgets previous to 2.9 used to implicitly create a\n`m:wxGLContext` inside `m:wxGLCanvas` itself. This is still supported in the\ncurrent version but is deprecated now and will be removed in the future, please\nupdate your code to create the rendering contexts explicitly.\n\nTo set up the attributes for the canvas (number of bits for the depth buffer,\nnumber of bits for the stencil buffer and so on) you pass them in the\nconstructor using a `wxGLAttributes` (not implemented in wx) instance. You can\nstill use the way before 3.1.0 (setting up the correct values of the\n`attribList` parameter) but it's discouraged.\n\nNote: On those platforms which use a configure script (e.g. Linux and macOS)\nOpenGL support is automatically enabled if the relative headers and libraries\nare found. To switch it on under the other platforms (e.g. Windows), you need to\nedit the `setup.h` file and set `wxUSE_GLCANVAS` to `1` and then also pass\n`USE_OPENGL=1` to the make utility. You may also need to add `opengl32.lib` (and\n`glu32.lib` for old OpenGL versions) to the list of the libraries your program\nis linked with.\n\nSee: `m:wxGLContext`, `wxGLAttributes` (not implemented in wx),\n`wxGLContextAttrs` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxGLCanvas](https://docs.wxwidgets.org/3.1/classwx_g_l_canvas.html)","ref":"wxGLCanvas.html"},{"type":"function","title":"wxGLCanvas.createSurface/1","doc":"","ref":"wxGLCanvas.html#createSurface/1"},{"type":"function","title":"wxGLCanvas.destroy/1","doc":"Destroys the object.","ref":"wxGLCanvas.html#destroy/1"},{"type":"function","title":"wxGLCanvas.isDisplaySupported/1","doc":"Determines if a canvas having the specified attributes is available.\n\nThis only applies for visual attributes, not rendering context attributes.\nPlease, use the new form of this method, using `wxGLAttributes` (not implemented\nin wx).\n\nReturn: true if attributes are supported.","ref":"wxGLCanvas.html#isDisplaySupported/1"},{"type":"function","title":"wxGLCanvas.new/1","doc":"","ref":"wxGLCanvas.html#new/1"},{"type":"function","title":"wxGLCanvas.new/2","doc":"This constructor is still available only for compatibility reasons.\n\nPlease use the constructor with `wxGLAttributes` (not implemented in wx)\ninstead.\n\nIf `attribList` is not specified, `wxGLAttributes::PlatformDefaults()` (not\nimplemented in wx) is used, plus some other attributes (see below).","ref":"wxGLCanvas.html#new/2"},{"type":"function","title":"wxGLCanvas.setCurrent/2","doc":"Makes the OpenGL state that is represented by the OpenGL rendering context\n`context` current, i.e.\n\nit will be used by all subsequent OpenGL calls.\n\nThis is equivalent to `wxGLContext:setCurrent/2` called with this window as\nparameter.\n\nNote: This function may only be called when the window is shown on screen, in\nparticular it can't usually be called from the constructor as the window isn't\nyet shown at this moment.\n\nReturn: false if an error occurred.","ref":"wxGLCanvas.html#setCurrent/2"},{"type":"function","title":"wxGLCanvas.swapBuffers/1","doc":"Swaps the double-buffer of this window, making the back-buffer the front-buffer\nand vice versa, so that the output of the previous OpenGL commands is displayed\non the window.\n\nReturn: false if an error occurred.","ref":"wxGLCanvas.html#swapBuffers/1"},{"type":"type","title":"wxGLCanvas.wxGLCanvas/0","doc":"","ref":"wxGLCanvas.html#t:wxGLCanvas/0"},{"type":"module","title":"wxGLContext","doc":"Functions for wxGLContext class\n\nAn instance of a `m:wxGLContext` represents the state of an OpenGL state machine\nand the connection between OpenGL and the system.\n\nThe OpenGL state includes everything that can be set with the OpenGL API:\ncolors, rendering variables, buffer data ids, texture objects, etc. It is\npossible to have multiple rendering contexts share buffer data and textures.\nThis feature is specially useful when the application use multiple threads for\nupdating data into the memory of the graphics card.\n\nWhether one only rendering context is used with or bound to multiple output\nwindows or if each window has its own bound context is a developer decision. It\nis important to take into account that GPU makers may set different pointers to\nthe same OGL function for different contexts. The way these pointers are\nretrieved from the OGL driver should be used again for each new context.\n\nBinding (making current) a rendering context with another instance of a\n`m:wxGLCanvas` however works only if the both `m:wxGLCanvas` instances were\ncreated with the same attributes.\n\nOpenGL version 3 introduced a new type of specification profile, the modern core\nprofile. The old compatibility profile maintains all legacy features. Since\nwxWidgets 3.1.0 you can choose the type of context and even ask for a specified\nOGL version number. However, its advised to use only core profile as the\ncompatibility profile may run a bit slower.\n\nOpenGL core profile specification defines several flags at context creation that\ndetermine not only the type of context but also some features. Some of these\nflags can be set in the list of attributes used at `m:wxGLCanvas` ctor. But\nsince wxWidgets 3.1.0 it is strongly encouraged to use the new mechanism:\nsetting the context attributes with a `wxGLContextAttrs` (not implemented in wx)\nobject and the canvas attributes with a `wxGLAttributes` (not implemented in wx)\nobject.\n\nThe best way of knowing if your OpenGL environment supports a specific type of\ncontext is creating a `m:wxGLContext` instance and checking `isOK/1`. If it\nreturns false, then simply delete that instance and create a new one with other\nattributes.\n\nwxHAS_OPENGL_ES is defined on platforms that only have this implementation\navailable (e.g. the iPhone) and don't support the full specification.\n\nSee: `m:wxGLCanvas`, `wxGLContextAttrs` (not implemented in wx),\n`wxGLAttributes` (not implemented in wx)\n\nwxWidgets docs:\n[wxGLContext](https://docs.wxwidgets.org/3.1/classwx_g_l_context.html)","ref":"wxGLContext.html"},{"type":"function","title":"wxGLContext.destroy/1","doc":"Destroys the object.","ref":"wxGLContext.html#destroy/1"},{"type":"function","title":"wxGLContext.isOK/1","doc":"Checks if the underlying OpenGL rendering context was correctly created by the\nsystem with the requested attributes.\n\nIf this function returns false then the `m:wxGLContext` object is useless and\nshould be deleted and recreated with different attributes.\n\nSince: 3.1.0","ref":"wxGLContext.html#isOK/1"},{"type":"function","title":"wxGLContext.new/1","doc":"","ref":"wxGLContext.html#new/1"},{"type":"function","title":"wxGLContext.new/2","doc":"Constructor.","ref":"wxGLContext.html#new/2"},{"type":"function","title":"wxGLContext.setCurrent/2","doc":"Makes the OpenGL state that is represented by this rendering context current\nwith the `m:wxGLCanvas` `win`.\n\nNote: `win` can be a different `m:wxGLCanvas` window than the one that was\npassed to the constructor of this rendering context. If `RC` is an object of\ntype `m:wxGLContext`, the statements `\"RC.SetCurrent(win);\"` and\n`\"win.SetCurrent(RC);\"` are equivalent, see `wxGLCanvas:setCurrent/2`.","ref":"wxGLContext.html#setCurrent/2"},{"type":"type","title":"wxGLContext.wxGLContext/0","doc":"","ref":"wxGLContext.html#t:wxGLContext/0"},{"type":"module","title":"wxGauge","doc":"Functions for wxGauge class\n\nA gauge is a horizontal or vertical bar which shows a quantity (often time).\n\n`m:wxGauge` supports two working modes: determinate and indeterminate progress.\n\nThe first is the usual working mode (see `setValue/2` and `setRange/2`) while\nthe second can be used when the program is doing some processing but you don't\nknow how much progress is being done. In this case, you can periodically call\nthe `pulse/1` function to make the progress bar switch to indeterminate mode\n(graphically it's usually a set of blocks which move or bounce in the bar\ncontrol).\n\n`m:wxGauge` supports dynamic switch between these two work modes.\n\nThere are no user commands for the gauge.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxSlider`, `m:wxScrollBar`\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs: [wxGauge](https://docs.wxwidgets.org/3.1/classwx_gauge.html)","ref":"wxGauge.html"},{"type":"function","title":"wxGauge.create/4","doc":"","ref":"wxGauge.html#create/4"},{"type":"function","title":"wxGauge.create/5","doc":"Creates the gauge for two-step construction.\n\nSee `new/4` for further details.","ref":"wxGauge.html#create/5"},{"type":"function","title":"wxGauge.destroy/1","doc":"Destructor, destroying the gauge.","ref":"wxGauge.html#destroy/1"},{"type":"function","title":"wxGauge.getRange/1","doc":"Returns the maximum position of the gauge.\n\nSee: `setRange/2`","ref":"wxGauge.html#getRange/1"},{"type":"function","title":"wxGauge.getValue/1","doc":"Returns the current position of the gauge.\n\nSee: `setValue/2`","ref":"wxGauge.html#getValue/1"},{"type":"function","title":"wxGauge.isVertical/1","doc":"Returns true if the gauge is vertical (has `wxGA_VERTICAL` style) and false\notherwise.","ref":"wxGauge.html#isVertical/1"},{"type":"function","title":"wxGauge.new/0","doc":"Default constructor.","ref":"wxGauge.html#new/0"},{"type":"function","title":"wxGauge.new/3","doc":"","ref":"wxGauge.html#new/3"},{"type":"function","title":"wxGauge.new/4","doc":"Constructor, creating and showing a gauge.\n\nSee: `create/5`","ref":"wxGauge.html#new/4"},{"type":"function","title":"wxGauge.pulse/1","doc":"Switch the gauge to indeterminate mode (if required) and makes the gauge move a\nbit to indicate the user that some progress has been made.\n\nNote: After calling this function the value returned by `getValue/1` is\nundefined and thus you need to explicitly call `setValue/2` if you want to\nrestore the determinate mode.","ref":"wxGauge.html#pulse/1"},{"type":"function","title":"wxGauge.setRange/2","doc":"Sets the range (maximum value) of the gauge.\n\nThis function makes the gauge switch to determinate mode, if it's not already.\n\nWhen the gauge is in indeterminate mode, under wxMSW the gauge repeatedly goes\nfrom zero to `range` and back; under other ports when in indeterminate mode, the\n`range` setting is ignored.\n\nSee: `getRange/1`","ref":"wxGauge.html#setRange/2"},{"type":"function","title":"wxGauge.setValue/2","doc":"Sets the position of the gauge.\n\nThe `pos` must be between 0 and the gauge range as returned by `getRange/1`,\ninclusive.\n\nThis function makes the gauge switch to determinate mode, if it was in\nindeterminate mode before.\n\nSee: `getValue/1`","ref":"wxGauge.html#setValue/2"},{"type":"type","title":"wxGauge.wxGauge/0","doc":"","ref":"wxGauge.html#t:wxGauge/0"},{"type":"module","title":"wxGenericDirCtrl","doc":"Functions for wxGenericDirCtrl class\n\nThis control can be used to place a directory listing (with optional files) on\nan arbitrary window.\n\nThe control contains a `m:wxTreeCtrl` window representing the directory\nhierarchy, and optionally, a `m:wxChoice` window containing a list of filters.\n\nStyles\n\nThis class supports the following styles:\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxGenericDirCtrl](https://docs.wxwidgets.org/3.1/classwx_generic_dir_ctrl.html)","ref":"wxGenericDirCtrl.html"},{"type":"module","title":"Events - wxGenericDirCtrl","doc":"Event types emitted from this class:\n[`dirctrl_selectionchanged`](`m:wxTreeEvent`),\n[`dirctrl_fileactivated`](`m:wxTreeEvent`)","ref":"wxGenericDirCtrl.html#module-events"},{"type":"function","title":"wxGenericDirCtrl.collapseTree/1","doc":"Collapses the entire tree.","ref":"wxGenericDirCtrl.html#collapseTree/1"},{"type":"function","title":"wxGenericDirCtrl.create/2","doc":"","ref":"wxGenericDirCtrl.html#create/2"},{"type":"function","title":"wxGenericDirCtrl.create/3","doc":"Create function for two-step construction.\n\nSee `new/2` for details.","ref":"wxGenericDirCtrl.html#create/3"},{"type":"function","title":"wxGenericDirCtrl.destroy/1","doc":"Destructor.","ref":"wxGenericDirCtrl.html#destroy/1"},{"type":"function","title":"wxGenericDirCtrl.expandPath/2","doc":"Tries to expand as much of the given `path` as possible, so that the filename or\ndirectory is visible in the tree control.","ref":"wxGenericDirCtrl.html#expandPath/2"},{"type":"function","title":"wxGenericDirCtrl.getDefaultPath/1","doc":"Gets the default path.","ref":"wxGenericDirCtrl.html#getDefaultPath/1"},{"type":"function","title":"wxGenericDirCtrl.getFilePath/1","doc":"Gets selected filename path only (else empty string).\n\nThis function doesn't count a directory as a selection.","ref":"wxGenericDirCtrl.html#getFilePath/1"},{"type":"function","title":"wxGenericDirCtrl.getFilter/1","doc":"Returns the filter string.","ref":"wxGenericDirCtrl.html#getFilter/1"},{"type":"function","title":"wxGenericDirCtrl.getFilterIndex/1","doc":"Returns the current filter index (zero-based).","ref":"wxGenericDirCtrl.html#getFilterIndex/1"},{"type":"function","title":"wxGenericDirCtrl.getPath/1","doc":"Gets the currently-selected directory or filename.","ref":"wxGenericDirCtrl.html#getPath/1"},{"type":"function","title":"wxGenericDirCtrl.getPath/2","doc":"Gets the path corresponding to the given tree control item.\n\nSince: 2.9.5","ref":"wxGenericDirCtrl.html#getPath/2"},{"type":"function","title":"wxGenericDirCtrl.getRootId/1","doc":"Returns the root id for the tree control.","ref":"wxGenericDirCtrl.html#getRootId/1"},{"type":"function","title":"wxGenericDirCtrl.getTreeCtrl/1","doc":"Returns a pointer to the tree control.","ref":"wxGenericDirCtrl.html#getTreeCtrl/1"},{"type":"function","title":"wxGenericDirCtrl.init/1","doc":"Initializes variables.","ref":"wxGenericDirCtrl.html#init/1"},{"type":"function","title":"wxGenericDirCtrl.new/0","doc":"Default constructor.","ref":"wxGenericDirCtrl.html#new/0"},{"type":"function","title":"wxGenericDirCtrl.new/1","doc":"","ref":"wxGenericDirCtrl.html#new/1"},{"type":"function","title":"wxGenericDirCtrl.new/2","doc":"Main constructor.","ref":"wxGenericDirCtrl.html#new/2"},{"type":"function","title":"wxGenericDirCtrl.reCreateTree/1","doc":"Collapse and expand the tree, thus re-creating it from scratch.\n\nMay be used to update the displayed directory content.","ref":"wxGenericDirCtrl.html#reCreateTree/1"},{"type":"function","title":"wxGenericDirCtrl.setDefaultPath/2","doc":"Sets the default path.","ref":"wxGenericDirCtrl.html#setDefaultPath/2"},{"type":"function","title":"wxGenericDirCtrl.setFilter/2","doc":"Sets the filter string.","ref":"wxGenericDirCtrl.html#setFilter/2"},{"type":"function","title":"wxGenericDirCtrl.setFilterIndex/2","doc":"Sets the current filter index (zero-based).","ref":"wxGenericDirCtrl.html#setFilterIndex/2"},{"type":"function","title":"wxGenericDirCtrl.setPath/2","doc":"Sets the current path.","ref":"wxGenericDirCtrl.html#setPath/2"},{"type":"type","title":"wxGenericDirCtrl.wxGenericDirCtrl/0","doc":"","ref":"wxGenericDirCtrl.html#t:wxGenericDirCtrl/0"},{"type":"module","title":"wxGraphicsBrush","doc":"Functions for wxGraphicsBrush class\n\nA `m:wxGraphicsBrush` is a native representation of a brush. The contents are\nspecific and private to the respective renderer. Instances are ref counted and\ncan therefore be assigned as usual. The only way to get a valid instance is via\n`wxGraphicsContext:createBrush/2` or `wxGraphicsRenderer:createBrush/2`.\n\nThis class is derived (and can use functions) from: `m:wxGraphicsObject`\n\nwxWidgets docs:\n[wxGraphicsBrush](https://docs.wxwidgets.org/3.1/classwx_graphics_brush.html)","ref":"wxGraphicsBrush.html"},{"type":"type","title":"wxGraphicsBrush.wxGraphicsBrush/0","doc":"","ref":"wxGraphicsBrush.html#t:wxGraphicsBrush/0"},{"type":"module","title":"wxGraphicsContext","doc":"Functions for wxGraphicsContext class\n\nA `m:wxGraphicsContext` instance is the object that is drawn upon. It is created\nby a renderer using `wxGraphicsRenderer:createContext/2`. This can be either\ndirectly using a renderer instance, or indirectly using the static convenience\n`create/1` functions of `m:wxGraphicsContext` that always delegate the task to\nthe default renderer.\n\nRemark: For some renderers (like Direct2D or Cairo) processing of drawing\noperations may be deferred (Direct2D render target normally builds up a batch of\nrendering commands but defers processing of these commands, Cairo operates on a\nseparate surface) so to make drawing results visible you need to update the\ncontent of the context by calling `wxGraphicsContext::Flush()` (not implemented\nin wx) or by destroying the context.\n\nSee: `wxGraphicsRenderer:createContext/2`, `m:wxGCDC`, `m:wxDC`\n\nThis class is derived (and can use functions) from: `m:wxGraphicsObject`\n\nwxWidgets docs:\n[wxGraphicsContext](https://docs.wxwidgets.org/3.1/classwx_graphics_context.html)","ref":"wxGraphicsContext.html"},{"type":"function","title":"wxGraphicsContext.clip/2","doc":"Sets the clipping region to the intersection of the given region and the\npreviously set clipping region.\n\nThe clipping region is an area to which drawing is restricted.\n\nRemark:","ref":"wxGraphicsContext.html#clip/2"},{"type":"function","title":"wxGraphicsContext.clip/5","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxGraphicsContext.html#clip/5"},{"type":"function","title":"wxGraphicsContext.concatTransform/2","doc":"Concatenates the passed in transform with the current transform of this context.","ref":"wxGraphicsContext.html#concatTransform/2"},{"type":"function","title":"wxGraphicsContext.create/0","doc":"Create a lightweight context that can be used only for measuring text.","ref":"wxGraphicsContext.html#create/0"},{"type":"function","title":"wxGraphicsContext.create/1","doc":"Creates a `m:wxGraphicsContext` from a `m:wxWindowDC`.\n\nSee: `wxGraphicsRenderer:createContext/2`","ref":"wxGraphicsContext.html#create/1"},{"type":"function","title":"wxGraphicsContext.createBrush/2","doc":"Creates a native brush from a `m:wxBrush`.","ref":"wxGraphicsContext.html#createBrush/2"},{"type":"function","title":"wxGraphicsContext.createFont/2","doc":"","ref":"wxGraphicsContext.html#createFont/2"},{"type":"function","title":"wxGraphicsContext.createFont/3","doc":"Creates a native graphics font from a `m:wxFont` and a text colour.\n\nRemark: For Direct2D graphics fonts can be created from TrueType fonts only.","ref":"wxGraphicsContext.html#createFont/3"},{"type":"function","title":"wxGraphicsContext.createFont/4","doc":"Creates a font object with the specified attributes.\n\nThe use of overload taking `m:wxFont` is preferred, see\n`wxGraphicsRenderer:createFont/4` for more details.\n\nRemark: For Direct2D graphics fonts can be created from TrueType fonts only.\n\nSince: 2.9.3","ref":"wxGraphicsContext.html#createFont/4"},{"type":"function","title":"wxGraphicsContext.createLinearGradientBrush/6","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxGraphicsContext.html#createLinearGradientBrush/6"},{"type":"function","title":"wxGraphicsContext.createLinearGradientBrush/7","doc":"`Creates a native brush with a linear gradient. The brush starts at (@a x1, @a y1) and ends at (@a x2, @a y2). Either just the start and end gradient colours (@a c1 and @a c2) or full set of gradient @a stops can be specified. The version taking wxGraphicsGradientStops is new in wxWidgets 2.9.1.`\n\nThe `matrix` parameter was added in wxWidgets 3.1.3","ref":"wxGraphicsContext.html#createLinearGradientBrush/7"},{"type":"function","title":"wxGraphicsContext.createMatrix/1","doc":"","ref":"wxGraphicsContext.html#createMatrix/1"},{"type":"function","title":"wxGraphicsContext.createMatrix/2","doc":"Creates a native affine transformation matrix from the passed in values.\n\nThe default parameters result in an identity matrix.","ref":"wxGraphicsContext.html#createMatrix/2"},{"type":"function","title":"wxGraphicsContext.createPath/1","doc":"Creates a native graphics path which is initially empty.","ref":"wxGraphicsContext.html#createPath/1"},{"type":"function","title":"wxGraphicsContext.createPen/2","doc":"Creates a native pen from a `m:wxPen`.\n\nPrefer to use the overload taking `wxGraphicsPenInfo` (not implemented in wx)\nunless you already have a `m:wxPen` as constructing one only to pass it to this\nmethod is wasteful.","ref":"wxGraphicsContext.html#createPen/2"},{"type":"function","title":"wxGraphicsContext.createRadialGradientBrush/7","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxGraphicsContext.html#createRadialGradientBrush/7"},{"type":"function","title":"wxGraphicsContext.createRadialGradientBrush/8","doc":"`Creates a native brush with a radial gradient. The brush originates at (@a startX, @a startY) and ends on a circle around (@a endX, @a endY) with the given @a radius. The gradient may be specified either by its start and end colours @a oColor and @a cColor or by a full set of gradient @a stops. The version taking wxGraphicsGradientStops is new in wxWidgets 2.9.1.`\n\nThe ability to apply a transformation matrix to the gradient was added in 3.1.3","ref":"wxGraphicsContext.html#createRadialGradientBrush/8"},{"type":"function","title":"wxGraphicsContext.destroy/1","doc":"Creates a `m:wxGraphicsContext` from a `m:wxWindow`.\n\nSee: `wxGraphicsRenderer:createContext/2`","ref":"wxGraphicsContext.html#destroy/1"},{"type":"function","title":"wxGraphicsContext.drawBitmap/6","doc":"Draws the bitmap.\n\nIn case of a mono bitmap, this is treated as a mask and the current brushed is\nused for filling.","ref":"wxGraphicsContext.html#drawBitmap/6"},{"type":"function","title":"wxGraphicsContext.drawEllipse/5","doc":"Draws an ellipse.","ref":"wxGraphicsContext.html#drawEllipse/5"},{"type":"function","title":"wxGraphicsContext.drawIcon/6","doc":"Draws the icon.","ref":"wxGraphicsContext.html#drawIcon/6"},{"type":"function","title":"wxGraphicsContext.drawLines/2","doc":"","ref":"wxGraphicsContext.html#drawLines/2"},{"type":"function","title":"wxGraphicsContext.drawLines/3","doc":"Draws a polygon.","ref":"wxGraphicsContext.html#drawLines/3"},{"type":"function","title":"wxGraphicsContext.drawPath/2","doc":"","ref":"wxGraphicsContext.html#drawPath/2"},{"type":"function","title":"wxGraphicsContext.drawPath/3","doc":"Draws the path by first filling and then stroking.","ref":"wxGraphicsContext.html#drawPath/3"},{"type":"function","title":"wxGraphicsContext.drawRectangle/5","doc":"Draws a rectangle.","ref":"wxGraphicsContext.html#drawRectangle/5"},{"type":"function","title":"wxGraphicsContext.drawRoundedRectangle/6","doc":"Draws a rounded rectangle.","ref":"wxGraphicsContext.html#drawRoundedRectangle/6"},{"type":"function","title":"wxGraphicsContext.drawText/4","doc":"Draws text at the defined position.","ref":"wxGraphicsContext.html#drawText/4"},{"type":"function","title":"wxGraphicsContext.drawText/5","doc":"Draws text at the defined position.","ref":"wxGraphicsContext.html#drawText/5"},{"type":"function","title":"wxGraphicsContext.drawText/6","doc":"Draws text at the defined position.","ref":"wxGraphicsContext.html#drawText/6"},{"type":"function","title":"wxGraphicsContext.fillPath/2","doc":"","ref":"wxGraphicsContext.html#fillPath/2"},{"type":"function","title":"wxGraphicsContext.fillPath/3","doc":"Fills the path with the current brush.","ref":"wxGraphicsContext.html#fillPath/3"},{"type":"function","title":"wxGraphicsContext.getPartialTextExtents/2","doc":"Fills the `widths` array with the widths from the beginning of `text` to the\ncorresponding character of `text`.","ref":"wxGraphicsContext.html#getPartialTextExtents/2"},{"type":"function","title":"wxGraphicsContext.getTextExtent/2","doc":"Gets the dimensions of the string using the currently selected font.","ref":"wxGraphicsContext.html#getTextExtent/2"},{"type":"function","title":"wxGraphicsContext.getTransform/1","doc":"Gets the current transformation matrix of this context.","ref":"wxGraphicsContext.html#getTransform/1"},{"type":"function","title":"wxGraphicsContext.resetClip/1","doc":"Resets the clipping to original shape.","ref":"wxGraphicsContext.html#resetClip/1"},{"type":"function","title":"wxGraphicsContext.rotate/2","doc":"Rotates the current transformation matrix (in radians).","ref":"wxGraphicsContext.html#rotate/2"},{"type":"function","title":"wxGraphicsContext.scale/3","doc":"Scales the current transformation matrix.","ref":"wxGraphicsContext.html#scale/3"},{"type":"function","title":"wxGraphicsContext.setBrush/2","doc":"Sets the brush for filling paths.","ref":"wxGraphicsContext.html#setBrush/2"},{"type":"function","title":"wxGraphicsContext.setFont/2","doc":"Sets the font for drawing text.","ref":"wxGraphicsContext.html#setFont/2"},{"type":"function","title":"wxGraphicsContext.setFont/3","doc":"Sets the font for drawing text.\n\nRemark: For Direct2D only TrueType fonts can be used.","ref":"wxGraphicsContext.html#setFont/3"},{"type":"function","title":"wxGraphicsContext.setPen/2","doc":"Sets the pen used for stroking.","ref":"wxGraphicsContext.html#setPen/2"},{"type":"function","title":"wxGraphicsContext.setTransform/2","doc":"Sets the current transformation matrix of this context.","ref":"wxGraphicsContext.html#setTransform/2"},{"type":"function","title":"wxGraphicsContext.strokeLine/5","doc":"Strokes a single line.","ref":"wxGraphicsContext.html#strokeLine/5"},{"type":"function","title":"wxGraphicsContext.strokeLines/2","doc":"Stroke lines connecting all the points.\n\nUnlike the other overload of this function, this method draws a single polyline\nand not a number of disconnected lines.","ref":"wxGraphicsContext.html#strokeLines/2"},{"type":"function","title":"wxGraphicsContext.strokePath/2","doc":"Strokes along a path with the current pen.","ref":"wxGraphicsContext.html#strokePath/2"},{"type":"function","title":"wxGraphicsContext.translate/3","doc":"Translates the current transformation matrix.","ref":"wxGraphicsContext.html#translate/3"},{"type":"type","title":"wxGraphicsContext.wxGraphicsContext/0","doc":"","ref":"wxGraphicsContext.html#t:wxGraphicsContext/0"},{"type":"module","title":"wxGraphicsFont","doc":"Functions for wxGraphicsFont class\n\nA `m:wxGraphicsFont` is a native representation of a font. The contents are\nspecific and private to the respective renderer. Instances are ref counted and\ncan therefore be assigned as usual. The only way to get a valid instance is via\n`wxGraphicsContext:createFont/4` or `wxGraphicsRenderer:createFont/4`.\n\nThis class is derived (and can use functions) from: `m:wxGraphicsObject`\n\nwxWidgets docs:\n[wxGraphicsFont](https://docs.wxwidgets.org/3.1/classwx_graphics_font.html)","ref":"wxGraphicsFont.html"},{"type":"type","title":"wxGraphicsFont.wxGraphicsFont/0","doc":"","ref":"wxGraphicsFont.html#t:wxGraphicsFont/0"},{"type":"module","title":"wxGraphicsGradientStops","doc":"Represents a collection of wxGraphicGradientStop values for use with\nCreateLinearGradientBrush and CreateRadialGradientBrush.\n\nThe stops are maintained in order of position. If two or more stops are added\nwith the same position then the one(s) added later come later. This can be\nuseful for producing discontinuities in the colour gradient.\n\nNotice that this class is write-once, you can't modify the stops once they had\nbeen added.\n\nSince: 2.9.1\n\nwxWidgets docs:\n[wxGraphicsGradientStops](https://docs.wxwidgets.org/3.1/classwx_graphics_gradient_stops.html)","ref":"wxGraphicsGradientStops.html"},{"type":"function","title":"wxGraphicsGradientStops.add/3","doc":"Add a new stop.","ref":"wxGraphicsGradientStops.html#add/3"},{"type":"function","title":"wxGraphicsGradientStops.destroy/1","doc":"Destroys the object.","ref":"wxGraphicsGradientStops.html#destroy/1"},{"type":"function","title":"wxGraphicsGradientStops.getCount/1","doc":"Returns the number of stops.","ref":"wxGraphicsGradientStops.html#getCount/1"},{"type":"function","title":"wxGraphicsGradientStops.getEndColour/1","doc":"Returns the end colour.","ref":"wxGraphicsGradientStops.html#getEndColour/1"},{"type":"function","title":"wxGraphicsGradientStops.getStartColour/1","doc":"Returns the start colour.","ref":"wxGraphicsGradientStops.html#getStartColour/1"},{"type":"function","title":"wxGraphicsGradientStops.item/2","doc":"Returns the stop at the given index.","ref":"wxGraphicsGradientStops.html#item/2"},{"type":"function","title":"wxGraphicsGradientStops.new/0","doc":"","ref":"wxGraphicsGradientStops.html#new/0"},{"type":"function","title":"wxGraphicsGradientStops.new/1","doc":"Initializes the gradient stops with the given boundary colours.\n\nCreates a `m:wxGraphicsGradientStops` instance with start colour given by\n`startCol` and end colour given by `endCol`.","ref":"wxGraphicsGradientStops.html#new/1"},{"type":"function","title":"wxGraphicsGradientStops.setEndColour/2","doc":"Set the end colour to `col`.","ref":"wxGraphicsGradientStops.html#setEndColour/2"},{"type":"function","title":"wxGraphicsGradientStops.setStartColour/2","doc":"Set the start colour to `col`.","ref":"wxGraphicsGradientStops.html#setStartColour/2"},{"type":"type","title":"wxGraphicsGradientStops.wxGraphicsGradientStops/0","doc":"","ref":"wxGraphicsGradientStops.html#t:wxGraphicsGradientStops/0"},{"type":"module","title":"wxGraphicsMatrix","doc":"Functions for wxGraphicsMatrix class\n\nA `m:wxGraphicsMatrix` is a native representation of an affine matrix. The\ncontents are specific and private to the respective renderer. Instances are ref\ncounted and can therefore be assigned as usual. The only way to get a valid\ninstance is via `wxGraphicsContext:createMatrix/2` or\n`wxGraphicsRenderer:createMatrix/2`.\n\nThis class is derived (and can use functions) from: `m:wxGraphicsObject`\n\nwxWidgets docs:\n[wxGraphicsMatrix](https://docs.wxwidgets.org/3.1/classwx_graphics_matrix.html)","ref":"wxGraphicsMatrix.html"},{"type":"function","title":"wxGraphicsMatrix.concat/2","doc":"Concatenates the matrix passed with the current matrix.\n\nThe effect of the resulting transformation is to first apply the transformation\nin `t` to the coordinates and then apply the transformation in the current\nmatrix to the coordinates.","ref":"wxGraphicsMatrix.html#concat/2"},{"type":"function","title":"wxGraphicsMatrix.get/1","doc":"Returns the component values of the matrix via the argument pointers.","ref":"wxGraphicsMatrix.html#get/1"},{"type":"function","title":"wxGraphicsMatrix.invert/1","doc":"Inverts the matrix.","ref":"wxGraphicsMatrix.html#invert/1"},{"type":"function","title":"wxGraphicsMatrix.isEqual/2","doc":"Returns true if the elements of the transformation matrix are equal.","ref":"wxGraphicsMatrix.html#isEqual/2"},{"type":"function","title":"wxGraphicsMatrix.isIdentity/1","doc":"Return true if this is the identity matrix.","ref":"wxGraphicsMatrix.html#isIdentity/1"},{"type":"function","title":"wxGraphicsMatrix.rotate/2","doc":"Rotates this matrix clockwise (in radians).","ref":"wxGraphicsMatrix.html#rotate/2"},{"type":"function","title":"wxGraphicsMatrix.scale/3","doc":"Scales this matrix.","ref":"wxGraphicsMatrix.html#scale/3"},{"type":"function","title":"wxGraphicsMatrix.set/1","doc":"","ref":"wxGraphicsMatrix.html#set/1"},{"type":"function","title":"wxGraphicsMatrix.set/2","doc":"Sets the matrix to the respective values (default values are the identity\nmatrix).","ref":"wxGraphicsMatrix.html#set/2"},{"type":"function","title":"wxGraphicsMatrix.transformDistance/1","doc":"Applies this matrix to a distance (ie.\n\nperforms all transforms except translations).","ref":"wxGraphicsMatrix.html#transformDistance/1"},{"type":"function","title":"wxGraphicsMatrix.transformPoint/1","doc":"Applies this matrix to a point.","ref":"wxGraphicsMatrix.html#transformPoint/1"},{"type":"function","title":"wxGraphicsMatrix.translate/3","doc":"Translates this matrix.","ref":"wxGraphicsMatrix.html#translate/3"},{"type":"type","title":"wxGraphicsMatrix.wxGraphicsMatrix/0","doc":"","ref":"wxGraphicsMatrix.html#t:wxGraphicsMatrix/0"},{"type":"module","title":"wxGraphicsObject","doc":"Functions for wxGraphicsObject class\n\nThis class is the superclass of native graphics objects like pens etc. It allows\nreference counting. Not instantiated by user code.\n\nSee: `m:wxGraphicsBrush`, `m:wxGraphicsPen`, `m:wxGraphicsMatrix`,\n`m:wxGraphicsPath`\n\nwxWidgets docs:\n[wxGraphicsObject](https://docs.wxwidgets.org/3.1/classwx_graphics_object.html)","ref":"wxGraphicsObject.html"},{"type":"function","title":"wxGraphicsObject.destroy/1","doc":"","ref":"wxGraphicsObject.html#destroy/1"},{"type":"function","title":"wxGraphicsObject.getRenderer/1","doc":"Returns the renderer that was used to create this instance, or NULL if it has\nnot been initialized yet.","ref":"wxGraphicsObject.html#getRenderer/1"},{"type":"function","title":"wxGraphicsObject.isNull/1","doc":"Return: false if this object is valid, otherwise returns true.","ref":"wxGraphicsObject.html#isNull/1"},{"type":"type","title":"wxGraphicsObject.wxGraphicsObject/0","doc":"","ref":"wxGraphicsObject.html#t:wxGraphicsObject/0"},{"type":"module","title":"wxGraphicsPath","doc":"Functions for wxGraphicsPath class\n\nA `m:wxGraphicsPath` is a native representation of a geometric path. The\ncontents are specific and private to the respective renderer. Instances are\nreference counted and can therefore be assigned as usual. The only way to get a\nvalid instance is by using `wxGraphicsContext:createPath/1` or\n`wxGraphicsRenderer:createPath/1`.\n\nThis class is derived (and can use functions) from: `m:wxGraphicsObject`\n\nwxWidgets docs:\n[wxGraphicsPath](https://docs.wxwidgets.org/3.1/classwx_graphics_path.html)","ref":"wxGraphicsPath.html"},{"type":"function","title":"wxGraphicsPath.addArc/6","doc":"","ref":"wxGraphicsPath.html#addArc/6"},{"type":"function","title":"wxGraphicsPath.addArc/7","doc":"Adds an arc of a circle.\n\nThe circle is defined by the coordinates of its centre (`x`, `y`) or `c` and its\nradius `r`. The arc goes from the starting angle `startAngle` to `endAngle`\neither clockwise or counter-clockwise depending on the value of `clockwise`\nargument.\n\nThe angles are measured in radians but, contrary to the usual mathematical\nconvention, are always `clockwise` from the horizontal axis.\n\nIf for clockwise arc `endAngle` is less than `startAngle` it will be\nprogressively increased by 2*pi until it is greater than `startAngle`. If for\ncounter-clockwise arc `endAngle` is greater than `startAngle` it will be\nprogressively decreased by 2*pi until it is less than `startAngle`.\n\nIf there is a current point set, an initial line segment will be added to the\npath to connect the current point to the beginning of the arc.","ref":"wxGraphicsPath.html#addArc/7"},{"type":"function","title":"wxGraphicsPath.addArcToPoint/6","doc":"Adds an arc (of a circle with radius `r`) that is tangent to the line connecting\ncurrent point and (`x1`, `y1`) and to the line connecting (`x1`, `y1`) and\n(`x2`, `y2`).\n\nIf the current point and the starting point of the arc are different, a straight\nline connecting these points is also appended. If there is no current point\nbefore the call to `addArcToPoint/6` this function will behave as if preceded by\na call to MoveToPoint(0, 0). After this call the current point will be at the\nending point of the arc.","ref":"wxGraphicsPath.html#addArcToPoint/6"},{"type":"function","title":"wxGraphicsPath.addCircle/4","doc":"Appends a circle around (`x`,`y`) with radius `r` as a new closed subpath.\n\nAfter this call the current point will be at (x+`r`, `y`).","ref":"wxGraphicsPath.html#addCircle/4"},{"type":"function","title":"wxGraphicsPath.addCurveToPoint/4","doc":"Adds a cubic bezier curve from the current point, using two control points and\nan end point.\n\nIf there is no current point before the call to `addCurveToPoint/7` this\nfunction will behave as if preceded by a call to MoveToPoint(`c1`).","ref":"wxGraphicsPath.html#addCurveToPoint/4"},{"type":"function","title":"wxGraphicsPath.addCurveToPoint/7","doc":"Adds a cubic bezier curve from the current point, using two control points and\nan end point.\n\nIf there is no current point before the call to `addCurveToPoint/7` this\nfunction will behave as if preceded by a call to MoveToPoint(`cx1`, `cy1`).","ref":"wxGraphicsPath.html#addCurveToPoint/7"},{"type":"function","title":"wxGraphicsPath.addEllipse/5","doc":"Appends an ellipse fitting into the passed in rectangle as a new closed subpath.\n\nAfter this call the current point will be at (x+`w`, y+`h/2`).","ref":"wxGraphicsPath.html#addEllipse/5"},{"type":"function","title":"wxGraphicsPath.addLineToPoint/2","doc":"Adds a straight line from the current point to `p`.\n\nIf current point is not yet set before the call to `addLineToPoint/3` this\nfunction will behave as `moveToPoint/3`.","ref":"wxGraphicsPath.html#addLineToPoint/2"},{"type":"function","title":"wxGraphicsPath.addLineToPoint/3","doc":"Adds a straight line from the current point to (`x`,`y`).\n\nIf current point is not yet set before the call to `addLineToPoint/3` this\nfunction will behave as `moveToPoint/3`.","ref":"wxGraphicsPath.html#addLineToPoint/3"},{"type":"function","title":"wxGraphicsPath.addPath/2","doc":"Adds another path onto the current path.\n\nAfter this call the current point will be at the added path's current point. For\nDirect2D the path being appended shouldn't contain a started non-empty subpath\nwhen this function is called.","ref":"wxGraphicsPath.html#addPath/2"},{"type":"function","title":"wxGraphicsPath.addQuadCurveToPoint/5","doc":"Adds a quadratic bezier curve from the current point, using a control point and\nan end point.\n\nIf there is no current point before the call to `addQuadCurveToPoint/5` this\nfunction will behave as if preceded by a call to MoveToPoint(`cx`, `cy`).","ref":"wxGraphicsPath.html#addQuadCurveToPoint/5"},{"type":"function","title":"wxGraphicsPath.addRectangle/5","doc":"Appends a rectangle as a new closed subpath.\n\nAfter this call the current point will be at (`x`, `y`).","ref":"wxGraphicsPath.html#addRectangle/5"},{"type":"function","title":"wxGraphicsPath.addRoundedRectangle/6","doc":"Appends a rounded rectangle as a new closed subpath.\n\nIf `radius` equals 0 this function will behave as `addRectangle/5`, otherwise\nafter this call the current point will be at (x+`w`, y+`h/2`).","ref":"wxGraphicsPath.html#addRoundedRectangle/6"},{"type":"function","title":"wxGraphicsPath.closeSubpath/1","doc":"Closes the current sub-path.\n\nAfter this call the current point will be at the joined endpoint of the\nsub-path.","ref":"wxGraphicsPath.html#closeSubpath/1"},{"type":"function","title":"wxGraphicsPath.contains/2","doc":"","ref":"wxGraphicsPath.html#contains/2"},{"type":"function","title":"wxGraphicsPath.contains/3","doc":"Return: true if the point is within the path.","ref":"wxGraphicsPath.html#contains/3"},{"type":"function","title":"wxGraphicsPath.contains/4","doc":"Return: true if the point is within the path.","ref":"wxGraphicsPath.html#contains/4"},{"type":"function","title":"wxGraphicsPath.getBox/1","doc":"Gets the bounding box enclosing all points (possibly including control points).","ref":"wxGraphicsPath.html#getBox/1"},{"type":"function","title":"wxGraphicsPath.getCurrentPoint/1","doc":"Gets the last point of the current path, (0,0) if not yet set.","ref":"wxGraphicsPath.html#getCurrentPoint/1"},{"type":"function","title":"wxGraphicsPath.moveToPoint/2","doc":"Begins a new subpath at `p`.","ref":"wxGraphicsPath.html#moveToPoint/2"},{"type":"function","title":"wxGraphicsPath.moveToPoint/3","doc":"Begins a new subpath at (`x`,`y`).","ref":"wxGraphicsPath.html#moveToPoint/3"},{"type":"function","title":"wxGraphicsPath.transform/2","doc":"Transforms each point of this path by the matrix.\n\nFor Direct2D the current path shouldn't contain a started non-empty subpath when\nthis function is called.","ref":"wxGraphicsPath.html#transform/2"},{"type":"type","title":"wxGraphicsPath.wxGraphicsPath/0","doc":"","ref":"wxGraphicsPath.html#t:wxGraphicsPath/0"},{"type":"module","title":"wxGraphicsPen","doc":"Functions for wxGraphicsPen class\n\nA `m:wxGraphicsPen` is a native representation of a pen. The contents are\nspecific and private to the respective renderer. Instances are ref counted and\ncan therefore be assigned as usual. The only way to get a valid instance is via\n`wxGraphicsContext:createPen/2` or `wxGraphicsRenderer::CreatePen()` (not\nimplemented in wx).\n\nThis class is derived (and can use functions) from: `m:wxGraphicsObject`\n\nwxWidgets docs:\n[wxGraphicsPen](https://docs.wxwidgets.org/3.1/classwx_graphics_pen.html)","ref":"wxGraphicsPen.html"},{"type":"type","title":"wxGraphicsPen.wxGraphicsPen/0","doc":"","ref":"wxGraphicsPen.html#t:wxGraphicsPen/0"},{"type":"module","title":"wxGraphicsRenderer","doc":"Functions for wxGraphicsRenderer class\n\nA `m:wxGraphicsRenderer` is the instance corresponding to the rendering engine\nused. There may be multiple instances on a system, if there are different\nrendering engines present, but there is always only one instance per engine.\nThis instance is pointed back to by all objects created by it\n(`m:wxGraphicsContext`, `m:wxGraphicsPath` etc.) and can be retrieved through\ntheir `wxGraphicsObject:getRenderer/1` method. Therefore you can create an\nadditional instance of a path etc. by calling `wxGraphicsObject:getRenderer/1`\nand then using the appropriate CreateXXX() function of that renderer.\n\nwxWidgets docs:\n[wxGraphicsRenderer](https://docs.wxwidgets.org/3.1/classwx_graphics_renderer.html)","ref":"wxGraphicsRenderer.html"},{"type":"function","title":"wxGraphicsRenderer.createBrush/2","doc":"Creates a native brush from a `m:wxBrush`.","ref":"wxGraphicsRenderer.html#createBrush/2"},{"type":"function","title":"wxGraphicsRenderer.createContext/2","doc":"Creates a `m:wxGraphicsContext` from a `m:wxWindowDC`.","ref":"wxGraphicsRenderer.html#createContext/2"},{"type":"function","title":"wxGraphicsRenderer.createFont/2","doc":"","ref":"wxGraphicsRenderer.html#createFont/2"},{"type":"function","title":"wxGraphicsRenderer.createFont/3","doc":"Creates a native graphics font from a `m:wxFont` and a text colour.","ref":"wxGraphicsRenderer.html#createFont/3"},{"type":"function","title":"wxGraphicsRenderer.createFont/4","doc":"Creates a graphics font with the given characteristics.\n\nIf possible, the `createFont/4` overload taking `m:wxFont` should be used\ninstead. The main advantage of this overload is that it can be used without X\nserver connection under Unix when using Cairo.\n\nSince: 2.9.3","ref":"wxGraphicsRenderer.html#createFont/4"},{"type":"function","title":"wxGraphicsRenderer.createLinearGradientBrush/6","doc":"Creates a native brush with a linear gradient.\n\nStops support is new since wxWidgets 2.9.1, previously only the start and end\ncolours could be specified.\n\nThe ability to apply a transformation matrix to the gradient was added in 3.1.3","ref":"wxGraphicsRenderer.html#createLinearGradientBrush/6"},{"type":"function","title":"wxGraphicsRenderer.createMatrix/1","doc":"","ref":"wxGraphicsRenderer.html#createMatrix/1"},{"type":"function","title":"wxGraphicsRenderer.createMatrix/2","doc":"Creates a native affine transformation matrix from the passed in values.\n\nThe defaults result in an identity matrix.","ref":"wxGraphicsRenderer.html#createMatrix/2"},{"type":"function","title":"wxGraphicsRenderer.createPath/1","doc":"Creates a native graphics path which is initially empty.","ref":"wxGraphicsRenderer.html#createPath/1"},{"type":"function","title":"wxGraphicsRenderer.createRadialGradientBrush/7","doc":"Creates a native brush with a radial gradient.\n\nStops support is new since wxWidgets 2.9.1, previously only the start and end\ncolours could be specified.\n\nThe ability to apply a transformation matrix to the gradient was added in 3.1.3","ref":"wxGraphicsRenderer.html#createRadialGradientBrush/7"},{"type":"function","title":"wxGraphicsRenderer.getDefaultRenderer/0","doc":"Returns the default renderer on this platform.\n\nOn macOS this is the Core Graphics (a.k.a. Quartz 2D) renderer, on MSW the\nGDIPlus renderer, and on GTK we currently default to the Cairo renderer.","ref":"wxGraphicsRenderer.html#getDefaultRenderer/0"},{"type":"type","title":"wxGraphicsRenderer.wxGraphicsRenderer/0","doc":"","ref":"wxGraphicsRenderer.html#t:wxGraphicsRenderer/0"},{"type":"module","title":"wxGrid","doc":"Functions for wxGrid class\n\n`m:wxGrid` and its related classes are used for displaying and editing tabular\ndata. They provide a rich set of features for display, editing, and interacting\nwith a variety of data sources. For simple applications, and to help you get\nstarted, `m:wxGrid` is the only class you need to refer to directly. It will set\nup default instances of the other classes and manage them for you. For more\ncomplex applications you can derive your own classes for custom grid views, grid\ndata tables, cell editors and renderers. The overview_grid has examples of\nsimple and more complex applications, explains the relationship between the\nvarious grid classes and has a summary of the keyboard shortcuts and mouse\nfunctions provided by `m:wxGrid`.\n\nA `wxGridTableBase` (not implemented in wx) class holds the actual data to be\ndisplayed by a `m:wxGrid` class. One or more `m:wxGrid` classes may act as a\nview for one table class. The default table class is called `wxGridStringTable`\n(not implemented in wx) and holds an array of strings. An instance of such a\nclass is created by `createGrid/4`.\n\n`m:wxGridCellRenderer` is the abstract base class for rendering contents in a\ncell. The following renderers are predefined:\n\nThe look of a cell can be further defined using `m:wxGridCellAttr`. An object of\nthis type may be returned by `wxGridTableBase::GetAttr()` (not implemented in\nwx).\n\n`m:wxGridCellEditor` is the abstract base class for editing the value of a cell.\nThe following editors are predefined:\n\nPlease see `m:wxGridEvent`, `wxGridSizeEvent` (not implemented in wx),\n`wxGridRangeSelectEvent` (not implemented in wx), and `wxGridEditorCreatedEvent`\n(not implemented in wx) for the documentation of all event types you can use\nwith `m:wxGrid`.\n\nSee:\n[Overview grid](https://docs.wxwidgets.org/3.1/overview_grid.html#overview_grid),\n`wxGridUpdateLocker` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxScrolledWindow`\n`m:wxPanel` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs: [wxGrid](https://docs.wxwidgets.org/3.1/classwx_grid.html)","ref":"wxGrid.html"},{"type":"function","title":"wxGrid.appendCols/1","doc":"","ref":"wxGrid.html#appendCols/1"},{"type":"function","title":"wxGrid.appendCols/2","doc":"Appends one or more new columns to the right of the grid.\n\nThe `updateLabels` argument is not used at present. If you are using a derived\ngrid table class you will need to override `wxGridTableBase::AppendCols()` (not\nimplemented in wx). See `insertCols/2` for further information.\n\nReturn: true on success or false if appending columns failed.","ref":"wxGrid.html#appendCols/2"},{"type":"function","title":"wxGrid.appendRows/1","doc":"","ref":"wxGrid.html#appendRows/1"},{"type":"function","title":"wxGrid.appendRows/2","doc":"Appends one or more new rows to the bottom of the grid.\n\nThe `updateLabels` argument is not used at present. If you are using a derived\ngrid table class you will need to override `wxGridTableBase::AppendRows()` (not\nimplemented in wx). See `insertRows/2` for further information.\n\nReturn: true on success or false if appending rows failed.","ref":"wxGrid.html#appendRows/2"},{"type":"function","title":"wxGrid.autoSize/1","doc":"Automatically sets the height and width of all rows and columns to fit their\ncontents.","ref":"wxGrid.html#autoSize/1"},{"type":"function","title":"wxGrid.autoSizeColumn/2","doc":"","ref":"wxGrid.html#autoSizeColumn/2"},{"type":"function","title":"wxGrid.autoSizeColumn/3","doc":"Automatically sizes the column to fit its contents.\n\nIf `setAsMin` is true the calculated width will also be set as the minimal width\nfor the column.","ref":"wxGrid.html#autoSizeColumn/3"},{"type":"function","title":"wxGrid.autoSizeColumns/1","doc":"","ref":"wxGrid.html#autoSizeColumns/1"},{"type":"function","title":"wxGrid.autoSizeColumns/2","doc":"Automatically sizes all columns to fit their contents.\n\nIf `setAsMin` is true the calculated widths will also be set as the minimal\nwidths for the columns.","ref":"wxGrid.html#autoSizeColumns/2"},{"type":"function","title":"wxGrid.autoSizeRow/2","doc":"","ref":"wxGrid.html#autoSizeRow/2"},{"type":"function","title":"wxGrid.autoSizeRow/3","doc":"Automatically sizes the row to fit its contents.\n\nIf `setAsMin` is true the calculated height will also be set as the minimal\nheight for the row.","ref":"wxGrid.html#autoSizeRow/3"},{"type":"function","title":"wxGrid.autoSizeRows/1","doc":"","ref":"wxGrid.html#autoSizeRows/1"},{"type":"function","title":"wxGrid.autoSizeRows/2","doc":"Automatically sizes all rows to fit their contents.\n\nIf `setAsMin` is true the calculated heights will also be set as the minimal\nheights for the rows.","ref":"wxGrid.html#autoSizeRows/2"},{"type":"function","title":"wxGrid.beginBatch/1","doc":"Increments the grid's batch count.\n\nWhen the count is greater than zero repainting of the grid is suppressed. Each\ncall to BeginBatch must be matched by a later call to `endBatch/1`. Code that\ndoes a lot of grid modification can be enclosed between `beginBatch/1` and\n`endBatch/1` calls to avoid screen flicker. The final `endBatch/1` call will\ncause the grid to be repainted.\n\nNotice that you should use `wxGridUpdateLocker` (not implemented in wx) which\nensures that there is always a matching `endBatch/1` call for this\n`beginBatch/1` if possible instead of calling this method directly.","ref":"wxGrid.html#beginBatch/1"},{"type":"function","title":"wxGrid.blockToDeviceRect/3","doc":"Convert grid cell coordinates to grid window pixel coordinates.\n\nThis function returns the rectangle that encloses the block of cells limited by\n`topLeft` and `bottomRight` cell in device coords and clipped to the client size\nof the grid window.\n\nSince: 3.1.3 Parameter `gridWindow` has been added.\n\nSee: `cellToRect/3`","ref":"wxGrid.html#blockToDeviceRect/3"},{"type":"function","title":"wxGrid.canDragCell/1","doc":"Return true if the dragging of cells is enabled or false otherwise.","ref":"wxGrid.html#canDragCell/1"},{"type":"function","title":"wxGrid.canDragColMove/1","doc":"Returns true if columns can be moved by dragging with the mouse.\n\nColumns can be moved by dragging on their labels.","ref":"wxGrid.html#canDragColMove/1"},{"type":"function","title":"wxGrid.canDragColSize/2","doc":"Returns true if the given column can be resized by dragging with the mouse.\n\nThis function returns true if resizing the columns interactively is globally\nenabled, i.e. if `disableDragColSize/1` hadn't been called, and if this column\nwasn't explicitly marked as non-resizable with `DisableColResize()` (not\nimplemented in wx).","ref":"wxGrid.html#canDragColSize/2"},{"type":"function","title":"wxGrid.canDragGridRowEdges/1","doc":"Return true if row edges inside the grid can be dragged to resize the rows.\n\nSee: `canDragGridSize/1`, `canDragRowSize/2`\n\nSince: 3.1.4","ref":"wxGrid.html#canDragGridRowEdges/1"},{"type":"function","title":"wxGrid.canDragGridSize/1","doc":"Return true if the dragging of grid lines to resize rows and columns is enabled\nor false otherwise.","ref":"wxGrid.html#canDragGridSize/1"},{"type":"function","title":"wxGrid.canDragRowSize/2","doc":"Returns true if the given row can be resized by dragging with the mouse.\n\nThis is the same as `canDragColSize/2` but for rows.","ref":"wxGrid.html#canDragRowSize/2"},{"type":"function","title":"wxGrid.canEnableCellControl/1","doc":"Returns true if the in-place edit control for the current grid cell can be used\nand false otherwise.\n\nThis function always returns false for the read-only cells.","ref":"wxGrid.html#canEnableCellControl/1"},{"type":"function","title":"wxGrid.cellToRect/2","doc":"Return the rectangle corresponding to the grid cell's size and position in\nlogical coordinates.\n\nSee: `blockToDeviceRect/3`","ref":"wxGrid.html#cellToRect/2"},{"type":"function","title":"wxGrid.cellToRect/3","doc":"Return the rectangle corresponding to the grid cell's size and position in\nlogical coordinates.\n\nSee: `blockToDeviceRect/3`","ref":"wxGrid.html#cellToRect/3"},{"type":"function","title":"wxGrid.clearGrid/1","doc":"Clears all data in the underlying grid table and repaints the grid.\n\nThe table is not deleted by this function. If you are using a derived table\nclass then you need to override `wxGridTableBase::Clear()` (not implemented in\nwx) for this function to have any effect.","ref":"wxGrid.html#clearGrid/1"},{"type":"function","title":"wxGrid.clearSelection/1","doc":"Deselects all cells that are currently selected.","ref":"wxGrid.html#clearSelection/1"},{"type":"function","title":"wxGrid.createGrid/3","doc":"","ref":"wxGrid.html#createGrid/3"},{"type":"function","title":"wxGrid.createGrid/4","doc":"Creates a grid with the specified initial number of rows and columns.\n\nCall this directly after the grid constructor. When you use this function\n`m:wxGrid` will create and manage a simple table of string values for you. All\nof the grid data will be stored in memory.\n\nFor applications with more complex data types or relationships, or for dealing\nwith very large datasets, you should derive your own grid table class and pass a\ntable object to the grid with `SetTable()` (not implemented in wx) or\n`AssignTable()` (not implemented in wx).","ref":"wxGrid.html#createGrid/4"},{"type":"function","title":"wxGrid.deleteCols/1","doc":"","ref":"wxGrid.html#deleteCols/1"},{"type":"function","title":"wxGrid.deleteCols/2","doc":"Deletes one or more columns from a grid starting at the specified position.\n\nThe `updateLabels` argument is not used at present. If you are using a derived\ngrid table class you will need to override `wxGridTableBase::DeleteCols()` (not\nimplemented in wx). See `insertCols/2` for further information.\n\nReturn: true on success or false if deleting columns failed.","ref":"wxGrid.html#deleteCols/2"},{"type":"function","title":"wxGrid.deleteRows/1","doc":"","ref":"wxGrid.html#deleteRows/1"},{"type":"function","title":"wxGrid.deleteRows/2","doc":"Deletes one or more rows from a grid starting at the specified position.\n\nThe `updateLabels` argument is not used at present. If you are using a derived\ngrid table class you will need to override `wxGridTableBase::DeleteRows()` (not\nimplemented in wx). See `insertRows/2` for further information.\n\nReturn: true on success or false if deleting rows failed.","ref":"wxGrid.html#deleteRows/2"},{"type":"function","title":"wxGrid.destroy/1","doc":"Destructor.\n\nThis will also destroy the associated grid table unless you passed a table\nobject to the grid and specified that the grid should not take ownership of the\ntable (see `SetTable()` (not implemented in wx)).","ref":"wxGrid.html#destroy/1"},{"type":"function","title":"wxGrid.disableCellEditControl/1","doc":"Disables in-place editing of grid cells.\n\nEquivalent to calling EnableCellEditControl(false).","ref":"wxGrid.html#disableCellEditControl/1"},{"type":"function","title":"wxGrid.disableDragColSize/1","doc":"Disables column sizing by dragging with the mouse.\n\nEquivalent to passing false to `enableDragColSize/2`.","ref":"wxGrid.html#disableDragColSize/1"},{"type":"function","title":"wxGrid.disableDragGridSize/1","doc":"Disable mouse dragging of grid lines to resize rows and columns.\n\nEquivalent to passing false to `enableDragGridSize/2`","ref":"wxGrid.html#disableDragGridSize/1"},{"type":"function","title":"wxGrid.disableDragRowSize/1","doc":"Disables row sizing by dragging with the mouse.\n\nEquivalent to passing false to `enableDragRowSize/2`.","ref":"wxGrid.html#disableDragRowSize/1"},{"type":"function","title":"wxGrid.enableCellEditControl/1","doc":"","ref":"wxGrid.html#enableCellEditControl/1"},{"type":"function","title":"wxGrid.enableCellEditControl/2","doc":"Enables or disables in-place editing of grid cell data.\n\nEnabling in-place editing generates `wxEVT_GRID_EDITOR_SHOWN` and, if it isn't\nvetoed by the application, shows the in-place editor which allows the user to\nchange the cell value.\n\nDisabling in-place editing does nothing if the in-place editor isn't currently\nshown, otherwise the `wxEVT_GRID_EDITOR_HIDDEN` event is generated but, unlike\nthe \"shown\" event, it can't be vetoed and the in-place editor is dismissed\nunconditionally.\n\nNote that it is an error to call this function if the current cell is read-only,\nuse `canEnableCellControl/1` to check for this precondition.","ref":"wxGrid.html#enableCellEditControl/2"},{"type":"function","title":"wxGrid.enableDragColSize/1","doc":"","ref":"wxGrid.html#enableDragColSize/1"},{"type":"function","title":"wxGrid.enableDragColSize/2","doc":"Enables or disables column sizing by dragging with the mouse.\n\nSee: `DisableColResize()` (not implemented in wx)","ref":"wxGrid.html#enableDragColSize/2"},{"type":"function","title":"wxGrid.enableDragGridSize/1","doc":"","ref":"wxGrid.html#enableDragGridSize/1"},{"type":"function","title":"wxGrid.enableDragGridSize/2","doc":"Enables or disables row and column resizing by dragging gridlines with the\nmouse.","ref":"wxGrid.html#enableDragGridSize/2"},{"type":"function","title":"wxGrid.enableDragRowSize/1","doc":"","ref":"wxGrid.html#enableDragRowSize/1"},{"type":"function","title":"wxGrid.enableDragRowSize/2","doc":"Enables or disables row sizing by dragging with the mouse.\n\nSee: `DisableRowResize()` (not implemented in wx)","ref":"wxGrid.html#enableDragRowSize/2"},{"type":"function","title":"wxGrid.enableEditing/2","doc":"Makes the grid globally editable or read-only.\n\nIf the edit argument is false this function sets the whole grid as read-only. If\nthe argument is true the grid is set to the default state where cells may be\neditable. In the default state you can set single grid cells and whole rows and\ncolumns to be editable or read-only via `wxGridCellAttr:setReadOnly/2`. For\nsingle cells you can also use the shortcut function `setReadOnly/4`.\n\nFor more information about controlling grid cell attributes see the\n`m:wxGridCellAttr` class and the overview_grid.","ref":"wxGrid.html#enableEditing/2"},{"type":"function","title":"wxGrid.enableGridLines/1","doc":"","ref":"wxGrid.html#enableGridLines/1"},{"type":"function","title":"wxGrid.enableGridLines/2","doc":"Turns the drawing of grid lines on or off.","ref":"wxGrid.html#enableGridLines/2"},{"type":"function","title":"wxGrid.endBatch/1","doc":"Decrements the grid's batch count.\n\nWhen the count is greater than zero repainting of the grid is suppressed. Each\nprevious call to `beginBatch/1` must be matched by a later call to `endBatch/1`.\nCode that does a lot of grid modification can be enclosed between `beginBatch/1`\nand `endBatch/1` calls to avoid screen flicker. The final `endBatch/1` will\ncause the grid to be repainted.\n\nSee: `wxGridUpdateLocker` (not implemented in wx)","ref":"wxGrid.html#endBatch/1"},{"type":"function","title":"wxGrid.fit/1","doc":"Overridden `m:wxWindow` method.","ref":"wxGrid.html#fit/1"},{"type":"function","title":"wxGrid.forceRefresh/1","doc":"Causes immediate repainting of the grid.\n\nUse this instead of the usual `wxWindow:refresh/2`.","ref":"wxGrid.html#forceRefresh/1"},{"type":"function","title":"wxGrid.getBatchCount/1","doc":"Returns the number of times that `beginBatch/1` has been called without (yet)\nmatching calls to `endBatch/1`.\n\nWhile the grid's batch count is greater than zero the display will not be\nupdated.","ref":"wxGrid.html#getBatchCount/1"},{"type":"function","title":"wxGrid.getCellAlignment/3","doc":"Sets the arguments to the horizontal and vertical text alignment values for the\ngrid cell at the specified location.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or\n`wxALIGN_BOTTOM`.","ref":"wxGrid.html#getCellAlignment/3"},{"type":"function","title":"wxGrid.getCellBackgroundColour/3","doc":"Returns the background colour of the cell at the specified location.","ref":"wxGrid.html#getCellBackgroundColour/3"},{"type":"function","title":"wxGrid.getCellEditor/3","doc":"Returns a pointer to the editor for the cell at the specified location.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell\neditors and renderers.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getCellEditor/3"},{"type":"function","title":"wxGrid.getCellFont/3","doc":"Returns the font for text in the grid cell at the specified location.","ref":"wxGrid.html#getCellFont/3"},{"type":"function","title":"wxGrid.getCellRenderer/3","doc":"Returns a pointer to the renderer for the grid cell at the specified location.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell\neditors and renderers.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getCellRenderer/3"},{"type":"function","title":"wxGrid.getCellTextColour/3","doc":"Returns the text colour for the grid cell at the specified location.","ref":"wxGrid.html#getCellTextColour/3"},{"type":"function","title":"wxGrid.getCellValue/2","doc":"Returns the string contained in the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid\ntable of string values you use this function together with `setCellValue/4` to\naccess cell values. For more complex applications where you have derived your\nown grid table class that contains various data types (e.g. numeric, boolean or\nuser-defined custom types) then you only use this function for those cells that\ncontain string values.\n\nSee `wxGridTableBase::CanGetValueAs()` (not implemented in wx) and the\noverview_grid for more information.","ref":"wxGrid.html#getCellValue/2"},{"type":"function","title":"wxGrid.getCellValue/3","doc":"Returns the string contained in the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid\ntable of string values you use this function together with `setCellValue/4` to\naccess cell values. For more complex applications where you have derived your\nown grid table class that contains various data types (e.g. numeric, boolean or\nuser-defined custom types) then you only use this function for those cells that\ncontain string values.\n\nSee `wxGridTableBase::CanGetValueAs()` (not implemented in wx) and the\noverview_grid for more information.","ref":"wxGrid.html#getCellValue/3"},{"type":"function","title":"wxGrid.getColLabelAlignment/1","doc":"Sets the arguments to the current column label alignment values.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or\n`wxALIGN_BOTTOM`.","ref":"wxGrid.html#getColLabelAlignment/1"},{"type":"function","title":"wxGrid.getColLabelSize/1","doc":"Returns the current height of the column labels.","ref":"wxGrid.html#getColLabelSize/1"},{"type":"function","title":"wxGrid.getColLabelValue/2","doc":"Returns the specified column label.\n\nThe default grid table class provides column labels of the form\nA,B...Z,AA,AB...ZZ,AAA... If you are using a custom grid table you can override\n`wxGridTableBase::GetColLabelValue()` (not implemented in wx) to provide your\nown labels.","ref":"wxGrid.html#getColLabelValue/2"},{"type":"function","title":"wxGrid.getColMinimalAcceptableWidth/1","doc":"Returns the minimal width to which a column may be resized.\n\nUse `setColMinimalAcceptableWidth/2` to change this value globally or\n`setColMinimalWidth/3` to do it for individual columns.\n\nSee: `getRowMinimalAcceptableHeight/1`","ref":"wxGrid.html#getColMinimalAcceptableWidth/1"},{"type":"function","title":"wxGrid.getDefaultCellAlignment/1","doc":"Returns the default cell alignment.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or\n`wxALIGN_BOTTOM`.\n\nSee: `setDefaultCellAlignment/3`","ref":"wxGrid.html#getDefaultCellAlignment/1"},{"type":"function","title":"wxGrid.getDefaultCellBackgroundColour/1","doc":"Returns the current default background colour for grid cells.","ref":"wxGrid.html#getDefaultCellBackgroundColour/1"},{"type":"function","title":"wxGrid.getDefaultCellFont/1","doc":"Returns the current default font for grid cell text.","ref":"wxGrid.html#getDefaultCellFont/1"},{"type":"function","title":"wxGrid.getDefaultCellTextColour/1","doc":"Returns the current default colour for grid cell text.","ref":"wxGrid.html#getDefaultCellTextColour/1"},{"type":"function","title":"wxGrid.getDefaultColLabelSize/1","doc":"Returns the default height for column labels.","ref":"wxGrid.html#getDefaultColLabelSize/1"},{"type":"function","title":"wxGrid.getDefaultColSize/1","doc":"Returns the current default width for grid columns.","ref":"wxGrid.html#getDefaultColSize/1"},{"type":"function","title":"wxGrid.getDefaultEditor/1","doc":"Returns a pointer to the current default grid cell editor.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell\neditors and renderers.","ref":"wxGrid.html#getDefaultEditor/1"},{"type":"function","title":"wxGrid.getDefaultEditorForCell/2","doc":"Returns the default editor for the specified cell.\n\nThe base class version returns the editor appropriate for the current cell type\nbut this method may be overridden in the derived classes to use custom editors\nfor some cells by default.\n\nNotice that the same may be achieved in a usually simpler way by associating a\ncustom editor with the given cell or cells.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultEditorForCell/2"},{"type":"function","title":"wxGrid.getDefaultEditorForCell/3","doc":"Returns the default editor for the specified cell.\n\nThe base class version returns the editor appropriate for the current cell type\nbut this method may be overridden in the derived classes to use custom editors\nfor some cells by default.\n\nNotice that the same may be achieved in a usually simpler way by associating a\ncustom editor with the given cell or cells.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultEditorForCell/3"},{"type":"function","title":"wxGrid.getDefaultEditorForType/2","doc":"Returns the default editor for the cells containing values of the given type.\n\nThe base class version returns the editor which was associated with the\nspecified `typeName` when it was registered `registerDataType/4` but this\nfunction may be overridden to return something different. This allows overriding\nan editor used for one of the standard types.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultEditorForType/2"},{"type":"function","title":"wxGrid.getDefaultRenderer/1","doc":"Returns a pointer to the current default grid cell renderer.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell\neditors and renderers.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultRenderer/1"},{"type":"function","title":"wxGrid.getDefaultRendererForCell/3","doc":"Returns the default renderer for the given cell.\n\nThe base class version returns the renderer appropriate for the current cell\ntype but this method may be overridden in the derived classes to use custom\nrenderers for some cells by default.\n\nThe caller must call DecRef() on the returned pointer.","ref":"wxGrid.html#getDefaultRendererForCell/3"},{"type":"function","title":"wxGrid.getDefaultRendererForType/2","doc":"Returns the default renderer for the cell containing values of the given type.\n\nSee: `getDefaultEditorForType/2`","ref":"wxGrid.html#getDefaultRendererForType/2"},{"type":"function","title":"wxGrid.getDefaultRowLabelSize/1","doc":"Returns the default width for the row labels.","ref":"wxGrid.html#getDefaultRowLabelSize/1"},{"type":"function","title":"wxGrid.getDefaultRowSize/1","doc":"Returns the current default height for grid rows.","ref":"wxGrid.html#getDefaultRowSize/1"},{"type":"function","title":"wxGrid.getGridColLabelWindow/1","doc":"Return the column labels window.\n\nThis window is not shown if the columns labels were hidden using\n`HideColLabels()` (not implemented in wx).\n\nDepending on whether `UseNativeColHeader()` (not implemented in wx) was called\nor not this can be either a `wxHeaderCtrl` (not implemented in wx) or a plain\n`m:wxWindow`. This function returns a valid window pointer in either case but in\nthe former case you can also use `GetGridColHeader()` (not implemented in wx) to\naccess it if you need wxHeaderCtrl-specific functionality.","ref":"wxGrid.html#getGridColLabelWindow/1"},{"type":"function","title":"wxGrid.getGridCornerLabelWindow/1","doc":"Return the window in the top left grid corner.\n\nThis window is shown only of both columns and row labels are shown and normally\ndoesn't contain anything. Clicking on it is handled by `m:wxGrid` however and\ncan be used to select the entire grid.","ref":"wxGrid.html#getGridCornerLabelWindow/1"},{"type":"function","title":"wxGrid.getGridCursorCol/1","doc":"Returns the current grid cell column position.\n\nSee: `GetGridCursorCoords()` (not implemented in wx)","ref":"wxGrid.html#getGridCursorCol/1"},{"type":"function","title":"wxGrid.getGridCursorRow/1","doc":"Returns the current grid cell row position.\n\nSee: `GetGridCursorCoords()` (not implemented in wx)","ref":"wxGrid.html#getGridCursorRow/1"},{"type":"function","title":"wxGrid.getGridLineColour/1","doc":"Returns the colour used for grid lines.\n\nSee: `GetDefaultGridLinePen()` (not implemented in wx)","ref":"wxGrid.html#getGridLineColour/1"},{"type":"function","title":"wxGrid.getGridRowLabelWindow/1","doc":"Return the row labels window.\n\nThis window is not shown if the row labels were hidden using `HideRowLabels()`\n(not implemented in wx).","ref":"wxGrid.html#getGridRowLabelWindow/1"},{"type":"function","title":"wxGrid.getGridWindow/1","doc":"Return the main grid window containing the grid cells.\n\nThis window is always shown.","ref":"wxGrid.html#getGridWindow/1"},{"type":"function","title":"wxGrid.getLabelBackgroundColour/1","doc":"Returns the colour used for the background of row and column labels.","ref":"wxGrid.html#getLabelBackgroundColour/1"},{"type":"function","title":"wxGrid.getLabelFont/1","doc":"Returns the font used for row and column labels.","ref":"wxGrid.html#getLabelFont/1"},{"type":"function","title":"wxGrid.getLabelTextColour/1","doc":"Returns the colour used for row and column label text.","ref":"wxGrid.html#getLabelTextColour/1"},{"type":"function","title":"wxGrid.getNumberCols/1","doc":"Returns the total number of grid columns.\n\nThis is the same as the number of columns in the underlying grid table.","ref":"wxGrid.html#getNumberCols/1"},{"type":"function","title":"wxGrid.getNumberRows/1","doc":"Returns the total number of grid rows.\n\nThis is the same as the number of rows in the underlying grid table.","ref":"wxGrid.html#getNumberRows/1"},{"type":"function","title":"wxGrid.getOrCreateCellAttr/3","doc":"Returns the attribute for the given cell creating one if necessary.\n\nIf the cell already has an attribute, it is returned. Otherwise a new attribute\nis created, associated with the cell and returned. In any case the caller must\ncall DecRef() on the returned pointer.\n\nPrefer to use `GetOrCreateCellAttrPtr()` (not implemented in wx) to avoid the\nneed to call DecRef() on the returned pointer.\n\nThis function may only be called if `CanHaveAttributes()` (not implemented in\nwx) returns true.","ref":"wxGrid.html#getOrCreateCellAttr/3"},{"type":"function","title":"wxGrid.getRowLabelAlignment/1","doc":"Returns the alignment used for row labels.\n\nHorizontal alignment will be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`.\n\nVertical alignment will be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or\n`wxALIGN_BOTTOM`.","ref":"wxGrid.html#getRowLabelAlignment/1"},{"type":"function","title":"wxGrid.getRowLabelSize/1","doc":"Returns the current width of the row labels.","ref":"wxGrid.html#getRowLabelSize/1"},{"type":"function","title":"wxGrid.getRowLabelValue/2","doc":"Returns the specified row label.\n\nThe default grid table class provides numeric row labels. If you are using a\ncustom grid table you can override `wxGridTableBase::GetRowLabelValue()` (not\nimplemented in wx) to provide your own labels.","ref":"wxGrid.html#getRowLabelValue/2"},{"type":"function","title":"wxGrid.getRowMinimalAcceptableHeight/1","doc":"Returns the minimal size to which rows can be resized.\n\nUse `setRowMinimalAcceptableHeight/2` to change this value globally or\n`setRowMinimalHeight/3` to do it for individual cells.\n\nSee: `getColMinimalAcceptableWidth/1`","ref":"wxGrid.html#getRowMinimalAcceptableHeight/1"},{"type":"function","title":"wxGrid.getRowSize/2","doc":"Returns the height of the specified row.","ref":"wxGrid.html#getRowSize/2"},{"type":"function","title":"wxGrid.getScrollLineX/1","doc":"Returns the number of pixels per horizontal scroll increment.\n\nThe default is 15.\n\nSee: `getScrollLineY/1`, `setScrollLineX/2`, `setScrollLineY/2`","ref":"wxGrid.html#getScrollLineX/1"},{"type":"function","title":"wxGrid.getScrollLineY/1","doc":"Returns the number of pixels per vertical scroll increment.\n\nThe default is 15.\n\nSee: `getScrollLineX/1`, `setScrollLineX/2`, `setScrollLineY/2`","ref":"wxGrid.html#getScrollLineY/1"},{"type":"function","title":"wxGrid.getSelectedCells/1","doc":"Returns an array of individually selected cells.\n\nNotice that this array does `not` contain all the selected cells in general as\nit doesn't include the cells selected as part of column, row or block selection.\nYou must use this method, `getSelectedCols/1`, `getSelectedRows/1` and\n`getSelectionBlockTopLeft/1` and `getSelectionBlockBottomRight/1` methods to\nobtain the entire selection in general.\n\nPlease notice this behaviour is by design and is needed in order to support\ngrids of arbitrary size (when an entire column is selected in a grid with a\nmillion of columns, we don't want to create an array with a million of entries\nin this function, instead it returns an empty array and `getSelectedCols/1`\nreturns an array containing one element).\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not\nimplemented in wx) in the new code.","ref":"wxGrid.html#getSelectedCells/1"},{"type":"function","title":"wxGrid.getSelectedCols/1","doc":"Returns an array of selected columns.\n\nPlease notice that this method alone is not sufficient to find all the selected\ncolumns as it contains only the columns which were individually selected but not\nthose being part of the block selection or being selected in virtue of all of\ntheir cells being selected individually, please see `getSelectedCells/1` for\nmore details.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not\nimplemented in wx) in the new code.","ref":"wxGrid.html#getSelectedCols/1"},{"type":"function","title":"wxGrid.getSelectedRows/1","doc":"Returns an array of selected rows.\n\nPlease notice that this method alone is not sufficient to find all the selected\nrows as it contains only the rows which were individually selected but not those\nbeing part of the block selection or being selected in virtue of all of their\ncells being selected individually, please see `getSelectedCells/1` for more\ndetails.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not\nimplemented in wx) in the new code.","ref":"wxGrid.html#getSelectedRows/1"},{"type":"function","title":"wxGrid.getSelectionBackground/1","doc":"Returns the colour used for drawing the selection background.","ref":"wxGrid.html#getSelectionBackground/1"},{"type":"function","title":"wxGrid.getSelectionBlockBottomRight/1","doc":"Returns an array of the bottom right corners of blocks of selected cells.\n\nPlease see `getSelectedCells/1` for more information about the selection\nrepresentation in `m:wxGrid`.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not\nimplemented in wx) in the new code.\n\nSee: `getSelectionBlockTopLeft/1`","ref":"wxGrid.html#getSelectionBlockBottomRight/1"},{"type":"function","title":"wxGrid.getSelectionBlockTopLeft/1","doc":"Returns an array of the top left corners of blocks of selected cells.\n\nPlease see `getSelectedCells/1` for more information about the selection\nrepresentation in `m:wxGrid`.\n\nThe function can be slow for the big grids, use `GetSelectedBlocks()` (not\nimplemented in wx) in the new code.\n\nSee: `getSelectionBlockBottomRight/1`","ref":"wxGrid.html#getSelectionBlockTopLeft/1"},{"type":"function","title":"wxGrid.getSelectionForeground/1","doc":"Returns the colour used for drawing the selection foreground.","ref":"wxGrid.html#getSelectionForeground/1"},{"type":"function","title":"wxGrid.gridLinesEnabled/1","doc":"Returns true if drawing of grid lines is turned on, false otherwise.","ref":"wxGrid.html#gridLinesEnabled/1"},{"type":"function","title":"wxGrid.hideCellEditControl/1","doc":"Hides the in-place cell edit control.","ref":"wxGrid.html#hideCellEditControl/1"},{"type":"function","title":"wxGrid.insertCols/1","doc":"","ref":"wxGrid.html#insertCols/1"},{"type":"function","title":"wxGrid.insertCols/2","doc":"Inserts one or more new columns into a grid with the first new column at the\nspecified position.\n\nNotice that inserting the columns in the grid requires grid table cooperation:\nwhen this method is called, grid object begins by requesting the underlying grid\ntable to insert new columns. If this is successful the table notifies the grid\nand the grid updates the display. For a default grid (one where you have called\n`createGrid/4`) this process is automatic. If you are using a custom grid table\n(specified with `SetTable()` (not implemented in wx) or `AssignTable()` (not\nimplemented in wx)) then you must override `wxGridTableBase::InsertCols()` (not\nimplemented in wx) in your derived table class.\n\nReturn: true if the columns were successfully inserted, false if an error\noccurred (most likely the table couldn't be updated).","ref":"wxGrid.html#insertCols/2"},{"type":"function","title":"wxGrid.insertRows/1","doc":"","ref":"wxGrid.html#insertRows/1"},{"type":"function","title":"wxGrid.insertRows/2","doc":"Inserts one or more new rows into a grid with the first new row at the specified\nposition.\n\nNotice that you must implement `wxGridTableBase::InsertRows()` (not implemented\nin wx) if you use a grid with a custom table, please see `insertCols/2` for more\ninformation.\n\nReturn: true if the rows were successfully inserted, false if an error occurred\n(most likely the table couldn't be updated).","ref":"wxGrid.html#insertRows/2"},{"type":"function","title":"wxGrid.isCellEditControlEnabled/1","doc":"Returns true if the in-place edit control is currently enabled.","ref":"wxGrid.html#isCellEditControlEnabled/1"},{"type":"function","title":"wxGrid.isCurrentCellReadOnly/1","doc":"Returns true if the current cell is read-only.\n\nSee: `setReadOnly/4`, `isReadOnly/3`","ref":"wxGrid.html#isCurrentCellReadOnly/1"},{"type":"function","title":"wxGrid.isEditable/1","doc":"Returns false if the whole grid has been set as read-only or true otherwise.\n\nSee `enableEditing/2` for more information about controlling the editing status\nof grid cells.","ref":"wxGrid.html#isEditable/1"},{"type":"function","title":"wxGrid.isInSelection/2","doc":"Returns true if the given cell is selected.","ref":"wxGrid.html#isInSelection/2"},{"type":"function","title":"wxGrid.isInSelection/3","doc":"Returns true if the given cell is selected.","ref":"wxGrid.html#isInSelection/3"},{"type":"function","title":"wxGrid.isReadOnly/3","doc":"Returns true if the cell at the specified location can't be edited.\n\nSee: `setReadOnly/4`, `isCurrentCellReadOnly/1`","ref":"wxGrid.html#isReadOnly/3"},{"type":"function","title":"wxGrid.isSelection/1","doc":"Returns true if there are currently any selected cells, rows, columns or blocks.","ref":"wxGrid.html#isSelection/1"},{"type":"function","title":"wxGrid.isVisible/2","doc":"","ref":"wxGrid.html#isVisible/2"},{"type":"function","title":"wxGrid.isVisible/3","doc":"Returns true if a cell is either entirely or at least partially visible in the\ngrid window.\n\nBy default, the cell must be entirely visible for this function to return true\nbut if `wholeCellVisible` is false, the function returns true even if the cell\nis only partially visible.","ref":"wxGrid.html#isVisible/3"},{"type":"function","title":"wxGrid.isVisible/4","doc":"Returns true if a cell is either entirely or at least partially visible in the\ngrid window.\n\nBy default, the cell must be entirely visible for this function to return true\nbut if `wholeCellVisible` is false, the function returns true even if the cell\nis only partially visible.","ref":"wxGrid.html#isVisible/4"},{"type":"function","title":"wxGrid.makeCellVisible/2","doc":"Brings the specified cell into the visible grid cell area with minimal\nscrolling.\n\nDoes nothing if the cell is already visible.","ref":"wxGrid.html#makeCellVisible/2"},{"type":"function","title":"wxGrid.makeCellVisible/3","doc":"Brings the specified cell into the visible grid cell area with minimal\nscrolling.\n\nDoes nothing if the cell is already visible.","ref":"wxGrid.html#makeCellVisible/3"},{"type":"function","title":"wxGrid.moveCursorDown/2","doc":"Moves the grid cursor down by one row.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorDown/2"},{"type":"function","title":"wxGrid.moveCursorDownBlock/2","doc":"Moves the grid cursor down in the current column such that it skips to the\nbeginning or end of a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorDownBlock/2"},{"type":"function","title":"wxGrid.moveCursorLeft/2","doc":"Moves the grid cursor left by one column.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorLeft/2"},{"type":"function","title":"wxGrid.moveCursorLeftBlock/2","doc":"Moves the grid cursor left in the current row such that it skips to the\nbeginning or end of a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorLeftBlock/2"},{"type":"function","title":"wxGrid.moveCursorRight/2","doc":"Moves the grid cursor right by one column.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorRight/2"},{"type":"function","title":"wxGrid.moveCursorRightBlock/2","doc":"Moves the grid cursor right in the current row such that it skips to the\nbeginning or end of a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorRightBlock/2"},{"type":"function","title":"wxGrid.moveCursorUp/2","doc":"Moves the grid cursor up by one row.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorUp/2"},{"type":"function","title":"wxGrid.moveCursorUpBlock/2","doc":"Moves the grid cursor up in the current column such that it skips to the\nbeginning or end of a block of non-empty cells.\n\nIf a block of cells was previously selected it will expand if the argument is\ntrue or be cleared if the argument is false.","ref":"wxGrid.html#moveCursorUpBlock/2"},{"type":"function","title":"wxGrid.movePageDown/1","doc":"Moves the grid cursor down by some number of rows so that the previous bottom\nvisible row becomes the top visible row.","ref":"wxGrid.html#movePageDown/1"},{"type":"function","title":"wxGrid.movePageUp/1","doc":"Moves the grid cursor up by some number of rows so that the previous top visible\nrow becomes the bottom visible row.","ref":"wxGrid.html#movePageUp/1"},{"type":"function","title":"wxGrid.new/0","doc":"Default constructor.\n\nYou must call `Create()` (not implemented in wx) to really create the grid\nwindow and also call `createGrid/4` or `SetTable()` (not implemented in wx) or\n`AssignTable()` (not implemented in wx) to initialize its contents.","ref":"wxGrid.html#new/0"},{"type":"function","title":"wxGrid.new/2","doc":"","ref":"wxGrid.html#new/2"},{"type":"function","title":"wxGrid.new/3","doc":"Constructor creating the grid window.\n\nYou must call either `createGrid/4` or `SetTable()` (not implemented in wx) or\n`AssignTable()` (not implemented in wx) to initialize the grid contents before\nusing it.","ref":"wxGrid.html#new/3"},{"type":"function","title":"wxGrid.registerDataType/4","doc":"Register a new data type.\n\nThe data types allow to naturally associate specific renderers and editors to\nthe cells containing values of the given type. For example, the grid\nautomatically registers a data type with the name `wxGRID_VALUE_STRING` which\nuses `m:wxGridCellStringRenderer` and `m:wxGridCellTextEditor` as its renderer\nand editor respectively - this is the data type used by all the cells of the\ndefault `wxGridStringTable` (not implemented in wx), so this renderer and editor\nare used by default for all grid cells.\n\nHowever if a custom table returns `wxGRID_VALUE_BOOL` from its\n`wxGridTableBase::GetTypeName()` (not implemented in wx) method, then\n`m:wxGridCellBoolRenderer` and `m:wxGridCellBoolEditor` are used for it because\nthe grid also registers a boolean data type with this name.\n\nAnd as this mechanism is completely generic, you may register your own data\ntypes using your own custom renderers and editors. Just remember that the table\nmust identify a cell as being of the given type for them to be used for this\ncell.","ref":"wxGrid.html#registerDataType/4"},{"type":"function","title":"wxGrid.saveEditControlValue/1","doc":"Sets the value of the current grid cell to the current in-place edit control\nvalue.\n\nThis is called automatically when the grid cursor moves from the current cell to\na new cell. It is also a good idea to call this function when closing a grid\nsince any edits to the final cell location will not be saved otherwise.","ref":"wxGrid.html#saveEditControlValue/1"},{"type":"function","title":"wxGrid.selectAll/1","doc":"Selects all cells in the grid.","ref":"wxGrid.html#selectAll/1"},{"type":"function","title":"wxGrid.selectBlock/3","doc":"","ref":"wxGrid.html#selectBlock/3"},{"type":"function","title":"wxGrid.selectBlock/4","doc":"Selects a rectangular block of cells.\n\nIf `addToSelected` is false then any existing selection will be deselected; if\ntrue the column will be added to the existing selection.","ref":"wxGrid.html#selectBlock/4"},{"type":"function","title":"wxGrid.selectBlock/5","doc":"","ref":"wxGrid.html#selectBlock/5"},{"type":"function","title":"wxGrid.selectBlock/6","doc":"Selects a rectangular block of cells.\n\nIf `addToSelected` is false then any existing selection will be deselected; if\ntrue the column will be added to the existing selection.","ref":"wxGrid.html#selectBlock/6"},{"type":"function","title":"wxGrid.selectCol/2","doc":"","ref":"wxGrid.html#selectCol/2"},{"type":"function","title":"wxGrid.selectCol/3","doc":"Selects the specified column.\n\nIf `addToSelected` is false then any existing selection will be deselected; if\ntrue the column will be added to the existing selection.\n\nThis method won't select anything if the current selection mode is\nwxGridSelectRows.","ref":"wxGrid.html#selectCol/3"},{"type":"function","title":"wxGrid.selectRow/2","doc":"","ref":"wxGrid.html#selectRow/2"},{"type":"function","title":"wxGrid.selectRow/3","doc":"Selects the specified row.\n\nIf `addToSelected` is false then any existing selection will be deselected; if\ntrue the row will be added to the existing selection.\n\nThis method won't select anything if the current selection mode is\nwxGridSelectColumns.","ref":"wxGrid.html#selectRow/3"},{"type":"function","title":"wxGrid.setCellAlignment/5","doc":"Sets the horizontal and vertical alignment for grid cell text at the specified\nlocation.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`.\n\nVertical alignment should be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or\n`wxALIGN_BOTTOM`.","ref":"wxGrid.html#setCellAlignment/5"},{"type":"function","title":"wxGrid.setCellBackgroundColour/4","doc":"Set the background colour for the given cell or all cells by default.","ref":"wxGrid.html#setCellBackgroundColour/4"},{"type":"function","title":"wxGrid.setCellEditor/4","doc":"Sets the editor for the grid cell at the specified location.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell\neditors and renderers.","ref":"wxGrid.html#setCellEditor/4"},{"type":"function","title":"wxGrid.setCellFont/4","doc":"Sets the font for text in the grid cell at the specified location.","ref":"wxGrid.html#setCellFont/4"},{"type":"function","title":"wxGrid.setCellRenderer/4","doc":"Sets the renderer for the grid cell at the specified location.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell\neditors and renderers.","ref":"wxGrid.html#setCellRenderer/4"},{"type":"function","title":"wxGrid.setCellTextColour/4","doc":"Sets the text colour for the given cell.","ref":"wxGrid.html#setCellTextColour/4"},{"type":"function","title":"wxGrid.setCellValue/3","doc":"Sets the string value for the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid\ntable of string values you use this function together with `getCellValue/3` to\naccess cell values. For more complex applications where you have derived your\nown grid table class that contains various data types (e.g. numeric, boolean or\nuser-defined custom types) then you only use this function for those cells that\ncontain string values.\n\nSee `wxGridTableBase::CanSetValueAs()` (not implemented in wx) and the\noverview_grid for more information.","ref":"wxGrid.html#setCellValue/3"},{"type":"function","title":"wxGrid.setCellValue/4","doc":"Sets the string value for the cell at the specified location.\n\nFor simple applications where a grid object automatically uses a default grid\ntable of string values you use this function together with `getCellValue/3` to\naccess cell values. For more complex applications where you have derived your\nown grid table class that contains various data types (e.g. numeric, boolean or\nuser-defined custom types) then you only use this function for those cells that\ncontain string values.\n\nSee `wxGridTableBase::CanSetValueAs()` (not implemented in wx) and the\noverview_grid for more information.","ref":"wxGrid.html#setCellValue/4"},{"type":"function","title":"wxGrid.setColAttr/3","doc":"Sets the cell attributes for all cells in the specified column.\n\nFor more information about controlling grid cell attributes see the\n`m:wxGridCellAttr` cell attribute class and the overview_grid.","ref":"wxGrid.html#setColAttr/3"},{"type":"function","title":"wxGrid.setColFormatBool/2","doc":"Sets the specified column to display boolean values.\n\nSee: `setColFormatCustom/3`","ref":"wxGrid.html#setColFormatBool/2"},{"type":"function","title":"wxGrid.setColFormatCustom/3","doc":"Sets the specified column to display data in a custom format.\n\nThis method provides an alternative to defining a custom grid table which would\nreturn `typeName` from its GetTypeName() method for the cells in this column:\nwhile it doesn't really change the type of the cells in this column, it does\nassociate the renderer and editor used for the cells of the specified type with\nthem.\n\nSee the overview_grid for more information on working with custom data types.","ref":"wxGrid.html#setColFormatCustom/3"},{"type":"function","title":"wxGrid.setColFormatFloat/2","doc":"","ref":"wxGrid.html#setColFormatFloat/2"},{"type":"function","title":"wxGrid.setColFormatFloat/3","doc":"Sets the specified column to display floating point values with the given width\nand precision.\n\nSee: `setColFormatCustom/3`","ref":"wxGrid.html#setColFormatFloat/3"},{"type":"function","title":"wxGrid.setColFormatNumber/2","doc":"Sets the specified column to display integer values.\n\nSee: `setColFormatCustom/3`","ref":"wxGrid.html#setColFormatNumber/2"},{"type":"function","title":"wxGrid.setColLabelAlignment/3","doc":"Sets the horizontal and vertical alignment of column label text.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`. Vertical alignment should be one of `wxALIGN_TOP`,\n`wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setColLabelAlignment/3"},{"type":"function","title":"wxGrid.setColLabelSize/2","doc":"Sets the height of the column labels.\n\nIf `height` equals to `wxGRID_AUTOSIZE` then height is calculated automatically\nso that no label is truncated. Note that this could be slow for a large table.","ref":"wxGrid.html#setColLabelSize/2"},{"type":"function","title":"wxGrid.setColLabelValue/3","doc":"Set the value for the given column label.\n\nIf you are using a custom grid table you must override\n`wxGridTableBase::SetColLabelValue()` (not implemented in wx) for this to have\nany effect.","ref":"wxGrid.html#setColLabelValue/3"},{"type":"function","title":"wxGrid.setColMinimalAcceptableWidth/2","doc":"Sets the minimal `width` to which the user can resize columns.\n\nSee: `getColMinimalAcceptableWidth/1`","ref":"wxGrid.html#setColMinimalAcceptableWidth/2"},{"type":"function","title":"wxGrid.setColMinimalWidth/3","doc":"Sets the minimal `width` for the specified column `col`.\n\nIt is usually best to call this method during grid creation as calling it later\nwill not resize the column to the given minimal width even if it is currently\nnarrower than it.\n\n`width` must be greater than the minimal acceptable column width as returned by\n`getColMinimalAcceptableWidth/1`.","ref":"wxGrid.html#setColMinimalWidth/3"},{"type":"function","title":"wxGrid.setColSize/3","doc":"Sets the width of the specified column.","ref":"wxGrid.html#setColSize/3"},{"type":"function","title":"wxGrid.setDefaultCellAlignment/3","doc":"Sets the default horizontal and vertical alignment for grid cell text.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`. Vertical alignment should be one of `wxALIGN_TOP`,\n`wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setDefaultCellAlignment/3"},{"type":"function","title":"wxGrid.setDefaultCellBackgroundColour/2","doc":"Sets the default background colour for grid cells.","ref":"wxGrid.html#setDefaultCellBackgroundColour/2"},{"type":"function","title":"wxGrid.setDefaultCellFont/2","doc":"Sets the default font to be used for grid cell text.","ref":"wxGrid.html#setDefaultCellFont/2"},{"type":"function","title":"wxGrid.setDefaultCellTextColour/2","doc":"Sets the current default colour for grid cell text.","ref":"wxGrid.html#setDefaultCellTextColour/2"},{"type":"function","title":"wxGrid.setDefaultColSize/2","doc":"","ref":"wxGrid.html#setDefaultColSize/2"},{"type":"function","title":"wxGrid.setDefaultColSize/3","doc":"Sets the default width for columns in the grid.\n\nThis will only affect columns subsequently added to the grid unless\n`resizeExistingCols` is true.\n\nIf `width` is less than `getColMinimalAcceptableWidth/1`, then the minimal\nacceptable width is used instead of it.","ref":"wxGrid.html#setDefaultColSize/3"},{"type":"function","title":"wxGrid.setDefaultEditor/2","doc":"Sets the default editor for grid cells.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellEditor` and the overview_grid for more information about cell\neditors and renderers.","ref":"wxGrid.html#setDefaultEditor/2"},{"type":"function","title":"wxGrid.setDefaultRenderer/2","doc":"Sets the default renderer for grid cells.\n\nThe grid will take ownership of the pointer.\n\nSee `m:wxGridCellRenderer` and the overview_grid for more information about cell\neditors and renderers.","ref":"wxGrid.html#setDefaultRenderer/2"},{"type":"function","title":"wxGrid.setDefaultRowSize/2","doc":"","ref":"wxGrid.html#setDefaultRowSize/2"},{"type":"function","title":"wxGrid.setDefaultRowSize/3","doc":"Sets the default height for rows in the grid.\n\nThis will only affect rows subsequently added to the grid unless\n`resizeExistingRows` is true.\n\nIf `height` is less than `getRowMinimalAcceptableHeight/1`, then the minimal\nacceptable height is used instead of it.","ref":"wxGrid.html#setDefaultRowSize/3"},{"type":"function","title":"wxGrid.setGridCursor/2","doc":"Set the grid cursor to the specified cell.\n\nThe grid cursor indicates the current cell and can be moved by the user using\nthe arrow keys or the mouse.\n\nCalling this function generates a `wxEVT_GRID_SELECT_CELL` event and if the\nevent handler vetoes this event, the cursor is not moved.\n\nThis function doesn't make the target call visible, use `GoToCell()` (not\nimplemented in wx) to do this.","ref":"wxGrid.html#setGridCursor/2"},{"type":"function","title":"wxGrid.setGridCursor/3","doc":"Set the grid cursor to the specified cell.\n\nThe grid cursor indicates the current cell and can be moved by the user using\nthe arrow keys or the mouse.\n\nCalling this function generates a `wxEVT_GRID_SELECT_CELL` event and if the\nevent handler vetoes this event, the cursor is not moved.\n\nThis function doesn't make the target call visible, use `GoToCell()` (not\nimplemented in wx) to do this.","ref":"wxGrid.html#setGridCursor/3"},{"type":"function","title":"wxGrid.setGridLineColour/2","doc":"Sets the colour used to draw grid lines.","ref":"wxGrid.html#setGridLineColour/2"},{"type":"function","title":"wxGrid.setLabelBackgroundColour/2","doc":"Sets the background colour for row and column labels.","ref":"wxGrid.html#setLabelBackgroundColour/2"},{"type":"function","title":"wxGrid.setLabelFont/2","doc":"Sets the font for row and column labels.","ref":"wxGrid.html#setLabelFont/2"},{"type":"function","title":"wxGrid.setLabelTextColour/2","doc":"Sets the colour for row and column label text.","ref":"wxGrid.html#setLabelTextColour/2"},{"type":"function","title":"wxGrid.setMargins/3","doc":"Sets the extra margins used around the grid area.\n\nA grid may occupy more space than needed for its data display and this function\nallows setting how big this extra space is","ref":"wxGrid.html#setMargins/3"},{"type":"function","title":"wxGrid.setReadOnly/3","doc":"","ref":"wxGrid.html#setReadOnly/3"},{"type":"function","title":"wxGrid.setReadOnly/4","doc":"Makes the cell at the specified location read-only or editable.\n\nSee: `isReadOnly/3`","ref":"wxGrid.html#setReadOnly/4"},{"type":"function","title":"wxGrid.setRowAttr/3","doc":"Sets the cell attributes for all cells in the specified row.\n\nThe grid takes ownership of the attribute pointer.\n\nSee the `m:wxGridCellAttr` class for more information about controlling cell\nattributes.","ref":"wxGrid.html#setRowAttr/3"},{"type":"function","title":"wxGrid.setRowLabelAlignment/3","doc":"Sets the horizontal and vertical alignment of row label text.\n\nHorizontal alignment should be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or\n`wxALIGN_RIGHT`. Vertical alignment should be one of `wxALIGN_TOP`,\n`wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGrid.html#setRowLabelAlignment/3"},{"type":"function","title":"wxGrid.setRowLabelSize/2","doc":"Sets the width of the row labels.\n\nIf `width` equals `wxGRID_AUTOSIZE` then width is calculated automatically so\nthat no label is truncated. Note that this could be slow for a large table.","ref":"wxGrid.html#setRowLabelSize/2"},{"type":"function","title":"wxGrid.setRowLabelValue/3","doc":"Sets the value for the given row label.\n\nIf you are using a derived grid table you must override\n`wxGridTableBase::SetRowLabelValue()` (not implemented in wx) for this to have\nany effect.","ref":"wxGrid.html#setRowLabelValue/3"},{"type":"function","title":"wxGrid.setRowMinimalAcceptableHeight/2","doc":"Sets the minimal row `height` used by default.\n\nSee `setColMinimalAcceptableWidth/2` for more information.","ref":"wxGrid.html#setRowMinimalAcceptableHeight/2"},{"type":"function","title":"wxGrid.setRowMinimalHeight/3","doc":"Sets the minimal `height` for the specified `row`.\n\nSee `setColMinimalWidth/3` for more information.","ref":"wxGrid.html#setRowMinimalHeight/3"},{"type":"function","title":"wxGrid.setRowSize/3","doc":"Sets the height of the specified row.\n\nSee `setColSize/3` for more information.","ref":"wxGrid.html#setRowSize/3"},{"type":"function","title":"wxGrid.setScrollLineX/2","doc":"Sets the number of pixels per horizontal scroll increment.\n\nThe default is 15.\n\nSee: `getScrollLineX/1`, `getScrollLineY/1`, `setScrollLineY/2`","ref":"wxGrid.html#setScrollLineX/2"},{"type":"function","title":"wxGrid.setScrollLineY/2","doc":"Sets the number of pixels per vertical scroll increment.\n\nThe default is 15.\n\nSee: `getScrollLineX/1`, `getScrollLineY/1`, `setScrollLineX/2`","ref":"wxGrid.html#setScrollLineY/2"},{"type":"function","title":"wxGrid.setSelectionBackground/2","doc":"Set the colour to be used for drawing the selection background.","ref":"wxGrid.html#setSelectionBackground/2"},{"type":"function","title":"wxGrid.setSelectionForeground/2","doc":"Set the colour to be used for drawing the selection foreground.","ref":"wxGrid.html#setSelectionForeground/2"},{"type":"function","title":"wxGrid.setSelectionMode/2","doc":"Set the selection behaviour of the grid.\n\nThe existing selection is converted to conform to the new mode if possible and\ndiscarded otherwise (e.g. any individual selected cells are deselected if the\nnew mode allows only the selection of the entire rows or columns).","ref":"wxGrid.html#setSelectionMode/2"},{"type":"function","title":"wxGrid.showCellEditControl/1","doc":"Displays the active in-place cell edit control for the current cell after it was\nhidden.\n\nThis method should only be called after calling `hideCellEditControl/1`, to\nstart editing the current grid cell use `enableCellEditControl/2` instead.","ref":"wxGrid.html#showCellEditControl/1"},{"type":"function","title":"wxGrid.xToCol/2","doc":"","ref":"wxGrid.html#xToCol/2"},{"type":"function","title":"wxGrid.xToCol/3","doc":"Returns the column at the given pixel position depending on the window.\n\nReturn: The column index or `wxNOT_FOUND`.","ref":"wxGrid.html#xToCol/3"},{"type":"function","title":"wxGrid.xToEdgeOfCol/2","doc":"Returns the column whose right hand edge is close to the given logical `x`\nposition.\n\nIf no column edge is near to this position `wxNOT_FOUND` is returned.","ref":"wxGrid.html#xToEdgeOfCol/2"},{"type":"function","title":"wxGrid.yToEdgeOfRow/2","doc":"Returns the row whose bottom edge is close to the given logical `y` position.\n\nIf no row edge is near to this position `wxNOT_FOUND` is returned.","ref":"wxGrid.html#yToEdgeOfRow/2"},{"type":"function","title":"wxGrid.yToRow/2","doc":"","ref":"wxGrid.html#yToRow/2"},{"type":"function","title":"wxGrid.yToRow/3","doc":"Returns the grid row that corresponds to the logical `y` coordinate.\n\nThe parameter `gridWindow` is new since wxWidgets 3.1.3. If it is specified,\ni.e. non-NULL, only the cells of this window are considered, i.e. the function\nreturns `wxNOT_FOUND` if `y` is out of bounds.\n\nIf `gridWindow` is NULL, the function returns `wxNOT_FOUND` only if there is no\nrow at all at the `y` position.","ref":"wxGrid.html#yToRow/3"},{"type":"type","title":"wxGrid.wxGrid/0","doc":"","ref":"wxGrid.html#t:wxGrid/0"},{"type":"module","title":"wxGridBagSizer","doc":"Functions for wxGridBagSizer class\n\nA `m:wxSizer` that can lay out items in a virtual grid like a\n`m:wxFlexGridSizer` but in this case explicit positioning of the items is\nallowed using `wxGBPosition` (not implemented in wx), and items can optionally\nspan more than one row and/or column using `wxGBSpan` (not implemented in wx).\n\nThis class is derived (and can use functions) from: `m:wxFlexGridSizer`\n`m:wxGridSizer` `m:wxSizer`\n\nwxWidgets docs:\n[wxGridBagSizer](https://docs.wxwidgets.org/3.1/classwx_grid_bag_sizer.html)","ref":"wxGridBagSizer.html"},{"type":"function","title":"wxGridBagSizer.add/2","doc":"","ref":"wxGridBagSizer.html#add/2"},{"type":"function","title":"wxGridBagSizer.add/3","doc":"","ref":"wxGridBagSizer.html#add/3"},{"type":"function","title":"wxGridBagSizer.add/4","doc":"Adds the given item to the given position.\n\nReturn: A valid pointer if the item was successfully placed at the given\nposition, or NULL if something was already there.","ref":"wxGridBagSizer.html#add/4"},{"type":"function","title":"wxGridBagSizer.add/5","doc":"Adds a spacer to the given position.\n\n`width` and `height` specify the dimension of the spacer to be added.\n\nReturn: A valid pointer if the spacer was successfully placed at the given\nposition, or NULL if something was already there.","ref":"wxGridBagSizer.html#add/5"},{"type":"function","title":"wxGridBagSizer.calcMin/1","doc":"Called when the managed size of the sizer is needed or when layout needs done.","ref":"wxGridBagSizer.html#calcMin/1"},{"type":"function","title":"wxGridBagSizer.checkForIntersection/2","doc":"","ref":"wxGridBagSizer.html#checkForIntersection/2"},{"type":"function","title":"wxGridBagSizer.checkForIntersection/3","doc":"Look at all items and see if any intersect (or would overlap) the given item.\n\nReturns true if so, false if there would be no overlap. If an `excludeItem` is\ngiven then it will not be checked for intersection, for example it may be the\nitem we are checking the position of.","ref":"wxGridBagSizer.html#checkForIntersection/3"},{"type":"function","title":"wxGridBagSizer.checkForIntersection/4","doc":"","ref":"wxGridBagSizer.html#checkForIntersection/4"},{"type":"function","title":"wxGridBagSizer.destroy/1","doc":"Destroys the object.","ref":"wxGridBagSizer.html#destroy/1"},{"type":"function","title":"wxGridBagSizer.findItem/2","doc":"Find the sizer item for the given window or subsizer, returns NULL if not found.\n\n(non-recursive)","ref":"wxGridBagSizer.html#findItem/2"},{"type":"function","title":"wxGridBagSizer.findItemAtPoint/2","doc":"Return the sizer item located at the point given in pt, or NULL if there is no\nitem at that point.\n\nThe (x,y) coordinates in `pt` correspond to the client coordinates of the window\nusing the sizer for layout. (non-recursive)","ref":"wxGridBagSizer.html#findItemAtPoint/2"},{"type":"function","title":"wxGridBagSizer.findItemAtPosition/2","doc":"Return the sizer item for the given grid cell, or NULL if there is no item at\nthat position.\n\n(non-recursive)","ref":"wxGridBagSizer.html#findItemAtPosition/2"},{"type":"function","title":"wxGridBagSizer.findItemWithData/2","doc":"Return the sizer item that has a matching user data (it only compares pointer\nvalues) or NULL if not found.\n\n(non-recursive)","ref":"wxGridBagSizer.html#findItemWithData/2"},{"type":"function","title":"wxGridBagSizer.getCellSize/3","doc":"Get the size of the specified cell, including hgap and vgap.\n\nOnly valid after window layout has been performed.","ref":"wxGridBagSizer.html#getCellSize/3"},{"type":"function","title":"wxGridBagSizer.getEmptyCellSize/1","doc":"Get the size used for cells in the grid with no item.","ref":"wxGridBagSizer.html#getEmptyCellSize/1"},{"type":"function","title":"wxGridBagSizer.getItemPosition/2","doc":"","ref":"wxGridBagSizer.html#getItemPosition/2"},{"type":"function","title":"wxGridBagSizer.getItemSpan/2","doc":"","ref":"wxGridBagSizer.html#getItemSpan/2"},{"type":"function","title":"wxGridBagSizer.new/0","doc":"","ref":"wxGridBagSizer.html#new/0"},{"type":"function","title":"wxGridBagSizer.new/1","doc":"Constructor, with optional parameters to specify the gap between the rows and\ncolumns.","ref":"wxGridBagSizer.html#new/1"},{"type":"function","title":"wxGridBagSizer.setEmptyCellSize/2","doc":"Set the size used for cells in the grid with no item.","ref":"wxGridBagSizer.html#setEmptyCellSize/2"},{"type":"function","title":"wxGridBagSizer.setItemPosition/3","doc":"","ref":"wxGridBagSizer.html#setItemPosition/3"},{"type":"function","title":"wxGridBagSizer.setItemSpan/3","doc":"","ref":"wxGridBagSizer.html#setItemSpan/3"},{"type":"type","title":"wxGridBagSizer.wxGridBagSizer/0","doc":"","ref":"wxGridBagSizer.html#t:wxGridBagSizer/0"},{"type":"module","title":"wxGridCellAttr","doc":"Functions for wxGridCellAttr class\n\nThis class can be used to alter the cells' appearance in the grid by changing\ntheir attributes from the defaults. An object of this class may be returned by\n`wxGridTableBase::GetAttr()` (not implemented in wx).\n\nNote that objects of this class are reference-counted and it's recommended to\nuse wxGridCellAttrPtr smart pointer class when working with them to avoid memory\nleaks.\n\nwxWidgets docs:\n[wxGridCellAttr](https://docs.wxwidgets.org/3.1/classwx_grid_cell_attr.html)","ref":"wxGridCellAttr.html"},{"type":"function","title":"wxGridCellAttr.getAlignment/1","doc":"Get the alignment to use for the cell with the given attribute.\n\nIf this attribute doesn't specify any alignment, the default attribute alignment\nis used (which can be changed using `wxGrid:setDefaultCellAlignment/3` but is\nleft and top by default).\n\nNotice that `hAlign` and `vAlign` values are always overwritten by this\nfunction, use `GetNonDefaultAlignment()` (not implemented in wx) if this is not\ndesirable.","ref":"wxGridCellAttr.html#getAlignment/1"},{"type":"function","title":"wxGridCellAttr.getBackgroundColour/1","doc":"Returns the background colour.","ref":"wxGridCellAttr.html#getBackgroundColour/1"},{"type":"function","title":"wxGridCellAttr.getEditor/4","doc":"Returns the cell editor.\n\nThe caller is responsible for calling `DecRef()` (not implemented in wx) on the\nreturned pointer, use `GetEditorPtr()` (not implemented in wx) to do it\nautomatically.","ref":"wxGridCellAttr.html#getEditor/4"},{"type":"function","title":"wxGridCellAttr.getFont/1","doc":"Returns the font.","ref":"wxGridCellAttr.html#getFont/1"},{"type":"function","title":"wxGridCellAttr.getRenderer/4","doc":"Returns the cell renderer.\n\nThe caller is responsible for calling `DecRef()` (not implemented in wx) on the\nreturned pointer, use `GetRendererPtr()` (not implemented in wx) to do it\nautomatically.","ref":"wxGridCellAttr.html#getRenderer/4"},{"type":"function","title":"wxGridCellAttr.getTextColour/1","doc":"Returns the text colour.","ref":"wxGridCellAttr.html#getTextColour/1"},{"type":"function","title":"wxGridCellAttr.hasAlignment/1","doc":"Returns true if this attribute has a valid alignment set.","ref":"wxGridCellAttr.html#hasAlignment/1"},{"type":"function","title":"wxGridCellAttr.hasBackgroundColour/1","doc":"Returns true if this attribute has a valid background colour set.","ref":"wxGridCellAttr.html#hasBackgroundColour/1"},{"type":"function","title":"wxGridCellAttr.hasEditor/1","doc":"Returns true if this attribute has a valid cell editor set.","ref":"wxGridCellAttr.html#hasEditor/1"},{"type":"function","title":"wxGridCellAttr.hasFont/1","doc":"Returns true if this attribute has a valid font set.","ref":"wxGridCellAttr.html#hasFont/1"},{"type":"function","title":"wxGridCellAttr.hasRenderer/1","doc":"Returns true if this attribute has a valid cell renderer set.","ref":"wxGridCellAttr.html#hasRenderer/1"},{"type":"function","title":"wxGridCellAttr.hasTextColour/1","doc":"Returns true if this attribute has a valid text colour set.","ref":"wxGridCellAttr.html#hasTextColour/1"},{"type":"function","title":"wxGridCellAttr.isReadOnly/1","doc":"Returns true if this cell is set as read-only.","ref":"wxGridCellAttr.html#isReadOnly/1"},{"type":"function","title":"wxGridCellAttr.setAlignment/3","doc":"Sets the alignment.\n\n`hAlign` can be one of `wxALIGN_LEFT`, `wxALIGN_CENTRE` or `wxALIGN_RIGHT` and\n`vAlign` can be one of `wxALIGN_TOP`, `wxALIGN_CENTRE` or `wxALIGN_BOTTOM`.","ref":"wxGridCellAttr.html#setAlignment/3"},{"type":"function","title":"wxGridCellAttr.setBackgroundColour/2","doc":"Sets the background colour.","ref":"wxGridCellAttr.html#setBackgroundColour/2"},{"type":"function","title":"wxGridCellAttr.setDefAttr/2","doc":"","ref":"wxGridCellAttr.html#setDefAttr/2"},{"type":"function","title":"wxGridCellAttr.setEditor/2","doc":"Sets the editor to be used with the cells with this attribute.","ref":"wxGridCellAttr.html#setEditor/2"},{"type":"function","title":"wxGridCellAttr.setFont/2","doc":"Sets the font.","ref":"wxGridCellAttr.html#setFont/2"},{"type":"function","title":"wxGridCellAttr.setReadOnly/1","doc":"","ref":"wxGridCellAttr.html#setReadOnly/1"},{"type":"function","title":"wxGridCellAttr.setReadOnly/2","doc":"Sets the cell as read-only.","ref":"wxGridCellAttr.html#setReadOnly/2"},{"type":"function","title":"wxGridCellAttr.setRenderer/2","doc":"Sets the renderer to be used for cells with this attribute.\n\nTakes ownership of the pointer.","ref":"wxGridCellAttr.html#setRenderer/2"},{"type":"function","title":"wxGridCellAttr.setTextColour/2","doc":"Sets the text colour.","ref":"wxGridCellAttr.html#setTextColour/2"},{"type":"type","title":"wxGridCellAttr.wxGridCellAttr/0","doc":"","ref":"wxGridCellAttr.html#t:wxGridCellAttr/0"},{"type":"module","title":"wxGridCellBoolEditor","doc":"Functions for wxGridCellBoolEditor class\n\nGrid cell editor for boolean data.\n\nSee: `m:wxGridCellEditor`, `wxGridCellAutoWrapStringEditor` (not implemented in\nwx), `m:wxGridCellChoiceEditor`, `wxGridCellEnumEditor` (not implemented in wx),\n`m:wxGridCellFloatEditor`, `m:wxGridCellNumberEditor`, `m:wxGridCellTextEditor`,\n`wxGridCellDateEditor` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxGridCellEditor`\n\nwxWidgets docs:\n[wxGridCellBoolEditor](https://docs.wxwidgets.org/3.1/classwx_grid_cell_bool_editor.html)","ref":"wxGridCellBoolEditor.html"},{"type":"function","title":"wxGridCellBoolEditor.destroy/1","doc":"Destroys the object.","ref":"wxGridCellBoolEditor.html#destroy/1"},{"type":"function","title":"wxGridCellBoolEditor.isTrueValue/1","doc":"Returns true if the given `value` is equal to the string representation of the\ntruth value we currently use (see `useStringValues/1`).","ref":"wxGridCellBoolEditor.html#isTrueValue/1"},{"type":"function","title":"wxGridCellBoolEditor.new/0","doc":"Default constructor.","ref":"wxGridCellBoolEditor.html#new/0"},{"type":"function","title":"wxGridCellBoolEditor.useStringValues/0","doc":"","ref":"wxGridCellBoolEditor.html#useStringValues/0"},{"type":"function","title":"wxGridCellBoolEditor.useStringValues/1","doc":"This method allows you to customize the values returned by\n`wxGridCellNumberEditor:getValue/1` for the cell using this editor.\n\nBy default, the default values of the arguments are used, i.e. `\"1\"` is returned\nif the cell is checked and an empty string otherwise.","ref":"wxGridCellBoolEditor.html#useStringValues/1"},{"type":"type","title":"wxGridCellBoolEditor.wxGridCellBoolEditor/0","doc":"","ref":"wxGridCellBoolEditor.html#t:wxGridCellBoolEditor/0"},{"type":"module","title":"wxGridCellBoolRenderer","doc":"Functions for wxGridCellBoolRenderer class\n\nThis class may be used to format boolean data in a cell.\n\nSee: `m:wxGridCellRenderer`, `wxGridCellAutoWrapStringRenderer` (not implemented\nin wx), `wxGridCellDateTimeRenderer` (not implemented in wx),\n`wxGridCellEnumRenderer` (not implemented in wx), `m:wxGridCellFloatRenderer`,\n`m:wxGridCellNumberRenderer`, `m:wxGridCellStringRenderer`\n\nThis class is derived (and can use functions) from: `m:wxGridCellRenderer`\n\nwxWidgets docs:\n[wxGridCellBoolRenderer](https://docs.wxwidgets.org/3.1/classwx_grid_cell_bool_renderer.html)","ref":"wxGridCellBoolRenderer.html"},{"type":"function","title":"wxGridCellBoolRenderer.destroy/1","doc":"Destroys the object.","ref":"wxGridCellBoolRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellBoolRenderer.new/0","doc":"","ref":"wxGridCellBoolRenderer.html#new/0"},{"type":"type","title":"wxGridCellBoolRenderer.wxGridCellBoolRenderer/0","doc":"","ref":"wxGridCellBoolRenderer.html#t:wxGridCellBoolRenderer/0"},{"type":"module","title":"wxGridCellChoiceEditor","doc":"Functions for wxGridCellChoiceEditor class\n\nGrid cell editor for string data providing the user a choice from a list of\nstrings.\n\nSee: `m:wxGridCellEditor`, `wxGridCellAutoWrapStringEditor` (not implemented in\nwx), `m:wxGridCellBoolEditor`, `wxGridCellEnumEditor` (not implemented in wx),\n`m:wxGridCellFloatEditor`, `m:wxGridCellNumberEditor`, `m:wxGridCellTextEditor`,\n`wxGridCellDateEditor` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxGridCellEditor`\n\nwxWidgets docs:\n[wxGridCellChoiceEditor](https://docs.wxwidgets.org/3.1/classwx_grid_cell_choice_editor.html)","ref":"wxGridCellChoiceEditor.html"},{"type":"function","title":"wxGridCellChoiceEditor.destroy/1","doc":"Destroys the object.","ref":"wxGridCellChoiceEditor.html#destroy/1"},{"type":"function","title":"wxGridCellChoiceEditor.new/1","doc":"","ref":"wxGridCellChoiceEditor.html#new/1"},{"type":"function","title":"wxGridCellChoiceEditor.new/2","doc":"Choice cell renderer ctor.","ref":"wxGridCellChoiceEditor.html#new/2"},{"type":"function","title":"wxGridCellChoiceEditor.setParameters/2","doc":"Parameters string format is \"item1\\[,item2[...,itemN]]\".\n\nThis method can be called before the editor is used for the first time, or\nlater, in which case it replaces the previously specified strings with the new\nones.","ref":"wxGridCellChoiceEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellChoiceEditor.wxGridCellChoiceEditor/0","doc":"","ref":"wxGridCellChoiceEditor.html#t:wxGridCellChoiceEditor/0"},{"type":"module","title":"wxGridCellEditor","doc":"Functions for wxGridCellEditor class\n\nThis class is responsible for providing and manipulating the in-place edit\ncontrols for the grid. Instances of `m:wxGridCellEditor` (actually, instances of\nderived classes since it is an abstract class) can be associated with the cell\nattributes for individual cells, rows, columns, or even for the entire grid.\n\nNormally `m:wxGridCellEditor` shows some UI control allowing the user to edit\nthe cell, but starting with wxWidgets 3.1.4 it's also possible to define\n\"activatable\" cell editors, that change the value of the cell directly when it's\nactivated (typically by pressing Space key or clicking on it), see\n`TryActivate()` (not implemented in wx) method. Note that when implementing an\neditor which is always activatable, i.e. never shows any in-place editor, it is\nmore convenient to derive its class from `wxGridCellActivatableEditor` (not\nimplemented in wx) than from `m:wxGridCellEditor` itself.\n\nSee: `wxGridCellAutoWrapStringEditor` (not implemented in wx),\n`m:wxGridCellBoolEditor`, `m:wxGridCellChoiceEditor`, `wxGridCellEnumEditor`\n(not implemented in wx), `m:wxGridCellFloatEditor`, `m:wxGridCellNumberEditor`,\n`m:wxGridCellTextEditor`, `wxGridCellDateEditor` (not implemented in wx)\n\nwxWidgets docs:\n[wxGridCellEditor](https://docs.wxwidgets.org/3.1/classwx_grid_cell_editor.html)","ref":"wxGridCellEditor.html"},{"type":"function","title":"wxGridCellEditor.create/4","doc":"Creates the actual edit control.","ref":"wxGridCellEditor.html#create/4"},{"type":"function","title":"wxGridCellEditor.handleReturn/2","doc":"Some types of controls on some platforms may need some help with the Return key.","ref":"wxGridCellEditor.html#handleReturn/2"},{"type":"function","title":"wxGridCellEditor.isCreated/1","doc":"Returns true if the edit control has been created.","ref":"wxGridCellEditor.html#isCreated/1"},{"type":"function","title":"wxGridCellEditor.reset/1","doc":"Reset the value in the control back to its starting value.","ref":"wxGridCellEditor.html#reset/1"},{"type":"function","title":"wxGridCellEditor.setSize/2","doc":"Size and position the edit control.","ref":"wxGridCellEditor.html#setSize/2"},{"type":"function","title":"wxGridCellEditor.show/2","doc":"","ref":"wxGridCellEditor.html#show/2"},{"type":"function","title":"wxGridCellEditor.show/3","doc":"Show or hide the edit control, use the specified attributes to set colours/fonts\nfor it.","ref":"wxGridCellEditor.html#show/3"},{"type":"function","title":"wxGridCellEditor.startingClick/1","doc":"If the editor is enabled by clicking on the cell, this method will be called.","ref":"wxGridCellEditor.html#startingClick/1"},{"type":"function","title":"wxGridCellEditor.startingKey/2","doc":"If the editor is enabled by pressing keys on the grid, this will be called to\nlet the editor do something about that first key if desired.","ref":"wxGridCellEditor.html#startingKey/2"},{"type":"type","title":"wxGridCellEditor.wxGridCellEditor/0","doc":"","ref":"wxGridCellEditor.html#t:wxGridCellEditor/0"},{"type":"module","title":"wxGridCellFloatEditor","doc":"Functions for wxGridCellFloatEditor class\n\nThe editor for floating point numbers data.\n\nSee: `m:wxGridCellEditor`, `wxGridCellAutoWrapStringEditor` (not implemented in\nwx), `m:wxGridCellBoolEditor`, `m:wxGridCellChoiceEditor`,\n`wxGridCellEnumEditor` (not implemented in wx), `m:wxGridCellNumberEditor`,\n`m:wxGridCellTextEditor`, `wxGridCellDateEditor` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxGridCellEditor`\n\nwxWidgets docs:\n[wxGridCellFloatEditor](https://docs.wxwidgets.org/3.1/classwx_grid_cell_float_editor.html)","ref":"wxGridCellFloatEditor.html"},{"type":"function","title":"wxGridCellFloatEditor.destroy/1","doc":"Destroys the object.","ref":"wxGridCellFloatEditor.html#destroy/1"},{"type":"function","title":"wxGridCellFloatEditor.new/0","doc":"","ref":"wxGridCellFloatEditor.html#new/0"},{"type":"function","title":"wxGridCellFloatEditor.new/1","doc":"Float cell editor ctor.","ref":"wxGridCellFloatEditor.html#new/1"},{"type":"function","title":"wxGridCellFloatEditor.setParameters/2","doc":"The parameters string format is \"width\\[,precision[,format]]\" where `format`\nshould be chosen between f|e|g|E|G (f is used by default)","ref":"wxGridCellFloatEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellFloatEditor.wxGridCellFloatEditor/0","doc":"","ref":"wxGridCellFloatEditor.html#t:wxGridCellFloatEditor/0"},{"type":"module","title":"wxGridCellFloatRenderer","doc":"Functions for wxGridCellFloatRenderer class\n\nThis class may be used to format floating point data in a cell.\n\nSee: `m:wxGridCellRenderer`, `wxGridCellAutoWrapStringRenderer` (not implemented\nin wx), `m:wxGridCellBoolRenderer`, `wxGridCellDateTimeRenderer` (not\nimplemented in wx), `wxGridCellEnumRenderer` (not implemented in wx),\n`m:wxGridCellNumberRenderer`, `m:wxGridCellStringRenderer`\n\nThis class is derived (and can use functions) from: `m:wxGridCellStringRenderer`\n`m:wxGridCellRenderer`\n\nwxWidgets docs:\n[wxGridCellFloatRenderer](https://docs.wxwidgets.org/3.1/classwx_grid_cell_float_renderer.html)","ref":"wxGridCellFloatRenderer.html"},{"type":"function","title":"wxGridCellFloatRenderer.destroy/1","doc":"Destroys the object.","ref":"wxGridCellFloatRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellFloatRenderer.getPrecision/1","doc":"Returns the precision.","ref":"wxGridCellFloatRenderer.html#getPrecision/1"},{"type":"function","title":"wxGridCellFloatRenderer.getWidth/1","doc":"Returns the width.","ref":"wxGridCellFloatRenderer.html#getWidth/1"},{"type":"function","title":"wxGridCellFloatRenderer.new/0","doc":"","ref":"wxGridCellFloatRenderer.html#new/0"},{"type":"function","title":"wxGridCellFloatRenderer.new/1","doc":"Float cell renderer ctor.","ref":"wxGridCellFloatRenderer.html#new/1"},{"type":"function","title":"wxGridCellFloatRenderer.setParameters/2","doc":"The parameters string format is \"width\\[,precision[,format]]\" where `format`\nshould be chosen between f|e|g|E|G (f is used by default)","ref":"wxGridCellFloatRenderer.html#setParameters/2"},{"type":"function","title":"wxGridCellFloatRenderer.setPrecision/2","doc":"Sets the precision.","ref":"wxGridCellFloatRenderer.html#setPrecision/2"},{"type":"function","title":"wxGridCellFloatRenderer.setWidth/2","doc":"Sets the width.","ref":"wxGridCellFloatRenderer.html#setWidth/2"},{"type":"type","title":"wxGridCellFloatRenderer.wxGridCellFloatRenderer/0","doc":"","ref":"wxGridCellFloatRenderer.html#t:wxGridCellFloatRenderer/0"},{"type":"module","title":"wxGridCellNumberEditor","doc":"Functions for wxGridCellNumberEditor class\n\nGrid cell editor for numeric integer data.\n\nSee: `m:wxGridCellEditor`, `wxGridCellAutoWrapStringEditor` (not implemented in\nwx), `m:wxGridCellBoolEditor`, `m:wxGridCellChoiceEditor`,\n`wxGridCellEnumEditor` (not implemented in wx), `m:wxGridCellFloatEditor`,\n`m:wxGridCellTextEditor`, `wxGridCellDateEditor` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxGridCellTextEditor`\n`m:wxGridCellEditor`\n\nwxWidgets docs:\n[wxGridCellNumberEditor](https://docs.wxwidgets.org/3.1/classwx_grid_cell_number_editor.html)","ref":"wxGridCellNumberEditor.html"},{"type":"function","title":"wxGridCellNumberEditor.destroy/1","doc":"Destroys the object.","ref":"wxGridCellNumberEditor.html#destroy/1"},{"type":"function","title":"wxGridCellNumberEditor.getValue/1","doc":"Returns the value currently in the editor control.","ref":"wxGridCellNumberEditor.html#getValue/1"},{"type":"function","title":"wxGridCellNumberEditor.new/0","doc":"","ref":"wxGridCellNumberEditor.html#new/0"},{"type":"function","title":"wxGridCellNumberEditor.new/1","doc":"Allows you to specify the range for acceptable data.\n\nValues equal to -1 for both `min` and `max` indicate that no range checking\nshould be done.","ref":"wxGridCellNumberEditor.html#new/1"},{"type":"function","title":"wxGridCellNumberEditor.setParameters/2","doc":"Parameters string format is \"min,max\".","ref":"wxGridCellNumberEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellNumberEditor.wxGridCellNumberEditor/0","doc":"","ref":"wxGridCellNumberEditor.html#t:wxGridCellNumberEditor/0"},{"type":"module","title":"wxGridCellNumberRenderer","doc":"Functions for wxGridCellNumberRenderer class\n\nThis class may be used to format integer data in a cell.\n\nSee: `m:wxGridCellRenderer`, `wxGridCellAutoWrapStringRenderer` (not implemented\nin wx), `m:wxGridCellBoolRenderer`, `wxGridCellDateTimeRenderer` (not\nimplemented in wx), `wxGridCellEnumRenderer` (not implemented in wx),\n`m:wxGridCellFloatRenderer`, `m:wxGridCellStringRenderer`\n\nThis class is derived (and can use functions) from: `m:wxGridCellStringRenderer`\n`m:wxGridCellRenderer`\n\nwxWidgets docs:\n[wxGridCellNumberRenderer](https://docs.wxwidgets.org/3.1/classwx_grid_cell_number_renderer.html)","ref":"wxGridCellNumberRenderer.html"},{"type":"function","title":"wxGridCellNumberRenderer.destroy/1","doc":"Destroys the object.","ref":"wxGridCellNumberRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellNumberRenderer.new/0","doc":"Default constructor.","ref":"wxGridCellNumberRenderer.html#new/0"},{"type":"type","title":"wxGridCellNumberRenderer.wxGridCellNumberRenderer/0","doc":"","ref":"wxGridCellNumberRenderer.html#t:wxGridCellNumberRenderer/0"},{"type":"module","title":"wxGridCellRenderer","doc":"Functions for wxGridCellRenderer class\n\nThis class is responsible for actually drawing the cell in the grid. You may\npass it to the `m:wxGridCellAttr` (below) to change the format of one given cell\nor to `wxGrid:setDefaultRenderer/2` to change the view of all cells. This is an\nabstract class, and you will normally use one of the predefined derived classes\nor derive your own class from it.\n\nSee: `wxGridCellAutoWrapStringRenderer` (not implemented in wx),\n`m:wxGridCellBoolRenderer`, `wxGridCellDateTimeRenderer` (not implemented in\nwx), `wxGridCellEnumRenderer` (not implemented in wx),\n`m:wxGridCellFloatRenderer`, `m:wxGridCellNumberRenderer`,\n`m:wxGridCellStringRenderer`\n\nwxWidgets docs:\n[wxGridCellRenderer](https://docs.wxwidgets.org/3.1/classwx_grid_cell_renderer.html)","ref":"wxGridCellRenderer.html"},{"type":"function","title":"wxGridCellRenderer.draw/8","doc":"Draw the given cell on the provided DC inside the given rectangle using the\nstyle specified by the attribute and the default or selected state corresponding\nto the isSelected value.\n\nThis pure virtual function has a default implementation which will prepare the\nDC using the given attribute: it will draw the rectangle with the background\ncolour from attr and set the text colour and font.","ref":"wxGridCellRenderer.html#draw/8"},{"type":"function","title":"wxGridCellRenderer.getBestSize/6","doc":"Get the preferred size of the cell for its contents.\n\nThis method must be overridden in the derived classes to return the minimal\nfitting size for displaying the content of the given grid cell.\n\nSee: `GetBestHeight()` (not implemented in wx), `GetBestWidth()` (not\nimplemented in wx)","ref":"wxGridCellRenderer.html#getBestSize/6"},{"type":"type","title":"wxGridCellRenderer.wxGridCellRenderer/0","doc":"","ref":"wxGridCellRenderer.html#t:wxGridCellRenderer/0"},{"type":"module","title":"wxGridCellStringRenderer","doc":"Functions for wxGridCellStringRenderer class\n\nThis class may be used to format string data in a cell; it is the default for\nstring cells.\n\nSee: `m:wxGridCellRenderer`, `wxGridCellAutoWrapStringRenderer` (not implemented\nin wx), `m:wxGridCellBoolRenderer`, `wxGridCellDateTimeRenderer` (not\nimplemented in wx), `wxGridCellEnumRenderer` (not implemented in wx),\n`m:wxGridCellFloatRenderer`, `m:wxGridCellNumberRenderer`\n\nThis class is derived (and can use functions) from: `m:wxGridCellRenderer`\n\nwxWidgets docs:\n[wxGridCellStringRenderer](https://docs.wxwidgets.org/3.1/classwx_grid_cell_string_renderer.html)","ref":"wxGridCellStringRenderer.html"},{"type":"function","title":"wxGridCellStringRenderer.destroy/1","doc":"Destroys the object.","ref":"wxGridCellStringRenderer.html#destroy/1"},{"type":"function","title":"wxGridCellStringRenderer.new/0","doc":"","ref":"wxGridCellStringRenderer.html#new/0"},{"type":"type","title":"wxGridCellStringRenderer.wxGridCellStringRenderer/0","doc":"","ref":"wxGridCellStringRenderer.html#t:wxGridCellStringRenderer/0"},{"type":"module","title":"wxGridCellTextEditor","doc":"Functions for wxGridCellTextEditor class\n\nGrid cell editor for string/text data.\n\nSee: `m:wxGridCellEditor`, `wxGridCellAutoWrapStringEditor` (not implemented in\nwx), `m:wxGridCellBoolEditor`, `m:wxGridCellChoiceEditor`,\n`wxGridCellEnumEditor` (not implemented in wx), `m:wxGridCellFloatEditor`,\n`m:wxGridCellNumberEditor`, `wxGridCellDateEditor` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxGridCellEditor`\n\nwxWidgets docs:\n[wxGridCellTextEditor](https://docs.wxwidgets.org/3.1/classwx_grid_cell_text_editor.html)","ref":"wxGridCellTextEditor.html"},{"type":"function","title":"wxGridCellTextEditor.destroy/1","doc":"Destroys the object.","ref":"wxGridCellTextEditor.html#destroy/1"},{"type":"function","title":"wxGridCellTextEditor.new/0","doc":"","ref":"wxGridCellTextEditor.html#new/0"},{"type":"function","title":"wxGridCellTextEditor.new/1","doc":"Text cell editor constructor.","ref":"wxGridCellTextEditor.html#new/1"},{"type":"function","title":"wxGridCellTextEditor.setParameters/2","doc":"The parameters string format is \"n\" where n is a number representing the maximum\nwidth.","ref":"wxGridCellTextEditor.html#setParameters/2"},{"type":"type","title":"wxGridCellTextEditor.wxGridCellTextEditor/0","doc":"","ref":"wxGridCellTextEditor.html#t:wxGridCellTextEditor/0"},{"type":"module","title":"wxGridEvent","doc":"Functions for wxGridEvent class\n\nThis event class contains information about various grid events.\n\nNotice that all grid event table macros are available in two versions:\n`EVT_GRID_XXX` and `EVT_GRID_CMD_XXX`. The only difference between the two is\nthat the former doesn't allow to specify the grid window identifier and so takes\na single parameter, the event handler, but is not suitable if there is more than\none grid control in the window where the event table is used (as it would catch\nthe events from all the grids). The version with `CMD` takes the id as first\nargument and the event handler as the second one and so can be used with\nmultiple grids as well. Otherwise there are no difference between the two and\nonly the versions without the id are documented below for brevity.\n\nThis class is derived (and can use functions) from: `m:wxNotifyEvent`\n`m:wxCommandEvent` `m:wxEvent`\n\nwxWidgets docs:\n[wxGridEvent](https://docs.wxwidgets.org/3.1/classwx_grid_event.html)","ref":"wxGridEvent.html"},{"type":"module","title":"Events - wxGridEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxGridEventType`](`t:wxGridEventType/0`) to\nsubscribe to events of this type.","ref":"wxGridEvent.html#module-events"},{"type":"function","title":"wxGridEvent.altDown/1","doc":"Returns true if the Alt key was down at the time of the event.","ref":"wxGridEvent.html#altDown/1"},{"type":"function","title":"wxGridEvent.controlDown/1","doc":"Returns true if the Control key was down at the time of the event.","ref":"wxGridEvent.html#controlDown/1"},{"type":"function","title":"wxGridEvent.getCol/1","doc":"Column at which the event occurred.\n\nNotice that for a `wxEVT_GRID_SELECT_CELL` event this column is the column of\nthe newly selected cell while the previously selected cell can be retrieved\nusing `wxGrid:getGridCursorCol/1`.","ref":"wxGridEvent.html#getCol/1"},{"type":"function","title":"wxGridEvent.getPosition/1","doc":"Position in pixels at which the event occurred.","ref":"wxGridEvent.html#getPosition/1"},{"type":"function","title":"wxGridEvent.getRow/1","doc":"Row at which the event occurred.\n\nNotice that for a `wxEVT_GRID_SELECT_CELL` event this row is the row of the\nnewly selected cell while the previously selected cell can be retrieved using\n`wxGrid:getGridCursorRow/1`.","ref":"wxGridEvent.html#getRow/1"},{"type":"function","title":"wxGridEvent.metaDown/1","doc":"Returns true if the Meta key was down at the time of the event.","ref":"wxGridEvent.html#metaDown/1"},{"type":"function","title":"wxGridEvent.selecting/1","doc":"Returns true if the user is selecting grid cells, or false if deselecting.","ref":"wxGridEvent.html#selecting/1"},{"type":"function","title":"wxGridEvent.shiftDown/1","doc":"Returns true if the Shift key was down at the time of the event.","ref":"wxGridEvent.html#shiftDown/1"},{"type":"type","title":"wxGridEvent.wxGrid/0","doc":"","ref":"wxGridEvent.html#t:wxGrid/0"},{"type":"type","title":"wxGridEvent.wxGridEvent/0","doc":"","ref":"wxGridEvent.html#t:wxGridEvent/0"},{"type":"type","title":"wxGridEvent.wxGridEventType/0","doc":"","ref":"wxGridEvent.html#t:wxGridEventType/0"},{"type":"module","title":"wxGridSizer","doc":"Functions for wxGridSizer class\n\nA grid sizer is a sizer which lays out its children in a two-dimensional table\nwith all table fields having the same size, i.e. the width of each field is the\nwidth of the widest child, the height of each field is the height of the tallest\nchild.\n\nSee: `m:wxSizer`,\n[Overview sizer](https://docs.wxwidgets.org/3.1/overview_sizer.html#overview_sizer)\n\nThis class is derived (and can use functions) from: `m:wxSizer`\n\nwxWidgets docs:\n[wxGridSizer](https://docs.wxwidgets.org/3.1/classwx_grid_sizer.html)","ref":"wxGridSizer.html"},{"type":"function","title":"wxGridSizer.destroy/1","doc":"Destroys the object.","ref":"wxGridSizer.html#destroy/1"},{"type":"function","title":"wxGridSizer.getCols/1","doc":"Returns the number of columns that has been specified for the sizer.\n\nReturns zero if the sizer is automatically adjusting the number of columns\ndepending on number of its children. To get the effective number of columns or\nrows being currently used, see `GetEffectiveColsCount()` (not implemented in wx)","ref":"wxGridSizer.html#getCols/1"},{"type":"function","title":"wxGridSizer.getHGap/1","doc":"Returns the horizontal gap (in pixels) between cells in the sizer.","ref":"wxGridSizer.html#getHGap/1"},{"type":"function","title":"wxGridSizer.getRows/1","doc":"Returns the number of rows that has been specified for the sizer.\n\nReturns zero if the sizer is automatically adjusting the number of rows\ndepending on number of its children. To get the effective number of columns or\nrows being currently used, see `GetEffectiveRowsCount()` (not implemented in\nwx).","ref":"wxGridSizer.html#getRows/1"},{"type":"function","title":"wxGridSizer.getVGap/1","doc":"Returns the vertical gap (in pixels) between the cells in the sizer.","ref":"wxGridSizer.html#getVGap/1"},{"type":"function","title":"wxGridSizer.new/1","doc":"","ref":"wxGridSizer.html#new/1"},{"type":"function","title":"wxGridSizer.new/2","doc":"","ref":"wxGridSizer.html#new/2"},{"type":"function","title":"wxGridSizer.new/3","doc":"","ref":"wxGridSizer.html#new/3"},{"type":"function","title":"wxGridSizer.new/4","doc":"","ref":"wxGridSizer.html#new/4"},{"type":"function","title":"wxGridSizer.setCols/2","doc":"Sets the number of columns in the sizer.","ref":"wxGridSizer.html#setCols/2"},{"type":"function","title":"wxGridSizer.setHGap/2","doc":"Sets the horizontal gap (in pixels) between cells in the sizer.","ref":"wxGridSizer.html#setHGap/2"},{"type":"function","title":"wxGridSizer.setRows/2","doc":"Sets the number of rows in the sizer.","ref":"wxGridSizer.html#setRows/2"},{"type":"function","title":"wxGridSizer.setVGap/2","doc":"Sets the vertical gap (in pixels) between the cells in the sizer.","ref":"wxGridSizer.html#setVGap/2"},{"type":"type","title":"wxGridSizer.wxGridSizer/0","doc":"","ref":"wxGridSizer.html#t:wxGridSizer/0"},{"type":"module","title":"wxHelpEvent","doc":"Functions for wxHelpEvent class\n\nA help event is sent when the user has requested context-sensitive help. This\ncan either be caused by the application requesting context-sensitive help mode\nvia `wxContextHelp` (not implemented in wx), or (on MS Windows) by the system\ngenerating a WM_HELP message when the user pressed F1 or clicked on the query\nbutton in a dialog caption.\n\nA help event is sent to the window that the user clicked on, and is propagated\nup the window hierarchy until the event is processed or there are no more event\nhandlers.\n\nThe application should call `wxEvent:getId/1` to check the identity of the\nclicked-on window, and then either show some suitable help or call\n`wxEvent:skip/2` if the identifier is unrecognised.\n\nCalling Skip is important because it allows wxWidgets to generate further events\nfor ancestors of the clicked-on window. Otherwise it would be impossible to show\nhelp for container windows, since processing would stop after the first window\nfound.\n\nSee: `wxContextHelp` (not implemented in wx), `m:wxDialog`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxHelpEvent](https://docs.wxwidgets.org/3.1/classwx_help_event.html)","ref":"wxHelpEvent.html"},{"type":"module","title":"Events - wxHelpEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxHelpEventType`](`t:wxHelpEventType/0`) to\nsubscribe to events of this type.","ref":"wxHelpEvent.html#module-events"},{"type":"function","title":"wxHelpEvent.getOrigin/1","doc":"Returns the origin of the help event which is one of the `wxHelpEvent::Origin`\n(not implemented in wx) values.\n\nThe application may handle events generated using the keyboard or mouse\ndifferently, e.g. by using `wx_misc:getMousePosition/0` for the mouse events.\n\nSee: `setOrigin/2`","ref":"wxHelpEvent.html#getOrigin/1"},{"type":"function","title":"wxHelpEvent.getPosition/1","doc":"Returns the left-click position of the mouse, in screen coordinates.\n\nThis allows the application to position the help appropriately.","ref":"wxHelpEvent.html#getPosition/1"},{"type":"function","title":"wxHelpEvent.setOrigin/2","doc":"Set the help event origin, only used internally by wxWidgets normally.\n\nSee: `getOrigin/1`","ref":"wxHelpEvent.html#setOrigin/2"},{"type":"function","title":"wxHelpEvent.setPosition/2","doc":"Sets the left-click position of the mouse, in screen coordinates.","ref":"wxHelpEvent.html#setPosition/2"},{"type":"type","title":"wxHelpEvent.wxHelp/0","doc":"","ref":"wxHelpEvent.html#t:wxHelp/0"},{"type":"type","title":"wxHelpEvent.wxHelpEvent/0","doc":"","ref":"wxHelpEvent.html#t:wxHelpEvent/0"},{"type":"type","title":"wxHelpEvent.wxHelpEventType/0","doc":"","ref":"wxHelpEvent.html#t:wxHelpEventType/0"},{"type":"module","title":"wxHtmlEasyPrinting","doc":"Functions for wxHtmlEasyPrinting class\n\nThis class provides very simple interface to printing architecture. It allows\nyou to print HTML documents using only a few commands.\n\nNote: Do not create this class on the stack only. You should create an instance\non app startup and use this instance for all printing operations. The reason is\nthat this class stores various settings in it.\n\nwxWidgets docs:\n[wxHtmlEasyPrinting](https://docs.wxwidgets.org/3.1/classwx_html_easy_printing.html)","ref":"wxHtmlEasyPrinting.html"},{"type":"function","title":"wxHtmlEasyPrinting.destroy/1","doc":"Destroys the object.","ref":"wxHtmlEasyPrinting.html#destroy/1"},{"type":"function","title":"wxHtmlEasyPrinting.getPageSetupData/1","doc":"Returns a pointer to `m:wxPageSetupDialogData` instance used by this class.\n\nYou can set its parameters (via SetXXXX methods).","ref":"wxHtmlEasyPrinting.html#getPageSetupData/1"},{"type":"function","title":"wxHtmlEasyPrinting.getPrintData/1","doc":"Returns pointer to `m:wxPrintData` instance used by this class.\n\nYou can set its parameters (via SetXXXX methods).","ref":"wxHtmlEasyPrinting.html#getPrintData/1"},{"type":"function","title":"wxHtmlEasyPrinting.new/0","doc":"","ref":"wxHtmlEasyPrinting.html#new/0"},{"type":"function","title":"wxHtmlEasyPrinting.new/1","doc":"Constructor.","ref":"wxHtmlEasyPrinting.html#new/1"},{"type":"function","title":"wxHtmlEasyPrinting.pageSetup/1","doc":"Display page setup dialog and allows the user to modify settings.","ref":"wxHtmlEasyPrinting.html#pageSetup/1"},{"type":"function","title":"wxHtmlEasyPrinting.previewFile/2","doc":"Preview HTML file.\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed\ninformation about the kind of the error.","ref":"wxHtmlEasyPrinting.html#previewFile/2"},{"type":"function","title":"wxHtmlEasyPrinting.previewText/2","doc":"","ref":"wxHtmlEasyPrinting.html#previewText/2"},{"type":"function","title":"wxHtmlEasyPrinting.previewText/3","doc":"Preview HTML text (not file\\!).\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed\ninformation about the kind of the error.","ref":"wxHtmlEasyPrinting.html#previewText/3"},{"type":"function","title":"wxHtmlEasyPrinting.printFile/2","doc":"Print HTML file.\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed\ninformation about the kind of the error.","ref":"wxHtmlEasyPrinting.html#printFile/2"},{"type":"function","title":"wxHtmlEasyPrinting.printText/2","doc":"","ref":"wxHtmlEasyPrinting.html#printText/2"},{"type":"function","title":"wxHtmlEasyPrinting.printText/3","doc":"Print HTML text (not file\\!).\n\nReturns false in case of error - call `wxPrinter:getLastError/0` to get detailed\ninformation about the kind of the error.","ref":"wxHtmlEasyPrinting.html#printText/3"},{"type":"function","title":"wxHtmlEasyPrinting.setFonts/3","doc":"","ref":"wxHtmlEasyPrinting.html#setFonts/3"},{"type":"function","title":"wxHtmlEasyPrinting.setFonts/4","doc":"Sets fonts.\n\nSee `wxHtmlDCRenderer::SetFonts` (not implemented in wx) for detailed\ndescription.","ref":"wxHtmlEasyPrinting.html#setFonts/4"},{"type":"function","title":"wxHtmlEasyPrinting.setFooter/2","doc":"","ref":"wxHtmlEasyPrinting.html#setFooter/2"},{"type":"function","title":"wxHtmlEasyPrinting.setFooter/3","doc":"Set page footer.\n\nThe following macros can be used inside it: @DATE@ is replaced by the current\ndate in default format @PAGENUM@ is replaced by page number @PAGESCNT@ is\nreplaced by total number of pages @TIME@ is replaced by the current time in\ndefault format @TITLE@ is replaced with the title of the document","ref":"wxHtmlEasyPrinting.html#setFooter/3"},{"type":"function","title":"wxHtmlEasyPrinting.setHeader/2","doc":"","ref":"wxHtmlEasyPrinting.html#setHeader/2"},{"type":"function","title":"wxHtmlEasyPrinting.setHeader/3","doc":"Set page header.\n\nThe following macros can be used inside it:","ref":"wxHtmlEasyPrinting.html#setHeader/3"},{"type":"type","title":"wxHtmlEasyPrinting.wxHtmlEasyPrinting/0","doc":"","ref":"wxHtmlEasyPrinting.html#t:wxHtmlEasyPrinting/0"},{"type":"module","title":"wxHtmlLinkEvent","doc":"Functions for wxHtmlLinkEvent class\n\nThis event class is used for the events generated by `m:wxHtmlWindow`.\n\nThis class is derived (and can use functions) from: `m:wxCommandEvent`\n`m:wxEvent`\n\nwxWidgets docs:\n[wxHtmlLinkEvent](https://docs.wxwidgets.org/3.1/classwx_html_link_event.html)","ref":"wxHtmlLinkEvent.html"},{"type":"module","title":"Events - wxHtmlLinkEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxHtmlLinkEventType`](`t:wxHtmlLinkEventType/0`) to subscribe to events of\nthis type.","ref":"wxHtmlLinkEvent.html#module-events"},{"type":"function","title":"wxHtmlLinkEvent.getLinkInfo/1","doc":"Returns the [`wx_wxHtmlLinkInfo()`](`t:wx:wx_wxHtmlLinkInfo/0`) which contains\ninfo about the cell clicked and the hyperlink it contains.","ref":"wxHtmlLinkEvent.html#getLinkInfo/1"},{"type":"type","title":"wxHtmlLinkEvent.wxHtmlLink/0","doc":"","ref":"wxHtmlLinkEvent.html#t:wxHtmlLink/0"},{"type":"type","title":"wxHtmlLinkEvent.wxHtmlLinkEvent/0","doc":"","ref":"wxHtmlLinkEvent.html#t:wxHtmlLinkEvent/0"},{"type":"type","title":"wxHtmlLinkEvent.wxHtmlLinkEventType/0","doc":"","ref":"wxHtmlLinkEvent.html#t:wxHtmlLinkEventType/0"},{"type":"module","title":"wxHtmlWindow","doc":"Functions for wxHtmlWindow class\n\n`m:wxHtmlWindow` is probably the only class you will directly use unless you\nwant to do something special (like adding new tag handlers or MIME filters).\n\nThe purpose of this class is to display rich content pages (either local file or\ndownloaded via HTTP protocol) in a window based on a subset of the HTML\nstandard. The width of the window is constant, given in the constructor and\nvirtual height is changed dynamically depending on page size. Once the window is\ncreated you can set its content by calling `setPage/2` with raw HTML,\n`loadPage/2` with a `wxFileSystem` (not implemented in wx) location or\n`loadFile/2` with a filename.\n\nNote: If you want complete HTML/CSS support as well as a Javascript engine,\nconsider using `m:wxWebView` instead.\n\n`m:wxHtmlWindow` uses the `m:wxImage` class for displaying images, so you need\nto initialize the handlers for any image formats you use before loading a page.\nSee ?wxInitAllImageHandlers and `wxImage::AddHandler` (not implemented in wx).\n\nStyles\n\nThis class supports the following styles:\n\nSee: `m:wxHtmlLinkEvent`, `wxHtmlCellEvent` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxScrolledWindow`\n`m:wxPanel` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxHtmlWindow](https://docs.wxwidgets.org/3.1/classwx_html_window.html)","ref":"wxHtmlWindow.html"},{"type":"module","title":"Events - wxHtmlWindow","doc":"Event types emitted from this class: [`html_cell_clicked`](`m:wxHtmlLinkEvent`),\n[`html_cell_hover`](`m:wxHtmlLinkEvent`),\n[`command_html_link_clicked`](`m:wxHtmlLinkEvent`)","ref":"wxHtmlWindow.html#module-events"},{"type":"function","title":"wxHtmlWindow.appendToPage/2","doc":"Appends HTML fragment to currently displayed text and refreshes the window.\n\nReturn: false if an error occurred, true otherwise.","ref":"wxHtmlWindow.html#appendToPage/2"},{"type":"function","title":"wxHtmlWindow.destroy/1","doc":"Destroys the object.","ref":"wxHtmlWindow.html#destroy/1"},{"type":"function","title":"wxHtmlWindow.getOpenedAnchor/1","doc":"Returns anchor within currently opened page (see `getOpenedPage/1`).\n\nIf no page is opened or if the displayed page wasn't produced by call to\n`loadPage/2`, empty string is returned.","ref":"wxHtmlWindow.html#getOpenedAnchor/1"},{"type":"function","title":"wxHtmlWindow.getOpenedPage/1","doc":"Returns full location of the opened page.\n\nIf no page is opened or if the displayed page wasn't produced by call to\n`loadPage/2`, empty string is returned.","ref":"wxHtmlWindow.html#getOpenedPage/1"},{"type":"function","title":"wxHtmlWindow.getOpenedPageTitle/1","doc":"Returns title of the opened page or wxEmptyString if the current page does not\ncontain   tag.","ref":"wxHtmlWindow.html#getOpenedPageTitle/1"},{"type":"function","title":"wxHtmlWindow.getRelatedFrame/1","doc":"Returns the related frame.","ref":"wxHtmlWindow.html#getRelatedFrame/1"},{"type":"function","title":"wxHtmlWindow.historyBack/1","doc":"Moves back to the previous page.\n\nOnly pages displayed using `loadPage/2` are stored in history list.","ref":"wxHtmlWindow.html#historyBack/1"},{"type":"function","title":"wxHtmlWindow.historyCanBack/1","doc":"Returns true if it is possible to go back in the history i.e.\n\n`historyBack/1` won't fail.","ref":"wxHtmlWindow.html#historyCanBack/1"},{"type":"function","title":"wxHtmlWindow.historyCanForward/1","doc":"Returns true if it is possible to go forward in the history i.e.\n\n`historyForward/1` won't fail.","ref":"wxHtmlWindow.html#historyCanForward/1"},{"type":"function","title":"wxHtmlWindow.historyClear/1","doc":"Clears history.","ref":"wxHtmlWindow.html#historyClear/1"},{"type":"function","title":"wxHtmlWindow.historyForward/1","doc":"Moves to next page in history.\n\nOnly pages displayed using `loadPage/2` are stored in history list.","ref":"wxHtmlWindow.html#historyForward/1"},{"type":"function","title":"wxHtmlWindow.loadFile/2","doc":"Loads an HTML page from a file and displays it.\n\nReturn: false if an error occurred, true otherwise\n\nSee: `loadPage/2`","ref":"wxHtmlWindow.html#loadFile/2"},{"type":"function","title":"wxHtmlWindow.loadPage/2","doc":"Unlike `setPage/2` this function first loads the HTML page from `location` and\nthen displays it.\n\nReturn: false if an error occurred, true otherwise\n\nSee: `loadFile/2`","ref":"wxHtmlWindow.html#loadPage/2"},{"type":"function","title":"wxHtmlWindow.new/0","doc":"Default ctor.","ref":"wxHtmlWindow.html#new/0"},{"type":"function","title":"wxHtmlWindow.new/1","doc":"","ref":"wxHtmlWindow.html#new/1"},{"type":"function","title":"wxHtmlWindow.new/2","doc":"Constructor.\n\nThe parameters are the same as `wxScrolled::wxScrolled()` (not implemented in\nwx) constructor.","ref":"wxHtmlWindow.html#new/2"},{"type":"function","title":"wxHtmlWindow.selectAll/1","doc":"Selects all text in the window.\n\nSee: `selectLine/2`, `selectWord/2`","ref":"wxHtmlWindow.html#selectAll/1"},{"type":"function","title":"wxHtmlWindow.selectionToText/1","doc":"Returns the current selection as plain text.\n\nReturns an empty string if no text is currently selected.","ref":"wxHtmlWindow.html#selectionToText/1"},{"type":"function","title":"wxHtmlWindow.selectLine/2","doc":"Selects the line of text that `pos` points at.\n\nNote that `pos` is relative to the top of displayed page, not to window's\norigin, use `wxScrolledWindow:calcUnscrolledPosition/3` to convert physical\ncoordinate.\n\nSee: `selectAll/1`, `selectWord/2`","ref":"wxHtmlWindow.html#selectLine/2"},{"type":"function","title":"wxHtmlWindow.selectWord/2","doc":"Selects the word at position `pos`.\n\nNote that `pos` is relative to the top of displayed page, not to window's\norigin, use `wxScrolledWindow:calcUnscrolledPosition/3` to convert physical\ncoordinate.\n\nSee: `selectAll/1`, `selectLine/2`","ref":"wxHtmlWindow.html#selectWord/2"},{"type":"function","title":"wxHtmlWindow.setBorders/2","doc":"This function sets the space between border of window and HTML contents.\n\nSee image:","ref":"wxHtmlWindow.html#setBorders/2"},{"type":"function","title":"wxHtmlWindow.setFonts/3","doc":"","ref":"wxHtmlWindow.html#setFonts/3"},{"type":"function","title":"wxHtmlWindow.setFonts/4","doc":"This function sets font sizes and faces.\n\nSee `wxHtmlDCRenderer::SetFonts` (not implemented in wx) for detailed\ndescription.\n\nSee: SetSize()","ref":"wxHtmlWindow.html#setFonts/4"},{"type":"function","title":"wxHtmlWindow.setPage/2","doc":"Sets the source of a page and displays it, for example:\n\nIf you want to load a document from some location use `loadPage/2` instead.\n\nReturn: false if an error occurred, true otherwise.","ref":"wxHtmlWindow.html#setPage/2"},{"type":"function","title":"wxHtmlWindow.setRelatedFrame/3","doc":"Sets the frame in which page title will be displayed.\n\n`format` is the format of the frame title, e.g. \"HtmlHelp : %s\". It must contain\nexactly one s. This s is substituted with HTML page title.","ref":"wxHtmlWindow.html#setRelatedFrame/3"},{"type":"function","title":"wxHtmlWindow.setRelatedStatusBar/2","doc":"`After` calling `setRelatedFrame/3`, this sets statusbar slot where messages\nwill be displayed.\n\n(Default is -1 = no messages.)","ref":"wxHtmlWindow.html#setRelatedStatusBar/2"},{"type":"function","title":"wxHtmlWindow.setRelatedStatusBar/3","doc":"`Sets` the associated statusbar where messages will be displayed.\n\nCall this instead of `setRelatedFrame/3` if you want statusbar updates only, no\nchanging of the frame title.\n\nSince: 2.9.0","ref":"wxHtmlWindow.html#setRelatedStatusBar/3"},{"type":"function","title":"wxHtmlWindow.toText/1","doc":"Returns content of currently displayed page as plain text.","ref":"wxHtmlWindow.html#toText/1"},{"type":"type","title":"wxHtmlWindow.wxHtmlWindow/0","doc":"","ref":"wxHtmlWindow.html#t:wxHtmlWindow/0"},{"type":"module","title":"wxIcon","doc":"Functions for wxIcon class\n\nAn icon is a small rectangular bitmap usually used for denoting a minimized\napplication.\n\nIt differs from a `m:wxBitmap` in always having a mask associated with it for\ntransparent drawing. On some platforms, icons and bitmaps are implemented\nidentically, since there is no real distinction between a `m:wxBitmap` with a\nmask and an icon; and there is no specific icon format on some platforms\n(X-based applications usually standardize on XPMs for small bitmaps and icons).\nHowever, some platforms (such as Windows) make the distinction, so a separate\nclass is provided.\n\nRemark: It is usually desirable to associate a pertinent icon with a frame.\nIcons can also be used for other purposes, for example with `m:wxTreeCtrl` and\n`m:wxListCtrl`. Icons have different formats on different platforms therefore\nseparate icons will usually be created for the different environments.\nPlatform-specific methods for creating a `m:wxIcon` structure are catered for,\nand this is an occasion where conditional compilation will probably be required.\nNote that a new icon must be created for every time the icon is to be used for a\nnew window. In Windows, the icon will not be reloaded if it has already been\nused. An icon allocated to a frame will be deleted when the frame is deleted.\nFor more information please see overview_bitmap.\n\nPredefined objects (include wx.hrl): ?wxNullIcon\n\nSee:\n[Overview bitmap](https://docs.wxwidgets.org/3.1/overview_bitmap.html#overview_bitmap),\n[Overview bitmap](https://docs.wxwidgets.org/3.1/overview_bitmap.html#overview_bitmap_supportedformats),\n`m:wxIconBundle`, `wxDC:drawIcon/3`, `m:wxCursor`\n\nThis class is derived (and can use functions) from: `m:wxBitmap`\n\nwxWidgets docs: [wxIcon](https://docs.wxwidgets.org/3.1/classwx_icon.html)","ref":"wxIcon.html"},{"type":"function","title":"wxIcon.copyFromBitmap/2","doc":"Copies `bmp` bitmap to this icon.\n\nUnder MS Windows the bitmap must have mask colour set.\n\nSee: `wxBitmap:loadFile/3`","ref":"wxIcon.html#copyFromBitmap/2"},{"type":"function","title":"wxIcon.destroy/1","doc":"Destructor.\n\nSee overview_refcount_destruct for more info.\n\nIf the application omits to delete the icon explicitly, the icon will be\ndestroyed automatically by wxWidgets when the application exits.\n\nWarning: Do not delete an icon that is selected into a memory device context.","ref":"wxIcon.html#destroy/1"},{"type":"function","title":"wxIcon.new/0","doc":"Default ctor.\n\nConstructs an icon object with no data; an assignment or another member function\nsuch as `wxBitmap:loadFile/3` must be called subsequently.","ref":"wxIcon.html#new/0"},{"type":"function","title":"wxIcon.new/1","doc":"Copy ctor.","ref":"wxIcon.html#new/1"},{"type":"function","title":"wxIcon.new/2","doc":"Loads an icon from a file or resource.\n\nSee: `wxBitmap:loadFile/3`","ref":"wxIcon.html#new/2"},{"type":"type","title":"wxIcon.wxIcon/0","doc":"","ref":"wxIcon.html#t:wxIcon/0"},{"type":"module","title":"wxIconBundle","doc":"Functions for wxIconBundle class\n\nThis class contains multiple copies of an icon in different sizes. It is\ntypically used in `wxDialog::SetIcons` (not implemented in wx) and\n`wxTopLevelWindow:setIcons/2`.\n\nPredefined objects (include wx.hrl): ?wxNullIconBundle\n\nwxWidgets docs:\n[wxIconBundle](https://docs.wxwidgets.org/3.1/classwx_icon_bundle.html)","ref":"wxIconBundle.html"},{"type":"function","title":"wxIconBundle.addIcon/2","doc":"Adds the icon to the collection; if the collection already contains an icon with\nthe same width and height, it is replaced by the new one.","ref":"wxIconBundle.html#addIcon/2"},{"type":"function","title":"wxIconBundle.addIcon/3","doc":"","ref":"wxIconBundle.html#addIcon/3"},{"type":"function","title":"wxIconBundle.destroy/1","doc":"Destructor.","ref":"wxIconBundle.html#destroy/1"},{"type":"function","title":"wxIconBundle.getIcon/1","doc":"","ref":"wxIconBundle.html#getIcon/1"},{"type":"function","title":"wxIconBundle.getIcon/2","doc":"Same as.\n\n.","ref":"wxIconBundle.html#getIcon/2"},{"type":"function","title":"wxIconBundle.getIcon/3","doc":"Returns the icon with the given size.\n\nIf `size` is ?wxDefaultSize, it is interpreted as the standard system icon size,\ni.e. the size returned by `wxSystemSettings:getMetric/2` for `wxSYS_ICON_X` and\n`wxSYS_ICON_Y`.\n\nIf the bundle contains an icon with exactly the requested size, it's always\nreturned. Otherwise, the behaviour depends on the flags. If only\n`wxIconBundle::FALLBACK_NONE` (not implemented in wx) is given, the function\nreturns an invalid icon. If `wxIconBundle::FALLBACK_SYSTEM` (not implemented in\nwx) is given, it tries to find the icon of standard system size, regardless of\nthe size passed as parameter. Otherwise, or if the icon system size is not found\nneither, but `wxIconBundle::FALLBACK_NEAREST_LARGER` (not implemented in wx)\nflag is specified, the function returns the smallest icon of the size larger\nthan the requested one or, if this fails too, just the icon closest to the\nspecified size.\n\nThe `flags` parameter is available only since wxWidgets 2.9.4.","ref":"wxIconBundle.html#getIcon/3"},{"type":"function","title":"wxIconBundle.new/0","doc":"Default ctor.","ref":"wxIconBundle.html#new/0"},{"type":"function","title":"wxIconBundle.new/1","doc":"Initializes the bundle with the icon(s) found in the file.","ref":"wxIconBundle.html#new/1"},{"type":"function","title":"wxIconBundle.new/2","doc":"","ref":"wxIconBundle.html#new/2"},{"type":"type","title":"wxIconBundle.wxIconBundle/0","doc":"","ref":"wxIconBundle.html#t:wxIconBundle/0"},{"type":"module","title":"wxIconizeEvent","doc":"Functions for wxIconizeEvent class\n\nAn event being sent when the frame is iconized (minimized) or restored.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxTopLevelWindow:iconize/2`, `wxTopLevelWindow:isIconized/1`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxIconizeEvent](https://docs.wxwidgets.org/3.1/classwx_iconize_event.html)","ref":"wxIconizeEvent.html"},{"type":"module","title":"Events - wxIconizeEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxIconizeEventType`](`t:wxIconizeEventType/0`) to subscribe to events of this\ntype.","ref":"wxIconizeEvent.html#module-events"},{"type":"function","title":"wxIconizeEvent.isIconized/1","doc":"Returns true if the frame has been iconized, false if it has been restored.","ref":"wxIconizeEvent.html#isIconized/1"},{"type":"type","title":"wxIconizeEvent.wxIconize/0","doc":"","ref":"wxIconizeEvent.html#t:wxIconize/0"},{"type":"type","title":"wxIconizeEvent.wxIconizeEvent/0","doc":"","ref":"wxIconizeEvent.html#t:wxIconizeEvent/0"},{"type":"type","title":"wxIconizeEvent.wxIconizeEventType/0","doc":"","ref":"wxIconizeEvent.html#t:wxIconizeEventType/0"},{"type":"module","title":"wxIdleEvent","doc":"Functions for wxIdleEvent class\n\nThis class is used for idle events, which are generated when the system becomes\nidle. Note that, unless you do something specifically, the idle events are not\nsent if the system remains idle once it has become it, e.g. only a single idle\nevent will be generated until something else resulting in more normal events\nhappens and only then is the next idle event sent again.\n\nIf you need to ensure a continuous stream of idle events, you can either use\n`requestMore/2` method in your handler or call ?wxWakeUpIdle() periodically (for\nexample from a timer event handler), but note that both of these approaches (and\nespecially the first one) increase the system load and so should be avoided if\npossible.\n\nBy default, idle events are sent to all windows, including even the hidden ones\nbecause they may be shown if some condition is met from their `wxEVT_IDLE` (or\nrelated `wxEVT_UPDATE_UI`) handler. The children of hidden windows do not\nreceive idle events however as they can't change their state in any way\nnoticeable by the user. Finally, the global `wxApp` (not implemented in wx)\nobject also receives these events, as usual, so it can be used for any global\nidle time processing.\n\nIf sending idle events to all windows is causing a significant overhead in your\napplication, you can call `setMode/1` with the value wxIDLE_PROCESS_SPECIFIED,\nand set the wxWS_EX_PROCESS_IDLE extra window style for every window which\nshould receive idle events, all the other ones will not receive them in this\ncase.\n\nDelayed Action Mechanism\n\n`m:wxIdleEvent` can be used to perform some action \"at slightly later time\".\nThis can be necessary in several circumstances when, for whatever reason,\nsomething can't be done in the current event handler. For example, if a mouse\nevent handler is called with the mouse button pressed, the mouse can be\ncurrently captured and some operations with it - notably capturing it again -\nmight be impossible or lead to undesirable results. If you still want to capture\nit, you can do it from `wxEVT_IDLE` handler when it is called the next time\ninstead of doing it immediately.\n\nThis can be achieved in two different ways: when using static event tables, you\nwill need a flag indicating to the (always connected) idle event handler whether\nthe desired action should be performed. The originally called handler would then\nset it to indicate that it should indeed be done and the idle handler itself\nwould reset it to prevent it from doing the same action again.\n\nUsing dynamically connected event handlers things are even simpler as the\noriginal event handler can simply `wxEvtHandler::Connect()` (not implemented in\nwx) or `wxEvtHandler::Bind()` (not implemented in wx) the idle event handler\nwhich would only be executed then and could `wxEvtHandler::Disconnect()` (not\nimplemented in wx) or `wxEvtHandler::Unbind()` (not implemented in wx) itself.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`m:wxUpdateUIEvent`, `wxWindow::OnInternalIdle` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxIdleEvent](https://docs.wxwidgets.org/3.1/classwx_idle_event.html)","ref":"wxIdleEvent.html"},{"type":"module","title":"Events - wxIdleEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxIdleEventType`](`t:wxIdleEventType/0`) to\nsubscribe to events of this type.","ref":"wxIdleEvent.html#module-events"},{"type":"function","title":"wxIdleEvent.getMode/0","doc":"Static function returning a value specifying how wxWidgets will send idle\nevents: to all windows, or only to those which specify that they will process\nthe events.\n\nSee: `setMode/1`","ref":"wxIdleEvent.html#getMode/0"},{"type":"function","title":"wxIdleEvent.moreRequested/1","doc":"Returns true if the OnIdle function processing this event requested more\nprocessing time.\n\nSee: `requestMore/2`","ref":"wxIdleEvent.html#moreRequested/1"},{"type":"function","title":"wxIdleEvent.requestMore/1","doc":"","ref":"wxIdleEvent.html#requestMore/1"},{"type":"function","title":"wxIdleEvent.requestMore/2","doc":"Tells wxWidgets that more processing is required.\n\nThis function can be called by an OnIdle handler for a window or window event\nhandler to indicate that wxApp::OnIdle should forward the OnIdle event once more\nto the application windows.\n\nIf no window calls this function during OnIdle, then the application will remain\nin a passive event loop (not calling OnIdle) until a new event is posted to the\napplication by the windowing system.\n\nSee: `moreRequested/1`","ref":"wxIdleEvent.html#requestMore/2"},{"type":"function","title":"wxIdleEvent.setMode/1","doc":"Static function for specifying how wxWidgets will send idle events: to all\nwindows, or only to those which specify that they will process the events.","ref":"wxIdleEvent.html#setMode/1"},{"type":"type","title":"wxIdleEvent.wxIdle/0","doc":"","ref":"wxIdleEvent.html#t:wxIdle/0"},{"type":"type","title":"wxIdleEvent.wxIdleEvent/0","doc":"","ref":"wxIdleEvent.html#t:wxIdleEvent/0"},{"type":"type","title":"wxIdleEvent.wxIdleEventType/0","doc":"","ref":"wxIdleEvent.html#t:wxIdleEventType/0"},{"type":"module","title":"wxImage","doc":"Functions for wxImage class\n\nThis class encapsulates a platform-independent image.\n\nAn image can be created from data, or using `wxBitmap:convertToImage/1`. An\nimage can be loaded from a file in a variety of formats, and is extensible to\nnew formats via image format handlers. Functions are available to set and get\nimage bits, so it can be used for basic image manipulation.\n\nA `m:wxImage` cannot (currently) be drawn directly to a `m:wxDC`. Instead, a\nplatform-specific `m:wxBitmap` object must be created from it using the\nwxBitmap::wxBitmap(wxImage,int depth) constructor. This bitmap can then be drawn\nin a device context, using `wxDC:drawBitmap/4`.\n\nMore on the difference between `m:wxImage` and `m:wxBitmap`: `m:wxImage` is just\na buffer of RGB bytes with an optional buffer for the alpha bytes. It is all\ngeneric, platform independent and image file format independent code. It\nincludes generic code for scaling, resizing, clipping, and other manipulations\nof the image data. OTOH, `m:wxBitmap` is intended to be a wrapper of whatever is\nthe native image format that is quickest/easiest to draw to a DC or to be the\ntarget of the drawing operations performed on a `m:wxMemoryDC`. By splitting the\nresponsibilities between wxImage/wxBitmap like this then it's easier to use\ngeneric code shared by all platforms and image types for generic operations and\nplatform specific code where performance or compatibility is needed.\n\nOne colour value of the image may be used as a mask colour which will lead to\nthe automatic creation of a `m:wxMask` object associated to the bitmap object.\n\nAlpha channel support\n\nStarting from wxWidgets 2.5.0 `m:wxImage` supports alpha channel data, that is\nin addition to a byte for the red, green and blue colour components for each\npixel it also stores a byte representing the pixel opacity.\n\nAn alpha value of 0 corresponds to a transparent pixel (null opacity) while a\nvalue of 255 means that the pixel is 100% opaque. The constants\n?wxIMAGE_ALPHA_TRANSPARENT and ?wxIMAGE_ALPHA_OPAQUE can be used to indicate\nthose values in a more readable form.\n\nWhile all images have RGB data, not all images have an alpha channel. Before\nusing `getAlpha/3` you should check if this image contains an alpha channel with\n`hasAlpha/1`. Currently the BMP, PNG, TGA, and TIFF format handlers have full\nalpha channel support for loading so if you want to use alpha you have to use\none of these formats. If you initialize the image alpha channel yourself using\n`setAlpha/4`, you should save it in either PNG, TGA, or TIFF format to avoid\nlosing it as these are the only handlers that currently support saving with\nalpha.\n\nAvailable image handlers\n\nThe following image handlers are available. wxBMPHandler is always installed by\ndefault. To use other image formats, install the appropriate handler with\n`wxImage::AddHandler` (not implemented in wx) or call ?wxInitAllImageHandlers().\n\nWhen saving in PCX format, `wxPCXHandler` (not implemented in wx) will count the\nnumber of different colours in the image; if there are 256 or less colours, it\nwill save as 8 bit, else it will save as 24 bit.\n\nLoading PNMs only works for ASCII or raw RGB images. When saving in PNM format,\n`wxPNMHandler` (not implemented in wx) will always save as raw RGB.\n\nSaving GIFs requires images of maximum 8 bpp (see `wxQuantize` (not implemented\nin wx)), and the alpha channel converted to a mask (see `convertAlphaToMask/5`).\nSaving an animated GIF requires images of the same size (see\n`wxGIFHandler::SaveAnimation` (not implemented in wx))\n\nPredefined objects (include wx.hrl): ?wxNullImage\n\nSee: `m:wxBitmap`, ?wxInitAllImageHandlers(), `wxPixelData` (not implemented in\nwx)\n\nwxWidgets docs: [wxImage](https://docs.wxwidgets.org/3.1/classwx_image.html)","ref":"wxImage.html"},{"type":"function","title":"wxImage.blur/2","doc":"Blurs the image in both horizontal and vertical directions by the specified\npixel `blurRadius`.\n\nThis should not be used when using a single mask colour for transparency.\n\nSee: `blurHorizontal/2`, `blurVertical/2`","ref":"wxImage.html#blur/2"},{"type":"function","title":"wxImage.blurHorizontal/2","doc":"Blurs the image in the horizontal direction only.\n\nThis should not be used when using a single mask colour for transparency.\n\nSee: `blur/2`, `blurVertical/2`","ref":"wxImage.html#blurHorizontal/2"},{"type":"function","title":"wxImage.blurVertical/2","doc":"Blurs the image in the vertical direction only.\n\nThis should not be used when using a single mask colour for transparency.\n\nSee: `blur/2`, `blurHorizontal/2`","ref":"wxImage.html#blurVertical/2"},{"type":"function","title":"wxImage.convertAlphaToMask/1","doc":"","ref":"wxImage.html#convertAlphaToMask/1"},{"type":"function","title":"wxImage.convertAlphaToMask/2","doc":"If the image has alpha channel, this method converts it to mask.\n\nIf the image has an alpha channel, all pixels with alpha value less than\n`threshold` are replaced with the mask colour and the alpha channel is removed.\nOtherwise nothing is done.\n\nThe mask colour is chosen automatically using `findFirstUnusedColour/2`, see the\noverload below if this is not appropriate.\n\nReturn: Returns true on success, false on error.","ref":"wxImage.html#convertAlphaToMask/2"},{"type":"function","title":"wxImage.convertAlphaToMask/4","doc":"","ref":"wxImage.html#convertAlphaToMask/4"},{"type":"function","title":"wxImage.convertAlphaToMask/5","doc":"If the image has alpha channel, this method converts it to mask using the\nspecified colour as the mask colour.\n\nIf the image has an alpha channel, all pixels with alpha value less than\n`threshold` are replaced with the mask colour and the alpha channel is removed.\nOtherwise nothing is done.\n\nSince: 2.9.0\n\nReturn: Returns true on success, false on error.","ref":"wxImage.html#convertAlphaToMask/5"},{"type":"function","title":"wxImage.convertToGreyscale/1","doc":"Returns a greyscale version of the image.\n\nSince: 2.9.0","ref":"wxImage.html#convertToGreyscale/1"},{"type":"function","title":"wxImage.convertToGreyscale/4","doc":"Returns a greyscale version of the image.\n\nThe returned image uses the luminance component of the original to calculate the\ngreyscale. Defaults to using the standard ITU-T BT.601 when converting to YUV,\nwhere every pixel equals (R _ `weight_r`) + (G _ `weight_g`) + (B \\*\n`weight_b`).","ref":"wxImage.html#convertToGreyscale/4"},{"type":"function","title":"wxImage.convertToMono/4","doc":"Returns monochromatic version of the image.\n\nThe returned image has white colour where the original has (r,g,b) colour and\nblack colour everywhere else.","ref":"wxImage.html#convertToMono/4"},{"type":"function","title":"wxImage.copy/1","doc":"Returns an identical copy of this image.","ref":"wxImage.html#copy/1"},{"type":"function","title":"wxImage.create/2","doc":"","ref":"wxImage.html#create/2"},{"type":"function","title":"wxImage.create/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxImage.html#create/3"},{"type":"function","title":"wxImage.create/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxImage.html#create/4"},{"type":"function","title":"wxImage.create/5","doc":"Creates a fresh image.\n\nSee `new/4` for more info.\n\nReturn: true if the call succeeded, false otherwise.","ref":"wxImage.html#create/5"},{"type":"function","title":"wxImage.Destroy/1","doc":"Destroys the image data.","ref":"wxImage.html#Destroy/1"},{"type":"function","title":"wxImage.destroy/1","doc":"Destructor.\n\nSee reference-counted object destruction for more info.","ref":"wxImage.html#destroy/1"},{"type":"function","title":"wxImage.findFirstUnusedColour/1","doc":"","ref":"wxImage.html#findFirstUnusedColour/1"},{"type":"function","title":"wxImage.findFirstUnusedColour/2","doc":"Finds the first colour that is never used in the image.\n\nThe search begins at given initial colour and continues by increasing R, G and B\ncomponents (in this order) by 1 until an unused colour is found or the colour\nspace exhausted.\n\nThe parameters `r`, `g`, `b` are pointers to variables to save the colour.\n\nThe parameters `startR`, `startG`, `startB` define the initial values of the\ncolour. The returned colour will have RGB values equal to or greater than these.\n\nReturn: Returns false if there is no unused colour left, true on success.\n\nNote: This method involves computing the histogram, which is a computationally\nintensive operation.","ref":"wxImage.html#findFirstUnusedColour/2"},{"type":"function","title":"wxImage.getAlpha/1","doc":"Returns pointer to the array storing the alpha values for this image.\n\nThis pointer is NULL for the images without the alpha channel. If the image does\nhave it, this pointer may be used to directly manipulate the alpha values which\nare stored as the RGB ones.","ref":"wxImage.html#getAlpha/1"},{"type":"function","title":"wxImage.getAlpha/3","doc":"Return alpha value at given pixel location.","ref":"wxImage.html#getAlpha/3"},{"type":"function","title":"wxImage.getBlue/3","doc":"Returns the blue intensity at the given coordinate.","ref":"wxImage.html#getBlue/3"},{"type":"function","title":"wxImage.getData/1","doc":"Returns the image data as an array.\n\nThis is most often used when doing direct image manipulation. The return value\npoints to an array of characters in RGBRGBRGB... format in the top-to-bottom,\nleft-to-right order, that is the first RGB triplet corresponds to the first\npixel of the first row, the second one - to the second pixel of the first row\nand so on until the end of the first row, with second row following after it and\nso on.\n\nYou should not delete the returned pointer nor pass it to `setData/4`.","ref":"wxImage.html#getData/1"},{"type":"function","title":"wxImage.getGreen/3","doc":"Returns the green intensity at the given coordinate.","ref":"wxImage.html#getGreen/3"},{"type":"function","title":"wxImage.getHeight/1","doc":"Gets the height of the image in pixels.\n\nSee: `getWidth/1`, `GetSize()` (not implemented in wx)","ref":"wxImage.html#getHeight/1"},{"type":"function","title":"wxImage.getImageCount/1","doc":"","ref":"wxImage.html#getImageCount/1"},{"type":"function","title":"wxImage.getImageCount/2","doc":"If the image file contains more than one image and the image handler is capable\nof retrieving these individually, this function will return the number of\navailable images.\n\nFor the overload taking the parameter `filename`, that's the name of the file to\nquery. For the overload taking the parameter `stream`, that's the opened input\nstream with image data.\n\nSee `wxImageHandler::GetImageCount()` (not implemented in wx) for more info.\n\nThe parameter `type` may be one of the following values:\n\nReturn: Number of available images. For most image handlers, this is 1\n(exceptions are TIFF and ICO formats as well as animated GIFs for which this\nfunction returns the number of frames in the animation).","ref":"wxImage.html#getImageCount/2"},{"type":"function","title":"wxImage.getImageExtWildcard/0","doc":"Iterates all registered `wxImageHandler` (not implemented in wx) objects, and\nreturns a string containing file extension masks suitable for passing to file\nopen/save dialog boxes.\n\nReturn: The format of the returned string is `\"(*.ext1;*.ext2)|*.ext1;*.ext2\"`.\nIt is usually a good idea to prepend a description before passing the result to\nthe dialog. Example:\n\nSee: `wxImageHandler` (not implemented in wx)","ref":"wxImage.html#getImageExtWildcard/0"},{"type":"function","title":"wxImage.getMaskBlue/1","doc":"Gets the blue value of the mask colour.","ref":"wxImage.html#getMaskBlue/1"},{"type":"function","title":"wxImage.getMaskGreen/1","doc":"Gets the green value of the mask colour.","ref":"wxImage.html#getMaskGreen/1"},{"type":"function","title":"wxImage.getMaskRed/1","doc":"Gets the red value of the mask colour.","ref":"wxImage.html#getMaskRed/1"},{"type":"function","title":"wxImage.getOption/2","doc":"Gets a user-defined string-valued option.\n\nGeneric options:\n\nOptions specific to `wxGIFHandler` (not implemented in wx):\n\nReturn: The value of the option or an empty string if not found. Use\n`hasOption/2` if an empty string can be a valid option value.\n\nSee: `setOption/3`, `getOptionInt/2`, `hasOption/2`","ref":"wxImage.html#getOption/2"},{"type":"function","title":"wxImage.getOptionInt/2","doc":"Gets a user-defined integer-valued option.\n\nThe function is case-insensitive to `name`. If the given option is not present,\nthe function returns 0. Use `hasOption/2` if 0 is a possibly valid value for the\noption.\n\nGeneric options:\n\nSince: 2.9.3\n\nOptions specific to `wxPNGHandler` (not implemented in wx):\n\nOptions specific to `wxTIFFHandler` (not implemented in wx):\n\nOptions specific to `wxGIFHandler` (not implemented in wx):\n\nNote: Be careful when combining the options\n`wxIMAGE_OPTION_TIFF_SAMPLESPERPIXEL`, `wxIMAGE_OPTION_TIFF_BITSPERSAMPLE`, and\n`wxIMAGE_OPTION_TIFF_PHOTOMETRIC`. While some measures are taken to prevent\nillegal combinations and/or values, it is still easy to abuse them and come up\nwith invalid results in the form of either corrupted images or crashes.\n\nReturn: The value of the option or 0 if not found. Use `hasOption/2` if 0 can be\na valid option value.\n\nSee: `setOption/3`, `getOption/2`","ref":"wxImage.html#getOptionInt/2"},{"type":"function","title":"wxImage.getOrFindMaskColour/1","doc":"Get the current mask colour or find a suitable unused colour that could be used\nas a mask colour.\n\nReturns true if the image currently has a mask.","ref":"wxImage.html#getOrFindMaskColour/1"},{"type":"function","title":"wxImage.getPalette/1","doc":"Returns the palette associated with the image.\n\nCurrently the palette is only used when converting to `m:wxBitmap` under\nWindows.\n\nSome of the `m:wxImage` handlers have been modified to set the palette if one\nexists in the image file (usually 256 or less colour images in GIF or PNG\nformat).","ref":"wxImage.html#getPalette/1"},{"type":"function","title":"wxImage.getRed/3","doc":"Returns the red intensity at the given coordinate.","ref":"wxImage.html#getRed/3"},{"type":"function","title":"wxImage.getSubImage/2","doc":"Returns a sub image of the current one as long as the rect belongs entirely to\nthe image.","ref":"wxImage.html#getSubImage/2"},{"type":"function","title":"wxImage.getWidth/1","doc":"Gets the width of the image in pixels.\n\nSee: `getHeight/1`, `GetSize()` (not implemented in wx)","ref":"wxImage.html#getWidth/1"},{"type":"function","title":"wxImage.hasAlpha/1","doc":"Returns true if this image has alpha channel, false otherwise.\n\nSee: `getAlpha/3`, `setAlpha/4`","ref":"wxImage.html#hasAlpha/1"},{"type":"function","title":"wxImage.hasMask/1","doc":"Returns true if there is a mask active, false otherwise.","ref":"wxImage.html#hasMask/1"},{"type":"function","title":"wxImage.hasOption/2","doc":"Returns true if the given option is present.\n\nThe function is case-insensitive to `name`.\n\nThe lists of the currently supported options are in `getOption/2` and\n`getOptionInt/2` function docs.\n\nSee: `setOption/3`, `getOption/2`, `getOptionInt/2`","ref":"wxImage.html#hasOption/2"},{"type":"function","title":"wxImage.initAlpha/1","doc":"Initializes the image alpha channel data.\n\nIt is an error to call it if the image already has alpha data. If it doesn't,\nalpha data will be by default initialized to all pixels being fully opaque. But\nif the image has a mask colour, all mask pixels will be completely transparent.","ref":"wxImage.html#initAlpha/1"},{"type":"function","title":"wxImage.initStandardHandlers/0","doc":"Internal use only.\n\nAdds standard image format handlers. It only install wxBMPHandler for the time\nbeing, which is used by `m:wxBitmap`.\n\nThis function is called by wxWidgets on startup, and shouldn't be called by the\nuser.\n\nSee: `wxImageHandler` (not implemented in wx), ?wxInitAllImageHandlers(),\n`wxQuantize` (not implemented in wx)","ref":"wxImage.html#initStandardHandlers/0"},{"type":"function","title":"wxImage.isOk/1","doc":"Returns true if image data is present.","ref":"wxImage.html#isOk/1"},{"type":"function","title":"wxImage.isTransparent/3","doc":"","ref":"wxImage.html#isTransparent/3"},{"type":"function","title":"wxImage.isTransparent/4","doc":"Returns true if the given pixel is transparent, i.e. either has the mask colour\nif this image has a mask or if this image has alpha channel and alpha value of\nthis pixel is strictly less than `threshold`.","ref":"wxImage.html#isTransparent/4"},{"type":"function","title":"wxImage.loadFile/2","doc":"","ref":"wxImage.html#loadFile/2"},{"type":"function","title":"wxImage.loadFile/3","doc":"Loads an image from a file.\n\nIf no handler type is provided, the library will try to autodetect the format.","ref":"wxImage.html#loadFile/3"},{"type":"function","title":"wxImage.loadFile/4","doc":"Loads an image from a file.\n\nIf no handler type is provided, the library will try to autodetect the format.","ref":"wxImage.html#loadFile/4"},{"type":"function","title":"wxImage.mirror/1","doc":"","ref":"wxImage.html#mirror/1"},{"type":"function","title":"wxImage.mirror/2","doc":"Returns a mirrored copy of the image.\n\nThe parameter `horizontally` indicates the orientation.","ref":"wxImage.html#mirror/2"},{"type":"function","title":"wxImage.new/0","doc":"Creates an empty `m:wxImage` object without an alpha channel.","ref":"wxImage.html#new/0"},{"type":"function","title":"wxImage.new/1","doc":"","ref":"wxImage.html#new/1"},{"type":"function","title":"wxImage.new/2","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxImage.html#new/2"},{"type":"function","title":"wxImage.new/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxImage.html#new/3"},{"type":"function","title":"wxImage.new/4","doc":"Creates an image from data in memory.\n\nIf `static_data` is false then the `m:wxImage` will take ownership of the data\nand free it afterwards. For this, it has to be allocated with `malloc`.","ref":"wxImage.html#new/4"},{"type":"function","title":"wxImage.ok/1","doc":"See: `isOk/1`.","ref":"wxImage.html#ok/1"},{"type":"function","title":"wxImage.removeHandler/1","doc":"Finds the handler with the given name, and removes it.\n\nThe handler is also deleted.\n\nReturn: true if the handler was found and removed, false otherwise.\n\nSee: `wxImageHandler` (not implemented in wx)","ref":"wxImage.html#removeHandler/1"},{"type":"function","title":"wxImage.replace/7","doc":"Replaces the colour specified by `r1`,g1,b1 by the colour `r2`,g2,b2.","ref":"wxImage.html#replace/7"},{"type":"function","title":"wxImage.rescale/3","doc":"","ref":"wxImage.html#rescale/3"},{"type":"function","title":"wxImage.rescale/4","doc":"Changes the size of the image in-place by scaling it: after a call to this\nfunction,the image will have the given width and height.\n\nFor a description of the `quality` parameter, see the `scale/4` function.\nReturns the (modified) image itself.\n\nSee: `scale/4`","ref":"wxImage.html#rescale/4"},{"type":"function","title":"wxImage.resize/3","doc":"","ref":"wxImage.html#resize/3"},{"type":"function","title":"wxImage.resize/4","doc":"Changes the size of the image in-place without scaling it by adding either a\nborder with the given colour or cropping as necessary.\n\nThe image is pasted into a new image with the given `size` and background colour\nat the position `pos` relative to the upper left of the new image.\n\nIf `red` = green = blue = -1 then use either the current mask colour if set or\nfind, use, and set a suitable mask colour for any newly exposed areas.\n\nReturn: The (modified) image itself.\n\nSee: `size/4`","ref":"wxImage.html#resize/4"},{"type":"function","title":"wxImage.rotate90/1","doc":"","ref":"wxImage.html#rotate90/1"},{"type":"function","title":"wxImage.rotate90/2","doc":"Returns a copy of the image rotated 90 degrees in the direction indicated by\n`clockwise`.","ref":"wxImage.html#rotate90/2"},{"type":"function","title":"wxImage.rotate/3","doc":"","ref":"wxImage.html#rotate/3"},{"type":"function","title":"wxImage.rotate/4","doc":"Rotates the image about the given point, by `angle` radians.\n\nPassing true to `interpolating` results in better image quality, but is slower.\n\nIf the image has a mask, then the mask colour is used for the uncovered pixels\nin the rotated image background. Else, black (rgb 0, 0, 0) will be used.\n\nReturns the rotated image, leaving this image intact.","ref":"wxImage.html#rotate/4"},{"type":"function","title":"wxImage.rotateHue/2","doc":"Rotates the hue of each pixel in the image by `angle`, which is a double in the\nrange of -1.0 to +1.0, where -1.0 corresponds to -360 degrees and +1.0\ncorresponds to +360 degrees.","ref":"wxImage.html#rotateHue/2"},{"type":"function","title":"wxImage.saveFile/2","doc":"Saves an image in the named file.\n\nFile type is determined from the extension of the file name. Note that this\nfunction may fail if the extension is not recognized\\! You can use one of the\nforms above to save images to files with non-standard extensions.","ref":"wxImage.html#saveFile/2"},{"type":"function","title":"wxImage.saveFile/3","doc":"Saves an image in the named file.","ref":"wxImage.html#saveFile/3"},{"type":"function","title":"wxImage.scale/3","doc":"","ref":"wxImage.html#scale/3"},{"type":"function","title":"wxImage.scale/4","doc":"Returns a scaled version of the image.\n\nThis is also useful for scaling bitmaps in general as the only other way to\nscale bitmaps is to blit a `m:wxMemoryDC` into another `m:wxMemoryDC`.\n\nThe parameter `quality` determines what method to use for resampling the image,\nsee wxImageResizeQuality documentation.\n\nIt should be noted that although using `wxIMAGE_QUALITY_HIGH` produces much\nnicer looking results it is a slower method. Downsampling will use the box\naveraging method which seems to operate very fast. If you are upsampling larger\nimages using this method you will most likely notice that it is a bit slower and\nin extreme cases it will be quite substantially slower as the bicubic algorithm\nhas to process a lot of data.\n\nIt should also be noted that the high quality scaling may not work as expected\nwhen using a single mask colour for transparency, as the scaling will blur the\nimage and will therefore remove the mask partially. Using the alpha channel will\nwork.\n\nExample:\n\nSee: `rescale/4`","ref":"wxImage.html#scale/4"},{"type":"function","title":"wxImage.setAlpha/2","doc":"This function is similar to `setData/4` and has similar restrictions.\n\nThe pointer passed to it may however be NULL in which case the function will\nallocate the alpha array internally - this is useful to add alpha channel data\nto an image which doesn't have any.\n\nIf the pointer is not NULL, it must have one byte for each image pixel and be\nallocated with malloc(). `m:wxImage` takes ownership of the pointer and will\nfree it unless `static_data` parameter is set to true - in this case the caller\nshould do it.","ref":"wxImage.html#setAlpha/2"},{"type":"function","title":"wxImage.setAlpha/4","doc":"Sets the alpha value for the given pixel.\n\nThis function should only be called if the image has alpha channel data, use\n`hasAlpha/1` to check for this.","ref":"wxImage.html#setAlpha/4"},{"type":"function","title":"wxImage.setData/2","doc":"Sets the image data without performing checks.\n\nThe data given must have the size (width*height*3) or results will be\nunexpected. Don't use this method if you aren't sure you know what you are\ndoing.\n\nThe data must have been allocated with `malloc()`, `NOT` with `operator` new.\n\nIf `static_data` is false, after this call the pointer to the data is owned by\nthe `m:wxImage` object, that will be responsible for deleting it. Do not pass to\nthis function a pointer obtained through `getData/1`.","ref":"wxImage.html#setData/2"},{"type":"function","title":"wxImage.setData/4","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxImage.html#setData/4"},{"type":"function","title":"wxImage.setMask/1","doc":"","ref":"wxImage.html#setMask/1"},{"type":"function","title":"wxImage.setMask/2","doc":"Specifies whether there is a mask or not.\n\nThe area of the mask is determined by the current mask colour.","ref":"wxImage.html#setMask/2"},{"type":"function","title":"wxImage.setMaskColour/4","doc":"Sets the mask colour for this image (and tells the image to use the mask).","ref":"wxImage.html#setMaskColour/4"},{"type":"function","title":"wxImage.setMaskFromImage/5","doc":"Sets image's mask so that the pixels that have RGB value of mr,mg,mb in mask\nwill be masked in the image.\n\nThis is done by first finding an unused colour in the image, setting this colour\nas the mask colour and then using this colour to draw all pixels in the image\nwho corresponding pixel in mask has given RGB value.\n\nThe parameter `mask` is the mask image to extract mask shape from. It must have\nthe same dimensions as the image.\n\nThe parameters `mr`, `mg`, `mb` are the RGB values of the pixels in mask that\nwill be used to create the mask.\n\nReturn: Returns false if mask does not have same dimensions as the image or if\nthere is no unused colour left. Returns true if the mask was successfully\napplied.\n\nNote: Note that this method involves computing the histogram, which is a\ncomputationally intensive operation.","ref":"wxImage.html#setMaskFromImage/5"},{"type":"function","title":"wxImage.setOption/3","doc":"Sets a user-defined option.\n\nThe function is case-insensitive to `name`.\n\nFor example, when saving as a JPEG file, the option `quality` is used, which is\na number between 0 and 100 (0 is terrible, 100 is very good).\n\nThe lists of the currently supported options are in `getOption/2` and\n`getOptionInt/2` function docs.\n\nSee: `getOption/2`, `getOptionInt/2`, `hasOption/2`","ref":"wxImage.html#setOption/3"},{"type":"function","title":"wxImage.setPalette/2","doc":"Associates a palette with the image.\n\nThe palette may be used when converting `m:wxImage` to `m:wxBitmap` (MSW only at\npresent) or in file save operations (none as yet).","ref":"wxImage.html#setPalette/2"},{"type":"function","title":"wxImage.setRGB/5","doc":"Sets the colour of the pixels within the given rectangle.\n\nThis routine performs bounds-checks for the coordinate so it can be considered a\nsafe way to manipulate the data.","ref":"wxImage.html#setRGB/5"},{"type":"function","title":"wxImage.setRGB/6","doc":"Set the color of the pixel at the given x and y coordinate.","ref":"wxImage.html#setRGB/6"},{"type":"function","title":"wxImage.size/3","doc":"","ref":"wxImage.html#size/3"},{"type":"function","title":"wxImage.size/4","doc":"Returns a resized version of this image without scaling it by adding either a\nborder with the given colour or cropping as necessary.\n\nThe image is pasted into a new image with the given `size` and background colour\nat the position `pos` relative to the upper left of the new image.\n\nIf `red` = green = blue = -1 then the areas of the larger image not covered by\nthis image are made transparent by filling them with the image mask colour\n(which will be allocated automatically if it isn't currently set).\n\nOtherwise, the areas will be filled with the colour with the specified RGB\ncomponents.\n\nSee: `resize/4`","ref":"wxImage.html#size/4"},{"type":"type","title":"wxImage.wxImage/0","doc":"","ref":"wxImage.html#t:wxImage/0"},{"type":"module","title":"wxImageList","doc":"Functions for wxImageList class\n\nA `m:wxImageList` contains a list of images, which are stored in an unspecified\nform. Images can have masks for transparent drawing, and can be made from a\nvariety of sources including bitmaps and icons.\n\n`m:wxImageList` is used principally in conjunction with `m:wxTreeCtrl` and\n`m:wxListCtrl` classes.\n\nSee: `m:wxTreeCtrl`, `m:wxListCtrl`\n\nwxWidgets docs:\n[wxImageList](https://docs.wxwidgets.org/3.1/classwx_image_list.html)","ref":"wxImageList.html"},{"type":"function","title":"wxImageList.add/2","doc":"Adds a new image using an icon.\n\nReturn: The new zero-based image index.\n\nRemark: The original bitmap or icon is not affected by the `add/3` operation,\nand can be deleted afterwards. If the bitmap is wider than the images in the\nlist, then the bitmap will automatically be split into smaller images, each\nmatching the dimensions of the image list. This does not apply when adding\nicons.\n\nOnly for:wxmsw,wxosx","ref":"wxImageList.html#add/2"},{"type":"function","title":"wxImageList.add/3","doc":"Adds a new image or images using a bitmap and mask colour.\n\nReturn: The new zero-based image index.\n\nRemark: The original bitmap or icon is not affected by the `add/3` operation,\nand can be deleted afterwards. If the bitmap is wider than the images in the\nlist, then the bitmap will automatically be split into smaller images, each\nmatching the dimensions of the image list. This does not apply when adding\nicons.","ref":"wxImageList.html#add/3"},{"type":"function","title":"wxImageList.create/3","doc":"","ref":"wxImageList.html#create/3"},{"type":"function","title":"wxImageList.create/4","doc":"Initializes the list.\n\nSee `new/3` for details.","ref":"wxImageList.html#create/4"},{"type":"function","title":"wxImageList.destroy/1","doc":"Destroys the object.","ref":"wxImageList.html#destroy/1"},{"type":"function","title":"wxImageList.draw/5","doc":"","ref":"wxImageList.html#draw/5"},{"type":"function","title":"wxImageList.draw/6","doc":"Draws a specified image onto a device context.","ref":"wxImageList.html#draw/6"},{"type":"function","title":"wxImageList.getBitmap/2","doc":"Returns the bitmap corresponding to the given index.","ref":"wxImageList.html#getBitmap/2"},{"type":"function","title":"wxImageList.getIcon/2","doc":"Returns the icon corresponding to the given index.","ref":"wxImageList.html#getIcon/2"},{"type":"function","title":"wxImageList.getImageCount/1","doc":"Returns the number of images in the list.","ref":"wxImageList.html#getImageCount/1"},{"type":"function","title":"wxImageList.getSize/2","doc":"Retrieves the size of the images in the list.\n\nCurrently, the `index` parameter is ignored as all images in the list have the\nsame size.\n\nReturn: true if the function succeeded, false if it failed (for example, if the\nimage list was not yet initialized).","ref":"wxImageList.html#getSize/2"},{"type":"function","title":"wxImageList.new/0","doc":"Default ctor.","ref":"wxImageList.html#new/0"},{"type":"function","title":"wxImageList.new/2","doc":"","ref":"wxImageList.html#new/2"},{"type":"function","title":"wxImageList.new/3","doc":"Constructor specifying the image size, whether image masks should be created,\nand the initial size of the list.\n\nSee: `create/4`","ref":"wxImageList.html#new/3"},{"type":"function","title":"wxImageList.remove/2","doc":"Removes the image at the given position.","ref":"wxImageList.html#remove/2"},{"type":"function","title":"wxImageList.removeAll/1","doc":"Removes all the images in the list.","ref":"wxImageList.html#removeAll/1"},{"type":"function","title":"wxImageList.replace/3","doc":"Replaces the existing image with the new image.\n\nReturn: true if the replacement was successful, false otherwise.\n\nRemark: The original bitmap or icon is not affected by the `replace/4`\noperation, and can be deleted afterwards.\n\nOnly for:wxmsw,wxosx","ref":"wxImageList.html#replace/3"},{"type":"function","title":"wxImageList.replace/4","doc":"Replaces the existing image with the new image.\n\nWindows only.\n\nReturn: true if the replacement was successful, false otherwise.\n\nRemark: The original bitmap or icon is not affected by the `replace/4`\noperation, and can be deleted afterwards.","ref":"wxImageList.html#replace/4"},{"type":"type","title":"wxImageList.wxImageList/0","doc":"","ref":"wxImageList.html#t:wxImageList/0"},{"type":"module","title":"wxInitDialogEvent","doc":"Functions for wxInitDialogEvent class\n\nA `m:wxInitDialogEvent` is sent as a dialog or panel is being initialised.\nHandlers for this event can transfer data to the window.\n\nThe default handler calls `wxWindow:transferDataToWindow/1`.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxInitDialogEvent](https://docs.wxwidgets.org/3.1/classwx_init_dialog_event.html)","ref":"wxInitDialogEvent.html"},{"type":"module","title":"Events - wxInitDialogEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxInitDialogEventType`](`t:wxInitDialogEventType/0`) to subscribe to events of\nthis type.","ref":"wxInitDialogEvent.html#module-events"},{"type":"type","title":"wxInitDialogEvent.wxInitDialog/0","doc":"","ref":"wxInitDialogEvent.html#t:wxInitDialog/0"},{"type":"type","title":"wxInitDialogEvent.wxInitDialogEvent/0","doc":"","ref":"wxInitDialogEvent.html#t:wxInitDialogEvent/0"},{"type":"type","title":"wxInitDialogEvent.wxInitDialogEventType/0","doc":"","ref":"wxInitDialogEvent.html#t:wxInitDialogEventType/0"},{"type":"module","title":"wxJoystickEvent","doc":"Functions for wxJoystickEvent class\n\nThis event class contains information about joystick events, particularly events\nreceived by windows.\n\nSee: `wxJoystick` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxJoystickEvent](https://docs.wxwidgets.org/3.1/classwx_joystick_event.html)","ref":"wxJoystickEvent.html"},{"type":"module","title":"Events - wxJoystickEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxJoystickEventType`](`t:wxJoystickEventType/0`) to subscribe to events of\nthis type.","ref":"wxJoystickEvent.html#module-events"},{"type":"function","title":"wxJoystickEvent.buttonDown/1","doc":"","ref":"wxJoystickEvent.html#buttonDown/1"},{"type":"function","title":"wxJoystickEvent.buttonDown/2","doc":"Returns true if the event was a down event from the specified button (or any\nbutton).","ref":"wxJoystickEvent.html#buttonDown/2"},{"type":"function","title":"wxJoystickEvent.buttonIsDown/1","doc":"","ref":"wxJoystickEvent.html#buttonIsDown/1"},{"type":"function","title":"wxJoystickEvent.buttonIsDown/2","doc":"Returns true if the specified button (or any button) was in a down state.","ref":"wxJoystickEvent.html#buttonIsDown/2"},{"type":"function","title":"wxJoystickEvent.buttonUp/1","doc":"","ref":"wxJoystickEvent.html#buttonUp/1"},{"type":"function","title":"wxJoystickEvent.buttonUp/2","doc":"Returns true if the event was an up event from the specified button (or any\nbutton).","ref":"wxJoystickEvent.html#buttonUp/2"},{"type":"function","title":"wxJoystickEvent.getButtonChange/1","doc":"Returns the identifier of the button changing state.\n\nThe return value is where `n` is the index of the button changing state, which\ncan also be retrieved using `GetButtonOrdinal()` (not implemented in wx).\n\nNote that for `n` equal to 1, 2, 3 or 4 there are predefined `wxJOY_BUTTONn`\nconstants which can be used for more clarity, however these constants are not\ndefined for the buttons beyond the first four.","ref":"wxJoystickEvent.html#getButtonChange/1"},{"type":"function","title":"wxJoystickEvent.getButtonState/1","doc":"Returns the down state of the buttons.\n\nThis is a `wxJOY_BUTTONn` identifier, where `n` is one of 1, 2, 3, 4.","ref":"wxJoystickEvent.html#getButtonState/1"},{"type":"function","title":"wxJoystickEvent.getJoystick/1","doc":"Returns the identifier of the joystick generating the event - one of wxJOYSTICK1\nand wxJOYSTICK2.","ref":"wxJoystickEvent.html#getJoystick/1"},{"type":"function","title":"wxJoystickEvent.getPosition/1","doc":"Returns the x, y position of the joystick event.\n\nThese coordinates are valid for all the events except wxEVT_JOY_ZMOVE.","ref":"wxJoystickEvent.html#getPosition/1"},{"type":"function","title":"wxJoystickEvent.getZPosition/1","doc":"Returns the z position of the joystick event.\n\nThis method can only be used for wxEVT_JOY_ZMOVE events.","ref":"wxJoystickEvent.html#getZPosition/1"},{"type":"function","title":"wxJoystickEvent.isButton/1","doc":"Returns true if this was a button up or down event (`not` 'is any button\ndown?').","ref":"wxJoystickEvent.html#isButton/1"},{"type":"function","title":"wxJoystickEvent.isMove/1","doc":"Returns true if this was an x, y move event.","ref":"wxJoystickEvent.html#isMove/1"},{"type":"function","title":"wxJoystickEvent.isZMove/1","doc":"Returns true if this was a z move event.","ref":"wxJoystickEvent.html#isZMove/1"},{"type":"type","title":"wxJoystickEvent.wxJoystick/0","doc":"","ref":"wxJoystickEvent.html#t:wxJoystick/0"},{"type":"type","title":"wxJoystickEvent.wxJoystickEvent/0","doc":"","ref":"wxJoystickEvent.html#t:wxJoystickEvent/0"},{"type":"type","title":"wxJoystickEvent.wxJoystickEventType/0","doc":"","ref":"wxJoystickEvent.html#t:wxJoystickEventType/0"},{"type":"module","title":"wxKeyEvent","doc":"Functions for wxKeyEvent class\n\nThis event class contains information about key press and release events.\n\nThe main information carried by this event is the key being pressed or released.\nIt can be accessed using either `getKeyCode/1` function or `getUnicodeKey/1`.\nFor the printable characters, the latter should be used as it works for any\nkeys, including non-Latin-1 characters that can be entered when using national\nkeyboard layouts. `getKeyCode/1` should be used to handle special characters\n(such as cursor arrows keys or `HOME` or `INS` and so on) which correspond to\n?wxKeyCode enum elements above the `WXK_START` constant. While `getKeyCode/1`\nalso returns the character code for Latin-1 keys for compatibility, it doesn't\nwork for Unicode characters in general and will return `WXK_NONE` for any\nnon-Latin-1 ones. For this reason, it's recommended to always use\n`getUnicodeKey/1` and only fall back to `getKeyCode/1` if `getUnicodeKey/1`\nreturned `WXK_NONE` meaning that the event corresponds to a non-printable\nspecial keys.\n\nWhile both of these functions can be used with the events of `wxEVT_KEY_DOWN`,\n`wxEVT_KEY_UP` and `wxEVT_CHAR` types, the values returned by them are different\nfor the first two events and the last one. For the latter, the key returned\ncorresponds to the character that would appear in e.g. a text zone if the user\npressed the key in it. As such, its value depends on the current state of the\nShift key and, for the letters, on the state of Caps Lock modifier. For example,\nif `A` key is pressed without Shift being held down, `m:wxKeyEvent` of type\n`wxEVT_CHAR` generated for this key press will return (from either\n`getKeyCode/1` or `getUnicodeKey/1` as their meanings coincide for ASCII\ncharacters) key code of 97 corresponding the ASCII value of `a`. And if the same\nkey is pressed but with Shift being held (or Caps Lock being active), then the\nkey could would be 65, i.e. ASCII value of capital `A`.\n\nHowever for the key down and up events the returned key code will instead be `A`\nindependently of the state of the modifier keys i.e. it depends only on physical\nkey being pressed and is not translated to its logical representation using the\ncurrent keyboard state. Such untranslated key codes are defined as follows:\n\nNotice that the first rule applies to all Unicode letters, not just the usual\nLatin-1 ones. However for non-Latin-1 letters only `getUnicodeKey/1` can be used\nto retrieve the key code as `getKeyCode/1` just returns `WXK_NONE` in this case.\n\nTo summarize: you should handle `wxEVT_CHAR` if you need the translated key and\n`wxEVT_KEY_DOWN` if you only need the value of the key itself, independent of\nthe current keyboard state.\n\nNote: Not all key down events may be generated by the user. As an example,\n`wxEVT_KEY_DOWN` with `=` key code can be generated using the standard US\nkeyboard layout but not using the German one because the `=` key corresponds to\nShift-0 key combination in this layout and the key code for it is `0`, not `=`.\nBecause of this you should avoid requiring your users to type key events that\nmight be impossible to enter on their keyboard.\n\nAnother difference between key and char events is that another kind of\ntranslation is done for the latter ones when the Control key is pressed: char\nevents for ASCII letters in this case carry codes corresponding to the ASCII\nvalue of Ctrl-Latter, i.e. 1 for Ctrl-A, 2 for Ctrl-B and so on until 26 for\nCtrl-Z. This is convenient for terminal-like applications and can be completely\nignored by all the other ones (if you need to handle Ctrl-A it is probably a\nbetter idea to use the key event rather than the char one). Notice that\ncurrently no translation is done for the presses of [, `\\`, ], `^` and `_` keys\nwhich might be mapped to ASCII values from 27 to 31. Since version 2.9.2, the\nenum values `WXK_CONTROL_A` \\- `WXK_CONTROL_Z` can be used instead of the\nnon-descriptive constant values 1-26.\n\nFinally, modifier keys only generate key events but no char events at all. The\nmodifiers keys are `WXK_SHIFT`, `WXK_CONTROL`, `WXK_ALT` and various\n`WXK_WINDOWS_XXX` from ?wxKeyCode enum.\n\nModifier keys events are special in one additional aspect: usually the keyboard\nstate associated with a key press is well defined, e.g. `shiftDown/1` returns\n`true` only if the Shift key was held pressed when the key that generated this\nevent itself was pressed. There is an ambiguity for the key press events for\nShift key itself however. By convention, it is considered to be already pressed\nwhen it is pressed and already released when it is released. In other words,\n`wxEVT_KEY_DOWN` event for the Shift key itself will have `wxMOD_SHIFT` in\n`getModifiers/1` and `shiftDown/1` will return true while the `wxEVT_KEY_UP`\nevent for Shift itself will not have `wxMOD_SHIFT` in its modifiers and\n`shiftDown/1` will return false.\n\n`Tip:` You may discover the key codes and modifiers generated by all the keys on\nyour system interactively by running the page_samples_keyboard wxWidgets sample\nand pressing some keys in it.\n\nNote: If a key down (`EVT_KEY_DOWN`) event is caught and the event handler does\nnot call `event.Skip()` then the corresponding char event (`EVT_CHAR`) will not\nhappen. This is by design and enables the programs that handle both types of\nevents to avoid processing the same key twice. As a consequence, if you do not\nwant to suppress the `wxEVT_CHAR` events for the keys you handle, always call\n`event.Skip()` in your `wxEVT_KEY_DOWN` handler. Not doing may also prevent\naccelerators defined using this key from working.\n\nNote: If a key is maintained in a pressed state, you will typically get a lot of\n(automatically generated) key down events but only one key up one at the end\nwhen the key is released so it is wrong to assume that there is one up event\ncorresponding to each down one.\n\nNote: For Windows programmers: The key and char events in wxWidgets are similar\nto but slightly different from Windows `WM_KEYDOWN` and `WM_CHAR` events. In\nparticular, Alt-x combination will generate a char event in wxWidgets (unless it\nis used as an accelerator) and almost all keys, including ones without ASCII\nequivalents, generate char events too.\n\nSee: `wxKeyboardState` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxKeyEvent](https://docs.wxwidgets.org/3.1/classwx_key_event.html)","ref":"wxKeyEvent.html"},{"type":"module","title":"Events - wxKeyEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxKeyEventType`](`t:wxKeyEventType/0`) to\nsubscribe to events of this type.","ref":"wxKeyEvent.html#module-events"},{"type":"function","title":"wxKeyEvent.altDown/1","doc":"Returns true if the Alt key is pressed.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#altDown/1"},{"type":"function","title":"wxKeyEvent.cmdDown/1","doc":"Returns true if the key used for command accelerators is pressed.\n\nSame as `controlDown/1`. Deprecated.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#cmdDown/1"},{"type":"function","title":"wxKeyEvent.controlDown/1","doc":"Returns true if the Control key or Apple/Command key under macOS is pressed.\n\nThis function doesn't distinguish between right and left control keys.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#controlDown/1"},{"type":"function","title":"wxKeyEvent.getKeyCode/1","doc":"Returns the key code of the key that generated this event.\n\nASCII symbols return normal ASCII values, while events from special keys such as\n\"left cursor arrow\" (`WXK_LEFT`) return values outside of the ASCII range. See\n?wxKeyCode for a full list of the virtual key codes.\n\nNote that this method returns a meaningful value only for special\nnon-alphanumeric keys or if the user entered a Latin-1 character (this includes\nASCII and the accented letters found in Western European languages but not\nletters of other alphabets such as e.g. Cyrillic). Otherwise it simply method\nreturns `WXK_NONE` and `getUnicodeKey/1` should be used to obtain the\ncorresponding Unicode character.\n\nUsing `getUnicodeKey/1` is in general the right thing to do if you are\ninterested in the characters typed by the user, `getKeyCode/1` should be only\nused for special keys (for which `getUnicodeKey/1` returns `WXK_NONE`). To\nhandle both kinds of keys you might write:","ref":"wxKeyEvent.html#getKeyCode/1"},{"type":"function","title":"wxKeyEvent.getModifiers/1","doc":"Return the bit mask of all pressed modifier keys.\n\nThe return value is a combination of `wxMOD_ALT`, `wxMOD_CONTROL`, `wxMOD_SHIFT`\nand `wxMOD_META` bit masks. Additionally, `wxMOD_NONE` is defined as 0, i.e.\ncorresponds to no modifiers (see `HasAnyModifiers()` (not implemented in wx))\nand `wxMOD_CMD` is either `wxMOD_CONTROL` (MSW and Unix) or `wxMOD_META` (Mac),\nsee `cmdDown/1`. See ?wxKeyModifier for the full list of modifiers.\n\nNotice that this function is easier to use correctly than, for example,\n`controlDown/1` because when using the latter you also have to remember to test\nthat none of the other modifiers is pressed:\n\nand forgetting to do it can result in serious program bugs (e.g. program not\nworking with European keyboard layout where `AltGr` key which is seen by the\nprogram as combination of CTRL and ALT is used). On the other hand, you can\nsimply write:\n\nwith this function.","ref":"wxKeyEvent.html#getModifiers/1"},{"type":"function","title":"wxKeyEvent.getPosition/1","doc":"Obtains the position (in client coordinates) at which the key was pressed.\n\nNotice that under most platforms this position is simply the current mouse\npointer position and has no special relationship to the key event itself.\n\n`x` and `y` may be NULL if the corresponding coordinate is not needed.","ref":"wxKeyEvent.html#getPosition/1"},{"type":"function","title":"wxKeyEvent.getRawKeyCode/1","doc":"Returns the raw key code for this event.\n\nThe flags are platform-dependent and should only be used if the functionality\nprovided by other `m:wxKeyEvent` methods is insufficient.\n\nUnder MSW, the raw key code is the value of `wParam` parameter of the\ncorresponding message.\n\nUnder GTK, the raw key code is the `keyval` field of the corresponding GDK\nevent.\n\nUnder macOS, the raw key code is the `keyCode` field of the corresponding\nNSEvent.\n\nNote: Currently the raw key codes are not supported by all ports, use #ifdef\nwxHAS_RAW_KEY_CODES to determine if this feature is available.","ref":"wxKeyEvent.html#getRawKeyCode/1"},{"type":"function","title":"wxKeyEvent.getRawKeyFlags/1","doc":"Returns the low level key flags for this event.\n\nThe flags are platform-dependent and should only be used if the functionality\nprovided by other `m:wxKeyEvent` methods is insufficient.\n\nUnder MSW, the raw flags are just the value of `lParam` parameter of the\ncorresponding message.\n\nUnder GTK, the raw flags contain the `hardware_keycode` field of the\ncorresponding GDK event.\n\nUnder macOS, the raw flags contain the modifiers state.\n\nNote: Currently the raw key flags are not supported by all ports, use #ifdef\nwxHAS_RAW_KEY_CODES to determine if this feature is available.","ref":"wxKeyEvent.html#getRawKeyFlags/1"},{"type":"function","title":"wxKeyEvent.getUnicodeKey/1","doc":"Returns the Unicode character corresponding to this key event.\n\nIf the key pressed doesn't have any character value (e.g. a cursor key) this\nmethod will return `WXK_NONE`. In this case you should use `getKeyCode/1` to\nretrieve the value of the key.\n\nThis function is only available in Unicode build, i.e. when `wxUSE_UNICODE`\nis 1.","ref":"wxKeyEvent.html#getUnicodeKey/1"},{"type":"function","title":"wxKeyEvent.getX/1","doc":"Returns the X position (in client coordinates) of the event.\n\nSee: `getPosition/1`","ref":"wxKeyEvent.html#getX/1"},{"type":"function","title":"wxKeyEvent.getY/1","doc":"Returns the Y position (in client coordinates) of the event.\n\nSee: `getPosition/1`","ref":"wxKeyEvent.html#getY/1"},{"type":"function","title":"wxKeyEvent.hasModifiers/1","doc":"Returns true if Control or Alt are pressed.\n\nChecks if Control, Alt or, under macOS only, Command key are pressed (notice\nthat the real Control key is still taken into account under OS X too).\n\nThis method returns false if only Shift is pressed for compatibility reasons and\nalso because pressing Shift usually doesn't change the interpretation of key\nevents, see `HasAnyModifiers()` (not implemented in wx) if you want to take\nShift into account as well.","ref":"wxKeyEvent.html#hasModifiers/1"},{"type":"function","title":"wxKeyEvent.metaDown/1","doc":"Returns true if the Meta/Windows/Apple key is pressed.\n\nThis function tests the state of the key traditionally called Meta under Unix\nsystems, Windows keys under MSW Notice that `getModifiers/1` should usually be\nused instead of this one.\n\nSee: `cmdDown/1`","ref":"wxKeyEvent.html#metaDown/1"},{"type":"function","title":"wxKeyEvent.shiftDown/1","doc":"Returns true if the Shift key is pressed.\n\nThis function doesn't distinguish between right and left shift keys.\n\nNotice that `getModifiers/1` should usually be used instead of this one.","ref":"wxKeyEvent.html#shiftDown/1"},{"type":"type","title":"wxKeyEvent.wxKey/0","doc":"","ref":"wxKeyEvent.html#t:wxKey/0"},{"type":"type","title":"wxKeyEvent.wxKeyEvent/0","doc":"","ref":"wxKeyEvent.html#t:wxKeyEvent/0"},{"type":"type","title":"wxKeyEvent.wxKeyEventType/0","doc":"","ref":"wxKeyEvent.html#t:wxKeyEventType/0"},{"type":"module","title":"wxLayoutAlgorithm","doc":"Functions for wxLayoutAlgorithm class\n\n`m:wxLayoutAlgorithm` implements layout of subwindows in MDI or SDI frames. It\nsends a `wxCalculateLayoutEvent` (not implemented in wx) event to children of\nthe frame, asking them for information about their size. For MDI parent frames,\nthe algorithm allocates the remaining space to the MDI client window (which\ncontains the MDI child frames).\n\nFor SDI (normal) frames, a 'main' window is specified as taking up the remaining\nspace.\n\nBecause the event system is used, this technique can be applied to any windows,\nwhich are not necessarily 'aware' of the layout classes (no virtual functions in\n`m:wxWindow` refer to `m:wxLayoutAlgorithm` or its events). However, you may\nwish to use `m:wxSashLayoutWindow` for your subwindows since this class provides\nhandlers for the required events, and accessors to specify the desired size of\nthe window. The sash behaviour in the base class can be used, optionally, to\nmake the windows user-resizable.\n\n`m:wxLayoutAlgorithm` is typically used in IDE (integrated development\nenvironment) applications, where there are several resizable windows in addition\nto the MDI client window, or other primary editing window. Resizable windows\nmight include toolbars, a project window, and a window for displaying error and\nwarning messages.\n\nWhen a window receives an OnCalculateLayout event, it should call SetRect in the\ngiven event object, to be the old supplied rectangle minus whatever space the\nwindow takes up. It should also set its own size accordingly.\n`wxSashLayoutWindow::OnCalculateLayout` (not implemented in wx) generates an\nOnQueryLayoutInfo event which it sends to itself to determine the orientation,\nalignment and size of the window, which it gets from internal member variables\nset by the application.\n\nThe algorithm works by starting off with a rectangle equal to the whole frame\nclient area. It iterates through the frame children, generating\nwxLayoutAlgorithm::OnCalculateLayout events which subtract the window size and\nreturn the remaining rectangle for the next window to process. It is assumed (by\n`wxSashLayoutWindow::OnCalculateLayout` (not implemented in wx)) that a window\nstretches the full dimension of the frame client, according to the orientation\nit specifies. For example, a horizontal window will stretch the full width of\nthe remaining portion of the frame client area. In the other orientation, the\nwindow will be fixed to whatever size was specified by\nwxLayoutAlgorithm::OnQueryLayoutInfo. An alignment setting will make the window\n'stick' to the left, top, right or bottom of the remaining client area. This\nscheme implies that order of window creation is important. Say you wish to have\nan extra toolbar at the top of the frame, a project window to the left of the\nMDI client window, and an output window above the status bar. You should\ntherefore create the windows in this order: toolbar, output window, project\nwindow. This ensures that the toolbar and output window take up space at the top\nand bottom, and then the remaining height in-between is used for the project\nwindow.\n\n`m:wxLayoutAlgorithm` is quite independent of the way in which\nwxLayoutAlgorithm::OnCalculateLayout chooses to interpret a window's size and\nalignment. Therefore you could implement a different window class with a new\nwxLayoutAlgorithm::OnCalculateLayout event handler, that has a more\nsophisticated way of laying out the windows. It might allow specification of\nwhether stretching occurs in the specified orientation, for example, rather than\nalways assuming stretching. (This could, and probably should, be added to the\nexisting implementation).\n\nNote: `m:wxLayoutAlgorithm` has nothing to do with `wxLayoutConstraints` (not\nimplemented in wx). It is an alternative way of specifying layouts for which the\nnormal constraint system is unsuitable.\n\nSee: `m:wxSashEvent`, `m:wxSashLayoutWindow`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nwxWidgets docs:\n[wxLayoutAlgorithm](https://docs.wxwidgets.org/3.1/classwx_layout_algorithm.html)","ref":"wxLayoutAlgorithm.html"},{"type":"function","title":"wxLayoutAlgorithm.destroy/1","doc":"Destructor.","ref":"wxLayoutAlgorithm.html#destroy/1"},{"type":"function","title":"wxLayoutAlgorithm.layoutFrame/2","doc":"","ref":"wxLayoutAlgorithm.html#layoutFrame/2"},{"type":"function","title":"wxLayoutAlgorithm.layoutFrame/3","doc":"Lays out the children of a normal frame.\n\n`mainWindow` is set to occupy the remaining space. This function simply calls\n`layoutWindow/3`.","ref":"wxLayoutAlgorithm.html#layoutFrame/3"},{"type":"function","title":"wxLayoutAlgorithm.layoutMDIFrame/2","doc":"","ref":"wxLayoutAlgorithm.html#layoutMDIFrame/2"},{"type":"function","title":"wxLayoutAlgorithm.layoutMDIFrame/3","doc":"Lays out the children of an MDI parent frame.\n\nIf `rect` is non-NULL, the given rectangle will be used as a starting point\ninstead of the frame's client area. The MDI client window is set to occupy the\nremaining space.","ref":"wxLayoutAlgorithm.html#layoutMDIFrame/3"},{"type":"function","title":"wxLayoutAlgorithm.layoutWindow/2","doc":"","ref":"wxLayoutAlgorithm.html#layoutWindow/2"},{"type":"function","title":"wxLayoutAlgorithm.layoutWindow/3","doc":"Lays out the children of a normal frame or other window.\n\n`mainWindow` is set to occupy the remaining space. If this is not specified,\nthen the last window that responds to a calculate layout event in query mode\nwill get the remaining space (that is, a non-query OnCalculateLayout event will\nnot be sent to this window and the window will be set to the remaining size).","ref":"wxLayoutAlgorithm.html#layoutWindow/3"},{"type":"function","title":"wxLayoutAlgorithm.new/0","doc":"Default constructor.","ref":"wxLayoutAlgorithm.html#new/0"},{"type":"type","title":"wxLayoutAlgorithm.wxLayoutAlgorithm/0","doc":"","ref":"wxLayoutAlgorithm.html#t:wxLayoutAlgorithm/0"},{"type":"module","title":"wxListBox","doc":"Functions for wxListBox class\n\nA listbox is used to select one or more of a list of strings.\n\nThe strings are displayed in a scrolling box, with the selected string(s) marked\nin reverse video. A listbox can be single selection (if an item is selected, the\nprevious selection is removed) or multiple selection (clicking an item toggles\nthe item on or off independently of other selections).\n\nList box elements are numbered from zero and while the maximal number of\nelements is unlimited, it is usually better to use a virtual control, not\nrequiring to add all the items to it at once, such as `wxDataViewCtrl` (not\nimplemented in wx) or `m:wxListCtrl` with `wxLC_VIRTUAL` style, once more than a\nfew hundreds items need to be displayed because this control is not optimized,\nneither from performance nor from user interface point of view, for large number\nof items.\n\nNotice that the list box doesn't support control characters other than `TAB`.\n\nStyles\n\nThis class supports the following styles:\n\nSee: `wxEditableListBox` (not implemented in wx), `m:wxChoice`, `m:wxComboBox`,\n`m:wxListCtrl`, `m:wxCommandEvent`\n\nThis class is derived (and can use functions) from: `m:wxControlWithItems`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxListBox](https://docs.wxwidgets.org/3.1/classwx_list_box.html)","ref":"wxListBox.html"},{"type":"module","title":"Events - wxListBox","doc":"Event types emitted from this class:\n[`command_listbox_selected`](`m:wxCommandEvent`),\n[`command_listbox_doubleclicked`](`m:wxCommandEvent`)","ref":"wxListBox.html#module-events"},{"type":"function","title":"wxListBox.create/6","doc":"","ref":"wxListBox.html#create/6"},{"type":"function","title":"wxListBox.create/7","doc":"","ref":"wxListBox.html#create/7"},{"type":"function","title":"wxListBox.deselect/2","doc":"Deselects an item in the list box.\n\nRemark: This applies to multiple selection listboxes only.","ref":"wxListBox.html#deselect/2"},{"type":"function","title":"wxListBox.destroy/1","doc":"Destructor, destroying the list box.","ref":"wxListBox.html#destroy/1"},{"type":"function","title":"wxListBox.getSelections/1","doc":"Fill an array of ints with the positions of the currently selected items.\n\nReturn: The number of selections.\n\nRemark: Use this with a multiple selection listbox.\n\nSee: `wxControlWithItems:getSelection/1`,\n`wxControlWithItems:getStringSelection/1`, `wxControlWithItems:setSelection/2`","ref":"wxListBox.html#getSelections/1"},{"type":"function","title":"wxListBox.hitTest/2","doc":"Returns the item located at `point`, or `wxNOT_FOUND` if there is no item\nlocated at `point`.\n\nIt is currently implemented for wxMSW, wxMac and wxGTK2 ports.\n\nReturn: Item located at point, or wxNOT_FOUND if unimplemented or the item does\nnot exist.\n\nSince: 2.7.0","ref":"wxListBox.html#hitTest/2"},{"type":"function","title":"wxListBox.hitTest/3","doc":"This is an overloaded member function, provided for convenience. It differs from\nthe above function only in what argument(s) it accepts.","ref":"wxListBox.html#hitTest/3"},{"type":"function","title":"wxListBox.insertItems/3","doc":"Insert the given number of strings before the specified position.","ref":"wxListBox.html#insertItems/3"},{"type":"function","title":"wxListBox.isSelected/2","doc":"Determines whether an item is selected.\n\nReturn: true if the given item is selected, false otherwise.","ref":"wxListBox.html#isSelected/2"},{"type":"function","title":"wxListBox.new/0","doc":"Default constructor.","ref":"wxListBox.html#new/0"},{"type":"function","title":"wxListBox.new/2","doc":"","ref":"wxListBox.html#new/2"},{"type":"function","title":"wxListBox.new/3","doc":"Constructor, creating and showing a list box.\n\nSee the other `new/3` constructor; the only difference is that this overload\ntakes a `wxArrayString` (not implemented in wx) instead of a pointer to an array\nof `wxString` (not implemented in wx).","ref":"wxListBox.html#new/3"},{"type":"function","title":"wxListBox.set/2","doc":"Replaces the current control contents with the given items.\n\nNotice that calling this method is usually much faster than appending them one\nby one if you need to add a lot of items.","ref":"wxListBox.html#set/2"},{"type":"function","title":"wxListBox.setFirstItem/2","doc":"Set the specified item to be the first visible item.","ref":"wxListBox.html#setFirstItem/2"},{"type":"type","title":"wxListBox.wxListBox/0","doc":"","ref":"wxListBox.html#t:wxListBox/0"},{"type":"module","title":"wxListCtrl","doc":"Functions for wxListCtrl class\n\nA list control presents lists in a number of formats: list view, report view,\nicon view and small icon view. In any case, elements are numbered from zero. For\nall these modes, the items are stored in the control and must be added to it\nusing `insertItem/4` method.\n\nA special case of report view quite different from the other modes of the list\ncontrol is a virtual control in which the items data (including text, images and\nattributes) is managed by the main program and is requested by the control\nitself only when needed which allows having controls with millions of items\nwithout consuming much memory. To use virtual list control you must use\n`setItemCount/2` first and override at least `wxListCtrl::OnGetItemText` (not\nimplemented in wx) (and optionally `wxListCtrl::OnGetItemImage` (not implemented\nin wx) or `wxListCtrl::OnGetItemColumnImage` (not implemented in wx) and\n`wxListCtrl::OnGetItemAttr` (not implemented in wx)) to return the information\nabout the items when the control requests it.\n\nVirtual list control can be used as a normal one except that no operations which\ncan take time proportional to the number of items in the control happen - this\nis required to allow having a practically infinite number of items. For example,\nin a multiple selection virtual list control, the selections won't be sent when\nmany items are selected at once because this could mean iterating over all the\nitems.\n\nUsing many of `m:wxListCtrl` features is shown in the corresponding sample.\n\nTo intercept events from a list control, use the event table macros described in\n`m:wxListEvent`.\n\n`wxMac Note`: Starting with wxWidgets 2.8, `m:wxListCtrl` uses a native\nimplementation for report mode, and uses a generic implementation for other\nmodes. You can use the generic implementation for report mode as well by setting\nthe `mac.listctrl.always_use_generic` system option (see `m:wxSystemOptions`)\nto 1.\n\nStyles\n\nThis class supports the following styles:\n\nNote: Under wxMSW this control uses `wxSystemThemedControl` (not implemented in\nwx) for an explorer style appearance by default since wxWidgets 3.1.0. If this\nis not desired, you can call `wxSystemThemedControl::EnableSystemTheme` (not\nimplemented in wx) with `false` argument to disable this.\n\nSee:\n[Overview listctrl](https://docs.wxwidgets.org/3.1/overview_listctrl.html#overview_listctrl),\n`m:wxListView`, `m:wxListBox`, `m:wxTreeCtrl`, `m:wxImageList`, `m:wxListEvent`,\n`m:wxListItem`, `wxEditableListBox` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxListCtrl](https://docs.wxwidgets.org/3.1/classwx_list_ctrl.html)","ref":"wxListCtrl.html"},{"type":"module","title":"Events - wxListCtrl","doc":"Event types emitted from this class:\n[`command_list_begin_drag`](`m:wxListEvent`),\n[`command_list_begin_rdrag`](`m:wxListEvent`),\n[`command_list_begin_label_edit`](`m:wxListEvent`),\n[`command_list_end_label_edit`](`m:wxListEvent`),\n[`command_list_delete_item`](`m:wxListEvent`),\n[`command_list_delete_all_items`](`m:wxListEvent`),\n[`command_list_item_selected`](`m:wxListEvent`),\n[`command_list_item_deselected`](`m:wxListEvent`),\n[`command_list_item_activated`](`m:wxListEvent`),\n[`command_list_item_focused`](`m:wxListEvent`),\n[`command_list_item_middle_click`](`m:wxListEvent`),\n[`command_list_item_right_click`](`m:wxListEvent`),\n[`command_list_key_down`](`m:wxListEvent`),\n[`command_list_insert_item`](`m:wxListEvent`),\n[`command_list_col_click`](`m:wxListEvent`),\n[`command_list_col_right_click`](`m:wxListEvent`),\n[`command_list_col_begin_drag`](`m:wxListEvent`),\n[`command_list_col_dragging`](`m:wxListEvent`),\n[`command_list_col_end_drag`](`m:wxListEvent`),\n[`command_list_cache_hint`](`m:wxListEvent`)","ref":"wxListCtrl.html#module-events"},{"type":"function","title":"wxListCtrl.arrange/1","doc":"","ref":"wxListCtrl.html#arrange/1"},{"type":"function","title":"wxListCtrl.arrange/2","doc":"Arranges the items in icon or small icon view.\n\nThis only has effect on Win32. `flag` is one of:","ref":"wxListCtrl.html#arrange/2"},{"type":"function","title":"wxListCtrl.assignImageList/3","doc":"Sets the image list associated with the control and takes ownership of it (i.e.\n\nthe control will, unlike when using `setImageList/3`, delete the list when\ndestroyed). `which` is one of `wxIMAGE_LIST_NORMAL`, `wxIMAGE_LIST_SMALL`,\n`wxIMAGE_LIST_STATE` (the last is unimplemented).\n\nSee: `setImageList/3`","ref":"wxListCtrl.html#assignImageList/3"},{"type":"function","title":"wxListCtrl.clearAll/1","doc":"Deletes all items and all columns.\n\nNote: This sends an event of type `wxEVT_LIST_DELETE_ALL_ITEMS` under all\nplatforms.","ref":"wxListCtrl.html#clearAll/1"},{"type":"function","title":"wxListCtrl.create/3","doc":"Creates the list control.\n\nSee `new/2` for further details.","ref":"wxListCtrl.html#create/3"},{"type":"function","title":"wxListCtrl.deleteAllItems/1","doc":"Deletes all items in the list control.\n\nThis function does `not` send the `wxEVT_LIST_DELETE_ITEM` event because\ndeleting many items from the control would be too slow then (unlike\n`deleteItem/2`) but it does send the special `wxEVT_LIST_DELETE_ALL_ITEMS` event\nif the control was not empty. If it was already empty, nothing is done and no\nevent is sent.\n\nReturn: true if the items were successfully deleted or if the control was\nalready empty, false if an error occurred while deleting the items.","ref":"wxListCtrl.html#deleteAllItems/1"},{"type":"function","title":"wxListCtrl.deleteColumn/2","doc":"Deletes a column.","ref":"wxListCtrl.html#deleteColumn/2"},{"type":"function","title":"wxListCtrl.deleteItem/2","doc":"Deletes the specified item.\n\nThis function sends the `wxEVT_LIST_DELETE_ITEM` event for the item being\ndeleted.\n\nSee: `deleteAllItems/1`","ref":"wxListCtrl.html#deleteItem/2"},{"type":"function","title":"wxListCtrl.destroy/1","doc":"Destructor, destroying the list control.","ref":"wxListCtrl.html#destroy/1"},{"type":"function","title":"wxListCtrl.editLabel/2","doc":"Starts editing the label of the given item.\n\nThis function generates a `EVT_LIST_BEGIN_LABEL_EDIT` event which can be vetoed\nso that no text control will appear for in-place editing.\n\nIf the user changed the label (i.e. s/he does not press ESC or leave the text\ncontrol without changes, a `EVT_LIST_END_LABEL_EDIT` event will be sent which\ncan be vetoed as well.","ref":"wxListCtrl.html#editLabel/2"},{"type":"function","title":"wxListCtrl.ensureVisible/2","doc":"Ensures this item is visible.","ref":"wxListCtrl.html#ensureVisible/2"},{"type":"function","title":"wxListCtrl.findItem/3","doc":"","ref":"wxListCtrl.html#findItem/3"},{"type":"function","title":"wxListCtrl.findItem/4","doc":"Find an item nearest this position in the specified direction, starting from\n`start` or the beginning if `start` is -1.\n\nReturn: The next matching item if any or `-1` (wxNOT_FOUND) otherwise.","ref":"wxListCtrl.html#findItem/4"},{"type":"function","title":"wxListCtrl.getColumn/3","doc":"Gets information about this column.\n\nSee `setItem/5` for more information.","ref":"wxListCtrl.html#getColumn/3"},{"type":"function","title":"wxListCtrl.getColumnCount/1","doc":"Returns the number of columns.","ref":"wxListCtrl.html#getColumnCount/1"},{"type":"function","title":"wxListCtrl.getColumnWidth/2","doc":"Gets the column width (report view only).","ref":"wxListCtrl.html#getColumnWidth/2"},{"type":"function","title":"wxListCtrl.getCountPerPage/1","doc":"Gets the number of items that can fit vertically in the visible area of the list\ncontrol (list or report view) or the total number of items in the list control\n(icon or small icon view).","ref":"wxListCtrl.html#getCountPerPage/1"},{"type":"function","title":"wxListCtrl.getEditControl/1","doc":"Returns the edit control being currently used to edit a label.\n\nReturns NULL if no label is being edited.\n\nNote: It is currently only implemented for wxMSW and the generic version, not\nfor the native macOS version.","ref":"wxListCtrl.html#getEditControl/1"},{"type":"function","title":"wxListCtrl.getImageList/2","doc":"Returns the specified image list.\n\n`which` may be one of:","ref":"wxListCtrl.html#getImageList/2"},{"type":"function","title":"wxListCtrl.getItem/2","doc":"Gets information about the item.\n\nSee `setItem/5` for more information.\n\nYou must call `info.SetId()` to set the ID of item you're interested in before\ncalling this method, and `info.SetMask()` with the flags indicating what fields\nyou need to retrieve from `info`.","ref":"wxListCtrl.html#getItem/2"},{"type":"function","title":"wxListCtrl.getItemBackgroundColour/2","doc":"Returns the colour for this item.\n\nIf the item has no specific colour, returns an invalid colour (and not the\ndefault background control of the control itself).\n\nSee: `getItemTextColour/2`","ref":"wxListCtrl.html#getItemBackgroundColour/2"},{"type":"function","title":"wxListCtrl.getItemCount/1","doc":"Returns the number of items in the list control.","ref":"wxListCtrl.html#getItemCount/1"},{"type":"function","title":"wxListCtrl.getItemData/2","doc":"Gets the application-defined data associated with this item.","ref":"wxListCtrl.html#getItemData/2"},{"type":"function","title":"wxListCtrl.getItemFont/2","doc":"Returns the item's font.","ref":"wxListCtrl.html#getItemFont/2"},{"type":"function","title":"wxListCtrl.getItemPosition/2","doc":"Returns the position of the item, in icon or small icon view.","ref":"wxListCtrl.html#getItemPosition/2"},{"type":"function","title":"wxListCtrl.getItemRect/2","doc":"","ref":"wxListCtrl.html#getItemRect/2"},{"type":"function","title":"wxListCtrl.getItemRect/3","doc":"Returns the rectangle representing the item's size and position, in physical\ncoordinates.\n\n`code` is one of wxLIST_RECT_BOUNDS, wxLIST_RECT_ICON, wxLIST_RECT_LABEL.","ref":"wxListCtrl.html#getItemRect/3"},{"type":"function","title":"wxListCtrl.getItemSpacing/1","doc":"Retrieves the spacing between icons in pixels: horizontal spacing is returned as\n`x` component of the \\{Width,Height\\} object and the vertical spacing as its `y`\ncomponent.","ref":"wxListCtrl.html#getItemSpacing/1"},{"type":"function","title":"wxListCtrl.getItemState/3","doc":"Gets the item state.\n\nFor a list of state flags, see `setItem/5`. The `stateMask` indicates which\nstate flags are of interest.","ref":"wxListCtrl.html#getItemState/3"},{"type":"function","title":"wxListCtrl.getItemText/2","doc":"","ref":"wxListCtrl.html#getItemText/2"},{"type":"function","title":"wxListCtrl.getItemText/3","doc":"Gets the item text for this item.","ref":"wxListCtrl.html#getItemText/3"},{"type":"function","title":"wxListCtrl.getItemTextColour/2","doc":"Returns the colour for this item.\n\nIf the item has no specific colour, returns an invalid colour (and not the\ndefault foreground control of the control itself as this wouldn't allow\ndistinguishing between items having the same colour as the current control\nforeground and items with default colour which, hence, have always the same\ncolour as the control).","ref":"wxListCtrl.html#getItemTextColour/2"},{"type":"function","title":"wxListCtrl.getNextItem/2","doc":"","ref":"wxListCtrl.html#getNextItem/2"},{"type":"function","title":"wxListCtrl.getNextItem/3","doc":"Searches for an item with the given geometry or state, starting from `item` but\nexcluding the `item` itself.\n\nIf `item` is -1, the first item that matches the specified flags will be\nreturned. Returns the first item with given state following `item` or -1 if no\nsuch item found. This function may be used to find all selected items in the\ncontrol like this:\n\n`geometry` can be one of:\n\nNote: this parameter is only supported by wxMSW currently and ignored on other\nplatforms.\n\n`state` can be a bitlist of the following:","ref":"wxListCtrl.html#getNextItem/3"},{"type":"function","title":"wxListCtrl.getSelectedItemCount/1","doc":"Returns the number of selected items in the list control.","ref":"wxListCtrl.html#getSelectedItemCount/1"},{"type":"function","title":"wxListCtrl.getTextColour/1","doc":"Gets the text colour of the list control.","ref":"wxListCtrl.html#getTextColour/1"},{"type":"function","title":"wxListCtrl.getTopItem/1","doc":"Gets the index of the topmost visible item when in list or report view.","ref":"wxListCtrl.html#getTopItem/1"},{"type":"function","title":"wxListCtrl.getViewRect/1","doc":"Returns the rectangle taken by all items in the control.\n\nIn other words, if the controls client size were equal to the size of this\nrectangle, no scrollbars would be needed and no free space would be left.\n\nNote that this function only works in the icon and small icon views, not in list\nor report views (this is a limitation of the native Win32 control).","ref":"wxListCtrl.html#getViewRect/1"},{"type":"function","title":"wxListCtrl.hitTest/2","doc":"Determines which item (if any) is at the specified point, giving details in\n`flags`.\n\nReturns index of the item or `wxNOT_FOUND` if no item is at the specified point.\n\n`flags` will be a combination of the following flags:\n\nIf `ptrSubItem` is not NULL and the `m:wxListCtrl` is in the report mode the\nsubitem (or column) number will also be provided. This feature is only available\nin version 2.7.0 or higher and is currently only implemented under wxMSW and\nrequires at least comctl32.dll of version 4.70 on the host system or the value\nstored in `ptrSubItem` will be always -1. To compile this feature into wxWidgets\nlibrary you need to have access to commctrl.h of version 4.70 that is provided\nby Microsoft.","ref":"wxListCtrl.html#hitTest/2"},{"type":"function","title":"wxListCtrl.insertColumn/3","doc":"For report view mode (only), inserts a column.\n\nFor more details, see `setItem/5`. Also see `insertColumn/4` overload for a\nusually more convenient alternative to this method and the description of how\nthe item width is interpreted by this method.","ref":"wxListCtrl.html#insertColumn/3"},{"type":"function","title":"wxListCtrl.insertColumn/4","doc":"For report view mode (only), inserts a column.\n\nInsert a new column in the list control in report view mode at the given\nposition specifying its most common attributes.\n\nNotice that to set the image for the column you need to use `insertColumn/4`\noverload and specify ?wxLIST_MASK_IMAGE in the item mask.\n\nReturn: The index of the inserted column or -1 if adding it failed.","ref":"wxListCtrl.html#insertColumn/4"},{"type":"function","title":"wxListCtrl.insertItem/2","doc":"Inserts an item, returning the index of the new item if successful, -1\notherwise.","ref":"wxListCtrl.html#insertItem/2"},{"type":"function","title":"wxListCtrl.insertItem/3","doc":"Insert a string item.","ref":"wxListCtrl.html#insertItem/3"},{"type":"function","title":"wxListCtrl.insertItem/4","doc":"Insert an image/string item.","ref":"wxListCtrl.html#insertItem/4"},{"type":"function","title":"wxListCtrl.new/0","doc":"Default constructor.","ref":"wxListCtrl.html#new/0"},{"type":"function","title":"wxListCtrl.new/2","doc":"Constructor, creating and showing a list control.\n\nSee: `create/3`, `wxValidator` (not implemented in wx)","ref":"wxListCtrl.html#new/2"},{"type":"function","title":"wxListCtrl.refreshItem/2","doc":"Redraws the given `item`.\n\nThis is only useful for the virtual list controls as without calling this\nfunction the displayed value of the item doesn't change even when the underlying\ndata does change.\n\nSee: `refreshItems/3`","ref":"wxListCtrl.html#refreshItem/2"},{"type":"function","title":"wxListCtrl.refreshItems/3","doc":"Redraws the items between `itemFrom` and `itemTo`.\n\nThe starting item must be less than or equal to the ending one.\n\nJust as `refreshItem/2` this is only useful for virtual list controls.","ref":"wxListCtrl.html#refreshItems/3"},{"type":"function","title":"wxListCtrl.scrollList/3","doc":"Scrolls the list control.\n\nIf in icon, small icon or report view mode, `dx` specifies the number of pixels\nto scroll. If in list view mode, `dx` specifies the number of columns to scroll.\n`dy` always specifies the number of pixels to scroll vertically.\n\nNote: This method is currently only implemented in the Windows version.","ref":"wxListCtrl.html#scrollList/3"},{"type":"function","title":"wxListCtrl.setBackgroundColour/2","doc":"Sets the background colour.\n\nNote that the `wxWindow:getBackgroundColour/1` function of `m:wxWindow` base\nclass can be used to retrieve the current background colour.","ref":"wxListCtrl.html#setBackgroundColour/2"},{"type":"function","title":"wxListCtrl.setColumn/3","doc":"Sets information about this column.\n\nSee `setItem/5` for more information.","ref":"wxListCtrl.html#setColumn/3"},{"type":"function","title":"wxListCtrl.setColumnWidth/3","doc":"Sets the column width.\n\n`width` can be a width in pixels or `wxLIST_AUTOSIZE` (-1) or\n`wxLIST_AUTOSIZE_USEHEADER` (-2).\n\n`wxLIST_AUTOSIZE` will resize the column to the length of its longest item.\n\n`wxLIST_AUTOSIZE_USEHEADER` will resize the column to the length of the header\n(Win32) or 80 pixels (other platforms).\n\nIn small or normal icon view, `col` must be -1, and the column width is set for\nall columns.","ref":"wxListCtrl.html#setColumnWidth/3"},{"type":"function","title":"wxListCtrl.setImageList/3","doc":"Sets the image list associated with the control.\n\n`which` is one of `wxIMAGE_LIST_NORMAL`, `wxIMAGE_LIST_SMALL`,\n`wxIMAGE_LIST_STATE` (the last is unimplemented).\n\nThis method does not take ownership of the image list, you have to delete it\nyourself.\n\nSee: `assignImageList/3`","ref":"wxListCtrl.html#setImageList/3"},{"type":"function","title":"wxListCtrl.setItem/2","doc":"Sets the data of an item.\n\nUsing the `m:wxListItem`'s mask and state mask, you can change only selected\nattributes of a `m:wxListCtrl` item.\n\nReturn: true if the item was successfully updated or false if the update failed\nfor some reason (e.g. an invalid item index).","ref":"wxListCtrl.html#setItem/2"},{"type":"function","title":"wxListCtrl.setItem/4","doc":"","ref":"wxListCtrl.html#setItem/4"},{"type":"function","title":"wxListCtrl.setItem/5","doc":"Sets an item string field at a particular column.\n\nReturn: true if the item was successfully updated or false if the update failed\nfor some reason (e.g. an invalid item index).","ref":"wxListCtrl.html#setItem/5"},{"type":"function","title":"wxListCtrl.setItemBackgroundColour/3","doc":"Sets the background colour for this item.\n\nThis function only works in report view mode. The colour can be retrieved using\n`getItemBackgroundColour/2`.","ref":"wxListCtrl.html#setItemBackgroundColour/3"},{"type":"function","title":"wxListCtrl.setItemColumnImage/4","doc":"Sets the image associated with the item.\n\nIn report view, you can specify the column. The image is an index into the image\nlist associated with the list control.","ref":"wxListCtrl.html#setItemColumnImage/4"},{"type":"function","title":"wxListCtrl.setItemCount/2","doc":"This method can only be used with virtual list controls.\n\nIt is used to indicate to the control the number of items it contains. After\ncalling it, the main program should be ready to handle calls to various item\ncallbacks (such as `wxListCtrl::OnGetItemText` (not implemented in wx)) for all\nitems in the range from 0 to `count`.\n\nNotice that the control is not necessarily redrawn after this call as it may be\nundesirable if an item which is not visible on the screen anyhow was added to or\nremoved from a control displaying many items, if you do need to refresh the\ndisplay you can just call `wxWindow:refresh/2` manually.","ref":"wxListCtrl.html#setItemCount/2"},{"type":"function","title":"wxListCtrl.setItemData/3","doc":"Associates application-defined data with this item.\n\nNotice that this function cannot be used to associate pointers with the control\nitems, use `SetItemPtrData()` (not implemented in wx) instead.","ref":"wxListCtrl.html#setItemData/3"},{"type":"function","title":"wxListCtrl.setItemFont/3","doc":"Sets the item's font.","ref":"wxListCtrl.html#setItemFont/3"},{"type":"function","title":"wxListCtrl.setItemImage/3","doc":"","ref":"wxListCtrl.html#setItemImage/3"},{"type":"function","title":"wxListCtrl.setItemImage/4","doc":"Sets the unselected and selected images associated with the item.\n\nThe images are indices into the image list associated with the list control.","ref":"wxListCtrl.html#setItemImage/4"},{"type":"function","title":"wxListCtrl.setItemPosition/3","doc":"Sets the position of the item, in icon or small icon view.\n\nWindows only.","ref":"wxListCtrl.html#setItemPosition/3"},{"type":"function","title":"wxListCtrl.setItemState/4","doc":"Sets the item state.\n\nThe `stateMask` is a combination of `wxLIST_STATE_XXX` constants described in\n`m:wxListItem` documentation. For each of the bits specified in `stateMask`, the\ncorresponding state is set or cleared depending on whether `state` argument\ncontains the same bit or not.\n\nSo to select an item you can use while to deselect it you should use\n\nConsider using `m:wxListView` if possible to avoid dealing with this error-prone\nand confusing method.\n\nAlso notice that contrary to the usual rule that only user actions generate\nevents, this method does generate wxEVT_LIST_ITEM_SELECTED event when it is used\nto select an item.","ref":"wxListCtrl.html#setItemState/4"},{"type":"function","title":"wxListCtrl.setItemText/3","doc":"Sets the item text for this item.","ref":"wxListCtrl.html#setItemText/3"},{"type":"function","title":"wxListCtrl.setItemTextColour/3","doc":"Sets the colour for this item.\n\nThis function only works in report view. The colour can be retrieved using\n`getItemTextColour/2`.","ref":"wxListCtrl.html#setItemTextColour/3"},{"type":"function","title":"wxListCtrl.setSingleStyle/2","doc":"","ref":"wxListCtrl.html#setSingleStyle/2"},{"type":"function","title":"wxListCtrl.setSingleStyle/3","doc":"Adds or removes a single window style.","ref":"wxListCtrl.html#setSingleStyle/3"},{"type":"function","title":"wxListCtrl.setTextColour/2","doc":"Sets the text colour of the list control.","ref":"wxListCtrl.html#setTextColour/2"},{"type":"function","title":"wxListCtrl.setWindowStyleFlag/2","doc":"Sets the whole window style, deleting all items.","ref":"wxListCtrl.html#setWindowStyleFlag/2"},{"type":"function","title":"wxListCtrl.sortItems/2","doc":"Sort the items in the list control.\n\nSorts the items with supplied `SortCallBack` fun.\n\nSortCallBack receives the client data associated with two items to compare\n(`NOT` the the index), and should return 0 if the items are equal, a negative\nvalue if the first item is less than the second one and a positive value if the\nfirst item is greater than the second one.\n\nRemark: Notice that the control may only be sorted on client data associated\nwith the items, so you must use SetItemData if you want to be able to sort the\nitems in the control.\n\nThe callback may not call other (wx) processes.","ref":"wxListCtrl.html#sortItems/2"},{"type":"type","title":"wxListCtrl.wxListCtrl/0","doc":"","ref":"wxListCtrl.html#t:wxListCtrl/0"},{"type":"module","title":"wxListEvent","doc":"Functions for wxListEvent class\n\nA list event holds information about events associated with `m:wxListCtrl`\nobjects.\n\nSee: `m:wxListCtrl`\n\nThis class is derived (and can use functions) from: `m:wxNotifyEvent`\n`m:wxCommandEvent` `m:wxEvent`\n\nwxWidgets docs:\n[wxListEvent](https://docs.wxwidgets.org/3.1/classwx_list_event.html)","ref":"wxListEvent.html"},{"type":"module","title":"Events - wxListEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxListEventType`](`t:wxListEventType/0`) to\nsubscribe to events of this type.","ref":"wxListEvent.html#module-events"},{"type":"function","title":"wxListEvent.getCacheFrom/1","doc":"For `EVT_LIST_CACHE_HINT` event only: return the first item which the list\ncontrol advises us to cache.","ref":"wxListEvent.html#getCacheFrom/1"},{"type":"function","title":"wxListEvent.getCacheTo/1","doc":"For `EVT_LIST_CACHE_HINT` event only: return the last item (inclusive) which the\nlist control advises us to cache.","ref":"wxListEvent.html#getCacheTo/1"},{"type":"function","title":"wxListEvent.getColumn/1","doc":"The column position: it is only used with `COL` events.\n\nFor the column dragging events, it is the column to the left of the divider\nbeing dragged, for the column click events it may be -1 if the user clicked in\nthe list control header outside any column.","ref":"wxListEvent.html#getColumn/1"},{"type":"function","title":"wxListEvent.getData/1","doc":"The data.","ref":"wxListEvent.html#getData/1"},{"type":"function","title":"wxListEvent.getImage/1","doc":"The image.","ref":"wxListEvent.html#getImage/1"},{"type":"function","title":"wxListEvent.getIndex/1","doc":"The item index.","ref":"wxListEvent.html#getIndex/1"},{"type":"function","title":"wxListEvent.getItem/1","doc":"An item object, used by some events.\n\nSee also `wxListCtrl:setItem/5`.","ref":"wxListEvent.html#getItem/1"},{"type":"function","title":"wxListEvent.getKeyCode/1","doc":"Key code if the event is a keypress event.","ref":"wxListEvent.html#getKeyCode/1"},{"type":"function","title":"wxListEvent.getLabel/1","doc":"The (new) item label for `EVT_LIST_END_LABEL_EDIT` event.","ref":"wxListEvent.html#getLabel/1"},{"type":"function","title":"wxListEvent.getMask/1","doc":"The mask.","ref":"wxListEvent.html#getMask/1"},{"type":"function","title":"wxListEvent.getPoint/1","doc":"The position of the mouse pointer if the event is a drag event.","ref":"wxListEvent.html#getPoint/1"},{"type":"function","title":"wxListEvent.getText/1","doc":"The text.","ref":"wxListEvent.html#getText/1"},{"type":"function","title":"wxListEvent.isEditCancelled/1","doc":"This method only makes sense for `EVT_LIST_END_LABEL_EDIT` message and returns\ntrue if it the label editing has been cancelled by the user (`getLabel/1`\nreturns an empty string in this case but it doesn't allow the application to\ndistinguish between really cancelling the edit and the admittedly rare case when\nthe user wants to rename it to an empty string).","ref":"wxListEvent.html#isEditCancelled/1"},{"type":"type","title":"wxListEvent.wxList/0","doc":"","ref":"wxListEvent.html#t:wxList/0"},{"type":"type","title":"wxListEvent.wxListEvent/0","doc":"","ref":"wxListEvent.html#t:wxListEvent/0"},{"type":"type","title":"wxListEvent.wxListEventType/0","doc":"","ref":"wxListEvent.html#t:wxListEventType/0"},{"type":"module","title":"wxListItem","doc":"Functions for wxListItem class\n\nThis class stores information about a `m:wxListCtrl` item or column.\n\n`m:wxListItem` is a class which contains information about:\n\nThe `m:wxListItem` object can also contain item-specific colour and font\ninformation: for this you need to call one of `setTextColour/2`,\n`setBackgroundColour/2` or `setFont/2` functions on it passing it the\ncolour/font to use. If the colour/font is not specified, the default list\ncontrol colour/font is used.\n\nSee: `m:wxListCtrl`\n\nwxWidgets docs:\n[wxListItem](https://docs.wxwidgets.org/3.1/classwx_list_item.html)","ref":"wxListItem.html"},{"type":"function","title":"wxListItem.clear/1","doc":"Resets the item state to the default.","ref":"wxListItem.html#clear/1"},{"type":"function","title":"wxListItem.destroy/1","doc":"Destroys the object.","ref":"wxListItem.html#destroy/1"},{"type":"function","title":"wxListItem.getAlign/1","doc":"Returns the alignment for this item.\n\nCan be one of `wxLIST_FORMAT_LEFT`, `wxLIST_FORMAT_RIGHT` or\n`wxLIST_FORMAT_CENTRE`.","ref":"wxListItem.html#getAlign/1"},{"type":"function","title":"wxListItem.getBackgroundColour/1","doc":"Returns the background colour for this item.","ref":"wxListItem.html#getBackgroundColour/1"},{"type":"function","title":"wxListItem.getColumn/1","doc":"Returns the zero-based column; meaningful only in report mode.","ref":"wxListItem.html#getColumn/1"},{"type":"function","title":"wxListItem.getFont/1","doc":"Returns the font used to display the item.","ref":"wxListItem.html#getFont/1"},{"type":"function","title":"wxListItem.getId/1","doc":"Returns the zero-based item position.","ref":"wxListItem.html#getId/1"},{"type":"function","title":"wxListItem.getImage/1","doc":"Returns the zero-based index of the image associated with the item into the\nimage list.","ref":"wxListItem.html#getImage/1"},{"type":"function","title":"wxListItem.getMask/1","doc":"Returns a bit mask indicating which fields of the structure are valid.\n\nCan be any combination of the following values:","ref":"wxListItem.html#getMask/1"},{"type":"function","title":"wxListItem.getState/1","doc":"Returns a bit field representing the state of the item.\n\nCan be any combination of:","ref":"wxListItem.html#getState/1"},{"type":"function","title":"wxListItem.getText/1","doc":"Returns the label/header text.","ref":"wxListItem.html#getText/1"},{"type":"function","title":"wxListItem.getTextColour/1","doc":"Returns the text colour.","ref":"wxListItem.html#getTextColour/1"},{"type":"function","title":"wxListItem.getWidth/1","doc":"Meaningful only for column headers in report mode.\n\nReturns the column width.","ref":"wxListItem.html#getWidth/1"},{"type":"function","title":"wxListItem.new/0","doc":"Constructor.","ref":"wxListItem.html#new/0"},{"type":"function","title":"wxListItem.new/1","doc":"","ref":"wxListItem.html#new/1"},{"type":"function","title":"wxListItem.setAlign/2","doc":"Sets the alignment for the item.\n\nSee also `getAlign/1`","ref":"wxListItem.html#setAlign/2"},{"type":"function","title":"wxListItem.setBackgroundColour/2","doc":"Sets the background colour for the item.","ref":"wxListItem.html#setBackgroundColour/2"},{"type":"function","title":"wxListItem.setColumn/2","doc":"Sets the zero-based column.\n\nMeaningful only in report mode.","ref":"wxListItem.html#setColumn/2"},{"type":"function","title":"wxListItem.setFont/2","doc":"Sets the font for the item.","ref":"wxListItem.html#setFont/2"},{"type":"function","title":"wxListItem.setId/2","doc":"Sets the zero-based item position.","ref":"wxListItem.html#setId/2"},{"type":"function","title":"wxListItem.setImage/2","doc":"Sets the zero-based index of the image associated with the item into the image\nlist.","ref":"wxListItem.html#setImage/2"},{"type":"function","title":"wxListItem.setMask/2","doc":"Sets the mask of valid fields.\n\nSee `getMask/1`.","ref":"wxListItem.html#setMask/2"},{"type":"function","title":"wxListItem.setState/2","doc":"Sets the item state flags (note that the valid state flags are influenced by the\nvalue of the state mask, see `setStateMask/2`).\n\nSee `getState/1` for valid flag values.","ref":"wxListItem.html#setState/2"},{"type":"function","title":"wxListItem.setStateMask/2","doc":"Sets the bitmask that is used to determine which of the state flags are to be\nset.\n\nSee also `setState/2`.","ref":"wxListItem.html#setStateMask/2"},{"type":"function","title":"wxListItem.setText/2","doc":"Sets the text label for the item.","ref":"wxListItem.html#setText/2"},{"type":"function","title":"wxListItem.setTextColour/2","doc":"Sets the text colour for the item.","ref":"wxListItem.html#setTextColour/2"},{"type":"function","title":"wxListItem.setWidth/2","doc":"Meaningful only for column headers in report mode.\n\nSets the column width.","ref":"wxListItem.html#setWidth/2"},{"type":"type","title":"wxListItem.wxListItem/0","doc":"","ref":"wxListItem.html#t:wxListItem/0"},{"type":"module","title":"wxListItemAttr","doc":"Functions for wxListItemAttr class\n\nwxWidgets docs:\n[wxListItemAttr](https://docs.wxwidgets.org/3.1/classwx_list_item_attr.html)","ref":"wxListItemAttr.html"},{"type":"function","title":"wxListItemAttr.destroy/1","doc":"Destroys the object.","ref":"wxListItemAttr.html#destroy/1"},{"type":"function","title":"wxListItemAttr.getBackgroundColour/1","doc":"","ref":"wxListItemAttr.html#getBackgroundColour/1"},{"type":"function","title":"wxListItemAttr.getFont/1","doc":"","ref":"wxListItemAttr.html#getFont/1"},{"type":"function","title":"wxListItemAttr.getTextColour/1","doc":"","ref":"wxListItemAttr.html#getTextColour/1"},{"type":"function","title":"wxListItemAttr.hasBackgroundColour/1","doc":"","ref":"wxListItemAttr.html#hasBackgroundColour/1"},{"type":"function","title":"wxListItemAttr.hasFont/1","doc":"","ref":"wxListItemAttr.html#hasFont/1"},{"type":"function","title":"wxListItemAttr.hasTextColour/1","doc":"","ref":"wxListItemAttr.html#hasTextColour/1"},{"type":"function","title":"wxListItemAttr.new/0","doc":"","ref":"wxListItemAttr.html#new/0"},{"type":"function","title":"wxListItemAttr.new/3","doc":"","ref":"wxListItemAttr.html#new/3"},{"type":"function","title":"wxListItemAttr.setBackgroundColour/2","doc":"","ref":"wxListItemAttr.html#setBackgroundColour/2"},{"type":"function","title":"wxListItemAttr.setFont/2","doc":"","ref":"wxListItemAttr.html#setFont/2"},{"type":"function","title":"wxListItemAttr.setTextColour/2","doc":"","ref":"wxListItemAttr.html#setTextColour/2"},{"type":"type","title":"wxListItemAttr.wxListItemAttr/0","doc":"","ref":"wxListItemAttr.html#t:wxListItemAttr/0"},{"type":"module","title":"wxListView","doc":"Functions for wxListView class\n\nThis class currently simply presents a simpler to use interface for the\n`m:wxListCtrl` \\- it can be thought of as a `façade` for that complicated class.\n\nUsing it is preferable to using `m:wxListCtrl` directly whenever possible\nbecause in the future some ports might implement `m:wxListView` but not the full\nset of `m:wxListCtrl` features.\n\nOther than different interface, this class is identical to `m:wxListCtrl`. In\nparticular, it uses the same events, same window styles and so on.\n\nSee: `setColumnImage/3`\n\nThis class is derived (and can use functions) from: `m:wxControl` `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxListView](https://docs.wxwidgets.org/3.1/classwx_list_view.html)","ref":"wxListView.html"},{"type":"function","title":"wxListView.clearColumnImage/2","doc":"Resets the column image - after calling this function, no image will be shown.\n\nSee: `setColumnImage/3`","ref":"wxListView.html#clearColumnImage/2"},{"type":"function","title":"wxListView.focus/2","doc":"Sets focus to the item with the given `index`.","ref":"wxListView.html#focus/2"},{"type":"function","title":"wxListView.getFirstSelected/1","doc":"Returns the first selected item in a (presumably) multiple selection control.\n\nTogether with `getNextSelected/2` it can be used to iterate over all selected\nitems in the control.\n\nReturn: The first selected item, if any, -1 otherwise.","ref":"wxListView.html#getFirstSelected/1"},{"type":"function","title":"wxListView.getFocusedItem/1","doc":"Returns the currently focused item or -1 if none.\n\nSee: `isSelected/2`, `focus/2`","ref":"wxListView.html#getFocusedItem/1"},{"type":"function","title":"wxListView.getNextSelected/2","doc":"Used together with `getFirstSelected/1` to iterate over all selected items in\nthe control.\n\nReturn: Returns the next selected item or -1 if there are no more of them.","ref":"wxListView.html#getNextSelected/2"},{"type":"function","title":"wxListView.isSelected/2","doc":"Returns true if the item with the given `index` is selected, false otherwise.\n\nSee: `getFirstSelected/1`, `getNextSelected/2`","ref":"wxListView.html#isSelected/2"},{"type":"function","title":"wxListView.select/2","doc":"","ref":"wxListView.html#select/2"},{"type":"function","title":"wxListView.select/3","doc":"Selects or unselects the given item.\n\nNotice that this method inherits the unusual behaviour of\n`wxListCtrl:setItemState/4` which sends a wxEVT_LIST_ITEM_SELECTED event when it\nis used to select an item, contrary to the usual rule that only the user actions\nresult in selection.","ref":"wxListView.html#select/3"},{"type":"function","title":"wxListView.setColumnImage/3","doc":"Sets the column image for the specified column.\n\nTo use the column images, the control must have a valid image list with at least\none image.","ref":"wxListView.html#setColumnImage/3"},{"type":"type","title":"wxListView.wxListView/0","doc":"","ref":"wxListView.html#t:wxListView/0"},{"type":"module","title":"wxListbook","doc":"Functions for wxListbook class\n\n`m:wxListbook` is a class similar to `m:wxNotebook` but which uses a\n`m:wxListCtrl` to show the labels instead of the tabs.\n\nThe underlying `m:wxListCtrl` displays page labels in a one-column report view\nby default. Calling wxBookCtrl::SetImageList will implicitly switch the control\nto use an icon view.\n\nFor usage documentation of this class, please refer to the base abstract class\nwxBookCtrl. You can also use the page_samples_notebook to see `m:wxListbook` in\naction.\n\nStyles\n\nThis class supports the following styles:\n\nSee: ?wxBookCtrl, `m:wxNotebook`,\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_notebook)\n\nThis class is derived (and can use functions) from: `m:wxBookCtrlBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxListbook](https://docs.wxwidgets.org/3.1/classwx_listbook.html)","ref":"wxListbook.html"},{"type":"module","title":"Events - wxListbook","doc":"Event types emitted from this class:\n[`listbook_page_changed`](`m:wxBookCtrlEvent`),\n[`listbook_page_changing`](`m:wxBookCtrlEvent`)","ref":"wxListbook.html#module-events"},{"type":"function","title":"wxListbook.addPage/3","doc":"","ref":"wxListbook.html#addPage/3"},{"type":"function","title":"wxListbook.addPage/4","doc":"Adds a new page.\n\nThe page must have the book control itself as the parent and must not have been\nadded to this control previously.\n\nThe call to this function will generate the page changing and page changed\nevents if `select` is true, but not when inserting the very first page (as there\nis no previous page selection to switch from in this case and so it wouldn't\nmake sense to e.g. veto such event).\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `insertPage/5`","ref":"wxListbook.html#addPage/4"},{"type":"function","title":"wxListbook.advanceSelection/1","doc":"","ref":"wxListbook.html#advanceSelection/1"},{"type":"function","title":"wxListbook.advanceSelection/2","doc":"Cycles through the tabs.\n\nThe call to this function generates the page changing events.","ref":"wxListbook.html#advanceSelection/2"},{"type":"function","title":"wxListbook.assignImageList/2","doc":"Sets the image list for the page control and takes ownership of the list.\n\nSee: `m:wxImageList`, `setImageList/2`","ref":"wxListbook.html#assignImageList/2"},{"type":"function","title":"wxListbook.changeSelection/2","doc":"Changes the selection to the given page, returning the previous selection.\n\nThis function behaves as `setSelection/2` but does `not` generate the page\nchanging events.\n\nSee overview_events_prog for more information.","ref":"wxListbook.html#changeSelection/2"},{"type":"function","title":"wxListbook.create/3","doc":"","ref":"wxListbook.html#create/3"},{"type":"function","title":"wxListbook.create/4","doc":"Create the list book control that has already been constructed with the default\nconstructor.","ref":"wxListbook.html#create/4"},{"type":"function","title":"wxListbook.deleteAllPages/1","doc":"Deletes all pages.","ref":"wxListbook.html#deleteAllPages/1"},{"type":"function","title":"wxListbook.destroy/1","doc":"Destroys the object.","ref":"wxListbook.html#destroy/1"},{"type":"function","title":"wxListbook.getCurrentPage/1","doc":"Returns the currently selected page or NULL.","ref":"wxListbook.html#getCurrentPage/1"},{"type":"function","title":"wxListbook.getImageList/1","doc":"Returns the associated image list, may be NULL.\n\nSee: `m:wxImageList`, `setImageList/2`","ref":"wxListbook.html#getImageList/1"},{"type":"function","title":"wxListbook.getPage/2","doc":"Returns the window at the given page position.","ref":"wxListbook.html#getPage/2"},{"type":"function","title":"wxListbook.getPageCount/1","doc":"Returns the number of pages in the control.","ref":"wxListbook.html#getPageCount/1"},{"type":"function","title":"wxListbook.getPageImage/2","doc":"Returns the image index for the given page.","ref":"wxListbook.html#getPageImage/2"},{"type":"function","title":"wxListbook.getPageText/2","doc":"Returns the string for the given page.","ref":"wxListbook.html#getPageText/2"},{"type":"function","title":"wxListbook.getSelection/1","doc":"Returns the currently selected page, or `wxNOT_FOUND` if none was selected.\n\nNote that this method may return either the previously or newly selected page\nwhen called from the `EVT_BOOKCTRL_PAGE_CHANGED` handler depending on the\nplatform and so `wxBookCtrlEvent:getSelection/1` should be used instead in this\ncase.","ref":"wxListbook.html#getSelection/1"},{"type":"function","title":"wxListbook.hitTest/2","doc":"Returns the index of the tab at the specified position or `wxNOT_FOUND` if none.\n\nIf `flags` parameter is non-NULL, the position of the point inside the tab is\nreturned as well.\n\nReturn: Returns the zero-based tab index or `wxNOT_FOUND` if there is no tab at\nthe specified position.","ref":"wxListbook.html#hitTest/2"},{"type":"function","title":"wxListbook.insertPage/4","doc":"","ref":"wxListbook.html#insertPage/4"},{"type":"function","title":"wxListbook.insertPage/5","doc":"Inserts a new page at the specified position.\n\nReturn: true if successful, false otherwise.\n\nRemark: Do not delete the page, it will be deleted by the book control.\n\nSee: `addPage/4`","ref":"wxListbook.html#insertPage/5"},{"type":"function","title":"wxListbook.new/0","doc":"Default ctor.","ref":"wxListbook.html#new/0"},{"type":"function","title":"wxListbook.new/2","doc":"","ref":"wxListbook.html#new/2"},{"type":"function","title":"wxListbook.new/3","doc":"Constructs a listbook control.","ref":"wxListbook.html#new/3"},{"type":"function","title":"wxListbook.setImageList/2","doc":"Sets the image list to use.\n\nIt does not take ownership of the image list, you must delete it yourself.\n\nSee: `m:wxImageList`, `assignImageList/2`","ref":"wxListbook.html#setImageList/2"},{"type":"function","title":"wxListbook.setPageImage/3","doc":"Sets the image index for the given page.\n\n`image` is an index into the image list which was set with `setImageList/2`.","ref":"wxListbook.html#setPageImage/3"},{"type":"function","title":"wxListbook.setPageSize/2","doc":"Sets the width and height of the pages.\n\nNote: This method is currently not implemented for wxGTK.","ref":"wxListbook.html#setPageSize/2"},{"type":"function","title":"wxListbook.setPageText/3","doc":"Sets the text for the given page.","ref":"wxListbook.html#setPageText/3"},{"type":"function","title":"wxListbook.setSelection/2","doc":"Sets the selection to the given page, returning the previous selection.\n\nNotice that the call to this function generates the page changing events, use\nthe `changeSelection/2` function if you don't want these events to be generated.\n\nSee: `getSelection/1`","ref":"wxListbook.html#setSelection/2"},{"type":"type","title":"wxListbook.wxListbook/0","doc":"","ref":"wxListbook.html#t:wxListbook/0"},{"type":"module","title":"wxLocale","doc":"Functions for wxLocale class\n\n`m:wxLocale` class encapsulates all language-dependent settings and is a\ngeneralization of the C locale concept.\n\nIn wxWidgets this class manages current locale. It also initializes and\nactivates `wxTranslations` (not implemented in wx) object that manages message\ncatalogs.\n\nFor a list of the supported languages, please see ?wxLanguage enum values. These\nconstants may be used to specify the language in `init/3` and are returned by\n`getSystemLanguage/0`.\n\nSee:\n[Overview i18n](https://docs.wxwidgets.org/3.1/overview_i18n.html#overview_i18n),\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_internat),\n`wxXLocale` (not implemented in wx), `wxTranslations` (not implemented in wx)\n\nwxWidgets docs: [wxLocale](https://docs.wxwidgets.org/3.1/classwx_locale.html)","ref":"wxLocale.html"},{"type":"function","title":"wxLocale.addCatalog/2","doc":"Calls wxTranslations::AddCatalog(const wxString&).","ref":"wxLocale.html#addCatalog/2"},{"type":"function","title":"wxLocale.addCatalog/3","doc":"Calls `wxTranslations::AddCatalog(const wxString&, wxLanguage)` (not implemented\nin wx).","ref":"wxLocale.html#addCatalog/3"},{"type":"function","title":"wxLocale.addCatalog/4","doc":"Calls `wxTranslations::AddCatalog(const wxString&, wxLanguage, const wxString&)`\n(not implemented in wx).","ref":"wxLocale.html#addCatalog/4"},{"type":"function","title":"wxLocale.addCatalogLookupPathPrefix/1","doc":"Calls `wxFileTranslationsLoader::AddCatalogLookupPathPrefix()` (not implemented\nin wx).","ref":"wxLocale.html#addCatalogLookupPathPrefix/1"},{"type":"function","title":"wxLocale.destroy/1","doc":"The destructor, like the constructor, also has global side effects: the\npreviously set locale is restored and so the changes described in `init/3`\ndocumentation are rolled back.","ref":"wxLocale.html#destroy/1"},{"type":"function","title":"wxLocale.getCanonicalName/1","doc":"Returns the canonical form of current locale name.\n\nCanonical form is the one that is used on UNIX systems: it is a two- or\nfive-letter string in xx or xx_YY format, where xx is ISO 639 code of language\nand YY is ISO 3166 code of the country. Examples are \"en\", \"en_GB\", \"en_US\" or\n\"fr_FR\". This form is internally used when looking up message catalogs. Compare\n`getSysName/1`.","ref":"wxLocale.html#getCanonicalName/1"},{"type":"function","title":"wxLocale.getHeaderValue/2","doc":"","ref":"wxLocale.html#getHeaderValue/2"},{"type":"function","title":"wxLocale.getHeaderValue/3","doc":"Calls `wxTranslations::GetHeaderValue()` (not implemented in wx).","ref":"wxLocale.html#getHeaderValue/3"},{"type":"function","title":"wxLocale.getLanguage/1","doc":"Returns the ?wxLanguage constant of current language.\n\nNote that you can call this function only if you used the form of `init/3` that\ntakes ?wxLanguage argument.","ref":"wxLocale.html#getLanguage/1"},{"type":"function","title":"wxLocale.getLanguageName/1","doc":"Returns English name of the given language or empty string if this language is\nunknown.\n\nSee `GetLanguageInfo()` (not implemented in wx) for a remark about special\nmeaning of `wxLANGUAGE_DEFAULT`.","ref":"wxLocale.html#getLanguageName/1"},{"type":"function","title":"wxLocale.getLocale/1","doc":"Returns the locale name as passed to the constructor or `init/3`.\n\nThis is a full, human-readable name, e.g. \"English\" or \"French\".","ref":"wxLocale.html#getLocale/1"},{"type":"function","title":"wxLocale.getName/1","doc":"Returns the current short name for the locale (as given to the constructor or\nthe `init/3` function).","ref":"wxLocale.html#getName/1"},{"type":"function","title":"wxLocale.getString/2","doc":"","ref":"wxLocale.html#getString/2"},{"type":"function","title":"wxLocale.getString/3","doc":"Calls wxGetTranslation(const wxString&, const wxString&).","ref":"wxLocale.html#getString/3"},{"type":"function","title":"wxLocale.getString/4","doc":"","ref":"wxLocale.html#getString/4"},{"type":"function","title":"wxLocale.getString/5","doc":"Calls wxGetTranslation(const wxString&, const wxString&, unsigned, const\nwxString&).","ref":"wxLocale.html#getString/5"},{"type":"function","title":"wxLocale.getSysName/1","doc":"Returns current platform-specific locale name as passed to setlocale().\n\nCompare `getCanonicalName/1`.","ref":"wxLocale.html#getSysName/1"},{"type":"function","title":"wxLocale.getSystemEncoding/0","doc":"Tries to detect the user's default font encoding.\n\nReturns ?wxFontEncoding() value or `wxFONTENCODING_SYSTEM` if it couldn't be\ndetermined.","ref":"wxLocale.html#getSystemEncoding/0"},{"type":"function","title":"wxLocale.getSystemEncodingName/0","doc":"Tries to detect the name of the user's default font encoding.\n\nThis string isn't particularly useful for the application as its form is\nplatform-dependent and so you should probably use `getSystemEncoding/0` instead.\n\nReturns a user-readable string value or an empty string if it couldn't be\ndetermined.","ref":"wxLocale.html#getSystemEncodingName/0"},{"type":"function","title":"wxLocale.getSystemLanguage/0","doc":"Tries to detect the user's default locale setting.\n\nReturns the ?wxLanguage value or `wxLANGUAGE_UNKNOWN` if the language-guessing\nalgorithm failed.\n\nNote: This function works with `locales` and returns the user's default locale.\nThis may be, and usually is, the same as their preferred UI language, but it's\nnot the same thing. Use wxTranslation to obtain `language` information.\n\nSee: `wxTranslations::GetBestTranslation()` (not implemented in wx)","ref":"wxLocale.html#getSystemLanguage/0"},{"type":"function","title":"wxLocale.init/1","doc":"","ref":"wxLocale.html#init/1"},{"type":"function","title":"wxLocale.init/2","doc":"Initializes the `m:wxLocale` instance.\n\nThe call of this function has several global side effects which you should\nunderstand: first of all, the application locale is changed - note that this\nwill affect many of standard C library functions such as printf() or strftime().\nSecond, this `m:wxLocale` object becomes the new current global locale for the\napplication and so all subsequent calls to ?wxGetTranslation() will try to\ntranslate the messages using the message catalogs for this locale.\n\nReturn: true on success or false if the given locale couldn't be set.","ref":"wxLocale.html#init/2"},{"type":"function","title":"wxLocale.init/3","doc":"Deprecated: This form is deprecated, use the other one unless you know what you\nare doing.","ref":"wxLocale.html#init/3"},{"type":"function","title":"wxLocale.isLoaded/2","doc":"Calls `wxTranslations::IsLoaded()` (not implemented in wx).","ref":"wxLocale.html#isLoaded/2"},{"type":"function","title":"wxLocale.isOk/1","doc":"Returns true if the locale could be set successfully.","ref":"wxLocale.html#isOk/1"},{"type":"function","title":"wxLocale.new/0","doc":"This is the default constructor and it does nothing to initialize the object:\n`init/3` must be used to do that.","ref":"wxLocale.html#new/0"},{"type":"function","title":"wxLocale.new/1","doc":"","ref":"wxLocale.html#new/1"},{"type":"function","title":"wxLocale.new/2","doc":"See `init/3` for parameters description.\n\nThe call of this function has several global side effects which you should\nunderstand: first of all, the application locale is changed - note that this\nwill affect many of standard C library functions such as printf() or strftime().\nSecond, this `m:wxLocale` object becomes the new current global locale for the\napplication and so all subsequent calls to ?wxGetTranslation() will try to\ntranslate the messages using the message catalogs for this locale.","ref":"wxLocale.html#new/2"},{"type":"type","title":"wxLocale.wxLocale/0","doc":"","ref":"wxLocale.html#t:wxLocale/0"},{"type":"module","title":"wxLogNull","doc":"Functions for wxLogNull class\n\nThis class allows you to temporarily suspend logging. All calls to the log\nfunctions during the life time of an object of this class are just ignored.\n\nIn particular, it can be used to suppress the log messages given by wxWidgets\nitself but it should be noted that it is rarely the best way to cope with this\nproblem as `all` log messages are suppressed, even if they indicate a completely\ndifferent error than the one the programmer wanted to suppress.\n\nFor instance, the example of the overview:\n\nwould be better written as:\n\nwxWidgets docs:\n[wxLogNull](https://docs.wxwidgets.org/3.1/classwx_log_null.html)","ref":"wxLogNull.html"},{"type":"function","title":"wxLogNull.destroy/1","doc":"Resumes logging.","ref":"wxLogNull.html#destroy/1"},{"type":"function","title":"wxLogNull.new/0","doc":"Suspends logging.","ref":"wxLogNull.html#new/0"},{"type":"type","title":"wxLogNull.wxLogNull/0","doc":"","ref":"wxLogNull.html#t:wxLogNull/0"},{"type":"module","title":"wxMDIChildFrame","doc":"Functions for wxMDIChildFrame class\n\nAn MDI child frame is a frame that can only exist inside a\n`m:wxMDIClientWindow`, which is itself a child of `m:wxMDIParentFrame`.\n\nStyles\n\nThis class supports the following styles:\n\nAll of the standard `m:wxFrame` styles can be used but most of them are ignored\nby TDI-based MDI implementations.\n\nRemark: Although internally an MDI child frame is a child of the MDI client\nwindow, in wxWidgets you create it as a child of `m:wxMDIParentFrame`. In fact,\nyou can usually forget that the client window exists. MDI child frames are\nclipped to the area of the MDI client window, and may be iconized on the client\nwindow. You can associate a menubar with a child frame as usual, although an MDI\nchild doesn't display its menubar under its own title bar. The MDI parent\nframe's menubar will be changed to reflect the currently active child frame. If\nthere are currently no children, the parent frame's own menubar will be\ndisplayed.\n\nSee: `m:wxMDIClientWindow`, `m:wxMDIParentFrame`, `m:wxFrame`\n\nThis class is derived (and can use functions) from: `m:wxFrame`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMDIChildFrame](https://docs.wxwidgets.org/3.1/classwx_m_d_i_child_frame.html)","ref":"wxMDIChildFrame.html"},{"type":"function","title":"wxMDIChildFrame.activate/1","doc":"Activates this MDI child frame.\n\nSee: `maximize/2`, `restore/1`","ref":"wxMDIChildFrame.html#activate/1"},{"type":"function","title":"wxMDIChildFrame.create/4","doc":"","ref":"wxMDIChildFrame.html#create/4"},{"type":"function","title":"wxMDIChildFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxMDIChildFrame.html#create/5"},{"type":"function","title":"wxMDIChildFrame.destroy/1","doc":"Destructor.\n\nDestroys all child windows and menu bar if present.","ref":"wxMDIChildFrame.html#destroy/1"},{"type":"function","title":"wxMDIChildFrame.maximize/1","doc":"","ref":"wxMDIChildFrame.html#maximize/1"},{"type":"function","title":"wxMDIChildFrame.maximize/2","doc":"Maximizes this MDI child frame.\n\nThis function doesn't do anything if `IsAlwaysMaximized()` (not implemented in\nwx) returns true.\n\nSee: `activate/1`, `restore/1`","ref":"wxMDIChildFrame.html#maximize/2"},{"type":"function","title":"wxMDIChildFrame.new/0","doc":"Default constructor.","ref":"wxMDIChildFrame.html#new/0"},{"type":"function","title":"wxMDIChildFrame.new/3","doc":"","ref":"wxMDIChildFrame.html#new/3"},{"type":"function","title":"wxMDIChildFrame.new/4","doc":"Constructor, creating the window.\n\nSee: `create/5`","ref":"wxMDIChildFrame.html#new/4"},{"type":"function","title":"wxMDIChildFrame.restore/1","doc":"Restores this MDI child frame (unmaximizes).\n\nThis function doesn't do anything if `IsAlwaysMaximized()` (not implemented in\nwx) returns true.\n\nSee: `activate/1`, `maximize/2`","ref":"wxMDIChildFrame.html#restore/1"},{"type":"type","title":"wxMDIChildFrame.wxMDIChildFrame/0","doc":"","ref":"wxMDIChildFrame.html#t:wxMDIChildFrame/0"},{"type":"module","title":"wxMDIClientWindow","doc":"Functions for wxMDIClientWindow class\n\nAn MDI client window is a child of `m:wxMDIParentFrame`, and manages zero or\nmore `m:wxMDIChildFrame` objects.\n\nThe client window is the area where MDI child windows exist. It doesn't have to\ncover the whole parent frame; other windows such as toolbars and a help window\nmight coexist with it. There can be scrollbars on a client window, which are\ncontrolled by the parent window style.\n\nThe `m:wxMDIClientWindow` class is usually adequate without further derivation,\nand it is created automatically when the MDI parent frame is created. If the\napplication needs to derive a new class, the function\n`wxMDIParentFrame::OnCreateClient()` (not implemented in wx) must be overridden\nin order to give an opportunity to use a different class of client window.\n\nUnder wxMSW, the client window will automatically have a sunken border style\nwhen the active child is not maximized, and no border style when a child is\nmaximized.\n\nSee: `m:wxMDIChildFrame`, `m:wxMDIParentFrame`, `m:wxFrame`\n\nThis class is derived (and can use functions) from: `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMDIClientWindow](https://docs.wxwidgets.org/3.1/classwx_m_d_i_client_window.html)","ref":"wxMDIClientWindow.html"},{"type":"function","title":"wxMDIClientWindow.createClient/2","doc":"","ref":"wxMDIClientWindow.html#createClient/2"},{"type":"function","title":"wxMDIClientWindow.createClient/3","doc":"Called by `m:wxMDIParentFrame` immediately after creating the client window.\n\nThis function may be overridden in the derived class but the base class version\nmust usually be called first to really create the window.","ref":"wxMDIClientWindow.html#createClient/3"},{"type":"function","title":"wxMDIClientWindow.destroy/1","doc":"Destroys the object.","ref":"wxMDIClientWindow.html#destroy/1"},{"type":"function","title":"wxMDIClientWindow.new/0","doc":"Default constructor.\n\nObjects of this class are only created by `m:wxMDIParentFrame` which uses the\ndefault constructor and calls `createClient/3` immediately afterwards.","ref":"wxMDIClientWindow.html#new/0"},{"type":"type","title":"wxMDIClientWindow.wxMDIClientWindow/0","doc":"","ref":"wxMDIClientWindow.html#t:wxMDIClientWindow/0"},{"type":"module","title":"wxMDIParentFrame","doc":"Functions for wxMDIParentFrame class\n\nAn MDI (Multiple Document Interface) parent frame is a window which can contain\nMDI child frames in its client area which emulates the full desktop.\n\nMDI is a user-interface model in which all the window reside inside the single\nparent window as opposed to being separate from each other. It remains popular\ndespite dire warnings from Microsoft itself (which popularized this model in the\nfirst model) that MDI is obsolete.\n\nAn MDI parent frame always has a `m:wxMDIClientWindow` associated with it, which\nis the parent for MDI child frames. In the simplest case, the client window\ntakes up the entire parent frame area but it is also possible to resize it to be\nsmaller in order to have other windows in the frame, a typical example is using\na sidebar along one of the window edges.\n\nThe appearance of MDI applications differs between different ports. The classic\nMDI model, with child windows which can be independently moved, resized etc, is\nonly available under MSW, which provides native support for it. In Mac ports,\nmultiple top level windows are used for the MDI children too and the MDI parent\nframe itself is invisible, to accommodate the native look and feel requirements.\nIn all the other ports, a tab-based MDI implementation (sometimes called TDI) is\nused and so at most one MDI child is visible at any moment (child frames are\nalways maximized).\n\nAlthough it is possible to have multiple MDI parent frames, a typical MDI\napplication has a single MDI parent frame window inside which multiple MDI child\nframes, i.e. objects of class `m:wxMDIChildFrame`, can be created.\n\nStyles\n\nThis class supports the following styles:\n\nThere are no special styles for this class, all `m:wxFrame` styles apply to it\nin the usual way. The only exception is that wxHSCROLL and wxVSCROLL styles\napply not to the frame itself but to the client window, so that using them\nenables horizontal and vertical scrollbars for this window and not the frame.\n\nSee: `m:wxMDIChildFrame`, `m:wxMDIClientWindow`, `m:wxFrame`, `m:wxDialog`\n\nThis class is derived (and can use functions) from: `m:wxFrame`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMDIParentFrame](https://docs.wxwidgets.org/3.1/classwx_m_d_i_parent_frame.html)","ref":"wxMDIParentFrame.html"},{"type":"function","title":"wxMDIParentFrame.activateNext/1","doc":"Activates the MDI child following the currently active one.\n\nThe MDI children are maintained in an ordered list and this function switches to\nthe next element in this list, wrapping around the end of it if the currently\nactive child is the last one.\n\nSee: `activatePrevious/1`","ref":"wxMDIParentFrame.html#activateNext/1"},{"type":"function","title":"wxMDIParentFrame.activatePrevious/1","doc":"Activates the MDI child preceding the currently active one.\n\nSee: `activateNext/1`","ref":"wxMDIParentFrame.html#activatePrevious/1"},{"type":"function","title":"wxMDIParentFrame.arrangeIcons/1","doc":"Arranges any iconized (minimized) MDI child windows.\n\nThis method is only implemented in MSW MDI implementation and does nothing under\nthe other platforms.\n\nSee: `cascade/1`, `tile/2`","ref":"wxMDIParentFrame.html#arrangeIcons/1"},{"type":"function","title":"wxMDIParentFrame.cascade/1","doc":"Arranges the MDI child windows in a cascade.\n\nThis method is only implemented in MSW MDI implementation and does nothing under\nthe other platforms.\n\nSee: `tile/2`, `arrangeIcons/1`","ref":"wxMDIParentFrame.html#cascade/1"},{"type":"function","title":"wxMDIParentFrame.create/4","doc":"","ref":"wxMDIParentFrame.html#create/4"},{"type":"function","title":"wxMDIParentFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxMDIParentFrame.html#create/5"},{"type":"function","title":"wxMDIParentFrame.destroy/1","doc":"Destructor.\n\nDestroys all child windows and menu bar if present.","ref":"wxMDIParentFrame.html#destroy/1"},{"type":"function","title":"wxMDIParentFrame.getActiveChild/1","doc":"Returns a pointer to the active MDI child, if there is one.\n\nIf there are any children at all this function returns a non-NULL pointer.","ref":"wxMDIParentFrame.html#getActiveChild/1"},{"type":"function","title":"wxMDIParentFrame.getClientWindow/1","doc":"Returns a pointer to the client window.\n\nSee: `OnCreateClient()` (not implemented in wx)","ref":"wxMDIParentFrame.html#getClientWindow/1"},{"type":"function","title":"wxMDIParentFrame.new/0","doc":"Default constructor.\n\nUse `create/5` for the objects created using this constructor.","ref":"wxMDIParentFrame.html#new/0"},{"type":"function","title":"wxMDIParentFrame.new/3","doc":"","ref":"wxMDIParentFrame.html#new/3"},{"type":"function","title":"wxMDIParentFrame.new/4","doc":"Constructor, creating the window.\n\nNotice that if you override virtual `OnCreateClient()` (not implemented in wx)\nmethod you shouldn't be using this constructor but the default constructor and\n`create/5` as otherwise your overridden method is never going to be called\nbecause of the usual C++ virtual call resolution rules.\n\nUnder wxMSW, the client window will automatically have a sunken border style\nwhen the active child is not maximized, and no border style when a child is\nmaximized.\n\nSee: `create/5`, `OnCreateClient()` (not implemented in wx)","ref":"wxMDIParentFrame.html#new/4"},{"type":"function","title":"wxMDIParentFrame.tile/1","doc":"","ref":"wxMDIParentFrame.html#tile/1"},{"type":"function","title":"wxMDIParentFrame.tile/2","doc":"Tiles the MDI child windows either horizontally or vertically depending on\nwhether `orient` is `wxHORIZONTAL` or `wxVERTICAL`.\n\nThis method is only implemented in MSW MDI implementation and does nothing under\nthe other platforms.","ref":"wxMDIParentFrame.html#tile/2"},{"type":"type","title":"wxMDIParentFrame.wxMDIParentFrame/0","doc":"","ref":"wxMDIParentFrame.html#t:wxMDIParentFrame/0"},{"type":"module","title":"wxMask","doc":"Functions for wxMask class\n\nThis class encapsulates a monochrome mask bitmap, where the masked area is black\nand the unmasked area is white.\n\nWhen associated with a bitmap and drawn in a device context, the unmasked area\nof the bitmap will be drawn, and the masked area will not be drawn.\n\nNote: A mask can be associated also with a bitmap with an alpha channel but\ndrawing such bitmaps under wxMSW may be slow so using them should be avoided if\ndrawing performance is an important factor.\n\nSee: `m:wxBitmap`, `wxDC:blit/6`, `m:wxMemoryDC`\n\nwxWidgets docs: [wxMask](https://docs.wxwidgets.org/3.1/classwx_mask.html)","ref":"wxMask.html"},{"type":"function","title":"wxMask.create/2","doc":"Constructs a mask from a monochrome bitmap.","ref":"wxMask.html#create/2"},{"type":"function","title":"wxMask.create/3","doc":"Constructs a mask from a bitmap and a colour that indicates the background.","ref":"wxMask.html#create/3"},{"type":"function","title":"wxMask.destroy/1","doc":"Destroys the `m:wxMask` object and the underlying bitmap data.","ref":"wxMask.html#destroy/1"},{"type":"function","title":"wxMask.new/0","doc":"Default constructor.","ref":"wxMask.html#new/0"},{"type":"function","title":"wxMask.new/1","doc":"Constructs a mask from a monochrome bitmap.","ref":"wxMask.html#new/1"},{"type":"function","title":"wxMask.new/2","doc":"Constructs a mask from a bitmap and a colour that indicates the background.","ref":"wxMask.html#new/2"},{"type":"type","title":"wxMask.wxMask/0","doc":"","ref":"wxMask.html#t:wxMask/0"},{"type":"module","title":"wxMaximizeEvent","doc":"Functions for wxMaximizeEvent class\n\nAn event being sent when a top level window is maximized. Notice that it is not\nsent when the window is restored to its original size after it had been\nmaximized, only a normal `m:wxSizeEvent` is generated in this case.\n\nCurrently this event is only generated in wxMSW, wxGTK and wxOSX/Cocoa ports so\nportable programs should only rely on receiving `wxEVT_SIZE` and not necessarily\nthis event when the window is maximized.\n\nSee:\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxTopLevelWindow:maximize/2`, `wxTopLevelWindow:isMaximized/1`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxMaximizeEvent](https://docs.wxwidgets.org/3.1/classwx_maximize_event.html)","ref":"wxMaximizeEvent.html"},{"type":"module","title":"Events - wxMaximizeEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxMaximizeEventType`](`t:wxMaximizeEventType/0`) to subscribe to events of\nthis type.","ref":"wxMaximizeEvent.html#module-events"},{"type":"type","title":"wxMaximizeEvent.wxMaximize/0","doc":"","ref":"wxMaximizeEvent.html#t:wxMaximize/0"},{"type":"type","title":"wxMaximizeEvent.wxMaximizeEvent/0","doc":"","ref":"wxMaximizeEvent.html#t:wxMaximizeEvent/0"},{"type":"type","title":"wxMaximizeEvent.wxMaximizeEventType/0","doc":"","ref":"wxMaximizeEvent.html#t:wxMaximizeEventType/0"},{"type":"module","title":"wxMemoryDC","doc":"Functions for wxMemoryDC class\n\nA memory device context provides a means to draw graphics onto a bitmap. When\ndrawing in to a mono-bitmap, using `wxWHITE`, `wxWHITE_PEN` and `wxWHITE_BRUSH`\nwill draw the background colour (i.e. 0) whereas all other colours will draw the\nforeground colour (i.e. 1).\n\nA bitmap must be selected into the new memory DC before it may be used for\nanything. Typical usage is as follows:\n\nNote that the memory DC must be deleted (or the bitmap selected out of it)\nbefore a bitmap can be reselected into another memory DC.\n\nAnd, before performing any other operations on the bitmap data, the bitmap must\nbe selected out of the memory DC:\n\nThis happens automatically when `m:wxMemoryDC` object goes out of scope.\n\nSee: `m:wxBitmap`, `m:wxDC`\n\nThis class is derived (and can use functions) from: `m:wxDC`\n\nwxWidgets docs:\n[wxMemoryDC](https://docs.wxwidgets.org/3.1/classwx_memory_d_c.html)","ref":"wxMemoryDC.html"},{"type":"function","title":"wxMemoryDC.destroy/1","doc":"Destroys the object.","ref":"wxMemoryDC.html#destroy/1"},{"type":"function","title":"wxMemoryDC.new/0","doc":"Constructs a new memory device context.\n\nUse the `wxDC:isOk/1` member to test whether the constructor was successful in\ncreating a usable device context. Don't forget to select a bitmap into the DC\nbefore drawing on it.","ref":"wxMemoryDC.html#new/0"},{"type":"function","title":"wxMemoryDC.new/1","doc":"Constructs a new memory device context having the same characteristics as the\ngiven existing device context.\n\nThis constructor creates a memory device context `compatible` with `dc` in\nwxMSW, the argument is ignored in the other ports. If `dc` is NULL, a device\ncontext compatible with the screen is created, just as with the default\nconstructor.","ref":"wxMemoryDC.html#new/1"},{"type":"function","title":"wxMemoryDC.selectObject/2","doc":"Works exactly like `selectObjectAsSource/2` but this is the function you should\nuse when you select a bitmap because you want to modify it, e.g.\n\ndrawing on this DC.\n\nUsing `selectObjectAsSource/2` when modifying the bitmap may incur some problems\nrelated to `m:wxBitmap` being a reference counted object (see\noverview_refcount).\n\nBefore using the updated bitmap data, make sure to select it out of context\nfirst either by selecting ?wxNullBitmap into the device context or destroying\nthe device context entirely.\n\nIf the bitmap is already selected in this device context, nothing is done. If it\nis selected in another context, the function asserts and drawing on the bitmap\nwon't work correctly.\n\nSee: `wxDC:drawBitmap/4`","ref":"wxMemoryDC.html#selectObject/2"},{"type":"function","title":"wxMemoryDC.selectObjectAsSource/2","doc":"Selects the given bitmap into the device context, to use as the memory bitmap.\n\nSelecting the bitmap into a memory DC allows you to draw into the DC (and\ntherefore the bitmap) and also to use `wxDC:blit/6` to copy the bitmap to a\nwindow. For this purpose, you may find `wxDC:drawIcon/3` easier to use instead.\n\nIf the argument is ?wxNullBitmap (or some other uninitialised `m:wxBitmap`) the\ncurrent bitmap is selected out of the device context, and the original bitmap\nrestored, allowing the current bitmap to be destroyed safely.","ref":"wxMemoryDC.html#selectObjectAsSource/2"},{"type":"type","title":"wxMemoryDC.wxMemoryDC/0","doc":"","ref":"wxMemoryDC.html#t:wxMemoryDC/0"},{"type":"module","title":"wxMenu","doc":"Functions for wxMenu class\n\nA menu is a popup (or pull down) list of items, one of which may be selected\nbefore the menu goes away (clicking elsewhere dismisses the menu). Menus may be\nused to construct either menu bars or popup menus.\n\nA menu item has an integer ID associated with it which can be used to identify\nthe selection, or to change the menu item in some way. A menu item with a\nspecial identifier `wxID_SEPARATOR` is a separator item and doesn't have an\nassociated command but just makes a separator line appear in the menu.\n\nNote: Please note that `wxID_ABOUT` and `wxID_EXIT` are predefined by wxWidgets\nand have a special meaning since entries using these IDs will be taken out of\nthe normal menus under macOS and will be inserted into the system menu\n(following the appropriate macOS interface guideline).\n\nMenu items may be either `normal` items, `check` items or `radio` items. Normal\nitems don't have any special properties while the check items have a boolean\nflag associated to them and they show a checkmark in the menu when the flag is\nset. wxWidgets automatically toggles the flag value when the item is clicked and\nits value may be retrieved using either `isChecked/2` method of `m:wxMenu` or\n`m:wxMenuBar` itself or by using wxEvent::IsChecked when you get the menu\nnotification for the item in question.\n\nThe radio items are similar to the check items except that all the other items\nin the same radio group are unchecked when a radio item is checked. The radio\ngroup is formed by a contiguous range of radio items, i.e. it starts at the\nfirst item of this kind and ends with the first item of a different kind (or the\nend of the menu). Notice that because the radio groups are defined in terms of\nthe item positions inserting or removing the items in the menu containing the\nradio items risks to not work correctly.\n\nAllocation strategy\n\nAll menus must be created on the `heap` because all menus attached to a menubar\nor to another menu will be deleted by their parent when it is deleted. The only\nexception to this rule are the popup menus (i.e. menus used with\n`wxWindow:popupMenu/4`) as wxWidgets does not destroy them to allow reusing the\nsame menu more than once. But the exception applies only to the menus themselves\nand not to any submenus of popup menus which are still destroyed by wxWidgets as\nusual and so must be heap-allocated.\n\nAs the frame menubar is deleted by the frame itself, it means that normally all\nmenus used are deleted automatically.\n\nEvent handling\n\nEvent handlers for the commands generated by the menu items can be connected\ndirectly to the menu object itself using `wxEvtHandler::Bind()` (not implemented\nin wx). If this menu is a submenu of another one, the events from its items can\nalso be processed in the parent menu and so on, recursively.\n\nIf the menu is part of a menu bar, then events can also be handled in\n`m:wxMenuBar` object.\n\nFinally, menu events can also be handled in the associated window, which is\neither the `m:wxFrame` associated with the menu bar this menu belongs to or the\nwindow for which `wxWindow:popupMenu/4` was called for the popup menus.\n\nSee overview_events_bind for how to bind event handlers to the various objects.\n\nSee: `m:wxMenuBar`, `wxWindow:popupMenu/4`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxFileHistory` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxEvtHandler`\n\nwxWidgets docs: [wxMenu](https://docs.wxwidgets.org/3.1/classwx_menu.html)","ref":"wxMenu.html"},{"type":"function","title":"wxMenu.append/2","doc":"Adds a menu item object.\n\nThis is the most generic variant of `append/5` method because it may be used for\nboth items (including separators) and submenus and because you can also specify\nvarious extra properties of a menu item this way, such as bitmaps and fonts.\n\nRemark: See the remarks for the other `append/5` overloads.\n\nSee: `appendSeparator/1`, `appendCheckItem/4`, `appendRadioItem/4`,\n`AppendSubMenu()` (not implemented in wx), `insert/6`, `setLabel/3`,\n`getHelpString/2`, `setHelpString/3`, `m:wxMenuItem`","ref":"wxMenu.html#append/2"},{"type":"function","title":"wxMenu.append/3","doc":"","ref":"wxMenu.html#append/3"},{"type":"function","title":"wxMenu.append/4","doc":"Adds a menu item.\n\nExample:\n\nor even better for stock menu items (see `wxMenuItem:new/1`):\n\nRemark: This command can be used after the menu has been shown, as well as on\ninitial creation of a menu or menubar.\n\nSee: `appendSeparator/1`, `appendCheckItem/4`, `appendRadioItem/4`,\n`AppendSubMenu()` (not implemented in wx), `insert/6`, `setLabel/3`,\n`getHelpString/2`, `setHelpString/3`, `m:wxMenuItem`","ref":"wxMenu.html#append/4"},{"type":"function","title":"wxMenu.append/5","doc":"Adds a submenu.\n\nDeprecated: This function is deprecated, use `AppendSubMenu()` (not implemented\nin wx) instead.\n\nSee: `appendSeparator/1`, `appendCheckItem/4`, `appendRadioItem/4`,\n`AppendSubMenu()` (not implemented in wx), `insert/6`, `setLabel/3`,\n`getHelpString/2`, `setHelpString/3`, `m:wxMenuItem`","ref":"wxMenu.html#append/5"},{"type":"function","title":"wxMenu.appendCheckItem/3","doc":"","ref":"wxMenu.html#appendCheckItem/3"},{"type":"function","title":"wxMenu.appendCheckItem/4","doc":"Adds a checkable item to the end of the menu.\n\nSee: `append/5`, `insertCheckItem/5`","ref":"wxMenu.html#appendCheckItem/4"},{"type":"function","title":"wxMenu.appendRadioItem/3","doc":"","ref":"wxMenu.html#appendRadioItem/3"},{"type":"function","title":"wxMenu.appendRadioItem/4","doc":"Adds a radio item to the end of the menu.\n\nAll consequent radio items form a group and when an item in the group is\nchecked, all the others are automatically unchecked.\n\nNote: Radio items are not supported under wxMotif.\n\nSee: `append/5`, `insertRadioItem/5`","ref":"wxMenu.html#appendRadioItem/4"},{"type":"function","title":"wxMenu.appendSeparator/1","doc":"Adds a separator to the end of the menu.\n\nSee: `append/5`, `insertSeparator/2`","ref":"wxMenu.html#appendSeparator/1"},{"type":"function","title":"wxMenu.break/1","doc":"Inserts a break in a menu, causing the next appended item to appear in a new\ncolumn.\n\nThis function only actually inserts a break in wxMSW and does nothing under the\nother platforms.","ref":"wxMenu.html#break/1"},{"type":"function","title":"wxMenu.check/3","doc":"Checks or unchecks the menu item.\n\nSee: `isChecked/2`","ref":"wxMenu.html#check/3"},{"type":"function","title":"wxMenu.Destroy/2","doc":"Deletes the menu item from the menu.\n\nIf the item is a submenu, it will be deleted. Use `remove/2` if you want to keep\nthe submenu (for example, to reuse it later).\n\nSee: `findItem/2`, `delete/2`, `remove/2`","ref":"wxMenu.html#Destroy/2"},{"type":"function","title":"wxMenu.delete/2","doc":"Deletes the menu item from the menu.\n\nIf the item is a submenu, it will `not` be deleted. Use `'Destroy'/2` if you\nwant to delete a submenu.\n\nSee: `findItem/2`, `'Destroy'/2`, `remove/2`","ref":"wxMenu.html#delete/2"},{"type":"function","title":"wxMenu.destroy/1","doc":"Destructor, destroying the menu.\n\nNote: Under Motif, a popup menu must have a valid parent (the window it was last\npopped up on) when being destroyed. Therefore, make sure you delete or re-use\nthe popup menu `before` destroying the parent window. Re-use in this context\nmeans popping up the menu on a different window from last time, which causes an\nimplicit destruction and recreation of internal data structures.","ref":"wxMenu.html#destroy/1"},{"type":"function","title":"wxMenu.enable/3","doc":"Enables or disables (greys out) a menu item.\n\nSee: `isEnabled/2`","ref":"wxMenu.html#enable/3"},{"type":"function","title":"wxMenu.findItem/2","doc":"Finds the menu id for a menu item string.\n\nReturn: Menu item identifier, or wxNOT_FOUND if none is found.\n\nRemark: Any special menu codes are stripped out of source and target strings\nbefore matching.","ref":"wxMenu.html#findItem/2"},{"type":"function","title":"wxMenu.findItemByPosition/2","doc":"Returns the `m:wxMenuItem` given a position in the menu.","ref":"wxMenu.html#findItemByPosition/2"},{"type":"function","title":"wxMenu.getHelpString/2","doc":"Returns the help string associated with a menu item.\n\nReturn: The help string, or the empty string if there is no help string or the\nitem was not found.\n\nSee: `setHelpString/3`, `append/5`","ref":"wxMenu.html#getHelpString/2"},{"type":"function","title":"wxMenu.getLabel/2","doc":"Returns a menu item label.\n\nReturn: The item label, or the empty string if the item was not found.\n\nSee: `GetLabelText()` (not implemented in wx), `setLabel/3`","ref":"wxMenu.html#getLabel/2"},{"type":"function","title":"wxMenu.getMenuItemCount/1","doc":"Returns the number of items in the menu.","ref":"wxMenu.html#getMenuItemCount/1"},{"type":"function","title":"wxMenu.getMenuItems/1","doc":"","ref":"wxMenu.html#getMenuItems/1"},{"type":"function","title":"wxMenu.getTitle/1","doc":"Returns the title of the menu.\n\nSee: `setTitle/2`","ref":"wxMenu.html#getTitle/1"},{"type":"function","title":"wxMenu.insert/3","doc":"Inserts the given `item` before the position `pos`.\n\nInserting the item at position `getMenuItemCount/1` is the same as appending it.\n\nSee: `append/5`, `prepend/5`","ref":"wxMenu.html#insert/3"},{"type":"function","title":"wxMenu.insert/4","doc":"Inserts the given `item` before the position `pos`.\n\nInserting the item at position `getMenuItemCount/1` is the same as appending it.\n\nSee: `append/5`, `prepend/5`","ref":"wxMenu.html#insert/4"},{"type":"function","title":"wxMenu.insert/5","doc":"","ref":"wxMenu.html#insert/5"},{"type":"function","title":"wxMenu.insert/6","doc":"Inserts the given `submenu` before the position `pos`.\n\n`text` is the text shown in the menu for it and `help` is the help string shown\nin the status bar when the submenu item is selected.\n\nSee: `AppendSubMenu()` (not implemented in wx), `prepend/5`","ref":"wxMenu.html#insert/6"},{"type":"function","title":"wxMenu.insertCheckItem/4","doc":"","ref":"wxMenu.html#insertCheckItem/4"},{"type":"function","title":"wxMenu.insertCheckItem/5","doc":"Inserts a checkable item at the given position.\n\nSee: `insert/6`, `appendCheckItem/4`","ref":"wxMenu.html#insertCheckItem/5"},{"type":"function","title":"wxMenu.insertRadioItem/4","doc":"","ref":"wxMenu.html#insertRadioItem/4"},{"type":"function","title":"wxMenu.insertRadioItem/5","doc":"Inserts a radio item at the given position.\n\nSee: `insert/6`, `appendRadioItem/4`","ref":"wxMenu.html#insertRadioItem/5"},{"type":"function","title":"wxMenu.insertSeparator/2","doc":"Inserts a separator at the given position.\n\nSee: `insert/6`, `appendSeparator/1`","ref":"wxMenu.html#insertSeparator/2"},{"type":"function","title":"wxMenu.isChecked/2","doc":"Determines whether a menu item is checked.\n\nReturn: true if the menu item is checked, false otherwise.\n\nSee: `check/3`","ref":"wxMenu.html#isChecked/2"},{"type":"function","title":"wxMenu.isEnabled/2","doc":"Determines whether a menu item is enabled.\n\nReturn: true if the menu item is enabled, false otherwise.\n\nSee: `enable/3`","ref":"wxMenu.html#isEnabled/2"},{"type":"function","title":"wxMenu.new/0","doc":"Constructs a `m:wxMenu` object.","ref":"wxMenu.html#new/0"},{"type":"function","title":"wxMenu.new/1","doc":"Constructs a `m:wxMenu` object.","ref":"wxMenu.html#new/1"},{"type":"function","title":"wxMenu.new/2","doc":"Constructs a `m:wxMenu` object with a title.","ref":"wxMenu.html#new/2"},{"type":"function","title":"wxMenu.prepend/2","doc":"Inserts the given `item` at position 0, i.e. before all the other existing\nitems.\n\nSee: `append/5`, `insert/6`","ref":"wxMenu.html#prepend/2"},{"type":"function","title":"wxMenu.prepend/3","doc":"Inserts the given `item` at position 0, i.e. before all the other existing\nitems.\n\nSee: `append/5`, `insert/6`","ref":"wxMenu.html#prepend/3"},{"type":"function","title":"wxMenu.prepend/4","doc":"","ref":"wxMenu.html#prepend/4"},{"type":"function","title":"wxMenu.prepend/5","doc":"Inserts the given `submenu` at position 0.\n\nSee: `AppendSubMenu()` (not implemented in wx), `insert/6`","ref":"wxMenu.html#prepend/5"},{"type":"function","title":"wxMenu.prependCheckItem/3","doc":"","ref":"wxMenu.html#prependCheckItem/3"},{"type":"function","title":"wxMenu.prependCheckItem/4","doc":"Inserts a checkable item at position 0.\n\nSee: `prepend/5`, `appendCheckItem/4`","ref":"wxMenu.html#prependCheckItem/4"},{"type":"function","title":"wxMenu.prependRadioItem/3","doc":"","ref":"wxMenu.html#prependRadioItem/3"},{"type":"function","title":"wxMenu.prependRadioItem/4","doc":"Inserts a radio item at position 0.\n\nSee: `prepend/5`, `appendRadioItem/4`","ref":"wxMenu.html#prependRadioItem/4"},{"type":"function","title":"wxMenu.prependSeparator/1","doc":"Inserts a separator at position 0.\n\nSee: `prepend/5`, `appendSeparator/1`","ref":"wxMenu.html#prependSeparator/1"},{"type":"function","title":"wxMenu.remove/2","doc":"Removes the menu item from the menu but doesn't delete the associated C++\nobject.\n\nThis allows you to reuse the same item later by adding it back to the menu\n(especially useful with submenus).\n\nReturn: A pointer to the item which was detached from the menu.","ref":"wxMenu.html#remove/2"},{"type":"function","title":"wxMenu.setHelpString/3","doc":"Sets an item's help string.\n\nSee: `getHelpString/2`","ref":"wxMenu.html#setHelpString/3"},{"type":"function","title":"wxMenu.setLabel/3","doc":"Sets the label of a menu item.\n\nSee: `append/5`, `getLabel/2`","ref":"wxMenu.html#setLabel/3"},{"type":"function","title":"wxMenu.setTitle/2","doc":"Sets the title of the menu.\n\nRemark: Notice that you can only call this method directly for the popup menus,\nto change the title of a menu that is part of a menu bar you need to use\n`wxMenuBar:setLabelTop/3`.\n\nSee: `getTitle/1`","ref":"wxMenu.html#setTitle/2"},{"type":"type","title":"wxMenu.wxMenu/0","doc":"","ref":"wxMenu.html#t:wxMenu/0"},{"type":"module","title":"wxMenuBar","doc":"Functions for wxMenuBar class\n\nA menu bar is a series of menus accessible from the top of a frame.\n\nRemark: To respond to a menu selection, provide a handler for EVT_MENU, in the\nframe that contains the menu bar.\n\nIf you have a toolbar which uses the same identifiers as your EVT_MENU entries,\nevents from the toolbar will also be processed by your EVT_MENU event handlers.\n\nTip: under Windows, if you discover that menu shortcuts (for example, Alt-F to\nshow the file menu) are not working, check any EVT_CHAR events you are handling\nin child windows. If you are not calling event.Skip() for events that you don't\nprocess in these event handlers, menu shortcuts may cease to work.\n\nSee: `m:wxMenu`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxWindow`\n`m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMenuBar](https://docs.wxwidgets.org/3.1/classwx_menu_bar.html)","ref":"wxMenuBar.html"},{"type":"function","title":"wxMenuBar.append/3","doc":"Adds the item to the end of the menu bar.\n\nReturn: true on success, false if an error occurred.\n\nSee: `insert/4`","ref":"wxMenuBar.html#append/3"},{"type":"function","title":"wxMenuBar.check/3","doc":"Checks or unchecks a menu item.\n\nRemark: Only use this when the menu bar has been associated with a frame;\notherwise, use the `m:wxMenu` equivalent call.","ref":"wxMenuBar.html#check/3"},{"type":"function","title":"wxMenuBar.destroy/1","doc":"Destructor, destroying the menu bar and removing it from the parent frame (if\nany).","ref":"wxMenuBar.html#destroy/1"},{"type":"function","title":"wxMenuBar.enable/3","doc":"Enables or disables (greys out) a menu item.\n\nRemark: Only use this when the menu bar has been associated with a frame;\notherwise, use the `m:wxMenu` equivalent call.","ref":"wxMenuBar.html#enable/3"},{"type":"function","title":"wxMenuBar.enableTop/3","doc":"Enables or disables a whole menu.\n\nRemark: Only use this when the menu bar has been associated with a frame.","ref":"wxMenuBar.html#enableTop/3"},{"type":"function","title":"wxMenuBar.findItem/2","doc":"Finds the menu item object associated with the given menu item identifier.\n\nReturn: The found menu item object, or NULL if one was not found.","ref":"wxMenuBar.html#findItem/2"},{"type":"function","title":"wxMenuBar.findMenu/2","doc":"Returns the index of the menu with the given `title` or `wxNOT_FOUND` if no such\nmenu exists in this menubar.\n\nThe `title` parameter may specify either the menu title (with accelerator\ncharacters, i.e. `\"&File\"`) or just the menu label (`\"File\"`) indifferently.","ref":"wxMenuBar.html#findMenu/2"},{"type":"function","title":"wxMenuBar.findMenuItem/3","doc":"Finds the menu item id for a menu name/menu item string pair.\n\nReturn: The menu item identifier, or wxNOT_FOUND if none was found.\n\nRemark: Any special menu codes are stripped out of source and target strings\nbefore matching.","ref":"wxMenuBar.html#findMenuItem/3"},{"type":"function","title":"wxMenuBar.getAutoWindowMenu/0","doc":"","ref":"wxMenuBar.html#getAutoWindowMenu/0"},{"type":"function","title":"wxMenuBar.getHelpString/2","doc":"Gets the help string associated with the menu item identifier.\n\nReturn: The help string, or the empty string if there was no help string or the\nmenu item was not found.\n\nSee: `setHelpString/3`","ref":"wxMenuBar.html#getHelpString/2"},{"type":"function","title":"wxMenuBar.getLabel/2","doc":"Gets the label associated with a menu item.\n\nReturn: The menu item label, or the empty string if the item was not found.\n\nRemark: Use only after the menubar has been associated with a frame.","ref":"wxMenuBar.html#getLabel/2"},{"type":"function","title":"wxMenuBar.getLabelTop/2","doc":"See: `getMenuLabel/2`.","ref":"wxMenuBar.html#getLabelTop/2"},{"type":"function","title":"wxMenuBar.getMenu/2","doc":"Returns the menu at `menuIndex` (zero-based).","ref":"wxMenuBar.html#getMenu/2"},{"type":"function","title":"wxMenuBar.getMenuCount/1","doc":"Returns the number of menus in this menubar.","ref":"wxMenuBar.html#getMenuCount/1"},{"type":"function","title":"wxMenuBar.getMenuLabel/2","doc":"Returns the label of a top-level menu.\n\nNote that the returned string includes the accelerator characters that have been\nspecified in the menu title string during its construction.\n\nReturn: The menu label, or the empty string if the menu was not found.\n\nRemark: Use only after the menubar has been associated with a frame.\n\nSee: `getMenuLabelText/2`, `setMenuLabel/3`","ref":"wxMenuBar.html#getMenuLabel/2"},{"type":"function","title":"wxMenuBar.getMenuLabelText/2","doc":"Returns the label of a top-level menu.\n\nNote that the returned string does not include any accelerator characters that\nmay have been specified in the menu title string during its construction.\n\nReturn: The menu label, or the empty string if the menu was not found.\n\nRemark: Use only after the menubar has been associated with a frame.\n\nSee: `getMenuLabel/2`, `setMenuLabel/3`","ref":"wxMenuBar.html#getMenuLabelText/2"},{"type":"function","title":"wxMenuBar.insert/4","doc":"Inserts the menu at the given position into the menu bar.\n\nInserting menu at position 0 will insert it in the very beginning of it,\ninserting at position `getMenuCount/1` is the same as calling `append/3`.\n\nReturn: true on success, false if an error occurred.\n\nSee: `append/3`","ref":"wxMenuBar.html#insert/4"},{"type":"function","title":"wxMenuBar.isChecked/2","doc":"Determines whether an item is checked.\n\nReturn: true if the item was found and is checked, false otherwise.","ref":"wxMenuBar.html#isChecked/2"},{"type":"function","title":"wxMenuBar.isEnabled/2","doc":"Determines whether an item is enabled.\n\nReturn: true if the item was found and is enabled, false otherwise.","ref":"wxMenuBar.html#isEnabled/2"},{"type":"function","title":"wxMenuBar.macGetCommonMenuBar/0","doc":"Enables you to get the global menubar on Mac, that is, the menubar displayed\nwhen the app is running without any frames open.\n\nReturn: The global menubar.\n\nRemark: Only exists on Mac, other platforms do not have this method.\n\nOnly for:wxosx","ref":"wxMenuBar.html#macGetCommonMenuBar/0"},{"type":"function","title":"wxMenuBar.macSetCommonMenuBar/1","doc":"Enables you to set the global menubar on Mac, that is, the menubar displayed\nwhen the app is running without any frames open.\n\nRemark: Only exists on Mac, other platforms do not have this method.\n\nOnly for:wxosx","ref":"wxMenuBar.html#macSetCommonMenuBar/1"},{"type":"function","title":"wxMenuBar.new/0","doc":"Construct an empty menu bar.","ref":"wxMenuBar.html#new/0"},{"type":"function","title":"wxMenuBar.new/1","doc":"","ref":"wxMenuBar.html#new/1"},{"type":"function","title":"wxMenuBar.oSXGetAppleMenu/1","doc":"Returns the Apple menu.\n\nThis is the leftmost menu with application's name as its title. You shouldn't\nremove any items from it, but it is safe to insert extra menu items or submenus\ninto it.\n\nOnly for:wxosx\n\nSince: 3.0.1","ref":"wxMenuBar.html#oSXGetAppleMenu/1"},{"type":"function","title":"wxMenuBar.remove/2","doc":"Removes the menu from the menu bar and returns the menu object - the caller is\nresponsible for deleting it.\n\nThis function may be used together with `insert/4` to change the menubar\ndynamically.\n\nSee: `replace/4`","ref":"wxMenuBar.html#remove/2"},{"type":"function","title":"wxMenuBar.replace/4","doc":"Replaces the menu at the given position with another one.\n\nReturn: The menu which was previously at position pos. The caller is responsible\nfor deleting it.\n\nSee: `insert/4`, `remove/2`","ref":"wxMenuBar.html#replace/4"},{"type":"function","title":"wxMenuBar.setAutoWindowMenu/1","doc":"","ref":"wxMenuBar.html#setAutoWindowMenu/1"},{"type":"function","title":"wxMenuBar.setHelpString/3","doc":"Sets the help string associated with a menu item.\n\nSee: `getHelpString/2`","ref":"wxMenuBar.html#setHelpString/3"},{"type":"function","title":"wxMenuBar.setLabel/3","doc":"Sets the label of a menu item.\n\nRemark: Use only after the menubar has been associated with a frame.\n\nSee: `getLabel/2`","ref":"wxMenuBar.html#setLabel/3"},{"type":"function","title":"wxMenuBar.setLabelTop/3","doc":"See: `setMenuLabel/3`.","ref":"wxMenuBar.html#setLabelTop/3"},{"type":"function","title":"wxMenuBar.setMenuLabel/3","doc":"Sets the label of a top-level menu.\n\nRemark: Use only after the menubar has been associated with a frame.","ref":"wxMenuBar.html#setMenuLabel/3"},{"type":"type","title":"wxMenuBar.wxMenuBar/0","doc":"","ref":"wxMenuBar.html#t:wxMenuBar/0"},{"type":"module","title":"wxMenuEvent","doc":"Functions for wxMenuEvent class\n\nThis class is used for a variety of menu-related events. Note that these do not\ninclude menu command events, which are handled using `m:wxCommandEvent` objects.\n\nEvents of this class are generated by both menus that are part of a\n`m:wxMenuBar`, attached to `m:wxFrame`, and popup menus shown by\n`wxWindow:popupMenu/4`. They are sent to the following objects until one of them\nhandles the event:\n`-# The menu object itself, as returned by GetMenu(), if any. -# The wxMenuBar to which this menu is attached, if any. -# The window associated with the menu, e.g. the one calling PopupMenu() for the popup menus. -# The top level parent of that window if it's different from the window itself.`\n\nThis is similar to command events generated by the menu items, but, unlike them,\n`m:wxMenuEvent` are only sent to the window itself and its top level parent but\nnot any intermediate windows in the hierarchy.\n\nThe default handler for `wxEVT_MENU_HIGHLIGHT` in `m:wxFrame` displays help text\nin the status bar, see `wxFrame:setStatusBarPane/2`.\n\nSee: `m:wxCommandEvent`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxMenuEvent](https://docs.wxwidgets.org/3.1/classwx_menu_event.html)","ref":"wxMenuEvent.html"},{"type":"module","title":"Events - wxMenuEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxMenuEventType`](`t:wxMenuEventType/0`) to\nsubscribe to events of this type.","ref":"wxMenuEvent.html#module-events"},{"type":"function","title":"wxMenuEvent.getMenu/1","doc":"Returns the menu which is being opened or closed, or the menu containing the\nhighlighted item.\n\nNote that the returned value can be NULL if the menu being opened doesn't have a\ncorresponding `m:wxMenu`, e.g. this happens when opening the system menu in\nwxMSW port.\n\nRemark: Since 3.1.3 this function can be used with `OPEN`, `CLOSE` and\n`HIGHLIGHT` events. Before 3.1.3, this method can only be used with the `OPEN`\nand `CLOSE` events.","ref":"wxMenuEvent.html#getMenu/1"},{"type":"function","title":"wxMenuEvent.getMenuId/1","doc":"Returns the menu identifier associated with the event.\n\nThis method should be only used with the `HIGHLIGHT` events.","ref":"wxMenuEvent.html#getMenuId/1"},{"type":"function","title":"wxMenuEvent.isPopup/1","doc":"Returns true if the menu which is being opened or closed is a popup menu, false\nif it is a normal one.\n\nThis method should only be used with the `OPEN` and `CLOSE` events.","ref":"wxMenuEvent.html#isPopup/1"},{"type":"type","title":"wxMenuEvent.wxMenu/0","doc":"","ref":"wxMenuEvent.html#t:wxMenu/0"},{"type":"type","title":"wxMenuEvent.wxMenuEvent/0","doc":"","ref":"wxMenuEvent.html#t:wxMenuEvent/0"},{"type":"type","title":"wxMenuEvent.wxMenuEventType/0","doc":"","ref":"wxMenuEvent.html#t:wxMenuEventType/0"},{"type":"module","title":"wxMenuItem","doc":"Functions for wxMenuItem class\n\nA menu item represents an item in a menu.\n\nNote that you usually don't have to deal with it directly as `m:wxMenu` methods\nusually construct an object of this class for you.\n\nAlso please note that the methods related to fonts and bitmaps are currently\nonly implemented for Windows, Mac and GTK+.\n\nSee: `m:wxMenuBar`, `m:wxMenu`\n\nwxWidgets docs:\n[wxMenuItem](https://docs.wxwidgets.org/3.1/classwx_menu_item.html)","ref":"wxMenuItem.html"},{"type":"module","title":"Events - wxMenuItem","doc":"Event types emitted from this class: [`menu_open`](`m:wxMenuEvent`),\n[`menu_close`](`m:wxMenuEvent`), [`menu_highlight`](`m:wxMenuEvent`)","ref":"wxMenuItem.html#module-events"},{"type":"function","title":"wxMenuItem.check/1","doc":"","ref":"wxMenuItem.html#check/1"},{"type":"function","title":"wxMenuItem.check/2","doc":"Checks or unchecks the menu item.\n\nNote that this only works when the item is already appended to a menu.","ref":"wxMenuItem.html#check/2"},{"type":"function","title":"wxMenuItem.destroy/1","doc":"Destructor.","ref":"wxMenuItem.html#destroy/1"},{"type":"function","title":"wxMenuItem.enable/1","doc":"","ref":"wxMenuItem.html#enable/1"},{"type":"function","title":"wxMenuItem.enable/2","doc":"Enables or disables the menu item.","ref":"wxMenuItem.html#enable/2"},{"type":"function","title":"wxMenuItem.getBitmap/1","doc":"Returns the checked or unchecked bitmap.\n\nOnly for:wxmsw","ref":"wxMenuItem.html#getBitmap/1"},{"type":"function","title":"wxMenuItem.getHelp/1","doc":"Returns the help string associated with the menu item.","ref":"wxMenuItem.html#getHelp/1"},{"type":"function","title":"wxMenuItem.getId/1","doc":"Returns the menu item identifier.","ref":"wxMenuItem.html#getId/1"},{"type":"function","title":"wxMenuItem.getItemLabel/1","doc":"Returns the text associated with the menu item including any accelerator\ncharacters that were passed to the constructor or `setItemLabel/2`.\n\nSee: `getItemLabelText/1`, `getLabelText/1`","ref":"wxMenuItem.html#getItemLabel/1"},{"type":"function","title":"wxMenuItem.getItemLabelText/1","doc":"Returns the text associated with the menu item, without any accelerator\ncharacters.\n\nSee: `getItemLabel/1`, `getLabelText/1`","ref":"wxMenuItem.html#getItemLabelText/1"},{"type":"function","title":"wxMenuItem.getKind/1","doc":"Returns the item kind, one of `wxITEM_SEPARATOR`, `wxITEM_NORMAL`,\n`wxITEM_CHECK` or `wxITEM_RADIO`.","ref":"wxMenuItem.html#getKind/1"},{"type":"function","title":"wxMenuItem.getLabel/1","doc":"See: `getItemLabelText/1`.","ref":"wxMenuItem.html#getLabel/1"},{"type":"function","title":"wxMenuItem.getLabelFromText/1","doc":"See: `getLabelText/1`.","ref":"wxMenuItem.html#getLabelFromText/1"},{"type":"function","title":"wxMenuItem.getLabelText/1","doc":"Strips all accelerator characters and mnemonics from the given `text`.\n\nFor example:\n\nwill return just `\"Hello\"`.\n\nSee: `getItemLabelText/1`, `getItemLabel/1`","ref":"wxMenuItem.html#getLabelText/1"},{"type":"function","title":"wxMenuItem.getMenu/1","doc":"Returns the menu this menu item is in, or NULL if this menu item is not\nattached.","ref":"wxMenuItem.html#getMenu/1"},{"type":"function","title":"wxMenuItem.getSubMenu/1","doc":"Returns the submenu associated with the menu item, or NULL if there isn't one.","ref":"wxMenuItem.html#getSubMenu/1"},{"type":"function","title":"wxMenuItem.getText/1","doc":"See: `getItemLabel/1`.","ref":"wxMenuItem.html#getText/1"},{"type":"function","title":"wxMenuItem.isCheckable/1","doc":"Returns true if the item is checkable.\n\nNotice that the radio buttons are considered to be checkable as well, so this\nmethod returns true for them too. Use `IsCheck()` (not implemented in wx) if you\nwant to test for the check items only.","ref":"wxMenuItem.html#isCheckable/1"},{"type":"function","title":"wxMenuItem.isChecked/1","doc":"Returns true if the item is checked.","ref":"wxMenuItem.html#isChecked/1"},{"type":"function","title":"wxMenuItem.isEnabled/1","doc":"Returns true if the item is enabled.","ref":"wxMenuItem.html#isEnabled/1"},{"type":"function","title":"wxMenuItem.isSeparator/1","doc":"Returns true if the item is a separator.","ref":"wxMenuItem.html#isSeparator/1"},{"type":"function","title":"wxMenuItem.isSubMenu/1","doc":"Returns true if the item is a submenu.","ref":"wxMenuItem.html#isSubMenu/1"},{"type":"function","title":"wxMenuItem.new/0","doc":"","ref":"wxMenuItem.html#new/0"},{"type":"function","title":"wxMenuItem.new/1","doc":"Constructs a `m:wxMenuItem` object.\n\nMenu items can be standard, or \"stock menu items\", or custom. For the standard\nmenu items (such as commands to open a file, exit the program and so on, see\npage_stockitems for the full list) it is enough to specify just the stock ID and\nleave `text` and `help` string empty. Some platforms (currently wxGTK only, and\nsee the remark in `setBitmap/2` documentation) will also show standard bitmaps\nfor stock menu items.\n\nLeaving at least `text` empty for the stock menu items is actually strongly\nrecommended as they will have appearance and keyboard interface (including\nstandard accelerators) familiar to the user.\n\nFor the custom (non-stock) menu items, `text` must be specified and while `help`\nstring may be left empty, it's recommended to pass the item description (which\nis automatically shown by the library in the status bar when the menu item is\nselected) in this parameter.\n\nFinally note that you can e.g. use a stock menu label without using its stock\nhelp string:\n\nthat is, stock properties are set independently one from the other.","ref":"wxMenuItem.html#new/1"},{"type":"function","title":"wxMenuItem.setBitmap/2","doc":"Sets the bitmap for the menu item.\n\nIt is equivalent to wxMenuItem::SetBitmaps(bmp, wxNullBitmap) if `checked` is\ntrue (default value) or SetBitmaps(wxNullBitmap, bmp) otherwise.\n\n`setBitmap/2` must be called before the item is appended to the menu, i.e.\nappending the item without a bitmap and setting one later is not guaranteed to\nwork. But the bitmap can be changed or reset later if it had been set up\ninitially.\n\nNotice that GTK+ uses a global setting called `gtk-menu-images` to determine if\nthe images should be shown in the menus at all. If it is off (which is the case\nin e.g. Gnome 2.28 by default), no images will be shown, consistently with the\nnative behaviour.\n\nOnly for:wxmsw,wxosx,wxgtk","ref":"wxMenuItem.html#setBitmap/2"},{"type":"function","title":"wxMenuItem.setHelp/2","doc":"Sets the help string.","ref":"wxMenuItem.html#setHelp/2"},{"type":"function","title":"wxMenuItem.setItemLabel/2","doc":"Sets the label associated with the menu item.\n\nNote that if the ID of this menu item corresponds to a stock ID, then it is not\nnecessary to specify a label: wxWidgets will automatically use the stock item\nlabel associated with that ID. See the `new/1` for more info.\n\nThe label string for the normal menu items (not separators) may include the\naccelerator which can be used to activate the menu item from keyboard. An\naccelerator key can be specified using the ampersand `&` character. In order to\nembed an ampersand character in the menu item text, the ampersand must be\ndoubled.\n\nOptionally you can specify also an accelerator string appending a tab character\n`\\t` followed by a valid key combination (e.g. `CTRL+V`). Its general syntax is\nany combination of `\"CTRL\"`, `\"RAWCTRL\"`, `\"ALT\"` and `\"SHIFT\"` strings (case\ndoesn't matter) separated by either `'-'` or `'+'` characters and followed by\nthe accelerator itself. Notice that `CTRL` corresponds to the \"Ctrl\" key on most\nplatforms but not under macOS where it is mapped to \"Cmd\" key on Mac keyboard.\nUsually this is exactly what you want in portable code but if you really need to\nuse the (rarely used for this purpose) \"Ctrl\" key even under Mac, you may use\n`RAWCTRL` to prevent this mapping. Under the other platforms `RAWCTRL` is the\nsame as plain `CTRL`.\n\nThe accelerator may be any alphanumeric character, any function key (from `F1`\nto `F12`), any numpad digit key using `KP_` prefix (i.e. from `KP_0` to `KP_9`)\nor one of the special strings listed below (again, case doesn't matter)\ncorresponding to the specified key code:\n\nExamples:\n\nNote: In wxGTK using `\"SHIFT\"` with non-alphabetic characters currently doesn't\nwork, even in combination with other modifiers, due to GTK+ limitation. E.g.\n`Shift+Ctrl+A` works but `Shift+Ctrl+1` or `Shift+/` do not, so avoid using\naccelerators of this form in portable code.\n\nNote: In wxGTk, the left/right/up/down arrow keys do not work as accelerator\nkeys for a menu item unless a modifier key is used. Additionally, the following\nkeycodes are not supported as menu accelerator keys:\n\nSee: `getItemLabel/1`, `getItemLabelText/1`","ref":"wxMenuItem.html#setItemLabel/2"},{"type":"function","title":"wxMenuItem.setMenu/2","doc":"Sets the parent menu which will contain this menu item.","ref":"wxMenuItem.html#setMenu/2"},{"type":"function","title":"wxMenuItem.setSubMenu/2","doc":"Sets the submenu of this menu item.","ref":"wxMenuItem.html#setSubMenu/2"},{"type":"function","title":"wxMenuItem.setText/2","doc":"See: `setItemLabel/2`.","ref":"wxMenuItem.html#setText/2"},{"type":"type","title":"wxMenuItem.wxMenuItem/0","doc":"","ref":"wxMenuItem.html#t:wxMenuItem/0"},{"type":"module","title":"wxMessageDialog","doc":"Functions for wxMessageDialog class\n\nThis class represents a dialog that shows a single or multi-line message, with a\nchoice of OK, Yes, No and Cancel buttons.\n\nStyles\n\nThis class supports the following styles:\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_msg)\n\nSee: `wxRichMessageDialog` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMessageDialog](https://docs.wxwidgets.org/3.1/classwx_message_dialog.html)","ref":"wxMessageDialog.html"},{"type":"function","title":"wxMessageDialog.destroy/1","doc":"Destroys the object.","ref":"wxMessageDialog.html#destroy/1"},{"type":"function","title":"wxMessageDialog.new/2","doc":"","ref":"wxMessageDialog.html#new/2"},{"type":"function","title":"wxMessageDialog.new/3","doc":"Constructor specifying the message box properties.\n\nUse `wxDialog:showModal/1` to show the dialog.\n\n`style` may be a bit list of the identifiers described above.\n\nNotice that not all styles are compatible: only one of `wxOK` and `wxYES_NO` may\nbe specified (and one of them must be specified) and at most one default button\nstyle can be used and it is only valid if the corresponding button is shown in\nthe message box.","ref":"wxMessageDialog.html#new/3"},{"type":"type","title":"wxMessageDialog.wxMessageDialog/0","doc":"","ref":"wxMessageDialog.html#t:wxMessageDialog/0"},{"type":"module","title":"wxMiniFrame","doc":"Functions for wxMiniFrame class\n\nA miniframe is a frame with a small title bar. It is suitable for floating\ntoolbars that must not take up too much screen area.\n\nAn example of mini frame can be seen in the page_samples_dialogs using the \"Mini\nframe\" command of the \"Generic dialogs\" submenu.\n\nStyles\n\nThis class supports the following styles:\n\nRemark: This class has miniframe functionality under Windows and GTK, i.e. the\npresence of mini frame will not be noted in the task bar and focus behaviour is\ndifferent. On other platforms, it behaves like a normal frame.\n\nSee: `m:wxMDIParentFrame`, `m:wxMDIChildFrame`, `m:wxFrame`, `m:wxDialog`\n\nThis class is derived (and can use functions) from: `m:wxFrame`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMiniFrame](https://docs.wxwidgets.org/3.1/classwx_mini_frame.html)","ref":"wxMiniFrame.html"},{"type":"function","title":"wxMiniFrame.create/4","doc":"","ref":"wxMiniFrame.html#create/4"},{"type":"function","title":"wxMiniFrame.create/5","doc":"Used in two-step frame construction.\n\nSee `new/4` for further details.","ref":"wxMiniFrame.html#create/5"},{"type":"function","title":"wxMiniFrame.destroy/1","doc":"Destructor.\n\nDestroys all child windows and menu bar if present.","ref":"wxMiniFrame.html#destroy/1"},{"type":"function","title":"wxMiniFrame.new/0","doc":"Default ctor.","ref":"wxMiniFrame.html#new/0"},{"type":"function","title":"wxMiniFrame.new/3","doc":"","ref":"wxMiniFrame.html#new/3"},{"type":"function","title":"wxMiniFrame.new/4","doc":"Constructor, creating the window.\n\nRemark: The frame behaves like a normal frame on non-Windows platforms.\n\nSee: `create/5`","ref":"wxMiniFrame.html#new/4"},{"type":"type","title":"wxMiniFrame.wxMiniFrame/0","doc":"","ref":"wxMiniFrame.html#t:wxMiniFrame/0"},{"type":"module","title":"wxMirrorDC","doc":"Functions for wxMirrorDC class\n\n`m:wxMirrorDC` is a simple wrapper class which is always associated with a real\n`m:wxDC` object and either forwards all of its operations to it without changes\n(no mirroring takes place) or exchanges `x` and `y` coordinates which makes it\npossible to reuse the same code to draw a figure and its mirror - i.e.\nreflection related to the diagonal line x == y.\n\nSince: 2.5.0\n\nThis class is derived (and can use functions) from: `m:wxDC`\n\nwxWidgets docs:\n[wxMirrorDC](https://docs.wxwidgets.org/3.1/classwx_mirror_d_c.html)","ref":"wxMirrorDC.html"},{"type":"function","title":"wxMirrorDC.destroy/1","doc":"Destroys the object.","ref":"wxMirrorDC.html#destroy/1"},{"type":"function","title":"wxMirrorDC.new/2","doc":"Creates a (maybe) mirrored DC associated with the real `dc`.\n\nEverything drawn on `m:wxMirrorDC` will appear (and maybe mirrored) on `dc`.\n\n`mirror` specifies if we do mirror (if it is true) or not (if it is false).","ref":"wxMirrorDC.html#new/2"},{"type":"type","title":"wxMirrorDC.wxMirrorDC/0","doc":"","ref":"wxMirrorDC.html#t:wxMirrorDC/0"},{"type":"module","title":"wxMouseCaptureChangedEvent","doc":"Functions for wxMouseCaptureChangedEvent class\n\nAn mouse capture changed event is sent to a window that loses its mouse capture.\nThis is called even if `wxWindow:releaseMouse/1` was called by the application\ncode. Handling this event allows an application to cater for unexpected capture\nreleases which might otherwise confuse mouse handling code.\n\nOnly for:wxmsw\n\nSee: `m:wxMouseCaptureLostEvent`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxWindow:captureMouse/1`, `wxWindow:releaseMouse/1`, `wxWindow:getCapture/0`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxMouseCaptureChangedEvent](https://docs.wxwidgets.org/3.1/classwx_mouse_capture_changed_event.html)","ref":"wxMouseCaptureChangedEvent.html"},{"type":"module","title":"Events - wxMouseCaptureChangedEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxMouseCaptureChangedEventType`](`t:wxMouseCaptureChangedEventType/0`) to\nsubscribe to events of this type.","ref":"wxMouseCaptureChangedEvent.html#module-events"},{"type":"function","title":"wxMouseCaptureChangedEvent.getCapturedWindow/1","doc":"Returns the window that gained the capture, or NULL if it was a non-wxWidgets\nwindow.","ref":"wxMouseCaptureChangedEvent.html#getCapturedWindow/1"},{"type":"type","title":"wxMouseCaptureChangedEvent.wxMouseCaptureChanged/0","doc":"","ref":"wxMouseCaptureChangedEvent.html#t:wxMouseCaptureChanged/0"},{"type":"type","title":"wxMouseCaptureChangedEvent.wxMouseCaptureChangedEvent/0","doc":"","ref":"wxMouseCaptureChangedEvent.html#t:wxMouseCaptureChangedEvent/0"},{"type":"type","title":"wxMouseCaptureChangedEvent.wxMouseCaptureChangedEventType/0","doc":"","ref":"wxMouseCaptureChangedEvent.html#t:wxMouseCaptureChangedEventType/0"},{"type":"module","title":"wxMouseCaptureLostEvent","doc":"Functions for wxMouseCaptureLostEvent class\n\nA mouse capture lost event is sent to a window that had obtained mouse capture,\nwhich was subsequently lost due to an \"external\" event (for example, when a\ndialog box is shown or if another application captures the mouse).\n\nIf this happens, this event is sent to all windows that are on the capture stack\n(i.e. called CaptureMouse, but didn't call ReleaseMouse yet). The event is not\nsent if the capture changes because of a call to CaptureMouse or ReleaseMouse.\n\nThis event is currently emitted under Windows only.\n\nOnly for:wxmsw\n\nSee: `m:wxMouseCaptureChangedEvent`,\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events),\n`wxWindow:captureMouse/1`, `wxWindow:releaseMouse/1`, `wxWindow:getCapture/0`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxMouseCaptureLostEvent](https://docs.wxwidgets.org/3.1/classwx_mouse_capture_lost_event.html)","ref":"wxMouseCaptureLostEvent.html"},{"type":"module","title":"Events - wxMouseCaptureLostEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxMouseCaptureLostEventType`](`t:wxMouseCaptureLostEventType/0`) to subscribe\nto events of this type.","ref":"wxMouseCaptureLostEvent.html#module-events"},{"type":"type","title":"wxMouseCaptureLostEvent.wxMouseCaptureLost/0","doc":"","ref":"wxMouseCaptureLostEvent.html#t:wxMouseCaptureLost/0"},{"type":"type","title":"wxMouseCaptureLostEvent.wxMouseCaptureLostEvent/0","doc":"","ref":"wxMouseCaptureLostEvent.html#t:wxMouseCaptureLostEvent/0"},{"type":"type","title":"wxMouseCaptureLostEvent.wxMouseCaptureLostEventType/0","doc":"","ref":"wxMouseCaptureLostEvent.html#t:wxMouseCaptureLostEventType/0"},{"type":"module","title":"wxMouseEvent","doc":"Functions for wxMouseEvent class\n\nThis event class contains information about the events generated by the mouse:\nthey include mouse buttons press and release events and mouse move events.\n\nAll mouse events involving the buttons use `wxMOUSE_BTN_LEFT` for the left mouse\nbutton, `wxMOUSE_BTN_MIDDLE` for the middle one and `wxMOUSE_BTN_RIGHT` for the\nright one. And if the system supports more buttons, the `wxMOUSE_BTN_AUX1` and\n`wxMOUSE_BTN_AUX2` events can also be generated. Note that not all mice have\neven a middle button so a portable application should avoid relying on the\nevents from it (but the right button click can be emulated using the left mouse\nbutton with the control key under Mac platforms with a single button mouse).\n\nFor the `wxEVT_ENTER_WINDOW` and `wxEVT_LEAVE_WINDOW` events purposes, the mouse\nis considered to be inside the window if it is in the window client area and not\ninside one of its children. In other words, the parent window receives\n`wxEVT_LEAVE_WINDOW` event not only when the mouse leaves the window entirely\nbut also when it enters one of its children.\n\nThe position associated with a mouse event is expressed in the window\ncoordinates of the window which generated the event, you can use\n`wxWindow:clientToScreen/3` to convert it to screen coordinates and possibly\ncall `wxWindow:screenToClient/2` next to convert it to window coordinates of\nanother window.\n\nNote: Note the difference between methods like `leftDown/1` and the inherited\n`leftIsDown/1`: the former returns true when the event corresponds to the left\nmouse button click while the latter returns true if the left mouse button is\ncurrently being pressed. For example, when the user is dragging the mouse you\ncan use `leftIsDown/1` to test whether the left mouse button is (still)\ndepressed. Also, by convention, if `leftDown/1` returns true, `leftIsDown/1`\nwill also return true in wxWidgets whatever the underlying GUI behaviour is\n(which is platform-dependent). The same applies, of course, to other mouse\nbuttons as well.\n\nSee: `m:wxKeyEvent`\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxMouseEvent](https://docs.wxwidgets.org/3.1/classwx_mouse_event.html)","ref":"wxMouseEvent.html"},{"type":"module","title":"Events - wxMouseEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxMouseEventType`](`t:wxMouseEventType/0`)\nto subscribe to events of this type.","ref":"wxMouseEvent.html#module-events"},{"type":"function","title":"wxMouseEvent.altDown/1","doc":"Returns true if the Alt key is pressed.\n\nNotice that `wxKeyEvent:getModifiers/1` should usually be used instead of this\none.","ref":"wxMouseEvent.html#altDown/1"},{"type":"function","title":"wxMouseEvent.aux1DClick/1","doc":"Returns true if the event was a first extra button double click.","ref":"wxMouseEvent.html#aux1DClick/1"},{"type":"function","title":"wxMouseEvent.aux1Down/1","doc":"Returns true if the first extra button mouse button changed to down.","ref":"wxMouseEvent.html#aux1Down/1"},{"type":"function","title":"wxMouseEvent.aux1Up/1","doc":"Returns true if the first extra button mouse button changed to up.","ref":"wxMouseEvent.html#aux1Up/1"},{"type":"function","title":"wxMouseEvent.aux2DClick/1","doc":"Returns true if the event was a second extra button double click.","ref":"wxMouseEvent.html#aux2DClick/1"},{"type":"function","title":"wxMouseEvent.aux2Down/1","doc":"Returns true if the second extra button mouse button changed to down.","ref":"wxMouseEvent.html#aux2Down/1"},{"type":"function","title":"wxMouseEvent.aux2Up/1","doc":"Returns true if the second extra button mouse button changed to up.","ref":"wxMouseEvent.html#aux2Up/1"},{"type":"function","title":"wxMouseEvent.button/2","doc":"Returns true if the event was generated by the specified button.\n\nSee: wxMouseState::ButtoinIsDown()","ref":"wxMouseEvent.html#button/2"},{"type":"function","title":"wxMouseEvent.buttonDClick/1","doc":"","ref":"wxMouseEvent.html#buttonDClick/1"},{"type":"function","title":"wxMouseEvent.buttonDClick/2","doc":"If the argument is omitted, this returns true if the event was a mouse double\nclick event.\n\nOtherwise the argument specifies which double click event was generated (see\n`button/2` for the possible values).","ref":"wxMouseEvent.html#buttonDClick/2"},{"type":"function","title":"wxMouseEvent.buttonDown/1","doc":"","ref":"wxMouseEvent.html#buttonDown/1"},{"type":"function","title":"wxMouseEvent.buttonDown/2","doc":"If the argument is omitted, this returns true if the event was a mouse button\ndown event.\n\nOtherwise the argument specifies which button-down event was generated (see\n`button/2` for the possible values).","ref":"wxMouseEvent.html#buttonDown/2"},{"type":"function","title":"wxMouseEvent.buttonUp/1","doc":"","ref":"wxMouseEvent.html#buttonUp/1"},{"type":"function","title":"wxMouseEvent.buttonUp/2","doc":"If the argument is omitted, this returns true if the event was a mouse button up\nevent.\n\nOtherwise the argument specifies which button-up event was generated (see\n`button/2` for the possible values).","ref":"wxMouseEvent.html#buttonUp/2"},{"type":"function","title":"wxMouseEvent.cmdDown/1","doc":"Returns true if the key used for command accelerators is pressed.\n\nSame as `controlDown/1`. Deprecated.\n\nNotice that `wxKeyEvent:getModifiers/1` should usually be used instead of this\none.","ref":"wxMouseEvent.html#cmdDown/1"},{"type":"function","title":"wxMouseEvent.controlDown/1","doc":"Returns true if the Control key or Apple/Command key under macOS is pressed.\n\nThis function doesn't distinguish between right and left control keys.\n\nNotice that `wxKeyEvent:getModifiers/1` should usually be used instead of this\none.","ref":"wxMouseEvent.html#controlDown/1"},{"type":"function","title":"wxMouseEvent.dragging/1","doc":"Returns true if this was a dragging event (motion while a button is depressed).\n\nSee: `moving/1`","ref":"wxMouseEvent.html#dragging/1"},{"type":"function","title":"wxMouseEvent.entering/1","doc":"Returns true if the mouse was entering the window.\n\nSee: `leaving/1`","ref":"wxMouseEvent.html#entering/1"},{"type":"function","title":"wxMouseEvent.getButton/1","doc":"Returns the mouse button which generated this event or `wxMOUSE_BTN_NONE` if no\nbutton is involved (for mouse move, enter or leave event, for example).\n\nOtherwise `wxMOUSE_BTN_LEFT` is returned for the left button down, up and double\nclick events, `wxMOUSE_BTN_MIDDLE` and `wxMOUSE_BTN_RIGHT` for the same events\nfor the middle and the right buttons respectively.","ref":"wxMouseEvent.html#getButton/1"},{"type":"function","title":"wxMouseEvent.getLinesPerAction/1","doc":"Returns the configured number of lines (or whatever) to be scrolled per wheel\naction.\n\nDefault value under most platforms is three.\n\nSee: `GetColumnsPerAction()` (not implemented in wx)","ref":"wxMouseEvent.html#getLinesPerAction/1"},{"type":"function","title":"wxMouseEvent.getLogicalPosition/2","doc":"Returns the logical mouse position in pixels (i.e. translated according to the\ntranslation set for the DC, which usually indicates that the window has been\nscrolled).","ref":"wxMouseEvent.html#getLogicalPosition/2"},{"type":"function","title":"wxMouseEvent.getPosition/1","doc":"Returns the physical mouse position.","ref":"wxMouseEvent.html#getPosition/1"},{"type":"function","title":"wxMouseEvent.getWheelAxis/1","doc":"Gets the axis the wheel operation concerns.\n\nUsually the mouse wheel is used to scroll vertically so `wxMOUSE_WHEEL_VERTICAL`\nis returned but some mice (and most trackpads) also allow to use the wheel to\nscroll horizontally in which case `wxMOUSE_WHEEL_HORIZONTAL` is returned.\n\nNotice that before wxWidgets 2.9.4 this method returned `int`.","ref":"wxMouseEvent.html#getWheelAxis/1"},{"type":"function","title":"wxMouseEvent.getWheelDelta/1","doc":"Get wheel delta, normally 120.\n\nThis is the threshold for action to be taken, and one such action (for example,\nscrolling one increment) should occur for each delta.","ref":"wxMouseEvent.html#getWheelDelta/1"},{"type":"function","title":"wxMouseEvent.getWheelRotation/1","doc":"Get wheel rotation, positive or negative indicates direction of rotation.\n\nCurrent devices all send an event when rotation is at least +/-WheelDelta, but\nfiner resolution devices can be created in the future.\n\nBecause of this you shouldn't assume that one event is equal to 1 line, but you\nshould be able to either do partial line scrolling or wait until several events\naccumulate before scrolling.","ref":"wxMouseEvent.html#getWheelRotation/1"},{"type":"function","title":"wxMouseEvent.getX/1","doc":"Returns X coordinate of the physical mouse event position.","ref":"wxMouseEvent.html#getX/1"},{"type":"function","title":"wxMouseEvent.getY/1","doc":"Returns Y coordinate of the physical mouse event position.","ref":"wxMouseEvent.html#getY/1"},{"type":"function","title":"wxMouseEvent.isButton/1","doc":"Returns true if the event was a mouse button event (not necessarily a button\ndown event - that may be tested using `buttonDown/2`).","ref":"wxMouseEvent.html#isButton/1"},{"type":"function","title":"wxMouseEvent.isPageScroll/1","doc":"Returns true if the system has been setup to do page scrolling with the mouse\nwheel instead of line scrolling.","ref":"wxMouseEvent.html#isPageScroll/1"},{"type":"function","title":"wxMouseEvent.leaving/1","doc":"Returns true if the mouse was leaving the window.\n\nSee: `entering/1`","ref":"wxMouseEvent.html#leaving/1"},{"type":"function","title":"wxMouseEvent.leftDClick/1","doc":"Returns true if the event was a left double click.","ref":"wxMouseEvent.html#leftDClick/1"},{"type":"function","title":"wxMouseEvent.leftDown/1","doc":"Returns true if the left mouse button changed to down.","ref":"wxMouseEvent.html#leftDown/1"},{"type":"function","title":"wxMouseEvent.leftIsDown/1","doc":"Returns true if the left mouse button is currently down.","ref":"wxMouseEvent.html#leftIsDown/1"},{"type":"function","title":"wxMouseEvent.leftUp/1","doc":"Returns true if the left mouse button changed to up.","ref":"wxMouseEvent.html#leftUp/1"},{"type":"function","title":"wxMouseEvent.metaDown/1","doc":"Returns true if the Meta key was down at the time of the event.","ref":"wxMouseEvent.html#metaDown/1"},{"type":"function","title":"wxMouseEvent.middleDClick/1","doc":"Returns true if the event was a middle double click.","ref":"wxMouseEvent.html#middleDClick/1"},{"type":"function","title":"wxMouseEvent.middleDown/1","doc":"Returns true if the middle mouse button changed to down.","ref":"wxMouseEvent.html#middleDown/1"},{"type":"function","title":"wxMouseEvent.middleIsDown/1","doc":"Returns true if the middle mouse button is currently down.","ref":"wxMouseEvent.html#middleIsDown/1"},{"type":"function","title":"wxMouseEvent.middleUp/1","doc":"Returns true if the middle mouse button changed to up.","ref":"wxMouseEvent.html#middleUp/1"},{"type":"function","title":"wxMouseEvent.moving/1","doc":"Returns true if this was a motion event and no mouse buttons were pressed.\n\nIf any mouse button is held pressed, then this method returns false and\n`dragging/1` returns true.","ref":"wxMouseEvent.html#moving/1"},{"type":"function","title":"wxMouseEvent.rightDClick/1","doc":"Returns true if the event was a right double click.","ref":"wxMouseEvent.html#rightDClick/1"},{"type":"function","title":"wxMouseEvent.rightDown/1","doc":"Returns true if the right mouse button changed to down.","ref":"wxMouseEvent.html#rightDown/1"},{"type":"function","title":"wxMouseEvent.rightIsDown/1","doc":"Returns true if the right mouse button is currently down.","ref":"wxMouseEvent.html#rightIsDown/1"},{"type":"function","title":"wxMouseEvent.rightUp/1","doc":"Returns true if the right mouse button changed to up.","ref":"wxMouseEvent.html#rightUp/1"},{"type":"function","title":"wxMouseEvent.shiftDown/1","doc":"Returns true if the Shift key is pressed.\n\nThis function doesn't distinguish between right and left shift keys.\n\nNotice that `wxKeyEvent:getModifiers/1` should usually be used instead of this\none.","ref":"wxMouseEvent.html#shiftDown/1"},{"type":"type","title":"wxMouseEvent.wxMouse/0","doc":"","ref":"wxMouseEvent.html#t:wxMouse/0"},{"type":"type","title":"wxMouseEvent.wxMouseEvent/0","doc":"","ref":"wxMouseEvent.html#t:wxMouseEvent/0"},{"type":"type","title":"wxMouseEvent.wxMouseEventType/0","doc":"","ref":"wxMouseEvent.html#t:wxMouseEventType/0"},{"type":"module","title":"wxMoveEvent","doc":"Functions for wxMoveEvent class\n\nA move event holds information about window position change.\n\nThese events are currently generated for top level (see `m:wxTopLevelWindow`)\nwindows in all ports, but are not generated for the child windows in wxGTK.\n\nSee: \\{X,Y\\},\n[Overview events](https://docs.wxwidgets.org/3.1/overview_events.html#overview_events)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxMoveEvent](https://docs.wxwidgets.org/3.1/classwx_move_event.html)","ref":"wxMoveEvent.html"},{"type":"module","title":"Events - wxMoveEvent","doc":"Use `wxEvtHandler:connect/3` with [`wxMoveEventType`](`t:wxMoveEventType/0`) to\nsubscribe to events of this type.","ref":"wxMoveEvent.html#module-events"},{"type":"function","title":"wxMoveEvent.getPosition/1","doc":"Returns the position of the window generating the move change event.","ref":"wxMoveEvent.html#getPosition/1"},{"type":"function","title":"wxMoveEvent.getRect/1","doc":"","ref":"wxMoveEvent.html#getRect/1"},{"type":"type","title":"wxMoveEvent.wxMove/0","doc":"","ref":"wxMoveEvent.html#t:wxMove/0"},{"type":"type","title":"wxMoveEvent.wxMoveEvent/0","doc":"","ref":"wxMoveEvent.html#t:wxMoveEvent/0"},{"type":"type","title":"wxMoveEvent.wxMoveEventType/0","doc":"","ref":"wxMoveEvent.html#t:wxMoveEventType/0"},{"type":"module","title":"wxMultiChoiceDialog","doc":"Functions for wxMultiChoiceDialog class\n\nThis class represents a dialog that shows a list of strings, and allows the user\nto select one or more.\n\nStyles\n\nThis class supports the following styles:\n\nSee:\n[Overview cmndlg](https://docs.wxwidgets.org/3.1/overview_cmndlg.html#overview_cmndlg_multichoice),\n`m:wxSingleChoiceDialog`\n\nThis class is derived (and can use functions) from: `m:wxDialog`\n`m:wxTopLevelWindow` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxMultiChoiceDialog](https://docs.wxwidgets.org/3.1/classwx_multi_choice_dialog.html)","ref":"wxMultiChoiceDialog.html"},{"type":"function","title":"wxMultiChoiceDialog.destroy/1","doc":"Destroys the object.","ref":"wxMultiChoiceDialog.html#destroy/1"},{"type":"function","title":"wxMultiChoiceDialog.getSelections/1","doc":"Returns array with indexes of selected items.","ref":"wxMultiChoiceDialog.html#getSelections/1"},{"type":"function","title":"wxMultiChoiceDialog.new/4","doc":"","ref":"wxMultiChoiceDialog.html#new/4"},{"type":"function","title":"wxMultiChoiceDialog.new/5","doc":"Constructor taking an array of `wxString` (not implemented in wx) choices.\n\nRemark: Use `wxDialog:showModal/1` to show the dialog.","ref":"wxMultiChoiceDialog.html#new/5"},{"type":"function","title":"wxMultiChoiceDialog.setSelections/2","doc":"Sets selected items from the array of selected items' indexes.","ref":"wxMultiChoiceDialog.html#setSelections/2"},{"type":"type","title":"wxMultiChoiceDialog.wxMultiChoiceDialog/0","doc":"","ref":"wxMultiChoiceDialog.html#t:wxMultiChoiceDialog/0"},{"type":"module","title":"wxNavigationKeyEvent","doc":"Functions for wxNavigationKeyEvent class\n\nThis event class contains information about navigation events, generated by\nnavigation keys such as tab and page down.\n\nThis event is mainly used by wxWidgets implementations. A\n`m:wxNavigationKeyEvent` handler is automatically provided by wxWidgets when you\nenable keyboard navigation inside a window by inheriting it from\nwxNavigationEnabled<>.\n\nSee: `wxWindow:navigate/2`, `wxWindow::NavigateIn` (not implemented in wx)\n\nThis class is derived (and can use functions) from: `m:wxEvent`\n\nwxWidgets docs:\n[wxNavigationKeyEvent](https://docs.wxwidgets.org/3.1/classwx_navigation_key_event.html)","ref":"wxNavigationKeyEvent.html"},{"type":"module","title":"Events - wxNavigationKeyEvent","doc":"Use `wxEvtHandler:connect/3` with\n[`wxNavigationKeyEventType`](`t:wxNavigationKeyEventType/0`) to subscribe to\nevents of this type.","ref":"wxNavigationKeyEvent.html#module-events"},{"type":"function","title":"wxNavigationKeyEvent.getCurrentFocus/1","doc":"Returns the child that has the focus, or NULL.","ref":"wxNavigationKeyEvent.html#getCurrentFocus/1"},{"type":"function","title":"wxNavigationKeyEvent.getDirection/1","doc":"Returns true if the navigation was in the forward direction.","ref":"wxNavigationKeyEvent.html#getDirection/1"},{"type":"function","title":"wxNavigationKeyEvent.isFromTab/1","doc":"Returns true if the navigation event was from a tab key.\n\nThis is required for proper navigation over radio buttons.","ref":"wxNavigationKeyEvent.html#isFromTab/1"},{"type":"function","title":"wxNavigationKeyEvent.isWindowChange/1","doc":"Returns true if the navigation event represents a window change (for example,\nfrom Ctrl-Page Down in a notebook).","ref":"wxNavigationKeyEvent.html#isWindowChange/1"},{"type":"function","title":"wxNavigationKeyEvent.setCurrentFocus/2","doc":"Sets the current focus window member.","ref":"wxNavigationKeyEvent.html#setCurrentFocus/2"},{"type":"function","title":"wxNavigationKeyEvent.setDirection/2","doc":"Sets the direction to forward if `direction` is true, or backward if false.","ref":"wxNavigationKeyEvent.html#setDirection/2"},{"type":"function","title":"wxNavigationKeyEvent.setFromTab/2","doc":"Marks the navigation event as from a tab key.","ref":"wxNavigationKeyEvent.html#setFromTab/2"},{"type":"function","title":"wxNavigationKeyEvent.setWindowChange/2","doc":"Marks the event as a window change event.","ref":"wxNavigationKeyEvent.html#setWindowChange/2"},{"type":"type","title":"wxNavigationKeyEvent.wxNavigationKey/0","doc":"","ref":"wxNavigationKeyEvent.html#t:wxNavigationKey/0"},{"type":"type","title":"wxNavigationKeyEvent.wxNavigationKeyEvent/0","doc":"","ref":"wxNavigationKeyEvent.html#t:wxNavigationKeyEvent/0"},{"type":"type","title":"wxNavigationKeyEvent.wxNavigationKeyEventType/0","doc":"","ref":"wxNavigationKeyEvent.html#t:wxNavigationKeyEventType/0"},{"type":"module","title":"wxNotebook","doc":"Functions for wxNotebook class\n\nThis class represents a notebook control, which manages multiple windows with\nassociated tabs.\n\nTo use the class, create a `m:wxNotebook` object and call\n`wxBookCtrlBase:addPage/4` or `wxBookCtrlBase:insertPage/5`, passing a window to\nbe used as the page. Do not explicitly delete the window for a page that is\ncurrently managed by `m:wxNotebook`.\n\n`wxNotebookPage` is a typedef for `m:wxWindow`.\n\nStyles\n\nThis class supports the following styles:\n\nPage backgrounds\n\nOn Windows, the default theme paints a background on the notebook's pages. If\nyou wish to suppress this theme, for aesthetic or performance reasons, there are\nthree ways of doing it. You can use `wxNB_NOPAGETHEME` to disable themed drawing\nfor a particular notebook, you can call `wxSystemOptions:setOption/2` to disable\nit for the whole application, or you can disable it for individual pages by\nusing `wxWindow:setBackgroundColour/2`.\n\nTo disable themed pages globally:\n\nSet the value to 1 to enable it again. To give a single page a solid background\nthat more or less fits in with the overall theme, use:\n\nOn platforms other than Windows, or if the application is not using Windows\nthemes, `getThemeBackgroundColour/1` will return an uninitialised colour object,\nand the above code will therefore work on all platforms.\n\nSee: ?wxBookCtrl, `m:wxBookCtrlEvent`, `m:wxImageList`,\n[Examples](https://docs.wxwidgets.org/3.1/page_samples.html#page_samples_notebook)\n\nThis class is derived (and can use functions) from: `m:wxBookCtrlBase`\n`m:wxControl` `m:wxWindow` `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxNotebook](https://docs.wxwidgets.org/3.1/classwx_notebook.html)","ref":"wxNotebook.html"},{"type":"module","title":"Events - wxNotebook","doc":"Event types emitted from this class:\n[`command_notebook_page_changed`](`m:wxBookCtrlEvent`),\n[`command_notebook_page_changing`](`m:wxBookCtrlEvent`)","ref":"wxNotebook.html#module-events"},{"type":"function","title":"wxNotebook.assignImageList/2","doc":"Sets the image list for the page control and takes ownership of the list.\n\nSee: `m:wxImageList`, `setImageList/2`","ref":"wxNotebook.html#assignImageList/2"},{"type":"function","title":"wxNotebook.create/3","doc":"","ref":"wxNotebook.html#create/3"},{"type":"function","title":"wxNotebook.create/4","doc":"Creates a notebook control.\n\nSee `new/3` for a description of the parameters.","ref":"wxNotebook.html#create/4"},{"type":"function","title":"wxNotebook.destroy/1","doc":"Destroys the `m:wxNotebook` object.","ref":"wxNotebook.html#destroy/1"},{"type":"function","title":"wxNotebook.getImageList/1","doc":"Returns the associated image list, may be NULL.\n\nSee: `m:wxImageList`, `setImageList/2`","ref":"wxNotebook.html#getImageList/1"},{"type":"function","title":"wxNotebook.getPageImage/2","doc":"Returns the image index for the given page.","ref":"wxNotebook.html#getPageImage/2"},{"type":"function","title":"wxNotebook.getRowCount/1","doc":"Returns the number of rows in the notebook control.","ref":"wxNotebook.html#getRowCount/1"},{"type":"function","title":"wxNotebook.getThemeBackgroundColour/1","doc":"If running under Windows and themes are enabled for the application, this\nfunction returns a suitable colour for painting the background of a notebook\npage, and can be passed to `wxWindow:setBackgroundColour/2`.\n\nOtherwise, an uninitialised colour will be returned.","ref":"wxNotebook.html#getThemeBackgroundColour/1"},{"type":"function","title":"wxNotebook.new/0","doc":"Constructs a notebook control.","ref":"wxNotebook.html#new/0"},{"type":"function","title":"wxNotebook.new/2","doc":"","ref":"wxNotebook.html#new/2"},{"type":"function","title":"wxNotebook.new/3","doc":"Constructs a notebook control.\n\nNote that sometimes you can reduce flicker by passing the wxCLIP_CHILDREN window\nstyle.","ref":"wxNotebook.html#new/3"},{"type":"function","title":"wxNotebook.setImageList/2","doc":"Sets the image list to use.\n\nIt does not take ownership of the image list, you must delete it yourself.\n\nSee: `m:wxImageList`, `assignImageList/2`","ref":"wxNotebook.html#setImageList/2"},{"type":"function","title":"wxNotebook.setPadding/2","doc":"Sets the amount of space around each page's icon and label, in pixels.\n\nNote: The vertical padding cannot be changed in wxGTK.","ref":"wxNotebook.html#setPadding/2"},{"type":"function","title":"wxNotebook.setPageImage/3","doc":"Sets the image index for the given page.\n\n`image` is an index into the image list which was set with `setImageList/2`.","ref":"wxNotebook.html#setPageImage/3"},{"type":"function","title":"wxNotebook.setPageSize/2","doc":"Sets the width and height of the pages.\n\nNote: This method is currently not implemented for wxGTK.","ref":"wxNotebook.html#setPageSize/2"},{"type":"type","title":"wxNotebook.wxNotebook/0","doc":"","ref":"wxNotebook.html#t:wxNotebook/0"},{"type":"module","title":"wxNotificationMessage","doc":"Functions for wxNotificationMessage class\n\nThis class allows showing the user a message non intrusively.\n\nCurrently it is implemented natively for Windows, macOS, GTK and uses generic\ntoast notifications under the other platforms. It's not recommended but\n`wxGenericNotificationMessage` can be used instead of the native ones. This\nmight make sense if your application requires features not available in the\nnative implementation.\n\nNotice that this class is not a window and so doesn't derive from `m:wxWindow`.\n\nPlatform Notes\n\nPar: Up to Windows 8 balloon notifications are displayed from an icon in the\nnotification area of the taskbar. If your application uses a `m:wxTaskBarIcon`\nyou should call `useTaskBarIcon/1` to ensure that only one icon is shown in the\nnotification area. Windows 10 displays all notifications as popup toasts. To\nsuppress the additional icon in the notification area on Windows 10 and for\ntoast notification support on Windows 8 it is recommended to call\n`mSWUseToasts/1` before showing the first notification message.\n\nPar: The macOS implementation uses Notification Center to display native\nnotifications. In order to use actions your notifications must use the alert\nstyle. This can be enabled by the user in system settings or by setting the\n`NSUserNotificationAlertStyle` value in Info.plist to `alert`. Please note that\nthe user always has the option to change the notification style.\n\nSince: 2.9.0\n\nThis class is derived (and can use functions) from: `m:wxEvtHandler`\n\nwxWidgets docs:\n[wxNotificationMessage](https://docs.wxwidgets.org/3.1/classwx_notification_message.html)","ref":"wxNotificationMessage.html"},{"type":"module","title":"Events - wxNotificationMessage","doc":"Event types emitted from this class:\n[`notification_message_click`](`m:wxCommandEvent`),\n[`notification_message_dismissed`](`m:wxCommandEvent`),\n[`notification_message_action`](`m:wxCommandEvent`)","ref":"wxNotificationMessage.html#module-events"},{"type":"function","title":"wxNotificationMessage.addAction/2","doc":"","ref":"wxNotificationMessage.html#addAction/2"},{"type":"function","title":"wxNotificationMessage.addAction/3","doc":"Add an action to the notification.\n\nIf supported by the implementation this are usually buttons in the notification\nselectable by the user.\n\nReturn: false if the current implementation or OS version does not support\nactions in notifications.\n\nSince: 3.1.0","ref":"wxNotificationMessage.html#addAction/3"},{"type":"function","title":"wxNotificationMessage.close/1","doc":"Hides the notification.\n\nReturns true if it was hidden or false if it couldn't be done (e.g. on some\nsystems automatically hidden notifications can't be hidden manually).","ref":"wxNotificationMessage.html#close/1"},{"type":"function","title":"wxNotificationMessage.destroy/1","doc":"Destructor does not hide the notification.\n\nThe notification can continue to be shown even after the C++ object was\ndestroyed, call `close/1` explicitly if it needs to be hidden.","ref":"wxNotificationMessage.html#destroy/1"},{"type":"function","title":"wxNotificationMessage.mSWUseToasts/0","doc":"","ref":"wxNotificationMessage.html#mSWUseToasts/0"},{"type":"function","title":"wxNotificationMessage.mSWUseToasts/1","doc":"Enables toast notifications available since Windows 8 and suppresses the\nadditional icon in the notification area on Windows 10.\n\nToast notifications `require` a shortcut to the application in the start menu.\nThe start menu shortcut needs to contain an Application User Model ID. It is\nrecommended that the applications setup creates the shortcut and the application\nspecifies the setup created shortcut in `shortcutPath`. A call to this method\nwill verify (and if necessary modify) the shortcut before enabling toast\nnotifications.\n\nReturn: false if toast notifications could not be enabled.\n\nOnly for:wxmsw\n\nSee: `wxAppConsole::SetAppName()` (not implemented in wx),\n`wxAppConsole::SetVendorName()` (not implemented in wx)\n\nSince: 3.1.0","ref":"wxNotificationMessage.html#mSWUseToasts/1"},{"type":"function","title":"wxNotificationMessage.new/0","doc":"Default constructor, use `setParent/2`, `setTitle/2` and `setMessage/2` to\ninitialize the object before showing it.","ref":"wxNotificationMessage.html#new/0"},{"type":"function","title":"wxNotificationMessage.new/1","doc":"","ref":"wxNotificationMessage.html#new/1"},{"type":"function","title":"wxNotificationMessage.new/2","doc":"Create a notification object with the given attributes.\n\nSee `setTitle/2`, `setMessage/2`, `setParent/2` and `setFlags/2` for the\ndescription of the corresponding parameters.","ref":"wxNotificationMessage.html#new/2"},{"type":"function","title":"wxNotificationMessage.setFlags/2","doc":"This parameter can be currently used to specify the icon to show in the\nnotification.\n\nValid values are `wxICON_INFORMATION`, `wxICON_WARNING` and `wxICON_ERROR`\n(notice that `wxICON_QUESTION` is not allowed here). Some implementations of\nthis class may not support the icons.\n\nSee: `setIcon/2`","ref":"wxNotificationMessage.html#setFlags/2"},{"type":"function","title":"wxNotificationMessage.setIcon/2","doc":"Specify a custom icon to be displayed in the notification.\n\nSome implementations of this class may not support custom icons.\n\nSee: `setFlags/2`\n\nSince: 3.1.0","ref":"wxNotificationMessage.html#setIcon/2"},{"type":"function","title":"wxNotificationMessage.setMessage/2","doc":"Set the main text of the notification.\n\nThis should be a more detailed description than the title but still limited to\nreasonable length (not more than 256 characters).","ref":"wxNotificationMessage.html#setMessage/2"},{"type":"function","title":"wxNotificationMessage.setParent/2","doc":"Set the parent for this notification: the notification will be associated with\nthe top level parent of this window or, if this method is not called, with the\nmain application window by default.","ref":"wxNotificationMessage.html#setParent/2"},{