/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging.impl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class WeakHashtable
extends Hashtable {
    private static final int MAX_CHANGES_BEFORE_PURGE = 100;
    private static final int PARTIAL_PURGE_COUNT = 10;
    private ReferenceQueue queue = new ReferenceQueue();
    private int changeCount = 0;

    public boolean containsKey(Object key) {
        class Org_apache_commons_logging_impl_WeakHashtable$2 {
            /* synthetic */ Org_apache_commons_logging_impl_WeakHashtable$2() {
            }
        }
        Referenced referenced = new Referenced(null, key);
        return super.containsKey(referenced);
    }

    public Enumeration elements() {
        this.purge();
        return super.elements();
    }

    public Set entrySet() {
        this.purge();
        Set referencedEntries = super.entrySet();
        HashSet<Entry> unreferencedEntries = new HashSet<Entry>();
        Iterator it = referencedEntries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Referenced referencedKey = (Referenced)entry.getKey();
            Object key = referencedKey.getValue();
            Object value = entry.getValue();
            if (key == null) continue;
            Entry dereferencedEntry = new Entry(null, key, value);
            unreferencedEntries.add(dereferencedEntry);
        }
        return unreferencedEntries;
    }

    public Object get(Object key) {
        Referenced referenceKey = new Referenced(null, key);
        return super.get(referenceKey);
    }

    public boolean isEmpty() {
        this.purge();
        return super.isEmpty();
    }

    public Set keySet() {
        this.purge();
        Set referencedKeys = super.keySet();
        HashSet<Object> unreferencedKeys = new HashSet<Object>();
        Iterator it = referencedKeys.iterator();
        while (it.hasNext()) {
            Referenced referenceKey = (Referenced)it.next();
            Object keyValue = referenceKey.getValue();
            if (keyValue == null) continue;
            unreferencedKeys.add(keyValue);
        }
        return unreferencedKeys;
    }

    public Enumeration keys() {
        this.purge();
        final Enumeration enumer = super.keys();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return enumer.hasMoreElements();
            }

            public Object nextElement() {
                Referenced nextReference = (Referenced)enumer.nextElement();
                return nextReference.getValue();
            }
        };
    }

    private void purge() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakKey key;
            while ((key = (WeakKey)this.queue.poll()) != null) {
                super.remove(key.getReferenced());
            }
        }
    }

    private void purgeOne() {
        ReferenceQueue referenceQueue = this.queue;
        synchronized (referenceQueue) {
            WeakKey key = (WeakKey)this.queue.poll();
            if (key != null) {
                super.remove(key.getReferenced());
            }
        }
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not allowed");
        }
        if (value == null) {
            throw new NullPointerException("Null values are not allowed");
        }
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        Object result = null;
        Referenced keyRef = new Referenced(null, key, this.queue);
        return super.put(keyRef, value);
    }

    public void putAll(Map t) {
        if (t != null) {
            Set entrySet = t.entrySet();
            Iterator it = entrySet.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void rehash() {
        this.purge();
        super.rehash();
    }

    public Object remove(Object key) {
        if (this.changeCount++ > 100) {
            this.purge();
            this.changeCount = 0;
        } else if (this.changeCount % 10 == 0) {
            this.purgeOne();
        }
        return super.remove(new Referenced(null, key));
    }

    public int size() {
        this.purge();
        return super.size();
    }

    public String toString() {
        this.purge();
        return super.toString();
    }

    public Collection values() {
        this.purge();
        return super.values();
    }

    private static final class Entry
    implements Map.Entry {
        private final Object key;
        private final Object value;

        private Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        /* synthetic */ Entry(2 $0, Object $1, Object $2) {
            this($1, $2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            boolean result = false;
            if (o == null) return result;
            if (!(o instanceof Map.Entry)) return result;
            Map.Entry entry = (Map.Entry)o;
            if (this.getKey() == null) {
                if (entry.getKey() != null) {
                    return false;
                }
            } else {
                boolean bl = this.getKey().equals(entry.getKey());
                if (!bl) return false;
            }
            if (this.getValue() == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl = this.getValue().equals(entry.getValue());
            if (bl) return true;
            return false;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Entry.setValue is not supported.");
        }
    }

    private static final class Referenced {
        private final WeakReference reference;
        private final int hashCode;

        private Referenced(Object referant) {
            this.reference = new WeakReference<Object>(referant);
            this.hashCode = referant.hashCode();
        }

        private Referenced(Object key, ReferenceQueue queue) {
            this.reference = new WeakKey(null, key, queue, this);
            this.hashCode = key.hashCode();
        }

        /* synthetic */ Referenced(2 $0, Object $1) {
            this($1);
        }

        /* synthetic */ Referenced(2 $0, Object $1, ReferenceQueue $2) {
            this($1, $2);
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (o instanceof Referenced) {
                Referenced otherKey = (Referenced)o;
                Object thisKeyValue = this.getValue();
                Object otherKeyValue = otherKey.getValue();
                if (thisKeyValue == null) {
                    boolean bl = result = otherKeyValue == null;
                    if (result) {
                        result = this.hashCode() == otherKey.hashCode();
                    }
                } else {
                    result = thisKeyValue.equals(otherKeyValue);
                }
            }
            return result;
        }

        private Object getValue() {
            return this.reference.get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static final class WeakKey
    extends WeakReference {
        private final Referenced referenced;

        private WeakKey(Object key, ReferenceQueue queue, Referenced referenced) {
            super(key, queue);
            this.referenced = referenced;
        }

        /* synthetic */ WeakKey(2 $0, Object $1, ReferenceQueue $2, Referenced $3) {
            this($1, $2, $3);
        }

        private Referenced getReferenced() {
            return this.referenced;
        }
    }
}

