/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.utils.Platform;
import net.sf.gogui.utils.ProgressShow;

public class GuiUtils {
    public static final int PAD = 5;
    public static final int SMALL_PAD = 2;
    private static final Font MONOSPACED_FONT;
    private static final Border EMPTY_BORDER;
    private static final Border SMALL_EMPTY_BORDER;
    private static final Dimension FILLER_DIMENSION;
    private static final Dimension SMALL_FILLER_DIMENSION;
    private static URL s_iconURL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void addStyle(JTextPane jTextPane, String string, Color color, Color color2) {
        StyledDocument styledDocument = jTextPane.getStyledDocument();
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        Style style = styleContext.getStyle("default");
        Style style2 = styledDocument.addStyle(string, style);
        StyleConstants.setForeground(style2, color);
        StyleConstants.setBackground(style2, color2);
    }

    public static Border createEmptyBorder() {
        return EMPTY_BORDER;
    }

    public static Box.Filler createFiller() {
        return new Box.Filler(FILLER_DIMENSION, FILLER_DIMENSION, FILLER_DIMENSION);
    }

    public static Border createSmallEmptyBorder() {
        return SMALL_EMPTY_BORDER;
    }

    public static Box.Filler createSmallFiller() {
        return new Box.Filler(SMALL_FILLER_DIMENSION, SMALL_FILLER_DIMENSION, SMALL_FILLER_DIMENSION);
    }

    public static int getDefaultMonoFontSize() {
        return MONOSPACED_FONT.getSize();
    }

    public static void initLookAndFeel(String string) {
        block21: {
            UIManager.put("FileChooser.readOnly", Boolean.TRUE);
            if ("".equals(string)) {
                return;
            }
            boolean bl = true;
            if (string == null) {
                bl = false;
                if (Platform.isWindows()) {
                    string = "jwindows";
                } else if (!Platform.isMac()) {
                    string = "plasticxp";
                } else {
                    return;
                }
            }
            UIManager.put("jgoodies.useNarrowButtons", Boolean.FALSE);
            UIManager.put("ScrollBar.maxBumpsWidth", new Integer(22));
            if ("cross".equals(string)) {
                string = UIManager.getCrossPlatformLookAndFeelClassName();
            } else if ("gtk".equals(string)) {
                string = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else if ("motif".equals(string)) {
                string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            } else if ("jwindows".equals(string)) {
                string = "com.jgoodies.looks.windows.WindowsLookAndFeel";
            } else if ("plasticxp".equals(string)) {
                string = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
            } else if ("system".equals(string)) {
                string = UIManager.getSystemLookAndFeelClassName();
            } else if ("windows".equals(string)) {
                string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            }
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {
                if (!bl) break block21;
                SimpleDialogs.showWarning(null, "Look and feel not found:\n" + string);
            }
        }
    }

    public static boolean isNormalSizeMode(JFrame jFrame) {
        int n;
        int n2 = jFrame.getExtendedState();
        return (n2 & (n = 7)) == 0;
    }

    public static void removeKeyBinding(JComponent jComponent, String string) {
        int n = 1;
        InputMap inputMap = jComponent.getInputMap(n);
        inputMap.put(KeyStroke.getKeyStroke(string), new Object());
    }

    public static void runProgress(Frame frame, String string, ProgressRunnable progressRunnable) throws Throwable {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        JDialog jDialog = new JDialog(frame, string, true);
        jDialog.setDefaultCloseOperation(0);
        jDialog.setResizable(false);
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setStringPainted(true);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(GuiUtils.createSmallEmptyBorder());
        jPanel.add(jProgressBar);
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        ProgressThread progressThread = new ProgressThread(jDialog, progressRunnable, jProgressBar);
        progressThread.start();
        jDialog.setVisible(true);
        if (progressThread.getThrowable() != null) {
            throw progressThread.getThrowable();
        }
    }

    public static void setAntiAlias(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
    }

    public static void setGoIcon(Frame frame) {
        URL uRL = s_iconURL;
        if (uRL != null) {
            frame.setIconImage(new ImageIcon(uRL).getImage());
        }
    }

    public static void setMonospacedFont(JComponent jComponent) {
        if (MONOSPACED_FONT != null) {
            jComponent.setFont(MONOSPACED_FONT);
        }
    }

    static {
        $assertionsDisabled = !GuiUtils.class.desiredAssertionStatus();
        Object object = ClassLoader.getSystemClassLoader();
        s_iconURL = ((ClassLoader)object).getResource("net/sf/gogui/images/gogui-16x16-notrans.png");
        object = UIManager.getFont("TextArea.font");
        if (object == null) {
            MONOSPACED_FONT = Font.decode("Monospaced");
        } else {
            int n = Math.max(11, ((Font)object).getSize());
            MONOSPACED_FONT = new Font("Monospaced", 0, n);
        }
        EMPTY_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        SMALL_EMPTY_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        FILLER_DIMENSION = new Dimension(5, 5);
        SMALL_FILLER_DIMENSION = new Dimension(2, 2);
    }

    private static class ProgressThread
    extends Thread
    implements ProgressShow {
        private int m_percent;
        private final Dialog m_dialog;
        private final JProgressBar m_progressBar;
        private final ProgressRunnable m_runnable;
        private Throwable m_throwable;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ProgressThread(Dialog dialog, ProgressRunnable progressRunnable, JProgressBar jProgressBar) {
            this.m_dialog = dialog;
            this.m_runnable = progressRunnable;
            this.m_progressBar = jProgressBar;
        }

        public Throwable getThrowable() {
            return this.m_throwable;
        }

        public void run() {
            block5: {
                long l = System.currentTimeMillis();
                try {
                    this.m_runnable.run(this);
                }
                catch (Throwable throwable) {
                    this.m_throwable = throwable;
                }
                long l2 = System.currentTimeMillis() - l;
                if (l2 < 1000L) {
                    try {
                        Thread.sleep(1000L - l2);
                    }
                    catch (InterruptedException interruptedException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressThread.this.m_dialog.dispose();
                }
            });
        }

        public void showProgress(int n) {
            this.m_percent = n;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressThread.this.m_progressBar.setValue(ProgressThread.this.m_percent);
                }
            });
        }

        static {
            $assertionsDisabled = !(class$net$sf$gogui$gui$GuiUtils == null ? (class$net$sf$gogui$gui$GuiUtils = GuiUtils.class$("net.sf.gogui.gui.GuiUtils")) : class$net$sf$gogui$gui$GuiUtils).desiredAssertionStatus();
        }
    }

    public static interface ProgressRunnable {
        public void run(ProgressShow var1) throws Throwable;
    }
}

