;;; irchat-pj-modeline.el --- Mode line format definition for irchat-pj

;; Copyright (C) 2000 by Project Pure.

;; Author: SHIMADA Mitsunobu <simm@irc.fan.gr.jp>
;; Keywords: IRC, irchat-pj, mode-line-format

;; $Id: irchat-pj-modeline.el,v 1.7 2001/01/17 14:36:01 simm Exp $

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; 

;;; Code:

;; AWAY / FREEZE indicator: used as `mode-line-modified'
(defvar irchat-pj-modeline-global-status
  '((irchat-pj-away-p "A" "-")
    (irchat-freeze "F" "-"))
  "Global mode line setting, to display IRC status.
This variable is used as `mode-line-modified', in Commands/Dialogue/Others buffer.")
(defvar irchat-pj-modeline-local-status
  '((irchat-pj-away-p "A" "-")
    (irchat-freeze-local "F" "-")
    (irchat-beep-local "B" "-")
    (irchat-suppress-local "S" "-"))
  "Local mode line setting, to display IRC status.
This variable is used as `mode-line-modified', in Channel buffer.")

;; NICK / SERVER NAME / CHANNEL indicator: use as `mode-line-buffer-identification'
(defvar irchat-pj-modeline-Command-buffer
  '("irchat-pj: " irchat-nickname " <" irchat-servername "> " irchat-chanbuf-indicator)
  "Local mode line setting, to display IRC informations in Commands buffer.
This variable is used as `mode-line-buffer-identification'.")
(defvar irchat-pj-modeline-Dialogue-buffer
  '("" irchat-chanbufs-indicator)
  "Local mode setting, to display IRC informations in Dialogue buffer.
This variable is used as `mode-line-buffer-identification'.")
(defvar irchat-pj-modeline-Others-buffer
  '("" irchat-chanbufs-indicator)
  "Local mode setting, to display IRC informations in Others buffer.
This variable is used as `mode-line-buffer-identification'.")
(defvar irchat-pj-modeline-Channel-buffer
  '("irchat-pj: " irchat-chanbuf-indicator)
  "Local mode setting, to display IRC informations in Channel buffer.
This variable is used as `mode-line-buffer-identification'.")

;; set mode line
(defun irchat-pj-modeline-set (status buffer-info &optional user-define)
  "Set mode-line-format"
  ;; common behaviour
  (setq mode-line-modified              status
	mode-line-buffer-identification buffer-info)
  ;; to emulate older irchat-pj-modeline.el
  (and user-define
       (boundp user-define)
       (symbol-value user-define)
       (let ((candidate (symbol-value user-define)))
	 (if (not (symbolp candidate))
	     (setq mode-line-format candidate)
	   (if (boundp candidate)
	       (setq mode-line-format (symbol-value candidate)))))))

;; That's all
(provide 'irchat-pj-modeline)

;;; irchat-pj-modeline.el ends here
