/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.start.PropsException;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.UsageException;

public final class Props
implements Iterable<Prop> {
    public static final String ORIGIN_SYSPROP = "<system-property>";
    private Map<String, Prop> props = new TreeMap<String, Prop>(String.CASE_INSENSITIVE_ORDER);
    private List<String> sysPropTracking = new ArrayList<String>();

    public static String getValue(String arg) {
        int idx = arg.indexOf(61);
        if (idx == -1) {
            throw new UsageException(-6, "Argument is missing a required value: %s", arg);
        }
        String value = arg.substring(idx + 1).trim();
        if (value.length() <= 0) {
            throw new UsageException(-6, "Argument is missing a required value: %s", arg);
        }
        return value;
    }

    public static List<String> getValues(String arg) {
        String v = Props.getValue(arg);
        ArrayList<String> l = new ArrayList<String>();
        for (String s : v.split(",")) {
            if (s == null || (s = s.trim()).length() <= 0) continue;
            l.add(s);
        }
        return l;
    }

    public void addAll(Props other) {
        this.props.putAll(other.props);
        this.sysPropTracking.addAll(other.sysPropTracking);
    }

    public boolean addPossibleProperty(String arg, String source) {
        if (arg.startsWith("-D")) {
            String[] assign = arg.substring(2).split("=", 2);
            switch (assign.length) {
                case 2: {
                    this.setSystemProperty(assign[0], assign[1]);
                    this.setProperty(assign[0], assign[1], source);
                    return true;
                }
                case 1: {
                    this.setSystemProperty(assign[0], "");
                    this.setProperty(assign[0], "", source);
                    return true;
                }
            }
            return false;
        }
        int idx = arg.indexOf(61);
        if (idx >= 0) {
            String key = arg.substring(0, idx);
            String value = arg.substring(idx + 1);
            this.setProperty(key, value, source);
            return true;
        }
        return false;
    }

    public String cleanReference(String property) {
        String name = property.trim();
        if (name.startsWith("${") && name.endsWith("}")) {
            name = name.substring(2, name.length() - 1);
        }
        return name.trim();
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public String expand(String str) {
        return this.expand(str, new Stack<String>());
    }

    public String expand(String str, Stack<String> seenStack) {
        if (str == null) {
            return str;
        }
        if (str.indexOf("${") < 0) {
            return str;
        }
        Pattern pat = Pattern.compile("(?<=[^$]|^)(\\$\\{[^}]*\\})");
        Matcher mat = pat.matcher(str);
        StringBuilder expanded = new StringBuilder();
        int offset = 0;
        while (mat.find(offset)) {
            String property = this.cleanReference(mat.group(1));
            if (seenStack.contains(property)) {
                int idx;
                StringBuilder err = new StringBuilder();
                err.append("Property expansion loop detected: ");
                for (int i = idx = seenStack.lastIndexOf(property); i < seenStack.size(); ++i) {
                    err.append((String)seenStack.get(i));
                    err.append(" -> ");
                }
                err.append(property);
                throw new PropsException(err.toString());
            }
            seenStack.push(property);
            expanded.append(str.subSequence(offset, mat.start(1)));
            String value = this.getString(property);
            if (value == null) {
                StartLog.trace("Unable to expand: %s", property);
                expanded.append(mat.group(1));
            } else {
                value = this.expand(value, seenStack);
                expanded.append(value);
            }
            offset = mat.end(1);
        }
        expanded.append(str.substring(offset));
        if (expanded.indexOf("$$") >= 0) {
            return expanded.toString().replaceAll("\\$\\$", "\\$");
        }
        return expanded.toString();
    }

    public Prop getProp(String key) {
        return this.getProp(key, true);
    }

    public Prop getProp(String key, boolean searchSystemProps) {
        Prop prop = this.props.get(key);
        if (prop == null && searchSystemProps) {
            prop = this.getSystemProperty(key);
        }
        return prop;
    }

    public String getString(String key) {
        if (key == null) {
            throw new PropsException("Cannot get value for null key");
        }
        String name = this.cleanReference(key);
        if (name.length() == 0) {
            throw new PropsException("Cannot get value for empty key");
        }
        Prop prop = this.getProp(name);
        if (prop == null) {
            return null;
        }
        return prop.value;
    }

    public String getString(String key, String defVal) {
        String val = this.getString(key);
        if (val == null) {
            return defVal;
        }
        return val;
    }

    private Prop getSystemProperty(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            return null;
        }
        return new Prop(key, value, ORIGIN_SYSPROP);
    }

    public static boolean hasPropertyKey(String name) {
        return Pattern.compile("(?<=[^$]|^)(\\$\\{[^}]*\\})").matcher(name).find();
    }

    @Override
    public Iterator<Prop> iterator() {
        return this.props.values().iterator();
    }

    public void reset() {
        this.props.clear();
    }

    public void setProperty(Prop prop) {
        this.props.put(prop.key, prop);
    }

    public void setProperty(String key, String value, String origin) {
        Prop prop = this.props.get(key);
        prop = prop == null ? new Prop(key, value, origin) : new Prop(key, value, origin, prop);
        this.props.put(key, prop);
    }

    public int size() {
        return this.props.size();
    }

    public void store(OutputStream stream, String comments) throws IOException {
        Properties props = new Properties();
        for (Prop prop : this) {
            props.setProperty(prop.key, this.expand(prop.value));
        }
        props.store(stream, comments);
    }

    public void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
        this.sysPropTracking.add(key);
    }

    public static class Prop {
        public String key;
        public String value;
        public String origin;
        public Prop overrides;

        public Prop(String key, String value, String origin) {
            this.key = key;
            this.value = value;
            this.origin = origin;
        }

        public Prop(String key, String value, String origin, Prop overrides) {
            this(key, value, origin);
            this.overrides = overrides;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Prop [key=");
            builder.append(this.key);
            builder.append(", value=");
            builder.append(this.value);
            builder.append(", origin=");
            builder.append(this.origin);
            builder.append(", overrides=");
            builder.append(this.overrides);
            builder.append("]");
            return builder.toString();
        }
    }
}

