/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.ErrorFactory;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.metrics.JicofoMetricsContainer;
import org.jitsi.jicofo.visitors.VisitorsConfig;
import org.jitsi.jicofo.xmpp.ConferenceIqHandlerKt;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.VisitorsManager;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.XmppVisitorConnectionConfig;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.jwt.JitsiToken;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u00012\u00020\u0002:\u00016B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0016J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u0014\u0010/\u001a\u0004\u0018\u00010,2\b\u00100\u001a\u0004\u0018\u00010,H\u0016J,\u00101\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010.2\u0006\u00105\u001a\u00020\fH\u0002R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00067"}, d2={"Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Listener;", "Lorg/jivesoftware/smack/iqrequest/AbstractIqRequestHandler;", "xmppProvider", "Lorg/jitsi/jicofo/xmpp/XmppProvider;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "focusAuthJid", "", "authAuthority", "Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "jigasiEnabled", "", "visitorsManager", "Lorg/jitsi/jicofo/xmpp/VisitorsManager;", "(Lorg/jitsi/jicofo/xmpp/XmppProvider;Lorg/jitsi/jicofo/FocusManager;Ljava/lang/String;Lorg/jitsi/jicofo/auth/AuthenticationAuthority;ZLorg/jitsi/jicofo/xmpp/VisitorsManager;)V", "getAuthAuthority", "()Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "breakoutAddress", "Lorg/jxmpp/jid/DomainBareJid;", "connection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "getFocusAuthJid", "()Ljava/lang/String;", "getFocusManager", "()Lorg/jitsi/jicofo/FocusManager;", "getJigasiEnabled", "()Z", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getVisitorsManager", "()Lorg/jitsi/jicofo/xmpp/VisitorsManager;", "getXmppProvider", "()Lorg/jitsi/jicofo/xmpp/XmppProvider;", "componentsChanged", "", "components", "", "Lorg/jitsi/jicofo/xmpp/XmppProvider$Component;", "handleConferenceIq", "Lorg/jivesoftware/smack/packet/IQ;", "query", "Lorg/jitsi/xmpp/extensions/jitsimeet/ConferenceIq;", "handleIQRequest", "iqRequest", "processExtensions", "room", "Lorg/jxmpp/jid/EntityBareJid;", "response", "roomExists", "Companion", "jicofo"})
@SourceDebugExtension(value={"SMAP\nConferenceIqHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConferenceIqHandler.kt\norg/jitsi/jicofo/xmpp/ConferenceIqHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1755#2,3:284\n1755#2,3:287\n1#3:290\n*S KotlinDebug\n*F\n+ 1 ConferenceIqHandler.kt\norg/jitsi/jicofo/xmpp/ConferenceIqHandler\n*L\n110#1:284,3\n111#1:287,3\n*E\n"})
public final class ConferenceIqHandler
extends AbstractIqRequestHandler
implements XmppProvider.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final FocusManager focusManager;
    @NotNull
    private final String focusAuthJid;
    @Nullable
    private final AuthenticationAuthority authAuthority;
    private final boolean jigasiEnabled;
    @NotNull
    private final VisitorsManager visitorsManager;
    @NotNull
    private final AbstractXMPPConnection connection;
    @Nullable
    private DomainBareJid breakoutAddress;
    @NotNull
    private final Logger logger;
    @NotNull
    private static final CounterMetric conferenceRequestCounter = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"conference_requests", (String)"Number of conference requests received.", (long)0L, null, (int)12, null);
    @NotNull
    private static final CounterMetric newConferenceRequestCounter = MetricsContainer.registerCounter$default((MetricsContainer)((MetricsContainer)JicofoMetricsContainer.Companion.getInstance()), (String)"conference_requests_new", (String)"Number of conference requests received for new conferences.", (long)0L, null, (int)12, null);

    public ConferenceIqHandler(@NotNull XmppProvider xmppProvider, @NotNull FocusManager focusManager, @NotNull String focusAuthJid, @Nullable AuthenticationAuthority authAuthority, boolean jigasiEnabled, @NotNull VisitorsManager visitorsManager) {
        Intrinsics.checkNotNullParameter((Object)xmppProvider, (String)"xmppProvider");
        Intrinsics.checkNotNullParameter((Object)focusManager, (String)"focusManager");
        Intrinsics.checkNotNullParameter((Object)focusAuthJid, (String)"focusAuthJid");
        Intrinsics.checkNotNullParameter((Object)visitorsManager, (String)"visitorsManager");
        super("conference", "http://jitsi.org/protocol/focus", IQ.Type.set, IQRequestHandler.Mode.sync);
        this.xmppProvider = xmppProvider;
        this.focusManager = focusManager;
        this.focusAuthJid = focusAuthJid;
        this.authAuthority = authAuthority;
        this.jigasiEnabled = jigasiEnabled;
        this.visitorsManager = visitorsManager;
        this.connection = this.xmppProvider.getXmppConnection();
        this.logger = LoggerExtensionsKt.createLogger$default((Object)((Object)this), null, null, (int)3, null);
        this.xmppProvider.addListener((XmppProvider.Listener)this);
        this.registrationChanged(this.xmppProvider.getRegistered());
        this.componentsChanged(this.xmppProvider.getComponents());
    }

    @NotNull
    public final XmppProvider getXmppProvider() {
        return this.xmppProvider;
    }

    @NotNull
    public final FocusManager getFocusManager() {
        return this.focusManager;
    }

    @NotNull
    public final String getFocusAuthJid() {
        return this.focusAuthJid;
    }

    @Nullable
    public final AuthenticationAuthority getAuthAuthority() {
        return this.authAuthority;
    }

    public final boolean getJigasiEnabled() {
        return this.jigasiEnabled;
    }

    @NotNull
    public final VisitorsManager getVisitorsManager() {
        return this.visitorsManager;
    }

    @NotNull
    public final OrderedJsonObject getDebugState() {
        String string;
        String string2;
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u240).put("breakout_address", String.valueOf(this.breakoutAddress));
        ((Map)$this$_get_debugState__u24lambda_u240).put("focus_auth_jid", this.focusAuthJid);
        ((Map)$this$_get_debugState__u24lambda_u240).put("jigasi_enabled", this.jigasiEnabled);
        Map map = (Map)$this$_get_debugState__u24lambda_u240;
        String string3 = "auth_authority";
        Object object = this.authAuthority;
        String string4 = string2 = object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null;
        if (string4 == null) {
            string = "null";
        } else {
            Intrinsics.checkNotNull((Object)string4);
            string = string2;
        }
        string2 = string;
        map.put(string3, string2);
        return orderedJsonObject;
    }

    @NotNull
    public final IQ handleConferenceIq(@NotNull ConferenceIq query) {
        Unit unit;
        Object object;
        String vnode;
        boolean bl;
        boolean visitorSupported;
        JitsiMeetConference conference;
        ConferenceIq response;
        String groupId;
        String userId;
        EntityBareJid room;
        block21: {
            boolean bl2;
            block20: {
                IQ error;
                boolean roomExists;
                ConferenceIq conferenceIq;
                Intrinsics.checkNotNullParameter((Object)query, (String)"query");
                EntityBareJid entityBareJid = query.getRoom();
                if (entityBareJid == null) {
                    ErrorIQ errorIQ = IQ.createErrorResponse((IQ)((IQ)query), (StanzaError)StanzaError.from((StanzaError.Condition)StanzaError.Condition.bad_request, (String)"No 'room' specified.").build());
                    Intrinsics.checkNotNullExpressionValue((Object)errorIQ, (String)"createErrorResponse(...)");
                    return (IQ)errorIQ;
                }
                room = entityBareJid;
                JitsiToken token = ConferenceIqHandlerKt.access$parseToken(query.getToken());
                JitsiToken jitsiToken = token;
                userId = jitsiToken != null && (jitsiToken = jitsiToken.getContext()) != null && (jitsiToken = jitsiToken.getUser()) != null ? jitsiToken.getId() : null;
                JitsiToken jitsiToken2 = token;
                groupId = jitsiToken2 != null && (jitsiToken2 = jitsiToken2.getContext()) != null ? jitsiToken2.getGroup() : null;
                ConferenceIq $this$handleConferenceIq_u24lambda_u241 = conferenceIq = new ConferenceIq();
                boolean bl3 = false;
                $this$handleConferenceIq_u24lambda_u241.setType(IQ.Type.result);
                $this$handleConferenceIq_u24lambda_u241.setStanzaId(query.getStanzaId());
                $this$handleConferenceIq_u24lambda_u241.setFrom(query.getTo());
                $this$handleConferenceIq_u24lambda_u241.setTo(query.getFrom());
                $this$handleConferenceIq_u24lambda_u241.setRoom(query.getRoom());
                $this$handleConferenceIq_u24lambda_u241.setFocusJid(this.focusAuthJid);
                response = conferenceIq;
                this.logger.info((Object)("Conference request for room " + room + ", from " + query.getFrom() + ", token=" + (query.getToken() != null)));
                this.logger.debug(() -> ConferenceIqHandler.handleConferenceIq$lambda$2(userId, groupId));
                CounterMetric.inc$default((CounterMetric)conferenceRequestCounter, null, (int)1, null);
                conference = this.focusManager.getConference(room);
                boolean bl4 = roomExists = conference != null;
                if (!roomExists) {
                    CounterMetric.inc$default((CounterMetric)newConferenceRequestCounter, null, (int)1, null);
                    if (!Boolean.parseBoolean(query.getPropertiesMap().getOrDefault("rtcstatsEnabled", "true"))) {
                        this.logger.info((Object)("New room with rtcstats disabled: " + room));
                    }
                }
                if ((error = this.processExtensions(query, room, response, roomExists)) != null) {
                    return error;
                }
                List list = query.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ConferenceIq.Property it = (ConferenceIq.Property)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"visitors-version")) continue;
                        bl2 = true;
                        break block20;
                    }
                    bl2 = false;
                }
            }
            visitorSupported = bl2;
            List list = query.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConferenceIq.Property it = (ConferenceIq.Property)element$iv;
                    boolean bl6 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"visitor") && Intrinsics.areEqual((Object)it.getValue(), (Object)"true"))) continue;
                    bl = true;
                    break block21;
                }
                bl = false;
            }
        }
        boolean visitorRequested = bl;
        Ref.BooleanRef visitorsLive = new Ref.BooleanRef();
        JitsiMeetConference jitsiMeetConference = conference;
        visitorsLive.element = jitsiMeetConference != null && (jitsiMeetConference = jitsiMeetConference.getChatRoom()) != null ? jitsiMeetConference.getVisitorsLive() : false;
        this.logger.debug(() -> ConferenceIqHandler.handleConferenceIq$lambda$5(visitorSupported, visitorRequested, visitorsLive));
        if (visitorSupported && visitorRequested && VisitorsConfig.config.getEnableLiveRoom() && !visitorsLive.element) {
            this.logger.debug((Object)"Sending to queue");
            response.setReady(Boolean.valueOf(false));
            response.addProperty(new ConferenceIq.Property("live", "false"));
            return (IQ)response;
        }
        Map map = query.getPropertiesMap();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getPropertiesMap(...)");
        conference = FocusManager.conferenceRequest$default(this.focusManager, room, map, null, false, 12, null);
        response.setReady(Boolean.valueOf(conference.isStarted()));
        ChatRoom chatRoom = conference.getChatRoom();
        visitorsLive.element = chatRoom != null ? chatRoom.getVisitorsLive() : false;
        ChatRoom chatRoom2 = conference.getChatRoom();
        boolean allowedInMainRoom = chatRoom2 != null ? chatRoom2.isAllowedInMainRoom(userId, groupId) : false;
        ChatRoom chatRoom3 = conference.getChatRoom();
        boolean preferredInMainRoom = chatRoom3 != null ? chatRoom3.isPreferredInMainRoom(userId, groupId) : false;
        this.logger.debug(() -> ConferenceIqHandler.handleConferenceIq$lambda$6(allowedInMainRoom, preferredInMainRoom, visitorsLive));
        if (VisitorsConfig.config.getEnableLiveRoom() && !allowedInMainRoom && !visitorsLive.element && visitorSupported) {
            this.logger.debug((Object)"Sending to queue");
            response.setReady(Boolean.valueOf(false));
            response.addProperty(new ConferenceIq.Property("live", "false"));
            return (IQ)response;
        }
        String string = visitorSupported && this.visitorsManager.getEnabled() && !preferredInMainRoom ? conference.redirectVisitor(visitorRequested || !allowedInMainRoom, userId, groupId) : (vnode = null);
        if (this.visitorsManager.getEnabled() && !visitorSupported) {
            this.logger.info((Object)"Endpoint with no visitor support.");
        }
        if ((object = (XmppVisitorConnectionConfig)XmppConfig.Companion.getVisitors().get(vnode)) != null && (object = object.getJid()) != null) {
            Object it = object;
            boolean bl7 = false;
            this.logger.info((Object)("Redirecting to " + vnode));
            response.setVnode(vnode);
            response.setFocusJid((String)it);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            ConferenceIqHandler $this$handleConferenceIq_u24lambda_u248 = this;
            boolean bl8 = false;
            if (vnode != null) {
                $this$handleConferenceIq_u24lambda_u248.logger.error((Object)("No XmppConnectionConfig for vnode=" + vnode));
            }
        }
        if (this.authAuthority != null) {
            response.addProperty(new ConferenceIq.Property("authentication", "true"));
            response.addProperty(new ConferenceIq.Property("externalAuth", String.valueOf(this.authAuthority.isExternal())));
        } else {
            response.addProperty(new ConferenceIq.Property("authentication", "false"));
        }
        if (this.jigasiEnabled) {
            response.addProperty(new ConferenceIq.Property("sipGatewayEnabled", "true"));
        }
        return (IQ)response;
    }

    private final IQ processExtensions(ConferenceIq query, EntityBareJid room, ConferenceIq response, boolean roomExists) {
        boolean isBreakoutRoom;
        boolean bl = isBreakoutRoom = this.breakoutAddress != null && Intrinsics.areEqual((Object)room.getDomain(), (Object)this.breakoutAddress);
        if (!isBreakoutRoom && this.authAuthority != null) {
            IQ authErrorOrResponse = this.authAuthority.processAuthentication(query, response);
            if (authErrorOrResponse != null) {
                return authErrorOrResponse;
            }
            if (!roomExists && !this.focusManager.hasBreakoutRooms(room) && this.authAuthority.getUserIdentity(query.getFrom()) == null) {
                return ErrorFactory.createNotAuthorizedError((IQ)query, "not authorized user domain");
            }
        }
        return null;
    }

    @Nullable
    public IQ handleIQRequest(@Nullable IQ iqRequest) {
        if (!(iqRequest instanceof ConferenceIq)) {
            ErrorIQ errorIQ;
            ErrorIQ it = errorIQ = IQ.createErrorResponse((IQ)iqRequest, (StanzaError)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).build());
            boolean bl = false;
            this.logger.error((Object)("Received an unexpected IQ type: " + iqRequest));
            return (IQ)errorIQ;
        }
        Jid originalFrom = ((ConferenceIq)iqRequest).getFrom();
        ConferenceIq conferenceIq = (ConferenceIq)iqRequest;
        DomainBareJid domainBareJid = XmppConfig.client.getClientProxy();
        Intrinsics.checkNotNull((Object)originalFrom);
        conferenceIq.setFrom(UtilKt.parseJidFromClientProxyJid((DomainBareJid)domainBareJid, (Jid)originalFrom));
        TaskPools.Companion.getIoPool().execute(() -> ConferenceIqHandler.handleIQRequest$lambda$11(this, iqRequest, originalFrom));
        return null;
    }

    public void componentsChanged(@NotNull Set<XmppProvider.Component> components) {
        DomainBareJid domainBareJid;
        String address;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter(components, (String)"components");
            Iterable iterable = components;
            for (Object t : iterable) {
                XmppProvider.Component it = (XmppProvider.Component)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"breakout_rooms")) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        XmppProvider.Component component = v0;
        String string = address = component != null ? component.getAddress() : null;
        if (address == null) {
            this.logger.info((Object)"No breakout room component discovered.");
            domainBareJid = null;
        } else {
            this.logger.info((Object)("Using breakout room component at " + address + "."));
            domainBareJid = JidCreate.domainBareFrom((String)address);
        }
        this.breakoutAddress = domainBareJid;
    }

    public void registrationChanged(boolean registered) {
        XmppProvider.Listener.DefaultImpls.registrationChanged((XmppProvider.Listener)this, (boolean)registered);
    }

    private static final String handleConferenceIq$lambda$2(String $userId, String $groupId) {
        return "User ID: " + $userId + ", Group ID: " + $groupId;
    }

    private static final String handleConferenceIq$lambda$5(boolean $visitorSupported, boolean $visitorRequested, Ref.BooleanRef $visitorsLive) {
        Intrinsics.checkNotNullParameter((Object)$visitorsLive, (String)"$visitorsLive");
        return "visitorSupported=" + $visitorSupported + ", visitorRequested=" + $visitorRequested + ", visitorsLive=" + $visitorsLive.element;
    }

    private static final String handleConferenceIq$lambda$6(boolean $allowedInMainRoom, boolean $preferredInMainRoom, Ref.BooleanRef $visitorsLive) {
        Intrinsics.checkNotNullParameter((Object)$visitorsLive, (String)"$visitorsLive");
        return "allowedInMainRoom=" + $allowedInMainRoom + ", preferredInMainRoom=" + $preferredInMainRoom + ", visitorsLive=" + $visitorsLive.element;
    }

    private static final void handleIQRequest$lambda$11(ConferenceIqHandler this$0, IQ $iqRequest, Jid $originalFrom) {
        IQ iQ;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        IQ $this$handleIQRequest_u24lambda_u2411_u24lambda_u2410 = iQ = this$0.handleConferenceIq((ConferenceIq)$iqRequest);
        boolean bl = false;
        $this$handleIQRequest_u24lambda_u2411_u24lambda_u2410.setTo($originalFrom);
        IQ response = iQ;
        try {
            this$0.connection.sendStanza((Stanza)response);
        }
        catch (Exception e) {
            this$0.logger.error((Object)"Failed to send response", (Throwable)e);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler$Companion;", "", "()V", "conferenceRequestCounter", "Lorg/jitsi/metrics/CounterMetric;", "getConferenceRequestCounter", "()Lorg/jitsi/metrics/CounterMetric;", "newConferenceRequestCounter", "getNewConferenceRequestCounter", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CounterMetric getConferenceRequestCounter() {
            return conferenceRequestCounter;
        }

        @NotNull
        public final CounterMetric getNewConferenceRequestCounter() {
            return newConferenceRequestCounter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

