/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xdata.form;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.xdata.AbstractMultiFormField;
import org.jivesoftware.smackx.xdata.AbstractSingleStringValueFormField;
import org.jivesoftware.smackx.xdata.BooleanFormField;
import org.jivesoftware.smackx.xdata.FormField;
import org.jxmpp.util.XmppDateTime;

public interface FormReader {
    public FormField getField(String var1);

    default public String readFirstValue(String fieldName) {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            return null;
        }
        return formField.getFirstValue();
    }

    default public List<? extends CharSequence> readValues(String fieldName) {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            return Collections.emptyList();
        }
        return formField.getValues();
    }

    default public List<String> readStringValues(String fieldName) {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            return Collections.emptyList();
        }
        AbstractMultiFormField multiFormField = formField.ifPossibleAs(AbstractMultiFormField.class);
        List<? extends CharSequence> charSequences = multiFormField.getValues();
        return StringUtils.toStrings(charSequences);
    }

    default public Boolean readBoolean(String fieldName) {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            return null;
        }
        BooleanFormField booleanFormField = formField.ifPossibleAs(BooleanFormField.class);
        return booleanFormField.getValueAsBoolean();
    }

    default public Integer readInteger(String fieldName) {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            return null;
        }
        AbstractSingleStringValueFormField textSingleFormField = formField.ifPossibleAs(AbstractSingleStringValueFormField.class);
        return textSingleFormField.getValueAsInt();
    }

    default public Date readDate(String fieldName) throws ParseException {
        FormField formField = this.getField(fieldName);
        if (formField == null) {
            return null;
        }
        AbstractSingleStringValueFormField textSingleFormField = formField.ifPossibleAs(AbstractSingleStringValueFormField.class);
        String value = textSingleFormField.getValue();
        if (value == null) {
            return null;
        }
        return XmppDateTime.parseDate((String)value);
    }
}

