/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.TimeUtils;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a\u000e\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u000e\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001f\u001a\u0016\u0010 \u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001\u001a\u0016\u0010#\u001a\u00020\u00012\u0006\u0010!\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0001\u001a\u001a\u0010$\u001a\u00020\u0001*\u00020\u00012\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u0001\u001a\u0015\u0010'\u001a\u00020\u001f*\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010'\u001a\u00020\u0001*\u00020\u00012\u0006\u0010(\u001a\u00020\u001fH\u0086\u0002\u001a\u0015\u0010'\u001a\u00020\u0001*\u00020\u00012\u0006\u0010(\u001a\u00020\u000eH\u0086\u0002\u001a\n\u0010)\u001a\u00020**\u00020\u0001\u001a\n\u0010+\u001a\u00020,*\u00020\u0001\u001a\n\u0010-\u001a\u00020,*\u00020\u0001\u001a\u0012\u0010.\u001a\u00020\u0001*\u00020\u00012\u0006\u0010/\u001a\u00020\u0001\u001a\u0012\u00100\u001a\u00020\u0001*\u00020\u00012\u0006\u0010/\u001a\u00020\u0001\u001a\u0012\u00101\u001a\u00020\u0001*\u00020\u00012\u0006\u0010/\u001a\u00020\u0001\u001a*\u00102\u001a\u00020\u0001\"\u0004\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H3042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u0002H3\u0012\u0004\u0012\u00020\u000106\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u0010(\u001a\u00020\u001fH\u0086\u0002\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u00108\u001a\u00020\u0005H\u0086\u0002\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u00012\u0006\u00108\u001a\u00020\u000eH\u0086\u0002\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u001f2\u0006\u0010(\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u00052\u0006\u00108\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u00107\u001a\u00020\u0001*\u00020\u000e2\u0006\u00108\u001a\u00020\u0001H\u0086\u0002\u001a\n\u00109\u001a\u00020\u001f*\u00020\u0001\u001a\n\u0010:\u001a\u00020\u001f*\u00020\u0001\u001a\n\u0010;\u001a\u00020\u000e*\u00020\u0001\u001a\n\u0010<\u001a\u00020\u000e*\u00020\u0001\u001a\n\u0010=\u001a\u00020\u000e*\u00020\u0001\u001a\r\u0010>\u001a\u00020\u0001*\u00020\u0001H\u0086\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0015\u0010\u000b\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000f\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\r\"\u0015\u0010\u0010\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\"\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\r\"\u0015\u0010\u0012\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\"\u0015\u0010\u0014\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\r\"\u0015\u0010\u0014\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000f\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\"\u0015\u0010\u0016\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000f\"\u0015\u0010\u0018\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\"\u0015\u0010\u0018\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\"\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\r\"\u0015\u0010\u001a\u001a\u00020\u0001*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000f\u00a8\u0006?"}, d2={"MAX_DURATION", "Ljava/time/Duration;", "getMAX_DURATION", "()Ljava/time/Duration;", "MICROS_PER_SECOND", "", "MIN_DURATION", "getMIN_DURATION", "NANOS_PER_MICRO", "NANOS_PER_MILLI", "NANOS_PER_SECOND", "days", "getDays", "(I)Ljava/time/Duration;", "", "(J)Ljava/time/Duration;", "hours", "getHours", "micros", "getMicros", "mins", "getMins", "ms", "getMs", "nanos", "getNanos", "secs", "getSecs", "abs", "duration", "durationOfDoubleSeconds", "", "max", "a", "b", "min", "coerceIn", "minimumValue", "maximumValue", "div", "other", "formatMilli", "", "isFinite", "", "isInfinite", "roundDownTo", "resolution", "roundTo", "roundUpTo", "sumOf", "T", "", "selector", "Lkotlin/Function1;", "times", "x", "toDouble", "toDoubleMillis", "toMicros", "toRoundedMicros", "toRoundedMillis", "unaryMinus", "jitsi-utils"})
public final class DurationKt {
    private static final int NANOS_PER_MICRO = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MICROS_PER_SECOND = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;
    @NotNull
    private static final Duration MIN_DURATION;
    @NotNull
    private static final Duration MAX_DURATION;

    @NotNull
    public static final Duration getNanos(int $this$nanos) {
        Duration duration = Duration.ofNanos($this$nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMicros(int $this$micros) {
        Duration duration = Duration.of($this$micros, ChronoUnit.MICROS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMs(int $this$ms) {
        Duration duration = Duration.ofMillis($this$ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @NotNull
    public static final Duration getSecs(int $this$secs) {
        Duration duration = Duration.ofSeconds($this$secs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return duration;
    }

    @NotNull
    public static final Duration getHours(int $this$hours) {
        Duration duration = Duration.ofHours($this$hours);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMins(int $this$mins) {
        Duration duration = Duration.ofMinutes($this$mins);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return duration;
    }

    @NotNull
    public static final Duration getDays(int $this$days) {
        Duration duration = Duration.ofDays($this$days);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        return duration;
    }

    @NotNull
    public static final Duration getNanos(long $this$nanos) {
        Duration duration = Duration.ofNanos($this$nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMicros(long $this$micros) {
        Duration duration = Duration.of($this$micros, ChronoUnit.MICROS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMs(long $this$ms) {
        Duration duration = Duration.ofMillis($this$ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @NotNull
    public static final Duration getSecs(long $this$secs) {
        Duration duration = Duration.ofSeconds($this$secs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return duration;
    }

    @NotNull
    public static final Duration getHours(long $this$hours) {
        Duration duration = Duration.ofHours($this$hours);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMins(long $this$mins) {
        Duration duration = Duration.ofMinutes($this$mins);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return duration;
    }

    @NotNull
    public static final Duration getDays(long $this$days) {
        Duration duration = Duration.ofDays($this$days);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, int x) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Duration duration = $this$times.multipliedBy(x);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, long x) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Duration duration = $this$times.multipliedBy(x);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(int $this$times, @NotNull Duration x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Duration duration = x.multipliedBy($this$times);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(long $this$times, @NotNull Duration x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Duration duration = x.multipliedBy($this$times);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    public static final double div(@NotNull Duration $this$div, @NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (double)$this$div.toNanos() / (double)other.toNanos();
    }

    public static final long toRoundedMillis(@NotNull Duration $this$toRoundedMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$toRoundedMillis, (String)"<this>");
        long millis = $this$toRoundedMillis.toMillis();
        int remainder = $this$toRoundedMillis.getNano() % 1000000;
        if (remainder > 499999) {
            long l = millis;
            millis = l + 1L;
        }
        return millis;
    }

    public static final long toMicros(@NotNull Duration $this$toMicros) {
        Intrinsics.checkNotNullParameter((Object)$this$toMicros, (String)"<this>");
        long tempSeconds = $this$toMicros.getSeconds();
        long tempNanos = $this$toMicros.getNano();
        if (tempSeconds < 0L) {
            ++tempSeconds;
            tempNanos -= (long)1000000000;
        }
        long micros = Math.multiplyExact(tempSeconds, 1000000);
        micros = Math.addExact(micros, tempNanos / (long)1000);
        return micros;
    }

    public static final long toRoundedMicros(@NotNull Duration $this$toRoundedMicros) {
        Intrinsics.checkNotNullParameter((Object)$this$toRoundedMicros, (String)"<this>");
        long micros = DurationKt.toMicros($this$toRoundedMicros);
        int remainder = $this$toRoundedMicros.getNano() % 1000;
        if (remainder > 499) {
            long l = micros;
            micros = l + 1L;
        }
        return micros;
    }

    public static final double toDouble(@NotNull Duration $this$toDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$toDouble, (String)"<this>");
        return (double)$this$toDouble.getSeconds() + (double)$this$toDouble.getNano() * 1.0E-9;
    }

    public static final double toDoubleMillis(@NotNull Duration $this$toDoubleMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$toDoubleMillis, (String)"<this>");
        long sec = $this$toDoubleMillis.getSeconds();
        int nano = $this$toDoubleMillis.getNano();
        return (double)sec * 1000.0 + (double)nano * 1.0E-6;
    }

    @NotNull
    public static final Duration durationOfDoubleSeconds(double duration) {
        double secs = Math.floor(duration);
        double ns = Math.rint((duration - secs) * 1.0E9);
        if (!(secs >= -9.223372036854776E18 && secs <= 9.223372036854776E18)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Duration duration2 = Duration.ofSeconds((long)secs, (long)ns);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        return duration2;
    }

    @NotNull
    public static final Duration getMIN_DURATION() {
        return MIN_DURATION;
    }

    @NotNull
    public static final Duration getMAX_DURATION() {
        return MAX_DURATION;
    }

    public static final boolean isFinite(@NotNull Duration $this$isFinite) {
        Intrinsics.checkNotNullParameter((Object)$this$isFinite, (String)"<this>");
        return !Intrinsics.areEqual((Object)$this$isFinite, (Object)MIN_DURATION) && !Intrinsics.areEqual((Object)$this$isFinite, (Object)MAX_DURATION);
    }

    public static final boolean isInfinite(@NotNull Duration $this$isInfinite) {
        Intrinsics.checkNotNullParameter((Object)$this$isInfinite, (String)"<this>");
        return !DurationKt.isFinite($this$isInfinite);
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, double other) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        return DurationKt.durationOfDoubleSeconds(DurationKt.toDouble($this$times) * other);
    }

    @NotNull
    public static final Duration times(double $this$times, @NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return DurationKt.durationOfDoubleSeconds(DurationKt.toDouble(other) * $this$times);
    }

    @NotNull
    public static final Duration div(@NotNull Duration $this$div, double other) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        return DurationKt.durationOfDoubleSeconds(DurationKt.toDouble($this$div) / other);
    }

    @NotNull
    public static final Duration div(@NotNull Duration $this$div, long other) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Duration duration = $this$div.dividedBy(other);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"dividedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration unaryMinus(@NotNull Duration $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        Duration duration = $this$unaryMinus.negated();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"negated(...)");
        return duration;
    }

    @NotNull
    public static final Duration abs(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return duration.compareTo(Duration.ZERO) >= 0 ? duration : DurationKt.unaryMinus(duration);
    }

    @NotNull
    public static final <T> Duration sumOf(@NotNull Iterable<? extends T> $this$sumOf, @NotNull Function1<? super T, Duration> selector) {
        Intrinsics.checkNotNullParameter($this$sumOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        Duration sum = duration;
        for (T element : $this$sumOf) {
            Intrinsics.checkNotNullExpressionValue((Object)sum.plus((Duration)selector.invoke(element)), (String)"plus(...)");
        }
        return sum;
    }

    @NotNull
    public static final Duration max(@NotNull Duration a, @NotNull Duration b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.compareTo(b) >= 0 ? a : b;
    }

    @NotNull
    public static final Duration min(@NotNull Duration a, @NotNull Duration b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return a.compareTo(b) <= 0 ? a : b;
    }

    @NotNull
    public static final Duration coerceIn(@NotNull Duration $this$coerceIn, @NotNull Duration minimumValue, @NotNull Duration maximumValue) {
        Intrinsics.checkNotNullParameter((Object)$this$coerceIn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)minimumValue, (String)"minimumValue");
        Intrinsics.checkNotNullParameter((Object)maximumValue, (String)"maximumValue");
        if (minimumValue.compareTo(maximumValue) > 0) {
            throw new IllegalArgumentException("Cannot coerce value to an empty range:  maximum " + maximumValue + " is less than minimum " + minimumValue + ".");
        }
        if ($this$coerceIn.compareTo(minimumValue) < 0) {
            return minimumValue;
        }
        if ($this$coerceIn.compareTo(maximumValue) > 0) {
            return maximumValue;
        }
        return $this$coerceIn;
    }

    @NotNull
    public static final Duration roundTo(@NotNull Duration $this$roundTo, @NotNull Duration resolution) {
        Intrinsics.checkNotNullParameter((Object)$this$roundTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        if (!DurationKt.isFinite($this$roundTo)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!DurationKt.isFinite(resolution)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(resolution.compareTo(Duration.ZERO) > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Duration duration = Duration.ofNanos(($this$roundTo.toNanos() + resolution.toNanos() / (long)2) / resolution.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return DurationKt.times(duration, resolution.toNanos());
    }

    @NotNull
    public static final Duration roundUpTo(@NotNull Duration $this$roundUpTo, @NotNull Duration resolution) {
        Intrinsics.checkNotNullParameter((Object)$this$roundUpTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        if (!DurationKt.isFinite($this$roundUpTo)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!DurationKt.isFinite(resolution)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(resolution.compareTo(Duration.ZERO) > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Duration duration = Duration.ofNanos(($this$roundUpTo.toNanos() + resolution.toNanos() - 1L) / resolution.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return DurationKt.times(duration, resolution.toNanos());
    }

    @NotNull
    public static final Duration roundDownTo(@NotNull Duration $this$roundDownTo, @NotNull Duration resolution) {
        Intrinsics.checkNotNullParameter((Object)$this$roundDownTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
        if (!DurationKt.isFinite($this$roundDownTo)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!DurationKt.isFinite(resolution)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(resolution.compareTo(Duration.ZERO) > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Duration duration = Duration.ofNanos($this$roundDownTo.toNanos() / resolution.toNanos());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return DurationKt.times(duration, resolution.toNanos());
    }

    @NotNull
    public static final String formatMilli(@NotNull Duration $this$formatMilli) {
        Intrinsics.checkNotNullParameter((Object)$this$formatMilli, (String)"<this>");
        String string = TimeUtils.formatTimeAsFullMillis($this$formatMilli.getSeconds(), $this$formatMilli.getNano());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatTimeAsFullMillis(...)");
        return string;
    }

    static {
        Duration duration = Duration.ofSeconds(Long.MIN_VALUE, 0L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        MIN_DURATION = duration;
        Duration duration2 = Duration.ofSeconds(Long.MAX_VALUE, 999999999L);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
        MAX_DURATION = duration2;
    }
}

