/*
 * Decompiled with CFR 0.152.
 */
package free.jin.board;

import free.chess.AbstractChessClock;
import free.chess.Chess;
import free.chess.ChessMove;
import free.chess.JChessClock;
import free.chess.Move;
import free.chess.Player;
import free.chess.Position;
import free.chess.WildVariant;
import free.chess.event.MoveEvent;
import free.chess.event.MoveListener;
import free.jin.Game;
import free.jin.I18n;
import free.jin.board.BoardManager;
import free.jin.board.ExaminedGameButtonPanel;
import free.jin.board.JinBoard;
import free.jin.board.PlayedGameButtonPanel;
import free.jin.board.event.UserMoveEvent;
import free.jin.board.event.UserMoveListener;
import free.jin.event.BoardFlipEvent;
import free.jin.event.ClockAdjustmentEvent;
import free.jin.event.GameEndEvent;
import free.jin.event.GameListener;
import free.jin.event.GameStartEvent;
import free.jin.event.IllegalMoveEvent;
import free.jin.event.MoveMadeEvent;
import free.jin.event.OfferEvent;
import free.jin.event.PositionChangedEvent;
import free.jin.event.TakebackEvent;
import free.util.PlatformUtils;
import free.util.SquareLayout;
import free.util.Utilities;
import free.util.models.BooleanModel;
import free.util.models.ModelUtils;
import free.util.swing.FullscreenPanel;
import free.util.swing.NonEditableTableModel;
import free.util.swing.SwingUtils;
import free.workarounds.FixedJPanel;
import free.workarounds.FixedJTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class BoardPanel
extends FixedJPanel
implements MoveListener,
GameListener,
AdjustmentListener,
PropertyChangeListener {
    protected final BoardManager boardManager;
    protected final Game game;
    private boolean isActive = true;
    protected boolean isFlipped = false;
    protected JinBoard board;
    private boolean highlightOwnMoves;
    private int moveSendingMode;
    protected final Vector madeMoves = new Vector();
    protected final Position realPosition;
    protected int displayedMoveNumber = 0;
    protected JLabel whiteLabel;
    protected JLabel blackLabel;
    protected JPanel buttonPanel;
    protected JToggleButton fullscreenButton;
    protected AbstractChessClock whiteClock;
    protected AbstractChessClock blackClock;
    protected JLabel gameLabel;
    protected JTable moveListTable;
    private boolean isMoveListTableSelectionUpdating = false;
    private boolean settingMoveListTableSelection = false;
    protected TableModel moveListTableModel;
    protected JScrollPane moveListTableScrollPane;
    protected JScrollBar positionScrollBar;
    protected boolean isPositionScrollBarUpdating = false;
    protected boolean isBoardPositionUpdating = false;
    private Move moveEnRoute = null;
    private Move queuedMove = null;
    private long sentMoveTimestamp = -1L;
    private final FullscreenPanel fullscreenPanel;
    private final ContentPanel contentPanel;

    public BoardPanel(BoardManager boardManager, Game game) {
        this.game = game;
        this.boardManager = boardManager;
        this.realPosition = game.getInitialPosition();
        boardManager.addPropertyChangeListener(this);
        game.addPropertyChangeListener((PropertyChangeListener)this);
        this.contentPanel = new ContentPanel();
        this.fullscreenPanel = new FullscreenPanel((Component)((Object)this.contentPanel));
        this.fullscreenPanel.setAllowExclusiveMode(false);
        this.init(game);
        this.setLayout(new BorderLayout());
        this.add((Component)this.fullscreenPanel, "Center");
        if (!PlatformUtils.isJavaBetterThan((String)"1.4") || PlatformUtils.isMacOSX() && !PlatformUtils.isJavaBetterThan((String)"1.4.2") || System.getSecurityManager() != null && PlatformUtils.isJavaBetterThan((String)"1.5")) {
            this.fullscreenButton.setEnabled(false);
            this.fullscreenButton.setToolTipText(I18n.get((Class)BoardPanel.class).getString("fullscreenUnavailableMessage"));
        } else {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            this.contentPanel.registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BoardPanel.this.fullscreenPanel.getFullscreenModeModel().flip();
                }
            }, keyStroke, 0);
        }
    }

    public void addUserMoveListener(UserMoveListener userMoveListener) {
        this.listenerList.add(UserMoveListener.class, userMoveListener);
    }

    public void removeUserMoveListener(UserMoveListener userMoveListener) {
        this.listenerList.remove(UserMoveListener.class, userMoveListener);
    }

    protected void fireUserMadeMove(UserMoveEvent userMoveEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$board$event$UserMoveListener == null ? BoardPanel.class$("free.jin.board.event.UserMoveListener") : class$free$jin$board$event$UserMoveListener)) continue;
            UserMoveListener userMoveListener = (UserMoveListener)objectArray[i + 1];
            userMoveListener.userMadeMove(userMoveEvent);
        }
    }

    protected void init(Game game) {
        this.isFlipped = game.isBoardInitiallyFlipped();
        this.highlightOwnMoves = this.boardManager.isHighlightingOwnMoves();
        this.moveSendingMode = this.boardManager.getMoveSendingMode();
        this.createComponents(game);
    }

    protected void createComponents(Game game) {
        this.board = this.createBoard(game);
        this.initBoard(game, this.board);
        this.board.getPosition().addMoveListener((MoveListener)this);
        this.gameLabel = this.createGameLabel(game);
        this.whiteLabel = this.createWhiteLabel(game);
        this.blackLabel = this.createBlackLabel(game);
        this.fullscreenButton = this.createFullscreenButton();
        this.whiteClock = this.createWhiteClock(game);
        this.blackClock = this.createBlackClock(game);
        this.buttonPanel = this.createButtonPanel(game);
        this.moveListTableModel = this.createMoveListTableModel(game);
        this.moveListTable = this.createMoveListTable(game, this.moveListTableModel);
        this.moveListTableScrollPane = this.createMoveListTableScrollPane(game, this.moveListTable);
        OtherPluginsPauser otherPluginsPauser = new OtherPluginsPauser();
        this.board.addMouseListener(otherPluginsPauser);
        this.board.addMouseMotionListener(otherPluginsPauser);
        this.moveListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BoardPanel.this.moveListTableSelectionChanged();
            }
        });
        this.moveListTable.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                BoardPanel.this.moveListTableSelectionChanged();
            }
        });
        this.positionScrollBar = this.createPositionScrollBar();
        this.positionScrollBar.addAdjustmentListener(this);
        this.updateClockActiveness();
    }

    protected JinBoard createBoard(Game game) {
        return new JinBoard(game.getInitialPosition());
    }

    protected void initBoard(Game game, JinBoard jinBoard) {
        if (this.isFlipped()) {
            jinBoard.setFlipped(true);
        }
        this.configureBoardFromGame(game, jinBoard);
        this.configureBoardFromBoardManager(jinBoard);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JinBoard jinBoard = BoardPanel.this.board;
                if (jinBoard.isMovingPiece()) {
                    jinBoard.cancelMovingPiece();
                } else if (BoardPanel.this.queuedMove != null) {
                    BoardPanel.this.setQueuedMove(null);
                    BoardPanel.this.isBoardPositionUpdating = true;
                    jinBoard.getPosition().copyFrom(BoardPanel.this.realPosition);
                    if (BoardPanel.this.isMoveEnRoute()) {
                        jinBoard.getPosition().makeMove(BoardPanel.this.moveEnRoute);
                    }
                    BoardPanel.this.isBoardPositionUpdating = false;
                } else {
                    BoardPanel.this.fullscreenPanel.getFullscreenModeModel().setOff();
                }
            }
        };
        this.contentPanel.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 16), 0);
        this.contentPanel.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(27, 0), 0);
        jinBoard.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!BoardPanel.this.contentPanel.hasFocus()) {
                    BoardPanel.this.contentPanel.requestFocus();
                }
            }
        });
        if (!this.isUserTurn() && this.moveSendingMode == 1) {
            jinBoard.setEditable(false);
        }
    }

    protected void configureBoardFromGame(Game game, JinBoard jinBoard) {
        jinBoard.setMoveInputMode(this.calcMoveInputMode(game));
    }

    protected void configureBoardFromBoardManager(JinBoard jinBoard) {
        jinBoard.setPiecePainter(this.boardManager.getPiecePainter());
        jinBoard.setBoardPainter(this.boardManager.getBoardPainter());
        jinBoard.setMoveInputStyle(this.boardManager.getMoveInputStyle());
        jinBoard.setPieceFollowsCursor(this.boardManager.isPieceFollowsCursor());
        jinBoard.setHighlightMadeMoveSquares(this.boardManager.isHighlightMadeMoveSquares());
        jinBoard.setMadeMoveSquaresHighlightColor(this.boardManager.getMadeMoveSquaresHighlightColor());
        jinBoard.setMoveHighlightingStyle(this.boardManager.getMoveHighlightingStyle());
        jinBoard.setCoordsDisplayStyle(this.boardManager.getCoordsDisplayStyle());
        jinBoard.setCoordsDisplayColor(this.boardManager.getCoordsDisplayColor());
        jinBoard.setManualPromote(!this.boardManager.isAutoPromote());
        jinBoard.setMoveHighlightingColor(this.boardManager.getMoveHighlightingColor());
    }

    protected int calcMoveInputMode(Game game) {
        if (game.getGameType() == 1) {
            if (game.isPlayed()) {
                if (game.getUserPlayer() == Player.WHITE_PLAYER) {
                    return 1;
                }
                return 2;
            }
            return 4;
        }
        return 0;
    }

    protected JLabel createGameLabel(Game game) {
        JLabel jLabel = new JLabel(this.createGameLabelText(game));
        jLabel.setFont(new Font("SansSerif", 0, 20));
        return jLabel;
    }

    protected String createGameLabelText(Game game) {
        WildVariant wildVariant = game.getVariant();
        String string = wildVariant.equals(Chess.getInstance()) ? game.getRatingCategoryString() : wildVariant.getName();
        I18n i18n = I18n.get((Class)BoardPanel.class);
        return i18n.getFormattedString("gameLabelFormat", new Object[]{game.isRated() ? i18n.getString("rated") : i18n.getString("unrated"), game.getTCString(), string});
    }

    protected JLabel createWhiteLabel(Game game) {
        JLabel jLabel = new JLabel(this.createWhiteLabelText(game));
        jLabel.setFont(new Font("SansSerif", 1, 20));
        return jLabel;
    }

    protected String createWhiteLabelText(Game game) {
        return game.getWhiteName() + game.getWhiteTitles() + " " + game.getWhiteRating();
    }

    protected JLabel createBlackLabel(Game game) {
        JLabel jLabel = new JLabel(this.createBlackLabelText(game));
        jLabel.setFont(new Font("SansSerif", 1, 20));
        return jLabel;
    }

    protected String createBlackLabelText(Game game) {
        return game.getBlackName() + game.getBlackTitles() + " " + game.getBlackRating();
    }

    protected JToggleButton createFullscreenButton() {
        I18n i18n = I18n.get((Class)BoardPanel.class);
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setRequestFocusEnabled(false);
        jToggleButton.setToolTipText(i18n.getString("fullscreenButton.tooltip"));
        Class clazz = BoardPanel.class;
        SwingUtils.makeIconButton((AbstractButton)jToggleButton, (Icon)new ImageIcon(clazz.getResource("images/view-fullscreen.png")), (Icon)new ImageIcon(clazz.getResource("images/view-fullscreen-rollover.png")), (Icon)new ImageIcon(clazz.getResource("images/view-fullscreen-pressed.png")));
        ModelUtils.link((BooleanModel)this.fullscreenPanel.getFullscreenModeModel(), (ButtonModel)jToggleButton.getModel());
        return jToggleButton;
    }

    protected AbstractChessClock createWhiteClock(Game game) {
        return new JChessClock(game.getWhiteTime());
    }

    protected AbstractChessClock createBlackClock(Game game) {
        return new JChessClock(game.getBlackTime());
    }

    protected JPanel createButtonPanel(Game game) {
        if (game.getGameType() != 1) {
            return null;
        }
        JPanel jPanel = game.isPlayed() ? this.createPlayedGameButtonPanel(game) : this.createExaminedGameButtonPanel(game);
        return jPanel;
    }

    protected JPanel createPlayedGameButtonPanel(Game game) {
        return new PlayedGameButtonPanel(this.boardManager, game, (Component)((Object)this.contentPanel));
    }

    protected JPanel createExaminedGameButtonPanel(Game game) {
        return new ExaminedGameButtonPanel(this.boardManager, game);
    }

    protected TableModel createMoveListTableModel(Game game) {
        I18n i18n = I18n.get((Class)BoardPanel.class);
        return new NonEditableTableModel((Object[])new String[]{i18n.getString("moveListTable.moveNo"), i18n.getString("moveListTable.white"), i18n.getString("moveListTable.black")}, 0);
    }

    protected JTable createMoveListTable(Game game, TableModel tableModel) {
        FixedJTable fixedJTable = new FixedJTable(tableModel);
        fixedJTable.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        fixedJTable.setCellSelectionEnabled(true);
        fixedJTable.getTableHeader().setPreferredSize(new Dimension(150, 18));
        fixedJTable.getTableHeader().setReorderingAllowed(false);
        fixedJTable.setSelectionMode(0);
        fixedJTable.setRequestFocusEnabled(false);
        return fixedJTable;
    }

    protected JScrollPane createMoveListTableScrollPane(Game game, JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        return jScrollPane;
    }

    protected void addMoveToListTable(Move move) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.moveListTableModel;
        int n = this.game.getPliesSinceStart() / 2;
        int n2 = this.moveListTable.getRowCount();
        if (n2 == 0 || move.getPlayer().isWhite()) {
            defaultTableModel.setNumRows(++n2);
            defaultTableModel.setValueAt(n2 + n + ".", n2 - 1, 0);
        }
        if (move.getPlayer().isWhite()) {
            defaultTableModel.setValueAt(move, n2 - 1, 1);
        } else {
            defaultTableModel.setValueAt(move, n2 - 1, 2);
        }
        if (this.displayedMoveNumber == 0) {
            this.moveListTable.clearSelection();
            this.positionScrollBar.setValues(0, 1, 0, this.madeMoves.size() + 1);
        } else {
            boolean bl = ((Move)this.madeMoves.elementAt(0)).getPlayer().isBlack();
            int n3 = bl ? this.displayedMoveNumber + 1 : this.displayedMoveNumber;
            int n4 = (n3 - 1) / 2;
            int n5 = 2 - n3 % 2;
            this.isPositionScrollBarUpdating = true;
            this.isMoveListTableSelectionUpdating = true;
            this.setMoveListTableSelection(n4, n5);
            this.positionScrollBar.setValues(this.displayedMoveNumber, 1, 0, this.madeMoves.size() + 1);
            this.isMoveListTableSelectionUpdating = false;
            this.isPositionScrollBarUpdating = false;
        }
        SwingUtilities.invokeLater(new MoveListScrollBarUpdater());
    }

    protected void updateMoveListTable() {
        int n;
        int n2;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.moveListTableModel;
        int n3 = this.game.getPliesSinceStart() / 2;
        int n4 = this.madeMoves.size();
        boolean bl = n4 > 0 && ((Move)this.madeMoves.elementAt(0)).getPlayer().isBlack();
        int n5 = bl ? 1 + n4 / 2 : (n4 + 1) / 2;
        defaultTableModel.setNumRows(n5);
        for (n2 = 0; n2 < n5; ++n2) {
            defaultTableModel.setValueAt(n2 + 1 + n3 + ".", n2, 0);
        }
        n2 = 0;
        int n6 = bl ? 2 : 1;
        for (n = 0; n < n4; ++n) {
            Object e = this.madeMoves.elementAt(n);
            defaultTableModel.setValueAt(e, n2, n6);
            if (++n6 != 3) continue;
            ++n2;
            n6 = 1;
        }
        if (n6 == 2) {
            defaultTableModel.setValueAt(null, n2, n6);
        }
        if (this.displayedMoveNumber == 0) {
            this.moveListTable.clearSelection();
            this.positionScrollBar.setValues(0, 1, 0, this.madeMoves.size() + 1);
        } else {
            n = bl ? this.displayedMoveNumber + 1 : this.displayedMoveNumber;
            n2 = (n - 1) / 2;
            n6 = 2 - n % 2;
            this.isPositionScrollBarUpdating = true;
            this.isMoveListTableSelectionUpdating = true;
            this.setMoveListTableSelection(n2, n6);
            this.positionScrollBar.setValues(this.displayedMoveNumber, 1, 0, this.madeMoves.size() + 1);
            this.isMoveListTableSelectionUpdating = false;
            this.isPositionScrollBarUpdating = false;
        }
        SwingUtilities.invokeLater(new MoveListScrollBarUpdater());
    }

    protected void setMoveListTableSelection(int n, int n2) {
        int n3 = this.moveListTable.getSelectedRow();
        int n4 = this.moveListTable.getSelectedColumn();
        if (n3 != n) {
            this.settingMoveListTableSelection = true;
            this.moveListTable.setColumnSelectionInterval(n2, n2);
            this.settingMoveListTableSelection = false;
            this.moveListTable.setRowSelectionInterval(n, n);
        } else if (n4 != n2) {
            this.settingMoveListTableSelection = true;
            this.moveListTable.setRowSelectionInterval(n, n);
            this.settingMoveListTableSelection = false;
            this.moveListTable.setColumnSelectionInterval(n2, n2);
        }
    }

    private void updateMoveHighlighting(boolean bl) {
        if (this.displayedMoveNumber == 0 || bl && !this.highlightOwnMoves) {
            this.board.setHighlightedMove(null);
        } else {
            Move move = (Move)this.madeMoves.elementAt(this.displayedMoveNumber - 1);
            this.board.setHighlightedMove(move);
        }
    }

    protected JScrollBar createPositionScrollBar() {
        JScrollBar jScrollBar = new JScrollBar(0, 0, 1, 0, 1);
        return jScrollBar;
    }

    public final boolean isFlipped() {
        return this.isFlipped;
    }

    public void setFlipped(boolean bl) {
        if (this.isFlipped() != bl) {
            this.isFlipped = bl;
            this.board.setFlipped(this.isFlipped);
            this.contentPanel.reAddComponents = true;
            this.contentPanel.revalidate();
        }
    }

    public Game getGame() {
        return this.game;
    }

    public JinBoard getBoard() {
        return this.board;
    }

    protected AbstractChessClock getClockForPlayer(Player player) {
        return player.isWhite() ? this.whiteClock : this.blackClock;
    }

    protected void updateClockActiveness() {
        Player player = this.board.getPosition().getCurrentPlayer();
        AbstractChessClock abstractChessClock = this.getClockForPlayer(player);
        AbstractChessClock abstractChessClock2 = this.getClockForPlayer(player.getOpponent());
        abstractChessClock.setActive(true);
        abstractChessClock2.setActive(false);
    }

    public void playSound(String string) {
        this.boardManager.playSound(string);
    }

    private boolean isMoveEnRoute() {
        return this.moveEnRoute != null;
    }

    private void setQueuedMove(Move move) {
        if (this.queuedMove != null) {
            this.board.setShaded(this.queuedMove.getEndingSquare(), false);
        }
        this.queuedMove = move;
        if (this.queuedMove != null) {
            this.board.setShaded(this.queuedMove.getEndingSquare(), true);
        }
        this.board.setEditable(this.queuedMove == null && this.displayedMoveNumber == this.madeMoves.size());
    }

    private void setDisplayedMove(int n) {
        if (n < 0 || n > this.madeMoves.size()) {
            throw new IllegalArgumentException("displayed move number out of range");
        }
        this.displayedMoveNumber = n;
        if (this.displayedMoveNumber != this.madeMoves.size()) {
            this.board.setEditable(false);
        } else if (this.moveSendingMode == 3) {
            this.board.setEditable(this.queuedMove == null);
        } else if (this.moveSendingMode == 1) {
            this.board.setEditable(this.isUserTurn());
        } else if (this.moveSendingMode == 2) {
            this.board.setEditable(true);
        } else {
            throw new IllegalStateException("Unrecognized move sending mode: " + this.moveSendingMode);
        }
    }

    public void gameStarted(GameStartEvent gameStartEvent) {
    }

    public void moveMade(MoveMadeEvent moveMadeEvent) {
        if (moveMadeEvent.getGame() != this.game) {
            return;
        }
        Move move = moveMadeEvent.getMove();
        boolean bl = this.moveEnRoute != null && Utilities.areEqual((Object)move.getStartingSquare(), (Object)this.moveEnRoute.getStartingSquare()) && Utilities.areEqual((Object)move.getEndingSquare(), (Object)this.moveEnRoute.getEndingSquare()) && Utilities.areEqual((Object)move.getPlayer(), (Object)this.moveEnRoute.getPlayer());
        boolean bl2 = true;
        if (this.displayedMoveNumber != this.madeMoves.size()) {
            bl2 = false;
        }
        this.madeMoves.addElement(move);
        this.realPosition.makeMove(move);
        if (!this.isMoveEnRoute()) {
            if (moveMadeEvent.isNew()) {
                this.playAudioClipForMove(move);
            }
            if (bl2) {
                this.isBoardPositionUpdating = true;
                this.board.getPosition().copyFrom(this.realPosition);
                this.isBoardPositionUpdating = false;
            }
        }
        if (bl2) {
            this.setDisplayedMove(this.madeMoves.size());
            this.updateMoveHighlighting(this.isMoveEnRoute());
        }
        if (this.queuedMove != null && this.queuedMove.getPlayer() == this.realPosition.getCurrentPlayer()) {
            Move move2 = null;
            try {
                move2 = this.game.getVariant().createMove(this.realPosition, this.queuedMove);
                if (!this.checkLegality(this.realPosition, move2)) {
                    move2 = null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (move2 == null) {
                this.isBoardPositionUpdating = true;
                this.board.getPosition().copyFrom(this.realPosition);
                this.isBoardPositionUpdating = false;
                this.setQueuedMove(null);
                this.playSound("IllegalMove");
            } else {
                UserMoveEvent userMoveEvent = new UserMoveEvent(this, move2);
                this.isBoardPositionUpdating = true;
                this.board.getPosition().copyFrom(this.realPosition);
                this.board.getPosition().makeMove(move2);
                this.isBoardPositionUpdating = false;
                this.moveEnRoute = move2;
                this.setQueuedMove(null);
                this.fireUserMadeMove(userMoveEvent);
            }
        } else if (bl) {
            this.moveEnRoute = null;
        }
        this.updateClockActiveness();
        this.addMoveToListTable(move);
    }

    protected boolean checkLegality(Position position, Move move) {
        if (move instanceof ChessMove) {
            ChessMove chessMove = (ChessMove)move;
            if (position.getCurrentPlayer() != chessMove.getPlayer()) {
                return false;
            }
            if (chessMove.isCapture() && chessMove.getCapturedPiece().getPlayer() == position.getCurrentPlayer()) {
                return false;
            }
        }
        return true;
    }

    public void positionChanged(PositionChangedEvent positionChangedEvent) {
        if (positionChangedEvent.getGame() != this.game) {
            return;
        }
        this.madeMoves.removeAllElements();
        this.realPosition.copyFrom(positionChangedEvent.getPosition());
        this.isBoardPositionUpdating = true;
        this.board.getPosition().copyFrom(this.realPosition);
        this.isBoardPositionUpdating = false;
        this.setDisplayedMove(0);
        this.updateMoveHighlighting(false);
        this.moveEnRoute = null;
        this.setQueuedMove(null);
        this.updateClockActiveness();
        this.updateMoveListTable();
    }

    public void takebackOccurred(TakebackEvent takebackEvent) {
        int n;
        if (takebackEvent.getGame() != this.game) {
            return;
        }
        int n2 = takebackEvent.getTakebackCount();
        int n3 = this.madeMoves.size() - n2;
        for (n = this.madeMoves.size() - 1; n >= n3; --n) {
            this.madeMoves.removeElementAt(n);
        }
        this.realPosition.copyFrom(this.game.getInitialPosition());
        for (n = 0; n < n3; ++n) {
            this.realPosition.makeMove((Move)this.madeMoves.elementAt(n));
        }
        this.moveEnRoute = null;
        this.setQueuedMove(null);
        if (this.displayedMoveNumber >= this.madeMoves.size()) {
            this.isBoardPositionUpdating = true;
            this.board.getPosition().copyFrom(this.realPosition);
            this.isBoardPositionUpdating = false;
            this.setDisplayedMove(this.madeMoves.size());
            this.updateMoveHighlighting(false);
        }
        this.updateClockActiveness();
        this.updateMoveListTable();
    }

    public void illegalMoveAttempted(IllegalMoveEvent illegalMoveEvent) {
        if (illegalMoveEvent.getGame() != this.game) {
            return;
        }
        if (!this.isMoveEnRoute()) {
            return;
        }
        this.moveEnRoute = null;
        this.setQueuedMove(null);
        this.isBoardPositionUpdating = true;
        this.board.getPosition().copyFrom(this.realPosition);
        this.isBoardPositionUpdating = false;
        AbstractChessClock abstractChessClock = this.getClockForPlayer(this.board.getPosition().getCurrentPlayer());
        abstractChessClock.setTime((int)((long)abstractChessClock.getTime() - (System.currentTimeMillis() - this.sentMoveTimestamp)));
        abstractChessClock.setRunning(true);
        this.updateClockActiveness();
        this.setDisplayedMove(this.madeMoves.size());
        this.updateMoveListTable();
    }

    public void clockAdjusted(ClockAdjustmentEvent clockAdjustmentEvent) {
        if (clockAdjustmentEvent.getGame() != this.game) {
            return;
        }
        Player player = clockAdjustmentEvent.getPlayer();
        int n = clockAdjustmentEvent.getTime();
        boolean bl = clockAdjustmentEvent.isClockRunning();
        AbstractChessClock abstractChessClock = player.equals(Player.WHITE_PLAYER) ? this.whiteClock : this.blackClock;
        abstractChessClock.setTime(n);
        abstractChessClock.setRunning(bl);
    }

    public void boardFlipped(BoardFlipEvent boardFlipEvent) {
        if (boardFlipEvent.getGame() != this.game) {
            return;
        }
        this.setFlipped(boardFlipEvent.isFlipped());
    }

    public void offerUpdated(OfferEvent offerEvent) {
    }

    public void gameEnded(GameEndEvent gameEndEvent) {
        if (gameEndEvent.getGame() != this.game) {
            return;
        }
        this.whiteClock.setRunning(false);
        this.blackClock.setRunning(false);
        this.setInactive();
    }

    protected void playAudioClipForMove(Move move) {
        if (move instanceof ChessMove) {
            ChessMove chessMove = (ChessMove)move;
            if (chessMove.isCapture()) {
                this.playSound("Capture");
            } else if (chessMove.isCastling()) {
                this.playSound("Castling");
            } else {
                this.playSound("Move");
            }
        } else {
            this.playSound("Move");
        }
    }

    public void moveMade(MoveEvent moveEvent) {
        if (this.isBoardPositionUpdating) {
            return;
        }
        Position position = moveEvent.getPosition();
        Move move = moveEvent.getMove();
        if (position == this.board.getPosition()) {
            this.playAudioClipForMove(move);
            if (this.game.isPlayed() && this.moveSendingMode == 3 && (this.isMoveEnRoute() || !this.isUserTurn())) {
                this.setQueuedMove(move);
            } else {
                UserMoveEvent userMoveEvent = new UserMoveEvent(this, move);
                this.fireUserMadeMove(userMoveEvent);
                this.moveEnRoute = moveEvent.getMove();
                this.getClockForPlayer(move.getPlayer()).setRunning(false);
                this.sentMoveTimestamp = System.currentTimeMillis();
                this.updateClockActiveness();
                if (this.moveSendingMode == 1) {
                    this.board.setEditable(false);
                }
            }
        }
    }

    protected boolean isUserTurn() {
        if (this.game.getGameType() == 2) {
            return false;
        }
        if (this.game.getGameType() == 3) {
            return false;
        }
        if (this.game.isPlayed()) {
            Player player = this.game.getUserPlayer();
            return this.realPosition.getCurrentPlayer().equals(player);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveListTableSelectionChanged() {
        if (this.settingMoveListTableSelection) {
            return;
        }
        if (this.isMoveListTableSelectionUpdating) {
            return;
        }
        int n = this.moveListTable.getSelectedRow();
        int n2 = this.moveListTable.getSelectedColumn();
        if (n == -1 || n2 == -1) {
            return;
        }
        this.isMoveListTableSelectionUpdating = true;
        try {
            boolean bl = ((Move)this.madeMoves.elementAt(0)).getPlayer().isBlack();
            int n3 = n2 + n * 2;
            if (bl && n3 > 0) {
                --n3;
            }
            if (n3 == this.madeMoves.size() + 1) {
                --n3;
            }
            if (n3 > this.madeMoves.size()) {
                throw new IllegalStateException();
            }
            Position position = this.game.getInitialPosition();
            for (int i = 0; i < n3; ++i) {
                Move move = (Move)this.madeMoves.elementAt(i);
                position.makeMove(move);
            }
            this.board.clearShaded();
            if (n3 == this.madeMoves.size() && this.queuedMove != null) {
                position.makeMove(this.queuedMove);
                this.board.setShaded(this.queuedMove.getEndingSquare(), true);
            }
            this.isBoardPositionUpdating = true;
            this.board.getPosition().copyFrom(position);
            this.isBoardPositionUpdating = false;
            this.setDisplayedMove(n3);
            if (!this.isPositionScrollBarUpdating) {
                this.positionScrollBar.setValues(this.displayedMoveNumber, 1, 0, this.madeMoves.size() + 1);
            }
            this.board.setEditable(this.displayedMoveNumber == this.madeMoves.size());
            this.updateMoveHighlighting(false);
            SwingUtilities.invokeLater(new MoveListScrollBarUpdater());
        }
        finally {
            this.isMoveListTableSelectionUpdating = false;
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object == this.positionScrollBar) {
            if (this.isPositionScrollBarUpdating) {
                return;
            }
            this.isPositionScrollBarUpdating = true;
            if (this.madeMoves.size() > 0) {
                int n;
                int n2 = this.positionScrollBar.getValue();
                boolean bl = ((Move)this.madeMoves.elementAt(0)).getPlayer().isBlack();
                int n3 = bl ? n2 + 1 : n2;
                int n4 = (n3 - 1) / 2;
                int n5 = n = n3 == 0 ? 0 : 2 - n3 % 2;
                if (!this.isMoveListTableSelectionUpdating) {
                    this.setMoveListTableSelection(n4, n);
                }
            }
            this.isPositionScrollBarUpdating = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        if (object == this.boardManager) {
            if ("moveInputStyle".equals(string)) {
                this.board.setMoveInputStyle(this.boardManager.getMoveInputStyle());
                return;
            } else if ("pieceFollowsCursor".equals(string)) {
                this.board.setPieceFollowsCursor(this.boardManager.isPieceFollowsCursor());
                return;
            } else if ("highlightMadeMoveSquares".equals(string)) {
                this.board.setHighlightMadeMoveSquares(this.boardManager.isHighlightMadeMoveSquares());
                return;
            } else if ("madeMoveSquaresHighlightColor".equals(string)) {
                this.board.setMadeMoveSquaresHighlightColor(this.boardManager.getMadeMoveSquaresHighlightColor());
                return;
            } else if ("moveHighlightingStyle".equals(string)) {
                this.board.setMoveHighlightingStyle(this.boardManager.getMoveHighlightingStyle());
                return;
            } else if ("autoPromote".equals(string)) {
                this.board.setManualPromote(!this.boardManager.isAutoPromote());
                return;
            } else if ("moveHighlightingColor".equals(string)) {
                this.board.setMoveHighlightingColor(this.boardManager.getMoveHighlightingColor());
                return;
            } else if ("highlightingOwnMoves".equals(string)) {
                this.highlightOwnMoves = this.boardManager.isHighlightingOwnMoves();
                return;
            } else if ("moveSendingMode".equals(string)) {
                this.moveSendingMode = this.boardManager.getMoveSendingMode();
                if (this.displayedMoveNumber != this.madeMoves.size()) return;
                if (this.moveSendingMode == 3 || this.moveSendingMode == 2) {
                    this.board.setEditable(true);
                    return;
                } else {
                    if (this.moveSendingMode != 1) throw new IllegalStateException("Unrecognized move sending mode: " + this.moveSendingMode);
                    this.board.setEditable(this.isUserTurn());
                }
                return;
            } else if ("coordsDisplayStyle".equals(string)) {
                this.board.setCoordsDisplayStyle(this.boardManager.getCoordsDisplayStyle());
                return;
            } else if ("coordsDisplayColor".equals(string)) {
                this.board.setCoordsDisplayColor(this.boardManager.getCoordsDisplayColor());
                return;
            } else if ("pieceSet".equals(string) || "whitePieceColor".equals(string) || "blackPieceColor".equals(string) || "whiteOutlineColor".equals(string) || "blackOutlineColor".equals(string)) {
                this.board.setPiecePainter(this.boardManager.getPiecePainter());
                return;
            } else {
                if (!"boardPattern".equals(string) && !"lightSquareColor".equals(string) && !"darkSquareColor".equals(string)) return;
                this.board.setBoardPainter(this.boardManager.getBoardPainter());
            }
            return;
        } else {
            if (object != this.game) return;
            this.gameLabel.setText(this.createGameLabelText(this.game));
            if ("whiteName".equals(string)) {
                this.whiteLabel.setText(this.createWhiteLabelText(this.game));
                return;
            } else if ("blackName".equals(string)) {
                this.blackLabel.setText(this.createBlackLabelText(this.game));
                return;
            } else {
                if (!"gameType".equals(string) && !"played".equals(string)) return;
                this.configureBoardFromGame(this.game, this.board);
                this.board.setEditable(this.isUserTurn() || this.moveSendingMode != 1);
                this.buttonPanel = this.createButtonPanel(this.game);
                this.gameLabel = this.createGameLabel(this.game);
                this.contentPanel.reAddComponents = true;
                this.contentPanel.revalidate();
            }
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setInactive() {
        this.isActive = false;
        this.board.getPosition().removeMoveListener((MoveListener)this);
        this.board.setMoveInputMode(3);
        this.board.setEditable(true);
        this.whiteClock.setRunning(false);
        this.blackClock.setRunning(false);
        if (this.whiteClock instanceof JChessClock) {
            ((JChessClock)this.whiteClock).setActiveForeground(Color.lightGray);
            ((JChessClock)this.whiteClock).setInactiveForeground(Color.gray);
        }
        if (this.blackClock instanceof JChessClock) {
            ((JChessClock)this.blackClock).setActiveForeground(Color.lightGray);
            ((JChessClock)this.blackClock).setInactiveForeground(Color.gray);
        }
    }

    public void done() {
        this.boardManager.removePropertyChangeListener(this);
    }

    public void removeNotify() {
        if (this.fullscreenPanel.getFullscreenModeModel().isOn()) {
            this.fullscreenPanel.getFullscreenModeModel().set(false);
        }
        super.removeNotify();
    }

    private class ContentPanel
    extends FixedJPanel {
        private boolean reAddComponents = true;
        private boolean isVerticalLayout;
        private JPanel infoBox;
        private JPanel topInfoBox;
        private JPanel bottomInfoBox;

        private ContentPanel() {
        }

        protected void addComponents(Game game, boolean bl) {
            this.setLayout(null);
            this.add((Component)((Object)BoardPanel.this.board));
            if (this.isVerticalLayout) {
                this.topInfoBox = new JPanel();
                this.topInfoBox.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.topInfoBox.setLayout(new BoxLayout(this.topInfoBox, 0));
                this.bottomInfoBox = new JPanel();
                this.bottomInfoBox.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.bottomInfoBox.setLayout(new BoxLayout(this.bottomInfoBox, 0));
                BoardPanel.this.whiteClock.setMaximumSize(BoardPanel.this.whiteClock.getPreferredSize());
                BoardPanel.this.blackClock.setMaximumSize(BoardPanel.this.blackClock.getPreferredSize());
                int n = Math.max(BoardPanel.this.whiteLabel.getPreferredSize().width, BoardPanel.this.blackLabel.getPreferredSize().width);
                int n2 = Math.max(BoardPanel.this.whiteLabel.getPreferredSize().height, BoardPanel.this.blackLabel.getPreferredSize().height);
                BoardPanel.this.whiteLabel.setMinimumSize(new Dimension(n, n2));
                BoardPanel.this.blackLabel.setMinimumSize(new Dimension(n, n2));
                BoardPanel.this.whiteLabel.setPreferredSize(new Dimension(n, n2));
                BoardPanel.this.blackLabel.setPreferredSize(new Dimension(n, n2));
                BoardPanel.this.fullscreenButton.setAlignmentY(1.0f);
                if (bl) {
                    BoardPanel.this.whiteLabel.setAlignmentY(1.0f);
                    BoardPanel.this.whiteClock.setAlignmentY(1.0f);
                    BoardPanel.this.blackLabel.setAlignmentY(0.0f);
                    BoardPanel.this.blackClock.setAlignmentY(0.0f);
                    this.topInfoBox.add(BoardPanel.this.whiteLabel);
                    this.topInfoBox.add(Box.createHorizontalStrut(10));
                    this.topInfoBox.add(BoardPanel.this.fullscreenButton);
                    this.topInfoBox.add(Box.createHorizontalGlue());
                    this.topInfoBox.add((Component)BoardPanel.this.whiteClock);
                    this.bottomInfoBox.add(BoardPanel.this.blackLabel);
                    this.bottomInfoBox.add(Box.createHorizontalGlue());
                    this.bottomInfoBox.add((Component)BoardPanel.this.blackClock);
                } else {
                    BoardPanel.this.whiteLabel.setAlignmentY(0.0f);
                    BoardPanel.this.whiteClock.setAlignmentY(0.0f);
                    BoardPanel.this.blackLabel.setAlignmentY(1.0f);
                    BoardPanel.this.blackClock.setAlignmentY(1.0f);
                    this.topInfoBox.add(BoardPanel.this.blackLabel);
                    this.topInfoBox.add(Box.createHorizontalStrut(10));
                    this.topInfoBox.add(BoardPanel.this.fullscreenButton);
                    this.topInfoBox.add(Box.createHorizontalGlue());
                    this.topInfoBox.add((Component)BoardPanel.this.blackClock);
                    this.bottomInfoBox.add(BoardPanel.this.whiteLabel);
                    this.bottomInfoBox.add(Box.createHorizontalGlue());
                    this.bottomInfoBox.add((Component)BoardPanel.this.whiteClock);
                }
                this.add(this.topInfoBox);
                this.add(this.bottomInfoBox);
            } else {
                BoardPanel.this.whiteClock.setMaximumSize(new Dimension(Integer.MAX_VALUE, BoardPanel.this.whiteClock.getPreferredSize().height));
                BoardPanel.this.blackClock.setMaximumSize(new Dimension(Integer.MAX_VALUE, BoardPanel.this.blackClock.getPreferredSize().height));
                BoardPanel.this.whiteLabel.setAlignmentY(0.5f);
                BoardPanel.this.whiteClock.setAlignmentY(0.5f);
                BoardPanel.this.blackLabel.setAlignmentY(0.5f);
                BoardPanel.this.blackClock.setAlignmentY(0.5f);
                BoardPanel.this.fullscreenButton.setAlignmentY(0.5f);
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)BoardPanel.this.whiteLabel, "Center");
                JPanel jPanel2 = new JPanel(new BorderLayout());
                jPanel2.add((Component)BoardPanel.this.blackLabel, "Center");
                Container container = SquareLayout.createSquareContainer((Component)BoardPanel.this.fullscreenButton);
                if (bl) {
                    jPanel.add((Component)container, "East");
                } else {
                    jPanel2.add((Component)container, "East");
                }
                Box box = Box.createHorizontalBox();
                box.add(BoardPanel.this.gameLabel);
                box.add(Box.createHorizontalGlue());
                JPanel jPanel3 = new JPanel(null);
                jPanel3.setLayout(new BoxLayout(jPanel3, 1));
                JPanel jPanel4 = new JPanel(null);
                jPanel4.setLayout(new BoxLayout(jPanel4, 1));
                JPanel jPanel5 = new JPanel(null);
                jPanel5.setLayout(new BoxLayout(jPanel5, 1));
                if (bl) {
                    jPanel3.add(jPanel);
                    jPanel3.add(Box.createVerticalStrut(10));
                    jPanel3.add((Component)BoardPanel.this.whiteClock);
                    jPanel4.add(Box.createVerticalStrut(10));
                    jPanel4.add(box);
                    jPanel4.add(Box.createVerticalStrut(10));
                    jPanel4.add(BoardPanel.this.positionScrollBar);
                    jPanel4.add(Box.createVerticalStrut(5));
                    jPanel4.add(BoardPanel.this.moveListTableScrollPane);
                    jPanel4.add(Box.createVerticalStrut(10));
                    if (BoardPanel.this.buttonPanel != null) {
                        jPanel4.add(BoardPanel.this.buttonPanel);
                        jPanel4.add(Box.createVerticalStrut(10));
                    }
                    jPanel5.add((Component)BoardPanel.this.blackClock);
                    jPanel5.add(Box.createVerticalStrut(10));
                    jPanel5.add(jPanel2);
                } else {
                    jPanel3.add(jPanel2);
                    jPanel3.add(Box.createVerticalStrut(10));
                    jPanel3.add((Component)BoardPanel.this.blackClock);
                    jPanel4.add(Box.createVerticalStrut(10));
                    jPanel4.add(box);
                    jPanel4.add(Box.createVerticalStrut(10));
                    jPanel4.add(BoardPanel.this.positionScrollBar);
                    jPanel4.add(Box.createVerticalStrut(10));
                    jPanel4.add(BoardPanel.this.moveListTableScrollPane);
                    jPanel4.add(Box.createVerticalStrut(10));
                    if (BoardPanel.this.buttonPanel != null) {
                        jPanel4.add(BoardPanel.this.buttonPanel);
                        jPanel4.add(Box.createVerticalStrut(10));
                    }
                    jPanel5.add((Component)BoardPanel.this.whiteClock);
                    jPanel5.add(Box.createVerticalStrut(10));
                    jPanel5.add(jPanel);
                }
                this.infoBox = new JPanel(null);
                this.infoBox.setBorder(new EmptyBorder(5, 5, 5, 5));
                this.infoBox.setLayout(new BorderLayout());
                this.infoBox.add((Component)jPanel3, "North");
                this.infoBox.add((Component)jPanel4, "Center");
                this.infoBox.add((Component)jPanel5, "South");
                this.add(this.infoBox);
            }
        }

        public void addNotify() {
            this.reAddComponents = true;
            super.addNotify();
        }

        public void doLayout() {
            boolean bl;
            Dimension dimension = this.getSize();
            boolean bl2 = bl = dimension.width < dimension.height;
            if (this.reAddComponents || this.isVerticalLayout != bl) {
                this.removeAll();
                this.reAddComponents = false;
                this.isVerticalLayout = bl;
                this.addComponents(BoardPanel.this.game, BoardPanel.this.isFlipped());
            }
            if (this.isVerticalLayout) {
                int n = (dimension.height - dimension.width) / 2;
                this.topInfoBox.setBounds(0, 0, dimension.width, n);
                BoardPanel.this.board.setBounds(0, n, dimension.width, dimension.width);
                this.bottomInfoBox.setBounds(0, dimension.height - n, dimension.width, n);
            } else {
                BoardPanel.this.board.setBounds(0, 0, dimension.height, dimension.height);
                this.infoBox.setBounds(dimension.height, 0, dimension.width - dimension.height, dimension.height);
            }
        }
    }

    private class MoveListScrollBarUpdater
    implements Runnable {
        private MoveListScrollBarUpdater() {
        }

        public void run() {
            JScrollBar jScrollBar = BoardPanel.this.moveListTableScrollPane.getVerticalScrollBar();
            int n = BoardPanel.this.moveListTable.getSelectedRow();
            int n2 = BoardPanel.this.moveListTable.getSelectedColumn();
            if (n == -1 || n2 == -1) {
                if (BoardPanel.this.displayedMoveNumber == 0) {
                    jScrollBar.setValue(jScrollBar.getMinimum());
                } else {
                    jScrollBar.setValue(jScrollBar.getMaximum());
                }
            } else {
                BoardPanel.this.moveListTable.scrollRectToVisible(BoardPanel.this.moveListTable.getCellRect(n, n2, true));
            }
        }
    }

    private class OtherPluginsPauser
    implements MouseListener,
    MouseMotionListener {
        private boolean paused = false;
        private Timer timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((OtherPluginsPauser)OtherPluginsPauser.this).BoardPanel.this.boardManager.setOtherPluginsPaused(false);
                OtherPluginsPauser.this.paused = false;
            }
        });

        private OtherPluginsPauser() {
        }

        private void go() {
            if (!this.paused) {
                this.paused = true;
                BoardPanel.this.boardManager.setOtherPluginsPaused(true);
            }
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.setRepeats(false);
                this.timer.start();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.go();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.go();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.go();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.go();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.go();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.go();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.go();
        }
    }
}

