/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.InterpreterError;
import bsh.ParserConstants;
import bsh.TargetError;
import java.io.Serializable;

public class Primitive
implements ParserConstants,
Serializable {
    public static final Primitive NULL = new Primitive(Special.NULL_VALUE);
    public static final Primitive VOID = new Primitive(Special.VOID_TYPE);
    private Object value;
    private static /* synthetic */ Class class$Lbsh$Primitive;

    public Object getValue() {
        if (this.value == Special.NULL_VALUE) {
            return null;
        }
        if (this.value == Special.VOID_TYPE) {
            throw new InterpreterError("attempt to unwrap void type");
        }
        return this.value;
    }

    public String toString() {
        if (this.value == Special.NULL_VALUE) {
            return "null";
        }
        if (this.value == Special.VOID_TYPE) {
            return "void";
        }
        return this.value.toString();
    }

    public Class getType() {
        return this.getType(this.value);
    }

    private final Class getType(Object object) {
        if (object instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (object instanceof Byte) {
            return Byte.TYPE;
        }
        if (object instanceof Short) {
            return Short.TYPE;
        }
        if (object instanceof Character) {
            return Character.TYPE;
        }
        if (object instanceof Integer) {
            return Integer.TYPE;
        }
        if (object instanceof Long) {
            return Long.TYPE;
        }
        if (object instanceof Float) {
            return Float.TYPE;
        }
        if (object instanceof Double) {
            return Double.TYPE;
        }
        return null;
    }

    public static Object binaryOperation(Object object, Object object2, int n) throws EvalError {
        Object object3;
        if (object == NULL || object2 == NULL) {
            throw new EvalError("Null value or 'null' literal in binary operation");
        }
        if (object == VOID || object2 == VOID) {
            throw new EvalError("Undefined variable, class, or 'void' literal in binary operation");
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        if (object instanceof Primitive) {
            object = ((Primitive)object).getValue();
        }
        if (object2 instanceof Primitive) {
            object2 = ((Primitive)object2).getValue();
        }
        Object[] objectArray = Primitive.promotePrimitives(object, object2);
        Object object4 = objectArray[0];
        Object object5 = objectArray[1];
        if (object4.getClass() != object5.getClass()) {
            throw new EvalError("type mismatch in operator.  " + object4.getClass() + " cannot be used with " + object5.getClass());
        }
        try {
            object3 = Primitive.binaryOperationImpl(object4, object5, n);
        }
        catch (ArithmeticException arithmeticException) {
            throw new TargetError("Arithemetic Exception in binary op", arithmeticException);
        }
        if (clazz == (class$Lbsh$Primitive != null ? class$Lbsh$Primitive : (class$Lbsh$Primitive = Primitive.class$("bsh.Primitive"))) && clazz2 == (class$Lbsh$Primitive != null ? class$Lbsh$Primitive : (class$Lbsh$Primitive = Primitive.class$("bsh.Primitive")))) {
            return new Primitive(object3);
        }
        return object3;
    }

    static Object binaryOperationImpl(Object object, Object object2, int n) throws EvalError {
        if (object instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)object, (Boolean)object2, n);
        }
        if (object instanceof Integer) {
            return Primitive.intBinaryOperation((Integer)object, (Integer)object2, n);
        }
        if (object instanceof Long) {
            return Primitive.longBinaryOperation((Long)object, (Long)object2, n);
        }
        if (object instanceof Float) {
            return Primitive.floatBinaryOperation((Float)object, (Float)object2, n);
        }
        if (object instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)object, (Double)object2, n);
        }
        throw new EvalError("Invalid types in binary operator");
    }

    static Boolean booleanBinaryOperation(Boolean bl, Boolean bl2, int n) throws EvalError {
        boolean bl3 = bl;
        boolean bl4 = bl2;
        switch (n) {
            case 79: {
                return new Boolean(bl3 == bl4);
            }
            case 84: {
                return new Boolean(bl3 != bl4);
            }
            case 85: 
            case 86: {
                return new Boolean(bl3 || bl4);
            }
            case 87: 
            case 88: {
                return new Boolean(bl3 && bl4);
            }
        }
        throw new InterpreterError("unimplemented binary operator");
    }

    static Object longBinaryOperation(Long l, Long l2, int n) {
        long l3 = l;
        long l4 = l2;
        switch (n) {
            case 73: 
            case 74: {
                return new Boolean(l3 < l4);
            }
            case 71: 
            case 72: {
                return new Boolean(l3 > l4);
            }
            case 79: {
                return new Boolean(l3 == l4);
            }
            case 80: 
            case 81: {
                return new Boolean(l3 <= l4);
            }
            case 82: 
            case 83: {
                return new Boolean(l3 >= l4);
            }
            case 84: {
                return new Boolean(l3 != l4);
            }
            case 91: {
                return new Long(l3 + l4);
            }
            case 92: {
                return new Long(l3 - l4);
            }
            case 93: {
                return new Long(l3 * l4);
            }
            case 94: {
                return new Long(l3 / l4);
            }
            case 100: {
                return new Long(l3 % l4);
            }
            case 101: 
            case 102: {
                return new Long(l3 << (int)l4);
            }
            case 103: 
            case 104: {
                return new Long(l3 >> (int)l4);
            }
            case 105: 
            case 106: {
                return new Long(l3 >>> (int)l4);
            }
            case 95: 
            case 96: {
                return new Long(l3 & l4);
            }
            case 97: 
            case 98: {
                return new Long(l3 | l4);
            }
            case 99: {
                return new Long(l3 ^ l4);
            }
        }
        throw new InterpreterError("Unimplemented binary long operator");
    }

    static Object intBinaryOperation(Integer n, Integer n2, int n3) {
        int n4 = n;
        int n5 = n2;
        switch (n3) {
            case 73: 
            case 74: {
                return new Boolean(n4 < n5);
            }
            case 71: 
            case 72: {
                return new Boolean(n4 > n5);
            }
            case 79: {
                return new Boolean(n4 == n5);
            }
            case 80: 
            case 81: {
                return new Boolean(n4 <= n5);
            }
            case 82: 
            case 83: {
                return new Boolean(n4 >= n5);
            }
            case 84: {
                return new Boolean(n4 != n5);
            }
            case 91: {
                return new Integer(n4 + n5);
            }
            case 92: {
                return new Integer(n4 - n5);
            }
            case 93: {
                return new Integer(n4 * n5);
            }
            case 94: {
                return new Integer(n4 / n5);
            }
            case 100: {
                return new Integer(n4 % n5);
            }
            case 101: 
            case 102: {
                return new Integer(n4 << n5);
            }
            case 103: 
            case 104: {
                return new Integer(n4 >> n5);
            }
            case 105: 
            case 106: {
                return new Integer(n4 >>> n5);
            }
            case 95: 
            case 96: {
                return new Integer(n4 & n5);
            }
            case 97: 
            case 98: {
                return new Integer(n4 | n5);
            }
            case 99: {
                return new Integer(n4 ^ n5);
            }
        }
        throw new InterpreterError("Unimplemented binary integer operator");
    }

    static Object doubleBinaryOperation(Double d, Double d2, int n) throws EvalError {
        double d3 = d;
        double d4 = d2;
        switch (n) {
            case 73: 
            case 74: {
                return new Boolean(d3 < d4);
            }
            case 71: 
            case 72: {
                return new Boolean(d3 > d4);
            }
            case 79: {
                return new Boolean(d3 == d4);
            }
            case 80: 
            case 81: {
                return new Boolean(d3 <= d4);
            }
            case 82: 
            case 83: {
                return new Boolean(d3 >= d4);
            }
            case 84: {
                return new Boolean(d3 != d4);
            }
            case 91: {
                return new Double(d3 + d4);
            }
            case 92: {
                return new Double(d3 - d4);
            }
            case 93: {
                return new Double(d3 * d4);
            }
            case 94: {
                return new Double(d3 / d4);
            }
            case 100: {
                return new Double(d3 % d4);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                throw new EvalError("Can't shift doubles");
            }
        }
        throw new InterpreterError("Unimplemented binary double operator");
    }

    static Object floatBinaryOperation(Float f, Float f2, int n) throws EvalError {
        float f3 = f.floatValue();
        float f4 = f2.floatValue();
        switch (n) {
            case 73: 
            case 74: {
                return new Boolean(f3 < f4);
            }
            case 71: 
            case 72: {
                return new Boolean(f3 > f4);
            }
            case 79: {
                return new Boolean(f3 == f4);
            }
            case 80: 
            case 81: {
                return new Boolean(f3 <= f4);
            }
            case 82: 
            case 83: {
                return new Boolean(f3 >= f4);
            }
            case 84: {
                return new Boolean(f3 != f4);
            }
            case 91: {
                return new Float(f3 + f4);
            }
            case 92: {
                return new Float(f3 - f4);
            }
            case 93: {
                return new Float(f3 * f4);
            }
            case 94: {
                return new Float(f3 / f4);
            }
            case 100: {
                return new Float(f3 % f4);
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                throw new EvalError("Can't shift floats ");
            }
        }
        throw new InterpreterError("Unimplemented binary float operator");
    }

    static Object promoteToInteger(Object object) {
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        if (object instanceof Byte || object instanceof Short) {
            return new Integer(((Number)object).intValue());
        }
        return object;
    }

    static Object[] promotePrimitives(Object object, Object object2) {
        object = Primitive.promoteToInteger(object);
        object2 = Primitive.promoteToInteger(object2);
        if (object instanceof Number && object2 instanceof Number) {
            Number number = (Number)object;
            Number number2 = (Number)object2;
            boolean bl = number instanceof Double;
            if (bl || number2 instanceof Double) {
                if (bl) {
                    object2 = new Double(number2.doubleValue());
                } else {
                    object = new Double(number.doubleValue());
                }
            } else {
                bl = number instanceof Float;
                if (bl || number2 instanceof Float) {
                    if (bl) {
                        object2 = new Float(number2.floatValue());
                    } else {
                        object = new Float(number.floatValue());
                    }
                } else {
                    bl = number instanceof Long;
                    if (bl || number2 instanceof Long) {
                        if (bl) {
                            object2 = new Long(number2.longValue());
                        } else {
                            object = new Long(number.longValue());
                        }
                    }
                }
            }
        }
        return new Object[]{object, object2};
    }

    public static Primitive unaryOperation(Primitive primitive, int n) throws EvalError {
        if (primitive == NULL) {
            throw new EvalError("illegal use of null object or 'null' literal");
        }
        if (primitive == VOID) {
            throw new EvalError("illegal use of undefined object or 'void' literal");
        }
        Class clazz = primitive.getType();
        Object object = Primitive.promoteToInteger(primitive.getValue());
        if (object instanceof Boolean) {
            return new Primitive(Primitive.booleanUnaryOperation((Boolean)object, n));
        }
        if (object instanceof Integer) {
            int n2 = Primitive.intUnaryOperation((Integer)object, n);
            if (n == 89 || n == 90) {
                if (clazz == Byte.TYPE) {
                    return new Primitive((byte)n2);
                }
                if (clazz == Short.TYPE) {
                    return new Primitive((short)n2);
                }
                if (clazz == Character.TYPE) {
                    return new Primitive((char)n2);
                }
            }
            return new Primitive(n2);
        }
        if (object instanceof Long) {
            return new Primitive(Primitive.longUnaryOperation((Long)object, n));
        }
        if (object instanceof Float) {
            return new Primitive(Primitive.floatUnaryOperation((Float)object, n));
        }
        if (object instanceof Double) {
            return new Primitive(Primitive.doubleUnaryOperation((Double)object, n));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }

    static boolean booleanUnaryOperation(Boolean bl, int n) throws EvalError {
        boolean bl2 = bl;
        switch (n) {
            case 75: {
                return !bl2;
            }
        }
        throw new EvalError("Operator inappropriate for boolean");
    }

    static int intUnaryOperation(Integer n, int n2) {
        int n3 = n;
        switch (n2) {
            case 91: {
                return n3;
            }
            case 92: {
                return -n3;
            }
            case 76: {
                return ~n3;
            }
            case 89: {
                return n3 + 1;
            }
            case 90: {
                return n3 - 1;
            }
        }
        throw new InterpreterError("bad integer unaryOperation");
    }

    static long longUnaryOperation(Long l, int n) {
        long l2 = l;
        switch (n) {
            case 91: {
                return l2;
            }
            case 92: {
                return -l2;
            }
            case 76: {
                return l2 ^ -1L;
            }
            case 89: {
                return l2 + 1L;
            }
            case 90: {
                return l2 - 1L;
            }
        }
        throw new InterpreterError("bad long unaryOperation");
    }

    static float floatUnaryOperation(Float f, int n) {
        float f2 = f.floatValue();
        switch (n) {
            case 91: {
                return f2;
            }
            case 92: {
                return -f2;
            }
        }
        throw new InterpreterError("bad float unaryOperation");
    }

    static double doubleUnaryOperation(Double d, int n) {
        double d2 = d;
        switch (n) {
            case 91: {
                return d2;
            }
            case 92: {
                return -d2;
            }
        }
        throw new InterpreterError("bad double unaryOperation");
    }

    public int intValue() throws EvalError {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        throw new EvalError("Primitive not a number");
    }

    public boolean booleanValue() throws EvalError {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new EvalError("Primitive not a boolean");
    }

    public boolean isNumber() {
        return !(this.value instanceof Boolean) && this != NULL && this != VOID;
    }

    public Number numberValue() throws EvalError {
        Object object = this.value;
        if (object instanceof Character) {
            object = new Integer(((Character)object).charValue());
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        throw new EvalError("Primitive not a number");
    }

    public boolean equals(Object object) {
        if (object instanceof Primitive) {
            return ((Primitive)object).value.equals(this.value);
        }
        return object.equals(this.value);
    }

    public static Object unwrap(Object object) {
        if (object == null) {
            return null;
        }
        if (object == VOID) {
            return null;
        }
        if (object instanceof Primitive) {
            return ((Primitive)object).getValue();
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Primitive(Object object) {
        if (object == null) {
            throw new InterpreterError("Use Primitve.NULL instead of Primitive(null)");
        }
        this.value = object;
    }

    public Primitive(Number number) {
        this((Object)number);
    }

    public Primitive(Boolean bl) {
        this((Object)bl);
    }

    public Primitive(Byte by) {
        this((Object)by);
    }

    public Primitive(Short s) {
        this((Object)s);
    }

    public Primitive(Character c) {
        this((Object)c);
    }

    public Primitive(Integer n) {
        this((Object)n);
    }

    public Primitive(Long l) {
        this((Object)l);
    }

    public Primitive(Float f) {
        this((Object)f);
    }

    public Primitive(Double d) {
        this((Object)d);
    }

    public Primitive(boolean bl) {
        this(new Boolean(bl));
    }

    public Primitive(byte by) {
        this(new Byte(by));
    }

    public Primitive(short s) {
        this(new Short(s));
    }

    public Primitive(char c) {
        this(new Character(c));
    }

    public Primitive(int n) {
        this(new Integer(n));
    }

    public Primitive(long l) {
        this(new Long(l));
    }

    public Primitive(float f) {
        this(new Float(f));
    }

    public Primitive(double d) {
        this(new Double(d));
    }

    private static class Special
    implements Serializable {
        public static final Special NULL_VALUE = new Special();
        public static final Special VOID_TYPE = new Special();

        private Special() {
        }
    }
}

