define("core_grades/edittree_weights",["exports","core/str","core/prefetch"],(function(_exports,_str,_prefetch){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=void 0;
/**
   * This module provides functionality for managing weight calculations and adjustments for grade items.
   *
   * @module     core_grades/edittree_weight
   * @copyright  2023 Shamim Rezaie <shamim@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
const selectors_weightOverrideCheckbox='input[type="checkbox"][name^="weightoverride_"]',selectors_weightOverrideInput='input[type="text"][name^="weight_"]',selectors_aggregationForCategory=category=>"[data-aggregationforcategory='".concat(category,"']"),selectors_childrenByCategory=category=>'tr[data-parent-category="'.concat(category,'"]'),selectors_categoryByIdentifier=identifier=>'tr.category[data-category="'.concat(identifier,'"]'),grade_aggregation={sum:13};let decimalSeparator,oldExtraCreditCalculation;const recalculateNaturalWeights=categoryElement=>{const childElements=document.querySelectorAll(selectors_childrenByCategory(categoryElement.dataset.category));let totalGradeMax=0,totalOverriddenWeight=0,totalOverriddenGradeMax=0,automaticGradeItemsPresent=!1,requiresNormalising=!1,erroneous=!1;const overrideArray={};for(const childElement of childElements){const weightInput=childElement.querySelector(selectors_weightOverrideInput),weightCheckbox=childElement.querySelector(selectors_weightOverrideCheckbox);if(!weightInput)continue;const itemWeight=parseWeight(weightInput.value),itemAggregationCoefficient=parseInt(childElement.dataset.aggregationcoef),itemGradeMax=parseFloat(childElement.dataset.grademax);overrideArray[childElement.dataset.itemid]={extraCredit:itemAggregationCoefficient,weight:itemWeight,weightOverride:weightCheckbox.checked},weightCheckbox.checked||0!==itemAggregationCoefficient||(automaticGradeItemsPresent=!0),itemAggregationCoefficient>0||(weightCheckbox.checked&&itemWeight<=0||(totalGradeMax+=itemGradeMax,weightCheckbox.checked&&(totalOverriddenWeight+=itemWeight,totalOverriddenGradeMax+=itemGradeMax)))}let normaliseTotal=0,overriddenTotal=0;for(const gradeItemDetail of Object.values(overrideArray))!gradeItemDetail.extraCredit&&gradeItemDetail.weight>0&&(normaliseTotal+=gradeItemDetail.weight),gradeItemDetail.weightOverride&&!gradeItemDetail.extraCredit&&gradeItemDetail.weight>0&&(overriddenTotal+=gradeItemDetail.weight);overriddenTotal>100&&(requiresNormalising=!0,normaliseTotal=overriddenTotal);const totalNonOverriddenGradeMax=totalGradeMax-totalOverriddenGradeMax;for(const childElement of childElements){const weightInput=childElement.querySelector(selectors_weightOverrideInput),weightCheckbox=childElement.querySelector(selectors_weightOverrideCheckbox),itemAggregationCoefficient=parseInt(childElement.dataset.aggregationcoef),itemGradeMax=parseFloat(childElement.dataset.grademax);if(!weightInput)continue;if(!oldExtraCreditCalculation&&itemAggregationCoefficient>0&&weightCheckbox.checked)continue;weightInput.classList.remove("is-invalid");const errorArea=weightInput.closest("td").querySelector(".invalid-feedback");if(errorArea.textContent="",!oldExtraCreditCalculation&&itemAggregationCoefficient>0&&!weightCheckbox.checked)weightInput.value=totalGradeMax?formatFloat(100*itemGradeMax/totalGradeMax):0;else if(weightCheckbox.checked){if((!automaticGradeItemsPresent&&100!==normaliseTotal||requiresNormalising||overrideArray[childElement.dataset.itemid].weight<0)&&(overrideArray[childElement.dataset.itemid].weight<0&&(weightInput.value=formatFloat(0)),0!==normaliseTotal)){erroneous=!0;const error=normaliseTotal>100?"erroroverweight":"errorunderweight";(0,_str.getString)(error,"core_grades").then((errorString=>{errorArea.textContent=errorString})),weightInput.classList.add("is-invalid")}}else weightInput.value=formatFloat(totalOverriddenWeight>=100||0===totalNonOverriddenGradeMax||0===itemGradeMax?0:itemGradeMax/totalNonOverriddenGradeMax*(100-totalOverriddenWeight))}if(!erroneous){if(parseFloat(categoryElement.dataset.grademax)!==totalGradeMax){categoryElement.dataset.grademax=totalGradeMax;document.querySelector(selectors_aggregationForCategory(categoryElement.dataset.category)).querySelector(".column-range").innerHTML=formatFloat(totalGradeMax,2,2);const parentCategory=document.querySelector(selectors_categoryByIdentifier(categoryElement.dataset.parentCategory));parentCategory&&parseInt(parentCategory.dataset.aggregation)===grade_aggregation.sum&&recalculateNaturalWeights(parentCategory)}}},formatFloat=function(number){let decimalPoints=arguments.length>1&&void 0!==arguments[1]?arguments[1]:3,minDecimals=arguments.length>2&&void 0!==arguments[2]?arguments[2]:1;return number.toFixed(decimalPoints).replace(new RegExp("0{0,".concat(decimalPoints-minDecimals,"}$")),"").replace(".",decimalSeparator)},parseWeight=weightString=>{const normalizedWeightString=weightString.replace(decimalSeparator,".");return isNaN(Number(normalizedWeightString))?0:parseFloat(normalizedWeightString||0)};_exports.init=(decSep,oldCalculation)=>{decimalSeparator=decSep,oldExtraCreditCalculation=oldCalculation,(0,_prefetch.prefetchStrings)("core_grades",["erroroverweight","errorunderweight"]),document.addEventListener("change",(e=>{if(e.target.matches(selectors_weightOverrideInput)||e.target.matches(selectors_weightOverrideCheckbox)){const gradeItemRow=e.target.closest("tr"),categoryElement=document.querySelector(selectors_categoryByIdentifier(gradeItemRow.dataset.parentCategory));if(parseInt(categoryElement.dataset.aggregation)===grade_aggregation.sum){const weightElement=gradeItemRow.querySelector(selectors_weightOverrideInput);weightElement.value=formatFloat(Math.max(0,parseWeight(weightElement.value))),recalculateNaturalWeights(categoryElement)}}})),document.addEventListener("submit",(e=>{if(e.target.matches("#gradetreeform")){const firstInvalidWeightInput=e.target.querySelector("input.is-invalid");if(firstInvalidWeightInput){const firstFocusableInvalidWeightInput=e.target.querySelector("input.is-invalid:enabled");firstFocusableInvalidWeightInput?firstFocusableInvalidWeightInput.focus():firstInvalidWeightInput.scrollIntoView({block:"center"}),e.preventDefault()}}}))}}));

//# sourceMappingURL=edittree_weights.min.js.map