/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import java.awt.Shape;
import java.awt.geom.QuadCurve2D;
import net.claribole.zvtm.glyphs.PathElement;

class QDCElement
extends PathElement {
    long ctrlx;
    long ctrly;
    QuadCurve2D[] pc;
    QuadCurve2D[] lpc;

    QDCElement(long x, long y, long ctrlx, long ctrly) {
        this.type = (short)2;
        this.x = x;
        this.y = y;
        this.ctrlx = ctrlx;
        this.ctrly = ctrly;
    }

    void initCams(int nbCam) {
        this.pc = new QuadCurve2D[nbCam];
        this.lpc = new QuadCurve2D[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new QuadCurve2D.Double();
            this.lpc[i] = new QuadCurve2D.Double();
        }
    }

    void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                QuadCurve2D[] ta = this.pc;
                this.pc = new QuadCurve2D[ta.length + 1];
                System.arraycopy(ta, 0, this.pc, 0, ta.length);
                this.pc[this.pc.length - 1] = new QuadCurve2D.Double();
                ta = this.lpc;
                this.lpc = new QuadCurve2D[ta.length + 1];
                System.arraycopy(ta, 0, this.lpc, 0, ta.length);
                this.lpc[this.lpc.length - 1] = new QuadCurve2D.Double();
            } else {
                System.err.println("DPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new QuadCurve2D[1];
            this.pc[0] = new QuadCurve2D.Double();
            this.lpc = new QuadCurve2D[1];
            this.lpc[0] = new QuadCurve2D.Double();
        } else {
            System.err.println("DPath:Error while adding camera " + verifIndex);
        }
    }

    void removeCamera(int index) {
        this.pc[index] = null;
        this.lpc[index] = null;
    }

    void project(int i, int hw, int hh, Camera c, float coef, double px, double py) {
        this.pc[i].setCurve(px, py, (float)hw + (float)(this.ctrlx - c.posx) * coef, (float)hh - (float)(this.ctrly - c.posy) * coef, (float)hw + (float)(this.x - c.posx) * coef, (float)hh - (float)(this.y - c.posy) * coef);
    }

    void projectForLens(int i, int hw, int hh, long lx, long ly, float coef, double px, double py) {
        this.lpc[i].setCurve(px, py, (float)hw + (float)(this.ctrlx - lx) * coef, (float)hh - (float)(this.ctrly - ly) * coef, (float)hw + (float)(this.x - lx) * coef, (float)hh - (float)(this.y - ly) * coef);
    }

    double getX(int i) {
        return this.pc[i].getX2();
    }

    double getY(int i) {
        return this.pc[i].getY2();
    }

    double getlX(int i) {
        return this.lpc[i].getX2();
    }

    double getlY(int i) {
        return this.lpc[i].getY2();
    }

    Shape getShape(int i) {
        return this.pc[i];
    }

    Shape getlShape(int i) {
        return this.lpc[i];
    }
}

