require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_AARCH64_VMPARAM_H_)) {
    eval 'sub _AARCH64_VMPARAM_H_ () {1;}' unless defined(&_AARCH64_VMPARAM_H_);
    if(defined(&__aarch64__)) {
	eval 'sub __USE_TOPDOWN_VM () {1;}' unless defined(&__USE_TOPDOWN_VM);
	eval 'sub PAGER_MAP_DEFAULT_SIZE () {(512* 1024* 1024);}' unless defined(&PAGER_MAP_DEFAULT_SIZE);
	unless(defined(&UBC_WINSHIFT)) {
	    eval 'sub UBC_WINSHIFT () {16;}' unless defined(&UBC_WINSHIFT);
	}
	unless(defined(&UBC_NWINS)) {
	    eval 'sub UBC_NWINS () {4096;}' unless defined(&UBC_NWINS);
	}
	if(defined(&AARCH64_PAGE_SHIFT)) {
	    if((1<< (defined(&AARCH64_PAGE_SHIFT) ? &AARCH64_PAGE_SHIFT : undef)) & ~0x141000) {
		die("AARCH64_PAGE_SHIFT\ contains\ an\ unsupported\ value\.");
	    }
	    eval 'sub PAGE_SHIFT () { &AARCH64_PAGE_SHIFT;}' unless defined(&PAGE_SHIFT);
	} else {
	    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
	}
	eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
	eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
	if((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) <= 14) {
	    eval 'sub USPACE () {32768;}' unless defined(&USPACE);
	} else {
	    eval 'sub USPACE () {65536;}' unless defined(&USPACE);
	}
	eval 'sub UPAGES () {( &USPACE >>  &PAGE_SHIFT);}' unless defined(&UPAGES);
	eval 'sub USRSTACK () { &VM_MAXUSER_ADDRESS;}' unless defined(&USRSTACK);
	unless(defined(&MAXTSIZ)) {
	    eval 'sub MAXTSIZ () {(1 << 30);}' unless defined(&MAXTSIZ);
	}
	unless(defined(&MAXDSIZ)) {
	    eval 'sub MAXDSIZ () {(1 << 36);}' unless defined(&MAXDSIZ);
	}
	unless(defined(&MAXSSIZ)) {
	    eval 'sub MAXSSIZ () {(1 << 26);}' unless defined(&MAXSSIZ);
	}
	unless(defined(&DFLDSIZ)) {
	    eval 'sub DFLDSIZ () {(1 << 32);}' unless defined(&DFLDSIZ);
	}
	unless(defined(&DFLSSIZ)) {
	    eval 'sub DFLSSIZ () {(1 << 23);}' unless defined(&DFLSSIZ);
	}
	eval 'sub USRSTACK32 () { &VM_MAXUSER_ADDRESS32;}' unless defined(&USRSTACK32);
	unless(defined(&MAXDSIZ32)) {
	    eval 'sub MAXDSIZ32 () {(3*1024*1024*1024);}' unless defined(&MAXDSIZ32);
	}
	unless(defined(&MAXSSIZ32)) {
	    eval 'sub MAXSSIZ32 () {(64*1024*1024);}' unless defined(&MAXSSIZ32);
	}
	unless(defined(&DFLDSIZ32)) {
	    eval 'sub DFLDSIZ32 () {(1 << 27);}' unless defined(&DFLDSIZ32);
	}
	unless(defined(&DFLSSIZ32)) {
	    eval 'sub DFLSSIZ32 () {(1 << 21);}' unless defined(&DFLSSIZ32);
	}
	eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t) 0x);}' unless defined(&VM_MIN_ADDRESS);
	eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t) (1 << 48) -  &PAGE_SIZE);}' unless defined(&VM_MAXUSER_ADDRESS);
	eval 'sub VM_MAX_ADDRESS () { &VM_MAXUSER_ADDRESS;}' unless defined(&VM_MAX_ADDRESS);
	eval 'sub VM_MAXUSER_ADDRESS32 () {(( &vaddr_t) 0xfffff000);}' unless defined(&VM_MAXUSER_ADDRESS32);
	eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t) 0xffffc00000000000);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
	eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t) 0xffffffffffe00000);}' unless defined(&VM_MAX_KERNEL_ADDRESS);
	eval 'sub EFI_RUNTIME_VA () {0xffff800000000000;}' unless defined(&EFI_RUNTIME_VA);
	eval 'sub EFI_RUNTIME_SIZE () {0x40000000;}' unless defined(&EFI_RUNTIME_SIZE);
	eval 'sub VM_KERNEL_IO_BASE () {0xfffffffff0000000;}' unless defined(&VM_KERNEL_IO_BASE);
	eval 'sub VM_KERNEL_IO_SIZE () {( &VM_MAX_KERNEL_ADDRESS -  &VM_KERNEL_IO_BASE);}' unless defined(&VM_KERNEL_IO_SIZE);
	eval 'sub VM_KERNEL_VM_BASE () {(0xffffc00040000000);}' unless defined(&VM_KERNEL_VM_BASE);
	eval 'sub VM_KERNEL_VM_SIZE () {( &VM_KERNEL_IO_BASE -  &VM_KERNEL_VM_BASE);}' unless defined(&VM_KERNEL_VM_SIZE);
	eval 'sub USRIOSIZE () {( &PAGE_SIZE / 8);}' unless defined(&USRIOSIZE);
	eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE *  &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
	eval 'sub VM_DEFAULT_ADDRESS32_TOPDOWN {
	    my($da, $sz) = @_;
    	    eval q( &trunc_page( &USRSTACK32 -  &MAXSSIZ32 - ($sz) -  &user_stack_guard_size));
	}' unless defined(&VM_DEFAULT_ADDRESS32_TOPDOWN);
	eval 'sub VM_DEFAULT_ADDRESS32_BOTTOMUP {
	    my($da, $sz) = @_;
    	    eval q( &round_page(( &vaddr_t)($da) + ( &vsize_t) &MAXDSIZ32));
	}' unless defined(&VM_DEFAULT_ADDRESS32_BOTTOMUP);
	eval 'sub AARCH64_DIRECTMAP_MASK () {(( &vaddr_t) 0xffff000000000000);}' unless defined(&AARCH64_DIRECTMAP_MASK);
	eval 'sub AARCH64_DIRECTMAP_SIZE () {(1 << 46);}' unless defined(&AARCH64_DIRECTMAP_SIZE);
	eval 'sub AARCH64_DIRECTMAP_START () { &AARCH64_DIRECTMAP_MASK;}' unless defined(&AARCH64_DIRECTMAP_START);
	eval 'sub AARCH64_DIRECTMAP_END () {( &AARCH64_DIRECTMAP_START +  &AARCH64_DIRECTMAP_SIZE);}' unless defined(&AARCH64_DIRECTMAP_END);
	eval 'sub AARCH64_KVA_P {
	    my($va) = @_;
    	    eval q(((( &vaddr_t) ($va) &  &AARCH64_DIRECTMAP_MASK) != 0));
	}' unless defined(&AARCH64_KVA_P);
	eval 'sub AARCH64_PA_TO_KVA {
	    my($pa) = @_;
    	    eval q((( &vaddr_t) (($pa) |  &AARCH64_DIRECTMAP_START)));
	}' unless defined(&AARCH64_PA_TO_KVA);
	eval 'sub AARCH64_KVA_TO_PA {
	    my($va) = @_;
    	    eval q((( &paddr_t) (($va) & ~ &AARCH64_DIRECTMAP_MASK)));
	}' unless defined(&AARCH64_KVA_TO_PA);
	eval 'sub VM_PHYSSEG_MAX () {256;}' unless defined(&VM_PHYSSEG_MAX);
	eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_BSEARCH;}' unless defined(&VM_PHYSSEG_STRAT);
	eval 'sub VM_NFREELIST () {1;}' unless defined(&VM_NFREELIST);
	eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
    }
 elsif(defined(&__arm__)) {
	require 'arm/vmparam.ph';
    }
}
1;
