require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_CT_H)) {
    eval 'sub OPENSSL_CT_H () {1;}' unless defined(&OPENSSL_CT_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_CT_H () {1;}' unless defined(&HEADER_CT_H);
    }
    require 'openssl/opensslconf.ph';
    unless(defined(&OPENSSL_NO_CT)) {
	require 'openssl/types.ph';
	require 'openssl/safestack.ph';
	require 'openssl/x509.ph';
	require 'openssl/cterr.ph';
	if(defined(&__cplusplus)) {
	}
	eval 'sub SCT_MIN_RSA_BITS () {2048;}' unless defined(&SCT_MIN_RSA_BITS);
	eval 'sub CT_V1_HASHLEN () { &SHA256_DIGEST_LENGTH;}' unless defined(&CT_V1_HASHLEN);
	eval 'sub sk_SCT_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_SCT_sk_type($sk)));
	}' unless defined(&sk_SCT_num);
	eval 'sub sk_SCT_value {
	    my($sk, $idx) = @_;
    	    eval q((( &SCT *) &OPENSSL_sk_value( &ossl_check_const_SCT_sk_type($sk), ($idx))));
	}' unless defined(&sk_SCT_value);
	eval 'sub sk_SCT_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &SCT) *) &OPENSSL_sk_new( &ossl_check_SCT_compfunc_type($cmp))));
	}' unless defined(&sk_SCT_new);
	eval 'sub sk_SCT_new_null () {
	    eval q((( &STACK_OF( &SCT) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_SCT_new_null);
	eval 'sub sk_SCT_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &SCT) *) &OPENSSL_sk_new_reserve( &ossl_check_SCT_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_SCT_new_reserve);
	eval 'sub sk_SCT_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_SCT_sk_type($sk), ($n)));
	}' unless defined(&sk_SCT_reserve);
	eval 'sub sk_SCT_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_SCT_sk_type($sk)));
	}' unless defined(&sk_SCT_free);
	eval 'sub sk_SCT_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_SCT_sk_type($sk)));
	}' unless defined(&sk_SCT_zero);
	eval 'sub sk_SCT_delete {
	    my($sk, $i) = @_;
    	    eval q((( &SCT *) &OPENSSL_sk_delete( &ossl_check_SCT_sk_type($sk), ($i))));
	}' unless defined(&sk_SCT_delete);
	eval 'sub sk_SCT_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &SCT *) &OPENSSL_sk_delete_ptr( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr))));
	}' unless defined(&sk_SCT_delete_ptr);
	eval 'sub sk_SCT_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr)));
	}' unless defined(&sk_SCT_push);
	eval 'sub sk_SCT_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr)));
	}' unless defined(&sk_SCT_unshift);
	eval 'sub sk_SCT_pop {
	    my($sk) = @_;
    	    eval q((( &SCT *) &OPENSSL_sk_pop( &ossl_check_SCT_sk_type($sk))));
	}' unless defined(&sk_SCT_pop);
	eval 'sub sk_SCT_shift {
	    my($sk) = @_;
    	    eval q((( &SCT *) &OPENSSL_sk_shift( &ossl_check_SCT_sk_type($sk))));
	}' unless defined(&sk_SCT_shift);
	eval 'sub sk_SCT_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_SCT_sk_type($sk), &ossl_check_SCT_freefunc_type($freefunc)));
	}' unless defined(&sk_SCT_pop_free);
	eval 'sub sk_SCT_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr), ($idx)));
	}' unless defined(&sk_SCT_insert);
	eval 'sub sk_SCT_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &SCT *) &OPENSSL_sk_set( &ossl_check_SCT_sk_type($sk), ($idx),  &ossl_check_SCT_type($ptr))));
	}' unless defined(&sk_SCT_set);
	eval 'sub sk_SCT_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr)));
	}' unless defined(&sk_SCT_find);
	eval 'sub sk_SCT_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr)));
	}' unless defined(&sk_SCT_find_ex);
	eval 'sub sk_SCT_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_type($ptr), $pnum));
	}' unless defined(&sk_SCT_find_all);
	eval 'sub sk_SCT_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_SCT_sk_type($sk)));
	}' unless defined(&sk_SCT_sort);
	eval 'sub sk_SCT_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_SCT_sk_type($sk)));
	}' unless defined(&sk_SCT_is_sorted);
	eval 'sub sk_SCT_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &SCT) *) &OPENSSL_sk_dup( &ossl_check_const_SCT_sk_type($sk))));
	}' unless defined(&sk_SCT_dup);
	eval 'sub sk_SCT_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &SCT) *) &OPENSSL_sk_deep_copy( &ossl_check_const_SCT_sk_type($sk),  &ossl_check_SCT_copyfunc_type($copyfunc),  &ossl_check_SCT_freefunc_type($freefunc))));
	}' unless defined(&sk_SCT_deep_copy);
	eval 'sub sk_SCT_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_SCT_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_SCT_sk_type($sk),  &ossl_check_SCT_compfunc_type($cmp))));
	}' unless defined(&sk_SCT_set_cmp_func);
	eval 'sub sk_CTLOG_num {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_num( &ossl_check_const_CTLOG_sk_type($sk)));
	}' unless defined(&sk_CTLOG_num);
	eval 'sub sk_CTLOG_value {
	    my($sk, $idx) = @_;
    	    eval q((( &CTLOG *) &OPENSSL_sk_value( &ossl_check_const_CTLOG_sk_type($sk), ($idx))));
	}' unless defined(&sk_CTLOG_value);
	eval 'sub sk_CTLOG_new {
	    my($cmp) = @_;
    	    eval q((( &STACK_OF( &CTLOG) *) &OPENSSL_sk_new( &ossl_check_CTLOG_compfunc_type($cmp))));
	}' unless defined(&sk_CTLOG_new);
	eval 'sub sk_CTLOG_new_null () {
	    eval q((( &STACK_OF( &CTLOG) *) &OPENSSL_sk_new_null()));
	}' unless defined(&sk_CTLOG_new_null);
	eval 'sub sk_CTLOG_new_reserve {
	    my($cmp, $n) = @_;
    	    eval q((( &STACK_OF( &CTLOG) *) &OPENSSL_sk_new_reserve( &ossl_check_CTLOG_compfunc_type($cmp), ($n))));
	}' unless defined(&sk_CTLOG_new_reserve);
	eval 'sub sk_CTLOG_reserve {
	    my($sk, $n) = @_;
    	    eval q( &OPENSSL_sk_reserve( &ossl_check_CTLOG_sk_type($sk), ($n)));
	}' unless defined(&sk_CTLOG_reserve);
	eval 'sub sk_CTLOG_free {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_free( &ossl_check_CTLOG_sk_type($sk)));
	}' unless defined(&sk_CTLOG_free);
	eval 'sub sk_CTLOG_zero {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_zero( &ossl_check_CTLOG_sk_type($sk)));
	}' unless defined(&sk_CTLOG_zero);
	eval 'sub sk_CTLOG_delete {
	    my($sk, $i) = @_;
    	    eval q((( &CTLOG *) &OPENSSL_sk_delete( &ossl_check_CTLOG_sk_type($sk), ($i))));
	}' unless defined(&sk_CTLOG_delete);
	eval 'sub sk_CTLOG_delete_ptr {
	    my($sk, $ptr) = @_;
    	    eval q((( &CTLOG *) &OPENSSL_sk_delete_ptr( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr))));
	}' unless defined(&sk_CTLOG_delete_ptr);
	eval 'sub sk_CTLOG_push {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_push( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr)));
	}' unless defined(&sk_CTLOG_push);
	eval 'sub sk_CTLOG_unshift {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_unshift( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr)));
	}' unless defined(&sk_CTLOG_unshift);
	eval 'sub sk_CTLOG_pop {
	    my($sk) = @_;
    	    eval q((( &CTLOG *) &OPENSSL_sk_pop( &ossl_check_CTLOG_sk_type($sk))));
	}' unless defined(&sk_CTLOG_pop);
	eval 'sub sk_CTLOG_shift {
	    my($sk) = @_;
    	    eval q((( &CTLOG *) &OPENSSL_sk_shift( &ossl_check_CTLOG_sk_type($sk))));
	}' unless defined(&sk_CTLOG_shift);
	eval 'sub sk_CTLOG_pop_free {
	    my($sk, $freefunc) = @_;
    	    eval q( &OPENSSL_sk_pop_free( &ossl_check_CTLOG_sk_type($sk), &ossl_check_CTLOG_freefunc_type($freefunc)));
	}' unless defined(&sk_CTLOG_pop_free);
	eval 'sub sk_CTLOG_insert {
	    my($sk, $ptr, $idx) = @_;
    	    eval q( &OPENSSL_sk_insert( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr), ($idx)));
	}' unless defined(&sk_CTLOG_insert);
	eval 'sub sk_CTLOG_set {
	    my($sk, $idx, $ptr) = @_;
    	    eval q((( &CTLOG *) &OPENSSL_sk_set( &ossl_check_CTLOG_sk_type($sk), ($idx),  &ossl_check_CTLOG_type($ptr))));
	}' unless defined(&sk_CTLOG_set);
	eval 'sub sk_CTLOG_find {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr)));
	}' unless defined(&sk_CTLOG_find);
	eval 'sub sk_CTLOG_find_ex {
	    my($sk, $ptr) = @_;
    	    eval q( &OPENSSL_sk_find_ex( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr)));
	}' unless defined(&sk_CTLOG_find_ex);
	eval 'sub sk_CTLOG_find_all {
	    my($sk, $ptr, $pnum) = @_;
    	    eval q( &OPENSSL_sk_find_all( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_type($ptr), $pnum));
	}' unless defined(&sk_CTLOG_find_all);
	eval 'sub sk_CTLOG_sort {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_sort( &ossl_check_CTLOG_sk_type($sk)));
	}' unless defined(&sk_CTLOG_sort);
	eval 'sub sk_CTLOG_is_sorted {
	    my($sk) = @_;
    	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_CTLOG_sk_type($sk)));
	}' unless defined(&sk_CTLOG_is_sorted);
	eval 'sub sk_CTLOG_dup {
	    my($sk) = @_;
    	    eval q((( &STACK_OF( &CTLOG) *) &OPENSSL_sk_dup( &ossl_check_const_CTLOG_sk_type($sk))));
	}' unless defined(&sk_CTLOG_dup);
	eval 'sub sk_CTLOG_deep_copy {
	    my($sk, $copyfunc, $freefunc) = @_;
    	    eval q((( &STACK_OF( &CTLOG) *) &OPENSSL_sk_deep_copy( &ossl_check_const_CTLOG_sk_type($sk),  &ossl_check_CTLOG_copyfunc_type($copyfunc),  &ossl_check_CTLOG_freefunc_type($freefunc))));
	}' unless defined(&sk_CTLOG_deep_copy);
	eval 'sub sk_CTLOG_set_cmp_func {
	    my($sk, $cmp) = @_;
    	    eval q((( &sk_CTLOG_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_CTLOG_sk_type($sk),  &ossl_check_CTLOG_compfunc_type($cmp))));
	}' unless defined(&sk_CTLOG_set_cmp_func);
	eval("sub CT_LOG_ENTRY_TYPE_NOT_SET () { -1; }") unless defined(&CT_LOG_ENTRY_TYPE_NOT_SET);
	eval("sub CT_LOG_ENTRY_TYPE_X509 () { 0; }") unless defined(&CT_LOG_ENTRY_TYPE_X509);
	eval("sub CT_LOG_ENTRY_TYPE_PRECERT () { 1; }") unless defined(&CT_LOG_ENTRY_TYPE_PRECERT);
	eval("sub SCT_VERSION_NOT_SET () { -1; }") unless defined(&SCT_VERSION_NOT_SET);
	eval("sub SCT_VERSION_V1 () { 0; }") unless defined(&SCT_VERSION_V1);
	eval("sub SCT_SOURCE_UNKNOWN () { 0; }") unless defined(&SCT_SOURCE_UNKNOWN);
	eval("sub SCT_SOURCE_TLS_EXTENSION () { 1; }") unless defined(&SCT_SOURCE_TLS_EXTENSION);
	eval("sub SCT_SOURCE_X509V3_EXTENSION () { 2; }") unless defined(&SCT_SOURCE_X509V3_EXTENSION);
	eval("sub SCT_SOURCE_OCSP_STAPLED_RESPONSE () { 3; }") unless defined(&SCT_SOURCE_OCSP_STAPLED_RESPONSE);
	eval("sub SCT_VALIDATION_STATUS_NOT_SET () { 0; }") unless defined(&SCT_VALIDATION_STATUS_NOT_SET);
	eval("sub SCT_VALIDATION_STATUS_UNKNOWN_LOG () { 1; }") unless defined(&SCT_VALIDATION_STATUS_UNKNOWN_LOG);
	eval("sub SCT_VALIDATION_STATUS_VALID () { 2; }") unless defined(&SCT_VALIDATION_STATUS_VALID);
	eval("sub SCT_VALIDATION_STATUS_INVALID () { 3; }") unless defined(&SCT_VALIDATION_STATUS_INVALID);
	eval("sub SCT_VALIDATION_STATUS_UNVERIFIED () { 4; }") unless defined(&SCT_VALIDATION_STATUS_UNVERIFIED);
	eval("sub SCT_VALIDATION_STATUS_UNKNOWN_VERSION () { 5; }") unless defined(&SCT_VALIDATION_STATUS_UNKNOWN_VERSION);
	if(defined(&__cplusplus)) {
	}
    }
}
1;
