require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_X509_ACERT_H)) {
    eval 'sub OPENSSL_X509_ACERT_H () {1;}' unless defined(&OPENSSL_X509_ACERT_H);
    require 'openssl/x509v3.ph';
    require 'openssl/x509.ph';
    require 'openssl/pem.ph';
    unless(defined(&OPENSSL_NO_STDIO)) {
    }
    eval 'sub X509_ACERT_VERSION_2 () {1;}' unless defined(&X509_ACERT_VERSION_2);
    eval 'sub OSSL_OBJECT_DIGEST_INFO_PUBLIC_KEY () {0;}' unless defined(&OSSL_OBJECT_DIGEST_INFO_PUBLIC_KEY);
    eval 'sub OSSL_OBJECT_DIGEST_INFO_PUBLIC_KEY_CERT () {1;}' unless defined(&OSSL_OBJECT_DIGEST_INFO_PUBLIC_KEY_CERT);
    eval 'sub OSSL_OBJECT_DIGEST_INFO_OTHER () {2;}' unless defined(&OSSL_OBJECT_DIGEST_INFO_OTHER);
    eval 'sub OSSL_IETFAS_OCTETS () {0;}' unless defined(&OSSL_IETFAS_OCTETS);
    eval 'sub OSSL_IETFAS_OID () {1;}' unless defined(&OSSL_IETFAS_OID);
    eval 'sub OSSL_IETFAS_STRING () {2;}' unless defined(&OSSL_IETFAS_STRING);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_num);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_value {
        my($sk, $idx) = @_;
	    eval q((( &OSSL_IETF_ATTR_SYNTAX_VALUE *) &OPENSSL_sk_value( &ossl_check_const_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk), ($idx))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_value);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &OSSL_IETF_ATTR_SYNTAX_VALUE) *) &OPENSSL_sk_new( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_new);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_new_null () {
        eval q((( &STACK_OF( &OSSL_IETF_ATTR_SYNTAX_VALUE) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_new_null);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &OSSL_IETF_ATTR_SYNTAX_VALUE) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_new_reserve);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk), ($n)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_reserve);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_free);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_zero);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_delete {
        my($sk, $i) = @_;
	    eval q((( &OSSL_IETF_ATTR_SYNTAX_VALUE *) &OPENSSL_sk_delete( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk), ($i))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_delete);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &OSSL_IETF_ATTR_SYNTAX_VALUE *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_delete_ptr);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_push);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_unshift);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_pop {
        my($sk) = @_;
	    eval q((( &OSSL_IETF_ATTR_SYNTAX_VALUE *) &OPENSSL_sk_pop( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_pop);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_shift {
        my($sk) = @_;
	    eval q((( &OSSL_IETF_ATTR_SYNTAX_VALUE *) &OPENSSL_sk_shift( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_shift);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk), &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_freefunc_type($freefunc)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_pop_free);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr), ($idx)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_insert);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &OSSL_IETF_ATTR_SYNTAX_VALUE *) &OPENSSL_sk_set( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk), ($idx),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_set);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_find);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_find_ex);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_type($ptr), $pnum));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_find_all);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_sort);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk)));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_is_sorted);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &OSSL_IETF_ATTR_SYNTAX_VALUE) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_dup);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &OSSL_IETF_ATTR_SYNTAX_VALUE) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_copyfunc_type($copyfunc),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_freefunc_type($freefunc))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_deep_copy);
    eval 'sub sk_OSSL_IETF_ATTR_SYNTAX_VALUE_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_OSSL_IETF_ATTR_SYNTAX_VALUE_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_sk_type($sk),  &ossl_check_OSSL_IETF_ATTR_SYNTAX_VALUE_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_IETF_ATTR_SYNTAX_VALUE_set_cmp_func);
    eval 'sub OSSL_TGT_TARGET_NAME () {0;}' unless defined(&OSSL_TGT_TARGET_NAME);
    eval 'sub OSSL_TGT_TARGET_GROUP () {1;}' unless defined(&OSSL_TGT_TARGET_GROUP);
    eval 'sub OSSL_TGT_TARGET_CERT () {2;}' unless defined(&OSSL_TGT_TARGET_CERT);
    eval 'sub sk_OSSL_TARGET_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_TARGET_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGET_num);
    eval 'sub sk_OSSL_TARGET_value {
        my($sk, $idx) = @_;
	    eval q((( &OSSL_TARGET *) &OPENSSL_sk_value( &ossl_check_const_OSSL_TARGET_sk_type($sk), ($idx))));
    }' unless defined(&sk_OSSL_TARGET_value);
    eval 'sub sk_OSSL_TARGET_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGET) *) &OPENSSL_sk_new( &ossl_check_OSSL_TARGET_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_TARGET_new);
    eval 'sub sk_OSSL_TARGET_new_null () {
        eval q((( &STACK_OF( &OSSL_TARGET) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_OSSL_TARGET_new_null);
    eval 'sub sk_OSSL_TARGET_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGET) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_TARGET_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_OSSL_TARGET_new_reserve);
    eval 'sub sk_OSSL_TARGET_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_TARGET_sk_type($sk), ($n)));
    }' unless defined(&sk_OSSL_TARGET_reserve);
    eval 'sub sk_OSSL_TARGET_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_TARGET_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGET_free);
    eval 'sub sk_OSSL_TARGET_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_TARGET_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGET_zero);
    eval 'sub sk_OSSL_TARGET_delete {
        my($sk, $i) = @_;
	    eval q((( &OSSL_TARGET *) &OPENSSL_sk_delete( &ossl_check_OSSL_TARGET_sk_type($sk), ($i))));
    }' unless defined(&sk_OSSL_TARGET_delete);
    eval 'sub sk_OSSL_TARGET_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &OSSL_TARGET *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr))));
    }' unless defined(&sk_OSSL_TARGET_delete_ptr);
    eval 'sub sk_OSSL_TARGET_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr)));
    }' unless defined(&sk_OSSL_TARGET_push);
    eval 'sub sk_OSSL_TARGET_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr)));
    }' unless defined(&sk_OSSL_TARGET_unshift);
    eval 'sub sk_OSSL_TARGET_pop {
        my($sk) = @_;
	    eval q((( &OSSL_TARGET *) &OPENSSL_sk_pop( &ossl_check_OSSL_TARGET_sk_type($sk))));
    }' unless defined(&sk_OSSL_TARGET_pop);
    eval 'sub sk_OSSL_TARGET_shift {
        my($sk) = @_;
	    eval q((( &OSSL_TARGET *) &OPENSSL_sk_shift( &ossl_check_OSSL_TARGET_sk_type($sk))));
    }' unless defined(&sk_OSSL_TARGET_shift);
    eval 'sub sk_OSSL_TARGET_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_TARGET_sk_type($sk), &ossl_check_OSSL_TARGET_freefunc_type($freefunc)));
    }' unless defined(&sk_OSSL_TARGET_pop_free);
    eval 'sub sk_OSSL_TARGET_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr), ($idx)));
    }' unless defined(&sk_OSSL_TARGET_insert);
    eval 'sub sk_OSSL_TARGET_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &OSSL_TARGET *) &OPENSSL_sk_set( &ossl_check_OSSL_TARGET_sk_type($sk), ($idx),  &ossl_check_OSSL_TARGET_type($ptr))));
    }' unless defined(&sk_OSSL_TARGET_set);
    eval 'sub sk_OSSL_TARGET_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr)));
    }' unless defined(&sk_OSSL_TARGET_find);
    eval 'sub sk_OSSL_TARGET_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr)));
    }' unless defined(&sk_OSSL_TARGET_find_ex);
    eval 'sub sk_OSSL_TARGET_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_type($ptr), $pnum));
    }' unless defined(&sk_OSSL_TARGET_find_all);
    eval 'sub sk_OSSL_TARGET_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_TARGET_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGET_sort);
    eval 'sub sk_OSSL_TARGET_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_TARGET_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGET_is_sorted);
    eval 'sub sk_OSSL_TARGET_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGET) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_TARGET_sk_type($sk))));
    }' unless defined(&sk_OSSL_TARGET_dup);
    eval 'sub sk_OSSL_TARGET_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGET) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_copyfunc_type($copyfunc),  &ossl_check_OSSL_TARGET_freefunc_type($freefunc))));
    }' unless defined(&sk_OSSL_TARGET_deep_copy);
    eval 'sub sk_OSSL_TARGET_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_OSSL_TARGET_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_TARGET_sk_type($sk),  &ossl_check_OSSL_TARGET_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_TARGET_set_cmp_func);
    eval 'sub sk_OSSL_TARGETS_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_TARGETS_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGETS_num);
    eval 'sub sk_OSSL_TARGETS_value {
        my($sk, $idx) = @_;
	    eval q((( &OSSL_TARGETS *) &OPENSSL_sk_value( &ossl_check_const_OSSL_TARGETS_sk_type($sk), ($idx))));
    }' unless defined(&sk_OSSL_TARGETS_value);
    eval 'sub sk_OSSL_TARGETS_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGETS) *) &OPENSSL_sk_new( &ossl_check_OSSL_TARGETS_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_TARGETS_new);
    eval 'sub sk_OSSL_TARGETS_new_null () {
        eval q((( &STACK_OF( &OSSL_TARGETS) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_OSSL_TARGETS_new_null);
    eval 'sub sk_OSSL_TARGETS_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGETS) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_TARGETS_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_OSSL_TARGETS_new_reserve);
    eval 'sub sk_OSSL_TARGETS_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_TARGETS_sk_type($sk), ($n)));
    }' unless defined(&sk_OSSL_TARGETS_reserve);
    eval 'sub sk_OSSL_TARGETS_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_TARGETS_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGETS_free);
    eval 'sub sk_OSSL_TARGETS_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_TARGETS_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGETS_zero);
    eval 'sub sk_OSSL_TARGETS_delete {
        my($sk, $i) = @_;
	    eval q((( &OSSL_TARGETS *) &OPENSSL_sk_delete( &ossl_check_OSSL_TARGETS_sk_type($sk), ($i))));
    }' unless defined(&sk_OSSL_TARGETS_delete);
    eval 'sub sk_OSSL_TARGETS_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &OSSL_TARGETS *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr))));
    }' unless defined(&sk_OSSL_TARGETS_delete_ptr);
    eval 'sub sk_OSSL_TARGETS_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr)));
    }' unless defined(&sk_OSSL_TARGETS_push);
    eval 'sub sk_OSSL_TARGETS_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr)));
    }' unless defined(&sk_OSSL_TARGETS_unshift);
    eval 'sub sk_OSSL_TARGETS_pop {
        my($sk) = @_;
	    eval q((( &OSSL_TARGETS *) &OPENSSL_sk_pop( &ossl_check_OSSL_TARGETS_sk_type($sk))));
    }' unless defined(&sk_OSSL_TARGETS_pop);
    eval 'sub sk_OSSL_TARGETS_shift {
        my($sk) = @_;
	    eval q((( &OSSL_TARGETS *) &OPENSSL_sk_shift( &ossl_check_OSSL_TARGETS_sk_type($sk))));
    }' unless defined(&sk_OSSL_TARGETS_shift);
    eval 'sub sk_OSSL_TARGETS_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_TARGETS_sk_type($sk), &ossl_check_OSSL_TARGETS_freefunc_type($freefunc)));
    }' unless defined(&sk_OSSL_TARGETS_pop_free);
    eval 'sub sk_OSSL_TARGETS_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr), ($idx)));
    }' unless defined(&sk_OSSL_TARGETS_insert);
    eval 'sub sk_OSSL_TARGETS_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &OSSL_TARGETS *) &OPENSSL_sk_set( &ossl_check_OSSL_TARGETS_sk_type($sk), ($idx),  &ossl_check_OSSL_TARGETS_type($ptr))));
    }' unless defined(&sk_OSSL_TARGETS_set);
    eval 'sub sk_OSSL_TARGETS_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr)));
    }' unless defined(&sk_OSSL_TARGETS_find);
    eval 'sub sk_OSSL_TARGETS_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr)));
    }' unless defined(&sk_OSSL_TARGETS_find_ex);
    eval 'sub sk_OSSL_TARGETS_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_type($ptr), $pnum));
    }' unless defined(&sk_OSSL_TARGETS_find_all);
    eval 'sub sk_OSSL_TARGETS_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_TARGETS_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGETS_sort);
    eval 'sub sk_OSSL_TARGETS_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_TARGETS_sk_type($sk)));
    }' unless defined(&sk_OSSL_TARGETS_is_sorted);
    eval 'sub sk_OSSL_TARGETS_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGETS) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_TARGETS_sk_type($sk))));
    }' unless defined(&sk_OSSL_TARGETS_dup);
    eval 'sub sk_OSSL_TARGETS_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &OSSL_TARGETS) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_copyfunc_type($copyfunc),  &ossl_check_OSSL_TARGETS_freefunc_type($freefunc))));
    }' unless defined(&sk_OSSL_TARGETS_deep_copy);
    eval 'sub sk_OSSL_TARGETS_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_OSSL_TARGETS_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_TARGETS_sk_type($sk),  &ossl_check_OSSL_TARGETS_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_TARGETS_set_cmp_func);
    eval 'sub sk_OSSL_ISSUER_SERIAL_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_OSSL_ISSUER_SERIAL_sk_type($sk)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_num);
    eval 'sub sk_OSSL_ISSUER_SERIAL_value {
        my($sk, $idx) = @_;
	    eval q((( &OSSL_ISSUER_SERIAL *) &OPENSSL_sk_value( &ossl_check_const_OSSL_ISSUER_SERIAL_sk_type($sk), ($idx))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_value);
    eval 'sub sk_OSSL_ISSUER_SERIAL_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &OSSL_ISSUER_SERIAL) *) &OPENSSL_sk_new( &ossl_check_OSSL_ISSUER_SERIAL_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_new);
    eval 'sub sk_OSSL_ISSUER_SERIAL_new_null () {
        eval q((( &STACK_OF( &OSSL_ISSUER_SERIAL) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_new_null);
    eval 'sub sk_OSSL_ISSUER_SERIAL_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &OSSL_ISSUER_SERIAL) *) &OPENSSL_sk_new_reserve( &ossl_check_OSSL_ISSUER_SERIAL_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_new_reserve);
    eval 'sub sk_OSSL_ISSUER_SERIAL_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk), ($n)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_reserve);
    eval 'sub sk_OSSL_ISSUER_SERIAL_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_free);
    eval 'sub sk_OSSL_ISSUER_SERIAL_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_zero);
    eval 'sub sk_OSSL_ISSUER_SERIAL_delete {
        my($sk, $i) = @_;
	    eval q((( &OSSL_ISSUER_SERIAL *) &OPENSSL_sk_delete( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk), ($i))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_delete);
    eval 'sub sk_OSSL_ISSUER_SERIAL_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &OSSL_ISSUER_SERIAL *) &OPENSSL_sk_delete_ptr( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_delete_ptr);
    eval 'sub sk_OSSL_ISSUER_SERIAL_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_push);
    eval 'sub sk_OSSL_ISSUER_SERIAL_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_unshift);
    eval 'sub sk_OSSL_ISSUER_SERIAL_pop {
        my($sk) = @_;
	    eval q((( &OSSL_ISSUER_SERIAL *) &OPENSSL_sk_pop( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_pop);
    eval 'sub sk_OSSL_ISSUER_SERIAL_shift {
        my($sk) = @_;
	    eval q((( &OSSL_ISSUER_SERIAL *) &OPENSSL_sk_shift( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_shift);
    eval 'sub sk_OSSL_ISSUER_SERIAL_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk), &ossl_check_OSSL_ISSUER_SERIAL_freefunc_type($freefunc)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_pop_free);
    eval 'sub sk_OSSL_ISSUER_SERIAL_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr), ($idx)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_insert);
    eval 'sub sk_OSSL_ISSUER_SERIAL_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &OSSL_ISSUER_SERIAL *) &OPENSSL_sk_set( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk), ($idx),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_set);
    eval 'sub sk_OSSL_ISSUER_SERIAL_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_find);
    eval 'sub sk_OSSL_ISSUER_SERIAL_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_find_ex);
    eval 'sub sk_OSSL_ISSUER_SERIAL_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_type($ptr), $pnum));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_find_all);
    eval 'sub sk_OSSL_ISSUER_SERIAL_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_sort);
    eval 'sub sk_OSSL_ISSUER_SERIAL_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_OSSL_ISSUER_SERIAL_sk_type($sk)));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_is_sorted);
    eval 'sub sk_OSSL_ISSUER_SERIAL_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &OSSL_ISSUER_SERIAL) *) &OPENSSL_sk_dup( &ossl_check_const_OSSL_ISSUER_SERIAL_sk_type($sk))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_dup);
    eval 'sub sk_OSSL_ISSUER_SERIAL_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &OSSL_ISSUER_SERIAL) *) &OPENSSL_sk_deep_copy( &ossl_check_const_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_copyfunc_type($copyfunc),  &ossl_check_OSSL_ISSUER_SERIAL_freefunc_type($freefunc))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_deep_copy);
    eval 'sub sk_OSSL_ISSUER_SERIAL_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_OSSL_ISSUER_SERIAL_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_OSSL_ISSUER_SERIAL_sk_type($sk),  &ossl_check_OSSL_ISSUER_SERIAL_compfunc_type($cmp))));
    }' unless defined(&sk_OSSL_ISSUER_SERIAL_set_cmp_func);
}
1;
