--TEST--
Test for correct linebreaks for lines _longer_ than 76 chars.
--SKIPIF--
--FILE--
<?php
error_reporting(E_ALL); // ignore E_STRICT

include("Mail/mime.php");
$text     = '12345678901234567890123456789012345678901234567890123456789012345678901234567890';
$params   = Array(
    'content_type' => 'text/plain',
    'encoding'     => 'quoted-printable',
);

for ($i=74; $i <= strlen($text); $i++) {
    $input = substr($text, 0, $i);
    $mimePart = new Mail_mimePart($input, $params);
    $encoded  =  $mimePart->encode();
    $output = $encoded['body'];
    printf("input: %02d: %s\n", strlen($input), $input);

    $lines = explode("\r\n", $output);
    for($j=0; $j < count($lines); $j++) {
        $line = $lines[$j];
        if ($j + 1 < count($lines)) {
            $line_vis = $line.'\r\n';
        } else {
            $line_vis = $line;
        }
        printf("output:%02d: %s\n", strlen($line), $line_vis);
    }
    print("---\n");
}
--EXPECT--
input: 74: 12345678901234567890123456789012345678901234567890123456789012345678901234
output:74: 12345678901234567890123456789012345678901234567890123456789012345678901234
---
input: 75: 123456789012345678901234567890123456789012345678901234567890123456789012345
output:75: 123456789012345678901234567890123456789012345678901234567890123456789012345
---
input: 76: 1234567890123456789012345678901234567890123456789012345678901234567890123456
output:76: 1234567890123456789012345678901234567890123456789012345678901234567890123456
---
input: 77: 12345678901234567890123456789012345678901234567890123456789012345678901234567
output:76: 123456789012345678901234567890123456789012345678901234567890123456789012345=\r\n
output:02: 67
---
input: 78: 123456789012345678901234567890123456789012345678901234567890123456789012345678
output:76: 123456789012345678901234567890123456789012345678901234567890123456789012345=\r\n
output:03: 678
---
input: 79: 1234567890123456789012345678901234567890123456789012345678901234567890123456789
output:76: 123456789012345678901234567890123456789012345678901234567890123456789012345=\r\n
output:04: 6789
---
input: 80: 12345678901234567890123456789012345678901234567890123456789012345678901234567890
output:76: 123456789012345678901234567890123456789012345678901234567890123456789012345=\r\n
output:05: 67890
---
