/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.json.JsonBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaComplianceChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;

public class YamlJsonSchemaHighlightingInspection
extends LocalInspectionTool {
    public boolean myCaseInsensitiveEnum = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = YAMLBundle.message("inspections.schema.validation.name");
        if (string == null) {
            YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(JsonBundle.message((String)"json.schema.inspection.case.insensitive.enum", (Object[])new Object[0]), "myCaseInsensitiveEnum");
        return optionsPanel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        VirtualFile virtualFile;
        PsiFile file;
        if (holder == null) {
            YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(2);
        }
        if (!((file = holder.getFile()) instanceof YAMLFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        List<YAMLDocument> documents = ((YAMLFile)file).getDocuments();
        if (documents.size() != 1) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        YAMLValue root = documents.get(0).getTopLevelValue();
        if (root == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(5);
            }
            return psiElementVisitor;
        }
        JsonSchemaService service = JsonSchemaService.Impl.get((Project)file.getProject());
        if (!service.isApplicableToFile(virtualFile = file.getViewProvider().getVirtualFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(6);
            }
            return psiElementVisitor;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(virtualFile);
        if (rootSchema == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(7);
            }
            return psiElementVisitor;
        }
        JsonSchemaObject object = service.getSchemaObject(virtualFile);
        if (object == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(8);
            }
            return psiElementVisitor;
        }
        JsonComplianceCheckerOptions options = new JsonComplianceCheckerOptions(this.myCaseInsensitiveEnum);
        YamlPsiElementVisitor yamlPsiElementVisitor = new YamlPsiElementVisitor((PsiElement)root, object, holder, session, options){
            final /* synthetic */ PsiElement val$root;
            final /* synthetic */ JsonSchemaObject val$object;
            final /* synthetic */ ProblemsHolder val$holder;
            final /* synthetic */ LocalInspectionToolSession val$session;
            final /* synthetic */ JsonComplianceCheckerOptions val$options;
            {
                this.val$root = psiElement;
                this.val$object = jsonSchemaObject;
                this.val$holder = problemsHolder;
                this.val$session = localInspectionToolSession;
                this.val$options = jsonComplianceCheckerOptions;
            }

            public void visitElement(PsiElement element) {
                if (element != this.val$root) {
                    return;
                }
                JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)element, (JsonSchemaObject)this.val$object);
                if (walker == null) {
                    return;
                }
                new JsonSchemaComplianceChecker(this.val$object, this.val$holder, walker, this.val$session, this.val$options, "Schema validation: ").annotate(element);
            }
        };
        if (yamlPsiElementVisitor == null) {
            YamlJsonSchemaHighlightingInspection.$$$reportNull$$$0(9);
        }
        return yamlPsiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/schema/YamlJsonSchemaHighlightingInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/schema/YamlJsonSchemaHighlightingInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

