/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.jetbrains.php.lang.documentation.PhpClassDocSource;
import com.jetbrains.php.lang.documentation.PhpDefaultDocSource;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassMemberDocSource
extends PhpNamedElementDocSource {
    private final PhpClassMember myMember;
    private final PhpDocSource mySourceDelegate;

    public PhpClassMemberDocSource(PhpClassMember element) {
        super((PhpNamedElement)element);
        this.myMember = element;
        this.mySourceDelegate = element instanceof Method ? new PhpFunctionDocSource((Function)((Method)element)) : (element instanceof Field ? new PhpNamedElementDocSource((PhpNamedElement)element) : new PhpDefaultDocSource((PhpPsiElement)element));
    }

    @Override
    @Nullable
    public PhpDocComment getDocComment() {
        return this.mySourceDelegate.getDocComment();
    }

    @Override
    @NotNull
    public String getTitle() {
        String title = this.mySourceDelegate.getTitle();
        PhpDocComment docComment = this.myMember.getDocComment();
        title = PhpClassMemberDocSource.addSuffix(docComment, "abstract", null, title);
        title = PhpClassMemberDocSource.addSuffix(docComment, "final", null, title);
        title = PhpClassMemberDocSource.addSuffix(docComment, "static", null, title);
        String string = title = PhpClassMemberDocSource.addSuffix(docComment, "static", "staticvar", title);
        if (string == null) {
            PhpClassMemberDocSource.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String addSuffix(PhpDocComment docComment, String suffix, @Nullable String tag, String declaration) {
        PhpDocTag[] abstractTags;
        String docTag = "@" + (tag == null ? suffix : tag);
        if (docComment != null && (abstractTags = docComment.getTagElementsByName(docTag)).length != 0 && !declaration.contains(suffix)) {
            return suffix + " " + declaration;
        }
        return declaration;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.mySourceDelegate.getDescription();
        if (string == null) {
            PhpClassMemberDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getParameters() {
        return this.mySourceDelegate.getParameters();
    }

    @Override
    public String getReturnType() {
        return this.mySourceDelegate.getReturnType();
    }

    @Override
    public String getReturnDescription() {
        return this.mySourceDelegate.getReturnDescription();
    }

    @Override
    public String getSince() {
        return this.mySourceDelegate.getSince();
    }

    @Override
    public String getUses() {
        return this.mySourceDelegate.getUses();
    }

    @Override
    public String getLinks() {
        return this.mySourceDelegate.getLinks();
    }

    @Override
    public String getSeeItems() {
        return this.mySourceDelegate.getSeeItems();
    }

    @Override
    public String getVersion() {
        return this.mySourceDelegate.getVersion();
    }

    @Override
    public String getThrows() {
        return this.mySourceDelegate.getThrows();
    }

    @Override
    public String getNamespace() {
        return null;
    }

    @Override
    public String getPackage() {
        PhpClass klass = this.myMember.getContainingClass();
        if (klass != null) {
            PhpClassDocSource classSource = new PhpClassDocSource(klass);
            return classSource.getPackage();
        }
        return null;
    }

    @Override
    public String getSubpackage() {
        PhpClass klass = this.myMember.getContainingClass();
        if (klass != null) {
            PhpClassDocSource classSource = new PhpClassDocSource(klass);
            return classSource.getSubpackage();
        }
        return null;
    }

    @Override
    public String getDeclaredIn() {
        PhpClass klass = this.myMember.getContainingClass();
        if (klass != null) {
            StringBuilder buffer = new StringBuilder();
            PhpClassMemberDocSource.appendLink(buffer, klass.getFQN(), null);
            return buffer.toString();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/documentation/PhpClassMemberDocSource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

