/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersHandlerFactory;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpFormatFunctionParametersMismatchInspection
extends PhpInspection {
    private static final String PARAMETER_MESSAGE = PhpBundle.message("inspection.format.function.parameters.mismatch.parameter", new Object[0]);
    private static final String STRING_MESSAGE = PhpBundle.message("inspection.format.function.parameters.mismatch.conversion.specification", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFormatFunctionParametersMismatchInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkReference(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkReference((FunctionReference)reference);
            }

            private void checkReference(FunctionReference reference) {
                String fqn = PhpHighlightFormatStringParametersHandlerFactory.resolveFqn(reference);
                int formatStringIndex = PhpHighlightFormatStringParametersHandlerFactory.getFormatStringIndex(holder.getProject(), fqn);
                PsiElement[] parameters = reference.getParameters();
                if (formatStringIndex < 0 || formatStringIndex >= parameters.length) {
                    return;
                }
                StringLiteralExpression formatExpression = (StringLiteralExpression)ObjectUtils.tryCast((Object)parameters[formatStringIndex], StringLiteralExpression.class);
                if (formatExpression == null) {
                    return;
                }
                MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications = PhpConversionSpecificationParser.parseConversionSpecifications(formatExpression.getContents(), formatExpression.isSingleQuote() || PhpHeredocToStringIntention.isNowdoc((PsiElement)formatExpression));
                this.checkFormatStringSpecifications(formatStringIndex, parameters, specifications, formatExpression);
                this.checkParameters(formatStringIndex, parameters, specifications);
            }

            private void checkParameters(int formatStringIndex, PsiElement[] parameters, MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications) {
                for (int i = formatStringIndex + 1; i < parameters.length; ++i) {
                    if (specifications.containsKey((Object)(i - formatStringIndex))) continue;
                    holder.registerProblem(parameters[i], PARAMETER_MESSAGE, new LocalQuickFix[0]);
                }
            }

            private void checkFormatStringSpecifications(int formatStringIndex, PsiElement[] parameters, MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications, StringLiteralExpression formatExpression) {
                int valueRangeStart = formatExpression.getValueRange().getStartOffset();
                specifications.entrySet().stream().filter(e -> (Integer)e.getKey() + formatStringIndex >= parameters.length).flatMap(e -> ((Collection)e.getValue()).stream()).map(specification -> specification.getRangeInElement().shiftRight(valueRangeStart)).forEach(range -> {
                    if (holder == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    holder.registerProblem((PsiElement)formatExpression, range, STRING_MESSAGE, new LocalQuickFix[0]);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpFormatFunctionParametersMismatchInspection$1", "lambda$checkFormatStringSpecifications$3"));
            }
        };
        if (phpElementVisitor == null) {
            PhpFormatFunctionParametersMismatchInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFormatFunctionParametersMismatchInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFormatFunctionParametersMismatchInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

