/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddFieldDeclarationQuickFix
extends PhpQuickFixBase {
    public static final PhpAddFieldDeclarationQuickFix INSTANCE = new PhpAddFieldDeclarationQuickFix();

    protected PhpAddFieldDeclarationQuickFix() {
    }

    @Nullable
    public static PhpModifier.Access getSettings() {
        return PhpRefactoringSettings.getInstance().EXTRACT_FIELD_DEFAULT_VISIBILITY;
    }

    @Nullable
    public static PsiElement addFieldToClass(@NotNull Project project, @NotNull PhpClass klass, @NotNull String fieldName, @NotNull PhpModifier.Access access, boolean staticRef) {
        if (project == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        if (access == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false)) {
            Messages.showErrorDialog((Project)project, (String)("The original class " + klass.getName() + " does not belong to the project\nand can not be modified."), (String)"Quick Fix Error");
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("class c { ");
        builder.append(access.toString());
        builder.append(" ");
        if (staticRef) {
            builder.append("static ");
        }
        if (!fieldName.startsWith("$")) {
            builder.append("$");
        }
        builder.append(fieldName);
        builder.append(";}");
        Field field = PhpPsiElementFactory.createFromText(klass.getProject(), Field.class, builder.toString());
        Ref insertedRef = new Ref();
        if (field != null && FileModificationService.getInstance().prepareFileForWrite(klass.getContainingFile())) {
            insertedRef.set(WriteAction.compute(() -> {
                if (klass == null) {
                    PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(13);
                }
                return PhpCodeEditUtil.insertClassMember(klass, field.getParent());
            }));
            PsiElement member = (PsiElement)insertedRef.get();
            if (member != null && member.isValid()) {
                PhpCodeUtil.openRelatedFile(project, member);
            }
        }
        return (PsiElement)insertedRef.get();
    }

    @NotNull
    public String getName() {
        if ("Add field" == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        return "Add field";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpModifier.Access access;
        if (project == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(7);
        }
        if ((access = PhpAddFieldDeclarationQuickFix.getSettings()) != null) {
            String fieldName;
            PsiElement field;
            PsiElement fieldNameElement = descriptor.getPsiElement();
            MemberReference reference = (MemberReference)PsiTreeUtil.getParentOfType((PsiElement)fieldNameElement, MemberReference.class, (boolean)false);
            if (reference == null) {
                return;
            }
            boolean staticRef = reference.getReferenceType().isStatic();
            PhpClass klass = PhpAddFieldDeclarationQuickFix.resolveClass(reference, true);
            if (klass != null && (field = PhpAddFieldDeclarationQuickFix.addFieldToClass(project, klass, fieldName = fieldNameElement.getText(), access, staticRef)) != null) {
                PhpAddFieldDeclarationQuickFix.runTemplate(field, PhpAddFieldDeclarationQuickFix.createTemplate(field), null);
            }
        }
    }

    @NotNull
    public static Template createTemplate(@NotNull PsiElement field) {
        if (field == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(8);
        }
        field = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)field);
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl(field);
        PhpPsiElement accessElement = ((PhpPsiElement)field).getFirstPsiChild();
        if (accessElement != null) {
            templateBuilder.replaceElement((PsiElement)accessElement, accessElement.getText());
        }
        Template template = templateBuilder.buildTemplate();
        if (template == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(9);
        }
        return template;
    }

    public static void runTemplate(@NotNull PsiElement element, @NotNull Template template, @Nullable TemplateEditingListener listener) {
        Project project;
        Editor editor;
        if (element == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        if (template == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(11);
        }
        if ((editor = FileEditorManager.getInstance((Project)(project = element.getProject())).getSelectedTextEditor()) != null) {
            TextRange range = element.getTextRange();
            WriteAction.run(() -> {
                if (template == null) {
                    PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(12);
                }
                editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template, listener);
            });
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddFieldDeclarationQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddFieldDeclarationQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFieldToClass";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTemplate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runTemplate$1";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addFieldToClass$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

