/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolConfiguration;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.ui.PhpUiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QualityToolConfigurableForm<C extends QualityToolConfiguration>
implements Configurable,
SearchableConfigurable {
    protected TextFieldWithBrowseButton myToolPathField;
    private JButton myValidateButton;
    private JPanel myTopPanel;
    private JTextField myMessagesPerFile;
    private JTextField myTimeoutField;
    private JBLabel myToolPathLabel;
    private final C myConfiguration;
    protected final Project myProject;
    protected final String myToolName;
    protected final String myToolLauncher;

    public QualityToolConfigurableForm(@NotNull Project project, C configuration) {
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(0);
        }
        this(project, configuration, "Tool Path", "");
    }

    public QualityToolConfigurableForm(@NotNull Project project, C configuration, @NotNull String toolName, @NotNull String launcherName) {
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(1);
        }
        if (toolName == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(2);
        }
        if (launcherName == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myToolName = toolName;
        this.myToolLauncher = launcherName;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        this.myToolPathField.setText(this.myConfiguration.getToolPath());
        this.myValidateButton.addActionListener(e -> this.validateConfiguration(this.myToolPathField.getText()));
        this.myMessagesPerFile.setMinimumSize(new Dimension(30, 0));
        this.myToolPathLabel.setText(this.getToolName() + " path:");
    }

    public JComponent createComponent() {
        return this.myTopPanel;
    }

    protected void addBrowseFolderListener(@NotNull Project project, @NotNull TextFieldWithBrowseButton textField) {
        if (project == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(4);
        }
        if (textField == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(5);
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return file.isDirectory() || QualityToolConfigurableForm.this.isValidToolFile(file);
            }
        };
        textField.addBrowseFolderListener(this.getToolLauncherName() + " location", "Choose a valid " + this.getToolLauncherName() + " launcher", null, descriptor);
    }

    public boolean isModified() {
        return !this.myConfiguration.getToolPath().equals(this.myToolPathField.getText()) || this.myConfiguration.getMaxMessagesPerFile() != this.getMaxMessagesPerFile() || this.myConfiguration.getTimeout() != this.getTimeout();
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setToolPath(this.myToolPathField.getText());
        this.myConfiguration.setMaxMessagesPerFile(this.getMaxMessagesPerFile());
        this.myConfiguration.setTimeout(this.getTimeout());
    }

    public void reset() {
        this.myMessagesPerFile.setText(Integer.toString(this.myConfiguration.getMaxMessagesPerFile()));
        this.myToolPathField.setText(this.myConfiguration.getToolPath());
        this.myTimeoutField.setText(Integer.toString(this.myConfiguration.getTimeout() / 1000));
    }

    public void disposeUIResources() {
    }

    @NotNull
    public C getConfiguration() {
        C c = this.myConfiguration;
        if (c == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(6);
        }
        return c;
    }

    private void createUIComponents() {
        this.myToolPathField = new TextFieldWithBrowseButton();
        this.addBrowseFolderListener(this.myProject, this.myToolPathField);
    }

    private void validateConfiguration(String toolPath) {
        this.myToolPathField.setEnabled(true);
        this.myValidateButton.setEnabled(false);
        C configuration = this.getConfiguration();
        String id = configuration.getInterpreterId();
        int timeout = configuration.getTimeout();
        try {
            ProcessOutput output = QualityToolProcessCreator.getToolOutput(this.myProject, id, toolPath, timeout, "Validating...", this.myTopPanel, "--version");
            this.myValidateButton.setEnabled(true);
            Pair<Boolean, String> validationResult = this.validateToolResult(output.getStdout());
            PhpUiUtil.showBalloon((String)validationResult.second, (Boolean)validationResult.first != false ? MessageType.INFO : MessageType.ERROR, (Component)this.myToolPathField);
        }
        catch (ExecutionException e) {
            this.myValidateButton.setEnabled(true);
            PhpUiUtil.showBalloon(StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("quality.tool.unknown.problem", new Object[0])), MessageType.ERROR, (Component)this.myToolPathField);
        }
    }

    @NotNull
    public String getToolName() {
        String string = this.myToolName;
        if (string == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getToolLauncherName() {
        String string = this.myToolLauncher;
        if (string == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Pair<Boolean, String> validateToolResult(@Nullable String message) {
        Pair pair = StringUtil.isEmpty((String)message) ? new Pair((Object)false, (Object)("Can not run " + this.getToolName())) : this.validateMessage(message);
        if (pair == null) {
            QualityToolConfigurableForm.$$$reportNull$$$0(9);
        }
        return pair;
    }

    @NotNull
    public abstract Pair<Boolean, String> validateMessage(String var1);

    public abstract boolean isValidToolFile(VirtualFile var1);

    private int getMaxMessagesPerFile() {
        int oldValue;
        String stringValue = this.myMessagesPerFile.getText();
        int newValue = oldValue = this.myConfiguration.getMaxMessagesPerFile();
        try {
            newValue = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (newValue < 1 || newValue > 100) {
            return oldValue;
        }
        return newValue;
    }

    private int getTimeout() {
        int oldValue;
        String stringValue = this.myTimeoutField.getText();
        int newValue = oldValue = this.myConfiguration.getTimeout() / 1000;
        try {
            newValue = Integer.parseInt(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (newValue < 1 || newValue > 30) {
            return oldValue * 1000;
        }
        return newValue * 1000;
    }

    @Nullable
    protected static Version extractVersion(String versionString) {
        String[] chunks = versionString.split("\\.");
        int major = 0;
        int minor = 0;
        int nano = 0;
        try {
            if (chunks.length > 0) {
                major = Integer.parseInt(chunks[0]);
                if (chunks.length > 1) {
                    minor = Integer.parseInt(chunks[1]);
                    if (chunks.length > 2) {
                        nano = Integer.parseInt(chunks[2]);
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Version(major, minor, nano);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolConfigurableForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolConfigurableForm";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolLauncherName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "validateToolResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JButton jButton;
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel;
        this.createUIComponents();
        this.myTopPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(5, 5, 5, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 2, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Max number of messages per file [1...100]:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMessagesPerFile = jTextField2 = new JTextField();
        jTextField2.setHorizontalAlignment(4);
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTimeoutField = jTextField = new JTextField();
        jTextField.setHorizontalAlignment(4);
        jPanel4.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 0, 0, new Dimension(50, -1), new Dimension(50, -1), new Dimension(50, -1)));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Tool process timeout, sec [1...30]:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myToolPathField;
        jPanel6.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        this.myValidateButton = jButton = new JButton();
        jButton.setText("Validate");
        jPanel6.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 4, 0, 1, 3, null, null, null));
        this.myToolPathLabel = jBLabel = new JBLabel();
        jBLabel.setText("Tool path:");
        jPanel5.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }
}

