/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.DockerCloudType;
import com.intellij.docker.deployment.ui.DockerComposeFilesTextField;
import com.intellij.docker.remote.DockerComposeCredentialsEditorLanguageContribution;
import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.CredentialsLanguageContribution;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.util.CloudAccountSelectionEditor;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeCredentialsEditor
implements CredentialsEditor<DockerComposeCredentialsHolder>,
PanelWithAnchor {
    private static final Logger LOG = Logger.getInstance(DockerComposeCredentialsEditor.class);
    private JPanel myMainPanel;
    private JPanel myDockerAccountSelectionPlaceHolder;
    private ComboBox<String> myDockerComposeServiceNameComboBox;
    private EnvironmentVariablesComponent myEnvsComponent;
    private JBLabel myConfigurationFilesLabel;
    private DockerComposeFilesTextField myConfigurationFilesTextField;
    @Nullable
    private final Project myProject;
    @NotNull
    private final StatusPanel myStatusPanel;
    @Nullable
    private final DockerComposeCredentialsEditorLanguageContribution<?> myEditorLanguageContribution;
    private final CloudAccountSelectionEditor myDockerAccountSelectionEditor;
    private boolean myConfigurationPathShouldBeInitialized;
    private String myConfigurationError;
    private boolean myValidationPhase;
    @Nullable
    private JComponent myAnchor;

    public DockerComposeCredentialsEditor(@Nullable Project project, @NotNull CredentialsLanguageContribution languageContribution, @NotNull StatusPanel statusPanel) {
        if (languageContribution == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (statusPanel == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(1);
        }
        this.myConfigurationPathShouldBeInitialized = true;
        this.myProject = project;
        this.myStatusPanel = statusPanel;
        this.$$$setupUI$$$();
        this.myEditorLanguageContribution = DockerComposeCredentialsEditor.findEditorContribution(languageContribution);
        this.myDockerAccountSelectionEditor = new CloudAccountSelectionEditor(Collections.singletonList(DockerCloudType.getInstance()));
        this.myDockerAccountSelectionPlaceHolder.add(this.myDockerAccountSelectionEditor.getMainPanel());
        this.myConfigurationFilesLabel.setLabelFor((Component)this.myConfigurationFilesTextField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceNameComboBox() {
        StatusPanel.Action action = this.myStatusPanel.progress("Processing Docker Compose configuration...");
        CollectionComboBoxModel model = new CollectionComboBoxModel();
        this.myConfigurationError = null;
        try {
            if (this.myEditorLanguageContribution != null) {
                ArrayList<String> configurationFilePaths = new ArrayList<String>();
                List files = this.myConfigurationFilesTextField.getConfigurationFiles();
                for (int i = 0; i < files.size(); ++i) {
                    String configurationFile = (String)files.get(i);
                    if (Files.exists(Paths.get(configurationFile, new String[0]), new LinkOption[0])) {
                        configurationFilePaths.add(configurationFile);
                        continue;
                    }
                    if (i != 0) continue;
                    throw new FileNotFoundException(String.format("Base configuration file \"%s\" does not exist", configurationFile));
                }
                DockerComposeCredentialsEditorLanguageContribution.DockerComposeConfigurationInfo info = this.myEditorLanguageContribution.getDockerComposeConfigurationInfo(configurationFilePaths);
                ArrayList<String> services = new ArrayList<String>(info.getServices());
                services.sort(String.CASE_INSENSITIVE_ORDER);
                model = new CollectionComboBoxModel(services);
                action.done();
            }
        }
        catch (FileNotFoundException e) {
            LOG.debug((Throwable)e);
            this.myConfigurationError = e.getMessage();
            if (!this.myValidationPhase) {
                action.failed(this.myConfigurationError);
            }
        }
        catch (IOException | RuntimeException e) {
            LOG.debug((Throwable)e);
            this.myConfigurationError = e.getMessage();
            if (!this.myValidationPhase) {
                action.failed(this.myConfigurationError);
            }
        }
        finally {
            this.myDockerComposeServiceNameComboBox.setModel((ComboBoxModel)model);
            action.done();
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void onSelected() {
        if (this.myProject != null && this.myConfigurationPathShouldBeInitialized) {
            try {
                if (this.myProject.getBasePath() != null) {
                    this.myConfigurationFilesTextField.initComposeFilePaths(this.myProject.getBasePath());
                }
            }
            finally {
                this.myConfigurationPathShouldBeInitialized = false;
            }
        }
    }

    public ValidationInfo validate() {
        this.myValidationPhase = true;
        RemoteServer selectedAccount = this.myDockerAccountSelectionEditor.getSelectedAccount();
        if (selectedAccount == null) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("Docker server is not selected", this.myDockerAccountSelectionEditor.getMainPanel());
        }
        if (this.myConfigurationFilesTextField.getConfigurationFiles().isEmpty()) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("Configuration files are not chosen", (JComponent)this.myConfigurationFilesTextField);
        }
        if (StringUtil.isNotEmpty((String)this.myConfigurationError)) {
            this.myStatusPanel.resetState();
            return new ValidationInfo(this.myConfigurationError, (JComponent)this.myConfigurationFilesTextField);
        }
        if (this.myDockerComposeServiceNameComboBox.getItemCount() == 0) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("No services defined in the configuration file(s)", this.myDockerComposeServiceNameComboBox);
        }
        String serviceName = (String)this.myDockerComposeServiceNameComboBox.getSelectedItem();
        if (StringUtil.isEmpty((String)serviceName)) {
            this.myStatusPanel.resetState();
            return new ValidationInfo("Service name is not selected", this.myDockerComposeServiceNameComboBox);
        }
        return null;
    }

    private void createUIComponents() {
        this.myConfigurationFilesTextField = new DockerComposeFilesTextField(this.myProject);
        this.myConfigurationFilesTextField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                DockerComposeCredentialsEditor.this.updateServiceNameComboBox();
            }
        });
    }

    @Nullable
    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myConfigurationFilesLabel.setAnchor(anchor);
        this.myEnvsComponent.setAnchor(anchor);
        this.myEnvsComponent.invalidate();
    }

    @Nullable
    private static DockerComposeCredentialsEditorLanguageContribution<?> findEditorContribution(@NotNull CredentialsLanguageContribution languageContribution) {
        if (languageContribution == null) {
            DockerComposeCredentialsEditor.$$$reportNull$$$0(2);
        }
        for (DockerComposeCredentialsEditorLanguageContribution o : (DockerComposeCredentialsEditorLanguageContribution[])DockerComposeCredentialsEditorLanguageContribution.EP_NAME.getExtensions()) {
            if (o.getLanguageContribution() != languageContribution) continue;
            return o;
        }
        return null;
    }

    public void saveCredentials(DockerComposeCredentialsHolder credentials) {
        RemoteServer account = this.myDockerAccountSelectionEditor.getSelectedAccount();
        String accountName = account == null ? null : account.getName();
        credentials.setAccountName(accountName);
        credentials.setComposeFilePaths(ContainerUtil.newArrayList((Iterable)this.myConfigurationFilesTextField.getConfigurationFiles()));
        credentials.setComposeServiceName((String)this.myDockerComposeServiceNameComboBox.getSelectedItem());
        credentials.setRemoteProjectPath("/opt/project");
        credentials.setEnvs(this.myEnvsComponent.getEnvData());
    }

    public void init(DockerComposeCredentialsHolder credentials) {
        this.myConfigurationPathShouldBeInitialized = false;
        this.myDockerAccountSelectionEditor.setSelectedAccount(credentials.getAccountName());
        this.myConfigurationFilesTextField.initComposeFilePaths(credentials.getComposeFilePaths());
        this.myDockerComposeServiceNameComboBox.setSelectedItem((Object)credentials.getComposeServiceName());
        this.myEnvsComponent.setEnvData(credentials.getEnvs());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageContribution";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/remote/DockerComposeCredentialsEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findEditorContribution";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        EnvironmentVariablesComponent environmentVariablesComponent;
        ComboBox comboBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Server:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myDockerAccountSelectionPlaceHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Service:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerComposeServiceNameComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myEnvsComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        environmentVariablesComponent.setLabelLocation("West");
        environmentVariablesComponent.setText("&Environment variables");
        jPanel2.add((Component)environmentVariablesComponent, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        DockerComposeFilesTextField dockerComposeFilesTextField = this.myConfigurationFilesTextField;
        jPanel3.add((Component)dockerComposeFilesTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myConfigurationFilesLabel = jBLabel = new JBLabel();
        jBLabel.setText("Configuration file(s):");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

