/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLUtil {
    public static final String CDATA_PREFIX = "<![CDATA[";
    public static final String CDATA_SUFFIX = "]]>";
    public static final String EMPTY_STR = "";
    private static final Pattern tagPattern = Pattern.compile("[A-Za-z_][A-Za-z0-9_.-]*");
    private static final Pattern attributePattern = Pattern.compile("[A-Za-z_:][A-Za-z0-9_:.-]*");

    private XMLUtil() {
    }

    public static boolean tagNameIsValid(String tagName) {
        Matcher matcher = tagPattern.matcher(tagName);
        return matcher.matches();
    }

    public static boolean attributeNameIsValid(String attributeName) {
        Matcher matcher = attributePattern.matcher(attributeName);
        return matcher.matches();
    }

    public static String XMLEscape(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block7: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static String XMLUnEscape(String s) {
        if (s == null) {
            return s;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '&') {
                String subStr;
                int subEndIndex = i + 8;
                if (subEndIndex > len) {
                    subEndIndex = len;
                }
                if ((subStr = s.substring(i, subEndIndex)).startsWith("&amp;")) {
                    sb.append('&');
                    i += "amp;".length();
                    continue;
                }
                if (subStr.startsWith("&lt;")) {
                    sb.append('<');
                    i += "lt;".length();
                    continue;
                }
                if (subStr.startsWith("&gt;")) {
                    sb.append('>');
                    i += "gt;".length();
                    continue;
                }
                if (subStr.startsWith("&apos;")) {
                    sb.append('\'');
                    i += "apos;".length();
                    continue;
                }
                if (subStr.startsWith("&quot;")) {
                    sb.append('\"');
                    i += "quot;".length();
                    continue;
                }
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String formatCDataWrapper(String str) {
        if (str == null) {
            str = EMPTY_STR;
        }
        return CDATA_PREFIX + str + CDATA_SUFFIX;
    }

    public static String stripCDataWrapper(String str) {
        if (str == null) {
            return null;
        }
        String trimmedStr = str.trim();
        if (!trimmedStr.startsWith(CDATA_PREFIX)) {
            return str;
        }
        if (!(trimmedStr = trimmedStr.substring(CDATA_PREFIX.length())).endsWith(CDATA_SUFFIX)) {
            return str;
        }
        if (trimmedStr.length() == CDATA_SUFFIX.length()) {
            return EMPTY_STR;
        }
        return trimmedStr.substring(0, trimmedStr.lastIndexOf(CDATA_SUFFIX));
    }

    public static boolean isWhitespace(String contents) {
        for (int i = 0; i < contents.length(); ++i) {
            char ch = contents.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsOuterElements(PsiElement elt) {
        final boolean[] result = new boolean[]{false};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitOuterLanguageElement(OuterLanguageElement element) {
                result[0] = true;
            }

            public void visitElement(PsiElement element) {
                if (!result[0]) {
                    super.visitElement(element);
                }
            }
        });
        return result[0];
    }

    public static String attributeNameFromTag(String tagName, String attributeName) {
        int colonIndex = tagName.indexOf(58);
        if (colonIndex >= 0) {
            String prefix = tagName.substring(0, colonIndex + 1);
            String suffix = tagName.substring(colonIndex + 1);
            return prefix + XMLUtil.matchCase(suffix, attributeName);
        }
        return XMLUtil.matchCase(tagName, attributeName);
    }

    private static String matchCase(String stringToMatch, String stringMatched) {
        if (stringMatched == null || stringMatched.length() == 0) {
            return stringToMatch.toLowerCase();
        }
        if (XMLUtil.isAllLowerCase(stringMatched)) {
            return stringToMatch.toLowerCase();
        }
        if (XMLUtil.isAllUpperCase(stringMatched)) {
            return stringToMatch.toUpperCase();
        }
        char startingChar = stringMatched.charAt(0);
        if (Character.isLowerCase(startingChar)) {
            return Character.toLowerCase(stringToMatch.charAt(0)) + stringToMatch.substring(1);
        }
        if (Character.isUpperCase(startingChar)) {
            return Character.toUpperCase(stringToMatch.charAt(0)) + stringToMatch.substring(1);
        }
        return stringToMatch;
    }

    private static boolean isAllLowerCase(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllUpperCase(String string) {
        char[] chars;
        for (char c : chars = string.toCharArray()) {
            if (!Character.isLetter(c) || Character.isUpperCase(c)) continue;
            return false;
        }
        return true;
    }
}

