/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.sockets;

import a.b.lb;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.sockets.MySftpSocketFactory;
import com.jcraft.jsch.SocketFactory;
import java.lang.invoke.MethodHandles;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SocketUtils {
    private static final Logger a;
    private static final long b;

    private SocketUtils() {
    }

    @Nullable
    public static SocketFactory getSftpSocketFactory(@NotNull String host) {
        if (host == null) {
            SocketUtils.a(0);
        }
        if (SocketUtils.shouldPatchSocketsOnMacForIPv6(host)) {
            return new MySftpSocketFactory(null);
        }
        return null;
    }

    public static boolean shouldPatchSocketsOnMacForIPv6(String host) {
        long l3 = b ^ 0x587ABEBA5707L;
        if (!SocketUtils.systemIsPatchable()) {
            return false;
        }
        try {
            boolean bl2;
            InetAddress inetAddress = InetAddress.getByName(host);
            boolean bl3 = bl2 = inetAddress instanceof Inet6Address && !StringUtil.isEmptyOrSpaces((String)SocketUtils.a());
            if (bl2) {
                a.debug("Socket patching needed for " + host);
            }
            return bl2;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean systemIsPatchable() {
        return SystemInfo.isMac;
    }

    static InetAddress getProperAddressIfNeeded(@NotNull InetAddress inetAddress) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        if (inetAddress == null) {
            SocketUtils.a(1);
        }
        if (SocketUtils.systemIsPatchable() && inetAddress instanceof Inet6Address && (networkInterface = SocketUtils.findProperIpv6HostNetworkInterface()) != null) {
            return SocketUtils.a(networkInterface, (Inet6Address)inetAddress);
        }
        return null;
    }

    @Nullable
    public static NetworkInterface findProperIpv6HostNetworkInterface() throws SocketException {
        long l3 = b ^ 0x7817F58BF293L;
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        String string = SocketUtils.a();
        NetworkInterface networkInterface = null;
        NetworkInterface networkInterface2 = null;
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface3 = enumeration.nextElement();
            if (string.contains(networkInterface3.getName())) continue;
            if (!networkInterface3.isUp()) {
                a.debug("Interface " + networkInterface3 + " is down ");
                continue;
            }
            for (InterfaceAddress interfaceAddress : networkInterface3.getInterfaceAddresses()) {
                InetAddress inetAddress = interfaceAddress.getAddress();
                if (!(inetAddress instanceof Inet6Address)) continue;
                if (networkInterface3.isLoopback()) {
                    networkInterface2 = networkInterface3;
                    break;
                }
                if (!inetAddress.isLinkLocalAddress()) {
                    a.debug("Using interface " + networkInterface3);
                    return networkInterface3;
                }
                if (networkInterface != null) continue;
                networkInterface = networkInterface3;
            }
            a.debug("No ipv6 addresses for " + networkInterface3);
        }
        if (networkInterface != null) {
            a.debug("Using link-local interface " + networkInterface);
            return networkInterface;
        }
        if (networkInterface2 != null) {
            a.debug("Using loopback interface " + networkInterface2);
            return networkInterface2;
        }
        return null;
    }

    @NotNull
    private static InetAddress a(@NotNull NetworkInterface networkInterface, Inet6Address inet6Address) throws UnknownHostException {
        if (networkInterface == null) {
            SocketUtils.a(2);
        }
        Inet6Address inet6Address2 = Inet6Address.getByAddress(inet6Address.getHostAddress(), inet6Address.getAddress(), networkInterface.getIndex());
        if (inet6Address2 == null) {
            SocketUtils.a(3);
        }
        return inet6Address2;
    }

    @NotNull
    private static String a() {
        long l3 = b ^ 0x3E4F84A962E6L;
        String string = Registry.get((String)"deployment.macOs.bannedInterfaces").asString();
        if (string == null) {
            SocketUtils.a(4);
        }
        return string;
    }

    static {
        b = lb.a(6968078342027187101L, -4931940728125851969L, MethodHandles.lookup().lookupClass()).a(21736791450343L);
        a = Logger.getInstance(SocketUtils.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l3 = b ^ 0x2C7550B19F29L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inetAddress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/sockets/SocketUtils";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/sockets/SocketUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddressForInterface";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBannedInterfaces";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSftpSocketFactory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProperAddressIfNeeded";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAddressForInterface";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

