/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.intellij.lang.xpath.XPathTokenTypes;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.psi.XPathFunction;
import org.intellij.lang.xpath.psi.XPathFunctionCall;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPathParameterInfoHandler
implements ParameterInfoHandler<XPathFunctionCall, XPathFunction> {
    public boolean couldShowInLookup() {
        return false;
    }

    public Object[] getParametersForLookup(LookupElement lookupElement, ParameterInfoContext parameterInfoContext) {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public XPathFunctionCall findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        XPathFunction function;
        XPathFunctionCall call;
        if (context == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((call = XPathParameterInfoHandler.findFunctionCall(context.getFile(), context.getOffset())) != null && (function = call.resolve()) != null && function.getDeclaration() != null) {
            context.setItemsToShow(new Object[]{function});
        }
        return call;
    }

    @Nullable
    private static XPathFunctionCall findFunctionCall(PsiFile psiFile, int offset) {
        XPathFunctionCall call;
        PsiElement e = psiFile.findElementAt(offset);
        while (e != null && (call = (XPathFunctionCall)PsiTreeUtil.getParentOfType((PsiElement)e, XPathFunctionCall.class)) != null) {
            ASTNode lparen = call.getNode().findChildByType(XPathTokenTypes.LPAREN);
            if (lparen != null && lparen.getTextRange().getStartOffset() < offset) {
                return call;
            }
            e = PsiTreeUtil.getParentOfType((PsiElement)e, XPathFunctionCall.class, (boolean)true);
        }
        return null;
    }

    public void showParameterInfo(@NotNull XPathFunctionCall call, @NotNull CreateParameterInfoContext context) {
        if (call == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(2);
        }
        context.showHint((PsiElement)call, call.getTextOffset() + 1, (ParameterInfoHandler)this);
    }

    public XPathFunctionCall findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return XPathParameterInfoHandler.findFunctionCall(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull XPathFunctionCall call, @NotNull UpdateParameterInfoContext context) {
        if (call == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)call.getNode(), (int)context.getOffset(), (IElementType)XPathTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    public void updateUI(XPathFunction function, @NotNull ParameterInfoUIContext context) {
        Function declaration;
        if (context == null) {
            XPathParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if ((declaration = function.getDeclaration()) != null) {
            if (declaration.getParameters().length > 0) {
                String signature = declaration.buildSignature();
                int length = declaration.getName().length();
                String hint = signature.substring(length + 1, signature.length() - 1);
                int currentParameterIndex = context.getCurrentParameterIndex();
                if (currentParameterIndex < 0 || currentParameterIndex >= declaration.getParameters().length) {
                    context.setupUIComponentPresentation(hint, -1, -1, false, false, false, context.getDefaultParameterColor());
                } else {
                    String[] ps = hint.split(",");
                    TextRange[] ts = new TextRange[ps.length];
                    int start = 0;
                    for (int i = 0; i < ps.length; ++i) {
                        String p = ps[i];
                        ts[i] = TextRange.from((int)start, (int)p.length());
                        start += p.length() + 1;
                    }
                    TextRange range = ts[currentParameterIndex];
                    context.setupUIComponentPresentation(hint, range.getStartOffset(), range.getEndOffset(), false, false, false, context.getDefaultParameterColor());
                }
            } else {
                context.setupUIComponentPresentation(XPathParameterInfoHandler.noParamsMessage(), -1, -1, false, false, false, context.getDefaultParameterColor());
            }
        }
    }

    private static String noParamsMessage() {
        return CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/xpath/XPathParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

