/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class _LastInSuiteTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        Disposer.setDebugMode((boolean)true);
    }

    public String getName() {
        String name = super.getName();
        String buildConf = System.getProperty("teamcity.buildConfName");
        return buildConf == null ? name : name + "[" + buildConf + "]";
    }

    public void testProjectLeak() {
        if (Boolean.getBoolean("idea.test.guimode")) {
            Application application = ApplicationManager.getApplication();
            TransactionGuard.getInstance().submitTransactionAndWait(() -> {
                IdeEventQueue.getInstance().flushQueue();
                ((ApplicationImpl)application).exit(true, true, false);
            });
            ShutDownTracker.getInstance().waitFor(100L, TimeUnit.SECONDS);
            return;
        }
        PlatformTestUtil.disposeApplicationAndCheckForProjectLeaks();
        try {
            Disposer.assertIsEmpty((boolean)true);
        }
        catch (AssertionError | Exception e) {
            PlatformTestUtil.captureMemorySnapshot();
            throw e;
        }
    }

    public void testStatistics() {
        long started = _FirstInSuiteTest.getSuiteStartTime();
        if (started != 0L) {
            long testSuiteDuration = System.nanoTime() - started;
            System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']", testSuiteDuration / 1000000L));
        }
        LightPlatformTestCase.reportTestExecutionStatistics();
    }
}

