/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.references;

import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssKeyframesRule;
import com.intellij.psi.css.index.CssIndex;
import com.intellij.psi.css.index.CssIndexValue;
import com.intellij.psi.css.reference.CssReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssKeyframesReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference,
CssReference {
    public CssKeyframesReference(PsiElement psiElement) {
        super(psiElement);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CssBundle.message((String)"unresolved.css.keyframes", (Object[])new Object[]{this.getCanonicalText()});
        if (string == null) {
            CssKeyframesReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        HashSet result = Sets.newHashSet();
        Project project = this.myElement.getProject();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)project);
        String key = CssIndexValue.KEYFRAMES.indexKey(this.getCanonicalText());
        FileBasedIndex.getInstance().processValues(CssIndex.CSS_INDEX, (Object)key, null, (file, value) -> {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                return true;
            }
            value.forEach(offset -> {
                PsiElement at = PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(offset), CssKeyframesRule.class);
                if (at != null) {
                    result.add(new PsiElementResolveResult(at));
                }
                return true;
            });
            return true;
        }, scope);
        ResolveResult[] resolveResultArray = !result.isEmpty() ? result.toArray(ResolveResult.EMPTY_ARRAY) : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            CssKeyframesReference.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            CssKeyframesReference.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/css/impl/util/references/CssKeyframesReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

