/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.model;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.rails.InflectorService;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsBaseView;
import org.jetbrains.plugins.ruby.rails.model.RailsExternalController;
import org.jetbrains.plugins.ruby.rails.model.RailsHelper;
import org.jetbrains.plugins.ruby.rails.model.RailsLayout;
import org.jetbrains.plugins.ruby.rails.model.RailsModel;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.ControllersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.rspec.RailsRSpecUtil;
import org.jetbrains.plugins.ruby.rails.rspec.model.RailsRSpecControllerTest;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class RailsController
extends RailsViewOwner {
    private String a;
    private static final long b = la.a(-1207109953462088965L, 6206205305893808890L, MethodHandles.lookup().lookupClass()).a(187998352428300L);

    protected RailsController(@NotNull Module module, @NotNull RClass aClass) {
        if (module == null) {
            RailsController.e(0);
        }
        if (aClass == null) {
            RailsController.e(1);
        }
        super(module, aClass);
    }

    public List<? extends RailsBaseView> getAllViewsAndPartials() {
        ArrayList<RailsView> arrayList = new ArrayList<RailsView>();
        arrayList.addAll(this.getAllViews());
        arrayList.addAll(this.getPartialViews());
        return arrayList;
    }

    @Contract(value="null -> null")
    @Nullable
    public static RailsController fromClass(@Nullable RClass rClass) {
        if (rClass == null) {
            return null;
        }
        return RailsController.fromClass(rClass, RailsApp.fromPsiElement((PsiElement)rClass));
    }

    @Contract(value="null, _ -> null; _, null -> null")
    @Nullable
    public static RailsController fromClass(@Nullable RClass rClass, @Nullable RailsApp railsApp) {
        if (rClass == null) {
            return null;
        }
        if (railsApp == null) {
            return null;
        }
        if (RailsApp.fromPsiElement((PsiElement)rClass) != null) {
            if (!RailsController.a(railsApp, rClass)) {
                return null;
            }
            return new RailsController(railsApp.getModule(), rClass);
        }
        return RailsExternalController.fromExternalClass(rClass, railsApp);
    }

    @Nullable
    public static RailsController fromFile(@NotNull PsiFile psiFile) {
        VirtualFile virtualFile;
        if (psiFile == null) {
            RailsController.e(2);
        }
        return (virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)psiFile)) == null ? null : RailsController.fromFile(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile), virtualFile);
    }

    @Nullable
    public static RailsController fromSymbol(@Nullable Symbol symbol) {
        if (symbol == null || symbol.getType() != Type.CLASS) {
            return null;
        }
        PsiElement psiElement = symbol.getPsiElement();
        if (psiElement == null) {
            return null;
        }
        FQN fQN = symbol.getFQNWithNesting();
        if (fQN == FQN.INVALID) {
            return null;
        }
        Module module = symbol.getModule();
        RailsApp railsApp = RailsApp.fromModule(module);
        if (railsApp == null) {
            return null;
        }
        return RailsController.fromClassFullyQualifiedName(module, fQN);
    }

    @Nullable
    public static RailsController fromFile(Module module, @NotNull VirtualFile file) {
        RailsApp railsApp;
        if (file == null) {
            RailsController.e(3);
        }
        if ((railsApp = RailsApp.fromModule(module)) == null) {
            return null;
        }
        if (!file.getUrl().startsWith(railsApp.getPaths().getControllerRootURL())) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (psiFile instanceof RFile) {
            List<RClass> list2 = RContainerUtil.getTopLevelClasses((RContainer)((RFile)psiFile));
            for (RClass rClass : list2) {
                if (!RailsController.a(railsApp, rClass)) continue;
                return new RailsController(module, rClass);
            }
        }
        return null;
    }

    @Nullable
    public static RailsController fromViewsFolder(Module module, String viewsFolderUrl) {
        VirtualFile virtualFile;
        RailsApp railsApp = RailsApp.fromModule(module);
        if (railsApp == null || viewsFolderUrl == null) {
            return null;
        }
        String string = RailsController.a(viewsFolderUrl, railsApp);
        VirtualFile virtualFile2 = virtualFile = string == null ? null : VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile != null) {
            return RailsController.fromFile(module, virtualFile);
        }
        VirtualFile virtualFile3 = VirtualFileManager.getInstance().findFileByUrl(viewsFolderUrl);
        return virtualFile3 == null ? null : RailsController.createControllerByViewsSubfolder(virtualFile3, module);
    }

    @Nullable
    private static String a(@NotNull String string, @NotNull RailsApp railsApp) {
        if (string == null) {
            RailsController.e(4);
        }
        if (railsApp == null) {
            RailsController.e(5);
        }
        String string2 = railsApp.getPaths().getViewsRootURL();
        String string3 = railsApp.getPaths().getControllerRootURL();
        String string4 = FileUtil.getRelativePath((String)string2, (String)string, (char)'/');
        if (string4 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string3);
        stringBuilder.append('/');
        stringBuilder.append(string4);
        stringBuilder.append(ControllersConventions.getControllerFileSuffixFor(string4, railsApp.getModule()));
        stringBuilder.append('.');
        stringBuilder.append(RubyFileType.RUBY.getDefaultExtension());
        return stringBuilder.toString();
    }

    @Nullable
    public static RailsController fromLayout(Module module, String layoutParentFolderUrl, String layoutFileName) {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = FileUtil.getNameWithoutExtension((String)layoutFileName);
        String string2 = ViewsConventions.getViewOrLayoutNameByFileName(string);
        String string3 = ViewsConventions.getRelativePathOfLayoutsFolder(layoutParentFolderUrl, module);
        String string4 = StringUtil.isEmpty((String)string3) ? string2 : string3 + "/" + string2;
        return RailsController.fromQualifiedName(module, string4);
    }

    @Nullable
    public static RailsController fromView(Module module, String viewParentFolder, String viewFileName) {
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        if (standardRailsPaths == null) {
            return null;
        }
        String string = FileUtil.getNameWithoutExtension((String)viewFileName);
        String string2 = ViewsConventions.getViewOrLayoutNameByFileName(string);
        String string3 = ViewsConventions.getRelativePathOfViewsFolder(viewParentFolder, module);
        String string4 = StringUtil.isEmpty((String)string3) ? string2 : string3 + "/" + string2;
        return RailsController.fromQualifiedName(module, string4);
    }

    @Nullable
    public static RailsController fromClassFullyQualifiedName(Module module, @NotNull FQN fullQualifiedName) {
        if (fullQualifiedName == null) {
            RailsController.e(6);
        }
        String string = NamingConventions.toUnderscoreCase(ControllersConventions.getControllerNameByClassName(fullQualifiedName.getFullPath()));
        return RailsController.fromQualifiedName(module, string);
    }

    @Nullable
    public static RailsController fromQualifiedName(Module module, @NotNull String fullQualifiedName) {
        RailsApp railsApp;
        long l2 = b ^ 0x714868321345L;
        if (fullQualifiedName == null) {
            RailsController.e(7);
        }
        if ((railsApp = RailsApp.fromModule(module)) == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        String string = standardRailsPaths.getControllerRootURL();
        String string2 = string + "/" + railsApp.appendProjectPrefix(fullQualifiedName) + ControllersConventions.getControllerFileSuffixFor(fullQualifiedName, module) + ".rb";
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string2);
        if (virtualFile == null) {
            return null;
        }
        return RailsController.fromFile(module, virtualFile);
    }

    @Nullable
    public static RailsController fromName(Module module, @NotNull String name, @NotNull VirtualFile folder) {
        long l2 = b ^ 0x6E28DC879A29L;
        if (name == null) {
            RailsController.e(8);
        }
        if (folder == null) {
            RailsController.e(9);
        }
        if (module == null || !RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        String string = folder.getUrl() + "/" + name + ControllersConventions.getControllerFileSuffixFor(name, module) + ".rb";
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile == null) {
            return null;
        }
        return RailsController.fromFile(module, virtualFile);
    }

    @NotNull
    public String getName() {
        String string = ControllersConventions.getControllerNameByClassName(this.myClass.getName());
        assert (string != null);
        String string2 = string;
        if (string2 == null) {
            RailsController.e(10);
        }
        return string2;
    }

    @NotNull
    public String getQualifiedName() {
        if (this.a == null) {
            VirtualFile virtualFile = this.getFile();
            String string = ControllersConventions.getRelativePathOfControllerFolder(virtualFile.getParent().getUrl(), this.myModule);
            if (StringUtil.isEmpty((String)string)) {
                String string2 = this.getName();
                if (string2 == null) {
                    RailsController.e(11);
                }
                return string2;
            }
            this.a = string + "/" + this.getName();
        }
        String string = this.a;
        if (string == null) {
            RailsController.e(12);
        }
        return string;
    }

    @Nullable
    public RMethod getAction(String view_name) {
        return RubyPsiUtil.getMethodWithPossibleZeroArgsByName((RContainer)this.myClass, view_name);
    }

    @Nullable
    public RMethod getActionByFileName(String fileName) {
        String string = FileUtil.getNameWithoutExtension((String)fileName);
        String string2 = ViewsConventions.getViewOrLayoutNameByFileName(string);
        return RubyPsiUtil.getMethodWithPossibleZeroArgsByName((RContainer)this.myClass, string2);
    }

    @Nullable
    public VirtualFile getViewsFolder() {
        String string = this.getViewsFolderUrl();
        if (string == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        if (virtualFile != null && virtualFile.isDirectory()) {
            return virtualFile;
        }
        return null;
    }

    @Nullable
    public String getViewsFolderUrl() {
        String string;
        VirtualFile virtualFile = this.myClass.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String string2 = ControllersConventions.getRelativePathOfControllerFolder(this.a(), this.myModule);
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(this.myModule);
        assert (standardRailsPaths != null);
        stringBuilder.append(standardRailsPaths.getViewsRootURL());
        if (!StringUtil.isEmpty((String)string2)) {
            stringBuilder.append('/');
            stringBuilder.append(string2);
        }
        if (!StringUtil.isEmpty((String)(string = this.getName()))) {
            stringBuilder.append('/');
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @NotNull
    public List<RailsView> getAllViews() {
        ArrayList<RailsView> arrayList = new ArrayList<RailsView>();
        VirtualFile virtualFile = this.getViewsFolder();
        if (virtualFile != null) {
            for (VirtualFile virtualFile2 : virtualFile.getChildren()) {
                RailsView railsView = RailsView.fromFile(virtualFile2, this.getModule());
                if (railsView == null || railsView.isPartial()) continue;
                arrayList.add(railsView);
            }
        }
        ArrayList<RailsView> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RailsController.e(13);
        }
        return arrayList2;
    }

    @NotNull
    public List<RailsView> getViews(String actionName) {
        List<RailsView> list2 = this.a(actionName, this.getViewsFolder());
        if (list2 == null) {
            RailsController.e(14);
        }
        return list2;
    }

    private List<RailsView> a(@NotNull String string, @Nullable VirtualFile virtualFile) {
        if (string == null) {
            RailsController.e(15);
        }
        ArrayList<RailsView> arrayList = new ArrayList<RailsView>();
        if (virtualFile != null) {
            VirtualFile[] virtualFileArray;
            for (VirtualFile virtualFile2 : virtualFileArray = virtualFile.getChildren()) {
                if (!ViewsConventions.isViewFile(virtualFile2) || !string.equals(ViewsConventions.getActionMethodNameByView(virtualFile2))) continue;
                arrayList.add(new RailsView(virtualFile2, this.myModule, this));
            }
        }
        return arrayList;
    }

    @NotNull
    public List<RailsView> getPartialViews() {
        ArrayList<RailsView> arrayList = new ArrayList<RailsView>();
        List<VirtualFile> list2 = ViewsConventions.findPartialViews(this.getViewsFolder());
        for (VirtualFile virtualFile : list2) {
            arrayList.add(new RailsView(virtualFile, this.myModule, this));
        }
        ArrayList<RailsView> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RailsController.e(16);
        }
        return arrayList2;
    }

    private String a() {
        VirtualFile virtualFile = this.myClass.getContainingFile().getVirtualFile();
        assert (virtualFile != null);
        VirtualFile virtualFile2 = virtualFile.getParent();
        assert (virtualFile2 != null);
        return virtualFile2.getUrl();
    }

    @Nullable
    public RailsHelper getOwnHelper() {
        VirtualFile virtualFile = this.getFile().getParent();
        assert (virtualFile != null);
        String string = virtualFile.getUrl();
        String string2 = ControllersConventions.getRelativePathOfControllerFolder(string, this.myModule);
        if (StringUtil.isEmpty((String)string2)) {
            return this.getApp().findHelper(this.getName());
        }
        return this.getApp().findHelper(string2 + "/" + this.getName());
    }

    @NotNull
    public List<RailsLayout> getLayouts() {
        String string = ControllersConventions.getRelativePathOfControllerFolder(this.a(), this.getModule());
        if (string == null) {
            List<RailsLayout> list2 = Collections.emptyList();
            if (list2 == null) {
                RailsController.e(17);
            }
            return list2;
        }
        VirtualFile virtualFile = this.getApp().getLayoutsRoot();
        if (virtualFile != null && !StringUtil.isEmpty((String)string)) {
            virtualFile = virtualFile.findFileByRelativePath(string);
        }
        List<RailsLayout> list3 = this.a(virtualFile);
        if (list3 == null) {
            RailsController.e(18);
        }
        return list3;
    }

    private List<RailsLayout> a(@Nullable VirtualFile virtualFile) {
        String string = this.getName();
        ArrayList<RailsLayout> arrayList = new ArrayList<RailsLayout>();
        if (virtualFile != null) {
            VirtualFile[] virtualFileArray;
            for (VirtualFile virtualFile2 : virtualFileArray = virtualFile.getChildren()) {
                if (!ViewsConventions.isLayoutFile(virtualFile2) || !string.equals(ViewsConventions.getActionMethodNameByView(virtualFile2))) continue;
                arrayList.add(new RailsLayout(virtualFile2, this.myModule, this));
            }
        }
        return arrayList;
    }

    @Nullable
    public RClass getFunctionalTestClass() {
        return this.getTestClass(this.getApp().getFunctionalTestsRoot(), this.getApp().getControllersRoot(), this.getFile().getNameWithoutExtension(), this.myClass.getName());
    }

    @Nullable
    public RClass getUnitTestClass() {
        return this.getTestClass(this.getApp().getUnitTestsRoot(), this.getApp().getControllersRoot(), this.getFile().getNameWithoutExtension(), this.myClass.getName());
    }

    @Nullable
    public RailsRSpecControllerTest getSpecTest() {
        return RailsRSpecControllerTest.fromController(this);
    }

    @Nullable
    public RailsModel getModel() {
        String string = this.getQualifiedName();
        RailsModel railsModel = this.getApp().findModelByName(string);
        InflectorService inflectorService = InflectorService.getInstance(this.myModule);
        if (railsModel != null || !inflectorService.isInflectorAvailable()) {
            return railsModel;
        }
        String string2 = this.getName();
        String string3 = inflectorService.singularize(string2);
        if (string3 == null) {
            return null;
        }
        String string4 = string.substring(0, string.length() - string2.length());
        return this.getApp().findModelByName(string4 + string3);
    }

    @Nullable
    public RailsHelper getHelper() {
        String string = this.getQualifiedName();
        return RailsHelper.fromQualifiedName(this.myModule, string);
    }

    @Nullable
    public VirtualFile findDirectoryForHelper() {
        String string = ControllersConventions.getRelativePathOfControllerFolder(this.getFile().getParent().getUrl(), this.getModule());
        if (string == null) {
            return null;
        }
        VirtualFile virtualFile = RailsUtil.getHelpersRoot(this.getModule());
        if (virtualFile == null) {
            return null;
        }
        return string.isEmpty() ? virtualFile : virtualFile.findFileByRelativePath(string);
    }

    public boolean isApplicationController() {
        long l2 = b ^ 0x227CAE7B2382L;
        String string = this.getQualifiedName();
        return string.equals("application");
    }

    @Nullable
    public VirtualFile getViewsSpecsFolder() {
        RailsApp railsApp = this.getApp();
        return RailsRSpecUtil.getSpecTest(railsApp.getSpecTestsViewsRoot(), railsApp.getViewsRoot(), this.getViewsFolder(), null);
    }

    @Nullable
    public VirtualFile getRequestSpec() {
        long l2 = b ^ 0x1A44D121C63L;
        RailsApp railsApp = this.getApp();
        VirtualFile virtualFile = railsApp.getSpecTestsRoot();
        String string = NamingConventions.toUnderscoreCase(this.getName()) + "_spec.rb";
        VirtualFile virtualFile2 = null;
        if (virtualFile != null) {
            virtualFile2 = virtualFile.findFileByRelativePath("/requests/" + string);
        }
        return virtualFile2;
    }

    @Nullable
    public VirtualFile getRoutingSpec() {
        long l2 = b ^ 0x5DC20246AAFAL;
        RailsApp railsApp = this.getApp();
        VirtualFile virtualFile = railsApp.getSpecTestsRoot();
        String string = NamingConventions.toUnderscoreCase(this.getName()) + "_routing" + "_spec.rb";
        VirtualFile virtualFile2 = null;
        if (virtualFile != null) {
            virtualFile2 = virtualFile.findFileByRelativePath("/routing/" + string);
        }
        return virtualFile2;
    }

    private static boolean a(RailsApp railsApp, @NotNull RClass rClass) {
        if (rClass == null) {
            RailsController.e(19);
        }
        if (ControllersConventions.getControllerNameByClassName(rClass.getName()) == null) {
            return false;
        }
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)rClass);
        if (virtualFile != null && ControllersConventions.isApplicationControllerFile(virtualFile, railsApp.getModule())) {
            return true;
        }
        return RailsController.checkPathEndsWithQualifiedName(rClass, railsApp.getControllersRoot());
    }

    @Nullable
    protected static RailsController createControllerByViewsSubfolder(@NotNull VirtualFile file, @NotNull Module module) {
        if (file == null) {
            RailsController.e(20);
        }
        if (module == null) {
            RailsController.e(21);
        }
        if (!file.isDirectory()) {
            return null;
        }
        VirtualFile virtualFile = RailsUtil.getViewsRoot(module);
        if (virtualFile == null) {
            return null;
        }
        List<String> list2 = VirtualFileUtil.getRelativePath(file, virtualFile);
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile2 = RailsUtil.getControllersRoot(module);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3 = virtualFile2;
            for (String string : list2) {
                VirtualFile virtualFile4 = virtualFile3.findChild(string);
                if (virtualFile4 != null && virtualFile4.isDirectory()) {
                    virtualFile3 = virtualFile4;
                    continue;
                }
                return RailsController.fromName(module, string, virtualFile3);
            }
        }
        return null;
    }

    private static /* synthetic */ void e(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x23D145A552F1L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderUrl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "app";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullQualifiedName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/model/RailsController";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rClass";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/model/RailsController";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllViews";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getViews";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialViews";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayouts";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControllerUrlByViewsFolderUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromClassFullyQualifiedName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromQualifiedName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fromName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findViewsInFolder";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isControllerClass";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createControllerByViewsSubfolder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

