/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.nameConventions;

import b.h.la;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.text.StringTokenizer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.rails.actions.navigation.RailsNavigateFromProvider;
import org.jetbrains.plugins.ruby.rails.facet.RailsFacetUtil;
import org.jetbrains.plugins.ruby.rails.facet.configuration.StandardRailsPaths;
import org.jetbrains.plugins.ruby.rails.model.RailsApp;
import org.jetbrains.plugins.ruby.rails.model.RailsExternalController;
import org.jetbrains.plugins.ruby.rails.model.RailsViewOwner;
import org.jetbrains.plugins.ruby.rails.nameConventions.HelpersConventions;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.RubyFileType;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.utils.NamingConventions;
import org.jetbrains.plugins.ruby.utils.VirtualFileUtil;

public class ControllersConventions {
    private static final long a = la.a(5166133839447391030L, 1047189043435875598L, MethodHandles.lookup().lookupClass()).a(166566398902509L);

    @Nullable
    public static String getControllerName(VirtualFile controller) {
        return ControllersConventions.getControllerName(controller.getName());
    }

    @Nullable
    public static String getControllerName(@NotNull String controllerFileName) {
        String string;
        long l2 = a ^ 0x5C9FC0518787L;
        if (controllerFileName == null) {
            ControllersConventions.a(0);
        }
        if ("application".equals(string = FileUtil.getNameWithoutExtension((String)controllerFileName))) {
            return string;
        }
        if (!string.endsWith("_controller")) {
            return null;
        }
        return string.substring(0, string.length() - "_controller".length());
    }

    @Nullable
    public static String getControllerNameByClassName(@Nullable String className) {
        long l2 = a ^ 0x4172914E8345L;
        if (className == null) {
            return null;
        }
        String string = NamingConventions.toUnderscoreCase(className);
        if (!string.endsWith("_controller")) {
            return null;
        }
        return string.substring(0, string.length() - "Controller".length() - 1);
    }

    @Nullable
    public static String getControllerClassName(@Nullable String controllerName) {
        long l2 = a ^ 0x7A63B6EB29DBL;
        if (controllerName == null) {
            return null;
        }
        return NamingConventions.toCamelCase(controllerName) + "Controller";
    }

    @Nullable
    public static String getControllerFileName(@Nullable String controllerClassName, Module module) {
        long l2 = a ^ 0x54616883C576L;
        if (controllerClassName == null) {
            return null;
        }
        return String.format("%s.%s", ControllersConventions.getControllerFileNameWithoutExtension(controllerClassName, module), RubyFileType.RUBY.getDefaultExtension());
    }

    @NotNull
    public static String getControllerFileNameWithoutExtension(@NotNull String controllerClassName, Module module) {
        long l2 = a ^ 0x5581C4CB13EAL;
        if (controllerClassName == null) {
            ControllersConventions.a(1);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if ("ApplicationController".equals(controllerClassName)) {
            if (RailsUtil.isAttachedRails_2_3_OrHigher(module)) {
                stringBuilder.append("application_controller");
            } else {
                stringBuilder.append("application");
            }
        } else {
            stringBuilder.append(NamingConventions.toUnderscoreCase(controllerClassName));
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ControllersConventions.a(2);
        }
        return string;
    }

    public static boolean isApplicationControllerFile(@NotNull VirtualFile controller, Module module) {
        String string;
        long l2 = a ^ 0x7E902E57923AL;
        if (controller == null) {
            ControllersConventions.a(3);
        }
        return ("application".equals(string = controller.getNameWithoutExtension()) || "application_controller".equals(string)) && controller.getUrl().equals(ControllersConventions.getApplicationControllerUrl(module));
    }

    @Nullable
    public static String getApplicationControllerUrl(Module module) {
        long l2 = a ^ 0x19CDABA1BD2DL;
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        if (standardRailsPaths == null) {
            return null;
        }
        RailsApp railsApp = RailsApp.fromModule(module);
        String string = standardRailsPaths.getControllerRootURL();
        assert (railsApp != null);
        return string + '/' + railsApp.getProjectPrefix() + "application" + ControllersConventions.getControllerFileSuffixFor("application", module) + "." + RubyFileType.RUBY.getDefaultExtension();
    }

    @Nullable
    public static String getControllerClassNameByFileName(@Nullable String controllerFileName) {
        long l2 = a ^ 0xE850025BF0DL;
        if (controllerFileName == null) {
            return null;
        }
        String string = FileUtil.getNameWithoutExtension((String)controllerFileName);
        if ("application".equals(string)) {
            return "ApplicationController";
        }
        if (!string.endsWith("_controller")) {
            return null;
        }
        return NamingConventions.toCamelCase(string);
    }

    @Nullable
    public static String getControllerCorrespondingDir(@NotNull String dirUrl, @NotNull Module module) {
        if (dirUrl == null) {
            ControllersConventions.a(4);
        }
        if (module == null) {
            ControllersConventions.a(5);
        }
        if (!RailsFacetUtil.hasRailsSupport(module)) {
            return null;
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        String string = standardRailsPaths.getControllerRootURL();
        if (dirUrl.startsWith(string)) {
            return dirUrl;
        }
        if (dirUrl.startsWith(standardRailsPaths.getHelpersRootURL())) {
            return HelpersConventions.getRelativePathOfHelperFolder(dirUrl, module);
        }
        if (dirUrl.startsWith(standardRailsPaths.getLayoutsRootURL())) {
            return ViewsConventions.getRelativePathOfLayoutsFolder(dirUrl, module);
        }
        String string2 = standardRailsPaths.getViewsRootURL();
        if (dirUrl.startsWith(string2)) {
            return ViewsConventions.getRelativePathOfViewsFolder(dirUrl, module);
        }
        return null;
    }

    public static boolean isValidActionName(@Nullable String name) {
        return NamingConventions.isInUnderscoredCase(name) && name.charAt(0) != '_';
    }

    @Nullable
    public static String getRelativePathOfControllerFolder(@NotNull String fileUrl, @NotNull Module module) {
        if (fileUrl == null) {
            ControllersConventions.a(6);
        }
        if (module == null) {
            ControllersConventions.a(7);
        }
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        String string = standardRailsPaths.getControllerRootURL();
        return VirtualFileUtil.getRelativePath(fileUrl, string);
    }

    @Nullable
    public static String getControllerUrlByViewUrl(@NotNull String viewFileUrl, @NotNull StandardRailsPaths railsPaths, @NotNull Module module) {
        if (viewFileUrl == null) {
            ControllersConventions.a(8);
        }
        if (railsPaths == null) {
            ControllersConventions.a(9);
        }
        if (module == null) {
            ControllersConventions.a(10);
        }
        return ControllersConventions.getControllerUrlByViewUrl(viewFileUrl, railsPaths.getViewsRootURL(), railsPaths.getControllerRootURL(), module);
    }

    @Nullable
    public static String getControllerUrlByViewUrl(@NotNull String viewFileUrl, @NotNull String viewsRootUrl, @NotNull String controllersRootUrl, @NotNull Module module) {
        if (viewFileUrl == null) {
            ControllersConventions.a(11);
        }
        if (viewsRootUrl == null) {
            ControllersConventions.a(12);
        }
        if (controllersRootUrl == null) {
            ControllersConventions.a(13);
        }
        if (module == null) {
            ControllersConventions.a(14);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(controllersRootUrl);
        int n2 = viewFileUrl.indexOf(viewsRootUrl) + viewsRootUrl.length() + 1;
        int n3 = viewFileUrl.lastIndexOf(47);
        if (n2 >= n3) {
            return null;
        }
        String string = viewFileUrl.substring(n2, n3);
        stringBuilder.append('/');
        stringBuilder.append(string);
        stringBuilder.append(ControllersConventions.getControllerFileSuffixFor(string, module));
        stringBuilder.append('.');
        stringBuilder.append(RubyFileType.RUBY.getDefaultExtension());
        return stringBuilder.toString();
    }

    @Nullable
    public static RClass getControllerByViewFile(Module module, VirtualFile viewFile) {
        VirtualFile virtualFile;
        String string = viewFile.getUrl();
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null);
        if (!ViewsConventions.hasValidTemplatePath(string, standardRailsPaths)) {
            return null;
        }
        String string2 = ControllersConventions.getControllerUrlByViewUrl(string, standardRailsPaths, module);
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        VirtualFile virtualFile2 = virtualFile = string2 != null ? virtualFileManager.findFileByUrl(string2) : null;
        if (virtualFile == null) {
            GemInfo gemInfo;
            VirtualFile virtualFile3;
            Iterator<GemInfo> iterator = GemManager.getAllGems(module).iterator();
            while (iterator.hasNext() && ((virtualFile3 = RailsExternalController.getGemControllersFolder(gemInfo = iterator.next())) == null || !virtualFile3.exists() || (virtualFile = (string2 = ControllersConventions.getControllerUrlByViewUrl(string, standardRailsPaths.getViewsRootURL(), virtualFile3.getUrl(), module)) != null ? virtualFileManager.findFileByUrl(string2) : null) == null)) {
            }
        }
        if (virtualFile == null) {
            return null;
        }
        return ControllersConventions.a(module, virtualFile);
    }

    @Nullable
    private static RClass a(Module module, VirtualFile virtualFile) {
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
        if (!(psiFile instanceof RFile)) {
            return null;
        }
        RFile rFile = (RFile)psiFile;
        String string = ControllersConventions.getControllerClassNameByFileName(virtualFile.getName());
        RClass rClass = RContainerUtil.getClassByName((RContainer)rFile, string);
        if (rClass != null) {
            return rClass;
        }
        return ControllersConventions.a(rFile, string);
    }

    @Nullable
    private static RClass a(RFile rFile, String string) {
        ArrayList<RModule> arrayList = new ArrayList<RModule>(RContainerUtil.getTopLevelModules((RContainer)rFile));
        while (arrayList.size() > 0) {
            RModule rModule = arrayList.get(0);
            arrayList.remove(0);
            RClass rClass = RContainerUtil.getClassByName((RContainer)rModule, string);
            if (rClass != null) {
                return rClass;
            }
            arrayList.addAll(RContainerUtil.selectElementsByType(rModule.getStructureElements(), RModule.class));
        }
        return null;
    }

    @Nullable
    public static RClass getControllerClassByShortName(@NotNull Module module, @NotNull PsiElement element, @NotNull String name) {
        long l2 = a ^ 0x5DE732FDF1B3L;
        if (module == null) {
            ControllersConventions.a(15);
        }
        if (element == null) {
            ControllersConventions.a(16);
        }
        if (name == null) {
            ControllersConventions.a(17);
        }
        assert (RModuleUtil.getInstance().hasRubySupport(module));
        StandardRailsPaths standardRailsPaths = RailsFacetUtil.getRailsAppPaths(module);
        assert (standardRailsPaths != null) : "no rails settings for " + module + " " + RailsApp.isRails3App(module);
        String string = standardRailsPaths.getControllerRootURL();
        String string2 = name + "_controller" + ".rb";
        String string3 = string + "/" + string2;
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string3);
        if (virtualFile == null) {
            PsiFile psiFile = element.getContainingFile();
            for (RailsNavigateFromProvider railsNavigateFromProvider : RailsNavigateFromProvider.EP_NAME.getExtensionList()) {
                RailsViewOwner railsViewOwner = railsNavigateFromProvider.controllerBy(psiFile);
                if (railsViewOwner != null) {
                    virtualFile = ControllersConventions.a(string2, railsViewOwner.getFile());
                }
                if (virtualFile == null) continue;
                break;
            }
            if (virtualFile == null) {
                virtualFile = ControllersConventions.a(string2, psiFile.getVirtualFile());
            }
        }
        if (virtualFile == null) {
            return null;
        }
        return ControllersConventions.a(module, virtualFile);
    }

    @Nullable
    private static VirtualFile a(String string, VirtualFile virtualFile) {
        VirtualFile virtualFile2 = virtualFile != null ? virtualFile.getParent() : null;
        VirtualFile virtualFile3 = virtualFile2 != null ? virtualFile2.findChild(string) : null;
        return virtualFile3;
    }

    public static boolean isCompositeControllerNameValid(@NotNull String name) {
        boolean bl2;
        if (name == null) {
            ControllersConventions.a(18);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(name, String.valueOf('/'));
        boolean bl3 = bl2 = name.length() > 0;
        while (stringTokenizer.hasMoreTokens() && bl2) {
            String string = stringTokenizer.nextToken();
            bl2 = NamingConventions.isInUnderscoredCase(string);
        }
        return bl2;
    }

    public static String getControllerFileSuffixFor(@NotNull String controllerQualifiedName, @NotNull Module module) {
        long l2 = a ^ 0x54E595822A74L;
        if (controllerQualifiedName == null) {
            ControllersConventions.a(19);
        }
        if (module == null) {
            ControllersConventions.a(20);
        }
        return "application".equals(controllerQualifiedName) && !RailsUtil.isAttachedRails_2_3_OrHigher(module) ? "" : "_controller";
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x13DF095D348DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerFileName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/rails/nameConventions/ControllersConventions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirUrl";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewFileUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "railsPaths";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewsRootUrl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllersRootUrl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controllerQualifiedName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/rails/nameConventions/ControllersConventions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getControllerFileNameWithoutExtension";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getControllerName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getControllerFileNameWithoutExtension";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicationControllerFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getControllerCorrespondingDir";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePathOfControllerFolder";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getControllerUrlByViewUrl";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getControllerClassByShortName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isCompositeControllerNameValid";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getControllerFileSuffixFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

