/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.darcula.ui.TextFieldWithPopupHandlerUI;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;

public class DarculaPasswordFieldUI
extends BasicPasswordFieldUI {
    private FocusListener focusListener;

    public static ComponentUI createUI(JComponent c) {
        return new DarculaPasswordFieldUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        final JTextComponent passwordField = this.getComponent();
        this.focusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                passwordField.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                passwordField.repaint();
            }
        };
        passwordField.addFocusListener(this.focusListener);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        if (this.focusListener != null) {
            this.getComponent().removeFocusListener(this.focusListener);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return this.updatePreferredSize(super.getPreferredSize(c));
    }

    protected Dimension updatePreferredSize(Dimension size) {
        Insets i = this.getComponent().getInsets();
        size.height = Math.max(size.height, this.getMinimumHeight() + i.top + i.bottom);
        JBInsets.addTo((Dimension)size, (Insets)this.getComponent().getMargin());
        return size;
    }

    protected int getMinimumHeight() {
        return DarculaUIUtil.MINIMUM_HEIGHT.get();
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintBackground(Graphics g) {
        JTextComponent component = this.getComponent();
        if (component != null) {
            Container parent = component.getParent();
            if (parent != null && component.isOpaque()) {
                g.setColor(parent.getBackground());
                g.fillRect(0, 0, component.getWidth(), component.getHeight());
            }
            Graphics2D g2 = (Graphics2D)g.create();
            Rectangle r = new Rectangle(component.getSize());
            JBInsets.removeFrom((Rectangle)r, (Insets)JBUI.insets((int)1));
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
                g2.translate(r.x, r.y);
                float bw = DarculaUIUtil.BW.getFloat();
                if (component.isEnabled() && component.isEditable()) {
                    g2.setColor(component.getBackground());
                }
                g2.fill(new Rectangle2D.Float(bw, bw, (float)r.width - bw * 2.0f, (float)r.height - bw * 2.0f));
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        JTextComponent c = this.getComponent();
        Rectangle bounds2 = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)bounds2, (Insets)c.getInsets());
        JBInsets.removeFrom((Rectangle)bounds2, (Insets)c.getMargin());
        return bounds2;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.getComponent().setMargin((Insets)JBUI.insets((int)0, (int)5));
    }

    @Override
    protected Caret createCaret() {
        return new TextFieldWithPopupHandlerUI.MarginAwareCaret();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        JTextComponent component = this.getComponent();
        if (SystemInfoRt.isMac) {
            LookAndFeel.installProperty(component, "echoChar", Character.valueOf('\u2022'));
        }
    }
}

