/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDiffHandler;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffAfterWithLocalFromLogActionProvider
implements AnActionExtensionProvider {
    @Nullable
    private static FilePath getFilePath(@NotNull AnActionEvent e, @NotNull VcsLog log2) {
        FilePath filePath;
        if (e == null) {
            ShowDiffAfterWithLocalFromLogActionProvider.$$$reportNull$$$0(0);
        }
        if (log2 == null) {
            ShowDiffAfterWithLocalFromLogActionProvider.$$$reportNull$$$0(1);
        }
        if ((filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH)) != null) {
            return filePath;
        }
        List commits = log2.getSelectedCommits();
        if (commits.isEmpty() || commits.size() > 1) {
            return null;
        }
        return VcsUtil.getFilePath((VirtualFile)((CommitId)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)commits))).getRoot());
    }

    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffAfterWithLocalFromLogActionProvider.$$$reportNull$$$0(2);
        }
        return e.getData(VcsLogDataKeys.VCS_LOG) != null && e.getData(ChangesBrowserBase.DATA_KEY) == null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffAfterWithLocalFromLogActionProvider.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        VcsLog log2 = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        if (project == null || log2 == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        e.getPresentation().setVisible(true);
        List commits = log2.getSelectedCommits();
        if (commits.size() != 1) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FilePath filePath = ShowDiffAfterWithLocalFromLogActionProvider.getFilePath(e, log2);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        e.getPresentation().setEnabled(filePath != null && filePath.getVirtualFile() != null && handler2 != null);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffAfterWithLocalFromLogActionProvider.$$$reportNull$$$0(4);
        }
        VcsLogUsageTriggerCollector.triggerUsage(e);
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        VcsLog log2 = (VcsLog)e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        List commits = log2.getSelectedCommits();
        if (commits.size() != 1) {
            return;
        }
        CommitId commit = (CommitId)ObjectUtils.notNull((Object)ContainerUtil.getFirstItem((List)commits));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        FilePath path = ShowDiffAfterWithLocalFromLogActionProvider.getFilePath(e, log2);
        VcsLogDiffHandler handler2 = (VcsLogDiffHandler)e.getRequiredData(VcsLogInternalDataKeys.LOG_DIFF_HANDLER);
        FilePath pathInCommit = path;
        FileHistoryUi historyUi = (FileHistoryUi)e.getData(VcsLogInternalDataKeys.FILE_HISTORY_UI);
        if (historyUi != null) {
            pathInCommit = historyUi.getPathInCommit(commit.getHash());
        }
        handler2.showDiffWithLocal(commit.getRoot(), pathInCommit, commit.getHash(), path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/ShowDiffAfterWithLocalFromLogActionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

