/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.utils;

import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.frame.XSuspendContext;
import org.jetbrains.annotations.NotNull;

public class SingleAlarmWithMutableDelay {
    private final Alarm myAlarm;
    private final Task myTask;
    private volatile int myDelayMillis;

    public SingleAlarmWithMutableDelay(@NotNull Task task, @NotNull Disposable parentDisposable) {
        if (task == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(1);
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
        this.myTask = task;
    }

    public void setDelay(int millis) {
        this.myDelayMillis = millis;
    }

    public void cancelAndRequest(@NotNull XSuspendContext suspendContext) {
        if (suspendContext == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(2);
        }
        this.cancelAndAddRequest(suspendContext, this.myDelayMillis);
    }

    public void cancelAndRequestImmediate(@NotNull XSuspendContext suspendContext) {
        if (suspendContext == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(3);
        }
        this.cancelAndAddRequest(suspendContext, 0);
    }

    public void cancelAllRequests() {
        this.myAlarm.cancelAllRequests();
    }

    private void cancelAndAddRequest(@NotNull XSuspendContext suspendContext, int delayMillis) {
        if (suspendContext == null) {
            SingleAlarmWithMutableDelay.$$$reportNull$$$0(4);
        }
        if (!this.myAlarm.isDisposed()) {
            this.cancelAllRequests();
            this.myAlarm.addRequest(() -> {
                if (suspendContext == null) {
                    SingleAlarmWithMutableDelay.$$$reportNull$$$0(5);
                }
                this.myTask.run(suspendContext);
            }, delayMillis);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suspendContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/memory/utils/SingleAlarmWithMutableDelay";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelAndRequest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelAndRequestImmediate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cancelAndAddRequest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$cancelAndAddRequest$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface Task {
        public void run(@NotNull XSuspendContext var1);
    }
}

