/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.typescript.psi.TypeScriptComparingUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCoreLibraryElementsCollector<T> {
    private static final String NASHORN_D_TS = "nashorn.d.ts";
    private final Map<JSQualifiedNamedElement, Pair<String, T>> myElements = ContainerUtil.newTroveMap((TObjectHashingStrategy)new TObjectHashingStrategy<JSQualifiedNamedElement>(){

        public int computeHashCode(JSQualifiedNamedElement object) {
            if (object instanceof TypeScriptFunction) {
                int parameters = ((TypeScriptFunction)object).getParameters().length;
                TypeScriptTypeParameterList typeParameters = ((TypeScriptFunction)object).getTypeParameterList();
                int typeParametersLength = typeParameters == null ? 0 : typeParameters.getTypeParameters().length;
                return Objects.hash(object.getQualifiedName(), parameters, typeParametersLength);
            }
            return Objects.hash(object.getQualifiedName());
        }

        public boolean equals(JSQualifiedNamedElement o1, JSQualifiedNamedElement o2) {
            if (!Objects.equals(o1.getQualifiedName(), o2.getQualifiedName())) {
                return false;
            }
            if (o1 instanceof TypeScriptFunction && o2 instanceof TypeScriptFunction) {
                return TypeScriptComparingUtil.areFunctionsSimilar((JSFunction)((TypeScriptFunction)o1), (JSFunction)((TypeScriptFunction)o2));
            }
            if (o1 instanceof JSFieldVariable && o2 instanceof JSFieldVariable) {
                return TypeScriptComparingUtil.areVariablesSimilar((JSFieldVariable)o1, (JSFieldVariable)o2) || "browser.d.ts".equals(o1.getContainingFile().getName()) || "browser.d.ts".equals(o2.getContainingFile().getName());
            }
            return false;
        }
    });

    public boolean isLibraryElement(@Nullable PsiElement element) {
        return (element instanceof TypeScriptField || element instanceof TypeScriptFunction || element instanceof TypeScriptVariable) && JSCorePredefinedLibrariesProvider.isLibraryElement(element);
    }

    @Nullable
    public T getValue(@NotNull PsiElement key) {
        if (key == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(0);
        }
        if (!(key instanceof JSQualifiedNamedElement)) {
            return null;
        }
        Pair<String, T> pair = this.myElements.get(key);
        return (T)Pair.getSecond(pair);
    }

    @NotNull
    public Collection<JSQualifiedNamedElement> getElements() {
        Set<JSQualifiedNamedElement> set = this.myElements.keySet();
        if (set == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @NotNull
    public Collection<T> getValues() {
        Collection collection = this.myElements.values().stream().map(el -> el.getSecond()).collect(Collectors.toSet());
        if (collection == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public boolean addElement(@Nullable PsiElement element, @Nullable T valueToStore) {
        if (!(element instanceof JSQualifiedNamedElement)) {
            return false;
        }
        JSQualifiedNamedElement newElement = (JSQualifiedNamedElement)element;
        Pair<String, T> value = this.myElements.get(element);
        String newFileName = newElement.getContainingFile().getName();
        if (value == null) {
            this.myElements.put(newElement, Pair.create((Object)newFileName, valueToStore));
            return true;
        }
        if (JSCoreLibraryElementsCollector.useNewElements(newFileName, (String)value.first)) {
            this.myElements.remove(newElement);
            this.myElements.put(newElement, Pair.create((Object)newFileName, valueToStore));
            return true;
        }
        return false;
    }

    private static boolean useNewElements(@NotNull String newFileName, @NotNull String storedFileName) {
        if (newFileName == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(3);
        }
        if (storedFileName == null) {
            JSCoreLibraryElementsCollector.$$$reportNull$$$0(4);
        }
        if ("browser.d.ts".equals(newFileName)) {
            return true;
        }
        if ("browser.d.ts".equals(storedFileName)) {
            return false;
        }
        if (NASHORN_D_TS.equals(newFileName)) {
            return true;
        }
        if (NASHORN_D_TS.equals(storedFileName)) {
            return false;
        }
        if ("flow.utilities.d.ts".equals(newFileName)) {
            return true;
        }
        if ("flow.utilities.d.ts".equals(storedFileName)) {
            return false;
        }
        return newFileName.compareTo(storedFileName) <= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSCoreLibraryElementsCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storedFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSCoreLibraryElementsCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "useNewElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

