/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.IOException;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.serialize.HTMLTagHashSet;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.type.SchemaType;

public class HTMLEmitter
extends XMLEmitter {
    private static final int REP_NATIVE = 0;
    private static final int REP_ENTITY = 1;
    private static final int REP_DECIMAL = 2;
    private static final int REP_HEX = 3;
    private int nonASCIIRepresentation = 0;
    private int excludedRepresentation = 1;
    private int inScript;
    private int version = 4;
    private String parentElement;
    private String uri;
    private boolean escapeNonAscii = false;
    static HTMLTagHashSet emptyTags = new HTMLTagHashSet(31);
    private static HTMLTagHashSet booleanAttributes;
    private static HTMLTagHashSet booleanCombinations;

    private static int representationCode(String rep) {
        if (rep.equalsIgnoreCase("native")) {
            return 0;
        }
        if (rep.equalsIgnoreCase("entity")) {
            return 1;
        }
        if (rep.equalsIgnoreCase("decimal")) {
            return 2;
        }
        if (rep.equalsIgnoreCase("hex")) {
            return 3;
        }
        return 1;
    }

    private static void setEmptyTag(String tag) {
        emptyTags.add(tag);
    }

    protected static boolean isEmptyTag(String tag) {
        return emptyTags.contains(tag);
    }

    private static void setBooleanAttribute(String element, String attribute) {
        booleanAttributes.add(attribute);
        booleanCombinations.add(element + '+' + attribute);
    }

    private static boolean isBooleanAttribute(String element, String attribute, String value) {
        return attribute.equalsIgnoreCase(value) && booleanAttributes.contains(attribute) && booleanCombinations.contains(element + '+' + attribute);
    }

    public void setEscapeNonAscii(Boolean escape) {
        this.escapeNonAscii = escape;
    }

    public void open() throws XPathException {
    }

    protected void openDocument() throws XPathException {
        String byteOrderMark;
        if (this.writer == null) {
            this.makeWriter();
        }
        if (this.started) {
            return;
        }
        this.started = true;
        String versionProperty = this.outputProperties.getProperty("html-version");
        if (versionProperty == null) {
            versionProperty = this.outputProperties.getProperty("version");
        }
        if (versionProperty != null) {
            if (versionProperty.equals("4.0") || versionProperty.equals("4.01")) {
                this.version = 4;
            } else if (versionProperty.equals("5.0")) {
                this.version = 5;
            } else {
                XPathException err = new XPathException("Unsupported HTML version: " + versionProperty);
                err.setErrorCode("SESU0013");
                throw err;
            }
        }
        if ("yes".equals(byteOrderMark = this.outputProperties.getProperty("byte-order-mark")) && "UTF-8".equalsIgnoreCase(this.outputProperties.getProperty("encoding"))) {
            try {
                this.writer.write(65279);
            }
            catch (IOException err) {
                // empty catch block
            }
        }
        String systemId = this.outputProperties.getProperty("doctype-system");
        String publicId = this.outputProperties.getProperty("doctype-public");
        if ("".equals(systemId)) {
            systemId = null;
        }
        if ("".equals(publicId)) {
            publicId = null;
        }
        if (systemId != null || publicId != null || this.version == 5) {
            this.writeDocType(null, "html", systemId, publicId);
        }
        this.inScript = -1000000;
    }

    protected void writeDocType(NodeName name, String displayName, String systemId, String publicId) throws XPathException {
        if (this.version == 5) {
            try {
                this.writer.write("<!DOCTYPE HTML>\n");
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        } else {
            super.writeDocType(name, displayName, systemId, publicId);
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        super.startElement(elemName, typeCode, locationId, properties);
        this.uri = elemName.getURI();
        this.parentElement = (String)this.elementStack.peek();
        if (elemName.isInNamespace("") && (this.parentElement.equalsIgnoreCase("script") || this.parentElement.equalsIgnoreCase("style"))) {
            this.inScript = 0;
        }
        ++this.inScript;
    }

    public void startContent() throws XPathException {
        this.closeStartTag();
    }

    protected void writeAttribute(NodeName elCode, String attname, CharSequence value, int properties) throws XPathException {
        try {
            if (this.uri.length() == 0 && HTMLEmitter.isBooleanAttribute(this.parentElement, attname, value.toString())) {
                this.writer.write(attname);
                return;
            }
            super.writeAttribute(elCode, attname, value, properties);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    protected void writeEscape(CharSequence chars, boolean inAttribute) throws IOException, XPathException {
        boolean[] specialChars;
        int segstart = 0;
        boolean[] blArray = specialChars = inAttribute ? specialInAtt : specialInText;
        if (chars instanceof CompressedWhitespace) {
            ((CompressedWhitespace)chars).writeEscape(specialChars, this.writer);
            return;
        }
        boolean disabled = false;
        while (segstart < chars.length()) {
            char c;
            int i;
            if (this.escapeNonAscii) {
                for (i = segstart; i < chars.length() && (c = chars.charAt(i)) < '\u007f' && !specialChars[c]; ++i) {
                }
            } else {
                while (i < chars.length() && ((c = chars.charAt(i)) < '\u007f' ? !specialChars[c] : this.characterSet.inCharset(c) && c > '\u00a0')) {
                    ++i;
                }
            }
            if (i == chars.length()) {
                if (segstart == 0) {
                    this.writeCharSequence(chars);
                } else {
                    this.writeCharSequence(chars.subSequence(segstart, i));
                }
                return;
            }
            if (i > segstart) {
                this.writeCharSequence(chars.subSequence(segstart, i));
            }
            if ((c = chars.charAt(i)) == '\u0000') {
                disabled = !disabled;
            } else if (disabled) {
                this.writer.write(c);
            } else if (c <= '\u007f') {
                if (inAttribute) {
                    if (c == '<') {
                        this.writer.write(60);
                    } else if (c == '>') {
                        this.writer.write("&gt;");
                    } else if (c == '&') {
                        if (i + 1 < chars.length() && chars.charAt(i + 1) == '{') {
                            this.writer.write(38);
                        } else {
                            this.writer.write("&amp;");
                        }
                    } else if (c == '\"') {
                        this.writer.write("&#34;");
                    } else if (c == '\n') {
                        this.writer.write("&#xA;");
                    } else if (c == '\t') {
                        this.writer.write("&#x9;");
                    } else if (c == '\r') {
                        this.writer.write("&#xD;");
                    }
                } else if (c == '<') {
                    this.writer.write("&lt;");
                } else if (c == '>') {
                    this.writer.write("&gt;");
                } else if (c == '&') {
                    this.writer.write("&amp;");
                } else if (c == '\r') {
                    this.writer.write("&#xD;");
                }
            } else {
                if (c < '\u00a0') {
                    XPathException err = new XPathException("Illegal HTML character: decimal " + c);
                    err.setErrorCode("SERE0014");
                    throw err;
                }
                if (c == '\u00a0') {
                    this.writer.write("&nbsp;");
                } else if (c >= '\ud800' && c <= '\udbff') {
                    int charval = (c - 55296) * 1024 + (chars.charAt(i + 1) - 56320) + 65536;
                    this.characterReferenceGenerator.outputCharacterReference(charval, this.writer);
                    ++i;
                } else if (this.escapeNonAscii || !this.characterSet.inCharset(c)) {
                    this.characterReferenceGenerator.outputCharacterReference(c, this.writer);
                } else {
                    this.writer.write(c);
                }
            }
            segstart = ++i;
        }
    }

    public void endElement() throws XPathException {
        String name = (String)this.elementStack.peek();
        --this.inScript;
        if (this.inScript == 0) {
            this.inScript = -1000000;
        }
        if (HTMLEmitter.isEmptyTag(name) && this.uri.length() == 0) {
            this.elementStack.pop();
        } else {
            super.endElement();
        }
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        int options = properties;
        if (this.inScript > 0) {
            options |= 1;
        }
        super.characters(chars, locationId, options);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (!this.started) {
            this.openDocument();
        }
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '>') continue;
            XPathException err = new XPathException("A processing instruction in HTML must not contain a > character");
            err.setErrorCode("SERE0015");
            throw err;
        }
        try {
            this.writer.write("<?");
            this.writer.write(target);
            this.writer.write(32);
            this.writeCharSequence(data);
            this.writer.write(62);
        }
        catch (IOException err) {
            throw new XPathException(err);
        }
    }

    static {
        HTMLEmitter.setEmptyTag("area");
        HTMLEmitter.setEmptyTag("base");
        HTMLEmitter.setEmptyTag("basefont");
        HTMLEmitter.setEmptyTag("br");
        HTMLEmitter.setEmptyTag("col");
        HTMLEmitter.setEmptyTag("frame");
        HTMLEmitter.setEmptyTag("hr");
        HTMLEmitter.setEmptyTag("img");
        HTMLEmitter.setEmptyTag("input");
        HTMLEmitter.setEmptyTag("isindex");
        HTMLEmitter.setEmptyTag("link");
        HTMLEmitter.setEmptyTag("meta");
        HTMLEmitter.setEmptyTag("param");
        booleanAttributes = new HTMLTagHashSet(31);
        booleanCombinations = new HTMLTagHashSet(53);
        HTMLEmitter.setBooleanAttribute("area", "nohref");
        HTMLEmitter.setBooleanAttribute("button", "disabled");
        HTMLEmitter.setBooleanAttribute("dir", "compact");
        HTMLEmitter.setBooleanAttribute("dl", "compact");
        HTMLEmitter.setBooleanAttribute("frame", "noresize");
        HTMLEmitter.setBooleanAttribute("hr", "noshade");
        HTMLEmitter.setBooleanAttribute("img", "ismap");
        HTMLEmitter.setBooleanAttribute("input", "checked");
        HTMLEmitter.setBooleanAttribute("input", "disabled");
        HTMLEmitter.setBooleanAttribute("input", "readonly");
        HTMLEmitter.setBooleanAttribute("menu", "compact");
        HTMLEmitter.setBooleanAttribute("object", "declare");
        HTMLEmitter.setBooleanAttribute("ol", "compact");
        HTMLEmitter.setBooleanAttribute("optgroup", "disabled");
        HTMLEmitter.setBooleanAttribute("option", "selected");
        HTMLEmitter.setBooleanAttribute("option", "disabled");
        HTMLEmitter.setBooleanAttribute("script", "defer");
        HTMLEmitter.setBooleanAttribute("select", "multiple");
        HTMLEmitter.setBooleanAttribute("select", "disabled");
        HTMLEmitter.setBooleanAttribute("td", "nowrap");
        HTMLEmitter.setBooleanAttribute("textarea", "disabled");
        HTMLEmitter.setBooleanAttribute("textarea", "readonly");
        HTMLEmitter.setBooleanAttribute("th", "nowrap");
        HTMLEmitter.setBooleanAttribute("ul", "compact");
    }
}

