/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

public final class MIMETypes {
    public static final String WRITER = "application/vnd.sun.xml.writer";
    public static final String CALC = "application/vnd.sun.xml.calc";
    public static final String IMPRESS = "application/vnd.sun.xml.impress";
    public static final String DRAW = "application/vnd.sun.xml.draw";
    public static final String CHART = "application/vnd.sun.xml.chart";
    public static final String MATH = "application/vnd.sun.xml.math";
    public static final String PNG = "image/png";
    public static final String JPEG = "image/jpeg";
    public static final String EPS = "image/x-eps";
    public static final String SVM = "(starview metafile)";
    public static final String XHTML = "text/html";
    public static final String XHTML_MATHML = "application/xhtml+xml";
    public static final String XHTML_MATHML_XSL = "application/xml";
    public static final String LATEX = "application/x-latex";
    public static final String BIBTEX = "application/x-bibtex";
    public static final String TEXT = "text";
    public static final byte[] PNG_SIG;
    public static final byte[] JPEG_SIG;
    public static final byte[] EPS_SIG;
    public static final byte[] SVM_SIG;
    public static final String PNG_EXT = ".png";
    public static final String JPEG_EXT = ".jpg";
    public static final String EPS_EXT = ".eps";
    public static final String SVM_EXT = ".svm";

    private static final boolean isType(byte[] blob, byte[] sig) {
        int n = sig.length;
        int i = 0;
        while (i < n) {
            if (blob[i] != sig[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final String getMagicMIMEType(byte[] blob) {
        if (MIMETypes.isType(blob, PNG_SIG)) {
            return PNG;
        }
        if (MIMETypes.isType(blob, JPEG_SIG)) {
            return JPEG;
        }
        if (MIMETypes.isType(blob, EPS_SIG)) {
            return EPS;
        }
        if (MIMETypes.isType(blob, SVM_SIG)) {
            return SVM;
        }
        return "";
    }

    public static final String getFileExtension(String sMIME) {
        if (PNG.equals(sMIME)) {
            return PNG_EXT;
        }
        if (JPEG.equals(sMIME)) {
            return JPEG_EXT;
        }
        if (EPS.equals(sMIME)) {
            return EPS_EXT;
        }
        if (SVM.equals(sMIME)) {
            return SVM_EXT;
        }
        return "";
    }

    static {
        WRITER = WRITER;
        CALC = CALC;
        IMPRESS = IMPRESS;
        DRAW = DRAW;
        CHART = CHART;
        MATH = MATH;
        PNG = PNG;
        JPEG = JPEG;
        EPS = EPS;
        SVM = SVM;
        XHTML = XHTML;
        XHTML_MATHML = XHTML_MATHML;
        XHTML_MATHML_XSL = XHTML_MATHML_XSL;
        LATEX = LATEX;
        BIBTEX = BIBTEX;
        TEXT = TEXT;
        PNG_SIG = new byte[]{-119, 80, 78, 71};
        JPEG_SIG = new byte[]{-1, -40, -1, -32};
        EPS_SIG = new byte[]{37, 33};
        SVM_SIG = new byte[]{86, 67, 76, 77, 84, 70};
        PNG_EXT = PNG_EXT;
        JPEG_EXT = JPEG_EXT;
        EPS_EXT = EPS_EXT;
        SVM_EXT = SVM_EXT;
    }
}

