/*
* MyGoGrinder - a program to practice Go problems
* Copyright (C) Ruediger Klehn (2014)
*   RuediRf@users.sourceforge.net
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.sgf;

import javax.swing.*;

import GoGrinder.ExceptionHandler;
//import GoGrinder.GS;
//import GoGrinder.SGFController;
import GoGrinder.Main;
//import GoGrinder.WGFController;

/**
 * @author Ruediger Klehn
 * @author  tkington
 */
// this class doesn't send anything to the file writer (that's handled by SGFLog)
public class SGFParseException extends Exception {
    public static boolean newExc = false;
    static final String NL = Main.NEW_LINE;
    
    //public static String displayString = ""; // HIER AUCH NOCH!
    /** Creates a new instance of SGFParseException */
    public SGFParseException(String msg) {
        super(msg);
    }
    
    public SGFParseException(Throwable cause) {
        super(cause);
    }
    
    //public SGFParseException(Throwable cause, String msg) {
    //    super(msg, cause);
    //}
    
    public SGFParseException(Throwable cause, String whatWhere){ // This still doesn't work as I want - its the old exception
      String originMsg = "";
      String origin = "" + getStackTrace()[0];
      if (Main.DEBUG2) originMsg = " >>> Happened in " + origin + NL;
      SGFLog.SGFLog(whatWhere, "", "", origin);
      ExceptionHandler.logCommonProblem(cause, "(per old SGFParseException - " + whatWhere);
    }
    
    //public SGFParseException(Throwable trace, String whyWhatWhere, int dummy){ // try new
    //  super(whyWhatWhere, trace);
    //  whyWhatWhere += NL + " >>> Happened in " + getStackTrace()[0];
    //  SGFParseException(trace, whyWhatWhere + trace.toString(), "");
    //}
    
    // this is used, when we hand over another exception, e.g. common Exception and want to preserve the original stacktrace
    public SGFParseException(Throwable trace, String parserMsg, String code){  // we use it now in e.g. Validator
      super(parserMsg, trace);
      newExc = true;
      String originMsg = "";
      String stackTop = "" + getStackTrace()[0];
      if (SGFLog.logLevel > 2 || Main.DEBUG2) originMsg = NL + " >>> Happened in " + stackTop + NL;
      String currFileStr = SGFLog.getCurrentFileName();
      String fileMsg = "Current file: " + NL + "\"" + currFileStr + "\"" + NL;
      code = SGFLog.shortenCode(code);
      if (!SGFParser.VALIDATING){
       // displayString = fileMsg + parserMsg + code + "<br>" + originMsg;
        // JOptionPane.showMessageDialog(null, displayString); //"curr. file: NAME \n (SZ[13]...) \n LOC
      }
      System.out.println(fileMsg + parserMsg + originMsg + "\n");
      SGFLog.SGFLog(currFileStr, parserMsg, code, stackTop);
      if (Main.DEBUG2){Main.logSilent(trace, currFileStr + NL + parserMsg + NL + code);}//.fillInStackTrace()
      
      
      //new SGFParseException(fillInStackTrace(), parserMsg, code);
    }
    
     // at the moment this is the standard exception for the sgf files
    public SGFParseException(String parserMsg, String code){
      // or fetch the code depending on checkingSGF? - more complicated?
      super(parserMsg);
      newExc = true; // in SGFController, catch(SGFParseException...) we decide, if we have the old Exception handling
      String originMsg = "";
      String stackTop = "" + getStackTrace()[0];
      if (SGFLog.logLevel > 2 || Main.DEBUG2) originMsg = NL + " >>> Happened in " + stackTop + NL;
      String currFileStr = SGFLog.getCurrentFileName();
      String fileMsg = "Current file: " + NL + "\"" + currFileStr + "\"" + NL;
      code = SGFLog.shortenCode(code);
      if (!code.equals("")) code = NL + code;
      if (!SGFParser.VALIDATING){ // WHAT THEN?
         //"Curr. file: \n NAME \n (SZ[13]...) \n LOCATION
         // displayString = fileMsg + parserMsg + "<br>" + code + originMsg;
         //JOptionPane.showMessageDialog(null, displayString);//fileMsg + parserMsg + code + originMsg
      }
      System.out.println(fileMsg + parserMsg + originMsg + "\n");
      SGFLog.SGFLog(currFileStr, parserMsg, code, stackTop);
      if (Main.DEBUG2){Main.logSilent(fillInStackTrace(), currFileStr + NL + parserMsg + code);}//
    }
}
