/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.omegat.util.StaticUtils;

public final class TeamSettings {
    private static File configFile;

    private TeamSettings() {
    }

    private static synchronized File getConfigFile() {
        if (configFile == null) {
            configFile = new File(StaticUtils.getConfigDir(), "repositories.properties");
        }
        return configFile;
    }

    public static synchronized Set<Object> listKeys() {
        try {
            Properties p = new Properties();
            if (TeamSettings.getConfigFile().exists()) {
                try (FileInputStream in = new FileInputStream(TeamSettings.getConfigFile());){
                    p.load(in);
                }
            }
            return p.keySet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static synchronized String get(String key) {
        try {
            Properties p = new Properties();
            if (TeamSettings.getConfigFile().exists()) {
                try (FileInputStream in = new FileInputStream(TeamSettings.getConfigFile());){
                    p.load(in);
                }
            }
            return p.getProperty(key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static synchronized void set(String key, String newValue) {
        try {
            Properties p = new Properties();
            File f = TeamSettings.getConfigFile();
            File fNew = new File(TeamSettings.getConfigFile().getAbsolutePath() + ".new");
            if (f.exists()) {
                try (FileInputStream in = new FileInputStream(f);){
                    p.load(in);
                }
            } else {
                boolean in = f.getParentFile().mkdirs();
            }
            if (newValue != null) {
                p.setProperty(key, newValue);
            } else {
                p.remove(key);
            }
            try (FileOutputStream out = new FileOutputStream(fNew);){
                p.store(out, null);
            }
            boolean ignored = f.delete();
            FileUtils.moveFile((File)fNew, (File)f);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

