/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.preferences;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.omegat.core.Core;
import org.omegat.core.team2.gui.RepositoriesCredentialsController;
import org.omegat.externalfinder.gui.ExternalFinderPreferencesController;
import org.omegat.gui.filters2.FiltersCustomizerController;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.gui.preferences.IPreferencesController;
import org.omegat.gui.preferences.PreferencePanel;
import org.omegat.gui.preferences.PreferenceViewSelectorPanel;
import org.omegat.gui.preferences.PreferencesControllers;
import org.omegat.gui.preferences.view.AppearanceController;
import org.omegat.gui.preferences.view.AutoCompleterController;
import org.omegat.gui.preferences.view.AutotextAutoCompleterOptionsController;
import org.omegat.gui.preferences.view.CharTableAutoCompleterOptionsController;
import org.omegat.gui.preferences.view.CustomColorSelectionController;
import org.omegat.gui.preferences.view.DictionaryPreferencesController;
import org.omegat.gui.preferences.view.EditingBehaviorController;
import org.omegat.gui.preferences.view.FontSelectionController;
import org.omegat.gui.preferences.view.GeneralOptionsController;
import org.omegat.gui.preferences.view.GlossaryAutoCompleterOptionsController;
import org.omegat.gui.preferences.view.GlossaryPreferencesController;
import org.omegat.gui.preferences.view.HistoryAutoCompleterOptionsController;
import org.omegat.gui.preferences.view.LanguageToolConfigurationController;
import org.omegat.gui.preferences.view.MachineTranslationPreferencesController;
import org.omegat.gui.preferences.view.PluginsPreferencesController;
import org.omegat.gui.preferences.view.SaveOptionsController;
import org.omegat.gui.preferences.view.SecureStoreController;
import org.omegat.gui.preferences.view.SpellcheckerConfigurationController;
import org.omegat.gui.preferences.view.TMMatchesPreferencesController;
import org.omegat.gui.preferences.view.TagProcessingOptionsController;
import org.omegat.gui.preferences.view.TeamOptionsController;
import org.omegat.gui.preferences.view.UserPassController;
import org.omegat.gui.preferences.view.VersionCheckPreferencesController;
import org.omegat.gui.preferences.view.ViewOptionsController;
import org.omegat.gui.segmentation.SegmentationCustomizerController;
import org.omegat.util.Java8Compat;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.StaticUIUtils;

public class PreferencesWindowController
implements IPreferencesController.FurtherActionListener {
    private static final Logger LOGGER = Logger.getLogger(PreferencesWindowController.class.getName());
    private static final String ACTION_KEY_NEW_SEARCH = "clearSearch";
    private static final String ACTION_KEY_CLEAR_OR_CLOSE = "clearSearchOrClose";
    private static final String ACTION_KEY_DO_SEARCH = "doSearch";
    private JDialog dialog;
    private PreferencePanel outerPanel;
    private PreferenceViewSelectorPanel innerPanel;
    private HighlightablePanel overlay;
    private IPreferencesController currentView;
    private boolean didLoadGuis;
    private final Map<String, Runnable> persistenceRunnables = new HashMap<String, Runnable>();

    public void show(Window parent) {
        this.show(parent, null);
    }

    public void show(Window parent, final Class<? extends IPreferencesController> initialSelection) {
        this.dialog = new JDialog();
        this.dialog.setTitle(OStrings.getString("PREFERENCES_TITLE_NO_SELECTION"));
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setModal(true);
        StaticUIUtils.setWindowIcon(this.dialog);
        this.outerPanel = new PreferencePanel();
        this.innerPanel = new PreferenceViewSelectorPanel();
        this.outerPanel.prefsViewPanel.add((Component)this.innerPanel, "Center");
        this.dialog.getContentPane().add(this.outerPanel);
        this.overlay = new HighlightablePanel(this.dialog.getRootPane(), this.innerPanel.selectedPrefsScrollPane);
        this.innerPanel.selectedPrefsScrollPane.getViewport().setOpaque(false);
        this.innerPanel.selectedPrefsScrollPane.setBackground(this.innerPanel.getBackground());
        this.innerPanel.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(() -> PreferencesWindowController.this.searchAndFilterTree());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(() -> PreferencesWindowController.this.searchAndFilterTree());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(() -> PreferencesWindowController.this.searchAndFilterTree());
            }
        });
        this.innerPanel.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    PreferencesWindowController.this.innerPanel.availablePrefsTree.getActionForKeyStroke(KeyStroke.getKeyStrokeForEvent(e)).actionPerformed(new ActionEvent(PreferencesWindowController.this.innerPanel.availablePrefsTree, 0, null));
                    PreferencesWindowController.this.innerPanel.availablePrefsTree.requestFocusInWindow();
                    e.consume();
                }
            }
        });
        this.innerPanel.searchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PreferencesWindowController.this.innerPanel.searchTextField.selectAll();
                PreferencesWindowController.this.searchCurrentView();
                PreferencesWindowController.this.preloadGuis();
            }
        });
        this.innerPanel.clearButton.addActionListener(e -> this.innerPanel.searchTextField.clear());
        this.innerPanel.availablePrefsTree.getSelectionModel().setSelectionMode(1);
        final DefaultMutableTreeNode root = PreferencesWindowController.createNodeTree();
        PreferencesWindowController.walkTree(root, node -> {
            IPreferencesController view = (IPreferencesController)node.getUserObject();
            if (view != null) {
                view.addFurtherActionListener(this);
            }
        });
        this.innerPanel.availablePrefsTree.setModel(new DefaultTreeModel(root));
        this.innerPanel.availablePrefsTree.addTreeSelectionListener(e -> {
            this.handleViewSelection(e);
            this.updateTitle();
        });
        this.innerPanel.availablePrefsTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                SwingUtilities.invokeLater(() -> PreferencesWindowController.this.adjustTreeSize());
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.innerPanel.selectedPrefsScrollPane.getViewport().setBackground(this.innerPanel.getBackground());
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.innerPanel.availablePrefsTree.getCellRenderer();
        renderer.setIcon(null);
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setDisabledIcon(null);
        this.outerPanel.okButton.addActionListener(e -> {
            if (this.currentView == null || this.currentView.validate()) {
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        PreferencesWindowController.this.doSave();
                        return null;
                    }

                    @Override
                    protected void done() {
                        if (PreferencesWindowController.this.getIsReloadRequired()) {
                            SwingUtilities.invokeLater(ProjectUICommands::promptReload);
                        }
                    }
                }.execute();
                StaticUIUtils.closeWindowByEvent(this.dialog);
            }
        });
        this.outerPanel.cancelButton.addActionListener(e -> StaticUIUtils.closeWindowByEvent(this.dialog));
        this.outerPanel.undoButton.setVisible(false);
        this.outerPanel.resetButton.setVisible(false);
        this.innerPanel.undoButton.addActionListener(e -> this.currentView.undoChanges());
        this.innerPanel.resetButton.addActionListener(e -> this.currentView.restoreDefaults());
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                PreferencesWindowController.walkTree(root, node -> {
                    if (node.getChildCount() > 0) {
                        PreferencesWindowController.this.innerPanel.availablePrefsTree.expandPath(new TreePath(node.getPath()));
                    }
                });
                SwingUtilities.invokeLater(() -> {
                    if (initialSelection != null) {
                        PreferencesWindowController.this.selectView(initialSelection);
                    }
                });
            }
        });
        this.innerPanel.availablePrefsScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingUtilities.invokeLater(() -> PreferencesWindowController.this.adjustTreeSize());
            }
        });
        ActionMap actionMap = this.innerPanel.getActionMap();
        InputMap inputMap = this.innerPanel.getInputMap(2);
        actionMap.put(ACTION_KEY_NEW_SEARCH, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindowController.this.innerPanel.searchTextField.requestFocusInWindow();
                PreferencesWindowController.this.innerPanel.searchTextField.selectAll();
            }
        });
        KeyStroke searchKeyStroke = KeyStroke.getKeyStroke(70, Java8Compat.getMenuShortcutKeyMaskEx());
        inputMap.put(searchKeyStroke, ACTION_KEY_NEW_SEARCH);
        actionMap.put(ACTION_KEY_CLEAR_OR_CLOSE, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PreferencesWindowController.this.innerPanel.searchTextField.isEmpty()) {
                    PreferencesWindowController.this.innerPanel.availablePrefsTree.requestFocusInWindow();
                    PreferencesWindowController.this.innerPanel.clearButton.doClick();
                } else {
                    StaticUIUtils.closeWindowByEvent(PreferencesWindowController.this.dialog);
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(27, 0), ACTION_KEY_CLEAR_OR_CLOSE);
        this.innerPanel.searchTextField.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), ACTION_KEY_DO_SEARCH);
        this.innerPanel.searchTextField.getActionMap().put(ACTION_KEY_DO_SEARCH, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesWindowController.this.searchCurrentView();
            }
        });
        String searchKeyText = StaticUIUtils.getKeyStrokeText(searchKeyStroke);
        this.innerPanel.searchTextField.setHintText(OStrings.getString("PREFERENCES_SEARCH_HINT", searchKeyText));
        this.searchAndFilterTree();
        this.adjustTreeSize();
        this.dialog.getRootPane().setDefaultButton(this.outerPanel.okButton);
        this.dialog.setPreferredSize(new Dimension(800, 500));
        this.dialog.pack();
        this.innerPanel.availablePrefsTree.requestFocusInWindow();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.setVisible(true);
    }

    private static DefaultMutableTreeNode createNodeTree() {
        HideableNode root = new HideableNode();
        root.add(new HideableNode(new GeneralOptionsController()));
        root.add(new HideableNode(new MachineTranslationPreferencesController()));
        root.add(new HideableNode(new GlossaryPreferencesController()));
        root.add(new HideableNode(new DictionaryPreferencesController()));
        HideableNode appearanceNode = new HideableNode(new AppearanceController());
        appearanceNode.add(new HideableNode(new FontSelectionController()));
        appearanceNode.add(new HideableNode(new CustomColorSelectionController()));
        root.add(appearanceNode);
        root.add(new HideableNode(new FiltersCustomizerController()));
        root.add(new HideableNode(new SegmentationCustomizerController()));
        HideableNode acNode = new HideableNode(new AutoCompleterController());
        acNode.add(new HideableNode(new GlossaryAutoCompleterOptionsController()));
        acNode.add(new HideableNode(new AutotextAutoCompleterOptionsController()));
        acNode.add(new HideableNode(new CharTableAutoCompleterOptionsController()));
        acNode.add(new HideableNode(new HistoryAutoCompleterOptionsController()));
        root.add(acNode);
        root.add(new HideableNode(new SpellcheckerConfigurationController()));
        root.add(new HideableNode(new LanguageToolConfigurationController()));
        root.add(new HideableNode(new ExternalFinderPreferencesController()));
        root.add(new HideableNode(new EditingBehaviorController()));
        root.add(new HideableNode(new TagProcessingOptionsController()));
        HideableNode teamNode = new HideableNode(new TeamOptionsController());
        teamNode.add(new HideableNode(new RepositoriesCredentialsController()));
        root.add(teamNode);
        root.add(new HideableNode(new TMMatchesPreferencesController()));
        root.add(new HideableNode(new ViewOptionsController()));
        root.add(new HideableNode(new SaveOptionsController()));
        root.add(new HideableNode(new UserPassController()));
        root.add(new HideableNode(new SecureStoreController()));
        HideableNode pluginsNode = new HideableNode(new PluginsPreferencesController());
        root.add(pluginsNode);
        root.add(new HideableNode(new VersionCheckPreferencesController()));
        PreferencesControllers.getSuppliers().forEach(s -> PreferencesWindowController.placePluginView(root, (IPreferencesController)s.get()));
        return root;
    }

    private static void placePluginView(HideableNode root, IPreferencesController view) {
        Class<? extends IPreferencesController> parentClass = view.getParentViewClass();
        Class effectiveParentClass = parentClass == null ? PluginsPreferencesController.class : parentClass;
        PreferencesWindowController.walkTree(root, node -> {
            IPreferencesController parent = (IPreferencesController)node.getUserObject();
            if (parent != null && parent.getClass().equals(effectiveParentClass)) {
                node.add(new HideableNode(view));
            }
        });
    }

    @Override
    public void setRestartRequired(boolean restartRequired) {
        this.updateMessage();
    }

    @Override
    public void setReloadRequired(boolean reloadRequired) {
        this.updateMessage();
    }

    private HideableNode getRoot() {
        return (HideableNode)this.innerPanel.availablePrefsTree.getModel().getRoot();
    }

    private boolean getIsRestartRequired() {
        return PreferencesWindowController.anyInTree(this.getRoot(), node -> {
            IPreferencesController view = (IPreferencesController)node.getUserObject();
            return view != null && view.isRestartRequired();
        });
    }

    private boolean getIsReloadRequired() {
        if (!Core.getProject().isProjectLoaded()) {
            return false;
        }
        return PreferencesWindowController.anyInTree(this.getRoot(), node -> {
            IPreferencesController view = (IPreferencesController)node.getUserObject();
            return view != null && view.isReloadRequired();
        });
    }

    private void updateMessage() {
        String message = null;
        if (this.getIsRestartRequired()) {
            message = OStrings.getString("PREFERENCES_WARNING_NEEDS_RESTART");
        } else if (this.getIsReloadRequired()) {
            message = OStrings.getString("PREFERENCES_WARNING_NEEDS_RELOAD");
        }
        this.outerPanel.messageTextArea.setText(message);
    }

    private void handleViewSelection(TreeSelectionEvent e) {
        TreePath selectedPath = e.getNewLeadSelectionPath();
        if (selectedPath == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedPath.getLastPathComponent();
        if (node == null) {
            return;
        }
        IPreferencesController oldView = this.currentView;
        Object obj = node.getUserObject();
        if (!(obj instanceof IPreferencesController)) {
            return;
        }
        IPreferencesController newView = (IPreferencesController)obj;
        if (Objects.equals(oldView, newView)) {
            return;
        }
        if (oldView != null && !oldView.validate()) {
            this.innerPanel.availablePrefsTree.getSelectionModel().setSelectionPath(e.getOldLeadSelectionPath());
            return;
        }
        if (!this.persistenceRunnables.containsKey(newView.getClass().getName())) {
            this.persistenceRunnables.put(newView.getClass().getName(), newView::persist);
        }
        this.overlay.setHighlightComponent(null);
        this.innerPanel.innerViewHolder.removeAll();
        this.innerPanel.innerViewHolder.add(newView.getGui(), "Center");
        this.innerPanel.selectedPrefsScrollPane.setViewportView(this.innerPanel.viewHolder);
        this.currentView = newView;
        SwingUtilities.invokeLater(() -> {
            this.adjustSize();
            this.searchCurrentView();
        });
    }

    private void updateTitle() {
        if (this.currentView == null) {
            this.dialog.setTitle(OStrings.getString("PREFERENCES_TITLE_NO_SELECTION"));
        } else {
            this.dialog.setTitle(StringUtil.format(OStrings.getString("PREFERENCES_TITLE_WITH_SELECTION"), this.currentView));
        }
    }

    private void adjustSize() {
        Dimension viewPreferredSize = this.innerPanel.viewHolder.getPreferredSize();
        Dimension viewActualSize = this.innerPanel.selectedPrefsScrollPane.getViewport().getSize();
        Dimension dialogSize = this.dialog.getSize();
        boolean shouldAdjust = false;
        if (viewPreferredSize.width > viewActualSize.width) {
            dialogSize.width += viewPreferredSize.width - viewActualSize.width;
            shouldAdjust = true;
        }
        if (viewPreferredSize.height > viewActualSize.height) {
            dialogSize.height += viewPreferredSize.height - viewActualSize.height;
            shouldAdjust = true;
        }
        if (shouldAdjust) {
            this.dialog.setSize(dialogSize);
            StaticUIUtils.fitInScreen(this.dialog);
        }
    }

    private void adjustTreeSize() {
        JScrollBar hScrollBar = this.innerPanel.availablePrefsScrollPane.getHorizontalScrollBar();
        if (hScrollBar != null) {
            int currentWidth = this.innerPanel.availablePrefsScrollPane.getViewport().getWidth();
            int preferredWidth = hScrollBar.getMaximum();
            if (preferredWidth > currentWidth) {
                int newWidth = this.innerPanel.leftPanel.getWidth() + (preferredWidth - currentWidth);
                this.innerPanel.leftPanel.setMinimumSize(new Dimension(newWidth, 0));
                this.innerPanel.mainSplitPane.setDividerLocation(-1);
            }
        }
    }

    private void searchAndFilterTree() {
        this.incrementalSearchImpl(true, this.getRoot());
    }

    private void searchCurrentView() {
        TreePath selection = this.innerPanel.availablePrefsTree.getSelectionPath();
        if (selection != null) {
            HideableNode root = (HideableNode)selection.getLastPathComponent();
            this.incrementalSearchImpl(false, root);
        }
    }

    private void incrementalSearchImpl(boolean filterTree, HideableNode root) {
        boolean isEmptyQuery = this.innerPanel.searchTextField.isEmpty();
        this.innerPanel.clearButton.setEnabled(!isEmptyQuery);
        if (isEmptyQuery) {
            if (filterTree) {
                if (PreferencesWindowController.setTreeVisible(root, true)) {
                    ((DefaultTreeModel)this.innerPanel.availablePrefsTree.getModel()).reload();
                }
                this.selectView(this.currentView);
            }
            this.overlay.setHighlightComponent(null);
            return;
        }
        String query = this.innerPanel.searchTextField.getText().trim();
        if (this.currentView != null && !this.currentView.validate()) {
            this.innerPanel.searchTextField.clear();
            return;
        }
        Pattern pattern = Pattern.compile(".*" + Pattern.quote(query) + ".*", 66);
        List<GuiSearchResult> results = PreferencesWindowController.searchTree(root, pattern.asPredicate());
        if (filterTree) {
            PreferencesWindowController.setTreeVisible(root, false);
        }
        if (results.isEmpty()) {
            this.innerPanel.searchTextField.setForeground(UIManager.getColor("OmegaT.searchFieldErrorText"));
            if (filterTree) {
                ((DefaultTreeModel)this.innerPanel.availablePrefsTree.getModel()).reload();
            }
            this.overlay.setHighlightComponent(null);
            this.innerPanel.selectedPrefsScrollPane.setViewportView(this.innerPanel.selectedPrefsPlaceholderPanel);
            this.currentView = null;
            this.updateTitle();
        } else {
            GuiSearchResult topResult = results.get(0);
            if (filterTree) {
                for (GuiSearchResult result : results) {
                    PreferencesWindowController.setNodePathVisible((HideableNode)result.node, true);
                }
                ((DefaultTreeModel)this.innerPanel.availablePrefsTree.getModel()).reload();
                this.selectNode(topResult.node);
            }
            if (topResult.comp != null) {
                ((JComponent)topResult.comp).scrollRectToVisible(topResult.comp.getBounds());
                this.overlay.setHighlightComponent(topResult.comp);
            }
            this.innerPanel.searchTextField.setForeground(UIManager.getColor("TextField.foreground"));
        }
    }

    private void selectView(IPreferencesController view) {
        PreferencesWindowController.firstNodeInTree(this.getRoot(), node -> node.getUserObject() == view).ifPresent(this::selectNode);
    }

    private void selectView(Class<? extends IPreferencesController> viewClass) {
        PreferencesWindowController.firstNodeInTree(this.getRoot(), node -> {
            Object obj = node.getUserObject();
            return obj != null && obj.getClass().equals(viewClass);
        }).ifPresent(this::selectNode);
    }

    void selectNode(DefaultMutableTreeNode node) {
        this.innerPanel.availablePrefsTree.setSelectionPath(new TreePath(node.getPath()));
    }

    private static boolean setTreeVisible(HideableNode root, boolean isVisible) {
        List<Boolean> changes = PreferencesWindowController.mapTree(root, node -> {
            HideableNode hideable = (HideableNode)node;
            boolean wasVisible = hideable.isVisible;
            hideable.setVisible(isVisible);
            return wasVisible != isVisible;
        });
        root.setVisible(true);
        return changes.contains(true);
    }

    private static void setNodePathVisible(HideableNode node, boolean isVisible) {
        node.setVisible(isVisible);
        for (TreeNode parent : node.getPath()) {
            ((HideableNode)parent).setVisible(isVisible);
        }
    }

    private static List<GuiSearchResult> searchTree(DefaultMutableTreeNode root, Predicate<String> filter) {
        ArrayList<GuiSearchResult> result = new ArrayList<GuiSearchResult>();
        PreferencesWindowController.walkTree(root, node -> {
            IPreferencesController view = (IPreferencesController)node.getUserObject();
            if (view != null) {
                PreferencesWindowController.visitUiStrings(view.getGui(), (str, comp) -> {
                    if (filter.test((String)str)) {
                        result.add(new GuiSearchResult((DefaultMutableTreeNode)node, (String)str, (Component)comp));
                    }
                });
                if (filter.test(view.toString())) {
                    result.add(new GuiSearchResult((DefaultMutableTreeNode)node, view.toString(), null));
                }
            }
        });
        return result;
    }

    private static void visitUiStrings(Component comp, BiConsumer<String, Component> consumer) {
        StaticUIUtils.visitHierarchy(comp, c -> c.isVisible(), c -> {
            try {
                Method getText = c.getClass().getMethod("getText", new Class[0]);
                String str = (String)getText.invoke(c, new Object[0]);
                if (!StringUtil.isEmpty(str)) {
                    consumer.accept(str, (Component)c);
                }
            }
            catch (NoSuchMethodException getText) {
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
    }

    private static void walkTree(DefaultMutableTreeNode node, Consumer<DefaultMutableTreeNode> consumer) {
        consumer.accept(node);
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode o = e.nextElement();
            PreferencesWindowController.walkTree((DefaultMutableTreeNode)o, consumer);
        }
    }

    private static <T> List<T> mapTree(DefaultMutableTreeNode node, Function<DefaultMutableTreeNode, T> function) {
        ArrayList results = new ArrayList();
        PreferencesWindowController.walkTree(node, n -> results.add(function.apply((DefaultMutableTreeNode)n)));
        return results;
    }

    private static boolean anyInTree(DefaultMutableTreeNode node, Predicate<DefaultMutableTreeNode> predicate) {
        return PreferencesWindowController.firstNodeInTree(node, predicate).isPresent();
    }

    private static Optional<DefaultMutableTreeNode> firstNodeInTree(DefaultMutableTreeNode node, Predicate<DefaultMutableTreeNode> predicate) {
        if (predicate.test(node)) {
            return Optional.of(node);
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreeNode o = e.nextElement();
            Optional<DefaultMutableTreeNode> child = PreferencesWindowController.firstNodeInTree((DefaultMutableTreeNode)o, predicate);
            if (!child.isPresent()) continue;
            return child;
        }
        return Optional.empty();
    }

    private void preloadGuis() {
        if (this.didLoadGuis) {
            return;
        }
        new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                PreferencesWindowController.this.preloadGuisImpl();
                PreferencesWindowController.this.didLoadGuis = true;
                return null;
            }
        }.execute();
    }

    private void preloadGuisImpl() {
        PreferencesWindowController.walkTree(this.getRoot(), node -> {
            IPreferencesController view = (IPreferencesController)node.getUserObject();
            if (view != null) {
                try {
                    view.getGui();
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        });
    }

    private void doSave() {
        this.persistenceRunnables.entrySet().forEach(e -> {
            long start = System.currentTimeMillis();
            ((Runnable)e.getValue()).run();
            long end = System.currentTimeMillis();
            if (end - start > 100L) {
                LOGGER.finer(() -> String.format("Persisting %s took %d ms", e.getKey(), end - start));
            }
        });
        Preferences.save();
    }

    static class HighlightablePanel
    extends JPanel {
        private static final Color SHADOW_COLOR = UIManager.getColor("OmegaT.searchDimmedBackground");
        private static final Color STROKE_COLOR = UIManager.getColor("OmegaT.searchResultBorder");
        private static final int STROKE = 2;
        private static final BasicStroke STROKE_OBJ = new BasicStroke(2.0f);
        private final transient ComponentListener compListener;
        private final transient MouseAdapter mouseAdapter;
        private final JRootPane rootPane;
        private final Component overlayComponent;
        private final Rectangle clipRect = new Rectangle();
        private final Rectangle highlightRect = new Rectangle();
        private Component comp;

        HighlightablePanel(final JRootPane rootPane, Component overlayComponent) {
            this.rootPane = rootPane;
            this.overlayComponent = overlayComponent;
            this.mouseAdapter = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.forward(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.forward(e);
                    this.setHighlightComponent(null);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    this.forward(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    this.forward(e);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    this.forward(e);
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.forward(e);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    this.forward(e);
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    this.forward(e);
                }

                private void forward(MouseEvent e) {
                    Point p;
                    Container contentPane = rootPane.getContentPane();
                    Component target = contentPane.findComponentAt(p = SwingUtilities.convertPoint(this, e.getPoint(), contentPane));
                    if (target != null) {
                        e = SwingUtilities.convertMouseEvent(this, e, target);
                        target.dispatchEvent(e);
                    }
                }
            };
            this.addMouseListener(this.mouseAdapter);
            this.addMouseMotionListener(this.mouseAdapter);
            this.addMouseWheelListener(this.mouseAdapter);
            this.compListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.update();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    this.update();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    this.update();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    this.update();
                }
            };
            SwingUtilities.windowForComponent(rootPane).addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                    this.setVisible(false);
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    this.setVisible(true);
                }
            });
            this.setOpaque(false);
        }

        public void setHighlightComponent(Component comp) {
            Component oldComp = this.comp;
            this.comp = comp;
            if (comp == null) {
                this.uninstall();
            } else if (Objects.equals(oldComp, comp)) {
                this.update();
            } else {
                this.install();
            }
        }

        private void update() {
            Rectangle bounds = SwingUtilities.convertRectangle(this.overlayComponent.getParent(), this.overlayComponent.getBounds(), this.rootPane.getLayeredPane());
            this.setBounds(bounds);
            this.repaint();
        }

        private void install() {
            JLayeredPane layeredPane = this.rootPane.getLayeredPane();
            if (!layeredPane.isAncestorOf(this)) {
                layeredPane.add((Component)this, JLayeredPane.MODAL_LAYER);
                this.overlayComponent.addComponentListener(this.compListener);
            }
            this.update();
        }

        private void uninstall() {
            JLayeredPane layeredPane = this.rootPane.getLayeredPane();
            layeredPane.remove(this);
            this.overlayComponent.removeComponentListener(this.compListener);
            this.overlayComponent.repaint();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (this.comp != null) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setStroke(STROKE_OBJ);
                this.paintHighlight(g2);
                g2.dispose();
            }
        }

        private void paintHighlight(Graphics2D g) {
            g.getClipBounds(this.clipRect);
            Area realClip = new Area(this.clipRect);
            Rectangle rect = this.getHighlightRect();
            Shape knockOut = this.roundifyRect(rect);
            realClip.subtract(new Area(knockOut));
            g.setClip(realClip);
            g.setColor(SHADOW_COLOR);
            g.fillRect(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.clipRect.height);
            g.setClip(this.clipRect);
            g.setColor(STROKE_COLOR);
            g.draw(knockOut);
        }

        private Rectangle getHighlightRect() {
            this.comp.getBounds(this.highlightRect);
            Point p = SwingUtilities.convertPoint(this.comp.getParent(), this.highlightRect.x, this.highlightRect.y, this);
            this.highlightRect.setLocation(p);
            return this.highlightRect;
        }

        private Shape roundifyRect(Rectangle rect) {
            int r = Math.min(10, Math.round((float)rect.height * 0.5f));
            int halfR = r / 2;
            RoundRectangle2D.Float roundRect = new RoundRectangle2D.Float(rect.x - halfR, rect.y - halfR, (float)(rect.width + r) - 1.5f, rect.height + r - 2, r, r);
            return roundRect;
        }
    }

    static class HideableNode
    extends DefaultMutableTreeNode {
        private boolean isVisible = true;

        HideableNode() {
        }

        HideableNode(Object userObject) {
            super(userObject);
        }

        public boolean isVisible() {
            return this.isVisible;
        }

        public void setVisible(boolean isVisible) {
            this.isVisible = isVisible;
        }

        @Override
        public TreeNode getChildAt(int index) {
            if (this.children == null) {
                throw new IndexOutOfBoundsException("node has no children");
            }
            int realIndex = -1;
            int visibleIndex = -1;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                HideableNode node = (HideableNode)e.nextElement();
                if (node.isVisible()) {
                    ++visibleIndex;
                }
                ++realIndex;
                if (visibleIndex != index) continue;
                Object result = this.children.elementAt(realIndex);
                return (TreeNode)result;
            }
            throw new IndexOutOfBoundsException("index unmatched");
        }

        @Override
        public int getChildCount() {
            if (this.children == null) {
                return 0;
            }
            int count = 0;
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                HideableNode node = (HideableNode)e.nextElement();
                if (!node.isVisible()) continue;
                ++count;
            }
            return count;
        }
    }

    static class GuiSearchResult {
        public final DefaultMutableTreeNode node;
        public final String string;
        public final Component comp;

        GuiSearchResult(DefaultMutableTreeNode node, String string, Component comp) {
            this.node = node;
            this.string = string;
            this.comp = comp;
        }
    }
}

