/*
 * Decompiled with CFR 0.152.
 */
package org.caffinitas.ohc.linked;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.caffinitas.ohc.linked.Uns;

abstract class AbstractDataInput
implements DataInput {
    long blkAdr;
    long blkOff;
    private final long blkEnd;

    AbstractDataInput(long hashEntryAdr, long offset, long len) {
        this.blkAdr = hashEntryAdr;
        this.blkOff = offset;
        this.blkEnd = offset + len;
    }

    long avail() {
        return this.blkEnd - this.blkOff;
    }

    void assertAvail(int req) throws IOException {
        if (this.available() < req || req < 0) {
            throw new EOFException();
        }
    }

    public int available() {
        long av = this.avail();
        return av > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)av;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (b == null || off < 0 || off + len > b.length || len < 0) {
            throw new IllegalArgumentException();
        }
        this.assertAvail(len);
        Uns.copyMemory(this.blkAdr, this.blkOff, b, off, (long)len);
        this.blkOff += (long)len;
    }

    @Override
    public byte readByte() throws IOException {
        this.assertAvail(1);
        return Uns.getByte(this.blkAdr, this.blkOff++);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.assertAvail(n);
        this.blkOff += (long)n;
        return n;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

