/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.charset.Charset;
import org.apache.catalina.ha.backend.HeartbeatListener;
import org.apache.catalina.ha.backend.Sender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MultiCastSender
implements Sender {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    private static final Charset US_ASCII = Charset.forName("US-ASCII");
    HeartbeatListener config = null;
    MulticastSocket s = null;
    InetAddress group = null;

    @Override
    public void init(HeartbeatListener config) throws Exception {
        this.config = config;
    }

    @Override
    public int send(String mess) throws Exception {
        if (this.s == null) {
            try {
                this.group = InetAddress.getByName(this.config.getGroup());
                if (this.config.host != null) {
                    InetAddress addr = InetAddress.getByName(this.config.host);
                    InetSocketAddress addrs = new InetSocketAddress(addr, this.config.getMultiport());
                    this.s = new MulticastSocket(addrs);
                } else {
                    this.s = new MulticastSocket(this.config.getMultiport());
                }
                this.s.setTimeToLive(this.config.getTtl());
                this.s.joinGroup(this.group);
            }
            catch (Exception ex) {
                log.error((Object)("Unable to use multicast: " + ex));
                this.s = null;
                return -1;
            }
        }
        byte[] buf = mess.getBytes(US_ASCII);
        DatagramPacket data = new DatagramPacket(buf, buf.length, this.group, this.config.getMultiport());
        try {
            this.s.send(data);
        }
        catch (Exception ex) {
            log.error((Object)("Unable to send collected load information: " + ex));
            this.s.close();
            this.s = null;
            return -1;
        }
        return 0;
    }
}

