/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.policy.parser.processors;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.policy.PrimitiveAssertion;
import org.apache.ws.security.policy.parser.SecurityPolicy;
import org.apache.ws.security.policy.parser.SecurityPolicyToken;
import org.apache.ws.security.policy.parser.SecurityProcessorContext;

public class Trust10Processor {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean initializedTrust10 = false;

    public void initializeTrust10(SecurityPolicyToken spt) throws NoSuchMethodException {
        SecurityPolicyToken tmpSpt = SecurityPolicy.mustSupportClientChallenge.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.mustSupportServerChallenge.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireClientEntropy.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.requireServerEntropy.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
        tmpSpt = SecurityPolicy.mustSupportIssuedTokens.copy();
        tmpSpt.setProcessTokenMethod(this);
        spt.setChildToken(tmpSpt);
    }

    public Object doTrust10(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        SecurityPolicyToken spt = spc.readCurrentSecurityToken();
        switch (spc.getAction()) {
            case 1: {
                PrimitiveAssertion pa;
                String text;
                if (!this.initializedTrust10) {
                    try {
                        this.initializeTrust10(spt);
                        this.initializedTrust10 = true;
                    }
                    catch (NoSuchMethodException e) {
                        e.printStackTrace();
                        return new Boolean(false);
                    }
                }
                if ((text = (pa = spc.getAssertion()).getStrValue()) != null) {
                    text = text.trim();
                    this.log.debug((Object)("Value: '" + text.toString() + "'"));
                }
            }
            case 2: {
                break;
            }
        }
        return new Boolean(true);
    }

    public Object doMustSupportClientChallenge(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return new Boolean(true);
    }

    public Object doMustSupportServerChallenge(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return new Boolean(true);
    }

    public Object doRequireClientEntropy(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return new Boolean(true);
    }

    public Object doRequireServerEntropy(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return new Boolean(true);
    }

    public Object doMustSupportIssuedTokens(SecurityProcessorContext spc) {
        this.log.debug((Object)("Processing " + spc.readCurrentSecurityToken().getTokenName() + ": " + SecurityProcessorContext.ACTION_NAMES[spc.getAction()]));
        return new Boolean(true);
    }
}

