/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.Location;

public class LogBuilder {
    private final StringBuilder sb;
    private final List<Integer> points = new ArrayList<Integer>();

    public LogBuilder(int size) {
        this.sb = size <= 0 ? null : new StringBuilder(size);
    }

    private static String o2s(Object o) {
        return o == null ? "null" : (o instanceof Class ? ((Class)o).getName() : (o instanceof String ? (String)o : (o instanceof Location ? ((Location)o).toShortString() : o.toString())));
    }

    private static void add(StringBuilder sb, Object ... objects) {
        for (Object o : objects) {
            if (o instanceof Object[]) {
                for (Object o2 : (Object[])o) {
                    sb.append(LogBuilder.o2s(o2));
                }
                continue;
            }
            sb.append(LogBuilder.o2s(o));
        }
    }

    public void add(Object ... objects) {
        if (this.sb != null) {
            LogBuilder.add(this.sb, objects);
        }
    }

    public <T> void addCollection(String delim, Collection<T> c) {
        if (this.sb != null) {
            for (T t : c) {
                LogBuilder.add(this.sb, t, delim);
            }
            if (!c.isEmpty()) {
                this.shrink(delim);
            }
        }
    }

    public void addStackTrace() {
        if (this.sb != null) {
            FreeColDebugger.addStackTrace(this);
        }
    }

    public void truncate(int size) {
        if (this.sb != null && this.sb.length() > size) {
            this.sb.setLength(size);
        }
    }

    public void mark() {
        if (this.sb != null) {
            this.points.add(0, this.sb.length());
        }
    }

    public boolean grew(Object ... objects) {
        if (this.sb == null) {
            return false;
        }
        int p = this.points.remove(0);
        if (this.sb.length() <= p) {
            return false;
        }
        StringBuilder sb2 = new StringBuilder(64);
        LogBuilder.add(sb2, objects);
        this.sb.insert(p, sb2.toString());
        return true;
    }

    public void shrink(String delim) {
        if (this.sb != null && delim != null) {
            this.sb.setLength(this.sb.length() - delim.length());
        }
    }

    public void log(Logger logger, Level level) {
        if (this.sb != null && logger != null && level != null && logger.isLoggable(level)) {
            logger.log(level, this.toString());
        }
    }

    public int size() {
        return this.sb == null ? 0 : this.sb.length();
    }

    public static String wide(int size, Object ... objects) {
        int delta;
        boolean left;
        if (size == 0) {
            return "";
        }
        boolean bl = left = size > 0;
        if (!left) {
            size = -size;
        }
        StringBuilder s2 = new StringBuilder(size);
        LogBuilder.add(s2, objects);
        if (left) {
            for (delta = size - s2.length(); delta > 0; --delta) {
                s2.append(" ");
            }
        } else {
            while (delta > 0) {
                s2.insert(0, " ");
                --delta;
            }
        }
        if (delta < 0) {
            s2.setLength(size);
        }
        return s2.toString();
    }

    public String toString() {
        return this.sb == null ? "" : this.sb.toString();
    }
}

