/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.model;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueCache;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueFactory;
import org.gradle.internal.model.ValueCalculator;
import org.gradle.internal.resources.ProjectLeaseRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.BuildSession.class})
public class CalculatedValueContainerFactory
implements CalculatedValueFactory {
    private final ProjectLeaseRegistry projectLeaseRegistry;
    private final NodeExecutionContext globalContext;

    public CalculatedValueContainerFactory(ProjectLeaseRegistry projectLeaseRegistry, ServiceRegistry buildScopeServices) {
        this.projectLeaseRegistry = projectLeaseRegistry;
        this.globalContext = arg_0 -> ((ServiceRegistry)buildScopeServices).get(arg_0);
    }

    public <T, S extends ValueCalculator<? extends T>> CalculatedValueContainer<T, S> create(DisplayName displayName, S supplier) {
        return new CalculatedValueContainer(displayName, supplier, this.projectLeaseRegistry, this.globalContext);
    }

    public <T> CalculatedValueContainer<T, ValueCalculator<T>> create(DisplayName displayName, Supplier<? extends T> supplier) {
        return new CalculatedValueContainer(displayName, new SupplierBackedCalculator<T>(supplier), this.projectLeaseRegistry, this.globalContext);
    }

    public <T> CalculatedValueContainer<T, ValueCalculator<T>> create(DisplayName displayName, T value) {
        return new CalculatedValueContainer(displayName, value);
    }

    public <K, V> CalculatedValueCache<K, V> createCache(DisplayName type) {
        return new DefaultCalculatedValueCache(type, this);
    }

    private static class DefaultCalculatedValueCache<K, V>
    implements CalculatedValueCache<K, V> {
        private final DisplayName type;
        private final Map<K, CalculatedValue<V>> cache = new ConcurrentHashMap<K, CalculatedValue<V>>();
        private final CalculatedValueContainerFactory calculatedValueContainerFactory;

        public DefaultCalculatedValueCache(DisplayName type, CalculatedValueContainerFactory calculatedValueContainerFactory) {
            this.type = type;
            this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        }

        public V computeIfAbsent(K key, Function<K, V> factory) {
            CalculatedValue value = this.cache.computeIfAbsent(key, (? super K k) -> this.calculatedValueContainerFactory.create(Describables.of((Object)k, (Object)this.type), context -> factory.apply(k)));
            value.finalizeIfNotAlready();
            return (V)value.get();
        }

        public void clear() {
            this.cache.clear();
        }
    }

    private static class SupplierBackedCalculator<T>
    implements ValueCalculator<T> {
        private final Supplier<T> supplier;

        public SupplierBackedCalculator(Supplier<? extends T> supplier) {
            this.supplier = (Supplier)Cast.uncheckedCast(supplier);
        }

        @Override
        public T calculateValue(NodeExecutionContext context) {
            return this.supplier.get();
        }
    }
}

