/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementFactory;
import org.jetbrains.kotlin.com.intellij.psi.PsiField;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordComponent;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecordHeader;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeElement;
import org.jetbrains.kotlin.com.intellij.psi.augment.PsiAugmentProvider;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightRecordField;
import org.jetbrains.kotlin.com.intellij.psi.impl.light.LightRecordMethod;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.PsiExtensibleClass;
import org.jetbrains.kotlin.com.intellij.psi.util.AccessModifier;
import org.jetbrains.kotlin.com.intellij.psi.util.JavaPsiRecordUtil;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class RecordAugmentProvider
extends PsiAugmentProvider {
    @Override
    @NotNull
    protected <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type2, @Nullable String nameHint) {
        if (element == null) {
            RecordAugmentProvider.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiExtensibleClass) {
            PsiExtensibleClass aClass = (PsiExtensibleClass)element;
            if (!aClass.isRecord()) {
                List list2 = Collections.emptyList();
                if (list2 == null) {
                    RecordAugmentProvider.$$$reportNull$$$0(2);
                }
                return list2;
            }
            if (type2 == PsiMethod.class && !(element instanceof PsiCompiledElement)) {
                return RecordAugmentProvider.getAccessorsAugments(aClass);
            }
            if (type2 == PsiField.class) {
                return RecordAugmentProvider.getFieldAugments(aClass);
            }
        }
        List list3 = Collections.emptyList();
        if (list3 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getAccessorsAugments(PsiExtensibleClass aClass) {
        PsiRecordHeader header = aClass.getRecordHeader();
        if (header == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                RecordAugmentProvider.$$$reportNull$$$0(4);
            }
            return list2;
        }
        PsiRecordComponent[] components2 = aClass.getRecordComponents();
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>(components2.length);
        List<PsiMethod> ownMethods2 = aClass.getOwnMethods();
        for (PsiRecordComponent component : components2) {
            PsiMethod recordMethod;
            if (!RecordAugmentProvider.shouldGenerateMethod(component, ownMethods2) || (recordMethod = RecordAugmentProvider.createRecordMethod(component, factory2)) == null) continue;
            LightRecordMethod method = new LightRecordMethod(aClass.getManager(), recordMethod, (PsiClass)aClass, component);
            methods2.add(method);
        }
        PsiMethod constructor2 = RecordAugmentProvider.getCanonicalConstructor(aClass, ownMethods2, header);
        if (constructor2 != null) {
            methods2.add(constructor2);
        }
        ArrayList<PsiMethod> arrayList = methods2;
        if (arrayList == null) {
            RecordAugmentProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    private static PsiMethod getCanonicalConstructor(PsiExtensibleClass aClass, List<PsiMethod> ownMethods2, @NotNull PsiRecordHeader recordHeader) {
        PsiMethod nonPhysical;
        String className2;
        if (recordHeader == null) {
            RecordAugmentProvider.$$$reportNull$$$0(6);
        }
        if ((className2 = aClass.getName()) == null) {
            return null;
        }
        for (PsiMethod method : ownMethods2) {
            if (!JavaPsiRecordUtil.isCompactConstructor(method) && !JavaPsiRecordUtil.isExplicitCanonicalConstructor(method)) continue;
            return null;
        }
        PsiElementFactory factory2 = JavaPsiFacade.getElementFactory(recordHeader.getProject());
        String sb = className2 + recordHeader.getText() + "{" + StringUtil.join(recordHeader.getRecordComponents(), c -> "this." + c.getName() + "=" + c.getName() + ";", "\n") + "}";
        try {
            nonPhysical = factory2.createMethodFromText(sb, recordHeader.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
        PsiModifierList classModifierList = aClass.getModifierList();
        AccessModifier modifier = classModifierList == null ? AccessModifier.PUBLIC : AccessModifier.fromModifierList(classModifierList);
        nonPhysical.getModifierList().setModifierProperty(modifier.toPsiModifier(), true);
        return new LightRecordCanonicalConstructor(nonPhysical, aClass);
    }

    private static boolean shouldGenerateMethod(PsiRecordComponent component, List<PsiMethod> ownMethods2) {
        String componentName = component.getName();
        if (componentName == null) {
            return false;
        }
        for (PsiMethod method : ownMethods2) {
            if (!componentName.equals(method.getName()) || !method.getParameterList().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getFieldAugments(PsiClass aClass) {
        PsiRecordComponent[] components2 = aClass.getRecordComponents();
        PsiElementFactory factory2 = JavaPsiFacade.getInstance(aClass.getProject()).getElementFactory();
        ArrayList<LightRecordField> fields2 = new ArrayList<LightRecordField>(components2.length);
        for (PsiRecordComponent component : components2) {
            PsiField recordField = RecordAugmentProvider.createRecordField(component, factory2);
            if (recordField == null) continue;
            LightRecordField field2 = new LightRecordField(aClass.getManager(), recordField, aClass, component);
            fields2.add(field2);
        }
        ArrayList<LightRecordField> arrayList = fields2;
        if (arrayList == null) {
            RecordAugmentProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Nullable
    private static PsiField createRecordField(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory2) {
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(8);
        }
        if (factory2 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(9);
        }
        String name2 = component.getName();
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        try {
            return factory2.createFieldFromText("private final " + typeText + " " + name2 + ";", component.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    private static PsiMethod createRecordMethod(@NotNull PsiRecordComponent component, @NotNull PsiElementFactory factory2) {
        String name2;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(10);
        }
        if (factory2 == null) {
            RecordAugmentProvider.$$$reportNull$$$0(11);
        }
        if ((name2 = component.getName()) == null) {
            return null;
        }
        if (RecordAugmentProvider.hasForbiddenType(component)) {
            return null;
        }
        String typeText = RecordAugmentProvider.getTypeText(component);
        if (typeText == null) {
            return null;
        }
        try {
            return factory2.createMethodFromText("public " + typeText + " " + name2 + "(){ return " + name2 + "; }", component.getContainingClass());
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static boolean hasForbiddenType(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(12);
        }
        return (typeElement = component.getTypeElement()) == null || typeElement.getText().equals("record");
    }

    @Nullable
    private static String getTypeText(@NotNull PsiRecordComponent component) {
        PsiTypeElement typeElement;
        if (component == null) {
            RecordAugmentProvider.$$$reportNull$$$0(13);
        }
        if ((typeElement = component.getTypeElement()) == null) {
            return null;
        }
        String typeText = typeElement.getText();
        if (typeText.endsWith("...")) {
            typeText = typeText.substring(0, typeText.length() - 3) + "[]";
        }
        return typeText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/impl/RecordAugmentProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHeader";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/RecordAugmentProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessorsAugments";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldAugments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalConstructor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRecordField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRecordMethod";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasForbiddenType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

