/*
 * Decompiled with CFR 0.152.
 */
package jd.core.model.classfile;

import java.util.ArrayList;
import jd.core.model.classfile.LocalVariable;

public class LocalVariables {
    private ArrayList<LocalVariable> listOfLocalVariables;
    private int indexOfFirstLocalVariable = 0;

    public LocalVariables() {
        this.listOfLocalVariables = new ArrayList(1);
    }

    public LocalVariables(LocalVariable[] localVariableTable, LocalVariable[] localVariableTypeTable) {
        int length = localVariableTable.length;
        this.listOfLocalVariables = new ArrayList(length);
        int i = 0;
        while (i < length) {
            LocalVariable localVariable = localVariableTable[i];
            if (localVariableTypeTable != null) {
                int typeLength = localVariableTypeTable.length;
                int j = 0;
                while (j < typeLength) {
                    LocalVariable typeLocalVariable = localVariableTypeTable[j];
                    if (typeLocalVariable != null && localVariable.compareTo(typeLocalVariable) == 0) {
                        localVariableTypeTable[j] = null;
                        localVariable = typeLocalVariable;
                        break;
                    }
                    ++j;
                }
            }
            this.add(localVariable);
            ++i;
        }
    }

    public void add(LocalVariable localVariable) {
        int length = this.listOfLocalVariables.size();
        int index = localVariable.index;
        int i = 0;
        while (i < length) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.index == index && lv.start_pc > localVariable.start_pc || lv.index > index) {
                this.listOfLocalVariables.add(i, localVariable);
                return;
            }
            ++i;
        }
        this.listOfLocalVariables.add(localVariable);
    }

    public LocalVariable get(int i) {
        return this.listOfLocalVariables.get(i);
    }

    public void remove(int i) {
        this.listOfLocalVariables.remove(i);
    }

    public String toString() {
        return this.listOfLocalVariables.toString();
    }

    public LocalVariable getLocalVariableAt(int i) {
        return i >= this.listOfLocalVariables.size() ? null : this.listOfLocalVariables.get(i);
    }

    public LocalVariable getLocalVariableWithIndexAndOffset(int index, int offset) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.index == index && lv.start_pc <= offset && offset < lv.start_pc + lv.length) {
                return lv;
            }
            --i;
        }
        return null;
    }

    public boolean containsLocalVariableWithNameIndex(int nameIndex) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.name_index == nameIndex) {
                return true;
            }
            --i;
        }
        return false;
    }

    public void removeLocalVariableWithIndexAndOffset(int index, int offset) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.index == index && lv.start_pc <= offset && offset < lv.start_pc + lv.length) {
                this.listOfLocalVariables.remove(i);
                break;
            }
            --i;
        }
    }

    public LocalVariable searchLocalVariableWithIndexAndOffset(int index, int offset) {
        int length = this.listOfLocalVariables.size();
        int i = length - 1;
        while (i >= 0) {
            LocalVariable lv = this.listOfLocalVariables.get(i);
            if (lv.index == index && lv.start_pc <= offset) {
                return lv;
            }
            --i;
        }
        return null;
    }

    public int size() {
        return this.listOfLocalVariables.size();
    }

    public int getIndexOfFirstLocalVariable() {
        return this.indexOfFirstLocalVariable;
    }

    public void setIndexOfFirstLocalVariable(int indexOfFirstLocalVariable) {
        this.indexOfFirstLocalVariable = indexOfFirstLocalVariable;
    }

    public int getMaxLocalVariableIndex() {
        int length = this.listOfLocalVariables.size();
        return length == 0 ? -1 : this.listOfLocalVariables.get((int)(length - 1)).index;
    }
}

