/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.EventListenerList;
import free.util.Utilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class BeanProperties {
    private final Object source;
    private final Hashtable props = new Hashtable();
    private final EventListenerList listenerList = new EventListenerList();

    public BeanProperties(Object object) {
        this.source = object;
    }

    public BeanProperties() {
        this.source = this;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.add(PropertyChangeListener.class, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerList.remove(PropertyChangeListener.class, propertyChangeListener);
    }

    private void firePropertyChanged(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this.source, string, object, object2);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$java$beans$PropertyChangeListener == null ? BeanProperties.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
            PropertyChangeListener propertyChangeListener = (PropertyChangeListener)objectArray[i + 1];
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public Enumeration getPropertyNames() {
        return this.props.keys();
    }

    public void setProperty(String string, Object object) {
        Object object2;
        Object object3 = object2 = object == null ? this.props.remove(string) : this.props.put(string, object);
        if (!Utilities.areEqual(object2, object)) {
            this.firePropertyChanged(string, object2, object);
        }
    }

    public Object getProperty(String string) {
        Object object = this.getProperty(string, null);
        if (object == null) {
            throw new NoSuchElementException(string);
        }
        return object;
    }

    public Object getProperty(String string, Object object) {
        Object v = this.props.get(string);
        return v == null ? object : v;
    }

    public void setBooleanProperty(String string, boolean bl) {
        this.setProperty(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getBooleanProperty(String string) {
        return (Boolean)this.getProperty(string);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        Boolean bl2 = (Boolean)this.getProperty(string, null);
        return bl2 == null ? bl : bl2;
    }

    public void setByteProperty(String string, byte by) {
        this.setProperty(string, new Byte(by));
    }

    public byte getByteProperty(String string) {
        return (Byte)this.getProperty(string);
    }

    public byte getByteProperty(String string, byte by) {
        Byte by2 = (Byte)this.getProperty(string, null);
        return by2 == null ? by : by2;
    }

    public void setShortProperty(String string, short s) {
        this.setProperty(string, new Short(s));
    }

    public short getShortProperty(String string) {
        return (Short)this.getProperty(string);
    }

    public short getShortProperty(String string, short s) {
        Short s2 = (Short)this.getProperty(string, null);
        return s2 == null ? s : s2;
    }

    public void setIntegerProperty(String string, int n) {
        this.setProperty(string, new Integer(n));
    }

    public int getIntegerProperty(String string) {
        return (Integer)this.getProperty(string);
    }

    public int getIntegerProperty(String string, int n) {
        Integer n2 = (Integer)this.getProperty(string, null);
        return n2 == null ? n : n2;
    }

    public void setLongProperty(String string, int n) {
        this.setProperty(string, new Long(n));
    }

    public long getLongProperty(String string) {
        return (Long)this.getProperty(string);
    }

    public long getLongProperty(String string, long l) {
        Long l2 = (Long)this.getProperty(string, null);
        return l2 == null ? l : l2;
    }

    public void setFloatProperty(String string, float f) {
        this.setProperty(string, new Float(f));
    }

    public float getFloatProperty(String string) {
        return ((Float)this.getProperty(string)).floatValue();
    }

    public float getFloatProperty(String string, float f) {
        Float f2 = (Float)this.getProperty(string, null);
        return f2 == null ? f : f2.floatValue();
    }

    public void setDoubleProperty(String string, double d) {
        this.setProperty(string, new Double(d));
    }

    public double getDoubleProperty(String string) {
        return (Double)this.getProperty(string);
    }

    public double getDoubleProperty(String string, double d) {
        Double d2 = (Double)this.getProperty(string, null);
        return d2 == null ? d : d2;
    }

    public void setCharacterProperty(String string, char c) {
        this.setProperty(string, new Character(c));
    }

    public char getCharacterProperty(String string) {
        return ((Character)this.getProperty(string)).charValue();
    }

    public char getCharacterProperty(String string, char c) {
        Character c2 = (Character)this.getProperty(string, null);
        return c2 == null ? c : c2.charValue();
    }

    public void setStringProperty(String string, String string2) {
        this.setProperty(string, string2);
    }

    public String getStringProperty(String string) {
        return (String)this.getProperty(string);
    }

    public String getStringProperty(String string, String string2) {
        String string3 = (String)this.getProperty(string, null);
        return string3 == null ? string2 : string3;
    }
}

