/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import free.util.ConcreteContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class SquareLayout
implements LayoutManager {
    public static Container createSquareContainer(Component component) {
        ConcreteContainer concreteContainer = new ConcreteContainer();
        concreteContainer.setLayout(new SquareLayout());
        concreteContainer.add(component);
        return concreteContainer;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private Component getChild(Container container) {
        int n = container.getComponentCount();
        if (n > 1) {
            throw new IllegalStateException("May not layout more than one component");
        }
        if (n == 0) {
            return null;
        }
        return container.getComponent(n - 1);
    }

    public void layoutContainer(Container container) {
        Component component = this.getChild(container);
        if (component == null) {
            return;
        }
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        int n = rectangle.width < rectangle.height ? rectangle.width : rectangle.height;
        int n2 = rectangle.width - n;
        int n3 = rectangle.height - n;
        component.setBounds(rectangle.x + (int)((float)n2 * component.getAlignmentX()), rectangle.y + (int)((float)n3 * component.getAlignmentY()), n, n);
    }

    public Dimension minimumLayoutSize(Container container) {
        Component component = this.getChild(container);
        if (component == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = component.getMinimumSize();
        Insets insets = container.getInsets();
        int n = dimension.width + insets.left + insets.right;
        int n2 = dimension.height + insets.top + insets.bottom;
        int n3 = Math.max(n, n2);
        return new Dimension(n3, n3);
    }

    public Dimension preferredLayoutSize(Container container) {
        Component component = this.getChild(container);
        if (component == null) {
            return new Dimension(0, 0);
        }
        Dimension dimension = component.getPreferredSize();
        Insets insets = container.getInsets();
        int n = dimension.width + insets.left + insets.right;
        int n2 = dimension.height + insets.top + insets.bottom;
        int n3 = Math.max(n, n2);
        return new Dimension(n3, n3);
    }
}

