/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.AbstractAction;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.ExpandableWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;

public class ExpanderWidget
extends ButtonWidget {
    private static Map<Object, Boolean> expandedCache = new WeakHashMap<Object, Boolean>();
    private ExpandableWidget expandable;

    public ExpanderWidget(Scene scene, ExpandableWidget expandable, boolean expanded) {
        super(scene, (String)null);
        this.expandable = expandable;
        this.setImage(new ExpanderImageWidget(scene, true, 8, 30));
        this.setSelectedImage((Object)new ExpanderImageWidget(scene, false, 8, 30));
        this.setSelected(expanded);
        this.setRoundedBorder(0, 4, 4, null);
        this.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExpanderWidget.this.expandable.setExpanded(!ExpanderWidget.this.expandable.isExpanded());
            }
        });
    }

    public static boolean isExpanded(ExpandableWidget expandable, boolean def) {
        Boolean val = expandedCache.get(expandable.hashKey());
        return val != null ? val : def;
    }

    @Override
    public void setSelected(boolean expanded) {
        expandedCache.put(this.expandable.hashKey(), expanded);
        super.setSelected(expanded);
        this.revalidate(true);
    }

    private static class ExpanderImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        private static final Stroke STROKE = new BasicStroke(2.5f, 2, 0);
        private double cos;

        public ExpanderImageWidget(Scene scene, boolean up, int size, int degrees) {
            super(scene, ButtonWidget.BORDER_COLOR, size, size);
            double radians = Math.PI * (double)degrees / 180.0;
            this.cos = Math.cos(radians / 2.0);
            if (!up) {
                this.cos = -this.cos;
            }
        }

        @Override
        protected Stroke getImageStroke() {
            return STROKE;
        }

        @Override
        protected Shape createImage(int width, int height) {
            GeneralPath path = new GeneralPath();
            float y1 = (float)((double)height + this.cos * (double)height / 2.0) / 2.0f;
            float y2 = (float)((double)height - this.cos * (double)height / 2.0) / 2.0f;
            path.moveTo((float)width / 2.0f, y1);
            path.lineTo(0.0f, y2);
            path.moveTo((float)width / 2.0f, y1);
            path.lineTo(width, y2);
            return path;
        }
    }
}

