/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import java.util.HashMap;
import java.util.Map;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.JavaClassHyperlinkProcessor;
import org.netbeans.modules.hibernate.hyperlink.PropertyHyperlinkProcessor;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;

public class HibernateMappingHyperlinkProvider
implements HyperlinkProvider {
    private BaseDocument lastDocument = null;
    private HyperlinkProcessor currentProcessor;
    private Map<String, HyperlinkProcessor> attribValueProcessors = new HashMap<String, HyperlinkProcessor>();

    public HibernateMappingHyperlinkProvider() {
        JavaClassHyperlinkProcessor classHyperlinkProcessor = new JavaClassHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("class", "name", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("subclass", "name", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("subclass", "extends", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("joined-subclass", "name", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("joined-subclass", "extends", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("joined-subclass", "persister", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("union-subclass", "name", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("union-subclass", "extends", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("union-subclass", "persister", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("one-to-many", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("composite-id", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("key-many-to-one", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("many-to-one", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("one-to-one", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("component", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("import", "class", classHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("many-to-many", "class", classHyperlinkProcessor);
        PropertyHyperlinkProcessor propertyHyperlinkProcessor = new PropertyHyperlinkProcessor();
        this.registerAttribValueHyperlinkPoint("property", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("id", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("set", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("composite-id", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("key-property", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("key-many-to-one", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("version", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("timestamp", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("many-to-one", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("one-to-one", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("component", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("any", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("map", "name", propertyHyperlinkProcessor);
        this.registerAttribValueHyperlinkPoint("list", "name", propertyHyperlinkProcessor);
    }

    private void registerAttribValueHyperlinkPoint(String tagName, String attribName, HyperlinkProcessor processor) {
        this.attribValueProcessors.put(this.createRegisteredName(tagName, attribName), processor);
    }

    public boolean isHyperlinkPoint(Document document, int offset) {
        if (!(document instanceof BaseDocument)) {
            return false;
        }
        BaseDocument doc = (BaseDocument)document;
        if (!(doc.getSyntaxSupport() instanceof XMLSyntaxSupport)) {
            return false;
        }
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        this.currentProcessor = env.getType().isValueHyperlink() ? this.locateHyperlinkProcessor(env.getTagName(), env.getAttribName(), this.attribValueProcessors) : null;
        return this.currentProcessor != null;
    }

    public int[] getHyperlinkSpan(Document document, int offset) {
        if (!(document instanceof BaseDocument)) {
            return null;
        }
        if (this.currentProcessor == null) {
            return null;
        }
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        return this.currentProcessor.getSpan(env);
    }

    public void performClickAction(Document document, int offset) {
        HyperlinkEnv env = new HyperlinkEnv(document, offset);
        if (this.currentProcessor != null) {
            this.currentProcessor.process(env);
        }
    }

    protected String createRegisteredName(String nodeName, String attributeName) {
        StringBuilder builder = new StringBuilder();
        if (nodeName != null && nodeName.trim().length() > 0) {
            builder.append("/nodeName=");
            builder.append(nodeName);
        } else {
            builder.append("/nodeName=");
            builder.append("*");
        }
        if (attributeName != null && attributeName.trim().length() > 0) {
            builder.append("/attribute=");
            builder.append(attributeName);
        }
        return builder.toString();
    }

    private HyperlinkProcessor locateHyperlinkProcessor(String nodeName, String attributeName, Map<String, HyperlinkProcessor> processors) {
        String key = this.createRegisteredName(nodeName, attributeName);
        if (processors.containsKey(key)) {
            return processors.get(key);
        }
        key = this.createRegisteredName("*", attributeName);
        if (processors.containsKey(key)) {
            return processors.get(key);
        }
        return null;
    }
}

