/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.reveng;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataLoader;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengDataNode;
import org.netbeans.modules.hibernate.loaders.reveng.HibernateRevengMetadata;
import org.netbeans.modules.hibernate.reveng.model.HibernateReverseEngineering;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public class HibernateRevengDataObject
extends MultiDataObject {
    private HibernateReverseEngineering revEngineering;
    private static final String VIEW_ID = "hibernate_reveng_multiview_id";
    private static final String ICON = "org/netbeans/modules/hibernate/resources/hibernate-reveng.png";

    public HibernateRevengDataObject(FileObject pf, HibernateRevengDataLoader loader) throws DataObjectExistsException, IOException {
        super(pf, (MultiFileLoader)loader);
        CookieSet cookies = this.getCookieSet();
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        cookies.add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        cookies.add((Node.Cookie)validateCookie);
        this.registerEditor("text/x-hibernate-reveng+xml", true);
    }

    public static MultiViewEditorElement createXmlMultiViewElement(Lookup lookup) {
        return new MultiViewEditorElement(lookup);
    }

    public HibernateReverseEngineering getHibernateReverseEngineering() {
        if (this.revEngineering == null) {
            try {
                this.revEngineering = HibernateRevengMetadata.getDefault().getRoot(this.getPrimaryFile());
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        assert (this.revEngineering != null);
        return this.revEngineering;
    }

    public void addReveng() {
        OutputStream out = null;
        try {
            out = this.getPrimaryFile().getOutputStream();
            this.getHibernateReverseEngineering().write(out);
        }
        catch (FileAlreadyLockedException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public void save() {
        EditorCookie edit = (EditorCookie)this.getCookie(EditorCookie.class);
        if (edit != null) {
            try {
                edit.saveDocument();
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    protected Node createNodeDelegate() {
        return new HibernateRevengDataNode(this);
    }

    protected int associateLookup() {
        return 1;
    }
}

